import { Component, OnInit, Input, ViewChild, Output, EventEmitter, forwardRef } from '@angular/core';
import { MultiSelect } from '@syncfusion/ej2-dropdowns';
import { ControlContainer, FormGroupDirective, ControlValueAccessor,NG_VALUE_ACCESSOR } from '@angular/forms';
import { Tooltip, TooltipEventArgs } from '@syncfusion/ej2-popups';
//var $ = require('jquery');
@Component({
  selector: 'sio-multiselect-reactive',
  templateUrl: './sio-multiselect-reactive.component.html',
  providers:[
    { 
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => SioMultiselectReactiveComponent),
      multi: true
    }
  ],
  viewProviders: [
    {
      provide: ControlContainer,
      useExisting: FormGroupDirective
    }
  ]
})
export class SioMultiselectReactiveComponent implements OnInit,ControlValueAccessor {

  @ViewChild('siomultiselect', {static: false})multiselect: MultiSelect;
  @Input() data:any
  @Input() placeholder:any = 'Seleccione...';
  @Input() value:any
  @Input() description:any
  @Input() formControlName: string;
  @Input() enabled: boolean;
  @Input() showDropDownIcon: boolean;
  @Output() valueChange = new EventEmitter();
  @Input() fields: Object;
  @Input() isToolTip: boolean = false;
  
  public content;
  counterValue:any;
  
  writeValue(value: any) {
  }
  propagateChange = (_: any) => {};

  registerOnChange(fn) {
    this.propagateChange = fn;
  }

  registerOnTouched() {}
  constructor() { 
    this.enabled = true;
  }

  ngOnInit() {
  }

  change(){
    this.valueChange.emit(this.multiselect);
    if(this.isToolTip){
      //$(".e-tooltip-wrap").hide();
    }
  }
  refresh(){
    this.multiselect.refresh();
  }

  /*--------------- Metodos tooltip --------------*/

  public tooltip: Tooltip;
  
  ngAfterViewInit() {
    if(this.isToolTip){
      //Initialize Tooltip component
      this.tooltip = new Tooltip({
        // default content of tooltip
        content: "Seleccione..",
        // set target element to tooltip
        target: ".customToolTip .e-list-item",
        // bind beforeRender event
        beforeRender: this.onBeforeRender
      });
      this.tooltip.appendTo("body");
    }
  }

  /**
   * beforeRender event of tooltip
   * @param args target
   */
  onBeforeRender(args: TooltipEventArgs): void {
    this.content = args.target.textContent;
  }

  onClose(e : any) {
    if(this.isToolTip){
      this.tooltip.close();
    }
  }
}