import { Component, Input, ViewEncapsulation, forwardRef, ElementRef, EventEmitter, Output } from '@angular/core';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';

@Component({
  selector: 'sio-datetime-reactive',
  templateUrl: './sio-datetime-reactive.component.html',
  styleUrls: ['./sio-datetime-reactive.component.scss'],
  encapsulation: ViewEncapsulation.None,
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => SioDatetimeReactiveComponent),
      multi: true
    }
  ]
})
export class SioDatetimeReactiveComponent implements ControlValueAccessor {

  value: any;

  private changeDate = (_: any) => { };
  private onTouched() { }
  // Attributes
  @Input() placeholder: string = 'DD/MM/AAAA HH:mm';
  @Input() format: string = 'dd/MM/yyyy HH:mm';
  @Input() isDisabled: boolean;
  @Input() isReadOnly: boolean;
  @Input() min;
  @Input() max;
  @Input() disabledDates: [];
  // Events
  @Output() onChanges = new EventEmitter();
  @Output() getDateTime = new EventEmitter<Date>();
  @Output() getString = new EventEmitter<String>();






  onChange(event) {
    this.getDateTime.emit(event);
    this.getString.emit(this.formatDateDirectriz(event));
    this.onChanges.emit(event);
  }

  // Event trigger
  get getFormat() {
    return this.format;
  }

  formatDateDirectriz(date) {
    var d = new Date(date),
      month = '' + (d.getMonth() + 1),
      day = '' + d.getDate(),
      year = d.getFullYear(),
      hour = d.getHours(),
      minute = d.getMinutes(),
      seconds = d.getSeconds();

    if (month.length < 2)
      month = '0' + month;
    if (day.length < 2)
      day = '0' + day;

    var dateString = [day, month, year].join('-');
    var hoursString = [hour, minute, seconds].join(':');
    return dateString + " " + hoursString;
  }

  registerOnChange(fn: any): void {
    this.changeDate = fn;
  }
  registerOnTouched(fn: any): void {
    this.onTouched = fn;
  }
  setDisabledState(isDisabled: boolean): void {
    this.isDisabled = isDisabled;
  }
  selectDate(item): void {
    this.value = item;
    this.changeDate(item);
    this.onChange(item);
  }
  writeValue(obj: any): void {
    this.value = obj;
  }
}
