
import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { SioDatetimeReactiveComponent} from './sio-datetime-reactive.component';
import { NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { IntlService } from '@progress/kendo-angular-intl';

describe('SioDatetimeReactiveComponent', () => {
  let component: SioDatetimeReactiveComponent;
  let fixture: ComponentFixture<SioDatetimeReactiveComponent>;

  beforeEach(async(() => {
    
    TestBed.configureTestingModule({
      declarations: [ SioDatetimeReactiveComponent ],
      schemas: [NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA],
      imports: [ ],
      providers: [
        IntlService
      ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SioDatetimeReactiveComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
  it('registerOnChange', () => {
    component.registerOnChange(null);
    expect(component).toBeTruthy();
  });
  it('registerOnTouched', () => {
    component.registerOnTouched(null);
    expect(component).toBeTruthy();
  });
  it('setDisabledState', () => {
    component.setDisabledState(true);
    expect(component).toBeTruthy();
  });
  it('selectDate', () => {
    component.selectDate(null);
    expect(component).toBeTruthy();
  });
  it('writeValue', () => {
    const obj:any = {};
    component.writeValue(obj);
    expect(component).toBeTruthy();
  });
  it('onChange', () => {
    const event:any = {};
    component.onChange(event);
    expect(component).toBeTruthy();
  });
  it('formatDateDirectriz', () => {
    component.formatDateDirectriz(new Date());
    expect(component).toBeTruthy();
  });
});
