import { Component, Input, ViewEncapsulation, forwardRef ,  ElementRef, EventEmitter, Output} from '@angular/core';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';

@Component({
  selector: 'sio-date-reactive',
  templateUrl: './sio-date-reactive.component.html',
  styleUrls: ['./sio-date-reactive.component.scss'],
  encapsulation: ViewEncapsulation.None,
  providers: [
    {
        provide: NG_VALUE_ACCESSOR,
        useExisting: forwardRef(() => SioDateReactiveComponent),
        multi: true
    }
  ]
})
export class SioDateReactiveComponent implements ControlValueAccessor {

  // Attributes
  @Input() placeholder: string = 'DD/MM/AAAA';
  @Input() bottomView: string;
  @Input() topView: string;
  @Input() activeView: string;
  @Input() format: string;
  @Input() isDisabled: boolean;
  @Input() isReadOnly: boolean;
  @Input() min;
  @Input() max;
  @Input() disabledDates: [];
  // Events
  @Input() blur;
  @Output() focus = new EventEmitter();
  @Input() open;
  @Input() close;
  @Input() change;
  @Output() onChanges = new EventEmitter();
  @Output() getDate = new EventEmitter<Date>();
  @Output() getString = new EventEmitter<String>();


  value: any;
  
  private changeDate = (_: any) => {};
  private onTouched() {}

  registerOnChange(fn: any): void {
      this.changeDate = fn;
  }
  registerOnTouched(fn: any): void {
    this.onTouched = fn;
  }
  setDisabledState(isDisabled: boolean): void {
    this.isDisabled = isDisabled;
  }
  selectDate(item): void {
    this.value = item;
    this.changeDate(item);   
    this.onChange(item);
  }
  writeValue(obj: any): void {
    this.value = obj;
  }

  onChange(event){
    this.getDate.emit(event);
    this.getString.emit(this.formatDateDirectriz(event));
    this.onChanges.emit(event);
  }

  // Event trigger

  onFocus(event) {
    this.focus.emit(event);
  }
  onBlur(event){
    //this.focus.emit(event);
  }
  onOpen(event){
    if (typeof this.open === 'function') {
      this.open = event;
    }
  }
  onClose(event){
    if (typeof this.close === 'function') {
      this.close = event;
    }
  }

  get getFormat() {
    return this.format;
  }

  get getBottomView() {
    return (this.bottomView) ? this.bottomView : '';
  }

  get getActiveView() {
    return (this.activeView) ? this.activeView : 'month';
  }

  get getTopView() {
    return (this.topView) ? this.topView : '';
  }

  formatDateDirectriz(date) {
    var d = new Date(date),
        month = '' + (d.getMonth() + 1),
        day = '' + d.getDate(),
        year = d.getFullYear();

    if (month.length < 2) 
        month = '0' + month;
    if (day.length < 2) 
        day = '0' + day;

    return [day, month, year].join('-');
  }
}
