import { Component, OnInit, Input, ViewChild, Output, EventEmitter, forwardRef} from '@angular/core';
import { ComboBox } from '@syncfusion/ej2-angular-dropdowns';

@Component({
  selector: 'sio-combobox',
  templateUrl: './sio-combobox.component.html',
  styleUrls: ['./sio-combobox.component.scss'],
})

export class SioComboboxComponent implements OnInit   {  
  @Input() data: Array<any>;
  @Input() placeholder: any;
  @Input() enabled: boolean;
  @Input() value: any;
  @Input() description: any;
  @Input() defaultValue: any;
  @Input() formControlName: string;
  @Output() valueChange = new EventEmitter();

  @ViewChild('siocombobox', {static: false}) combobox: ComboBox;
  writeValue(value: any) {
  }
  propagateChange = (_: any) => {};

  registerOnChange(fn) {
    this.propagateChange = fn;
  }

  registerOnTouched() {}

  fields: Object;
  constructor() {
    this.enabled = true;
  }

  change(){
    this.valueChange.emit(this.combobox);
  }
  
  setvalue(newValue){
    this.combobox.value = newValue;
  }
  
  setDisabled(disabled: boolean){
    this.combobox.enabled = !disabled;
  }
  
  ngOnChanges() {
    if(this.defaultValue != null && this.data != null){
      let c = this.data.findIndex(x => x.id === this.defaultValue);
      this.combobox.index = c;
    }
  }
  ngOnInit() {
    this.fields = {value: this.value, text: this.description};
  }

}