import { Component, OnInit, Input, ViewChild, Output, EventEmitter, forwardRef} from '@angular/core';
import { ComboBox } from '@syncfusion/ej2-dropdowns';
import { ControlContainer, FormGroupDirective, ControlValueAccessor,NG_VALUE_ACCESSOR } from '@angular/forms';

@Component({
  selector: 'sio-combobox-reactive',
  templateUrl: './sio-combobox-reactive.component.html',
  providers:[
    { 
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => SioComboboxReactiveComponent),
      multi: true
    }
  ],
  viewProviders: [
    {
      provide: ControlContainer,
      useExisting: FormGroupDirective
    }
  ]
})
export class SioComboboxReactiveComponent implements OnInit, ControlValueAccessor   {
  @Input() data: Array<any>;
  @Input() enabled = true;
  @Input() allowFiltering = true;
  @Input() value: any;
  @Input() description: any;
  @Input() defaultValue: any;
  @Input() formControlName: string;
  @Input() placeholder = 'Seleccione..';
  @Input() showClearButton = true;
  @Output() valueChange = new EventEmitter();
  @Output() click = new EventEmitter();

  @ViewChild('siocomboboxreactive', { static: false }) siocombobox: ComboBox;

  public fields: Object;

  constructor() {}

  /**
   * Hook OnInit
   */
  ngOnInit() {
    this.fields = { value: this.value, text: this.description };
  }

  /**
   * Hook OnChange
   */
  ngOnChanges() {
    if (this.defaultValue != null && this.data != null) {
      let c = this.data.findIndex(x => x.id === this.defaultValue);
      if (c !== -1) {
        if (this.siocombobox) {
          this.siocombobox.index = c;
        }
      }
    }
  }

  /**
   * Public Method that is executed on touched event
   */
  registerOnTouched() { }
  
  /**
   * Public Method that is executed on change event
   */
  registerOnChange(fn) {
    this.propagateChange = fn;
  }

  /**
   * Public Method that propagate event change
   * @param _ 
   */
  propagateChange = (_: any) => { };

  /**
   * Public Method that write value of component
   * @param value 
   */
  writeValue(value: any) {
    this.value=value;
  }

  /**
   * Public Method that is fired by componente change event
   * @param event 
   */
  onChange(event) {
    this.valueChange.emit(event);
  }

  /** 
   * Public Method that is fired by componente click event
   * @param event
   */
  onClick(event) {
    this.click.emit(event);
  }

  /**
   * Public Method that is fired by componente change event
   * @param event
   */
  change(event){
    this.valueChange.emit(event);
  }

  /**
   * Public Method that set new value to component
   * @param event
   */
  setvalue(newValue){
    this.siocombobox.value = newValue;
  }
}