import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { SioComboboxReactiveComponent } from './sio-combobox-reactive.component';
import { ComboBoxModule } from '@syncfusion/ej2-angular-dropdowns'
import { NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';

describe('SioComboboxReactiveComponent', () => {
  let component: SioComboboxReactiveComponent;
  let fixture: ComponentFixture<SioComboboxReactiveComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [SioComboboxReactiveComponent ],
      imports: [ComboBoxModule],
      schemas: [NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA],
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SioComboboxReactiveComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();    
  });

  it('onChange', () => {
    const event: any = {};
    spyOn(component.valueChange, 'emit');
    component.onChange(event);
    expect(component.valueChange.emit).toHaveBeenCalled();
    expect(component).toBeTruthy();
  });

  it('registerOnChange', () => {
    component.registerOnChange(null);
    expect(component).toBeTruthy();    
  });

  it('registerOnTouched', () => {
    component.registerOnTouched();
    expect(component).toBeTruthy();
  });

  it('propagateChange', () => {
    component.propagateChange('');
    expect(component).toBeTruthy();
  });

  it('writeValue', () => {
    component.writeValue('test');
    expect(component.value == 'test').toBeTruthy();
  });

  it('ngOnChanges', () => {
    component.data = [
      {
        id: 1
      }
    ];
    component.defaultValue = 1;
    component.ngOnChanges();
    expect(component).toBeTruthy();    
  });

  it('onClick', () => {
    component.onClick('');
    expect(component).toBeTruthy();
  });

  it('change', () => {
    component.change('');
    expect(component).toBeTruthy();    
  });

  it('setvalue', () => {
    component.setvalue(null);
    expect(component).toBeTruthy();    
  });
});
