import { Directive, ElementRef, HostListener, Renderer2, OnChanges, Input, SimpleChanges } from '@angular/core';
import { NgControl } from '@angular/forms';

@Directive({
  selector: '[controlRequired]'
})
export class ControlRequiredDirective implements OnChanges{

    @Input() formInvalid: any;
    @Input('controlRequired') idLabel: string;
    @Input('controlRequired-error') verError: boolean;

  
    constructor(private el: ElementRef,
                private renderer: Renderer2,
                private control: NgControl) {}
  
  
    ngOnChanges(changes: SimpleChanges): void {
      this.onChange();
    }

    @HostListener('blur', ['$event'])
    onFocus() {
      this.onChange();
    }

    @HostListener('ngModelChange', ['$event'])
    onChange() {
      
      let campo = <HTMLLabelElement>document.getElementById(this.idLabel);
      
      if(campo !== null){
        if(this.verError){
          campo.classList.add('sio-error-label');
        }else{
          if (this.control.invalid && this.verError) {
            campo.classList.add('sio-error-label');
          } 
          else{
            campo.classList.remove('sio-error-label');
          }
          if(this.control.control.errors === null){
            campo.classList.remove('sio-error-label');
          }
        }
      }

    }
  }