import { ControlRequiredDirective } from './control-required.directive';

describe('ControlRequiredDirective', () => {
  it('should create an instance', () => {
    const directive = new ControlRequiredDirective(null, null, null);
    expect(directive).toBeTruthy();
  });

  it('ngOnChanges', () => {
    const directive = new ControlRequiredDirective(null, null, null);
    directive.ngOnChanges(null);
    expect(directive).toBeTruthy();
  });

  it('onFocus', () => {
    const directive = new ControlRequiredDirective(null, null, null);
    directive.onFocus();
    expect(directive).toBeTruthy();
  });

  it('onChange verError manual', () => {
    var dummyElement = document.createElement('div');
    document.getElementById = jasmine.createSpy('HTML Element').and.returnValue(dummyElement);
    const directive = new ControlRequiredDirective(null, null, null);
    directive.verError = true;
    directive.onChange();
    expect(directive).toBeTruthy();
  });

  it('onChange verError touched', () => {
    var dummyElement = document.createElement('div');
    document.getElementById = jasmine.createSpy('HTML Element').and.returnValue(dummyElement);
    const directive = new ControlRequiredDirective(null, null, null);
    directive.verError = false;
    (<any>directive['control']) = {invalid: true, touched: true, control:{errors: 'hay errores'}};

    directive.onChange();
    expect(directive).toBeTruthy();
  });

  it('onChange verError errors', () => {
    var dummyElement = document.createElement('div');
    document.getElementById = jasmine.createSpy('HTML Element').and.returnValue(dummyElement);
    const directive = new ControlRequiredDirective(null, null, null);
    directive.verError = false;
    (<any>directive['control']) = {invalid: false, touched: false, control:{errors: null}};

    directive.onChange();
    expect(directive).toBeTruthy();
  });

});
