import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { DialogComponent } from '@syncfusion/ej2-angular-popups';

@Component({
  selector: 'sio-attachments',
  templateUrl: './sio-attachments.component.html',
  styleUrls: ['./sio-attachments.component.scss']
})
export class SioAttachmentsComponent implements OnInit {

  @Input() public filesLoaded: any;
  @Input() public responseFilter; 
  
  @ViewChild('modalDocs', { static: false })
  public modalDocs: DialogComponent;

  public widthModalCopyConsigment = '35%';
  public animationSettingsCopyConsigments = { effect: 'None' };
  public showCloseIconCopyConsigment = true;
  public position: object = { X: 'center', Y: 'top' };
  public isModalCopyConsigment: boolean = true;
  public titleModalCopyConsigment = '';

  constructor() { }

  ngOnInit() {
  }

  public showModaAttachments() {
    this.modalDocs.width = '710px';

    const selectedConsignment = { ...this.responseFilter[0] };
    const files: any = selectedConsignment.filesConsignments;

    files.map(p => p.name = this.getFileNameDocumet(p.name, p.type));
    this.titleModalCopyConsigment = 'Descargar documentos consignación ' + selectedConsignment.consecutive;
    this.filesLoaded = files;
    this.modalDocs.show();
  }
  
  
  public hideModalDocs() {
    this.filesLoaded = [];
    this.modalDocs.hide();
  }
  private getFileNameDocumet(docName, extension) {
    if ((docName + extension).length > 74) {
      return docName.slice(0, 67) + '..' + extension;
    }
    return docName + extension;
  }
}
