import { Component, OnInit, AfterContentInit } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';

//traduce al español los componentes de syncfusion
import { L10n, setCulture } from '@syncfusion/ej2-base';
import locale_ES from '../../../../assets/l10n/es';

import 'bootstrap';

setCulture('es');
L10n.load(locale_ES);

@Component({
  selector: 'index-consignment',
  templateUrl: './index.component.html',
  styleUrls: ['./index.component.scss']
})

export class IndexConsignmentComponent implements OnInit, AfterContentInit {
  
  public formFilter: FormGroup;

  public defaultPlaceholder = 'Seleccione..';

  // selecciona los datos del checked por defecto
  public checkedRadio: any = {
    fechas: true,
    semanas: false
  };
  // parametros genericos de prueba
  public listGeneric: Array<any> = [];
  public fieldsGeneric: Object = { value: 'id', text: 'name' };

  public listTestTypes: Array<any> = [];
  public testTypesFields: Object = { value: 'id', text: 'name', toolTip: 'name' };

  public fechaFiltroDisabled = false;
  public semanaFiltroDisabled = true;

  contentFilterDates: HTMLElement;
  contentFilterCodes: HTMLElement;
  contentAdvFilterDates: HTMLElement;

  testTypes: any;

  constructor(private formBuider: FormBuilder) {
  }

  ngOnInit() {
    this.createFormFilter();
    this.initializeCombos();
    this.advancedOptions();
  }

  createFormFilter() {
    this.formFilter = this.formBuider.group({
      operativeAgent: [[], []],
      actualStatus: [[], []],
      entryType: [[], []],
      maintenanceOrigin: [[], []],
      penaltyType: [[], []],
      color: [[], []],
      consecutive: [''],
      area: [[], []],
      subarea: [[], []],
      substation: [[], []],
      elementType: [[], []],
      element: [[], []],
      scheduledStartDate: [],
      scheduledEndDate: [],
      startWeek: ['', []],
      endWeek: ['', []],
      carga: ['', []],
      anioInicial: [new Date(), []],
      anioFinal: [new Date(), []],
      valueIntervention: [null, []],
      isGenerationTest: [null, []],
      testTypes: [[], []],
      codigoConsignacionActivo: [false, []],
      filterDates: ['fechas', []],
      filterFechas: ['fechas', []]
    });
  }

  ngAfterContentInit(): void {
    this.contentFilterDates = document.querySelector('.div-filtros-fechas');
    this.contentFilterCodes = document.querySelector(".div-codigo-consignacion");
    this.contentAdvFilterDates = document.querySelector(".div-filtros-av-fechas");
    //se elimina un residuo css al agregar tooltip a combobox
   // $('body').removeClass("e-control e-tooltip");
  }

  ngOnDestroy(): void {
  }

  /**
   * Realiza la peticion con los datos filtrados
   * @param formValue 
   */
  filterConsignment(formValue: any): void {
    console.log("formValue", formValue);
    this.testTypes = formValue.testTypes;
  }

  public consultar(isClearAll) {
    setTimeout(() => {
      this.filterConsignment(this.formFilter.getRawValue());
    }, 500);
  }

  initializeCombos() {
    this.getListTestType();
  }

  public advancedOptions() {
    // Verifica estado actual de items
    const advancedSearch = document.querySelector(".advanced-search");
    if (advancedSearch.classList.contains("close-advanced")) {
      // Agrega propiedad de cerrar y comportamiento
      advancedSearch.classList.remove("close-advanced");
    }
    else {
      // Agerga propuedad de abrir y comportamiento
      advancedSearch.classList.add("close-advanced");
    }
  }

  public focusCodigoConsignacion(event) {
    this.setFocusFilterConsecutive();
    this.focusInInput(event);
  }

  //FocusOut Event function for input component
  public focusOutInput(target: HTMLElement): void {
    target.parentElement.classList.remove('e-input-focus');
  }

  //Focus Event function for input component
  public focusInInput(target: HTMLElement): void {
    target.parentElement.classList.add('e-input-focus');
  }

  public setFocusFilterConsecutive() {
    this.setStateContainer(this.contentFilterCodes, true, true);
    this.setStateContainer(this.contentFilterDates, false);
    this.setStateContainer(this.contentAdvFilterDates, false);
  }

  public setFocusFilterDates() {
    this.setStateContainer(this.contentFilterCodes, false);
    this.setStateContainer(this.contentFilterDates, true, true);
    this.setStateContainer(this.contentAdvFilterDates, true);
  }

  public setFocusAdvFilterConsecutive() {
    this.setStateContainer(this.contentFilterCodes, false);
    this.setStateContainer(this.contentFilterDates, true);
    this.setStateContainer(this.contentAdvFilterDates, true, true);
  }

  /**
   * Public method that disable/enable div and formControl
   */
  public setStateContainer(element: Element, stateEnable: boolean, setBg: boolean = false) {
    // Add or remove class disabled-content
    if (stateEnable) {
      element.classList.remove('disabled-content');
    }
    else {
      element.classList.add('disabled-content');
    }

    if (setBg) {
      element.classList.add("bg-sio-white-silver");
    } else {
      element.classList.remove("bg-sio-white-silver");
    }
  }

  getListTestType() {
    this.listTestTypes = [
      {
        "id": 1,
        "code": 1,
        "name": "Text Ok"
      },
      {
        "id": 18,
        "code": 18,
        "name": "Text Fail. Protecciones asociadas al Sistema de Transmisión Nacional y esquemas especiales o suplementarios."
      },
     
      {
        "id": 24,
        "code": 24,
        "name": "Text Fail. Ajuste y verificacion del control de potencia reactiva o tension en el punto de conexion compartida"
      },
    ];
  }

}
