import { Component, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { SidebarComponent, TreeViewComponent, NodeSelectEventArgs } from '@syncfusion/ej2-angular-navigations';
import { assetUrl } from 'src/single-spa/asset-url';
import { Subscription } from 'rxjs';
@Component({
    selector: 'app-sidebar',
    templateUrl: './sidebar.component.html',
    styleUrls: ['./sidebar.component.scss']
})
export class SidebarSioComponent {
    @ViewChild('sidebar', { static: false })
    sidebar: SidebarComponent;
    @ViewChild('tree', { static: false })
    public tree: TreeViewComponent;
    public showBackdrop: boolean = true;
    public type: string = 'Push';
    public width: string = '290px';
    public closeOnDocumentClick: boolean = true;
    public mediaQuery: string = ('(min-width: 600px)');
    public createSidebar = false;
    public urlItemSelected = '';
    public routeObservable: Subscription;
    public path: string;
    public urlItem = {
        consulta: '',
        ingreso: '',
        admon: '',
        reporte: '',
        xm: '',
        home: '',
        sio: ''
    };
    public data: any[] = [];
    public field:Object = {};

    constructor( private router: Router) {}

    ngOnInit() {
        this.urlItem.xm = assetUrl('img/iconos/img_logo_xm.svg');
        this.setSidebarItem();
        this.setRouterEvent();
    }  

    // Sidebar's OnCreate event
    public onCreate() {
        // Hide the sidebar element on creation using isOpen property 
        this.sidebar.isOpen = false;
        this.sidebar.dataBind();  
        this.createSidebar = true;      
    }

    // Sidebar's Toggle event
    public toggleClick(): void {
        if (this.sidebar.isOpen) this.sidebar.hide();
        else this.sidebar.show();
    }

    // Sidebar's Click event
    public closeClick(): void {
        this.sidebar.hide();
    }

    // Treeview's OnCreate event
    public onCreateTree(){
        // Triggers on mouse hover/keydown event
        ['mouseover','keydown'].forEach( evt => this.tree.element.addEventListener(evt, (event)=>{this.setHeight(event.target); }));        
        this.tree.selectedNodes = [];
        this.data.forEach((item)=>{
            var node = this.tree.getNode(item.id);
            this.setHeight(node);
        });
        this.setItemSelected(this.router.url);
    }

     // Treeview's OnSelected event
    public onSelectTree(args: any): void {
    if (args.node != undefined) this.setHeight(args.node);
      this.loadRoutingContent(args);      
    }

    // Treeview Sets e-fullrow to be the same as e-text-content
    public setHeight(element) {
        if(this.tree.fullRowSelect && 
            element != undefined &&
            element != null &&
            element.classList != undefined &&
            element.classList != null) {
            if(element.classList.contains("e-treeview")) {
                element = element.querySelector(".e-node-focus").querySelector(".e-fullrow");
            }
            else if(element.classList.contains("e-list-parent")) {
                element = element.querySelector(".e-fullrow");
            }
            else if(element.classList.value != ("e-fullrow") && element.closest(".e-list-item")) {
                element = element.closest(".e-list-item").querySelector(".e-fullrow");
            }
            if(element.nextElementSibling)
                element.style.height = element.nextElementSibling.offsetHeight +"px";
        }   
    }
    
    // Add router link to Treeview's items
    public loadRoutingContent(args: NodeSelectEventArgs): void {
        let data:any = this.tree.getTreeData(args.node);
        if (data[0]!=undefined &&  
            data[0].path != undefined &&
            this.router.url != data[0].path) {
            let routerLink: string = data[0].path;
            this.router.navigate([routerLink]);
            this.sidebar.hide();
        }   
    }
    
    public setSidebarItem(){
        this.data = [];
        this.data = this.hasPermission(this.data);
        this.field = {dataSource: this.data, id: 'id', parentID: 'pid', text: 'name', hasChildren: 'hasChild' };        
    }

    public setItemSelected(url){   
        if (this.tree != undefined) {
            var node = this.getIdItemByUrl(this.data, url);    
            if (node.pid != undefined) this.tree.expandAll(node.pid);            
            this.setHeight(node.el);
            this.tree.selectedNodes = [node.id];
            this.urlItemSelected = url; 
        }
    }
    
    private getIdItemByUrl(data, url):any{
        var node = {
            id: "",
            pid: "",
            el: null
        };
        data.forEach(element => {
            if (element.path == url) {           
                node.id = element.id;
                node.pid = element.pid;
                node.el = element;
            }
        });
        return node;
    }

    hasPermission(items): any[] {
        return items;
    }

    setRouterEvent(): void {
    }

    logout() {
    }
}
