import { Component, OnInit, EventEmitter, Output } from '@angular/core';
import { assetUrl } from 'src/single-spa/asset-url';

@Component({
  selector: 'app-navbar',
  templateUrl: './navbar.component.html',
  styleUrls: ['./navbar.component.scss']
})
export class NavbarComponent implements OnInit {

  @Output() toggleClick = new EventEmitter();
  public urlItem = {
    consulta: '',
    ingreso: '',
    admon: '',
    reporte: '',
    xm: '',
    home: '',
    sio: ''
  };
  public user : any;

  constructor() { }

  ngOnInit() {
    this.urlItem.sio = assetUrl('img/iconos/img_logo_sio.svg');
    this.getUser();
  }

  getUser() {
    this.user = {
      company: 'UNSC Infinity',
      name: 'User 117'
    };
  }

  onToggleClick() {
    this.toggleClick.emit(event);
  }
  onDockMenu() {
    const navbarDock = document.querySelector('.navbar-projects') as Element;
    if (navbarDock.classList.contains('active')) {
      navbarDock.classList.remove('active');
      navbarDock.classList.add('hidden');
      navbarDock.classList.remove('open-sidebar');
    } else {
      navbarDock.classList.add('active');
      navbarDock.classList.remove('hidden');
      navbarDock.classList.add('open-sidebar');
    }
  }
}
