import { Component, OnInit, HostListener, ElementRef } from '@angular/core';
import { assetUrl } from 'src/single-spa/asset-url';

@Component({
  selector: 'app-dock',
  templateUrl: './dock.component.html',
  styleUrls: ['./dock.component.scss']
})
export class DockComponent implements OnInit {
  public urlItem = {
    maniobras: ''
  };

  constructor(private eRef: ElementRef) { }

  ngOnInit() {
    this.urlItem.maniobras = assetUrl('img/iconos/ico_maniobras.svg');
  }

  @HostListener('document:click', ['$event'])
  clickout(event) {
    if(!this.eRef.nativeElement.contains(event.target)) {
      const navbarDock = document.querySelector(".navbar-projects") as Element;
      if(navbarDock.classList.contains("active") && !navbarDock.classList.contains("open-sidebar")){
        navbarDock.classList.remove("active");
        navbarDock.classList.add("hidden");
      }
      else if(navbarDock.classList.contains("open-sidebar")) {
        navbarDock.classList.remove("open-sidebar");
      }
    }
  }

}