import { NgModule, NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA, APP_INITIALIZER } from '@angular/core';
import { CommonModule } from '@angular/common';
import { SharedModuleModule} from '../shared/shared.module';
import { RouterModule} from '@angular/router';
import { SidebarModule, TreeViewModule } from '@syncfusion/ej2-angular-navigations';
import { MenuModule } from '@syncfusion/ej2-angular-navigations';

import { TemplateComponent } from './template/template.component';
import { LoadingScreenComponent } from './template/loading-screen/loading-screen.component';
import { NavbarComponent } from './template/navbar/navbar.component';
import { ClockComponent } from './template/clock/clock.component';
import { AppRoutingModule } from '../app-routing.module';
import { SidebarSioComponent } from './template/sidebar/sidebar.component';
import { DockComponent } from './template/dock/dock.component';
@NgModule({
  declarations: [
    TemplateComponent, 
    LoadingScreenComponent,
    NavbarComponent,
    ClockComponent,
    SidebarSioComponent,
    DockComponent
  ],
  imports: [
    CommonModule,
    SharedModuleModule,
    SidebarModule,
    RouterModule,
    AppRoutingModule,
    TreeViewModule,
    MenuModule
  ],
  exports:[
    TemplateComponent
  ],
  schemas: [NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA]
})
export class CoreModule { }
