import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { LOCALE_ID } from '@angular/core';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { FormsModule, ReactiveFormsModule} from '@angular/forms';
import { DatePipe, APP_BASE_HREF, registerLocaleData  } from '@angular/common';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';

import { HttpClient, HttpClientModule, HTTP_INTERCEPTORS} from '@angular/common/http';
import localeEsCo from '@angular/common/locales/es-CO';

// registrar los locales con el nombre que quieras utilizar a la hora de proveer
registerLocaleData(localeEsCo, 'es');

import { MultiSelectAllModule } from '@syncfusion/ej2-angular-dropdowns';  
//External Modules
import { GridModule,GridAllModule } from '@syncfusion/ej2-angular-grids';
import { PageService, SortService, FilterService, GroupService ,ToolbarService, ExcelExportService} from '@syncfusion/ej2-angular-grids';
import { AccordionModule } from '@syncfusion/ej2-angular-navigations';
import { TimePickerModule } from '@syncfusion/ej2-angular-calendars';
import { DateTimePickerModule } from '@syncfusion/ej2-angular-calendars';
import { SwitchComponent,SwitchModule} from '@syncfusion/ej2-angular-buttons';
import { DialogModule } from '@syncfusion/ej2-angular-popups';
import { RadioButtonModule } from '@syncfusion/ej2-angular-buttons';
import { GanttModule } from '@syncfusion/ej2-angular-gantt';
import { ResizeService, SelectionService, ReorderService, EditService, DayMarkersService, ContextMenuService} from '@syncfusion/ej2-angular-gantt';
import { ToolbarService as toolbarServiceGantt} from '@syncfusion/ej2-angular-gantt';
import { TabModule } from '@syncfusion/ej2-angular-navigations';

//Translation
import { TranslateLoader, TranslateModule } from '@ngx-translate/core';
import { TranslateHttpLoader } from '@ngx-translate/http-loader';

/*********** Services ************/

/******** Components *************/
import { NgbDatepickerModule } from '@ng-bootstrap/ng-bootstrap';
//import { ClockComponent } from './components/clock/clock.component';


/******** Components syncfusion *************/
import { AutoCompleteModule } from '@syncfusion/ej2-angular-dropdowns';

import { ComboBoxModule, MultiSelectModule, DropDownListModule } from '@syncfusion/ej2-angular-dropdowns';
import { TextBoxModule, NumericTextBoxModule } from '@syncfusion/ej2-angular-inputs';
import { DatePickerModule } from '@syncfusion/ej2-angular-calendars';
import { TooltipModule } from '@syncfusion/ej2-angular-popups';


/******** Events *************/

/******** Pipes *************/
  
/******** modules *************/
import { CheckBoxModule } from '@syncfusion/ej2-angular-buttons';
import { DlDateTimeDateModule, DlDateTimePickerModule, DlDateTimeInputModule } from 'angular-bootstrap-datetimepicker';

import { PdfViewerComponent } from '@syncfusion/ej2-angular-pdfviewer';
import { EJ_REPORTVIEWER_COMPONENTS } from '@syncfusion/reporting-angular/src/ej/reportviewer.component';

import { AdminMainComponent } from './shared/admin-main/admin-main.component';
import { SharedModuleModule } from './shared/shared.module';
import { CoreModule } from './core/core.module';
import { ConsignmentsModule } from './modules/consignments/consignments.module';

import { ToolbarModule, ContextMenuModule} from '@syncfusion/ej2-angular-navigations';
import { DropDownButtonModule } from '@syncfusion/ej2-angular-splitbuttons';

import { environment } from '@environments/environment';

import { NgxIndexedDBModule, DBConfig } from 'ngx-indexed-db';

@NgModule({
  declarations: [
    AppComponent,
    // pipes
    // modules
    PdfViewerComponent,
    EJ_REPORTVIEWER_COMPONENTS,
    AdminMainComponent,
  ],
  imports: [
    MultiSelectAllModule,
    BrowserAnimationsModule,
    BrowserModule,
    ReactiveFormsModule,
    FormsModule,
    ReactiveFormsModule,
    AutoCompleteModule,
    AppRoutingModule,
    HttpClientModule,
    SwitchModule,
    ComboBoxModule,
    MultiSelectModule,
    DropDownListModule ,
    NumericTextBoxModule,
    TextBoxModule,
    CheckBoxModule,
    RadioButtonModule,
    NgxIndexedDBModule.forRoot(environment.dbConfig),

    TranslateModule.forRoot({
      loader: {
        provide: TranslateLoader,
        useFactory: (http: HttpClient) => {
          return new TranslateHttpLoader(http);
        },
        deps: [ HttpClient ]
      }
    }),
    GridModule,
    GridAllModule,
    AccordionModule,
    SwitchModule,
    DateTimePickerModule,
    NgbDatepickerModule,
    DatePickerModule,
    TooltipModule,
    DlDateTimePickerModule,
    DlDateTimeDateModule,
    DlDateTimeInputModule,
    DialogModule,
    TimePickerModule,
    GanttModule,
    TabModule,
    SharedModuleModule,
    CoreModule,
    ConsignmentsModule,
    ToolbarModule, 
    ContextMenuModule,
    DropDownButtonModule
  ],
  exports:[
    SwitchComponent,
  ],
  providers: [
    PageService,
    SortService,
    FilterService,
    GroupService,
    ToolbarService, 
    ExcelExportService,
    DatePipe,
    ResizeService, 
    SelectionService, 
    ReorderService,
    EditService, 
    DayMarkersService, 
    ToolbarService,
    ContextMenuService,
    toolbarServiceGantt,
    { provide: APP_BASE_HREF, useValue: '/mantenimiento' },
    { provide: LOCALE_ID, useValue: 'es-CO' }
  ],
  bootstrap: [AppComponent],
})
export class AppModule {}
