import { NgModule} from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { APP_BASE_HREF } from '@angular/common';
import { IndexConsignmentComponent } from '@modules/consignments/index/index.component';
import { SioConsignmentModulesRoutes } from '@shared/const/modules.const';

const routes: Routes = [
  {path: '' , redirectTo: 'inicio', pathMatch: 'full'},
  {path: 'inicio' , component: IndexConsignmentComponent},
  {
    path: SioConsignmentModulesRoutes.index,
    component: IndexConsignmentComponent
  },
  {path: '**', redirectTo: 'index-consignment'}
];

@NgModule({
  imports: [RouterModule.forRoot(routes,{useHash:false})],
  exports: [RouterModule],
  providers: [
    { provide: APP_BASE_HREF, useValue: '/index-consignment' },
  ],
})
export class AppRoutingModule { }
