﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Threading.Tasks;
using APIService.Data;
using Microsoft.AspNetCore.Components;
using Syncfusion.Blazor;
using Syncfusion.Blazor.Data;
using Syncfusion.Blazor.Grids;

namespace APIService.Pages
{
    public partial class Index
    {
        [Inject]
        public HttpClient httpclient { get; set; }

        [Inject]
        public OrderService OrderData { get; set; }

        public SfGrid<Orders> DataGrid;

        protected override async Task OnInitializedAsync()
        {
            await base.OnInitializedAsync();
        }

        protected override void OnInitialized()
        {
            base.OnInitialized();
            var a = DataGrid.DataManager.Adaptor;
        }
    }

    public class CustomAdaptor : DataAdaptor
    {
        [Inject]
        public static HttpClient httpclient { get; set; } = new HttpClient();
        public OrderService OrderData { get; set; }

        // Performs data Read operation
        public override async Task<object> ReadAsync(DataManagerRequest dataManagerRequest, string key = null)
        {
            await Task.Delay(10000);
            if (ScopedServices != null)
            {
                OrderData = ScopedServices.GetService(typeof(OrderService)) as OrderService;
                var data = await OrderData.GetPeople();
                return new DataResult { Result = data, Count = dataManagerRequest.Take };
            }
            return new DataResult();
        }
    }
}
