﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace APIService.Data
{
    public class OrderService
    {
        private readonly HttpClient _httpClient;
        public OrderService(HttpClient httpClient)
        {
            _httpClient = httpClient;

        }
        string baseUrl = "https://localhost:44314/";
        public async Task<List<Orders>> GetPeople()
        {

            var json = await _httpClient.GetStringAsync($"{baseUrl}api/Default");
            return JsonConvert.DeserializeObject<List<Orders>>(json);

        }
        public async Task<HttpResponseMessage> InsertOrderAsync(Orders value)
        {           
            return await _httpClient.PostAsync($"{baseUrl}api/Default", getStringContentFromObject(value));
        }
        public async Task<HttpResponseMessage> UpdateOrderAsync(string id, Orders value)
        {           
            return await _httpClient.PutAsync($"{baseUrl}api/Default/{id}", getStringContentFromObject(value));
        }

        public async Task<HttpResponseMessage> DeleteOrderAsync(string id)
        {           
            return await _httpClient.DeleteAsync($"{baseUrl}api/Default/{id}");
        }
        private StringContent getStringContentFromObject(object obj)
        {
            var serialized = JsonConvert.SerializeObject(obj);
            var stringContent = new StringContent(serialized, Encoding.UTF8, "application/json");
            return stringContent;
        }      

    }

}
