﻿using ImageProcessor;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Exporting;
using Syncfusion.Pdf.Graphics;
using Syncfusion.Pdf.Parsing;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    class Program
    {
        static void Main(string[] args)
        {
            using (PdfLoadedDocument pdfDocument = new PdfLoadedDocument("Sample.pdf"))
            {
                // Without this it works!
                pdfDocument.Conformance = PdfConformanceLevel.Pdf_A1B; 

                //// Commented out the image manipulation for simplicity
                //// Because Pdf/A-1b doesn't support transparency, replace the transparent background with a white background for all images in the PDF document
                //// Without the transparent background the image has a black background after conversion :(
                //using (ImageFactory imageFactory = new ImageFactory(preserveExifData: true))
                //{
                //    foreach (PdfPageBase pdfPage in pdfDocument.Pages)
                //    {
                //        foreach (PdfImageInfo imageInfo in pdfPage.ImagesInfo)
                //        {
                //            using (MemoryStream inputImageStream = new MemoryStream())
                //            {
                //                // Syncfusion 18.4.0.34: The call of "RepplaceImage" doesn't return and doesn't throw an exception. This happens not to all images but for the second and third in this example
                //                // Syncfusion 18.4.0.44: Seems to work, the method returns
                //                imageInfo.Image.Save(inputImageStream, imageInfo.Image.RawFormat);
                //                inputImageStream.Position = 0;
                //                pdfPage.ReplaceImage(imageInfo.Index,
                //                                     new PdfBitmap(imageFactory.Load(inputImageStream)
                //                                                               .BackgroundColor(Color.White)
                //                                                               .Image));
                //            }
                //        }
                //    }
                //}
                
                // The second and third images are destroyed somehow (2x2 Pixel, one color) in the resulting PDF.
                // If saving the extracted images to file they still look good and without setting the conformance level to PDF/A it works.
                pdfDocument.Save("Sample_New.pdf");
                pdfDocument.Close(true);
            }

            Process.Start("Sample_New.pdf");
        }
    }
}
