﻿using System.IO;
using Syncfusion.XlsIO;

namespace DocGenRepro {
    class Program {
        private const string FileExt = "xlsx";
        private const string FileName = "Book2";
        private const string sheet = "Sheet1";

        static void Main(string[] args) {
            var dir = Directory.GetParent(Directory.GetCurrentDirectory()).Parent?.FullName;
            var filePath = $"{dir}\\{FileName}";
            var engine = new ExcelEngine();
            var excelApp = engine.Excel;

            using (var inFile = new FileStream($"{filePath}.{FileExt}", FileMode.Open)) {
                var excel = excelApp.Workbooks.Open(inFile, ExcelOpenType.SpreadsheetML2007);

                WriteTo(excel, sheet, "C4", "1"); // Does not persist
                //WriteTo(excel, sheet, "A1", "1"); // Works

                excel.SaveAs($"{filePath}-out.{FileExt}");
                excel.Close();
                engine.Dispose();
            }
        }

        static void WriteTo(IWorkbook excel, string wrksheet, string cell, string value) {
            var sheet = excel.Worksheets[wrksheet];
            var c = sheet[cell];
            c.Value = value;
        }
    }
}