﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Poc1
{
    /// <summary>
    /// Lógica de interacción para MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window, INotifyPropertyChanged
    {
        public MainWindow()
        {
            InitializeComponent();
            DataContext = this;
        }

        public CultureInfo Culture 
        {
            get => pv_CurrentCulture;
            set
            {
                pv_CurrentCulture = value;
                Thread.CurrentThread.CurrentCulture = pv_CurrentCulture;
                Thread.CurrentThread.CurrentUICulture = pv_CurrentCulture;
                CultureInfo.DefaultThreadCurrentCulture = pv_CurrentCulture;

                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(Culture)));
            }
        }
        
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            pv_CurrentCultureIdx = (pv_CurrentCultureIdx + 1) % CULTURES.Length;
            Culture = new CultureInfo(CULTURES[pv_CurrentCultureIdx]);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private string[] CULTURES = { "es-ES", "en-US" };
        private int pv_CurrentCultureIdx = 0;
        private CultureInfo pv_CurrentCulture = Thread.CurrentThread.CurrentCulture;

        private void navigationDrawer_Closing(object sender, CancelEventArgs e)
        {

        }

        private void navigationDrawer_Closed(object sender, EventArgs e)
        {

        }

        private void navigationDrawer_Opening(object sender, CancelEventArgs e)
        {

        }

        private void navigationDrawer_Opened(object sender, EventArgs e)
        {

        }
    }
}
