﻿using Syncfusion.DocIO.DLS;
using Syncfusion.DocToPDFConverter;
using Syncfusion.OfficeChartToImageConverter;
using Syncfusion.Pdf;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    class Program
    {
        static void Main(string[] args)
        {
            using (WordDocument wordDocument = new WordDocument(@"Sample.docx"))
            {
                wordDocument.ChartToImageConverter = new ChartToImageConverter();
                using (DocToPDFConverter docToPDFConverter = new DocToPDFConverter())
                {
                    using (PdfDocument pdfDocument = docToPDFConverter.ConvertToPDF(wordDocument))
                    {
                        pdfDocument.Save("Sample.pdf");
                        pdfDocument.Close(true);
                    }
                }

                wordDocument.Close();
            }

            Process.Start("Sample.pdf");
        }
    }
}
