﻿using Syncfusion.Windows.Forms.Chart;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;

// This sample code uses the Syncfusion Chart Control to chart line segments
// by adding an empty point after the start and end points of each segment.
// However there is an issue when segments are contiguous;
// in which case, only the first segment is displayed!

namespace SyncfusionWinFormsLineChartIssue
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
 
            // Define Line Segments
            var segments = new List<LineSegment>()
            {
                // ISSUE: Line Segments S1, S2, & S3 are contiguous and consecutive, but S2 and S3 are not displayed!
                new LineSegment("S1", 25, 22, 50, 22),
                new LineSegment("S2", 50, 22, 75, 22),
                new LineSegment("S3", 75, 22, 100, 22),
                // Line Segments S3, S4, & S5 are not contiguous, and each are displayed
                new LineSegment("S4", 25, 16, 50, 16),
                new LineSegment("S5", 50, 15, 75, 15),
                new LineSegment("S6", 75, 16, 100, 16),
                // Line Segments S7, S8 & S9 are contiguous but are defined in reverse order so that the points are not consecutive, and each are displayed
                new LineSegment("S9", 75, 10, 100, 10),
                new LineSegment("S8", 50, 10, 75, 10),
                new LineSegment("S7", 25, 10, 50, 10),
            };

            // Configure chart control series
            var series = chartControl1.Series["LineSegments"];
            series.Style.ToolTip = series.Name;
            ChartSymbolInfo chartSymbolInfo1 = new ChartSymbolInfo()
            {
                Color = System.Drawing.Color.Brown,
                Shape = Syncfusion.Windows.Forms.Chart.ChartSymbolShape.Square,
                Size = new System.Drawing.Size(6, 6)
            };
            series.Style.Symbol = chartSymbolInfo1;

            // Add Line Segments to chart control
            series.SortPoints = false;
            var points = series.Points;
            points.Clear();
            foreach (var segment in segments)
            {
                // Add start point and tooltip for point
                int i = points.Add(segment.StartX, segment.StartY);
                string tooltip = segment.ToString();
                series.Styles[i].ToolTip = tooltip;
                // Add end point and tooltip for point
                i = points.Add(segment.EndX, segment.EndY);
                series.Styles[i].ToolTip = tooltip;
                // Add empty point to end line segment and tooltip for point
                i = points.Add(new ChartPoint() { IsEmpty = true });
                series.Styles[i].ToolTip = tooltip;
                // Conditionally log Line Segment details
                Debug.WriteLine($"Line Segment = {tooltip}");
            }
        }
    }
}
