﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using Syncfusion.JavaScript.DataVisualization;
using Syncfusion.JavaScript.DataVisualization.Models;
using Syncfusion.EJ;

namespace ChartWebForms
{
    public partial class _Default : Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("xValue");
            dt.Columns.Add("yValue");

            dt.Rows.Add(new Object[] { "Opening Policy Count", 1288 });
            dt.Rows.Add(new Object[] { "Exits", -250 });
            dt.Rows.Add(new Object[] { "Expiries", -260 });
            dt.Rows.Add(new Object[] { "New business", 279 });
            dt.Rows.Add(new Object[] { "Reinstatements"  });
           
            Series series = new Series();            
            series.XName = "xValue";
            series.YName = "yValue";
           // series.DataSource = dt;
            series.Marker.DataLabel.Visible = true;
            series.Marker.DataLabel.EnableContrastColor = true;
            series.Marker.DataLabel.Font.FontSize = "13px";
            series.Marker.DataLabel.TextPosition = TextPosition.Middle;
            series.Marker.DataLabel.Font.FontWeight = ChartFontWeight.Regular;
            series.Tooltip.Visible = true;
            series.Type = SeriesType.Waterfall;
            series.EnableAnimation = true;
            series.PositiveFill = "green";
            this.Chart1.Series.Add(series);
            this.Chart1.PrimaryXAxis.LabelIntersectAction = LabelIntersectAction.Wrap;
            this.Chart1.PrimaryYAxis.LabelFormat = "{value}";
            this.Chart1.Title.Text = "Active Policy Count Movement Analysis";
            this.Chart1.Visible = true;
            this.Chart1.Legend.Visible = false;
            this.Chart1.DataSource = dt;
            this.Chart1.DataBind();
           

            //// Create dataSource to chart
            //List<ChartData> data = new List<ChartData>();
            //data.Add(new ChartData("Jan", 35));
            //data.Add(new ChartData("Feb", 28));
            //data.Add(new ChartData("Mar", 34));
            //data.Add(new ChartData("Apr", 32));
            //data.Add(new ChartData("May", 40));
            //data.Add(new ChartData("Jun", 32));
            //data.Add(new ChartData("Jul", 35));
            //data.Add(new ChartData("Aug", 55));
            //data.Add(new ChartData("Sep", 38));
            //data.Add(new ChartData("Oct", 30));
            //data.Add(new ChartData("Nov", 25));
            //data.Add(new ChartData("Dec", 32));
            //this.Chart1.DataSource = data;
            //this.DataBind();
        }
    }
    public class ChartData
    {
        public string Month;
        public double Sales;
        public ChartData(string month, double sales)
        {
            this.Month = month;
            this.Sales = sales;
        }
    }
}