import { Component, OnInit, ViewChild } from "@angular/core";
import { inventoryData } from "./data";
import {
  GroupService,
  SortService,
  GridComponent,
  parentsUntil
} from "@syncfusion/ej2-angular-grids";
import { CheckBox } from "@syncfusion/ej2-angular-buttons";

@Component({
  selector: "app-root",
  templateUrl: "app.component.html",
  providers: [GroupService, SortService]
})
export class AppComponent {
  public data: Object[];
  public groupOptions: Object;
  public pageSettings: Object;
  public refresh: Boolean;
  @ViewChild("grid", { static: true }) grid: GridComponent;
  ngOnInit(): void {
    this.data = inventoryData;
    this.groupOptions = {
      showGroupedColumn: false,
      columns: ["Country", "Mainfieldsofinvention"],
      captionTemplate: "#groupTemplate"
    };
    this.pageSettings = { pageCount: 20 };
  }
  dataBound() {
    var chaecksavil = document.getElementsByClassName("groupcheck");
    if (chaecksavil.length) {
      for (var i = 0; i < chaecksavil.length; i++) {
        var checkBoxObj = new CheckBox({ change: this.onChange.bind(this) });
        checkBoxObj.appendTo(chaecksavil[i] as HTMLElement);
      }
    }
  }
  onChange(args) {
    var tr = parentsUntil(args.event.target, "e-groupcaption").parentElement;
    let i = (tr as any).rowIndex;
    let nextRow;
    let indexes = [];
    i++;
    nextRow = (tr as any).parentElement.rows[i];
    while (nextRow.classList.contains("e-row")) {
      if (
        args.checked &&
        this.grid
          .getSelectedRowIndexes()
          .indexOf(parseInt(nextRow.getAttribute("aria-rowindex"))) > -1
      ) {
        nextRow.getElementsByTagName("input")[0].click();
      }
      nextRow.getElementsByTagName("input")[0].click();
      i++;
      nextRow = (tr as any).parentElement.rows[i];
    }
  }

  checkBoxChange(args) {
    if (args.target.closest(".e-headercell") !== null) {
      var chaecksavil = document.getElementsByClassName("groupcheck");
      var i = 0;
      while (i < chaecksavil.length) {
        (chaecksavil[i] as any).ej2_instances[0].checked = args.checked;
        i++;
      }
    }
  }
}
