﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Reflection;

namespace TestSyncfusionSfMultiSelect.Data
{
    public delegate Task EventHandlerAsync<T>(object sender, T e);


    public class ObservableProperty<T>
    {
        public event EventHandler<T> OnChanged;
        public event EventHandlerAsync<T> OnChangedAsync;

        T variable;
        public T Property
        {
            get => variable;
            set
            {
                //if (value == null && typeof(T).IsClass)
                //    variable = (T)Activator.CreateInstance(typeof(T));
                //else
                variable = value;

                OnChanged?.Invoke(this, value);
                if (OnChangedAsync != null)
                    Task.Run(async () => { await OnChangedAsync.Invoke(this, value); });
            }
        }


        public bool IsEmpty()
        {
            var t = typeof(T);

            if (t==typeof(List<>))
            {
                int cnt = (int) t.GetProperty("Count").GetValue(variable);
                return (variable == null || cnt==0);
            }
            else
                return variable == null;
        }

        public ObservableProperty()
        {
            if (typeof(T).IsClass)
                variable = (T)Activator.CreateInstance(typeof(T));
        }
    }
}
