﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace TestSyncfusionSfMultiSelect.Data
{
    public class Authority
    {
        public Int64 Id { get; set; }
        public String Name { get; set; }
    }



    public class NavBarState
    {
        public bool MenuShown { get; set; } = false;

        public List<Authority> Authorities { get; set; }

        public ObservableProperty<List<Int64>> SelectedAuthorityIds = new ObservableProperty<List<Int64>>();

        public NavBarState()
        {
            Authorities = new List<Authority>() { new Authority { Id = 1, Name = "Adf" }, new Authority { Id = 2, Name = "Cisa" }, new Authority { Id = 3, Name = "Salt" }, new Authority { Id = 4, Name = "ATS" } };
        }

        public String SelectedAuthorityNames {
            get
            {
                if (SelectedAuthorityIds.Property == null)
                    return String.Empty;
                else return String.Join(',', Authorities.Where(e => SelectedAuthorityIds.Property.Contains(e.Id)).Select(e => e.Name));
            }
        }
    }
}
