declare namespace ej { 
export namespace barcodeGenerator { 

//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/barcode-base.d.ts
/**
 * defines the common methods for the barcode
 */
export  abstract class BarcodeBase {
    abstract validateInput(char: string, characters: string): boolean | string;
    abstract drawImage(canvas: HTMLCanvasElement, options: BaseAttributes[], labelPosition: number, barcodeSize: Rect, endValue: number, textRender: string): void;
    abstract getDrawableSize(margin: MarginModel, widthValue: number, height: number): void;
    height: string | number;
    width: string | number;
    margin: MarginModel;
    displayText: DisplayTextModel;
    value: string;
    foreColor: string;
    type: BarcodeType;
    isSvgMode: boolean;
    alignment: Alignment;
    enableCheckSum: boolean;
    encodingValue: DataMatrixEncoding;
    size: DataMatrixSize;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/barcode-model.d.ts
/**
 * Interface for a class BarcodeGenerator
 */
export interface BarcodeGeneratorModel extends base.ComponentModel{
    /**
     * Defines the width of the barcode model.
     * ```html
     * <div id='barcode'/>
     * ```
     * ```typescript
     * let barcode: Barcode = new Barcode({
     * width:'1000px', height:'500px' });
     * barcode.appendTo('#barcode');
     * ```
     * @default '100%'
     */
    width?: string | number;
    /**
     * Defines the height of the barcode model.
     * ```html
     * <div id='barcode'/>
     * ```
     * ```typescript
     * let barcode: Barcode = new Barcode({
     * height:'1000px', height:'500px' });
     * barcode.appendTo('#barcode');
     * ```
     * @default '100'
     */
    height?: string | number;
    /**
     * Defines the barcode rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode?: RenderingMode;
    /**
     * Defines the type of barcode to be rendered.
     * @default 'Code128'
     */
    type?: BarcodeType;
    /**
     * Defines the value of the barcode to be rendered.
     * @default undefined
     */
    value?: string;
    /**
     * Defines the checksum for the barcode.
     * @default 'true'
     */
    enableCheckSum?: boolean;
    /**
     * Defines the text properties for the barcode.
     * @default ''
     */
    displayText?: DisplayTextModel;
    /**
     * Defines the margin properties for the barcode.
     * @default ''
     */
    margin?: MarginModel;
    /**
     * Defines the background color of the barcode.
     * @default 'white'
     */
    backgroundColor?: string;
    /**
     * Defines the forecolor of the barcode.
     * @default 'black'
     */
    foreColor?: string;
    /**
     * Triggers if you enter any invalid character.
     * @event
     */
    invalid?: base.EmitType<Object>;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/barcode.d.ts
/**
 * Represents the Barcode control
 * ```html
 * <div id='barcode'/>
 * ```
 * ```typescript
 * let barcode$: Barcode = new Barcode({
 * width:'1000px', height:'500px' });
 * barcode.appendTo('#barcode');
 * ```
 */
export  class BarcodeGenerator extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * Defines the width of the barcode model.
     * ```html
     * <div id='barcode'/>
     * ```
     * ```typescript
     * let barcode$: Barcode = new Barcode({
     * width:'1000px', height:'500px' });
     * barcode.appendTo('#barcode');
     * ```
     * @default '100%'
     */
    width: string | number;
    /**
     * Defines the height of the barcode model.
     * ```html
     * <div id='barcode'/>
     * ```
     * ```typescript
     * let barcode$: Barcode = new Barcode({
     * height:'1000px', height:'500px' });
     * barcode.appendTo('#barcode');
     * ```
     * @default '100'
     */
    height: string | number;
    /**
     * Defines the barcode rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode: RenderingMode;
    /**
     * Defines the type of barcode to be rendered.
     * @default 'Code128'
     */
    type: BarcodeType;
    /**
     * Defines the value of the barcode to be rendered.
     * @default undefined
     */
    value: string;
    /**
     * Defines the checksum for the barcode.
     * @default 'true'
     */
    enableCheckSum: boolean;
    /**
     * Defines the text properties for the barcode.
     * @default ''
     */
    displayText: DisplayTextModel;
    /**
     * Defines the margin properties for the barcode.
     * @default ''
     */
    margin: MarginModel;
    /**
     * Defines the background color of the barcode.
     * @default 'white'
     */
    backgroundColor: string;
    /**
     * Defines the forecolor of the barcode.
     * @default 'black'
     */
    foreColor: string;
    /**
     * Triggers if you enter any invalid character.
     * @event
     */
    invalid: base.EmitType<Object>;
    /** @private */
    localeObj: base.L10n;
    /** @private */
    private defaultLocale;
    private barcodeCanvas;
    private barcodeRenderer;
    /**
     * Constructor for creating the widget
     */
    constructor(options?: BarcodeGeneratorModel, element?: HTMLElement | string);
    private triggerEvent;
    onPropertyChanged(newProp: BarcodeGeneratorModel, oldProp: BarcodeGeneratorModel): void;
    private initialize;
    private renderElements;
    private refreshCanvasBarcode;
    private clearCanvas;
    /**
     * Get the properties to be maintained in the persisted state.
     * @return {string}
     */
    getPersistData(): string;
    /**
     * @private
     * @param real
     */
    private getElementSize;
    protected preRender(): void;
    private initializePrivateVariables;
    /**
     * Method to set culture for chart
     */
    private setCulture;
    /**
     * Renders the barcode control with nodes and connectors
     */
    render(): void;
    /**
     * Returns the module name of the barcode
     */
    getModuleName(): string;
    /**
     * To provide the array of modules needed for control rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    /**
     * Destroys the barcode control
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/enum/enum.d.ts
/**
 * Enum
 */
/**
 * Defines the rendering mode of the barcode. They are
 * * SVG
 * * Canvas
 */
export  type RenderingMode = 
/** SVG - Renders the barcode objects as SVG elements */
'SVG' | 
/** Canvas - Renders the barcode in a canvas */
'Canvas';
/**
 * Defines the event of the barcode
 * * BarcodeEvent - Throws when an invalid input was given.
 */
export  enum BarcodeEvent {
    'invalid' = 0
}
/**
 * Defines the text alignment for the text to be rendered in the barcode. The text alignment types are
 * * Left
 * * Right
 * * Center
 */
export  type Alignment = 
/** Left - Align the text to the left side of the barcode element. */
'Left' | 
/** Left - Align the text to the right side of the barcode element. */
'Right' | 
/** Left - Align the text to the center side of the barcode element. */
'Center';
/**
 * Defines the text position for the text to be rendered in the barcode. The text positions are
 * * Bottom
 * * Top
 */
export  type TextPosition = 
/** Bottom - Text will be rendered in the bottom of the barcode element. */
'Bottom' | 
/** Top - Text will be rendered in the top of the barcode element. */
'Top';
/**
 * Defines the quite zone for the Qr Code.
 */
/** @private */
export  enum QuietZone {
    All = 2
}
/**
 * Defines the encoding type for the datamatrix code. They are
 * * Auto
 * * ASCII
 * * ASCIINumeric
 * * Base256
 */
export  type DataMatrixEncoding = 
/** Auto - Encoding type will be automatically assigned for the given input. */
'Auto' | 
/** ASCII - Accept only the ASCII values. */
'ASCII' | 
/** ASCIINumeric - Accept only the ASCII numeric values. */
'ASCIINumeric' | 
/** Base256 -Accept the base256 values */
'Base256';
/**
 * Defines the size for the datamatrix code. The defined size are
 * * Auto
 * * Size10x10
 * * Size12x12
 * * Size14x14
 * * Size16x16
 * * Size18x18
 * * Size20x20
 * * Size22x22
 * * Size24x24
 * * Size26x26
 * * Size32x32
 * * Size36x36
 * * Size40x40
 * * Size44x44
 * * Size48x48
 * * Size52x52
 * * Size64x64
 * * Size72x72
 * * Size80x80
 * * Size88x88
 * * Size96x96
 * * Size104x104
 * * Size120x120
 * * Size132x132
 * * Size144x144
 * * Size8x18
 * * Size8x32
 * * Size12x26
 * * Size12x36
 * * Size16x36
 * * Size16x48
 * @aspNumberEnum
 * @blazorNumberEnum
 * @IgnoreSingular
 */
export  enum DataMatrixSize {
    /**
     * modules will be generated automatically.
     */
    Auto = 0,
    /**
     * will generate 10*10 modules.
     */
    Size10x10 = 1,
    /**
     * will generate 12*12 modules.
     */
    Size12x12 = 2,
    /**
     * will generate 14*14 modules.
     */
    Size14x14 = 3,
    /**
     * will generate 16*16 modules.
     */
    Size16x16 = 4,
    /**
     * will generate 18*18 modules.
     */
    Size18x18 = 5,
    /**
     * will generate 20*20 modules.
     */
    Size20x20 = 6,
    /**
     * will generate 22*22 modules.
     */
    Size22x22 = 7,
    /**
     * will generate 24*24 modules.
     */
    Size24x24 = 8,
    /**
     * will generate 26*26 modules.
     */
    Size26x26 = 9,
    /**
     * will generate 32*32 modules.
     */
    Size32x32 = 10,
    /**
     * will generate 32*32 modules.
     */
    Size36x36 = 11,
    /**
     * will generate 40*40 modules.
     */
    Size40x40 = 12,
    /**
     * will generate 44*44 modules.
     */
    Size44x44 = 13,
    /**
     * will generate 48*48 modules.
     */
    Size48x48 = 14,
    /**
     * will generate 52*52 modules.
     */
    Size52x52 = 15,
    /**
     * will generate 64*64 modules.
     */
    Size64x64 = 16,
    /**
     * will generate 72*72 modules.
     */
    Size72x72 = 17,
    /**
     * will generate 80*80 modules.
     */
    Size80x80 = 18,
    /**
     * will generate 88*88 modules.
     */
    Size88x88 = 19,
    /**
     * will generate 96*96 modules.
     */
    Size96x96 = 20,
    /**
     * will generate 104*104 modules.
     */
    Size104x104 = 21,
    /**
     * will generate 120*120 modules.
     */
    Size120x120 = 22,
    /**
     * will generate 132*132 modules.
     */
    Size132x132 = 23,
    /**
     * will generate 144*144 modules.
     */
    Size144x144 = 24,
    /**
     * will generate 8*18 modules.
     */
    Size8x18 = 25,
    /**
     * will generate 8*32 modules.
     */
    Size8x32 = 26,
    /**
     * will generate 12*26 modules.
     */
    Size12x26 = 27,
    /**
     * will generate 12*36 modules.
     */
    Size12x36 = 28,
    /**
     * will generate 16*36 modules.
     */
    Size16x36 = 29,
    /**
     * will generate 16*48 modules.
     */
    Size16x48 = 30
}
/**
 * Defines the type of the barcode to be generated. The barcode types are
 * * Code39
 * * Code128
 * * Code128A
 * * Code128B
 * * Code128C
 * * Codabar
 * * Ean8
 * * Ean13
 * * UpcA
 * * UpcE
 * * Code11
 * * Code93
 * * Code93Extension
 * * Code39Extension
 * * Code32
 */
export  type BarcodeType = 
/** code39 - render the code39 barcode */
'Code39' | 
/** code128 - render the code128 barcode */
'Code128' | 
/** code128A - render the code128A barcode */
'Code128A' | 
/** code128B - render the code128B barcode */
'Code128B' | 
/** code128C - render the code128C barcode */
'Code128C' | 
/** Codabar - render the codabar barcode */
'Codabar' | 
/** Ean8 - render the Ean8 barcode */
'Ean8' | 
/** Ean8 - render the Ean8 barcode */
'Ean13' | 
/** UpcA - render the UpcA barcode */
'UpcA' | 
/** UpcE - render the UpcE barcode */
'UpcE' | 
/** Code11 - render the code11 barcode */
'Code11' | 
/** Code93 - render the code93 barcode */
'Code93' | 
/** Code93Extension - render the Code93Extension barcode */
'Code93Extension' | 
/** Code39EXTD - render the code39EXTD barcode */
'Code39Extension' | 
/** Code32 - render the Code32 barcode */
'Code32';
/**
 * Defines the Qrcode input mode. The QR input modes are
 * * NumericMode
 * * BinaryMode
 * * AlphaNumericMode
 */
export  type QRInputMode = 
/** NumericMode - Changes its mode to numericMode when the given input is numeric. */
'NumericMode' | 
/** BinaryMode - Changes its mode to BinaryMode when the given input is numeric or smaller case or both. */
'BinaryMode' | 
/** AlphaNumericMode - Changes its mode to AlphaNumericMode when the given is numeric or upper case or both. */
'AlphaNumericMode';
/**
 * Defines the Qrcode QRCodeVersion. They are
 * * Auto
 * * Version01
 * * Version02
 * * Version03
 * * Version04
 * * Version05
 * * Version06
 * * Version07
 * * Version08
 * * Version09
 * * Version10
 * * Version11
 * * Version12
 * * Version13
 * * Version14
 * * Version15
 * * Version16
 * * Version17
 * * Version18
 * * Version19
 * * Version20
 * * Version21
 * * Version22
 * * Version23
 * * Version24
 * * Version25
 * * Version26
 * * Version27
 * * Version28
 * * Version29
 * * Version30
 * * Version31
 * * Version32
 * * Version33
 * * Version34
 * * Version35
 * * Version36
 * * Version37
 * * Version38
 * * Version39
 * * Version40
 * @aspNumberEnum
 * @blazorNumberEnum
 * @IgnoreSingular
 */
export  enum QRCodeVersion {
    /**
     * Specifies the default version.
     */
    Auto = 0,
    /**
     * Specifies version 1 (21 x 21 modules).
     */
    Version01 = 1,
    /**
     * Specifies version 2 (25 x 25 modules).
     */
    Version02 = 2,
    /**
     * Specifies version 3 (29 x 29 modules).
     */
    Version03 = 3,
    /**
     * Specifies version 4 (33 x 33 modules).
     */
    Version04 = 4,
    /**
     * Specifies version 5 (37 x 37 modules).
     */
    Version05 = 5,
    /**
     * Specifies version 6 (41 x 41 modules).
     */
    Version06 = 6,
    /**
     * Specifies version 7 (45 x 45 modules).
     */
    Version07 = 7,
    /**
     * Specifies version 8 (49 x 49 modules).
     */
    Version08 = 8,
    /**
     * Specifies version 9 (53 x 53 modules).
     */
    Version09 = 9,
    /**
     * Specifies version 10 (57 x 57 modules).
     */
    Version10 = 10,
    /**
     * Specifies version 11 (61 x 61 modules).
     */
    Version11 = 11,
    /**
     * Specifies version 12 (65 x 65 modules).
     */
    Version12 = 12,
    /**
     * Specifies version 13 (69 x 69 modules).
     */
    Version13 = 13,
    /**
     * Specifies version 14 (73 x 73 modules).
     */
    Version14 = 14,
    /**
     * Specifies version 15 (77 x 77 modules).
     */
    Version15 = 15,
    /**
     * Specifies version 17 (85 x 85 modules).
     */
    Version16 = 16,
    /**
     * Specifies version 17 (85 x 85 modules).
     */
    Version17 = 17,
    /**
     * Specifies version 18 (89 x 89 modules).
     */
    Version18 = 18,
    /**
     * Specifies version 19 (93 x 93 modules).
     */
    Version19 = 19,
    /**
     * Specifies version 20 (97 x 97 modules).
     */
    Version20 = 20,
    /**
     * Specifies version 21 (101 x 101 modules).
     */
    Version21 = 21,
    /**
     * Specifies version 22 (105 x 105 modules).
     */
    Version22 = 22,
    /**
     * Specifies version 23 (109 x 109 modules).
     */
    Version23 = 23,
    /**
     * Specifies version 24 (113 x 113 modules).
     */
    Version24 = 24,
    /**
     * Specifies version 25 (117 x 117 modules).
     */
    Version25 = 25,
    /**
     * Specifies version 26 (121 x 121 modules).
     */
    Version26 = 26,
    /**
     * Specifies version 27 (125 x 125 modules).
     */
    Version27 = 27,
    /**
     * Specifies version 28 (129 x 129 modules).
     */
    Version28 = 28,
    /**
     * Specifies version 29 (133 x 133 modules).
     */
    Version29 = 29,
    /**
     * Specifies version 30 (137 x 137 modules).
     */
    Version30 = 30,
    /**
     * Specifies version 31 (141 x 141 modules).
     */
    Version31 = 31,
    /**
     * Specifies version 32 (145 x 145 modules).
     */
    Version32 = 32,
    /**
     * Specifies version 33 (149 x 149 modules).
     */
    Version33 = 33,
    /**
     * Specifies version 34 (153 x 153 modules).
     */
    Version34 = 34,
    /**
     * Specifies version 35 (157 x 157 modules).
     */
    Version35 = 35,
    /**
     * Specifies version 36 (161 x 161 modules).
     */
    Version36 = 36,
    /**
     * Specifies version 37 (165 x 165 modules).
     */
    Version37 = 37,
    /**
     * Specifies version 38 (169 x 169 modules).
     */
    Version38 = 38,
    /**
     * Specifies version 39 (173 x 173 modules).
     */
    Version39 = 39,
    /**
     * Specifies version 40 (177 x 177 modules).
     */
    Version40 = 40
}
/**
 * Indicated the recovery capacity of the qrcode. The default capacity levels are
 * * Low
 * * Medium
 * * Quartile
 * * High
 * @aspNumberEnum
 * @blazorNumberEnum
 * @IgnoreSingular
 */
export  enum ErrorCorrectionLevel {
    /**
     * The Recovery capacity is 7%(approx.)
     */
    Low = 7,
    /**
     * The Recovery capacity is 15%(approx.)
     */
    Medium = 15,
    /**
     * The Recovery capacity is 25%(approx.)
     */
    Quartile = 25,
    /**
     * The Recovery capacity is 30%(approx.)
     */
    High = 30
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/index.d.ts
/**
 * Barcode component exported items
 */
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension.d.ts
/**
 * onedimension class is used to render all type of one dimensional shapes
 */
export  abstract class OneDimension extends BarcodeBase {
    private getInstance;
    /** @private */
    getDrawableSize(margin: MarginModel, w: number, h: number): Rect;
    private getBaseAttributes;
    private getBarLineRatio;
    private multipleWidth;
    private barCodeType;
    private checkStartValueCondition;
    private checkEndValueCondition;
    private getDisplayText;
    private checkExtraHeight;
    private getWidthValue;
    /** @private */
    calculateBarCodeAttributes(code: number[] | string[], canvas: HTMLElement, isUpcE?: string): void;
    private canIncrementCheck;
    private verticalTextMargin;
    private getAlignmentPosition;
    /** @private */
    drawImage(canvas: HTMLCanvasElement, options: BaseAttributes[]): void;
    private updateDisplayTextSize;
    private alignDisplayText;
    private updateOverlappedTextPosition;
    private drawText;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/codabar.d.ts
/**
 * codabar used to calculate the barcode of type codabar
 */
export  class CodaBar extends OneDimension {
    /** @private */
    validateInput(char: string): string;
    private getCodeValue;
    private appendStartStopCharacters;
    private getPatternCollection;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code11.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code11 extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    /**
     * get the code value to check
     */
    private getCodeValue;
    private getPatternCollection;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code128.d.ts
/**
 * code128 used to calculate the barcode of type 128
 */
export  class Code128 extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(char: string): string;
    private getCodeValue;
    private getBytes;
    private appendStartStopCharacters;
    private check128C;
    private check128A;
    private check128B;
    private clipAB;
    private code128Clip;
    private clipC;
    /** @private */
    draw(canvas: HTMLElement): void;
    /** @private */
    code128(canvas: HTMLElement): void;
    private encodeData;
    private swap;
    private encode;
    private correctIndex;
    private getCodes;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code128A.d.ts
/**
 * code128A used to calculate the barcode of type 1228A
 */
export  class Code128A extends Code128 {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(char: string): string;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code128B.d.ts
/**
 * code128B used to calculate the barcode of type 128
 */
export  class Code128B extends Code128 {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(char: string): string;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code128C.d.ts
/**
 * code128C used to calculate the barcode of type 128C barcode
 */
export  class Code128C extends Code128 {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(char: string): string;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code32.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code32 extends OneDimension {
    /** @private */
    validateInput(char: string): string;
    /**
     * get the code value to check
     */
    private getCodeValue;
    private getPatternCollection;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code39.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code39 extends OneDimension {
    /**
     * get the code value to check
     */
    private getCodeValue;
    /**
     * get the characters to check
     */
    private getCharacter;
    /**
     * Check sum method for the code 39 bar code
     */
    private checkSum;
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(char: string): string;
    private getPatternCollection;
    private appendStartStopCharacters;
    /** @private */
    drawCode39Extension(canvas: HTMLElement, encodedCharacter: string): void;
    /** @private */
    draw(canvas: HTMLElement, encodedCharacter?: string): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code39Extension.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code39Extension extends Code39 {
    private code39ExtensionValues;
    /**
     * Validate the given input to check whether the input is valid one or not
     *
     */
    /** @private */
    validateInput(char: string): string;
    private checkText;
    private code39Extension;
    /** @private */
    drawCode39(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code93.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code93 extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    private getCharacterWeight;
    /**
     * get the code value to check
     */
    private getCodeValue;
    private getPatternCollection;
    private calculateCheckSum;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/code93Extension.d.ts
/**
 * code39 used to calculate the barcode of type 39
 */
export  class Code93Extension extends Code93 {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(text: string): string;
    private getValue;
    private barcodeSymbols;
    private getBars;
    private GetExtendedText;
    /** @private */
    drawCode93(canvas: HTMLElement): void;
    private extendedText;
    private GetCheckSumSymbols;
    private CalculateCheckDigit;
    private getArrayValue;
    private encoding;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/ean13.d.ts
/**
 * EAN13 class is  used to calculate the barcode of type EAN13 barcode
 */
export  class Ean13 extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    private checkSumData;
    private getStructure;
    private getBinaries;
    /** @private */
    draw(canvas: HTMLElement): void;
    private leftValue;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/ean8.d.ts
/**
 * EAN8 class is  used to calculate the barcode of type EAN8 barcode
 */
export  class Ean8 extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    private getCodeValueRight;
    private checkSumData;
    /** @private */
    draw(canvas: HTMLElement): void;
    private leftValue;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/upcA.d.ts
/**
 * This class is  used to calculate the barcode of type Universal Product Code barcode
 */
export  class UpcA extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    private checkSumData;
    private getBinaries;
    /** @private */
    draw(canvas: HTMLElement): void;
    private leftValue;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/one-dimension/upcE.d.ts
/**
 * This class is  used to calculate the barcode of type Universal Product Code barcode
 */
export  class UpcE extends OneDimension {
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    /** @private */
    validateInput(value: string): string;
    private checkSum;
    private getStructure;
    private getValue;
    private getExpansion;
    private getUpcValue;
    private getBinaries;
    private encoding;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/displaytext-model.d.ts
/**
 * Interface for a class DisplayText
 */
export interface DisplayTextModel {
    /**
     * Sets the textual description of the barcode.
     * @default ''
     */
    text?: string;
    /**
     * Defines the visibility of the text.
     * @default true
     */
    visibility?: boolean;
    /**
     * Defines the font style of the text
     * @default 'monospace'
     */
    font?: string;
    /**
     * Defines the size of the text.
     * @default 20
     */
    size?: number;
    /**
     * Sets the space to be left between the text and its barcode.
     * @default ''
     */
    margin?: MarginModel;
    /**
     * Defines the horizontal alignment of the text.
     * * Left - Aligns the text at the left
     * * Right - Aligns the text at the Right
     * * Center - Aligns the text at the Center
     * @default 'Center'
     */
    alignment?: Alignment;
    /**
     * Defines the position of the text.
     * * Bottom - Position the text at the Bottom
     * * Top - Position the text at the Top
     * @default 'Bottom'
     */
    position?: TextPosition;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/displaytext.d.ts
/**
 * Defines the space to be left between an object and its immediate parent
 */
export  class DisplayText extends base.ChildProperty<DisplayText> {
    /**
     * Sets the textual description of the barcode.
     * @default ''
     */
    text: string;
    /**
     * Defines the visibility of the text.
     * @default true
     */
    visibility: boolean;
    /**
     * Defines the font style of the text
     * @default 'monospace'
     */
    font: string;
    /**
     * Defines the size of the text.
     * @default 20
     */
    size: number;
    /**
     * Sets the space to be left between the text and its barcode.
     * @default ''
     */
    margin: MarginModel;
    /**
     * Defines the horizontal alignment of the text.
     * * Left - Aligns the text at the left
     * * Right - Aligns the text at the Right
     * * Center - Aligns the text at the Center
     * @default 'Center'
     */
    alignment: Alignment;
    /**
     * Defines the position of the text.
     * * Bottom - Position the text at the Bottom
     * * Top - Position the text at the Top
     * @default 'Bottom'
     */
    position: TextPosition;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/margin-model.d.ts
/**
 * Interface for a class Margin
 */
export interface MarginModel {
    /**
     * Sets the space to be left from the left side of the immediate parent of an element
     * @default 10
     */
    left?: number;
    /**
     * Sets the space to be left from the right side of the immediate parent of an element
     * @default 10
     */
    right?: number;
    /**
     * Sets the space to be left from the top side of the immediate parent of an element
     * @default 10
     */
    top?: number;
    /**
     * Sets the space to be left from the bottom side of the immediate parent of an element
     * @default 10
     */
    bottom?: number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/margin.d.ts
/**
 * Defines the space to be left between an object and its immediate parent
 */
export  class Margin extends base.ChildProperty<Margin> {
    /**
     * Sets the space to be left from the left side of the immediate parent of an element
     * @default 10
     */
    left: number;
    /**
     * Sets the space to be left from the right side of the immediate parent of an element
     * @default 10
     */
    right: number;
    /**
     * Sets the space to be left from the top side of the immediate parent of an element
     * @default 10
     */
    top: number;
    /**
     * Sets the space to be left from the bottom side of the immediate parent of an element
     * @default 10
     */
    bottom: number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/point-model.d.ts
/**
 * Interface for a class Point
 */
export interface PointModel {
    /**
     * Sets the x-coordinate of a position
     * @default 0
     */
    x?: number;
    /**
     * Sets the y-coordinate of a position
     * @default 0
     */
    y?: number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/point.d.ts
/**
 * Defines and processes coordinates
 */
export  class Point extends base.ChildProperty<Point> {
    /**
     * Sets the x-coordinate of a position
     * @default 0
     */
    x: number;
    /**
     * Sets the y-coordinate of a position
     * @default 0
     */
    y: number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/rect.d.ts
/**
 * Rect defines and processes rectangular regions
 */
export  class Rect {
    /**
     * Sets the x-coordinate of the starting point of a rectangular region
     * @default 0
     */
    x: number;
    /**
     * Sets the y-coordinate of the starting point of a rectangular region
     * @default 0
     */
    y: number;
    /**
     * Sets the width of a rectangular region
     * @default 0
     */
    width: number;
    /**
     * Sets the height of a rectangular region
     * @default 0
     */
    height: number;
    constructor(x?: number, y?: number, width?: number, height?: number);
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/primitives/size.d.ts
/**
 * Size defines and processes the size(width/height) of the objects
 */
export  class Size {
    /**
     * Sets the height of an object
     * @default 0
     */
    height: number;
    /**
     * Sets the width of an object
     * @default 0
     */
    width: number;
    constructor(width?: number, height?: number);
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/rendering/canvas-interface.d.ts
/** @private */
export interface BaseAttributes {
    x: number;
    y: number;
    width: number;
    height: number;
    color: string;
    string?: string;
    stringSize?: number;
    visibility?: boolean;
    fontStyle?: string;
    id?: string;
    strokeColor?: string;
}
/** @private */
export interface EncodingResult {
    checksum: number;
    result: string;
}
/** @private */
export interface PdfDataMatrixSymbolAttribute {
    SymbolRow: number;
    SymbolColumn: number;
    HorizontalDataRegion: number;
    VerticalDataRegion: number;
    DataCodewords: number;
    CorrectionCodewords: number;
    InterleavedBlock: number;
    InterleavedDataBlock: number;
}
/** @private */
export interface Code93ExtendedValues {
    value: string;
    checkDigit: number;
    bars: string;
}
/** @private */
export interface Code93ExtendedArrayAttribute {
    character: string;
    keyword?: string;
    value?: string;
}
/** @private */
export interface ValidateEvent {
    message: string;
}
/** @private */
export  class BarcodeSVGRenderer implements IBarcodeRenderer {
    /**   @private  */
    renderRootElement(attribute: Object): HTMLElement;
    /**   @private  */
    renderRect(canvas: Object, attribute: Object): HTMLElement;
    /**   @private  */
    renderLine(canvas: Object, attribute: Object): HTMLElement;
    /**   @private  */
    renderText(canvas: Object, attribute: Object): HTMLElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/rendering/canvas-renderer.d.ts
/**
 * canvas renderer
 */
/** @private */
export  class BarcodeCanvasRenderer implements IBarcodeRenderer {
    /**   @private  */
    static getContext(canvas: HTMLCanvasElement): CanvasRenderingContext2D;
    /**   @private  */
    renderRootElement(attribute: Object, backGroundColor: string, width: number, height: number): HTMLElement;
    /**   @private  */
    renderRect(canvas: HTMLCanvasElement, attribute: BaseAttributes): HTMLElement;
    renderText(canvas: HTMLCanvasElement, attribute: BaseAttributes): HTMLElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/rendering/IRenderer.d.ts
/**
 * IRenderer interface
 */
/** @private */
export interface IBarcodeRenderer {
    renderRootElement(attribute: Object, backGroundColor: string, width: number, height: number): HTMLElement;
    renderRect(canvas: HTMLCanvasElement, attribute: Object, isText?: boolean): HTMLElement;
    renderText(canvas: HTMLCanvasElement, attribute: Object): HTMLElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/rendering/renderer.d.ts
/**
 * Renderer
 */
/**
 * Renderer module is used to render basic barcode elements
 */
/** @private */
export  class BarcodeRenderer {
    /**   @private  */
    renderer: IBarcodeRenderer;
    isSvgMode: Boolean;
    constructor(name: string, isSvgMode: Boolean);
    /**   @private  */
    renderRootElement(attribute: Object, backGroundColor: string, width: number, height: number): HTMLElement;
    /**   @private  */
    renderRectElement(canvas: HTMLCanvasElement, attribute: Object): HTMLElement;
    /**   @private  */
    renderTextElement(canvas: HTMLCanvasElement, attribute: Object): HTMLElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/rendering/svg-renderer.d.ts
/**
 * svg renderer
 */
/** @private */
export  class BarcodeSVGRenderering implements IBarcodeRenderer {
    /**   @private  */
    renderRootElement(attribute: Object, backGroundColor: string): HTMLElement;
    /**   @private  */
    renderRect(svg: HTMLElement, attribute: BaseAttributes): HTMLElement;
    /**   @private  */
    renderText(svg: HTMLElement, attribute: BaseAttributes): HTMLElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/utility/barcode-util.d.ts
/**
 * Barcode util
 */
/** @private */
export  function removeChildElements(newProp: QRCodeGeneratorModel | DataMatrixGeneratorModel, barcodeCanvas: HTMLElement, mode: RenderingMode, id: string): BarcodeRenderer;
/** @private */
export  function getBaseAttributes(width: number, height: number, offSetX: number, offsetY: number, color: string, strokeColor?: string): BaseAttributes;
/** @private */
export  function clearCanvas(view: QRCodeGenerator | DataMatrixGenerator, barcodeCanvas: HTMLCanvasElement): void;
/** @private */
export  function refreshCanvasBarcode(qrCodeGenerator: QRCodeGenerator | DataMatrixGenerator, barcodeCanvas: HTMLCanvasElement): void;
//node_modules/@syncfusion/ej2-barcode-generator/src/barcode/utility/dom-util.d.ts
/**
 * DOM util
 */
/** @private */
export  function createHtmlElement(elementType: string, attribute?: Object): HTMLElement;
export  function getChildNode(node: SVGElement): SVGElement[] | HTMLCollection;
export  function measureText(textContent: BaseAttributes): Size;
/** @private */
export  function setAttribute(element: HTMLElement | SVGElement, attributes: Object): void;
/** @private */
export  function createSvgElement(elementType: string, attribute: Object): HTMLElement | SVGElement;
/** @private */
export  function createMeasureElements(): void;
//node_modules/@syncfusion/ej2-barcode-generator/src/datamatrix/datamatrix-model.d.ts
/**
 * Interface for a class DataMatrixGenerator
 */
export interface DataMatrixGeneratorModel extends base.ComponentModel{
    /**
     * Defines encoding type of the DataMatrix.
     * @default 'Auto'
     */
    encoding?: DataMatrixEncoding;
    /**
     * Defines encoding type of the DataMatrix.
     * @default 'Auto'
     */
    size?: DataMatrixSize;
    /**
     * Defines the DataMatrix rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode?: RenderingMode;
    /**
     * Defines the value of the DataMatrix to be rendered.
     * @default undefined
     */
    value?: string;
    /**
     * Defines the height of the DataMatrix.
     * @default '100%'
     */
    height?: string | number;
    /**
     * Defines the width of the DataMatrix.
     * @default '100%'
     */
    width?: string | number;
    /**
     * Defines the text properties for the DataMatrix.
     * @default ''
     */
    displayText?: DisplayTextModel;
    /**
     * Defines the margin properties for the DataMatrix.
     * @default ''
     */
    margin?: MarginModel;
    /**
     * Defines the background color of the DataMatrix.
     * @default 'white'
     */
    backgroundColor?: string;
    /**
     * Triggers if we entered any invalid character
     * @event
     */
    invalid?: base.EmitType<Object>;
    /**
     * Defines the forecolor of the DataMatrix.
     * @default 'black'
     */
    foreColor?: string;
    /**
     * Defines the xDimension of the DataMatrix.
     */
    xDimension?: number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/datamatrix/datamatrix-util.d.ts
/**
 * DataMatrix used to calculate the DataMatrix barcode
 */
export  class DataMatrix {
    /** @private */
    encodingValue: DataMatrixEncoding;
    /** @private */
    height: string | number;
    /** @private */
    width: string | number;
    /** @private */
    margin: MarginModel;
    /** @private */
    displayText: DisplayTextModel;
    /** @private */
    foreColor: string;
    /** @private */
    isSvgMode: boolean;
    /** @private */
    value: string;
    private barcodeRenderer;
    /** @private */
    size: DataMatrixSize;
    private mXDimension;
    private mDataMatrixArray;
    private actualColumns;
    private actualRows;
    /** @private */
    XDimension: number;
    private encodedCodeword;
    private mSymbolAttribute;
    private GetData;
    private fillZero;
    private DataMatrixNumericEncoder;
    private ComputeBase256Codeword;
    private DataMatrixBaseEncoder;
    private copy;
    private DataMatrixEncoder;
    private PrepareDataCodeword;
    private PdfDataMatrixSymbolAttribute;
    private getmSymbolAttributes;
    private PadCodewords;
    private EccProduct;
    /**
     * Validate the given input to check whether the input is valid one or not
     */
    private validateInput;
    private ComputeErrorCorrection;
    private CreateLogArrays;
    private EccSum;
    private EccDoublify;
    private CreateRSPolynomial;
    private PrepareCodeword;
    private copyArray;
    private ecc200placementbit;
    private ecc200placementblock;
    private ecc200placementcornerD;
    private ecc200placementcornerA;
    private ecc200placementcornerB;
    private ecc200placementcornerC;
    private ecc200placement;
    private getActualRows;
    private getActualColumns;
    private AddQuiteZone;
    private drawImage;
    private CreateMatrix;
    private create1DMatrixArray;
    private create2DMartixArray;
    /** @private */
    BuildDataMatrix(): number[] | string;
    private drawText;
    private getInstance;
    private drawDisplayText;
    private getDrawableSize;
    /** @private */
    draw(canvas: HTMLElement): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/datamatrix/datamatrix.d.ts
/**
 * Represents the Datamatrix control
 * ```
 */
export  class DataMatrixGenerator extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * Defines encoding type of the DataMatrix.
     * @default 'Auto'
     */
    encoding: DataMatrixEncoding;
    /**
     * Defines encoding type of the DataMatrix.
     * @default 'Auto'
     */
    size: DataMatrixSize;
    /**
     * Defines the DataMatrix rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode: RenderingMode;
    /**
     * Defines the value of the DataMatrix to be rendered.
     * @default undefined
     */
    value: string;
    /**
     * Defines the height of the DataMatrix.
     * @default '100%'
     */
    height: string | number;
    /**
     * Defines the width of the DataMatrix.
     * @default '100%'
     */
    width: string | number;
    /**
     * Defines the text properties for the DataMatrix.
     * @default ''
     */
    displayText: DisplayTextModel;
    /**
     * Defines the margin properties for the DataMatrix.
     * @default ''
     */
    margin: MarginModel;
    /**
     * Defines the background color of the DataMatrix.
     * @default 'white'
     */
    backgroundColor: string;
    /**
     * Triggers if we entered any invalid character
     * @event
     */
    invalid: base.EmitType<Object>;
    /**
     * Defines the forecolor of the DataMatrix.
     * @default 'black'
     */
    foreColor: string;
    /**
     * Defines the xDimension of the DataMatrix.
     */
    xDimension: number;
    /** @private */
    private barcodeRenderer;
    private barcodeCanvas;
    /** @private */
    localeObj: base.L10n;
    /** @private */
    private defaultLocale;
    /**
     * Destroys the the data matrix generator
     */
    destroy(): void;
    private initializePrivateVariables;
    /**
     * Constructor for creating the widget
     */
    constructor(options?: DataMatrixGeneratorModel, element?: HTMLElement | string);
    /**
     * Get the properties to be maintained in the persisted state.
     * @return {string}
     */
    getPersistData(): string;
    /**
     * Returns the module name of the the data matrix generator
     */
    getModuleName(): string;
    private setCulture;
    private getElementSize;
    private initialize;
    private triggerEvent;
    protected preRender(): void;
    onPropertyChanged(newProp: DataMatrixGeneratorModel, oldProp: DataMatrixGeneratorModel): void;
    private checkdata;
    private renderElements;
    /**
     * Renders the barcode control with nodes and connectors
     */
    render(): void;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/datamatrix/index.d.ts
/**
 * Datamatrix component exported items
 */
//node_modules/@syncfusion/ej2-barcode-generator/src/index.d.ts
/**
 * Barcode component exported items
 */
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/index.d.ts
/**
 * Qrcode component exported items
 */
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/qr-barcode-values.d.ts
/**
 * Qrcode used to calculate the Qrcode control
 */
export  class PdfQRBarcodeValues {
    /**
     * Holds the Version Information.
     */
    private mVersion;
    /**
     * Holds the Error Correction Level.
     */
    private mErrorCorrectionLevel;
    /**
     * Holds the Number of Data code word.
     */
    private mNumberOfDataCodeWord;
    /**
     * Holds the Number of Error correcting code words.
     */
    private mNumberOfErrorCorrectingCodeWords;
    /**
     * Holds the Number of Error correction Blocks.
     */
    private mNumberOfErrorCorrectionBlocks;
    /**
     * Holds the End value of the version.
     */
    private mEnd;
    /**
     * Holds the Data copacity of the version.
     */
    private mDataCapacity;
    /**
     * Holds the Format Information.
     */
    private mFormatInformation;
    /**
     * Holds the Version Information.
     */
    private mVersionInformation;
    /**
     * Holds all the values of Error correcting code words.
     */
    private numberOfErrorCorrectingCodeWords;
    /**
     * Hexadecimal values of CP437 characters
     */
    private cp437CharSet;
    /**
     * Hexadecimal values of ISO8859_2 characters
     */
    private iso88592CharSet;
    /**
     * Hexadecimal values of ISO8859_3 characters
     */
    private iso88593CharSet;
    /**
     * Hexadecimal values of ISO8859_4 characters
     */
    private iso88594CharSet;
    /**
     * Hexadecimal values of Windows1250 characters
     */
    private windows1250CharSet;
    /**
     * Hexadecimal values of Windows1251 characters
     */
    private windows1251CharSet;
    /**
     * Hexadecimal values of Windows1252 characters
     */
    private windows1252CharSet;
    /**
     * Hexadecimal values of Windows1256 characters
     */
    private windows1256CharSet;
    /**
     * Equivalent values of CP437 characters
     */
    private cp437ReplaceNumber;
    /**
     * Equivalent values of ISO8859_2 characters
     */
    private iso88592ReplaceNumber;
    /**
     * Equivalent values of ISO8859_3 characters
     */
    private iso88593ReplaceNumber;
    /**
     * Equivalent values of ISO8859_4 characters
     */
    private iso88594ReplaceNumber;
    /**
     * Equivalent values of Windows1250 characters
     */
    private windows1250ReplaceNumber;
    /**
     * Equivalent values of Windows1251 characters
     */
    private windows1251ReplaceNumber;
    /**
     * Equivalent values of Windows1252 characters
     */
    private windows1252ReplaceNumber;
    /**
     * Equivalent values of Windows1256 characters
     */
    private windows1256ReplaceNumber;
    /**
     * Holds all the end values.
     */
    /** @private */
    endValues: number[];
    /**
     * Holds all the Data capacity values.
     */
    /** @private */
    dataCapacityValues: number[];
    /**
     * Holds all  the Numeric Data capacity of the Error correction level Low.
     */
    /** @private */
    numericDataCapacityLow: number[];
    /**
     * Holds all  the Numeric Data capacity of the Error correction level Medium.
     */
    /** @private */
    numericDataCapacityMedium: number[];
    /**
     * Holds all  the Numeric Data capacity of the Error correction level Quartile.
     */
    /** @private */
    numericDataCapacityQuartile: number[];
    /**
     * Holds all  the Numeric Data capacity of the Error correction level High.
     */
    /** @private */
    numericDataCapacityHigh: number[];
    /**
     * Holds all  the Alpha numeric Data capacity of the Error correction level Low.
     */
    /** @private */
    alphanumericDataCapacityLow: number[];
    /**
     * Holds all  the Alpha numeric Data capacity of the Error correction level Medium.
     */
    /** @private */
    alphanumericDataCapacityMedium: number[];
    /**
     * Holds all  the Alpha numeric Data capacity of the Error correction level Quartile.
     */
    /** @private */
    alphanumericDataCapacityQuartile: number[];
    /**
     * Holds all  the Alpha numeric Data capacity of the Error correction level High.
     */
    /** @private */
    alphanumericDataCapacityHigh: number[];
    /**
     * Holds all  the Binary Data capacity of the Error correction level Low.
     */
    /** @private */
    binaryDataCapacityLow: number[];
    /**
     * Holds all  the Binary Data capacity of the Error correction level Medium.
     */
    /** @private */
    binaryDataCapacityMedium: number[];
    /**
     * Holds all  the Binary Data capacity of the Error correction level Quartile.
     */
    /** @private */
    binaryDataCapacityQuartile: number[];
    /**
     * Holds all  the Binary Data capacity of the Error correction level High.
     */
    /** @private */
    binaryDataCapacityHigh: number[];
    /**
     * Holds all  the Mixed Data capacity of the Error correction level Low.
     */
    private mixedDataCapacityLow;
    /**
     * Holds all  the Mixed Data capacity of the Error correction level Medium.
     */
    private mixedDataCapacityMedium;
    /**
     * Holds all  the Mixed Data capacity of the Error correction level Quartile.
     */
    private mixedDataCapacityQuartile;
    /**
     * Holds all  the Mixed Data capacity of the Error correction level High.
     */
    private mixedDataCapacityHigh;
    /**
     * Get or public set the Number of Data code words.
     */
    /** @private */
    /** @private */
    NumberOfDataCodeWord: number;
    /**
     * Get or Private set the Number of Error correction code words.
     */
    /** @private */
    /** @private */
    NumberOfErrorCorrectingCodeWords: number;
    /**
     * Get or Private set the Number of Error correction Blocks.
     */
    /** @private */
    /** @private */
    NumberOfErrorCorrectionBlocks: number[];
    /**
     * Set the End value of the Current Version.
     */
    private End;
    /**
     * Get or Private set the Data capacity.
     */
    private DataCapacity;
    /**
     * Get or Private set the Format Information.
     */
    /** @private */
    /** @private */
    FormatInformation: number[];
    /**
     * Get or Private set the Version Information.
     */
    /** @private */
    /** @private */
    VersionInformation: number[];
    /**
     * Initializes the values
     * @param version - version of the qr code
     * @param errorCorrectionLevel - defines the level of error correction.
     */
    constructor(version: QRCodeVersion, errorCorrectionLevel: ErrorCorrectionLevel);
    /**
     * Gets the Alphanumeric values.
     */
    /** @private */
    getAlphaNumericValues(value: string): number;
    /**
     * Gets number of data code words.
     */
    private obtainNumberOfDataCodeWord;
    /**
     * Get number of Error correction code words.
     */
    private obtainNumberOfErrorCorrectingCodeWords;
    /**
     * Gets number of Error correction Blocks.
     */
    private obtainNumberOfErrorCorrectionBlocks;
    /**
     * Gets the End of the version.
     */
    private obtainEnd;
    /**
     * Gets Data capacity
     */
    private obtainDataCapacity;
    /**
     * Gets format information
     */
    private obtainFormatInformation;
    /**
     * Gets version information
     */
    private obtainVersionInformation;
    /**
     * Gets Numeric Data capacity.
     */
    /** @private */
    getNumericDataCapacity(version: QRCodeVersion, errorCorrectionLevel: ErrorCorrectionLevel): number;
    /**
     * Gets Alphanumeric data capacity.
     */
    /** @private */
    getAlphanumericDataCapacity(version: QRCodeVersion, errorCorrectionLevel: ErrorCorrectionLevel): number;
    /** @private */
    getBinaryDataCapacity(version: QRCodeVersion, errorCorrectionLevel: ErrorCorrectionLevel): number;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/qr-code-util.d.ts
/**
 * Qrcode used to calculate the Qrcode control
 */
export  class QRCode {
    private mVersion;
    private mInputMode;
    private validInput;
    /**
     * Total bits required in mixing mode.
     */
    private totalBits;
    /**
     * Holds the data of Function Pattern.
     */
    private mModuleValue;
    private mDataAllocationValues;
    private mQrBarcodeValues;
    /**
     * Set version for mixing mode.
     */
    private mixVersionERC;
    /**
     * Data to be currently encoded in Mixing Mode
     */
    private mixExecutablePart;
    /**
     * Count of mixing mode blocks.
     */
    private mixDataCount;
    /**
     * Holds the Number of Modules.
     */
    private mNoOfModules;
    /**
     * Check if User Mentioned Mode
     */
    private mIsUserMentionedMode;
    private chooseDefaultMode;
    /** @private */
    text: string;
    private mixRemainingPart;
    private isXdimension;
    private mXDimension;
    /** @private */
    /** @private */
    XDimension: number;
    private inputMode;
    /** @private */
    /** @private */
    version: QRCodeVersion;
    private mIsEci;
    /** @private */
    mIsUserMentionedErrorCorrectionLevel: boolean;
    private isSvgMode;
    private mEciAssignmentNumber;
    /** @private */
    mIsUserMentionedVersion: boolean;
    /** @private */
    mErrorCorrectionLevel: ErrorCorrectionLevel;
    private textList;
    private mode;
    private getBaseAttributes;
    private getInstance;
    private drawImage;
    /** @private */
    draw(char: string, canvas: HTMLElement, height: number, width: number, margin?: MarginModel, displayText?: DisplayTextModel, mode?: boolean, foreColor?: string): boolean;
    private drawText;
    private drawDisplayText;
    private generateValues;
    /**
     * Draw the PDP in the given location
     * @param x - The x co-ordinate.
     * @param y - The y co-ordinate.
     */
    private drawPDP;
    /**
     * Draw the Timing Pattern
     */
    private drawTimingPattern;
    private initialize;
    /**
     * Adds quietzone to the QR Barcode.
     */
    private addQuietZone;
    /**
     * Draw the Format Information
     */
    private drawFormatInformation;
    /**
     * Allocates the Encoded Data and then Mask
     * @param Data - Encoded Data
     */
    private dataAllocationAndMasking;
    /**
     * Allocates Format and Version Information
     */
    private allocateFormatAndVersionInformation;
    /**
     * Draw the Alignment Pattern in the given location
     * @param x - The x co-ordinate
     * @param y - The y co-ordinate
     */
    private drawAlignmentPattern;
    /**
     * Gets the Allignment pattern coordinates of the current version.
     */
    private getAlignmentPatternCoOrdinates;
    /**
     * Encode the Input Data
     */
    private encodeData;
    /**
     * Converts string value to Boolean
     * @param numberInString - The String value
     * @param noOfBits - Number of Bits
     */
    private stringToBoolArray;
    /**
     * Converts Integer value to Boolean
     * @param number - The Integer value
     * @param noOfBits - Number of Bits
     */
    private intToBoolArray;
    /**
     * Splits the Code words
     * @param ds - The Encoded value Blocks
     * @param blk - Index of Block Number
     * @param count - Length of the Block
     */
    private splitCodeWord;
    /**
     * Creates the Blocks
     * @param encodeData - The Encoded value.
     * @param noOfBlocks - Number of Blocks.
     */
    private createBlocks;
}
/** @private */
export  class ModuleValue {
    isBlack: boolean;
    isFilled: boolean;
    isPdp: boolean;
    constructor();
}
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/qr-error-correction.d.ts
/**
 * Qrcode used to calculate the Qrcode control
 */
export  class ErrorCorrectionCodewords {
    /**
     * Holds the length
     */
    private mLength;
    /**
     * Holds the Error Correction Code Word
     */
    private eccw;
    /**
     * Holds the databits
     */
    private databits;
    /**
     * Holds the Data Code word
     */
    private mDataCodeWord;
    /**
     * Holds G(x)
     */
    private gx;
    /**
     * Holds all the values of Alpha
     */
    private alpha;
    /**
     * Holds the Decimal value
     */
    private decimalValue;
    /**
     * Holds the values of QR Barcode
     */
    private mQrBarcodeValues;
    /**
     * Sets and Gets the Data code word
     */
    /** @private */
    DC: string[];
    /**
     * Sets and Gets the DataBits
     */
    /** @private */
    DataBits: number;
    /**
     * Sets and Gets the Error Correction Code Words
     */
    /** @private */
    Eccw: number;
    /**
     * Initializes Error correction code word
     */
    constructor(version: QRCodeVersion, correctionLevel: ErrorCorrectionLevel);
    /**
     * Gets the Error correction code word
     */
    /** @private */
    getErcw(): string[];
    /**
     * Convert to decimal
     * @param inString - is a binary values.
     */
    private toDecimal;
    /**
     * Convert decimal to binary.
     */
    private toBinary;
    /**
     * Polynomial division
     */
    private divide;
    private xORPolynoms;
    private multiplyGeneratorPolynomByLeadterm;
    private convertToDecNotation;
    private convertToAlphaNotation;
    private findLargestExponent;
    private getIntValFromAlphaExp;
    /**
     * Find the element in the alpha
     */
    private findElement;
    /**
     * Gets g(x) of the element
     */
    private getElement;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/qrcode-model.d.ts
/**
 * Interface for a class QRCodeGenerator
 */
export interface QRCodeGeneratorModel extends base.ComponentModel{
    /**
     * Defines the height of the QR code model.
     * @default '100%'
     */
    height?: string | number;
    /**
     * Defines the width of the QR code model.
     * @default '100%'
     */
    width?: string | number;
    /**
     * Defines the QR code rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode?: RenderingMode;
    /**
     * Defines the xDimension of the QR code model.
     */
    xDimension?: number;
    /**
     * Defines the error correction level of the QR code.
     * @blazorDefaultValueIgnore
     * @aspDefaultValueIgnore
     * @aspNumberEnum 
     * @blazorNumberEnum
     * @default undefined
     */
    errorCorrectionLevel?: ErrorCorrectionLevel;
    /**
     * Defines the margin properties for the QR code.
     * @default ''
     */
    margin?: MarginModel;
    /**
     * Defines the background color of the QR code.
     * @default 'white'
     */
    backgroundColor?: string;
    /**
     * Triggers if you enter any invalid character.
     * @event
     */
    invalid?: base.EmitType<Object>;
    /**
     * Defines the forecolor of the QR code.
     * @default 'black'
     */
    foreColor?: string;
    /**
     * Defines the text properties for the QR code.
     * @default ''
     */
    displayText?: DisplayTextModel;
    /**
     * * Defines the version of the QR code.
     * @aspDefaultValueIgnore
     * @blazorNumberEnum
     * @blazorDefaultValueIgnore
     * @aspNumberEnum 
     * @default undefined
     */
    version?: QRCodeVersion;
    /**
     * Defines the type of barcode to be rendered.
     * @default undefined
     */
    value?: string;
}
//node_modules/@syncfusion/ej2-barcode-generator/src/qrcode/qrcode.d.ts
/**
 * Represents the Qrcode control
 * ```
 */
export  class QRCodeGenerator extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * Constructor for creating the widget
     */
    constructor(options?: QRCodeGeneratorModel, element?: HTMLElement | string);
    /**
     * Defines the height of the QR code model.
     * @default '100%'
     */
    height: string | number;
    /**
     * Defines the width of the QR code model.
     * @default '100%'
     */
    width: string | number;
    /**
     * Defines the QR code rendering mode.
     * * SVG - Renders the bar-code objects as SVG elements
     * * Canvas - Renders the bar-code in a canvas
     * @default 'SVG'
     */
    mode: RenderingMode;
    /**
     * Defines the xDimension of the QR code model.
     */
    xDimension: number;
    /**
     * Defines the error correction level of the QR code.
     * @blazorDefaultValueIgnore
     * @aspDefaultValueIgnore
     * @aspNumberEnum
     * @blazorNumberEnum
     * @default undefined
     */
    errorCorrectionLevel: ErrorCorrectionLevel;
    /**
     * Defines the margin properties for the QR code.
     * @default ''
     */
    margin: MarginModel;
    /**
     * Defines the background color of the QR code.
     * @default 'white'
     */
    backgroundColor: string;
    /**
     * Triggers if you enter any invalid character.
     * @event
     */
    invalid: base.EmitType<Object>;
    /**
     * Defines the forecolor of the QR code.
     * @default 'black'
     */
    foreColor: string;
    /**
     * Defines the text properties for the QR code.
     * @default ''
     */
    displayText: DisplayTextModel;
    /**
     * * Defines the version of the QR code.
     * @aspDefaultValueIgnore
     * @blazorNumberEnum
     * @blazorDefaultValueIgnore
     * @aspNumberEnum
     * @default undefined
     */
    version: QRCodeVersion;
    private widthChange;
    private heightChange;
    private isSvgMode;
    private barcodeRenderer;
    /**
     * Defines the type of barcode to be rendered.
     * @default undefined
     */
    value: string;
    /** @private */
    localeObj: base.L10n;
    /** @private */
    private defaultLocale;
    private barcodeCanvas;
    /**
     * Renders the barcode control with nodes and connectors
     */
    render(): void;
    private triggerEvent;
    private renderElements;
    private setCulture;
    private getElementSize;
    private initialize;
    protected preRender(): void;
    /**
     * Get the properties to be maintained in the persisted state.
     * @return {string}
     */
    getPersistData(): string;
    /**
     * Returns the module name of the barcode
     */
    getModuleName(): string;
    /**
     * Destroys the barcode control
     */
    destroy(): void;
    private initializePrivateVariables;
    onPropertyChanged(newProp: QRCodeGeneratorModel, oldProp: QRCodeGeneratorModel): void;
}
 }
export namespace base { 

//node_modules/@syncfusion/ej2-base/src/ajax.d.ts
/**
 * Ajax class provides ability to make asynchronous HTTP request to the server
 * ```typescript
 *   var ajax = new Ajax("index.html", "GET", true);
 *   ajax.send().then(
 *               function (value) {
 *                   console.log(value);
 *               },
 *               function (reason) {
 *                   console.log(reason);
 *               });
 * ```
 */
export  class Ajax {
    /**
     * Specifies the URL to which request to be sent.
     * @default null
     */
    url: string;
    /**
     * Specifies which HTTP request method to be used. For ex., GET, POST
     * @default GET
     */
    type: string;
    /**
     * Specifies the data to be sent.
     * @default null
     */
    data: string | Object;
    /**
     * A boolean value indicating whether the request should be sent asynchronous or not.
     * @default true
     */
    mode: boolean;
    /**
     * Specifies the callback for creating the XMLHttpRequest object.
     * @default null
     */
    httpRequest: XMLHttpRequest;
    /**
     * A boolean value indicating whether to ignore the promise reject.
     * @private
     * @default true
     */
    emitError: boolean;
    private options;
    onLoad: (this: XMLHttpRequest, ev: Event) => Object;
    onProgress: (this: XMLHttpRequest, ev: Event) => Object;
    onError: (this: XMLHttpRequest, ev: Event) => Object;
    onAbort: (this: XMLHttpRequest, ev: Event) => Object;
    onUploadProgress: (this: XMLHttpRequest, ev: Event) => Object;
    private contentType;
    private dataType;
    /**
     * Constructor for Ajax class
     * @param  {string|Object} options?
     * @param  {string} type?
     * @param  {boolean} async?
     * @returns defaultType
     */
    constructor(options?: string | Object, type?: string, async?: boolean, contentType?: string);
    /**
     * Send the request to server.
     * @param {any} data - To send the user data
     * @return {Promise}
     */
    send(data?: string | Object): Promise<Ajax>;
    /**
     * Specifies the callback function to be triggered before sending request to sever.
     * This can be used to modify the XMLHttpRequest object before it is sent.
     * @event
     */
    beforeSend: Function;
    /**
     * Specifies callback function to be triggered after XmlHttpRequest is succeeded.
     * The callback will contain server response as the parameter.
     * @event
     */
    onSuccess: Function;
    /**
     * Triggers when XmlHttpRequest is failed.
     * @event
     */
    onFailure: Function;
    private successHandler;
    private failureHandler;
    private stateChange;
    /**
     * To get the response header from XMLHttpRequest
     * @param  {string} key Key to search in the response header
     * @returns {string}
     */
    getResponseHeader(key: string): string;
}
export interface HeaderOptions {
    readyState?: number;
    getResponseHeader?: Function;
    setRequestHeader?: Function;
    overrideMimeType?: Function;
}
/**
 * Specifies the ajax beforeSend event arguments
 * @event
 */
export interface BeforeSendEventArgs {
    /** To cancel the ajax request in beforeSend */
    cancel?: boolean;
    /** Returns the request sent from the client end */
    httpRequest?: XMLHttpRequest;
}
//node_modules/@syncfusion/ej2-base/src/animation-model.d.ts
/**
 * Interface for a class Animation
 */
export interface AnimationModel {
    /**
     * Specify the type of animation
     * @default : 'FadeIn';
     */
    name?: Effect;
    /**
     * Specify the duration to animate
     * @default : 400;
     */
    duration?: number;
    /**
     * Specify the animation timing function
     * @default : 'ease';
     */
    timingFunction?: string;
    /**
     * Specify the delay to start animation
     * @default : 0;
     */
    delay?: number;
    /**
     * Triggers when animation is in-progress
     * @event
     */
    progress?: EmitType<AnimationOptions>;
    /**
     * Triggers when the animation is started
     * @event
     */
    begin?: EmitType<AnimationOptions>;
    /**
     * Triggers when animation is completed
     * @event
     */
    end?: EmitType<AnimationOptions>;
    /**
     * Triggers when animation is failed due to any scripts
     * @event
     */
    fail?: EmitType<AnimationOptions>;
}
//node_modules/@syncfusion/ej2-base/src/animation.d.ts
/**
 * Animation effect names
 */
export  type Effect = 'FadeIn' | 'FadeOut' | 'FadeZoomIn' | 'FadeZoomOut' | 'FlipLeftDownIn' | 'FlipLeftDownOut' | 'FlipLeftUpIn' | 'FlipLeftUpOut' | 'FlipRightDownIn' | 'FlipRightDownOut' | 'FlipRightUpIn' | 'FlipRightUpOut' | 'FlipXDownIn' | 'FlipXDownOut' | 'FlipXUpIn' | 'FlipXUpOut' | 'FlipYLeftIn' | 'FlipYLeftOut' | 'FlipYRightIn' | 'FlipYRightOut' | 'SlideBottomIn' | 'SlideBottomOut' | 'SlideDown' | 'SlideLeft' | 'SlideLeftIn' | 'SlideLeftOut' | 'SlideRight' | 'SlideRightIn' | 'SlideRightOut' | 'SlideTopIn' | 'SlideTopOut' | 'SlideUp' | 'ZoomIn' | 'ZoomOut';
/**
 * The Animation framework provide options to animate the html DOM elements
 * ```typescript
 *   let animeObject = new Animation({
 *      name: 'SlideLeftIn',
 *      duration: 1000
 *   });
 *   animeObject.animate('#anime1');
 *   animeObject.animate('#anime2', { duration: 500 });
 * ```
 */
export  class Animation extends Base<HTMLElement> implements INotifyPropertyChanged {
    /**
     * Specify the type of animation
     * @default : 'FadeIn';
     */
    name: Effect;
    /**
     * Specify the duration to animate
     * @default : 400;
     */
    duration: number;
    /**
     * Specify the animation timing function
     * @default : 'ease';
     */
    timingFunction: string;
    /**
     * Specify the delay to start animation
     * @default : 0;
     */
    delay: number;
    /**
     * Triggers when animation is in-progress
     * @event
     */
    progress: EmitType<AnimationOptions>;
    /**
     * Triggers when the animation is started
     * @event
     */
    begin: EmitType<AnimationOptions>;
    /**
     * Triggers when animation is completed
     * @event
     */
    end: EmitType<AnimationOptions>;
    /**
     * Triggers when animation is failed due to any scripts
     * @event
     */
    fail: EmitType<AnimationOptions>;
    /**
     * @private
     */
    easing: {
        [key: string]: string;
    };
    constructor(options: AnimationModel);
    /**
     * Applies animation to the current element.
     * @param {string | HTMLElement} element - Element which needs to be animated.
     * @param {AnimationModel} options - Overriding default animation settings.
     * @return {void}
     */
    animate(element: string | HTMLElement, options?: AnimationModel): void;
    /**
     * Stop the animation effect on animated element.
     * @param {HTMLElement} element - Element which needs to be stop the animation.
     * @param {AnimationOptions} model - Handling the animation model at stop function.
     * @return {void}
     */
    static stop(element: HTMLElement, model?: AnimationOptions): void;
    /**
     * Set delay to animation element
     * @param {AnimationModel} model
     * @returns {void}
     */
    private static delayAnimation;
    /**
     * Triggers animation
     * @param {AnimationModel} model
     * @returns {void}
     */
    private static applyAnimation;
    /**
     * Returns Animation Model
     * @param {AnimationModel} options
     * @returns {AnimationModel}
     */
    private getModel;
    /**
     * @private
     */
    onPropertyChanged(newProp: AnimationModel, oldProp: AnimationModel): void;
    /**
     * Returns module name as animation
     * @private
     */
    getModuleName(): string;
    /**
     * @private
     */
    destroy(): void;
}
/**
 * Animation event argument for progress event handler
 */
export interface AnimationOptions extends AnimationModel {
    /**
     * Get current time-stamp in progress EventHandler
     */
    timeStamp?: number;
    /**
     * Get current animation element in progress EventHandler
     */
    element?: HTMLElement;
}
/**
 * Ripple provides material theme's wave effect when an element is clicked
 * ```html
 * <div id='ripple'></div>
 * <script>
 *   rippleEffect(document.getElementById('ripple'));
 * </script>
 * ```
 * @private
 * @param HTMLElement element - Target element
 * @param RippleOptions rippleOptions - Ripple options .
 */
export  function rippleEffect(element: HTMLElement, rippleOptions?: RippleOptions, done?: Function): () => void;
/**
 * Ripple method arguments to handle ripple effect
 * @private
 */
export interface RippleOptions {
    /**
     * Get selector child elements for ripple effect
     */
    selector?: string;
    /**
     * Get ignore elements to prevent ripple effect
     */
    ignore?: string;
    /**
     * Override the enableRipple method
     */
    rippleFlag?: boolean;
    /**
     * Set ripple effect from center position
     */
    isCenterRipple?: boolean;
    /**
     * Set ripple duration
     */
    duration?: number;
}
export  let isRippleEnabled: boolean;
/**
 * Animation Module provides support to enable ripple effect functionality to Essential JS 2 components.
 * @param {boolean} isRipple Specifies the boolean value to enable or disable ripple effect.
 * @returns {boolean}
 */
export  function enableRipple(isRipple: boolean): boolean;
//node_modules/@syncfusion/ej2-base/src/base.d.ts
export interface DomElements extends HTMLElement {
    ej2_instances: Object[];
}
export interface AngularEventEmitter {
    subscribe?: (generatorOrNext?: any, error?: any, complete?: any) => any;
}
export  type EmitType<T> = AngularEventEmitter & ((arg?: T, ...rest: any[]) => void);
/**
 * Base library module is common module for Framework modules like touch,keyboard and etc.,
 * @private
 */
export  abstract class Base<ElementType extends HTMLElement> {
    element: ElementType;
    isDestroyed: boolean;
    protected isProtectedOnChange: boolean;
    protected properties: {
        [key: string]: Object;
    };
    protected changedProperties: {
        [key: string]: Object;
    };
    protected oldProperties: {
        [key: string]: Object;
    };
    protected refreshing: boolean;
    protected finalUpdate: Function;
    protected modelObserver: Observer;
    protected childChangedProperties: {
        [key: string]: Object;
    };
    protected abstract getModuleName(): string;
    protected abstract onPropertyChanged(newProperties: Object, oldProperties?: Object): void;
    /** Property base section */
    /**
     * Function used to set bunch of property at a time.
     * @private
     * @param  {Object} prop - JSON object which holds components properties.
     * @param  {boolean} muteOnChange? - Specifies to true when we set properties.
     */
    setProperties(prop: Object, muteOnChange?: boolean): void;
    /**
     * Calls for child element data bind
     * @param {Object} obj
     * @param {Object} parent
     * @returns {void}
     */
    private static callChildDataBind;
    protected clearChanges(): void;
    /**
     * Bind property changes immediately to components
     */
    dataBind(): void;
    protected saveChanges(key: string, newValue: string, oldValue: string): void;
    /** Event Base Section */
    /**
     * Adds the handler to the given event listener.
     * @param {string} eventName - A String that specifies the name of the event
     * @param {Function} listener - Specifies the call to run when the event occurs.
     * @return {void}
     */
    addEventListener(eventName: string, handler: Function): void;
    /**
     * Removes the handler from the given event listener.
     * @param {string} eventName - A String that specifies the name of the event to remove
     * @param {Function} listener - Specifies the function to remove
     * @return {void}
     */
    removeEventListener(eventName: string, handler: Function): void;
    /**
     * Triggers the handlers in the specified event.
     * @private
     * @param {string} eventName - Specifies the event to trigger for the specified component properties.
     * Can be a custom event, or any of the standard events.
     * @param {Event} eventProp - Additional parameters to pass on to the event properties
     * @param {Function} successHandler - this function will invoke after event successfully triggered
     * @param {Function} errorHandler - this function will invoke after event if it failured to call.
     * @return {void}
     */
    trigger(eventName: string, eventProp?: Object, successHandler?: Function, errorHandler?: Function): void | object;
    /**
     * Base constructor accept options and element
     */
    constructor(options: Object, element: ElementType | string);
    /**
     * To maintain instance in base class
     */
    protected addInstance(): void;
    /**
     * To remove the instance from the element
     */
    protected destroy(): void;
}
/**
 * Global function to get the component instance from the rendered element.
 * @param elem Specifies the HTMLElement or element id string.
 * @param comp Specifies the component module name or Component.
 */
export  function getComponent<T>(elem: HTMLElement | string, comp: string | any | T): T;
//node_modules/@syncfusion/ej2-base/src/browser.d.ts
/**
 * Get configuration details for Browser
 * @private
 */
export  class Browser {
    private static uA;
    private static extractBrowserDetail;
    /**
     * To get events from the browser
     * @param {string} event - type of event triggered.
     * @returns {Boolean}
     */
    private static getEvent;
    /**
     * To get the Touch start event from browser
     * @returns {string}
     */
    private static getTouchStartEvent;
    /**
     * To get the Touch end event from browser
     * @returns {string}
     */
    private static getTouchEndEvent;
    /**
     * To get the Touch move event from browser
     * @returns {string}
     */
    private static getTouchMoveEvent;
    /**
     * To cancel the touch event from browser
     * @returns {string}
     */
    private static getTouchCancelEvent;
    /**
     * To get the value based on provided key and regX
     * @param {string} key
     * @param {RegExp} regX
     * @returns {Object}
     */
    private static getValue;
    /**
     * Property specifies the userAgent of the browser. Default userAgent value is based on the browser.
     * Also we can set our own userAgent.
     */
    static userAgent: string;
    /**
     * Property is to get the browser information like Name, Version and Language
     * @returns BrowserInfo
     */
    static readonly info: BrowserInfo;
    /**
     * Property is to get whether the userAgent is based IE.
     */
    static readonly isIE: Boolean;
    /**
     * Property is to get whether the browser has touch support.
     */
    static readonly isTouch: Boolean;
    /**
     * Property is to get whether the browser has Pointer support.
     */
    static readonly isPointer: Boolean;
    /**
     * Property is to get whether the browser has MSPointer support.
     */
    static readonly isMSPointer: Boolean;
    /**
     * Property is to get whether the userAgent is device based.
     */
    static readonly isDevice: Boolean;
    /**
     * Property is to get whether the userAgent is IOS.
     */
    static readonly isIos: Boolean;
    /**
     * Property is to get whether the userAgent is Ios7.
     */
    static readonly isIos7: Boolean;
    /**
     * Property is to get whether the userAgent is Android.
     */
    static readonly isAndroid: Boolean;
    /**
     * Property is to identify whether application ran in web view.
     */
    static readonly isWebView: Boolean;
    /**
     * Property is to get whether the userAgent is Windows.
     */
    static readonly isWindows: Boolean;
    /**
     * Property is to get the touch start event. It returns event name based on browser.
     */
    static readonly touchStartEvent: string;
    /**
     * Property is to get the touch move event. It returns event name based on browser.
     */
    static readonly touchMoveEvent: string;
    /**
     * Property is to get the touch end event. It returns event name based on browser.
     */
    static readonly touchEndEvent: string;
    /**
     * Property is to cancel the touch end event.
     */
    static readonly touchCancelEvent: string;
}
export interface BrowserDetails {
    isAndroid?: Boolean;
    isDevice?: Boolean;
    isIE?: Boolean;
    isIos?: Boolean;
    isIos7?: Boolean;
    isMSPointer?: Boolean;
    isPointer?: Boolean;
    isTouch?: Boolean;
    isWebView?: Boolean;
    isWindows?: Boolean;
    info?: BrowserInfo;
    touchStartEvent?: string;
    touchMoveEvent?: string;
    touchEndEvent?: string;
    touchCancelEvent?: string;
}
export interface BrowserInfo {
    name?: string;
    version?: string;
    culture?: {
        name?: string;
        language?: string;
    };
}
//node_modules/@syncfusion/ej2-base/src/child-property.d.ts
/**
 * To detect the changes for inner properties.
 * @private
 */
export  class ChildProperty<T> {
    private parentObj;
    private controlParent;
    private propName;
    private isParentArray;
    protected properties: {
        [key: string]: Object;
    };
    protected changedProperties: {
        [key: string]: Object;
    };
    protected childChangedProperties: {
        [key: string]: Object;
    };
    protected oldProperties: {
        [key: string]: Object;
    };
    protected finalUpdate: Function;
    private callChildDataBind;
    constructor(parent: T, propName: string, defaultValue: Object, isArray?: boolean);
    /**
     * Updates the property changes
     * @param {boolean} val
     * @param {string} propName
     * @returns {void}
     */
    private updateChange;
    /**
     * Updates time out duration
     */
    private updateTimeOut;
    /**
     * Clears changed properties
     */
    private clearChanges;
    /**
     * Set property changes
     * @param {Object} prop
     * @param {boolean} muteOnChange
     * {void}
     */
    protected setProperties(prop: Object, muteOnChange: boolean): void;
    /**
     * Binds data
     */
    protected dataBind(): void;
    /**
     * Saves changes to newer values
     * @param {string} key
     * @param {Object} newValue
     * @param {Object} oldValue
     * @returns {void}
     */
    protected saveChanges(key: string, newValue: Object, oldValue: Object): void;
}
//node_modules/@syncfusion/ej2-base/src/component-model.d.ts
/**
 * Interface for a class Component
 */
export interface ComponentModel {
    /**
     * Enable or disable persisting component's state between page reloads.
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * Enable or disable rendering component in right to left direction.
     * @default false
     */
    enableRtl?: boolean;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @default ''
     */
    locale?: string;
}
//node_modules/@syncfusion/ej2-base/src/component.d.ts
/**
 * Base class for all Essential JavaScript components
 */
export  abstract class Component<ElementType extends HTMLElement> extends Base<ElementType> {
    element: ElementType;
    private randomId;
    /**
     * Enable or disable persisting component's state between page reloads.
     * @default false
     */
    enablePersistence: boolean;
    /**
     * Enable or disable rendering component in right to left direction.
     * @default false
     */
    enableRtl: boolean;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @default ''
     */
    locale: string;
    /**
     * string template option for Blazor template rendering
     * @private
     */
    isStringTemplate: boolean;
    protected needsID: boolean;
    protected moduleLoader: ModuleLoader;
    protected localObserver: Observer;
    protected abstract render(): void;
    protected abstract preRender(): void;
    protected abstract getPersistData(): string;
    protected injectedModules: Function[];
    protected requiredModules(): ModuleDeclaration[];
    protected isRendered: boolean;
    /**
     * Destroys the sub modules while destroying the widget
     */
    protected destroy(): void;
    /**
     * Applies all the pending property changes and render the component again.
     */
    refresh(): void;
    /**
     * Appends the control within the given HTML element
     * @param {string | HTMLElement} selector - Target element where control needs to be appended
     */
    appendTo(selector?: string | HTMLElement): void;
    /**
     * It is used to process the post rendering functionalities to a component.
     */
    protected renderComplete(wrapperElement?: Node): void;
    /**
     * When invoked, applies the pending property changes immediately to the component.
     */
    dataBind(): void;
    /**
     * Attach one or more  event handler to the current component context.
     * It is used for internal handling event internally within the component only.
     * @param {BoundOptions[]| string} event - It is  optional type either to  Set the collection of event list or the eventName.
     * @param {Function} handler - optional parameter Specifies the handler to run when the event occurs
     * @param {Object} context - optional parameter Specifies the context to be bind in the handler.
     * @return {void}
     * @private
     */
    on(event: BoundOptions[] | string, handler?: Function, context?: Object): void;
    /**
     * To remove one or more event handler that has been attached with the on() method.
     * @param {BoundOptions[]| string} event - It is  optional type either to  Set the collection of event list or the eventName.
     * @param {Function} handler - optional parameter Specifies the function to run when the event occurs
     * @return {void}
     * @private
     */
    off(event: BoundOptions[] | string, handler?: Function): void;
    /**
     * To notify the handlers in the specified event.
     * @param {string} property - Specifies the event to be notify.
     * @param {Object} argument - Additional parameters to pass while calling the handler.
     * @return {void}
     * @private
     */
    notify(property: string, argument: Object): void;
    /**
     * Get injected modules
     * @private
     */
    getInjectedModules(): Function[];
    /**
     * Dynamically injects the required modules to the component.
     */
    static Inject(...moduleList: Function[]): void;
    /**
     * Initialize the constructor for component base
     */
    constructor(options?: Object, selector?: string | ElementType);
    /**
     * This is a instance method to create an element.
     * @private
     */
    createElement: (tag: string, prop?: {
        id?: string;
        className?: string;
        innerHTML?: string;
        styles?: string;
        attrs?: {
            [key: string]: string;
        };
    }) => HTMLElement;
    private injectModules;
    private detectFunction;
    private mergePersistData;
    private setPersistData;
    protected clearTemplate(templateName?: string[], index?: any): void;
    private getUniqueID;
    private pageID;
    private isHistoryChanged;
    protected addOnPersist(options: string[]): string;
    protected getActualProperties<T>(obj: T): T;
    protected ignoreOnPersist(options: string[]): string;
    protected iterateJsonProperties(obj: {
        [key: string]: Object;
    }, ignoreList: string[]): Object;
}
//node_modules/@syncfusion/ej2-base/src/dom.d.ts
/**
 * Function to create Html element.
 * @param tagName - Name of the tag, id and class names.
 * @param properties - Object to set properties in the element.
 * @param properties.id - To set the id to the created element.
 * @param properties.className - To add classes to the element.
 * @param properties.innerHTML - To set the innerHTML to element.
 * @param properties.styles - To set the some custom styles to element.
 * @param properties.attrs - To set the attributes to element.
 * @private
 */
export  function createElement(tagName: string, properties?: {
    id?: string;
    className?: string;
    innerHTML?: string;
    styles?: string;
    attrs?: {
        [key: string]: string;
    };
}): HTMLElement;
/**
 * The function used to add the classes to array of elements
 * @param  {Element[]|NodeList} elements - An array of elements that need to add a list of classes
 * @param  {string|string[]} classes - String or array of string that need to add an individual element as a class
 * @private
 */
export  function addClass(elements: Element[] | NodeList, classes: string | string[]): Element[] | NodeList;
/**
 * The function used to add the classes to array of elements
 * @param  {Element[]|NodeList} elements - An array of elements that need to remove a list of classes
 * @param  {string|string[]} classes - String or array of string that need to add an individual element as a class
 * @private
 */
export  function removeClass(elements: Element[] | NodeList, classes: string | string[]): Element[] | NodeList;
/**
 * The function used to check element is visible or not.
 * @param  {Element|Node} element - An element the need to check visibility
 * @private
 */
export  function isVisible(element: Element | Node): Boolean;
/**
 * The function used to insert an array of elements into a first of the element.
 * @param  {Element[]|NodeList} fromElements - An array of elements that need to prepend.
 * @param  {Element} toElement - An element that is going to prepend.
 * @private
 */
export  function prepend(fromElements: Element[] | NodeList, toElement: Element, isEval?: Boolean): Element[] | NodeList;
/**
 * The function used to insert an array of elements into last of the element.
 * @param  {Element[]|NodeList} fromElements - An array of elements that need to append.
 * @param  {Element} toElement - An element that is going to prepend.
 * @private
 */
export  function append(fromElements: Element[] | NodeList, toElement: Element, isEval?: Boolean): Element[] | NodeList;
/**
 * The function used to remove the element from the
 * @param  {Element|Node|HTMLElement} element - An element that is going to detach from the Dom
 * @private
 */
export  function detach(element: Element | Node | HTMLElement): Element;
/**
 * The function used to remove the element from Dom also clear the bounded events
 * @param  {Element|Node|HTMLElement} element - An element remove from the Dom
 * @private
 */
export  function remove(element: Element | Node | HTMLElement): void;
/**
 * The function helps to set multiple attributes to an element
 * @param  {Element|Node} element - An element that need to set attributes.
 * @param  {{[key:string]:string}} attributes - JSON Object that is going to as attributes.
 * @private
 */
export  function attributes(element: Element | Node, attributes: {
    [key: string]: string;
}): Element;
/**
 * The function selects the element from giving context.
 * @param  {string} selector - Selector string need fetch element from the
 * @param  {Document|Element=document} context - It is an optional type, That specifies a Dom context.
 * @private
 */
export  function select(selector: string, context?: Document | Element): Element;
/**
 * The function selects an array of element from the given context.
 * @param  {string} selector - Selector string need fetch element from the
 * @param  {Document|Element=document} context - It is an optional type, That specifies a Dom context.
 * @private
 */
export  function selectAll(selector: string, context?: Document | Element): HTMLElement[];
/**
 * Returns single closest parent element based on class selector.
 * @param  {Element} element - An element that need to find the closest element.
 * @param  {string} selector - A classSelector of closest element.
 * @private
 */
export  function closest(element: Element | Node, selector: string): Element;
/**
 * Returns all sibling elements of the given element.
 * @param  {Element|Node} element - An element that need to get siblings.
 * @private
 */
export  function siblings(element: Element | Node): Element[];
/**
 * set the value if not exist. Otherwise set the existing value
 * @param  {HTMLElement} element - An element to which we need to set value.
 * @param  {string} property - Property need to get or set.
 * @param  {string} value - value need to set.
 * @private
 */
export  function getAttributeOrDefault(element: HTMLElement, property: string, value: string): string;
/**
 * Set the style attributes to Html element.
 * @param {HTMLElement} element - Element which we want to set attributes
 * @param {any} attrs - Set the given attributes to element
 * @return {void}
 * @private
 */
export  function setStyleAttribute(element: HTMLElement, attrs: {
    [key: string]: Object;
}): void;
/**
 * Method for add and remove classes to a dom element.
 * @param {Element} element - Element for add and remove classes
 * @param {string[]} addClasses - List of classes need to be add to the element
 * @param {string[]} removeClasses - List of classes need to be remove from the element
 * @return {void}
 * @private
 */
export  function classList(element: Element, addClasses: string[], removeClasses: string[]): void;
/**
 * Method to check whether the element matches the given selector.
 * @param {Element} element - Element to compare with the selector.
 * @param {string} selector - String selector which element will satisfy.
 * @return {void}
 * @private
 */
export  function matches(element: Element, selector: string): boolean;
//node_modules/@syncfusion/ej2-base/src/draggable-model.d.ts
/**
 * Interface for a class Position
 */
export interface PositionModel {
    /**
     * Specifies the left position of cursor in draggable.
     */
    left?: number;
    /**
     * Specifies the left position of cursor in draggable.
     */
    top?: number;
}
/**
 * Interface for a class Draggable
 */
export interface DraggableModel {
    /**
     * Defines the distance between the cursor and the draggable element.
     */
    cursorAt?: PositionModel;
    /**
     * If `clone` set to true, drag operations are performed in duplicate element of the draggable element. 
     * @default true
     */
    clone?: boolean;
    /**
     * Defines the parent  element in which draggable element movement will be restricted.
     */
    dragArea?: HTMLElement | string;
    /**
     * Defines the dragArea is scrollable or not.
     */
    isDragScroll?: boolean;
    /**
     * Specifies the callback function for drag event.
     * @event
     */
    drag?: Function;
    /**
     * Specifies the callback function for dragStart event.
     * @event
     */
    dragStart?: Function;
    /**
     * Specifies the callback function for dragStop event.
     * @event
     */
    dragStop?: Function;
    /**
     * Defines the minimum distance draggable element to be moved to trigger the drag operation.
     * @default 1
     */
    distance?: number;
    /**
     * Defines the child element selector which will act as drag handle.
     */
    handle?: string;
    /**
     * Defines the child element selector which will prevent dragging of element.
     */
    abort?: string;
    /**
     * Defines the callback function for customizing the cloned  element.
     */
    helper?: Function;
    /**
     * Defines the scope value to group sets of draggable and droppable items. 
     * A draggable with the same scope value will be accepted by the droppable.
     */
    scope?: string;
    /**
     * Specifies the dragTarget by which the clone element is positioned if not given current context element will be considered.
     * @private
     */
    dragTarget?: string;
    /**
     * Defines the axis to limit the draggable element drag path.The possible axis path values are   
     * * `x` - Allows drag movement in horizontal direction only. 
     * * `y` - Allows drag movement in vertical direction only.
     */
    axis?: DragDirection;
    /**
     * Defines the function to change the position value.
     * @private
     */
    queryPositionInfo?: Function;
    /**
     * Defines whether the drag clone element will be split form the cursor pointer.
     * @private
     */
    enableTailMode?: boolean;
    /**
     * Defines whether to skip the previous drag movement comparison.
     * @private
     */
    skipDistanceCheck?: boolean;
    /**
     * @private
     */
    preventDefault?: boolean;
    /**
     * Defines whether to enable autoscroll on drag movement of draggable element.
     * enableAutoScroll
     * @private
     */
    enableAutoScroll?: boolean;
    /**
     * Defines whether to enable taphold  on mobile devices.
     * enableAutoScroll
     * @private
     */
    enableTapHold?: boolean;
    /**
     * Specifies the time delay for tap hold.
     * @default 750
     *  @private
     */
    tapHoldThreshold?: number;
}
//node_modules/@syncfusion/ej2-base/src/draggable.d.ts
/**
 * Specifies the Direction in which drag movement happen.
 */
export  type DragDirection = 'x' | 'y';
/**
 * Specifies the position coordinates
 */
export  class Position extends ChildProperty<Position> {
    /**
     * Specifies the left position of cursor in draggable.
     */
    left: number;
    /**
     * Specifies the left position of cursor in draggable.
     */
    top: number;
}
/**
 * Coordinates for element position
 * @private
 */
export interface Coordinates {
    /**
     * Defines the x Coordinate of page.
     */
    pageX: number;
    /**
     * Defines the y Coordinate of page.
     */
    pageY: number;
    /**
     * Defines the x Coordinate of client.
     */
    clientX: number;
    /**
     * Defines the y Coordinate of client.
     */
    clientY: number;
}
/**
 * Interface to specify the drag data in the droppable.
 */
export interface DropInfo {
    /**
     * Specifies the current draggable element
     */
    draggable?: HTMLElement;
    /**
     * Specifies the current helper element.
     */
    helper?: HTMLElement;
    /**
     * Specifies the drag target element
     */
    draggedElement?: HTMLElement;
}
export interface DropObject {
    target: HTMLElement;
    instance: DropOption;
}
/**
 * Used to access values
 * @private
 */
export interface DragPosition {
    left?: string;
    top?: string;
}
/**
 * Used for accessing the interface.
 * @private
 */
export interface Instance extends HTMLElement {
    /**
     * Specifies current instance collection in element
     */
    ej2_instances: {
        [key: string]: Object;
    }[];
}
/**
 * Droppable function to be invoked from draggable
 * @private
 */
export interface DropOption {
    /**
     * Used to triggers over function while draggable element is over the droppable element.
     */
    intOver: Function;
    /**
     * Used to triggers out function while draggable element is out of the droppable element.
     */
    intOut: Function;
    /**
     * Used to triggers  out function while draggable element is dropped on the droppable element.
     */
    intDrop: Function;
    /**
     * Specifies the information about the drag element.
     */
    dragData: DropInfo;
    /**
     * Specifies the status of the drag of drag stop calling.
     */
    dragStopCalled: boolean;
}
/**
 * Drag Event arguments
 */
export interface DragEventArgs {
    /**
     * Specifies the actual event.
     */
    event?: MouseEvent & TouchEvent;
    /**
     * Specifies the current drag element.
     */
    element?: HTMLElement;
    /**
     * Specifies the current target element.
     */
    target?: HTMLElement;
}
/**
 * Used for accessing the BlazorEventArgs.
 * @private
 */
export interface BlazorDragEventArgs {
    /**
     * bind draggable element for Blazor Components
     */
    bindEvents: Function;
    /**
     * Draggable element to which draggable events are to be binded in Blazor.
     */
    dragElement: HTMLElement;
}
/**
 * Draggable Module provides support to enable draggable functionality in Dom Elements.
 * ```html
 * <div id='drag'>Draggable</div>
 * <script>
 * var ele = document.getElementById('drag');
 * var drag:Draggable = new Draggable(ele,{
 *     clone:false,
 *     drag: function(e) {
 *      //drag handler code.
 *      },
 *     handle:'.class'
 * });
 * </script>
 * ```
 */
export  class Draggable extends Base<HTMLElement> implements INotifyPropertyChanged {
    /**
     * Defines the distance between the cursor and the draggable element.
     */
    cursorAt: PositionModel;
    /**
     * If `clone` set to true, drag operations are performed in duplicate element of the draggable element.
     * @default true
     */
    clone: boolean;
    /**
     * Defines the parent  element in which draggable element movement will be restricted.
     */
    dragArea: HTMLElement | string;
    /**
     * Defines the dragArea is scrollable or not.
     */
    isDragScroll: boolean;
    /**
     * Specifies the callback function for drag event.
     * @event
     */
    drag: Function;
    /**
     * Specifies the callback function for dragStart event.
     * @event
     */
    dragStart: Function;
    /**
     * Specifies the callback function for dragStop event.
     * @event
     */
    dragStop: Function;
    /**
     * Defines the minimum distance draggable element to be moved to trigger the drag operation.
     * @default 1
     */
    distance: number;
    /**
     * Defines the child element selector which will act as drag handle.
     */
    handle: string;
    /**
     * Defines the child element selector which will prevent dragging of element.
     */
    abort: string;
    /**
     * Defines the callback function for customizing the cloned  element.
     */
    helper: Function;
    /**
     * Defines the scope value to group sets of draggable and droppable items.
     * A draggable with the same scope value will be accepted by the droppable.
     */
    scope: string;
    /**
     * Specifies the dragTarget by which the clone element is positioned if not given current context element will be considered.
     * @private
     */
    dragTarget: string;
    /**
     * Defines the axis to limit the draggable element drag path.The possible axis path values are
     * * `x` - Allows drag movement in horizontal direction only.
     * * `y` - Allows drag movement in vertical direction only.
     */
    axis: DragDirection;
    /**
     * Defines the function to change the position value.
     * @private
     */
    queryPositionInfo: Function;
    /**
     * Defines whether the drag clone element will be split form the cursor pointer.
     * @private
     */
    enableTailMode: boolean;
    /**
     * Defines whether to skip the previous drag movement comparison.
     * @private
     */
    skipDistanceCheck: boolean;
    /**
     * @private
     */
    preventDefault: boolean;
    /**
     * Defines whether to enable autoscroll on drag movement of draggable element.
     * enableAutoScroll
     * @private
     */
    enableAutoScroll: boolean;
    /**
     * Defines whether to enable taphold  on mobile devices.
     * enableAutoScroll
     * @private
     */
    enableTapHold: boolean;
    /**
     * Specifies the time delay for tap hold.
     * @default 750
     *  @private
     */
    tapHoldThreshold: number;
    private target;
    private initialPosition;
    private relativeXPosition;
    private relativeYPosition;
    private margin;
    private offset;
    private position;
    private dragLimit;
    private borderWidth;
    private padding;
    private left;
    private top;
    private width;
    private height;
    private pageX;
    private diffX;
    private prevLeft;
    private prevTop;
    private dragProcessStarted;
    private tapHoldTimer;
    private externalInitialize;
    private diffY;
    private pageY;
    private helperElement;
    private hoverObject;
    private parentClientRect;
    private parentScrollX;
    private parentScrollY;
    droppables: {
        [key: string]: DropInfo;
    };
    constructor(element: HTMLElement, options?: DraggableModel);
    protected bind(): void;
    private static getDefaultPosition;
    private toggleEvents;
    private mobileInitialize;
    private removeTapholdTimer;
    private getScrollableParent;
    private getScrollableValues;
    private initialize;
    private intDragStart;
    private bindDragEvents;
    private elementInViewport;
    private getProcessedPositionValue;
    private calculateParentPosition;
    private intDrag;
    private getDragPosition;
    private getDocumentWidthHeight;
    private intDragStop;
    private intDestroy;
    onPropertyChanged(newProp: DraggableModel, oldProp: DraggableModel): void;
    getModuleName(): string;
    private setDragArea;
    private getProperTargetElement;
    private getMousePosition;
    private getCoordinates;
    private getHelperElement;
    private setGlobalDroppables;
    private checkTargetElement;
    private getDropInstance;
    destroy(): void;
}
//node_modules/@syncfusion/ej2-base/src/droppable-model.d.ts
/**
 * Interface for a class Droppable
 */
export interface DroppableModel {
    /**
     * Defines the selector for draggable element to be accepted by the droppable.
     */
    accept?: string;
    /**
     * Defines the scope value to group sets of draggable and droppable items. 
     * A draggable with the same scope value will only be accepted by the droppable.
     */
    scope?: string;
    /**
     * Specifies the callback function, which will be triggered while drag element is dropped in droppable.
     * @event
     */
    drop?: (args: DropEventArgs) => void;
    /**
     * Specifies the callback function, which will be triggered while drag element is moved over droppable element.
     * @event
     */
    over?: Function;
    /**
     * Specifies the callback function, which will be triggered while drag element is moved out of droppable element.
     * @event
     */
    out?: Function;
}
//node_modules/@syncfusion/ej2-base/src/droppable.d.ts
/**
 * Droppable arguments in drop callback.
 * @private
 */
export interface DropData {
    /**
     * Specifies that current element can be dropped.
     */
    canDrop: boolean;
    /**
     * Specifies target to drop.
     */
    target: HTMLElement;
}
export interface DropEvents extends MouseEvent, TouchEvent {
    dropTarget?: HTMLElement;
}
/**
 * Interface for drop event args
 */
export interface DropEventArgs {
    /**
     * Specifies the original mouse or touch  event arguments.
     */
    event?: MouseEvent & TouchEvent;
    /**
     * Specifies the target element.
     */
    target?: HTMLElement;
    /**
     *  Specifies the dropped element.
     */
    droppedElement?: HTMLElement;
    /**
     * Specifies the dragData
     */
    dragData?: DropInfo;
}
/**
 * Droppable Module provides support to enable droppable functionality in Dom Elements.
 * ```html
 * <div id='drop'>Droppable</div>
 * <script>
 * let ele:HTMLElement = document.getElementById('drop');
 * var drag:Droppable = new Droppable(ele,{
 *     accept:'.drop',
 *     drop: function(e) {
 *      //drop handler code.
 *     }
 * });
 * </script>
 * ```
 */
export  class Droppable extends Base<HTMLElement> implements INotifyPropertyChanged {
    /**
     * Defines the selector for draggable element to be accepted by the droppable.
     */
    accept: string;
    /**
     * Defines the scope value to group sets of draggable and droppable items.
     * A draggable with the same scope value will only be accepted by the droppable.
     */
    scope: string;
    /**
     * Specifies the callback function, which will be triggered while drag element is dropped in droppable.
     * @event
     */
    drop: (args: DropEventArgs) => void;
    /**
     * Specifies the callback function, which will be triggered while drag element is moved over droppable element.
     * @event
     */
    over: Function;
    /**
     * Specifies the callback function, which will be triggered while drag element is moved out of droppable element.
     * @event
     */
    out: Function;
    private mouseOver;
    dragData: {
        [key: string]: DropInfo;
    };
    constructor(element: HTMLElement, options?: DroppableModel);
    protected bind(): void;
    private wireEvents;
    onPropertyChanged(newProp: DroppableModel, oldProp: DroppableModel): void;
    getModuleName(): string;
    private dragStopCalled;
    intOver(event: MouseEvent & TouchEvent, element?: Element): void;
    intOut(event: MouseEvent & TouchEvent, element?: Element): void;
    private intDrop;
    private isDropArea;
    destroy(): void;
}
//node_modules/@syncfusion/ej2-base/src/event-handler.d.ts
/**
 * EventHandler class provides option to add, remove, clear and trigger events to a HTML DOM element
 * @private
 * ```html
 * <div id="Eventdiv">  </div>
 * <script>
 *   let node: HTMLElement = document.querySelector("#Eventdiv");
 *   EventHandler.addEventListener(node, "click", function(){
 *       // click handler function code
 *   });
 *   EventHandler.addEventListener(node, "onmouseover", function(){
 *       // mouseover handler function code
 *   });
 *   EventHandler.removeEventListener(node, "click", function(){
 *       // click handler function code
 *   });
 *   eventObj.clearEvents();
 * </script>
 * ```
 */
export  class EventHandler {
    private static addOrGetEventData;
    /**
     * Add an event to the specified DOM element.
     * @param {any} element - Target HTML DOM element
     * @param {string} eventName - A string that specifies the name of the event
     * @param {Function} listener - Specifies the function to run when the event occurs
     * @param {Object} bindTo - A object that binds 'this' variable in the event handler
     * @param {number} debounce - Specifies at what interval given event listener should be triggered.
     * @return {Function}
     */
    static add(element: Element | HTMLElement | Document, eventName: string, listener: Function, bindTo?: Object, intDebounce?: number): Function;
    /**
     * Remove an event listener that has been attached before.
     * @param {any} element - Specifies the target html element to remove the event
     * @param {string} eventName - A string that specifies the name of the event to remove
     * @param {Function} listener - Specifies the function to remove
     * @return {void}
     */
    static remove(element: Element | HTMLElement | Document, eventName: string, listener: Function): void;
    /**
     * Clear all the event listeners that has been previously attached to the element.
     * @param {any} element - Specifies the target html element to clear the events
     * @return {void}
     */
    static clearEvents(element: Element): void;
    /**
     * Trigger particular event of the element.
     * @param {any} element - Specifies the target html element to trigger the events
     * @param {string} eventName - Specifies the event to trigger for the specified element.
     * Can be a custom event, or any of the standard events.
     * @param {any} eventProp - Additional parameters to pass on to the event properties
     * @return {void}
     */
    static trigger(element: HTMLElement, eventName: string, eventProp?: Object): void;
}
/**
 * Common Event argument for all base Essential JavaScript 2 Events.
 * @private
 */
export interface BaseEventArgs {
    /**
     * Specifies name of the event.
     */
    name?: string;
}
//node_modules/@syncfusion/ej2-base/src/hijri-parser.d.ts
/***
 * Hijri parser
 */
export  namespace HijriParser {
    function getHijriDate(gDate: Date): Object;
    function toGregorian(year: number, month: number, day: number): Date;
}
//node_modules/@syncfusion/ej2-base/src/index.d.ts
/**
 * Base modules
 */
//node_modules/@syncfusion/ej2-base/src/internationalization.d.ts
/**
 * Specifies the observer used for external change detection.
 */
export  let onIntlChange: Observer;
/**
 * Specifies the default rtl status for EJ2 components.
 */
export  let rightToLeft: boolean;
/**
 * Interface for dateFormatOptions
 *
 */
export interface DateFormatOptions {
    /**
     * Specifies the skeleton for date formatting.
     */
    skeleton?: string;
    /**
     * Specifies the type of date formatting either date, dateTime or time.
     */
    type?: string;
    /**
     * Specifies custom date formatting to be used.
     */
    format?: string;
    /**
     * Specifies the calendar mode other than gregorian
     */
    calendar?: string;
}
/**
 * Interface for numberFormatOptions
 *
 */
export interface NumberFormatOptions {
    /**
     * Specifies minimum fraction digits in formatted value.
     */
    minimumFractionDigits?: number;
    /**
     * Specifies maximum fraction digits in formatted value.
     */
    maximumFractionDigits?: number;
    /**
     * Specifies minimum significant digits in formatted value.
     */
    minimumSignificantDigits?: number;
    /**
     * Specifies maximum significant digits in formatted value.
     */
    maximumSignificantDigits?: number;
    /**
     * Specifies whether to use grouping or not in formatted value,
     */
    useGrouping?: boolean;
    /**
     * Specifies the skeleton for perform formatting.
     */
    skeleton?: string;
    /**
     * Specifies the currency code to be used for formatting.
     */
    currency?: string;
    /**
     * Specifies minimum integer digits in formatted value.
     */
    minimumIntegerDigits?: number;
    /**
     * Specifies custom number format for formatting.
     */
    format?: string;
}
/**
 * Specifies the CLDR data loaded for internationalization functionalities.
 * @private
 */
export  let cldrData: Object;
/**
 * Specifies the default culture value to be considered.
 * @private
 */
export  let defaultCulture: string;
/**
 * Specifies default currency code to be considered
 * @private
 */
export  let defaultCurrencyCode: string;
/**
 * Internationalization class provides support to parse and format the number and date object to the desired format.
 * ```typescript
 * // To set the culture globally
 * setCulture('en-GB');
 *
 * // To set currency code globally
 * setCurrencyCode('EUR');
 *
 * //Load cldr data
 * loadCldr(gregorainData);
 * loadCldr(timeZoneData);
 * loadCldr(numbersData);
 * loadCldr(numberSystemData);
 *
 * // To use formatter in component side
 * let Intl:Internationalization = new Internationalization();
 *
 * // Date formatting
 * let dateFormatter: Function = Intl.getDateFormat({skeleton:'long',type:'dateTime'});
 * dateFormatter(new Date('11/2/2016'));
 * dateFormatter(new Date('25/2/2030'));
 * Intl.formatDate(new Date(),{skeleton:'E'});
 *
 * //Number formatting
 * let numberFormatter: Function = Intl.getNumberFormat({skeleton:'C5'})
 * numberFormatter(24563334);
 * Intl.formatNumber(123123,{skeleton:'p2'});
 *
 * // Date parser
 * let dateParser: Function = Intl.getDateParser({skeleton:'short',type:'time'});
 * dateParser('10:30 PM');
 * Intl.parseDate('10',{skeleton:'H'});
 * ```
 */
export  class Internationalization {
    culture: string;
    constructor(cultureName?: string);
    /**
     * Returns the format function for given options.
     * @param {DateFormatOptions} options - Specifies the format options in which the format function will return.
     * @returns {Function}
     */
    getDateFormat(options?: DateFormatOptions): Function;
    /**
     * Returns the format function for given options.
     * @param {NumberFormatOptions} options - Specifies the format options in which the format function will return.
     * @returns {Function}
     */
    getNumberFormat(options?: NumberFormatOptions): Function;
    /**
     * Returns the parser function for given options.
     * @param {DateFormatOptions} options - Specifies the format options in which the parser function will return.
     * @returns {Function}
     */
    getDateParser(options?: DateFormatOptions): Function;
    /**
     * Returns the parser function for given options.
     * @param {NumberFormatOptions} options - Specifies the format options in which the parser function will return.
     * @returns {Function}
     */
    getNumberParser(options?: NumberFormatOptions): Function;
    /**
     * Returns the formatted string based on format options.
     * @param {Number} value - Specifies the number to format.
     * @param {NumberFormatOptions} option - Specifies the format options in which the number will be formatted.
     * @returns {string}
     */
    formatNumber(value: Number, option?: NumberFormatOptions): string;
    /**
     * Returns the formatted date string based on format options.
     * @param {Number} value - Specifies the number to format.
     * @param {DateFormatOptions} option - Specifies the format options in which the number will be formatted.
     * @returns {string}
     */
    formatDate(value: Date, option?: DateFormatOptions): string;
    /**
     * Returns the date object for given date string and options.
     * @param {string} value - Specifies the string to parse.
     * @param {DateFormatOptions} option - Specifies the parse options in which the date string will be parsed.
     * @returns {Date}
     */
    parseDate(value: string, option?: DateFormatOptions): Date;
    /**
     * Returns the number object from the given string value and options.
     * @param {string} value - Specifies the string to parse.
     * @param {NumberFormatOptions} option - Specifies the parse options in which the  string number  will be parsed.
     * @returns {number}
     */
    parseNumber(value: string, option?: NumberFormatOptions): number;
    /**
     * Returns Native Date Time Pattern
     * @param {DateFormatOptions} option - Specifies the parse options for resultant date time pattern.
     * @param {boolean} isExcelFormat - Specifies format value to be converted to excel pattern.
     * @returns {string}
     * @private
     */
    getDatePattern(option: DateFormatOptions, isExcelFormat?: boolean): string;
    /**
     * Returns Native Number Pattern
     * @param {NumberFormatOptions} option - Specifies the parse options for resultant number pattern.
     * @returns {string}
     * @private
     */
    getNumberPattern(option: NumberFormatOptions): string;
    /**
     * Returns the First Day of the Week
     * @returns {number}
     */
    getFirstDayOfWeek(): number;
    private getCulture;
}
/**
 * Set the default culture to all EJ2 components
 * @param {string} cultureName - Specifies the culture name to be set as default culture.
 */
export  function setCulture(cultureName: string): void;
/**
 * Set the default currency code to all EJ2 components
 * @param {string} currencyCode Specifies the culture name to be set as default culture.
 * @returns {void}
 */
export  function setCurrencyCode(currencyCode: string): void;
/**
 * Load the CLDR data into context
 * @param {Object[]} obj Specifies the CLDR data's to be used for formatting and parser.
 * @returns {void}
 */
export  function loadCldr(...data: Object[]): void;
/**
 * To enable or disable RTL functionality for all components globally.
 * @param {boolean} status - Optional argument Specifies the status value to enable or disable rtl option.
 * @returns {void}
 */
export  function enableRtl(status?: boolean): void;
/**
 * To get the numeric CLDR object for given culture
 * @param {string} locale - Specifies the locale for which numericObject to be returned.
 * @ignore
 * @private
 */
export  function getNumericObject(locale: string, type?: string): Object;
/**
 * To get the numeric CLDR  number base object for given culture
 * @param {string} locale - Specifies the locale for which numericObject to be returned.
 * @param {string} currency - Specifies the currency for which numericObject to be returned.
 * @ignore
 * @private
 */
export  function getNumberDependable(locale: string, currency: string): string;
/**
 * To get the default date CLDR object.
 * @ignore
 * @private
 */
export  function getDefaultDateObject(mode?: string): Object;
//node_modules/@syncfusion/ej2-IntlBase/src/intl/date-formatter.d.ts
export  const basicPatterns: string[];
/**
 * Interface for Date Format Options Modules.
 * @private
 */
export interface FormatOptions {
    month?: Object;
    weekday?: Object;
    pattern?: string;
    designator?: Object;
    timeZone?: IntlBase.TimeZoneOptions;
    era?: Object;
    hour12?: boolean;
    numMapper?: NumberMapper;
    dateSeperator?: string;
    isIslamic?: boolean;
}
export  const datePartMatcher: {
    [key: string]: Object;
};
/**
 * Date Format is a framework provides support for date formatting.
 * @private
 */
export  class DateFormat {
    /**
     * Returns the formatter function for given skeleton.
     * @param {string} -  Specifies the culture name to be which formatting.
     * @param {DateFormatOptions} - Specific the format in which date  will format.
     * @param {cldr} - Specifies the global cldr data collection.
     * @return Function.
     */
    static dateFormat(culture: string, option: DateFormatOptions, cldr: Object): Function;
    /**
     * Returns formatted date string based on options passed.
     * @param {Date} value
     * @param {FormatOptions} options
     */
    private static intDateFormatter;
    private static getCurrentDateValue;
    /**
     * Returns two digit numbers for given value and length
     */
    private static checkTwodigitNumber;
    /**
     * Returns the value of the Time Zone.
     * @param {number} tVal
     * @param {string} pattern
     * @private
     */
    static getTimeZoneValue(tVal: number, pattern: string): string;
}
//node_modules/@syncfusion/ej2-base/src/intl/date-parser.d.ts
/**
 * Date Parser.
 * @private
 */
export  class DateParser {
    /**
     * Returns the parser function for given skeleton.
     * @param {string} -  Specifies the culture name to be which formatting.
     * @param {DateFormatOptions} - Specific the format in which string date  will be parsed.
     * @param {cldr} - Specifies the global cldr data collection.
     *  @return Function.
     */
    static dateParser(culture: string, option: DateFormatOptions, cldr: Object): Function;
    /**
     * Returns date object for provided date options
     * @param {DateParts} options
     * @param {Date} value
     * @returns {Date}
     */
    private static getDateObject;
    /**
     * Returns date parsing options for provided value along with parse and numeric options
     * @param {string} value
     * @param {ParseOptions} parseOptions
     * @param {NumericOptions} num
     * @returns {DateParts}
     */
    private static internalDateParse;
    /**
     * Returns parsed number for provided Numeric string and Numeric Options
     * @param {string} value
     * @param {NumericOptions} option
     * @returns {number}
     */
    private static internalNumberParser;
    /**
     * Returns parsed time zone RegExp for provided hour format and time zone
     * @param {string} hourFormat
     * @param {base.TimeZoneOptions} tZone
     * @param {string} nRegex
     * @returns {string}
     */
    private static parseTimeZoneRegx;
    /**
     * Returns zone based value.
     * @param {boolean} flag
     * @param {string} val1
     * @param {string} val2
     * @param {NumericOptions} num
     * @returns {number}
     */
    private static getZoneValue;
}
//node_modules/@syncfusion/ej2-base/src/intl/index.d.ts
/**
 * Internationalization
 */
//node_modules/@syncfusion/ej2-base/src/intl/intl-base.d.ts
/**
 * Date base common constants and function for date parser and formatter.
 */
export  namespace IntlBase {
    const negativeDataRegex: RegExp;
    const customRegex: RegExp;
    const latnParseRegex: RegExp;
    const defaultCurrency: string;
    const islamicRegex: RegExp;
    interface NumericSkeleton {
        type?: string;
        isAccount?: boolean;
        fractionDigits?: number;
    }
    interface GenericFormatOptions {
        nData?: NegativeData;
        pData?: NegativeData;
        zeroData?: NegativeData;
    }
    interface GroupSize {
        primary?: number;
        secondary?: number;
    }
    interface NegativeData extends FormatParts {
        nlead?: string;
        nend?: string;
        groupPattern?: string;
        minimumFraction?: number;
        maximumFraction?: number;
    }
    const formatRegex: RegExp;
    const currencyFormatRegex: RegExp;
    const curWithoutNumberRegex: RegExp;
    const dateParseRegex: RegExp;
    const basicPatterns: string[];
    interface Dependables {
        parserObject?: Object;
        dateObject?: Object;
        numericObject?: Object;
    }
    interface TimeZoneOptions {
        hourFormat?: string;
        gmtFormat?: string;
        gmtZeroFormat?: string;
    }
    const defaultObject: Object;
    const monthIndex: Object;
    /**
     *
     */
    const month: string;
    const days: string;
    /**
     * Default numerber Object
     */
    const patternMatcher: {
        [key: string]: Object;
    };
    /**
     * Returns the resultant pattern based on the skeleton, dateObject and the type provided
     * @private
     * @param {string} skeleton
     * @param {Object} dateObject
     * @param {string} type
     * @returns {string}
     */
    function getResultantPattern(skeleton: string, dateObject: Object, type: string, isIslamic?: boolean): string;
    interface DateObject {
        year?: number;
        month?: number;
        date?: number;
    }
    /**
     * Returns the dependable object for provided cldr data and culture
     * @private
     * @param {Object} cldr
     * @param {string} culture
     * @param {boolean} isNumber
     * @returns {Dependables}
     */
    function getDependables(cldr: Object, culture: string, mode: string, isNumber?: boolean): Dependables;
    /**
     * Returns the symbol pattern for provided parameters
     * @private
     * @param {string} type
     * @param {string} numSystem
     * @param {Object} obj
     * @param {boolean} isAccount
     * @returns {string}
     */
    function getSymbolPattern(type: string, numSystem: string, obj: Object, isAccount: boolean): string;
    /**
     * Returns proper numeric skeleton
     * @private
     * @param {string} skeleton
     * @returns {NumericSkeleton}
     */
    function getProperNumericSkeleton(skeleton: string): NumericSkeleton;
    /**
     * Returns format data for number formatting like minimum fraction, maximum fraction, etc..,
     * @private
     * @param {string} pattern
     * @param {boolean} needFraction
     * @param {string} cSymbol
     * @param {boolean} fractionOnly
     * @returns {NegativeData}
     */
    function getFormatData(pattern: string, needFraction: boolean, cSymbol: string, fractionOnly?: boolean): NegativeData;
    /**
     * Returns currency symbol based on currency code
     * @private
     * @param {Object} numericObject
     * @param {string} currencyCode
     * @returns {string}
     */
    function getCurrencySymbol(numericObject: Object, currencyCode: string): string;
    /**
     * Returns formatting options for custom number format
     * @private
     * @param {string} format
     * @param {CommonOptions} dOptions
     * @param {Dependables} obj
     * @returns {GenericFormatOptions}
     */
    function customFormat(format: string, dOptions: CommonOptions, obj: Dependables): GenericFormatOptions;
    /**
     * Returns formatting options for currency or percent type
     * @private
     * @param {string[]} parts
     * @param {string} actual
     * @param {string} symbol
     * @returns {NegativeData}
     */
    function isCurrencyPercent(parts: string[], actual: string, symbol: string): NegativeData;
    /**
     * Returns culture based date separator
     * @private
     * @param {Object} dateObj
     * @returns {string}
     */
    function getDateSeparator(dateObj: Object): string;
    /**
     * Returns Native Date Time pattern
     * @private
     * @param {string} culture
     * @param {DateFormatOptions} options
     * @param {Object} cldr
     * @returns {string}
     */
    function getActualDateTimeFormat(culture: string, options: DateFormatOptions, cldr?: Object, isExcelFormat?: boolean): string;
    /**
     * Returns Native Number pattern
     * @private
     * @param {string} culture
     * @param {NumberFormatOptions} options
     * @param {Object} cldr
     * @returns {string}
     */
    function getActualNumberFormat(culture: string, options: NumberFormatOptions, cldr?: Object): string;
    function getWeekData(culture: string, cldr?: Object): number;
}
//node_modules/@syncfusion/ej2-IntlBase/src/intl/number-formatter.d.ts
/**
 * Interface for default formatting options
 * @private
 */
export interface FormatParts extends IntlBase.NumericSkeleton, NumberFormatOptions {
    groupOne?: boolean;
    isPercent?: boolean;
    isCurrency?: boolean;
    isNegative?: boolean;
    groupData?: GroupDetails;
    groupSeparator?: string;
}
/**
 * Interface for common formatting options
 */
export interface CommonOptions {
    numberMapper?: NumberMapper;
    currencySymbol?: string;
    percentSymbol?: string;
    minusSymbol?: string;
}
/**
 * Interface for grouping process
 */
export interface GroupDetails {
    primary?: number;
    secondary?: number;
}
/**
 * Module for number formatting.
 * @private
 */
export  class NumberFormat {
    /**
     * Returns the formatter function for given skeleton.
     * @param {string} culture -  Specifies the culture name to be which formatting.
     * @param {NumberFormatOptions} option - Specific the format in which number  will format.
     * @param {Object} object- Specifies the global cldr data collection.
     * @return Function.
     */
    static numberFormatter(culture: string, option: NumberFormatOptions, cldr: Object): Function;
    /**
     * Returns grouping details for the pattern provided
     * @param {string} pattern
     * @returns {GroupDetails}
     */
    static getGroupingDetails(pattern: string): GroupDetails;
    /**
     * Returns if the provided integer range is valid.
     * @param {number} val1
     * @param {number} val2
     * @param {boolean} checkbothExist
     * @param {boolean} isFraction
     * @returns {boolean}
     */
    private static checkValueRange;
    /**
     * Check if the provided fraction range is valid
     * @param {number} val
     * @param {string} text
     * @param {boolean} isFraction
     * @returns {void}
     */
    private static checkRange;
    /**
     * Returns formatted numeric string for provided formatting options
     * @param {number} value
     * @param {IntlBase.GenericFormatOptions} fOptions
     * @param {CommonOptions} dOptions
     * @returns {string}
     */
    private static intNumberFormatter;
    /**
     * Returns significant digits processed numeric string
     * @param {number} value
     * @param {number} min
     * @param {number} max
     * @returns {string}
     */
    private static processSignificantDigits;
    /**
     * Returns grouped numeric string
     * @param {string} val
     * @param {number} level1
     * @param {string} sep
     * @param {string} decimalSymbol
     * @param {number} level2
     * @returns {string}
     */
    private static groupNumbers;
    /**
     * Returns fraction processed numeric string
     * @param {number} value
     * @param {number} min
     * @param {number} max
     * @returns {string}
     */
    private static processFraction;
    /**
     * Returns integer processed numeric string
     * @param {string} value
     * @param {number} min
     * @returns {string}
     */
    private static processMinimumIntegers;
}
//node_modules/@syncfusion/ej2-IntlBase/src/intl/number-parser.d.ts
/**
 * interface for Numeric Formatting Parts
 */
export interface NumericParts {
    symbolRegex?: RegExp;
    nData?: IntlBase.NegativeData;
    pData?: IntlBase.NegativeData;
    infinity?: string;
    type?: string;
    fractionDigits?: number;
    isAccount?: boolean;
    custom?: boolean;
}
/**
 * Module for Number Parser.
 * @private
 */
export  class NumberParser {
    /**
     * Returns the parser function for given skeleton.
     * @param {string} -  Specifies the culture name to be which formatting.
     * @param {NumberFormatOptions} - Specific the format in which number  will parsed.
     * @param {cldr} - Specifies the global cldr data collection.
     * @return Function.
     */
    static numberParser(culture: string, option: NumberFormatOptions, cldr: Object): Function;
    /**
     * Returns parsed number for the provided formatting options
     * @param {string} value
     * @param {NumericParts} options
     * @param {NumericOptions} numOptions
     * @returns {number}
     */
    private static getParsedNumber;
}
//node_modules/@syncfusion/ej2-base/src/intl/parser-base.d.ts
/**
 * Parser
 */
/**
 * Interface for numeric Options
 */
export interface NumericOptions {
    numericPair?: Object;
    numericRegex?: string;
    numberParseRegex?: RegExp;
    symbolNumberSystem?: Object;
    symbolMatch?: Object;
    numberSystem?: string;
}
/**
 * Interface for numeric object
 */
export interface NumericObject {
    obj?: Object;
    nSystem?: string;
}
/**
 * Interface for number mapper
 */
export interface NumberMapper {
    mapper?: Object;
    timeSeparator?: string;
    numberSymbols?: Object;
    numberSystem?: string;
}
/**
 * Interface for parser base
 * @private
 */
export  class ParserBase {
    static nPair: string;
    static nRegex: string;
    static numberingSystems: Object;
    /**
     * Returns the cldr object for the culture specifies
     * @param {Object} obj - Specifies the object from which culture object to be acquired.
     * @param {string} cName - Specifies the culture name.
     * @returns {Object}
     */
    static getMainObject(obj: Object, cName: string): Object;
    /**
     * Returns the numbering system object from given cldr data.
     * @param {Object} obj - Specifies the object from which number system is acquired.
     * @returns {Object}
     */
    static getNumberingSystem(obj: Object): Object;
    /**
     * Returns the reverse of given object keys or keys specified.
     * @param {Object} prop - Specifies the object to be reversed.
     * @param {number[]} keys - Optional parameter specifies the custom keyList for reversal.
     * @returns {Object}
     */
    static reverseObject(prop: Object, keys?: number[]): Object;
    /**
     * Returns the symbol regex by skipping the escape sequence.
     * @param {string[]} props - Specifies the array values to be skipped.
     * @returns {RegExp}
     */
    static getSymbolRegex(props: string[]): RegExp;
    private static getSymbolMatch;
    /**
     * Returns regex string for provided value
     * @param {string} val
     * @returns {string}
     */
    private static constructRegex;
    /**
     * Returns the replaced value of matching regex and obj mapper.
     * @param {string} value - Specifies the  values to be replaced.
     * @param {RegExp} regex - Specifies the  regex to search.
     * @param {Object} obj - Specifies the  object matcher to be replace value parts.
     * @returns {string}
     */
    static convertValueParts(value: string, regex: RegExp, obj: Object): string;
    /**
     * Returns default numbering system object for formatting from cldr data
     * @param {Object} obj
     * @returns {NumericObject}
     */
    static getDefaultNumberingSystem(obj: Object): NumericObject;
    /**
     * Returns the replaced value of matching regex and obj mapper.
     */
    static getCurrentNumericOptions(curObj: Object, numberSystem: Object, needSymbols?: boolean): Object;
    /**
     * Returns number mapper object for the provided cldr data
     * @param {Object} curObj
     * @param {Object} numberSystem
     * @param {boolean} isNumber
     * @returns {NumberMapper}
     */
    static getNumberMapper(curObj: Object, numberSystem: Object, isNumber?: boolean): NumberMapper;
}
//node_modules/@syncfusion/ej2-base/src/keyboard-model.d.ts
/**
 * Interface for a class KeyboardEvents
 */
export interface KeyboardEventsModel {
    /**
     * Specifies key combination and it respective action name.
     * @default null
     */
    keyConfigs?: { [key: string]: string };
    /**
     * Specifies on which event keyboardEvents class should listen for key press. For ex., `keyup`, `keydown` or `keypress`
     * @default keyup
     */
    eventName?: string;
    /**
     * Specifies the listener when keyboard actions is performed. 
     * @event
     */
    keyAction?: EmitType<KeyboardEventArgs>;
}
//node_modules/@syncfusion/ej2-base/src/keyboard.d.ts
/**
 * KeyboardEvents
 */
export interface KeyboardEventArgs extends KeyboardEvent {
    /**
     * action of the KeyboardEvent
     */
    action: string;
}
/**
 * KeyboardEvents class enables you to bind key action desired key combinations for ex., Ctrl+A, Delete, Alt+Space etc.
 * ```html
 * <div id='testEle'>  </div>;
 * <script>
 *   let node$: HTMLElement = document.querySelector('#testEle');
 *   let kbInstance = new KeyboardEvents({
 *       element: node,
 *       keyConfigs:{ selectAll : 'ctrl+a' },
 *       keyAction: function (e:KeyboardEvent, action:string) {
 *           // handler function code
 *       }
 *   });
 * </script>
 * ```
 */
export  class KeyboardEvents extends Base<HTMLElement> implements INotifyPropertyChanged {
    /**
     * Specifies key combination and it respective action name.
     * @default null
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * Specifies on which event keyboardEvents class should listen for key press. For ex., `keyup`, `keydown` or `keypress`
     * @default keyup
     */
    eventName: string;
    /**
     * Specifies the listener when keyboard actions is performed.
     * @event
     */
    keyAction: EmitType<KeyboardEventArgs>;
    /**
     * Initializes the KeyboardEvents
     * @param {HTMLElement} element
     * @param {KeyboardEventsModel} options
     */
    constructor(element: HTMLElement, options?: KeyboardEventsModel);
    /**
     * Unwire bound events and destroy the instance.
     * @return {void}
     */
    destroy(): void;
    /**
     * Function can be used to specify certain action if a property is changed
     * @param newProp
     * @param oldProp
     * @returns {void}
     * @private
     */
    onPropertyChanged(newProp: KeyboardEventsModel, oldProp?: KeyboardEventsModel): void;
    protected bind(): void;
    /**
     * To get the module name, returns 'keyboard'.
     * @private
     */
    getModuleName(): string;
    /**
     * Wiring event handlers to events
     */
    private wireEvents;
    /**
     * Unwiring event handlers to events
     */
    private unwireEvents;
    /**
     * To handle a key press event returns null
     */
    private keyPressHandler;
    private static configCache;
    /**
     * To get the key configuration data
     * @param {string} config - configuration data
     * returns {KeyData}
     */
    private static getKeyConfigData;
    private static getKeyCode;
}
//node_modules/@syncfusion/ej2-base/src/l10n.d.ts
/**
 * L10n modules provides localized text for different culture.
 * ```typescript
 * //load global locale object common for all components.
 * L10n.load({
 *    'fr-BE': {
 *       'button': {
 *            'check': 'vérifié'
 *        }
 *    }
 * });
 * //set globale default locale culture.
 * tsBaseLibrary.setCulture('fr-BE');
 * let instance: L10n = new L10n('button', {
 *    check: 'checked'
 * });
 * //Get locale text for current property.
 * instance.getConstant('check');
 * //Change locale culture in a component.
 * instance.setLocale('en-US');
 * ```
 */
export  class L10n {
    private static locale;
    private controlName;
    private localeStrings;
    private currentLocale;
    /**
     * Constructor
     */
    constructor(controlName: string, localeStrings: Object, locale?: string);
    /**
     * Sets the locale text
     * @param {string} locale
     * @returns {void}
     */
    setLocale(locale: string): void;
    /**
     * Sets the global locale for all components.
     * @param {Object} localeObject - specifies the localeObject to be set as global locale.
     */
    static load(localeObject: Object): void;
    /**
     * Returns current locale text for the property based on the culture name and control name.
     * @param {string} propertyName - specifies the property for which localize text to be returned.
     * @return string
     */
    getConstant(prop: string): string;
    /**
     * Returns the control constant object for current object and the locale specified.
     * @param {Object} curObject
     * @param {string} locale
     * @returns {Object}
     */
    private intGetControlConstant;
}
//node_modules/@syncfusion/ej2-base/src/module-loader.d.ts
/**
 * Interface for module declaration.
 */
export interface ModuleDeclaration {
    /**
     * Specifies the args for module declaration.
     */
    args: Object[];
    /**
     * Specifies the member for module declaration.
     */
    member: string;
    /**
     * Specifies whether it is a property or not.
     */
    isProperty?: boolean;
}
export interface IParent {
    [key: string]: any;
}
export  class ModuleLoader {
    private parent;
    private loadedModules;
    constructor(parent: IParent);
    /**
     * Inject required modules in component library
     * @return {void}
     * @param {ModuleDeclaration[]} requiredModules - Array of modules to be required
     * @param {Function[]} moduleList - Array of modules to be injected from sample side
     */
    inject(requiredModules: ModuleDeclaration[], moduleList: Function[]): void;
    /**
     * To remove the created object while destroying the control
     * @return {void}
     */
    clean(): void;
    /**
     * Removes all unused modules
     * @param {ModuleDeclaration[]} moduleList
     * @returns {void}
     */
    private clearUnusedModule;
    /**
     * To get the name of the member.
     * @param {string} name
     * @returns {string}
     */
    private getMemberName;
    /**
     * Returns boolean based on whether the module specified is loaded or not
     * @param {string} modName
     * @returns {boolean}
     */
    private isModuleLoaded;
}
//node_modules/@syncfusion/ej2-base/src/notify-property-change.d.ts
/**
 * Method used to create property. General syntax below.
 * @param  {T} defaultValue? - Specifies the default value of property.
 * ```
 * @Property('TypeScript')
 * propertyName: Type;
 * ```
 * @private
 */
export  function Property<T>(defaultValue?: T | Object): PropertyDecorator;
/**
 * Method used to create complex property. General syntax below.
 * @param  {T} defaultValue - Specifies the default value of property.
 * @param  {Function} type - Specifies the class type of complex object.
 * ```
 * @Complex<Type>({},Type)
 * propertyName: Type;
 * ```
 * @private
 */
export  function Complex<T>(defaultValue: T, type: Function): PropertyDecorator;
/**
 * Method used to create complex Factory property. General syntax below.
 * @param  {Function} defaultType - Specifies the default value of property.
 * @param  {Function} type - Specifies the class factory type of complex object.
 * ```
 * @ComplexFactory(defaultType, factoryFunction)
 * propertyName: Type1 | Type2;
 * ```
 * @private
 */
export  function ComplexFactory(type: Function): PropertyDecorator;
/**
 * Method used to create complex array property. General syntax below.
 * @param  {T[]} defaultValue - Specifies the default value of property.
 * @param  {Function} type - Specifies the class type of complex object.
 * ```
 * @Collection([], Type);
 * propertyName: Type;
 * ```
 * @private
 */
export  function Collection<T>(defaultValue: T[], type: Function): PropertyDecorator;
/**
 * Method used to create complex factory array property. General syntax below.
 * @param  {T[]} defaultType - Specifies the default type of property.
 * @param  {Function} type - Specifies the class type of complex object.
 * ```
 * @Collection([], Type);
 * propertyName: Type;
 * ```
 * @private
 */
export  function CollectionFactory(type: Function): PropertyDecorator;
/**
 * Method used to create event property. General syntax below.
 * @param  {Function} defaultValue? - Specifies the default value of property.
 * @param  {boolean} isComplex? - Specifies the whether it is complex object.
 * ```
 * @Event(()=>{return true;
})
 * ```
 * @private
 */
export  function Event(): PropertyDecorator;
/**
 * NotifyPropertyChanges is triggers the call back when the property has been changed.
 *
 * ```
 *  @NotifyPropertyChanges
 * class DemoClass implements INotifyPropertyChanged {
 *
 *     @Property()
 *     property1: string;
 *
 *     dataBind: () => void;
 *
 *     constructor() { }
 *
 *     onPropertyChanged(newProp: any, oldProp: any) {
 *         // Called when property changed
 *     }
 * }
 * ```
 * @private
 */
export  function NotifyPropertyChanges(classConstructor: Function): void;
/**
 * Interface to notify the changed properties
 */
export interface INotifyPropertyChanged {
    onPropertyChanged(newProperties: Object, oldProperties?: Object): void;
}
/**
 * Method used to create builder for the components
 * @param {any} component -specifies the target component for which builder to be created.
 * @private
 */
export  function CreateBuilder<T>(component: T): Object;
//node_modules/@syncfusion/ej2-base/src/observer.d.ts
/**
 * Observer is used to perform event handling based the object.
 * ```
 * //Creating observer instance.
 * let observer:Observer = Observer(this);
 * let handler: Function = (a:number, b: number): number => {return a + b;
 }
 * //add handler to event.
 * observe.on('eventname', handler);
 * //remove handler from event.
 * observe.off('eventname', handler);
 * //notify the handlers in event.
 * observe.notify('eventname');
 * ```
 *
 */
export interface BoundOptions {
    handler?: Function;
    context?: Object;
    event?: string;
    id?: string;
}
export  class Observer {
    private context;
    private ranArray;
    private boundedEvents;
    constructor(context?: Object);
    /**
     * To attach handler for given property in current context.
     * @param {string} property - specifies the name of the event.
     * @param {Function} handler - Specifies the handler function to be called while event notified.
     * @param {Object} context - Specifies the context binded to the handler.
     * @param {string} id - specifies the random generated id.
     * @return {void}
     */
    on(property: string, handler: Function, context?: Object, id?: string): void;
    /**
     * To remove handlers from a event attached using on() function.
     * @param {string} eventName - specifies the name of the event.
     * @param {Function} handler - Optional argument specifies the handler function to be called while event notified.
     * @param {string} id - specifies the random generated id.
     * @return {void}
     */
    off(property: string, handler?: Function, id?: string): void;
    /**
     * To notify the handlers in the specified event.
     * @param {string} property - Specifies the event to be notify.
     * @param {Object} args - Additional parameters to pass while calling the handler.
     * @param {Function} successHandler - this function will invoke after event successfully triggered
     * @param {Function} errorHandler - this function will invoke after event if it was failure to call.
     * @return {void}
     */
    notify(property: string, argument?: Object, successHandler?: Function, errorHandler?: Function): void | Object;
    private blazorCallback;
    isJson(value: string): boolean;
    /**
     * To destroy handlers in the event
     */
    destroy(): void;
    /**
     * Returns if the property exists.
     */
    private notExist;
    /**
     * Returns if the handler is present.
     */
    private isHandlerPresent;
}
//node_modules/@syncfusion/ej2-base/src/template-engine.d.ts
export  let blazorTemplates: object;
export  function getRandomId(): string;
/**
 * Interface for Template Engine.
 */
export interface ITemplateEngine {
    compile: (templateString: string, helper?: Object) => (data: Object | JSON) => string;
}
/**
 * Compile the template string into template function.
 * @param  {string} templateString - The template string which is going to convert.
 * @param  {Object} helper? - Helper functions as an object.
 * @private
 */
export  function compile(templateString: string, helper?: Object): (data: Object | JSON, component?: any, propName?: any) => NodeList;
export  function updateBlazorTemplate(templateId?: string, templateName?: string, comp?: object, isEmpty?: boolean, callBack?: Function): void;
export  function resetBlazorTemplate(templateId?: string, templateName?: string, index?: number): void;
/**
 * Set your custom template engine for template rendering.
 * @param  {ITemplateEngine} classObj - Class object for custom template.
 * @private
 */
export  function setTemplateEngine(classObj: ITemplateEngine): void;
/**
 * Get current template engine for template rendering.
 * @param  {ITemplateEngine} classObj - Class object for custom template.
 * @private
 */
export  function getTemplateEngine(): (template: string, helper?: Object) => (data: Object | JSON) => string;
//node_modules/@syncfusion/ej2-base/src/template.d.ts
/**
 * Template Engine
 */
/**
 * The function to set regular expression for template expression string.
 * @param  {RegExp} value - Value expression.
 * @private
 */
export  function expression(value?: RegExp): RegExp;
/**
 * Compile the template string into template function.
 * @param  {string} template - The template string which is going to convert.
 * @param  {Object} helper? - Helper functions as an object.
 * @private
 */
export  function compile(template: string, helper?: Object): () => string;
//node_modules/@syncfusion/ej2-base/src/touch-model.d.ts
/**
 * Interface for a class SwipeSettings
 */
export interface SwipeSettingsModel {
    /**
     * Property specifies minimum distance of swipe moved.
     */
    swipeThresholdDistance?: number;
}
/**
 * Interface for a class Touch
 */
export interface TouchModel {
    /**
     * Specifies the callback function for tap event.
     * @event
     */
    tap?: EmitType<TapEventArgs>;
    /**
     * Specifies the callback function for tapHold event.
     * @event
     */
    tapHold?: EmitType<TapEventArgs>;
    /**
     * Specifies the callback function for swipe event.
     * @event
     */
    swipe?: EmitType<SwipeEventArgs>;
    /**
     * Specifies the callback function for scroll event.
     * @event
     */
    scroll?: EmitType<ScrollEventArgs>;
    /**
     * Specifies the time delay for tap.
     * @default 350
     */
    tapThreshold?: number;
    /**
     * Specifies the time delay for tap hold.
     * @default 750
     */
    tapHoldThreshold?: number;
    /**
     * Customize the swipe event configuration.
     * @default { swipeThresholdDistance: 50 }
     */
    swipeSettings?: SwipeSettingsModel;
}
//node_modules/@syncfusion/ej2-base/src/touch.d.ts
/**
 * SwipeSettings is a framework module that provides support to handle swipe event like swipe up, swipe right, etc..,
 */
export  class SwipeSettings extends ChildProperty<SwipeSettings> {
    /**
     * Property specifies minimum distance of swipe moved.
     */
    swipeThresholdDistance: number;
}
/**
 * Touch class provides support to handle the touch event like tap, double tap, tap hold, etc..,
 * ```typescript
 *    let node$: HTMLElement;
 * let touchObj: Touch = new Touch({
 *    element: node,
 *    tap: function (e) {
 *        // tap handler function code
 *    }
 *    tapHold: function (e) {
 *        // tap hold handler function code
 *    }
 *    scroll: function (e) {
 *        // scroll handler function code
 *    }
 *    swipe: function (e) {
 *        // swipe handler function code
 *    }
 * });
 * ```
 */
export  class Touch extends Base<HTMLElement> implements INotifyPropertyChanged {
    private isTouchMoved;
    private startPoint;
    private movedPoint;
    private endPoint;
    private startEventData;
    private lastTapTime;
    private lastMovedPoint;
    private scrollDirection;
    private hScrollLocked;
    private vScrollLocked;
    private defaultArgs;
    private distanceX;
    private distanceY;
    private movedDirection;
    private tStampStart;
    private touchAction;
    private timeOutTap;
    private modeClear;
    private timeOutTapHold;
    /**
     * Specifies the callback function for tap event.
     * @event
     */
    tap: EmitType<TapEventArgs>;
    /**
     * Specifies the callback function for tapHold event.
     * @event
     */
    tapHold: EmitType<TapEventArgs>;
    /**
     * Specifies the callback function for swipe event.
     * @event
     */
    swipe: EmitType<SwipeEventArgs>;
    /**
     * Specifies the callback function for scroll event.
     * @event
     */
    scroll: EmitType<ScrollEventArgs>;
    /**
     * Specifies the time delay for tap.
     * @default 350
     */
    tapThreshold: number;
    /**
     * Specifies the time delay for tap hold.
     * @default 750
     */
    tapHoldThreshold: number;
    /**
     * Customize the swipe event configuration.
     * @default { swipeThresholdDistance: 50 }
     */
    swipeSettings: SwipeSettingsModel;
    private tapCount;
    constructor(element: HTMLElement, options?: TouchModel);
    /**
     * @private
     * @param newProp
     * @param oldProp
     */
    onPropertyChanged(newProp: TouchModel, oldProp: TouchModel): void;
    protected bind(): void;
    /**
     * To destroy the touch instance.
     * @return {void}
     */
    destroy(): void;
    private wireEvents;
    private unwireEvents;
    /**
     * Returns module name as touch
     * @returns {string}
     * @private
     */
    getModuleName(): string;
    /**
     * Returns if the HTML element is Scrollable.
     * @param {HTMLElement} element - HTML Element to check if Scrollable.
     * @returns {boolean}
     */
    private isScrollable;
    private startEvent;
    private moveEvent;
    private cancelEvent;
    private tapHoldEvent;
    private endEvent;
    private swipeFn;
    private modeclear;
    private calcPoints;
    private calcScrollPoints;
    private getVelocity;
    private checkSwipe;
}
/**
 * The argument type of `Tap` Event
 */
export interface TapEventArgs extends BaseEventArgs {
    /**
     * Original native event Object.
     */
    originalEvent: TouchEventArgs | MouseEventArgs;
    /**
     * Tap Count.
     */
    tapCount?: number;
}
/**
 * The argument type of `Scroll` Event
 */
export interface ScrollEventArgs extends BaseEventArgs {
    /**
     * Event argument for start event.
     */
    startEvents: TouchEventArgs | MouseEventArgs;
    /**
     * Original native event object for scroll.
     */
    originalEvent: TouchEventArgs | MouseEventArgs;
    /**
     * X position when scroll started.
     */
    startX: number;
    /**
     * Y position when scroll started.
     */
    startY: number;
    /**
     * The direction scroll.
     */
    scrollDirection: string;
    /**
     * The total traveled distance from X position
     */
    distanceX: number;
    /**
     * The total traveled distance from Y position
     */
    distanceY: number;
    /**
     * The velocity of scroll.
     */
    velocity: number;
}
/**
 * The argument type of `Swipe` Event
 */
export interface SwipeEventArgs extends BaseEventArgs {
    /**
     * Event argument for start event.
     */
    startEvents: TouchEventArgs | MouseEventArgs;
    /**
     * Original native event object  for swipe.
     */
    originalEvent: TouchEventArgs | MouseEventArgs;
    /**
     * X position when swipe started.
     */
    startX: number;
    /**
     * Y position when swipe started.
     */
    startY: number;
    /**
     * The direction swipe.
     */
    swipeDirection: string;
    /**
     * The total traveled distance from X position
     */
    distanceX: number;
    /**
     * The total traveled distance from Y position
     */
    distanceY: number;
    /**
     * The velocity of swipe.
     */
    velocity: number;
}
export interface TouchEventArgs extends MouseEvent {
    /**
     * A TouchList with touched points.
     */
    changedTouches: MouseEventArgs[] | TouchEventArgs[];
    /**
     * Cancel the default action.
     */
    preventDefault(): void;
    /**
     * The horizontal coordinate point of client area.
     */
    clientX: number;
    /**
     * The vertical coordinate point of client area.
     */
    clientY: number;
}
export interface MouseEventArgs extends MouseEvent {
    /**
     * A TouchList with touched points.
     */
    changedTouches: MouseEventArgs[] | TouchEventArgs[];
    /**
     * Cancel the default action.
     */
    preventDefault(): void;
    /**
     * The horizontal coordinate point of client area.
     */
    clientX: number;
    /**
     * The vertical coordinate point of client area.
     */
    clientY: number;
}
//node_modules/@syncfusion/ej2-base/src/util.d.ts
/**
 * Common utility methods
 */
export interface IKeyValue extends CSSStyleDeclaration {
    [key: string]: any;
}
/**
 * Create Instance from constructor function with desired parameters.
 * @param {Function} classFunction - Class function to which need to create instance
 * @param {any[]} params - Parameters need to passed while creating instance
 * @return {any}
 * @private
 */
export  function createInstance(classFunction: Function, params: any[]): any;
/**
 * To run a callback function immediately after the browser has completed other operations.
 * @param {Function} handler - callback function to be triggered.
 * @return {Function}
 * @private
 */
export  function setImmediate(handler: Function): Function;
/**
 * To get nameSpace value from the desired object.
 * @param {string} nameSpace - String value to the get the inner object
 * @param {any} obj - Object to get the inner object value.
 * @return {any}
 * @private
 */
export  function getValue(nameSpace: string, obj: any): any;
/**
 * To set value for the nameSpace in desired object.
 * @param {string} nameSpace - String value to the get the inner object
 * @param {any} value - Value that you need to set.
 * @param {any} obj - Object to get the inner object value.
 * @return {void}
 * @private
 */
export  function setValue(nameSpace: string, value: any, obj: any): any;
/**
 * Delete an item from Object
 * @param {any} obj - Object in which we need to delete an item.
 * @param {string} params - String value to the get the inner object
 * @return {void}
 * @private
 */
export  function deleteObject(obj: any, key: string): void;
/**
 * Check weather the given argument is only object.
 * @param {any} obj - Object which is need to check.
 * @return {boolean}
 * @private
 */
export  function isObject(obj: any): boolean;
/**
 * To get enum value by giving the string.
 * @param {any} enumObject - Enum object.
 * @param {string} enumValue - Enum value to be searched
 * @return {any}
 * @private
 */
export  function getEnumValue(enumObject: any, enumValue: string | number): any;
/**
 * Merge the source object into destination object.
 * @param {any} source - source object which is going to merge with destination object
 * @param {any} destination - object need to be merged
 * @return {void}
 * @private
 */
export  function merge(source: Object, destination: Object): void;
/**
 * Extend the two object with newer one.
 * @param {any} copied - Resultant object after merged
 * @param {Object} first - First object need to merge
 * @param {Object} second - Second object need to merge
 * @return {Object}
 * @private
 */
export  function extend(copied: Object, first: Object, second?: Object, deep?: boolean): Object;
/**
 * To check whether the object is null or undefined.
 * @param {Object} value - To check the object is null or undefined
 * @return {boolean}
 * @private
 */
export  function isNullOrUndefined(value: Object): boolean;
/**
 * To check whether the object is undefined.
 * @param {Object} value - To check the object is undefined
 * @return {boolean}
 * @private
 */
export  function isUndefined(value: Object): boolean;
/**
 * To return the generated unique name
 * @param {string} definedName - To concatenate the unique id to provided name
 * @return {string}
 * @private
 */
export  function getUniqueID(definedName?: string): string;
/**
 * It limits the rate at which a function can fire. The function will fire only once every provided second instead of as quickly.
 * @param {Function} eventFunction - Specifies the function to run when the event occurs
 * @param {number} delay - A number that specifies the milliseconds for function delay call option
 * @return {Function}
 * @private
 */
export  function debounce(eventFunction: Function, delay: number): Function;
/**
 * To convert the object to string for query url
 * @param  {Object} data
 * @returns string
 * @private
 */
export  function queryParams(data: any): string;
/**
 * To check whether the given array contains object.
 * @param {T[]} value- Specifies the T type array to be checked.
 * @private
 */
export  function isObjectArray<T>(value: T[]): boolean;
/**
 * To check whether the  child element is descendant to parent element or parent and child are same element.
 * @param{Element} - Specifies the child element to compare with parent.
 * @param{Element} - Specifies the parent element.
 * @return boolean
 * @private
 */
export  function compareElementParent(child: Element, parent: Element): boolean;
/**
 * To throw custom error message.
 * @param{string} - Specifies the error message to be thrown.
 * @private
 */
export  function throwError(message: string): void;
/**
 * This function is used to print given element
 * @param{Element} element - Specifies the print content element.
 * @param{Window} printWindow - Specifies the print window.
 * @private
 */
export  function print(element: Element, printWindow?: Window): Window;
/**
 * Function to normalize the units applied to the element.
 * @param  {number|string} value
 * @return {string} result
 * @private
 */
export  function formatUnit(value: number | string): string;
/**
 * Function to check whether the platform is blazor or not.
 * @return {boolean} result
 * @private
 */
export  function isBlazor(): boolean;
/**
 * Function to convert xPath to DOM element in blazor platform
 * @return {HTMLElement} result
 * @param {HTMLElement | object} element
 * @private
 */
export  function getElement(element: object): HTMLElement;
/**
 * Function to fetch the Instances of a HTML element for the given component.
 * @param {string | HTMLElement} element
 * @param {any} component
 * @return {Object} inst
 * @private
 */
export  function getInstance(element: string | HTMLElement, component: any): Object;
/**
 * Function to add instances for the given element.
 * @param {string | HTMLElement} element
 * @param {Object} instance
 * @return {void}
 * @private
 */
export  function addInstance(element: string | HTMLElement, instance: Object): void;
/**
 * Function to generate the unique id.
 * @return {any}
 * @private
 */
export  function uniqueID(): any;
 }
export namespace build { 

 }
export namespace buttons { 

//node_modules/@syncfusion/ej2-buttons/src/button/button-model.d.ts
/**
 * Interface for a class Button
 */
export interface ButtonModel extends base.ComponentModel{
    /**
     * Positions the icon before/after the text content in the Button.
     * The possible values are:
     * * Left: The icon will be positioned to the left of the text content.
     * * Right: The icon will be positioned to the right of the text content.
     * @default "left"
     */
    iconPosition?: IconPosition;
    /**
     * Defines class/multiple classes separated by a space for the Button that is used to include an icon.
     * Buttons can also include font icon and sprite image.
     * @default ""
     */
    iconCss?: string;
    /**
     * Specifies a value that indicates whether the Button is `disabled` or not.
     * @default false.
     */
    disabled?: boolean;
    /**
     * Allows the appearance of the Button to be enhanced and visually appealing when set to `true`.
     * @default false
     */
    isPrimary?: boolean;
    /**
     * Defines class/multiple classes separated by a space in the Button element. The Button types, styles, and
     * size can be defined by using
     * [`this`](http://ej2.syncfusion.com/documentation/button/howto.html?lang=typescript#create-a-block-button).
     * @default ""
     */
    cssClass?: string;
    /**
     * Defines the text `content` of the Button element.
     * @default ""
     */
    content?: string;
    /**
     * Makes the Button toggle, when set to `true`. When you click it, the state changes from normal to active.
     * @default false
     */
    isToggle?: boolean;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @private
     */
    locale?: string;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Event>;
}
//node_modules/@syncfusion/ej2-buttons/src/button/button.d.ts
export  type IconPosition = 'Left' | 'Right' | 'Top' | 'Bottom';
/**
 * The Button is a graphical user interface element that triggers an event on its click action. It can contain a text, an image, or both.
 * ```html
 * <button id="button">Button</button>
 * ```
 * ```typescript
 * <script>
 * var btnObj = new Button();
 * btnObj.appendTo("#button");
 * </script>
 * ```
 */
export  class Button extends base.Component<HTMLButtonElement> implements base.INotifyPropertyChanged {
    private removeRippleEffect;
    /**
     * Positions the icon before/after the text content in the Button.
     * The possible values are:
     * * Left: The icon will be positioned to the left of the text content.
     * * Right: The icon will be positioned to the right of the text content.
     * @default "left"
     */
    iconPosition: IconPosition;
    /**
     * Defines class/multiple classes separated by a space for the Button that is used to include an icon.
     * Buttons can also include font icon and sprite image.
     * @default ""
     */
    iconCss: string;
    /**
     * Specifies a value that indicates whether the Button is `disabled` or not.
     * @default false.
     */
    disabled: boolean;
    /**
     * Allows the appearance of the Button to be enhanced and visually appealing when set to `true`.
     * @default false
     */
    isPrimary: boolean;
    /**
     * Defines class/multiple classes separated by a space in the Button element. The Button types, styles, and
     * size can be defined by using
     * [`this`](http://ej2.syncfusion.com/documentation/button/howto.html?lang=typescript#create-a-block-button).
     * @default ""
     */
    cssClass: string;
    /**
     * Defines the text `content` of the Button element.
     * @default ""
     */
    content: string;
    /**
     * Makes the Button toggle, when set to `true`. When you click it, the state changes from normal to active.
     * @default false
     */
    isToggle: boolean;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @private
     */
    locale: string;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Event>;
    /**
     * Constructor for creating the widget
     * @param  {ButtonModel} options?
     * @param  {string|HTMLButtonElement} element?
     */
    constructor(options?: ButtonModel, element?: string | HTMLButtonElement);
    protected preRender(): void;
    /**
     * Initialize the control rendering
     * @returns void
     * @private
     */
    render(): void;
    private initialize;
    private controlStatus;
    private setIconCss;
    protected wireEvents(): void;
    protected unWireEvents(): void;
    private btnClickHandler;
    /**
     * Destroys the widget.
     * @returns void
     */
    destroy(): void;
    /**
     * Get component name.
     * @returns string
     * @private
     */
    getModuleName(): string;
    /**
     * Get the properties to be maintained in the persisted state.
     * @returns string
     * @private
     */
    getPersistData(): string;
    /**
     * Dynamically injects the required modules to the component.
     * @private
     */
    static Inject(): void;
    /**
     * Called internally if any of the property value changed.
     * @param  {ButtonModel} newProp
     * @param  {ButtonModel} oldProp
     * @returns void
     * @private
     */
    onPropertyChanged(newProp: ButtonModel, oldProp: ButtonModel): void;
    /**
     * Click the button element
     * its native method
     * @public
     */
    click(): void;
    /**
     * Sets the focus to Button
     * its native method
     * @public
     */
    focusIn(): void;
}
//node_modules/@syncfusion/ej2-buttons/src/button/index.d.ts
/**
 * Button modules
 */
//node_modules/@syncfusion/ej2-buttons/src/check-box/check-box-model.d.ts
/**
 * Interface for a class CheckBox
 */
export interface CheckBoxModel extends base.ComponentModel{
    /**
     * Triggers when the CheckBox state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the CheckBox is `checked` or not.
     * When set to `true`, the CheckBox will be in `checked` state.
     * @default false
     */
    checked?: boolean;
    /**
     * Defines class/multiple classes separated by a space in the CheckBox element.
     * You can add custom styles to the CheckBox by using this property.
     * @default ''
     */
    cssClass?: string;
    /**
     * Specifies a value that indicates whether the CheckBox is `disabled` or not.
     * When set to `true`, the CheckBox will be in `disabled` state.
     * @default false
     */
    disabled?: boolean;
    /**
     * Specifies a value that indicates whether the CheckBox is in `indeterminate` state or not.
     * When set to `true`, the CheckBox will be in `indeterminate` state.
     * @default false
     */
    indeterminate?: boolean;
    /**
     * Defines the caption for the CheckBox, that describes the purpose of the CheckBox.
     * @default ''
     */
    label?: string;
    /**
     * Positions label `before`/`after` the CheckBox.
     * The possible values are:
     * * Before - The label is positioned to left of the CheckBox.
     * * After - The label is positioned to right of the CheckBox.
     * @default 'After'
     */
    labelPosition?: LabelPosition;
    /**
     * Defines `name` attribute for the CheckBox.
     * It is used to reference form data (CheckBox value) after a form is submitted.
     * @default ''
     */
    name?: string;
    /**
     * Defines `value` attribute for the CheckBox.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value?: string;
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes?: { [key: string]: string;
 };
}
//node_modules/@syncfusion/ej2-buttons/src/check-box/check-box.d.ts
export  type LabelPosition = 'After' | 'Before';
/**
 * The CheckBox is a graphical user interface element that allows you to select one or more options from the choices.
 * It contains checked, unchecked, and indeterminate states.
 * ```html
 * <input type="checkbox" id="checkbox"/>
 * <script>
 * var checkboxObj = new CheckBox({ label: "Default" });
 * checkboxObj.appendTo("#checkbox");
 * </script>
 * ```
 */
export  class CheckBox extends base.Component<HTMLInputElement> implements base.INotifyPropertyChanged {
    private tagName;
    private isFocused;
    private isMouseClick;
    private keyboardModule;
    private formElement;
    private initialCheckedValue;
    /**
     * Triggers when the CheckBox state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the CheckBox is `checked` or not.
     * When set to `true`, the CheckBox will be in `checked` state.
     * @default false
     */
    checked: boolean;
    /**
     * Defines class/multiple classes separated by a space in the CheckBox element.
     * You can add custom styles to the CheckBox by using this property.
     * @default ''
     */
    cssClass: string;
    /**
     * Specifies a value that indicates whether the CheckBox is `disabled` or not.
     * When set to `true`, the CheckBox will be in `disabled` state.
     * @default false
     */
    disabled: boolean;
    /**
     * Specifies a value that indicates whether the CheckBox is in `indeterminate` state or not.
     * When set to `true`, the CheckBox will be in `indeterminate` state.
     * @default false
     */
    indeterminate: boolean;
    /**
     * Defines the caption for the CheckBox, that describes the purpose of the CheckBox.
     * @default ''
     */
    label: string;
    /**
     * Positions label `before`/`after` the CheckBox.
     * The possible values are:
     * * Before - The label is positioned to left of the CheckBox.
     * * After - The label is positioned to right of the CheckBox.
     * @default 'After'
     */
    labelPosition: LabelPosition;
    /**
     * Defines `name` attribute for the CheckBox.
     * It is used to reference form data (CheckBox value) after a form is submitted.
     * @default ''
     */
    name: string;
    /**
     * Defines `value` attribute for the CheckBox.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value: string;
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes: {
        [key: string]: string;
    };
    /**
     * Constructor for creating the widget
     * @private
     */
    constructor(options?: CheckBoxModel, element?: string | HTMLInputElement);
    private changeState;
    private clickHandler;
    /**
     * Destroys the widget.
     * @returns void
     */
    destroy(): void;
    private focusHandler;
    private focusOutHandler;
    /**
     * Gets the module name.
     * @private
     */
    protected getModuleName(): string;
    /**
     * Gets the properties to be maintained in the persistence state.
     * @private
     */
    getPersistData(): string;
    private getWrapper;
    private initialize;
    private initWrapper;
    private keyUpHandler;
    private labelMouseHandler;
    /**
     * Called internally if any of the property value changes.
     * @private
     */
    onPropertyChanged(newProp: CheckBoxModel, oldProp: CheckBoxModel): void;
    /**
     * Initialize Angular, React and Unique ID support.
     * @private
     */
    protected preRender(): void;
    /**
     * Initialize the control rendering.
     * @private
     */
    protected render(): void;
    private setDisabled;
    private setText;
    private changeHandler;
    private formResetHandler;
    protected unWireEvents(): void;
    protected wireEvents(): void;
    protected updateHtmlAttributeToWrapper(): void;
    /**
     * Click the CheckBox element
     * its native method
     * @public
     */
    click(): void;
    /**
     * Sets the focus to CheckBox
     * its native method
     * @public
     */
    focusIn(): void;
}
//node_modules/@syncfusion/ej2-buttons/src/check-box/index.d.ts
/**
 * CheckBox modules
 */
//node_modules/@syncfusion/ej2-buttons/src/chips/chip-list-model.d.ts
/**
 * Interface for a class ChipList
 */
export interface ChipListModel extends base.ComponentModel{
    /**
     * This chips property helps to render ChipList component.
     * @default []
     */
    chips?: string[] | number[] | ChipModel[];
    /**
     * This text property helps to render Chip component.
     * @default ''
     */
    text?: string;
    /**
     * This avatarText property helps to customize avatar content.
     * @default ''
     */
    avatarText?: string;
    /**
     * This avatarIconCss property helps to customize avatar element.
     * @default ''
     */
    avatarIconCss?: string;
    /**
     * This leadingIconCss property helps to customize leading icon element.
     * @default ''
     */
    leadingIconCss?: string;
    /**
     * This trailingIconCss property helps to customize trailing icon element.
     * @default ''
     */
    trailingIconCss?: string;
    /**
     * This cssClass property helps to customize ChipList component.
     * @default ''
     */
    cssClass?: string;
    /**
     * This enabled property helps to enable/disable ChipList component.
     * @default true
     */
    enabled?: boolean;
    /**
     * This selectedChips property helps to select chip items.
     * @default []
     */
    selectedChips?: number[] | number;
    /**
     * This selection property enables chip selection type.
     * @default 'None'
     */
    selection?: Selection;
    /**
     * This enableDelete property helps to enable delete functionality.
     * @default false
     */
    enableDelete?: boolean;
    /**
     * This created event will get triggered once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Event>;
    /**
     * This click event will get triggered once the chip is clicked.
     * @event
     * @blazorProperty 'OnClick'
     */
    click?: base.EmitType<ClickEventArgs>;
    /**
     * This delete event will get triggered before removing the chip.
     * @event
     * @blazorProperty 'OnDelete'
     */
    delete?: base.EmitType<DeleteEventArgs>;
}
//node_modules/@syncfusion/ej2-buttons/src/chips/chip-list.d.ts
export  const classNames: ClassNames;
export  type Selection = 'Single' | 'Multiple' | 'None';
export interface ClassNames {
    chipSet: string;
    chip: string;
    avatar: string;
    text: string;
    icon: string;
    delete: string;
    deleteIcon: string;
    multiSelection: string;
    singleSelection: string;
    active: string;
    chipWrapper: string;
    iconWrapper: string;
    focused: string;
    disabled: string;
    rtl: string;
}
export interface SelectedItems {
    /**
     * It denotes the selected items text.
     */
    texts: string[];
    /**
     * It denotes the selected items index.
     */
    Indexes: number[];
    /**
     * It denotes the selected items data.
     */
    data: string[] | number[] | ChipModel[];
    /**
     * It denotes the selected items element.
     */
    elements: HTMLElement[];
}
export interface SelectedItem {
    /**
     * It denotes the selected item text.
     */
    text: string;
    /**
     * It denotes the selected item index.
     */
    index: number;
    /**
     * It denotes the selected item data.
     */
    data: string | number | ChipModel;
    /**
     * It denotes the selected item element.
     */
    element: HTMLElement;
}
export interface ClickEventArgs {
    /**
     * It denotes the clicked item text.
     */
    text: string;
    /**
     * It denotes the clicked item index.
     */
    index?: number;
    /**
     * It denotes the clicked item data.
     */
    data: string | number | ChipModel;
    /**
     * It denotes the clicked item element.
     */
    element: HTMLElement;
    /**
     * It denotes whether the clicked item is selected or not.
     */
    selected?: boolean;
    /**
     * It denotes the event.
     */
    event: base.MouseEventArgs | base.KeyboardEventArgs;
}
export interface DeleteEventArgs {
    /**
     * It denotes the deleted item text.
     */
    text: string;
    /**
     * It denotes the deleted item index.
     */
    index: number;
    /**
     * It denotes the deleted item data.
     */
    data: string | number | ChipModel;
    /**
     * It denotes the deleted Item element.
     */
    element: HTMLElement;
    /**
     * It denotes whether the item can be deleted or not.
     */
    cancel: boolean;
    /**
     * It denotes the event.
     */
    event: base.MouseEventArgs | base.KeyboardEventArgs;
}
export interface ChipDataArgs {
    /**
     * It denotes the item text.
     */
    text: string;
    /**
     * It denotes the Item index.
     */
    index: number;
    /**
     * It denotes the item data.
     */
    data: string | number | ChipModel;
    /**
     * It denotes the item element.
     */
    element: HTMLElement;
}
/**
 * A chip component is a small block of essential information, mostly used on contacts or filter tags.
 * ```html
 * <div id="chip"></div>
 * ```
 * ```typescript
 * <script>
 * var chipObj = new ChipList();
 * chipObj.appendTo("#chip");
 * </script>
 * ```
 */
export  class ChipList extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * This chips property helps to render ChipList component.
     * @default []
     */
    chips: string[] | number[] | ChipModel[];
    /**
     * This text property helps to render Chip component.
     * @default ''
     */
    text: string;
    /**
     * This avatarText property helps to customize avatar content.
     * @default ''
     */
    avatarText: string;
    /**
     * This avatarIconCss property helps to customize avatar element.
     * @default ''
     */
    avatarIconCss: string;
    /**
     * This leadingIconCss property helps to customize leading icon element.
     * @default ''
     */
    leadingIconCss: string;
    /**
     * This trailingIconCss property helps to customize trailing icon element.
     * @default ''
     */
    trailingIconCss: string;
    /**
     * This cssClass property helps to customize ChipList component.
     * @default ''
     */
    cssClass: string;
    /**
     * This enabled property helps to enable/disable ChipList component.
     * @default true
     */
    enabled: boolean;
    /**
     * This selectedChips property helps to select chip items.
     * @default []
     */
    selectedChips: number[] | number;
    /**
     * This selection property enables chip selection type.
     * @default 'None'
     */
    selection: Selection;
    /**
     * This enableDelete property helps to enable delete functionality.
     * @default false
     */
    enableDelete: boolean;
    /**
     * This created event will get triggered once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Event>;
    /**
     * This click event will get triggered once the chip is clicked.
     * @event
     * @blazorProperty 'OnClick'
     */
    click: base.EmitType<ClickEventArgs>;
    /**
     * This delete event will get triggered before removing the chip.
     * @event
     * @blazorProperty 'OnDelete'
     */
    delete: base.EmitType<DeleteEventArgs>;
    constructor(options?: ChipListModel, element?: string | HTMLElement);
    private rippleFunctin;
    private type;
    private innerText;
    preRender(): void;
    render(): void;
    private createChip;
    private setAttributes;
    private setRtl;
    private chipCreation;
    private getFieldValues;
    private elementCreation;
    /**
     * A function that finds chip based on given input.
     * @param  {number | HTMLElement } fields - We can pass index number or element of chip.
     */
    find(fields: number | HTMLElement): ChipDataArgs;
    /**
     * A function that adds chip items based on given input.
     * @param  {string[] | number[] | ChipModel[] | string | number | ChipModel} chipsData - We can pass array of string or
     *  array of number or array of chip model or string data or number data or chip model.
     */
    add(chipsData: string[] | number[] | ChipModel[] | string | number | ChipModel): void;
    /**
     * A function that selects chip items based on given input.
     * @param  {number | number[] | HTMLElement | HTMLElement[]} fields - We can pass number or array of number
     *  or chip element or array of chip element.
     */
    select(fields: number | number[] | HTMLElement | HTMLElement[]): void;
    /**
     * A function that removes chip items based on given input.
     * @param  {number | number[] | HTMLElement | HTMLElement[]} fields - We can pass number or array of number
     *  or chip element or array of chip element.
     */
    remove(fields: number | number[] | HTMLElement | HTMLElement[]): void;
    /**
     * A function that returns selected chips data.
     */
    getSelectedChips(): SelectedItem | SelectedItems;
    private wireEvent;
    private keyHandler;
    private focusInHandler;
    private focusOutHandler;
    private clickHandler;
    private selectionHandler;
    private deleteHandler;
    /**
     * It is used to destroy the ChipList component.
     */
    destroy(): void;
    private removeMultipleAttributes;
    getPersistData(): string;
    getModuleName(): string;
    onPropertyChanged(newProp: ChipList, oldProp: ChipList): void;
}
//node_modules/@syncfusion/ej2-buttons/src/chips/chip.d.ts
/**
 * Represents ChipList `Chip` model class.
 */
export  class Chip {
    /**
     * This text property helps to render ChipList component.
     * @default ''
     */
    text: string;
    /**
     * This avatarText property helps to customize avatar content.
     * @default ''
     */
    avatarText: string;
    /**
     * This avatarIconCss property helps to customize avatar element.
     * @default ''
     */
    avatarIconCss: string;
    /**
     * This leadingIconCss property helps to customize leading icon element.
     * @default ''
     */
    leadingIconCss: string;
    /**
     * This trailingIconCss property helps to customize trailing icon element.
     * @default ''
     */
    trailingIconCss: string;
    /**
     * This cssClass property helps to customize ChipList component.
     * @default ''
     */
    cssClass: string;
    /**
     * This enabled property helps to enable/disable ChipList component.
     * @default true
     */
    enabled: boolean;
}
export interface ChipModel {
    /**
     * This text property helps to render ChipList component.
     * @default ''
     */
    text?: string;
    /**
     * This avatarText property helps to customize avatar content.
     * @default ''
     */
    avatarText?: string;
    /**
     * This avatarIconCss property helps to customize avatar element.
     * @default ''
     */
    avatarIconCss?: string;
    /**
     * This leadingIconCss property helps to customize leading icon element.
     * @default ''
     */
    leadingIconCss?: string;
    /**
     * This trailingIconCss property helps to customize trailing icon element.
     * @default ''
     */
    trailingIconCss?: string;
    /**
     * This cssClass property helps to customize ChipList component.
     * @default ''
     */
    cssClass?: string;
    /**
     * This enabled property helps to enable/disable ChipList component.
     * @default true
     */
    enabled?: boolean;
}
//node_modules/@syncfusion/ej2-buttons/src/chips/index.d.ts
/**
 * Chip modules
 */
//node_modules/@syncfusion/ej2-buttons/src/common/common.d.ts
/**
 * Initialize wrapper element for angular.
 * @private
 */
export  function wrapperInitialize(createElement: CreateElementArgs, tag: string, type: string, element: HTMLInputElement, WRAPPER: string, role: string): HTMLInputElement;
export  function getTextNode(element: HTMLElement): Node;
/**
 * Destroy the button components.
 * @private
 */
export  function destroy(ejInst: Switch | CheckBox, wrapper: Element, tagName: string): void;
export  function preRender(proxy: Switch | CheckBox, control: string, wrapper: string, element: HTMLInputElement, moduleName: string): void;
/**
 * Creates CheckBox component UI with theming and ripple support.
 * @private
 */
export  function createCheckBox(createElement: CreateElementArgs, enableRipple?: boolean, options?: CheckBoxUtilModel): Element;
export  function rippleMouseHandler(e: MouseEvent, rippleSpan: Element): void;
/**
 * Append hidden input to given element
 * @private
 */
export  function setHiddenInput(proxy: Switch | CheckBox, wrap: Element): void;
export interface CheckBoxUtilModel {
    checked?: boolean;
    label?: string;
    enableRtl?: boolean;
    cssClass?: string;
}
export interface ChangeEventArgs extends base.BaseEventArgs {
    /** Returns the event parameters of the CheckBox or Switch. */
    event?: Event;
    /** Returns the checked value of the CheckBox or Switch. */
    checked?: boolean;
}
export  type CreateElementArgs = (tag: string, prop?: {
    id?: string;
    className?: string;
    innerHTML?: string;
    styles?: string;
    attrs?: {
        [key: string]: string;
    };
}) => HTMLElement;
//node_modules/@syncfusion/ej2-buttons/src/common/index.d.ts
/**
 * Common modules
 */
//node_modules/@syncfusion/ej2-buttons/src/index.d.ts
/**
 * Button all modules
 */
//node_modules/@syncfusion/ej2-buttons/src/radio-button/index.d.ts
/**
 * RadioButton modules
 */
//node_modules/@syncfusion/ej2-buttons/src/radio-button/radio-button-model.d.ts
/**
 * Interface for a class RadioButton
 */
export interface RadioButtonModel extends base.ComponentModel{
    /**
     * base.Event trigger when the RadioButton state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<ChangeArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the RadioButton is `checked` or not.
     * When set to `true`, the RadioButton will be in `checked` state.
     * @default false
     */
    checked?: boolean;
    /**
     * Defines class/multiple classes separated by a space in the RadioButton element.
     * You can add custom styles to the RadioButton by using this property.
     * @default ''
     */
    cssClass?: string;
    /**
     * Specifies a value that indicates whether the RadioButton is `disabled` or not.
     * When set to `true`, the RadioButton will be in `disabled` state.
     * @default false
     */
    disabled?: boolean;
    /**
     * Defines the caption for the RadioButton, that describes the purpose of the RadioButton.
     * @default ''
     */
    label?: string;
    /**
     * Positions label `before`/`after` the RadioButton.
     * The possible values are:
     * * Before: The label is positioned to left of the RadioButton.
     * * After: The label is positioned to right of the RadioButton.
     * @default 'After'
     */
    labelPosition?: RadioLabelPosition;
    /**
     * Defines `name` attribute for the RadioButton.
     * It is used to reference form data (RadioButton value) after a form is submitted.
     * @default ''
     */
    name?: string;
    /**
     * Defines `value` attribute for the RadioButton.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value?: string;
}
//node_modules/@syncfusion/ej2-buttons/src/radio-button/radio-button.d.ts
export  type RadioLabelPosition = 'After' | 'Before';
/**
 * The RadioButton is a graphical user interface element that allows you to select one option from the choices.
 * It contains checked and unchecked states.
 * ```html
 * <input type="radio" id="radio"/>
 * <script>
 * var radioObj = new RadioButton({ label: "Default" });
 * radioObj.appendTo("#radio");
 * </script>
 * ```
 */
export  class RadioButton extends base.Component<HTMLInputElement> implements base.INotifyPropertyChanged {
    private tagName;
    private isFocused;
    private formElement;
    private initialCheckedValue;
    private angularValue;
    /**
     * Event trigger when the RadioButton state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<ChangeArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the RadioButton is `checked` or not.
     * When set to `true`, the RadioButton will be in `checked` state.
     * @default false
     */
    checked: boolean;
    /**
     * Defines class/multiple classes separated by a space in the RadioButton element.
     * You can add custom styles to the RadioButton by using this property.
     * @default ''
     */
    cssClass: string;
    /**
     * Specifies a value that indicates whether the RadioButton is `disabled` or not.
     * When set to `true`, the RadioButton will be in `disabled` state.
     * @default false
     */
    disabled: boolean;
    /**
     * Defines the caption for the RadioButton, that describes the purpose of the RadioButton.
     * @default ''
     */
    label: string;
    /**
     * Positions label `before`/`after` the RadioButton.
     * The possible values are:
     * * Before: The label is positioned to left of the RadioButton.
     * * After: The label is positioned to right of the RadioButton.
     * @default 'After'
     */
    labelPosition: RadioLabelPosition;
    /**
     * Defines `name` attribute for the RadioButton.
     * It is used to reference form data (RadioButton value) after a form is submitted.
     * @default ''
     */
    name: string;
    /**
     * Defines `value` attribute for the RadioButton.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value: string;
    /**
     * Constructor for creating the widget
     * @private
     */
    constructor(options?: RadioButtonModel, element?: string | HTMLInputElement);
    private changeHandler;
    private updateChange;
    /**
     * Destroys the widget.
     * @returns void
     */
    destroy(): void;
    private focusHandler;
    private focusOutHandler;
    protected getModuleName(): string;
    /**
     * To get the value of selected radio button in a group.
     * @method getSelectedValue
     * @return {string}
     */
    getSelectedValue(): string;
    private getRadioGroup;
    /**
     * Gets the properties to be maintained in the persistence state.
     * @private
     */
    getPersistData(): string;
    private getLabel;
    private initialize;
    private initWrapper;
    private keyUpHandler;
    private labelRippleHandler;
    private formResetHandler;
    /**
     * Called internally if any of the property value changes.
     * @private
     */
    onPropertyChanged(newProp: RadioButtonModel, oldProp: RadioButtonModel): void;
    /**
     * Initialize checked Property, Angular and React and Unique ID support.
     * @private
     */
    protected preRender(): void;
    /**
     * Initialize the control rendering
     * @private
     */
    protected render(): void;
    private setDisabled;
    private setText;
    protected unWireEvents(): void;
    protected wireEvents(): void;
    /**
     * Click the RadioButton element
     * its native method
     * @public
     */
    click(): void;
    /**
     * Sets the focus to RadioButton
     * its native method
     * @public
     */
    focusIn(): void;
}
export interface ChangeArgs extends base.BaseEventArgs {
    /** Returns the value of the RadioButton. */
    value?: string;
    /** Returns the event parameters of the RadioButton. */
    event?: Event;
}
//node_modules/@syncfusion/ej2-buttons/src/switch/index.d.ts
/**
 * Switch modules
 */
//node_modules/@syncfusion/ej2-buttons/src/switch/switch-model.d.ts
/**
 * Interface for a class Switch
 */
export interface SwitchModel extends base.ComponentModel{
    /**
     * Triggers when Switch state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the Switch is `checked` or not.
     * When set to `true`, the Switch will be in `checked` state.
     * @default false
     */
    checked?: boolean;
    /**
     * You can add custom styles to the Switch by using this property.
     * @default ''
     */
    cssClass?: string;
    /**
     * Specifies a value that indicates whether the Switch is `disabled` or not.
     * When set to `true`, the Switch will be in `disabled` state.
     * @default false
     */
    disabled?: boolean;
    /**
     * Defines `name` attribute for the Switch.
     * It is used to reference form data (Switch value) after a form is submitted.
     * @default ''
     */
    name?: string;
    /**
     * Specifies a text that indicates the Switch is in checked state.
     * @default ''
     */
    onLabel?: string;
    /**
     * Specifies a text that indicates the Switch is in unchecked state.
     * @default ''
     */
    offLabel?: string;
    /**
     * Defines `value` attribute for the Switch.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value?: string;
}
//node_modules/@syncfusion/ej2-buttons/src/switch/switch.d.ts
/**
 * The Switch is a graphical user interface element that allows you to toggle between checked and unchecked states.
 * ```html
 * <input type="checkbox" id="switch"/>
 * <script>
 * var switchObj = new Switch({});
 * switchObj.appendTo("#switch");
 * </script>
 * ```
 */
export  class Switch extends base.Component<HTMLInputElement> implements base.INotifyPropertyChanged {
    private tagName;
    private isFocused;
    private isDrag;
    private delegateMouseUpHandler;
    private delegateKeyUpHandler;
    private formElement;
    private initialSwitchCheckedValue;
    /**
     * Triggers when Switch state has been changed by user interaction.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers once the component rendering is completed.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Event>;
    /**
     * Specifies a value that indicates whether the Switch is `checked` or not.
     * When set to `true`, the Switch will be in `checked` state.
     * @default false
     */
    checked: boolean;
    /**
     * You can add custom styles to the Switch by using this property.
     * @default ''
     */
    cssClass: string;
    /**
     * Specifies a value that indicates whether the Switch is `disabled` or not.
     * When set to `true`, the Switch will be in `disabled` state.
     * @default false
     */
    disabled: boolean;
    /**
     * Defines `name` attribute for the Switch.
     * It is used to reference form data (Switch value) after a form is submitted.
     * @default ''
     */
    name: string;
    /**
     * Specifies a text that indicates the Switch is in checked state.
     * @default ''
     */
    onLabel: string;
    /**
     * Specifies a text that indicates the Switch is in unchecked state.
     * @default ''
     */
    offLabel: string;
    /**
     * Defines `value` attribute for the Switch.
     * It is a form data passed to the server when submitting the form.
     * @default ''
     */
    value: string;
    /**
     * Constructor for creating the widget.
     * @private
     */
    constructor(options?: SwitchModel, element?: string | HTMLInputElement);
    private changeState;
    private clickHandler;
    /**
     * Destroys the Switch widget.
     * @returns void
     */
    destroy(): void;
    private focusHandler;
    private focusOutHandler;
    /**
     * Gets the module name.
     * @private
     */
    protected getModuleName(): string;
    /**
     * Gets the properties to be maintained in the persistence state.
     * @private
     */
    getPersistData(): string;
    private getWrapper;
    private initialize;
    private initWrapper;
    /**
     * Called internally if any of the property value changes.
     * @private
     */
    onPropertyChanged(newProp: SwitchModel, oldProp: SwitchModel): void;
    /**
     * Initialize Angular, React and Unique ID support.
     * @private
     */
    protected preRender(): void;
    /**
     * Initialize control rendering.
     * @private
     */
    protected render(): void;
    private rippleHandler;
    private rippleTouchHandler;
    private setDisabled;
    private setLabel;
    private switchFocusHandler;
    private switchMouseUp;
    private formResetHandler;
    /**
     * Toggle the Switch component state into checked/unchecked.
     * @returns void
     */
    toggle(): void;
    private wireEvents;
    private unWireEvents;
    /**
     * Click the switch element
     * its native method
     * @public
     */
    click(): void;
    /**
     * Sets the focus to Switch
     * its native method
     * @public
     */
    focusIn(): void;
}
 }
export namespace calendars { 

//node_modules/@syncfusion/ej2-calendars/src/calendar/calendar-model.d.ts
/**
 * Interface for a class CalendarBase
 * @private
 */
export interface CalendarBaseModel extends base.ComponentModel{
    /**
     * Gets or sets the minimum date that can be selected in the Calendar.
     * @default new Date(1900, 00, 01)
     * @blazorDefaultValue new DateTime(1900, 01, 01)
     */
    min?: Date;
    /**
     * Gets or sets the maximum date that can be selected in the Calendar.
     * @default new Date(2099, 11, 31)
     * @blazorDefaultValue new DateTime(2099, 12, 31)
     */
    max?: Date;
    /**
     * Gets or sets the Calendar's first day of the week. By default, the first day of the week will be based on the current culture.
     * @default 0
     * @aspType int
     * @blazorType int
     * > For more details about firstDayOfWeek refer to 
     * [`First day of week`](../../calendar/how-to/first-day-of-week#change-the-first-day-of-the-week) documentation.
     */
    firstDayOfWeek?: number;
    /**
     * Gets or sets the Calendar's Type like gregorian or islamic.
     * @default Gregorian
     */
    calendarMode?: CalendarType;
    /**
     * Specifies the initial view of the Calendar when it is opened.
     * With the help of this property, initial view can be changed to year or decade view.
     * @default Month
     *  
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * View<br/></td><td colSpan=1 rowSpan=1>
     * Description<br/></td></tr> 
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Month<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the days of the month.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Year<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the months of the year.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Decade<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the years of the decade.<br/></td></tr>
     * </table>
     *
     * > For more details about start refer to 
     * [`calendarView`](../../calendar/calendar-views#view-restriction)documentation.
     */
    start?: CalendarView;
    /**
     * Sets the maximum level of view such as month, year, and decade in the Calendar.
     * Depth view should be smaller than the start view to restrict its view navigation.
     * @default Month
     * 
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * view<br/></td><td colSpan=1 rowSpan=1> 
     * Description<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Month<br/></td><td colSpan=1 rowSpan=1> 
     * Calendar view shows up to the days of the month.<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Year<br/></td><td colSpan=1 rowSpan=1> 
     * Calendar view shows up to the months of the year.<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Decade<br/></td><td colSpan=1 rowSpan=1> 
     * Calendar view shows up to the years of the decade.<br/></td></tr> 
     * </table> 
     * 
     * > For more details about depth refer to 
     *  [`calendarView`](../../calendar/calendar-views#view-restriction)documentation.
     */
    depth?: CalendarView;
    /**
     * Determines whether the week number of the year is to be displayed in the calendar or not.
     * @default false
     * > For more details about weekNumber refer to 
     * [`Calendar with week number`](../../calendar/how-to/render-the-calendar-with-week-numbers)documentation.
     */
    weekNumber?: boolean;
    /**
     * Specifies whether the today button is to be displayed or not.
     * @default true
     */
    showTodayButton?: boolean;
    /**
     * Specifies the format of the day that to be displayed in header. By default, the format is ‘short’.
     * Possible formats are:
     * * `Short` - Sets the short format of day name (like Su ) in day header.
     * * `Narrow` - Sets the single character of day name (like S ) in day header.
     * * `Abbreviated` - Sets the min format of day name (like Sun ) in day header.
     * * `Wide` - Sets the long format of day name (like Sunday ) in day header.
     * @default Short
     */
    dayHeaderFormat?: DayHeaderFormats;
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * Customizes the key actions in Calendar.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     * 
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlUp<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+38<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlDown<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+40<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * select<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * home<br/></td><td colSpan=1 rowSpan=1> 
     * home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * end<br/></td><td colSpan=1 rowSpan=1> 
     * end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageUp<br/></td><td colSpan=1 rowSpan=1> 
     * pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageDown<br/></td><td colSpan=1 rowSpan=1> 
     * pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlHome<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlEnd<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * spacebar<br/></td><td colSpan=1 rowSpan=1> 
     * space<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+rightarrow<br/></td></tr>  
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveDown<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveUp<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveLeft<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveRight<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * </table>
     * 
     * @default null
     * @blazorType object
     */
    keyConfigs?: { [key: string]: string };
    /**
     * Triggers when Calendar is created.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Object>;
    /**
     * Triggers when Calendar is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed?: base.EmitType<Object>;
    /**
     * Triggers when the Calendar is navigated to another level or within the same level of view.
     * @event
     * @blazorProperty 'Navigated'
     */
    navigated?: base.EmitType<NavigatedEventArgs>;
    /**
     * Triggers when each day cell of the Calendar is rendered.
     * @event
     * @blazorProperty 'OnRenderDayCell'
     */
    renderDayCell?: base.EmitType<RenderDayCellEventArgs>;
}
/**
 * Interface for a class Calendar
 */
export interface CalendarModel extends CalendarBaseModel{
    /**
     * Gets or sets the selected date of the Calendar.
     * @default null
     * @isBlazorNullableType true
     */
    value?: Date;
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     */
    values?: Date[];
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     */
    isMultiSelection?: boolean;
    /**
     * Triggers when the Calendar value is changed.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<ChangedEventArgs>;
}
//node_modules/@syncfusion/ej2-calendars/src/calendar/calendar.d.ts
/**
 * Specifies the view of the calendar.
 */
export  type CalendarView = 'Month' | 'Year' | 'Decade';
export  type CalendarType = 'Islamic' | 'Gregorian';
export  type DayHeaderFormats = 'Short' | 'Narrow' | 'Abbreviated' | 'Wide';
/**
 *
 * @private
 */
export  class CalendarBase extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    protected headerElement: HTMLElement;
    protected contentElement: HTMLElement;
    private calendarEleCopy;
    protected table: HTMLElement;
    protected tableHeadElement: HTMLElement;
    protected tableBodyElement: Element;
    protected nextIcon: HTMLElement;
    protected previousIcon: HTMLElement;
    protected headerTitleElement: HTMLElement;
    protected todayElement: HTMLElement;
    protected footer: HTMLElement;
    protected keyboardModule: base.KeyboardEvents;
    protected globalize: base.Internationalization;
    islamicModule: Islamic;
    protected currentDate: Date;
    protected navigatedArgs: NavigatedEventArgs;
    protected renderDayCellArgs: RenderDayCellEventArgs;
    protected effect: string;
    protected previousDate: Date;
    protected previousValues: number;
    protected navigateHandler: Function;
    protected navigatePreviousHandler: Function;
    protected navigateNextHandler: Function;
    protected l10: base.L10n;
    protected todayDisabled: boolean;
    protected tabIndex: string;
    protected todayDate: Date;
    protected calendarElement: HTMLElement;
    protected isPopupClicked: boolean;
    protected isDateSelected: boolean;
    protected defaultKeyConfigs: {
        [key: string]: string;
    };
    /**
     * Gets or sets the minimum date that can be selected in the Calendar.
     * @default new Date(1900, 00, 01)
     * @blazorDefaultValue new DateTime(1900, 01, 01)
     */
    min: Date;
    /**
     * Gets or sets the maximum date that can be selected in the Calendar.
     * @default new Date(2099, 11, 31)
     * @blazorDefaultValue new DateTime(2099, 12, 31)
     */
    max: Date;
    /**
     * Gets or sets the Calendar's first day of the week. By default, the first day of the week will be based on the current culture.
     * @default 0
     * @aspType int
     * @blazorType int
     * > For more details about firstDayOfWeek refer to
     * [`First day of week`](../../calendar/how-to/first-day-of-week#change-the-first-day-of-the-week) documentation.
     */
    firstDayOfWeek: number;
    /**
     * Gets or sets the Calendar's Type like gregorian or islamic.
     * @default Gregorian
     */
    calendarMode: CalendarType;
    /**
     * Specifies the initial view of the Calendar when it is opened.
     * With the help of this property, initial view can be changed to year or decade view.
     * @default Month
     *
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * View<br/></td><td colSpan=1 rowSpan=1>
     * Description<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Month<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the days of the month.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Year<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the months of the year.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Decade<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows the years of the decade.<br/></td></tr>
     * </table>
     *
     * > For more details about start refer to
     * [`calendarView`](../../calendar/calendar-views#view-restriction)documentation.
     */
    start: CalendarView;
    /**
     * Sets the maximum level of view such as month, year, and decade in the Calendar.
     * Depth view should be smaller than the start view to restrict its view navigation.
     * @default Month
     *
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * view<br/></td><td colSpan=1 rowSpan=1>
     * Description<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Month<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows up to the days of the month.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Year<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows up to the months of the year.<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Decade<br/></td><td colSpan=1 rowSpan=1>
     * Calendar view shows up to the years of the decade.<br/></td></tr>
     * </table>
     *
     * > For more details about depth refer to
     *  [`calendarView`](../../calendar/calendar-views#view-restriction)documentation.
     */
    depth: CalendarView;
    /**
     * Determines whether the week number of the year is to be displayed in the calendar or not.
     * @default false
     * > For more details about weekNumber refer to
     * [`Calendar with week number`](../../calendar/how-to/render-the-calendar-with-week-numbers)documentation.
     */
    weekNumber: boolean;
    /**
     * Specifies whether the today button is to be displayed or not.
     * @default true
     */
    showTodayButton: boolean;
    /**
     * Specifies the format of the day that to be displayed in header. By default, the format is ‘short’.
     * Possible formats are:
     * * `Short` - Sets the short format of day name (like Su ) in day header.
     * * `Narrow` - Sets the single character of day name (like S ) in day header.
     * * `Abbreviated` - Sets the min format of day name (like Sun ) in day header.
     * * `Wide` - Sets the long format of day name (like Sunday ) in day header.
     * @default Short
     */
    dayHeaderFormat: DayHeaderFormats;
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence: boolean;
    /**
     * Customizes the key actions in Calendar.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     *
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlUp<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+38<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlDown<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+40<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * select<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * home<br/></td><td colSpan=1 rowSpan=1>
     * home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * end<br/></td><td colSpan=1 rowSpan=1>
     * end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageUp<br/></td><td colSpan=1 rowSpan=1>
     * pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageDown<br/></td><td colSpan=1 rowSpan=1>
     * pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1>
     * shift+pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1>
     * shift+pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlHome<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlEnd<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * spacebar<br/></td><td colSpan=1 rowSpan=1>
     * space<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveDown<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveUp<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveLeft<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveRight<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * </table>
     *
     * @default null
     * @blazorType object
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * Triggers when Calendar is created.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Object>;
    /**
     * Triggers when Calendar is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed: base.EmitType<Object>;
    /**
     * Triggers when the Calendar is navigated to another level or within the same level of view.
     * @event
     * @blazorProperty 'Navigated'
     */
    navigated: base.EmitType<NavigatedEventArgs>;
    /**
     * Triggers when each day cell of the Calendar is rendered.
     * @event
     * @blazorProperty 'OnRenderDayCell'
     */
    renderDayCell: base.EmitType<RenderDayCellEventArgs>;
    /**
     * Initialized new instance of Calendar Class.
     * Constructor for creating the widget
     * @param  {CalendarModel} options?
     * @param  {string|HTMLElement} element?
     */
    constructor(options?: CalendarBaseModel, element?: string | HTMLElement);
    /**
     * To Initialize the control rendering.
     * @returns void
     * @private
     */
    protected render(): void;
    protected rangeValidation(min: Date, max: Date): void;
    protected validateDate(value?: Date): void;
    protected setOverlayIndex(popupWrapper: HTMLElement, popupElement: HTMLElement, modal: HTMLElement, isDevice: Boolean): void;
    protected minMaxUpdate(value?: Date): void;
    protected createHeader(): void;
    protected createContent(): void;
    protected getCultureValues(): string[];
    protected createContentHeader(): void;
    protected createContentBody(): void;
    protected updateFooter(): void;
    protected createContentFooter(): void;
    protected wireEvents(): void;
    protected todayButtonClick(value?: Date): void;
    protected keyActionHandle(e: base.KeyboardEventArgs, value?: Date, multiSelection?: boolean): void;
    protected KeyboardNavigate(number: number, currentView: number, e: KeyboardEvent, max: Date, min: Date): void;
    /**
     * Initialize the event handler
     * @private
     */
    protected preRender(value?: Date): void;
    protected minMaxDate(localDate: Date): Date;
    protected renderMonths(e?: Event, value?: Date): void;
    protected renderDays(currentDate: Date, e?: Event, value?: Date, multiSelection?: boolean, values?: Date[]): HTMLElement[];
    protected updateFocus(otherMonth: boolean, disabled: boolean, localDate: Date, tableElement: HTMLElement, currentDate: Date): void;
    protected renderYears(e?: Event, value?: Date): void;
    protected renderDecades(e?: Event, value?: Date): void;
    protected dayCell(localDate: Date): HTMLElement;
    protected firstDay(date: Date): Date;
    protected lastDay(date: Date, view: number): Date;
    protected checkDateValue(value: Date): Date;
    protected findLastDay(date: Date): Date;
    protected removeTableHeadElement(): void;
    protected renderTemplate(elements: HTMLElement[], count: number, classNm: string, e?: Event, value?: Date): void;
    protected clickHandler(e: MouseEvent, value: Date): void;
    protected clickEventEmitter(e: MouseEvent): void;
    protected contentClick(e?: MouseEvent, view?: number, element?: Element, value?: Date): void;
    protected switchView(view: number, e?: Event, multiSelection?: boolean): void;
    /**
     * To get component name
     * @private
     */
    protected getModuleName(): string;
    requiredModules(): base.ModuleDeclaration[];
    /**
     * Gets the properties to be maintained upon browser refresh.
     * @returns string
     */
    getPersistData(): string;
    /**
     * Called internally if any of the property value changed.
     * returns void
     * @private
     */
    onPropertyChanged(newProp: CalendarBaseModel, oldProp: CalendarBaseModel, multiSelection?: boolean, values?: Date[]): void;
    /**
     * values property updated with considered disabled dates of the calendar.
     */
    protected validateValues(multiSelection?: boolean, values?: Date[]): void;
    protected setValueUpdate(): void;
    protected copyValues(values: Date[]): Date[];
    protected titleUpdate(date: Date, view: string): void;
    protected setActiveDescendant(): string;
    protected iconHandler(): void;
    /**
     * Destroys the widget.
     * @returns void
     */
    destroy(): void;
    protected title(e?: Event): void;
    protected getViewNumber(stringVal: string): number;
    protected navigateTitle(e?: Event): void;
    protected previous(): void;
    protected navigatePrevious(e: MouseEvent | KeyboardEvent): void;
    protected next(): void;
    protected navigateNext(eve: MouseEvent | KeyboardEvent): void;
    /**
     * This method is used to navigate to the month/year/decade view of the Calendar.
     * @param  {string} view - Specifies the view of the Calendar.
     * @param  {Date} date - Specifies the focused date in a view.
     * @returns void
     */
    navigateTo(view: CalendarView, date: Date): void;
    /**
     * Gets the current view of the Calendar.
     * @returns string
     */
    currentView(): string;
    protected getDateVal(date: Date, value: Date): boolean;
    protected getCultureObjects(ld: Object, c: string): Object;
    protected getWeek(d: Date): number;
    protected setStartDate(date: Date, time: number): void;
    protected addMonths(date: Date, i: number): void;
    protected addYears(date: Date, i: number): void;
    protected getIdValue(e: MouseEvent | TouchEvent | KeyboardEvent, element: Element): Date;
    protected adjustLongHeaderSize(): void;
    protected selectDate(e: MouseEvent | base.KeyboardEventArgs, date: Date, node: Element, multiSelection?: boolean, values?: Date[]): void;
    protected checkPresentDate(dates: Date, values: Date[]): boolean;
    protected setAriaActiveDescendant(): void;
    protected previousIconHandler(disabled: boolean): void;
    protected renderDayCellEvent(args: RenderDayCellEventArgs): void;
    protected navigatedEvent(eve: MouseEvent | KeyboardEvent): void;
    protected triggerNavigate(event: MouseEvent | KeyboardEvent): void;
    protected nextIconHandler(disabled: boolean): void;
    protected compare(startDate: Date, endDate: Date, modifier: number): number;
    protected isMinMaxRange(date: Date): boolean;
    protected isMonthYearRange(date: Date): boolean;
    protected compareYear(start: Date, end: Date): number;
    protected compareDecade(start: Date, end: Date): number;
    protected shiftArray(array: string[], i: number): string[];
    protected addDay(date: Date, i: number, e: KeyboardEvent, max: Date, min: Date): void;
    protected findNextTD(date: Date, column: number, max: Date, min: Date): boolean;
    protected getMaxDays(d: Date): number;
    protected setDateDecade(date: Date, year: number): void;
    protected setDateYear(date: Date, value: Date): void;
    protected compareMonth(start: Date, end: Date): number;
    protected checkValue(inValue: string | Date | number): string;
    protected checkView(): void;
}
/**
 * Represents the Calendar component that allows the user to select a date.
 * ```html
 * <div id="calendar"/>
 * ```
 * ```typescript
 * <script>
 *   var calendarObj = new Calendar({ value: new Date() });
 *   calendarObj.appendTo("#calendar");
 * </script>
 * ```
 */
export  class Calendar extends CalendarBase {
    protected changedArgs: ChangedEventArgs;
    protected changeHandler: Function;
    /**
     * Gets or sets the selected date of the Calendar.
     * @default null
     * @isBlazorNullableType true
     */
    value: Date;
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     */
    values: Date[];
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     */
    isMultiSelection: boolean;
    /**
     * Triggers when the Calendar value is changed.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<ChangedEventArgs>;
    /**
     * Initialized new instance of Calendar Class.
     * Constructor for creating the widget
     * @param  {CalendarModel} options?
     * @param  {string|HTMLElement} element?
     */
    constructor(options?: CalendarModel, element?: string | HTMLElement);
    /**
     * To Initialize the control rendering.
     * @returns void
     * @private
     */
    protected render(): void;
    protected formResetHandler(): void;
    protected validateDate(): void;
    protected minMaxUpdate(): void;
    protected generateTodayVal(value: Date): Date;
    protected todayButtonClick(): void;
    protected keyActionHandle(e: base.KeyboardEventArgs): void;
    /**
     * Initialize the event handler
     * @private
     */
    protected preRender(): void;
    createContent(): void;
    protected minMaxDate(localDate: Date): Date;
    protected renderMonths(e?: Event): void;
    protected renderDays(currentDate: Date, e?: Event): HTMLElement[];
    protected renderYears(e?: Event): void;
    protected renderDecades(e?: Event): void;
    protected renderTemplate(elements: HTMLElement[], count: number, classNm: string, e?: Event): void;
    protected clickHandler(e: MouseEvent): void;
    protected switchView(view: number, e?: Event): void;
    /**
     * To get component name
     * @private
     */
    protected getModuleName(): string;
    /**
     * Gets the properties to be maintained upon browser refresh.
     * @returns string
     */
    getPersistData(): string;
    /**
     * Called internally if any of the property value changed.
     * returns void
     * @private
     */
    onPropertyChanged(newProp: CalendarModel, oldProp: CalendarModel): void;
    /**
     * Destroys the widget.
     * @returns void
     */
    destroy(): void;
    /**
     * This method is used to navigate to the month/year/decade view of the Calendar.
     * @param  {string} view - Specifies the view of the Calendar.
     * @param  {Date} date - Specifies the focused date in a view.
     * @returns void
     */
    navigateTo(view: CalendarView, date: Date): void;
    /**
     * Gets the current view of the Calendar.
     * @returns string
     */
    currentView(): string;
    /**
     * This method is used to add the single or multiple dates to the values property of the Calendar.
     * @param  {Date || Date[]} dates - Specifies the date or dates to be added to the values property of the Calendar.
     * @returns void
     */
    addDate(dates: Date | Date[]): void;
    /**
     * This method is used to remove the single or multiple dates from the values property of the Calendar.
     * @param  {Date || Date[]} dates - Specifies the date or dates which need to be removed from the values property of the Calendar.
     * @returns void
     */
    removeDate(dates: Date | Date[]): void;
    protected update(): void;
    protected selectDate(e: MouseEvent | base.KeyboardEventArgs, date: Date, element: Element): void;
    protected changeEvent(e: Event): void;
    protected triggerChange(e: MouseEvent | KeyboardEvent): void;
}
export interface NavigatedEventArgs extends base.BaseEventArgs {
    /** Defines the current view of the Calendar. */
    view?: string;
    /** Defines the focused date in a view. */
    date?: Date;
    /**
     * Specifies the original event arguments.
     */
    event?: KeyboardEvent | MouseEvent | Event;
}
export interface RenderDayCellEventArgs extends base.BaseEventArgs {
    /** Specifies whether to disable the current date or not. */
    isDisabled?: boolean;
    /** Specifies the day cell element. */
    element?: HTMLElement;
    /** Defines the current date of the Calendar. */
    date?: Date;
    /** Defines whether the current date is out of range (less than min or greater than max) or not. */
    isOutOfRange?: boolean;
}
export interface ChangedEventArgs extends base.BaseEventArgs {
    /** Defines the selected date of the Calendar. */
    value?: Date;
    /** Defines the multiple selected date of the Calendar. */
    values?: Date[];
    /**
     * Specifies the original event arguments.
     */
    event?: KeyboardEvent | MouseEvent | Event;
    /** Defines the element. */
    element?: HTMLElement | HTMLInputElement;
    /**
     * If the event is triggered by interaction, it returns true. Otherwise, it returns false.
     */
    isInteracted?: boolean;
}
export interface IslamicObject {
    year: number;
    date: number;
    month: number;
}
/**
 * Defines the argument for the focus event.
 */
export interface FocusEventArgs {
    model?: Object;
}
/**
 * Defines the argument for the blur event.
 */
export interface BlurEventArgs {
    model?: Object;
}
//node_modules/@syncfusion/ej2-calendars/src/calendar/index.d.ts
/**
 * Calendar modules
 */
//node_modules/@syncfusion/ej2-calendars/src/calendar/islamic.d.ts
export  class Islamic {
    constructor(instance: Calendar);
    private calendarInstance;
    getModuleName(): string;
    islamicTitleUpdate(date: Date, view: string): void;
    islamicRenderDays(currentDate: Date, value?: Date, multiSelection?: boolean, values?: Date[]): HTMLElement[];
    islamicIconHandler(): void;
    islamicNext(): void;
    islamicPrevious(): void;
    islamicRenderYears(e?: Event, value?: Date): void;
    islamicRenderDecade(e?: Event, value?: Date): void;
    islamicDayCell(localDate: Date): HTMLElement;
    islamicRenderTemplate(elements: HTMLElement[], count: number, classNm: string, e?: Event, value?: Date): void;
    islamicCompareMonth(start: Date, end: Date): number;
    islamicCompare(startDate: Date, endDate: Date, modifier: number): number;
    getIslamicDate(date: Date): any;
    toGregorian(year: number, month: number, date: number): Date;
    hijriCompareYear(start: Date, end: Date): number;
    hijriCompareDecade(start: Date, end: Date): number;
    destroy(): void;
    protected islamicInValue(inValue: string | Date | number): string;
}
export interface IslamicDateArgs {
    year: number;
    date: number;
    month: number;
}
//node_modules/@syncfusion/ej2-calendars/src/datepicker/datepicker-model.d.ts
/**
 * Interface for a class DatePicker
 */
export interface DatePickerModel extends CalendarModel{
    /**
     * Specifies the width of the DatePicker component.
     * @default null
     */
    width?: number | string;
    /**
     * Specifies the root CSS class of the DatePicker that allows to
     * customize the appearance by overriding the styles.
     * @default null
     */
    cssClass?: string;
    /**
     * Specifies the component to act as strict. So that, it allows to enter only a valid date  value within a specified range or else it 
     * will resets to previous value. By default, strictMode is in false.
     * it allows invalid or out-of-range date value with highlighted error class.
     * @default false
     * > For more details refer to 
     * [`Strict Mode`](../../datepicker/strict-mode/) documentation.
     */
    strictMode?: boolean;
    /**
     * Specifies the format of the value that to be displayed in component. By default, the format is based on the culture.
     * @default null
     * @aspType string
     * @blazorType string
     */
    format?: string | FormatObject;
    /**
     * Specifies the component to be disabled or not.
     * @default true
     */
    enabled?: boolean;
    /**
     * You can add the additional html base.attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes?: { [key: string]: string;
 };
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     * @private
     */
    values?: Date[];
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     * @private
     */
    isMultiSelection?: boolean;
    /**
     * Specifies whether to show or hide the clear icon in textbox.
     * @default true
     */
    showClearButton?: boolean;
    /**
     * > Support for `allowEdit` has been provided from 
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#datepicker).
     * 
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the 
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit?: boolean;
    /**
     * Customizes the key actions in DatePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     * 
     * 
     * inputs.Input Navigation
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * escape<br/></td><td colSpan=1 rowSpan=1> 
     * escape<br/></td></tr> 
     * </table> 
     * 
     * Calendar Navigation
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlUp<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+38<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlDown<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+40<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveDown<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveUp<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveLeft<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveRight<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pagedown<br/></td></tr> 
     * <tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * select<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * home<br/></td><td colSpan=1 rowSpan=1> 
     * home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * end<br/></td><td colSpan=1 rowSpan=1> 
     * end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageUp<br/></td><td colSpan=1 rowSpan=1> 
     * pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageDown<br/></td><td colSpan=1 rowSpan=1> 
     * pagedown<br/></td></tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlHome<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlEnd<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * spacebar<br/></td><td colSpan=1 rowSpan=1> 
     * space<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+rightarrow<br/></td></tr>  
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+leftarrow<br/></td></tr> 
     * </table>
     * 
     * @default null
     * @blazorType object 
     */
    keyConfigs?: { [key: string]: string };
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * specifies the z-index value of the datePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex?: number;
    /**
     * Specifies the component in readonly state. When the Component is readonly it does not allow user input.
     * @default false
     */
    readonly?: boolean;
    /**
     * Specifies the placeholder text that displayed in textbox.
     * @default null
     */
    placeholder?: string;
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType?: inputs.FloatLabelType | string;
    /**
     * Triggers when the popup is opened.
     * @event
     * @blazorProperty 'OnOpen'
     * @blazorType PopupObjectArgs
     */
    open?: base.EmitType<PreventableEventArgs | PopupObjectArgs>;
    /**
     * Triggers when the popup is closed.
     * @event
     * @blazorProperty 'OnClose'
     * @blazorType PopupObjectArgs
     */
    close?: base.EmitType<PreventableEventArgs | PopupObjectArgs>;
    /**
     * Triggers when the input loses the focus.
     * @event
     */
    blur?: base.EmitType<BlurEventArgs>;
    /**
     *  Triggers when the input gets focus.
     * @event
     */
    focus?: base.EmitType<FocusEventArgs>;
    /**
     * Triggers when the component is created.
     * @event 
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Object>;
    /**
     * Triggers when the component is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed?: base.EmitType<Object>;
}
//node_modules/@syncfusion/ej2-calendars/src/datepicker/datepicker.d.ts

export interface FormatObject {
    /**
     * Specifies the format in which the date format will process
     */
    skeleton?: string;
}
/**
 * Represents the DatePicker component that allows user to select
 * or enter a date value.
 * ```html
 * <input id='datepicker'/>
 * ```
 * ```typescript
 * <script>
 *   let datePickerObject:DatePicker = new DatePicker({ value: new Date() });
 *   datePickerObject.appendTo('#datepicker');
 * </script>
 * ```
 */
export  class DatePicker extends Calendar implements inputs.IInput {
    protected popupObj: popups.Popup;
    protected inputWrapper: inputs.InputObject;
    private modal;
    protected inputElement: HTMLInputElement;
    protected popupWrapper: HTMLElement;
    protected changedArgs: ChangedEventArgs;
    protected previousDate: Date;
    private keyboardModules;
    private calendarKeyboardModules;
    protected previousElementValue: string;
    protected ngTag: string;
    protected dateTimeFormat: string;
    protected inputElementCopy: HTMLElement;
    protected inputValueCopy: Date;
    protected l10n: base.L10n;
    protected preventArgs: PopupObjectArgs;
    private isDateIconClicked;
    protected isAltKeyPressed: boolean;
    private isInteracted;
    private index;
    private formElement;
    protected invalidValueString: string;
    private checkPreviousValue;
    protected formatString: string;
    protected tabIndex: string;
    private datepickerOptions;
    protected defaultKeyConfigs: {
        [key: string]: string;
    };
    protected mobilePopupWrapper: HTMLElement;
    /**
     * Specifies the width of the DatePicker component.
     * @default null
     */
    width: number | string;
    /**
     * Specifies the root CSS class of the DatePicker that allows to
     * customize the appearance by overriding the styles.
     * @default null
     */
    cssClass: string;
    /**
     * Specifies the component to act as strict. So that, it allows to enter only a valid date  value within a specified range or else it
     * will resets to previous value. By default, strictMode is in false.
     * it allows invalid or out-of-range date value with highlighted error class.
     * @default false
     * > For more details refer to
     * [`Strict Mode`](../../datepicker/strict-mode/) documentation.
     */
    strictMode: boolean;
    /**
     * Specifies the format of the value that to be displayed in component. By default, the format is based on the culture.
     * @default null
     * @aspType string
     * @blazorType string
     */
    format: string | FormatObject;
    /**
     * Specifies the component to be disabled or not.
     * @default true
     */
    enabled: boolean;
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes: {
        [key: string]: string;
    };
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     * @private
     */
    values: Date[];
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     * @private
     */
    isMultiSelection: boolean;
    /**
     * Specifies whether to show or hide the clear icon in textbox.
     * @default true
     */
    showClearButton: boolean;
    /**
     * > Support for `allowEdit` has been provided from
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#datepicker).
     *
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit: boolean;
    /**
     * Customizes the key actions in DatePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     *
     *
     * Input Navigation
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * escape<br/></td><td colSpan=1 rowSpan=1>
     * escape<br/></td></tr>
     * </table>
     *
     * Calendar Navigation
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlUp<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+38<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlDown<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+40<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveDown<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveUp<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveLeft<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveRight<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1>
     * shift+pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1>
     * shift+pagedown<br/></td></tr>
     * <tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * select<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * home<br/></td><td colSpan=1 rowSpan=1>
     * home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * end<br/></td><td colSpan=1 rowSpan=1>
     * end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageUp<br/></td><td colSpan=1 rowSpan=1>
     * pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageDown<br/></td><td colSpan=1 rowSpan=1>
     * pagedown<br/></td></tr>
     * <td colSpan=1 rowSpan=1>
     * controlHome<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlEnd<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * spacebar<br/></td><td colSpan=1 rowSpan=1>
     * space<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+leftarrow<br/></td></tr>
     * </table>
     *
     * @default null
     * @blazorType object
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence: boolean;
    /**
     * specifies the z-index value of the datePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex: number;
    /**
     * Specifies the component in readonly state. When the Component is readonly it does not allow user input.
     * @default false
     */
    readonly: boolean;
    /**
     * Specifies the placeholder text that displayed in textbox.
     * @default null
     */
    placeholder: string;
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType: inputs.FloatLabelType | string;
    /**
     * Triggers when the popup is opened.
     * @event
     * @blazorProperty 'OnOpen'
     * @blazorType PopupObjectArgs
     */
    open: base.EmitType<PreventableEventArgs | PopupObjectArgs>;
    /**
     * Triggers when the popup is closed.
     * @event
     * @blazorProperty 'OnClose'
     * @blazorType PopupObjectArgs
     */
    close: base.EmitType<PreventableEventArgs | PopupObjectArgs>;
    /**
     * Triggers when the input loses the focus.
     * @event
     */
    blur: base.EmitType<BlurEventArgs>;
    /**
     *  Triggers when the input gets focus.
     * @event
     */
    focus: base.EmitType<FocusEventArgs>;
    /**
     * Triggers when the component is created.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Object>;
    /**
     * Triggers when the component is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed: base.EmitType<Object>;
    /**
     * Constructor for creating the widget.
     */
    constructor(options?: DatePickerModel, element?: string | HTMLInputElement);
    /**
     * To Initialize the control rendering.
     * @return void
     * @private
     */
    render(): void;
    protected setAllowEdit(): void;
    protected updateIconState(): void;
    private initialize;
    private createInput;
    protected updateInput(): void;
    protected minMaxUpdates(): void;
    private checkStringValue;
    protected checkInvalidValue(value: Date): void;
    private bindInputEvent;
    protected bindEvents(): void;
    protected resetFormHandler(): void;
    protected restoreValue(): void;
    private inputChangeHandler;
    private bindClearEvent;
    protected resetHandler(e?: MouseEvent): void;
    private clear;
    private dateIconHandler;
    protected updateHtmlAttributeToWrapper(): void;
    protected updateHtmlAttributeToElement(): void;
    private CalendarKeyActionHandle;
    private inputFocusHandler;
    private inputHandler;
    private inputBlurHandler;
    private documentHandler;
    protected inputKeyActionHandle(e: base.KeyboardEventArgs): void;
    protected defaultAction(e: base.KeyboardEventArgs): void;
    protected popupUpdate(): void;
    protected strictModeUpdate(): void;
    private createCalendar;
    private setAriaDisabled;
    private modelHeader;
    protected changeTrigger(event?: MouseEvent | KeyboardEvent): void;
    protected navigatedEvent(): void;
    protected changeEvent(event?: MouseEvent | KeyboardEvent | Event): void;
    requiredModules(): base.ModuleDeclaration[];
    protected selectCalendar(e?: MouseEvent | KeyboardEvent | Event): void;
    protected isCalendar(): boolean;
    protected setWidth(width: number | string): void;
    /**
     * Shows the Calendar.
     * @returns void
     */
    show(type?: null | string, e?: MouseEvent | KeyboardEvent | base.KeyboardEventArgs): void;
    /**
     * Hide the Calendar.
     * @returns void
     */
    hide(event?: MouseEvent | KeyboardEvent | Event): void;
    private closeEventCallback;
    /**
     * Sets the focus to widget for interaction.
     * @returns void
     */
    focusIn(triggerEvent?: boolean): void;
    /**
     * Remove the focus from widget, if the widget is in focus state.
     * @returns void
     */
    focusOut(): void;
    /**
     * Gets the current view of the DatePicker.
     * @returns string
     */
    currentView(): string;
    /**
     * Navigates to specified month or year or decade view of the DatePicker.
     * @param  {string} view - Specifies the view of the calendar.
     * @param  {Date} date - Specifies the focused date in a view.
     * @returns void
     */
    navigateTo(view: CalendarView, date: Date): void;
    /**
     * To destroy the widget.
     * @returns void
     */
    destroy(): void;
    protected ensureInputAttribute(): void;
    /**
     * Initialize the event handler
     * @private
     */
    protected preRender(): void;
    protected validationAttribute(target: HTMLElement, inputElement: Element): void;
    protected checkFormat(): void;
    private checkHtmlAttributes;
    /**
     * To get component name.
     * @private
     */
    protected getModuleName(): string;
    private disabledDates;
    private setAriaAttributes;
    protected errorClass(): void;
    /**
     * Called internally if any of the property value changed.
     * returns void
     * @private
     */
    onPropertyChanged(newProp: DatePickerModel, oldProp: DatePickerModel): void;
}
export interface PopupObjectArgs {
    /** Prevents the default action */
    preventDefault?: Function;
    /**
     * Defines the DatePicker popup element.
     * @deprecated
     */
    popup?: popups.Popup;
    /**
     * Illustrates whether the current action needs to be prevented or not.
     */
    cancel?: boolean;
    /**
     * Specifies the original event arguments.
     */
    event?: MouseEvent | KeyboardEvent | Event;
    /**
     * Specifies the node to which the popup element to be appended.
     */
    appendTo?: HTMLElement;
}
export interface PreventableEventArgs {
    /** Prevents the default action */
    preventDefault?: Function;
}
//node_modules/@syncfusion/ej2-calendars/src/datepicker/index.d.ts
/**
 * Datepicker modules
 */
//node_modules/@syncfusion/ej2-calendars/src/daterangepicker/daterangepicker-model.d.ts
/**
 * Interface for a class Presets
 */
export interface PresetsModel {
    /**
     * Defines the label string of the preset range. 
     */
    label?: string;
    /**
     * Defines the start date of the preset range.
     */
    start?: Date;
    /**
     * Defines the end date of the preset range 
     */
    end?: Date;
}
/**
 * Interface for a class DateRangePicker
 */
export interface DateRangePickerModel extends CalendarBaseModel{
    /**
     * Gets or sets the start and end date of the Calendar.
     * @default null
     */
    value?: Date[] | DateRange;
    /**
     * Enable or disable the persisting component's state between the page reloads. If enabled, following list of states will be persisted.
     * 1. startDate
     * 2. endDate
     * 3. value
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * Gets or sets the minimum date that can be selected in the calendar-popup.
     * @default new Date(1900, 00, 01)
     * @blazorDefaultValue new DateTime(1900, 01, 01)
     */
    min?: Date;
    /**
     * Gets or sets the maximum date that can be selected in the calendar-popup.
     * @default new Date(2099, 11, 31)
     * @blazorDefaultValue new DateTime(2099, 12, 31)
     */
    max?: Date;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @default 'en-US'
     */
    locale?: string;
    /**
     * Gets or sets the Calendar's first day of the week. By default, the first day of the week will be based on the current culture.
     * > For more details about firstDayOfWeek refer to 
     * [`First day of week`](../../daterangepicker/customization#first-day-of-week) documentation.
     * @default null
     */
    firstDayOfWeek?: number;
    /**
     * Determines whether the week number of the Calendar is to be displayed or not.
     * The week number is displayed in every week row.
     * > For more details about weekNumber refer to 
     * [`Calendar with week number`](../../calendar/how-to/week-number#render-the-calendar-with-week-numbers)documentation.
     * @default false
     */
    weekNumber?: boolean;
    /**
     * Gets or sets the Calendar's Type like gregorian or islamic.
     * @default Gregorian
     * @private
     */
    calendarMode?: CalendarType;
    /**
     * Triggers when Calendar is created.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Object>;
    /**
     * Triggers when Calendar is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed?: base.EmitType<Object>;
    /**
     * Triggers when the Calendar value is changed.
     * @event  
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<RangeEventArgs>;
    /**
     * Triggers when the Calendar is navigated to another view or within the same level of view.
     * @event
     * @blazorProperty 'Navigated'
     */
    navigated?: base.EmitType<NavigatedEventArgs>;
    /**
     * Triggers when each day cell of the Calendar is rendered.
     * @event
     * @blazorProperty 'OnRenderDayCell'
     */
    renderDayCell?: base.EmitType<RenderDayCellEventArgs>;
    /**
     * Gets or sets the start date of the date range selection.
     * @default null
     * @isBlazorNullableType true
     */
    startDate?: Date;
    /**
     * Gets or sets the end date of the date range selection.
     * @default null
     * @isBlazorNullableType true
     */
    endDate?: Date;
    /**
     * Set the predefined ranges which let the user pick required range easily in a component.
     * > For more details refer to 
     * [`Preset Ranges`](../../daterangepicker/customization#preset-ranges) documentation.
     * @default null
     */
    presets?: PresetsModel[];
    /**
     * Specifies the width of the DateRangePicker component.
     * @default ''
     */
    width?: number | string;
    /**
     * specifies the z-index value of the dateRangePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex?: number;
    /**
     * Specifies whether to show or hide the clear icon
     * @default true
     */
    showClearButton?: boolean;
    /**
     * Specifies whether the today button is to be displayed or not.
     * @default true
     * @hidden
     */
    showTodayButton?: boolean;
    /**
     * Specifies the initial view of the Calendar when it is opened.
     * With the help of this property, initial view can be changed to year or decade view.
     * @default Month
     */
    start?: CalendarView;
    /**
     * Sets the maximum level of view (month, year, decade) in the Calendar.
     * Depth view should be smaller than the start view to restrict its view navigation.
     * @default Month
     */
    depth?: CalendarView;
    /**
     *  Sets the root CSS class to the DateRangePicker which allows you to customize the appearance.
     * @default ''    
     */
    cssClass?: string;
    /**
     * Sets or gets the string that used between the start and end date string. 
     * @default '-'
     */
    separator?: string;
    /**
     *  Specifies the minimum span of days that can be allowed in date range selection.
     * > For more details refer to 
     * [`Range Span`](../../daterangepicker/range-restriction/#range-span) documentation.
     * @default null    
     * @aspType int
     * @blazorType int
     */
    minDays?: number;
    /**
     *  Specifies the maximum span of days that can be allowed in a date range selection.
     * > For more details refer to 
     * [`Range Span`](../../daterangepicker/range-restriction/#range-span) documentation.
     * @default null
     * @aspType int
     * @blazorType int
     * @isBlazorNullableType true
     */
    maxDays?: number;
    /**
     * Specifies the component to act as strict which allows entering only a valid date range in a DateRangePicker.
     * > For more details refer to 
     * [`Strict Mode`](../../daterangepicker/range-restriction#strict-mode)documentation.
     * @default false
     */
    strictMode?: boolean;
    /**
     * Customizes the key actions in DateRangePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     * 
     * 
     * inputs.Input Navigation
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * escape<br/></td><td colSpan=1 rowSpan=1> 
     * escape<br/></td></tr> 
     * </table> 
     * 
     * Calendar Navigation (Use the following list of keys to navigate the currently focused Calendar after the popup has opened). 
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlUp<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+38<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlDown<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+40<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveDown<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageUp<br/></td><td colSpan=1 rowSpan=1> 
     * pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageDown<br/></td><td colSpan=1 rowSpan=1> 
     * pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveUp<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveLeft<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveRight<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * base.select<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * home<br/></td><td colSpan=1 rowSpan=1> 
     * home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * end<br/></td><td colSpan=1 rowSpan=1> 
     * end<br/></td></tr> 
     * <tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlHome<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlEnd<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * spacebar<br/></td><td colSpan=1 rowSpan=1> 
     * space<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * enter<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+rightarrow<br/></td></tr>  
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+leftarrow<br/></td></tr> 
     * </table>
     * 
     * @default null
     * @blazorType object 
     */
    keyConfigs?: { [key: string]: string };
    /**
     * Sets or gets the required date format to the start and end date string.
     * > For more details refer to 
     * [`Format`](https://ej2.syncfusion.com/demos/#/material/daterangepicker/format.html)sample.
     * @aspType string
     * @default null
     * @blazorType string
     */
    format?: string | RangeFormatObject;
    /**
     * Specifies the component to be disabled which prevents the DateRangePicker from user interactions. 
     * @default true
     */
    enabled?: boolean;
    /**
     * Denies the editing the ranges in the DateRangePicker component. 
     * @default false
     */
    readonly?: boolean;
    /**
     * > Support for `allowEdit` has been provided from 
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#daterangepicker).
     * 
     * Specifies whether the input textbox is editable or not. Here the user can base.select the value from the 
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit?: boolean;
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType?: inputs.FloatLabelType | string;
    /**
     * Specifies the placeholder text that need to be displayed in the DateRangePicker component.
     * 
     * @default null
     */
    placeholder?: string;
    /**
     * You can add the additional html base.attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes?: { [key: string]: string;
 };
    /**
     * Triggers when the DateRangePicker is opened.
     * @event 
     * @blazorProperty 'OnOpen'
     * @blazorType RangePopupEventArgs
     */
    open?: base.EmitType<Object>;
    /**
     * Triggers when the DateRangePicker is closed.
     * @event
     * @blazorProperty 'OnClose'
     * @blazorType RangePopupEventArgs
     */
    close?: base.EmitType<Object>;
    /**
     * Triggers on selecting the start and end date.
     * @event 
     * @blazorProperty 'RangeSelected'
     * @blazorType RangeEventArgs
     */
    select?: base.EmitType<Object>;
    /**
     *  Triggers when the control gets focus.
     * @event
     */
    focus?: base.EmitType<FocusEventArgs>;
    /**
     * Triggers when the control loses the focus.
     * @event
     */
    blur?: base.EmitType<BlurEventArgs>;
}
//node_modules/@syncfusion/ej2-calendars/src/daterangepicker/daterangepicker.d.ts

export  class Presets extends base.ChildProperty<Presets> {
    /**
     * Defines the label string of the preset range.
     */
    label: string;
    /**
     * Defines the start date of the preset range.
     */
    start: Date;
    /**
     * Defines the end date of the preset range
     */
    end: Date;
}
export interface DateRange {
    /** Defines the start date */
    start?: Date;
    /** Defines the end date */
    end?: Date;
}
export interface RangeEventArgs extends base.BaseEventArgs {
    /**
     * Defines the value
     */
    value?: Date[] | DateRange;
    /** Defines the value string in the input element */
    text?: string;
    /** Defines the start date  */
    startDate?: Date;
    /** Defines the end date  */
    endDate?: Date;
    /** Defines the day span between the range */
    daySpan?: number;
    /** Specifies the element. */
    element?: HTMLElement | HTMLInputElement;
    /**
     * Specifies the original event arguments.
     */
    event?: MouseEvent | KeyboardEvent | TouchEvent | Event;
    /**
     * If the event is triggered by interaction, it returns true. Otherwise, it returns false.
     */
    isInteracted?: boolean;
}
export interface RangePopupEventArgs {
    /** Defines the range string in the input element */
    date: string;
    /** Defines the DateRangePicker model */
    model: DateRangePickerModel;
    /**
     * Illustrates whether the current action needs to be prevented or not.
     */
    cancel?: boolean;
    /**
     * Defines the DateRangePicker popup object.
     * @deprecated
     */
    popup?: popups.Popup;
    /**
     * Specifies the original event arguments.
     */
    event?: MouseEvent | KeyboardEvent | Event;
    /**
     * Specifies the node to which the popup element to be appended.
     */
    appendTo?: HTMLElement;
}
export interface RangeFormatObject {
    /**
     * Specifies the format in which the date format will process
     */
    skeleton?: string;
}
/**
 * Represents the DateRangePicker component that allows user to select the date range from the calendar
 * or entering the range through the input element.
 * ```html
 * <input id="daterangepicker"/>
 * ```
 * ```typescript
 * <script>
 *   var dateRangePickerObj = new DateRangePicker({ startDate: new Date("05/07/2017"), endDate: new Date("10/07/2017") });
 *   dateRangePickerObj.appendTo("#daterangepicker");
 * </script>
 * ```
 */
export  class DateRangePicker extends CalendarBase {
    private popupObj;
    private inputWrapper;
    private popupWrapper;
    private rightCalendar;
    private leftCalendar;
    private deviceCalendar;
    private leftCalCurrentDate;
    private initStartDate;
    private initEndDate;
    private startValue;
    private endValue;
    private modelValue;
    private rightCalCurrentDate;
    private leftCalPrevIcon;
    private leftCalNextIcon;
    private leftTitle;
    private rightTitle;
    private rightCalPrevIcon;
    private rightCalNextIcon;
    private inputKeyboardModule;
    protected leftKeyboardModule: base.KeyboardEvents;
    protected rightKeyboardModule: base.KeyboardEvents;
    private previousStartValue;
    private previousEndValue;
    private applyButton;
    private cancelButton;
    private startButton;
    private endButton;
    private cloneElement;
    private l10n;
    private isCustomRange;
    private isCustomWindow;
    private presetsItem;
    private liCollections;
    private activeIndex;
    private presetElement;
    private previousEleValue;
    private targetElement;
    private disabledDayCnt;
    private angularTag;
    private inputElement;
    private modal;
    private firstHiddenChild;
    private secondHiddenChild;
    private isKeyPopup;
    private dateDisabled;
    private navNextFunction;
    private navPrevFunction;
    private deviceNavNextFunction;
    private deviceNavPrevFunction;
    private isRangeIconClicked;
    private isMaxDaysClicked;
    private popupKeyboardModule;
    private presetKeyboardModule;
    private btnKeyboardModule;
    private virtualRenderCellArgs;
    private disabledDays;
    private isMobile;
    private keyInputConfigs;
    private defaultConstant;
    private preventBlur;
    private preventFocus;
    private valueType;
    private closeEventArgs;
    private openEventArgs;
    private controlDown;
    private startCopy;
    private endCopy;
    private formElement;
    private formatString;
    protected tabIndex: string;
    private invalidValueString;
    private dateRangeOptions;
    private mobileRangePopupWrap;
    /**
     * Gets or sets the start and end date of the Calendar.
     * @default null
     */
    value: Date[] | DateRange;
    /**
     * Enable or disable the persisting component's state between the page reloads. If enabled, following list of states will be persisted.
     * 1. startDate
     * 2. endDate
     * 3. value
     * @default false
     */
    enablePersistence: boolean;
    /**
     * Gets or sets the minimum date that can be selected in the calendar-popup.
     * @default new Date(1900, 00, 01)
     * @blazorDefaultValue new DateTime(1900, 01, 01)
     */
    min: Date;
    /**
     * Gets or sets the maximum date that can be selected in the calendar-popup.
     * @default new Date(2099, 11, 31)
     * @blazorDefaultValue new DateTime(2099, 12, 31)
     */
    max: Date;
    /**
     * Overrides the global culture and localization value for this component. Default global culture is 'en-US'.
     * @default 'en-US'
     */
    locale: string;
    /**
     * Gets or sets the Calendar's first day of the week. By default, the first day of the week will be based on the current culture.
     * > For more details about firstDayOfWeek refer to
     * [`First day of week`](../../daterangepicker/customization#first-day-of-week) documentation.
     * @default null
     */
    firstDayOfWeek: number;
    /**
     * Determines whether the week number of the Calendar is to be displayed or not.
     * The week number is displayed in every week row.
     * > For more details about weekNumber refer to
     * [`Calendar with week number`](../../calendar/how-to/week-number#render-the-calendar-with-week-numbers)documentation.
     * @default false
     */
    weekNumber: boolean;
    /**
     * Gets or sets the Calendar's Type like gregorian or islamic.
     * @default Gregorian
     * @private
     */
    calendarMode: CalendarType;
    /**
     * Triggers when Calendar is created.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Object>;
    /**
     * Triggers when Calendar is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed: base.EmitType<Object>;
    /**
     * Triggers when the Calendar value is changed.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<RangeEventArgs>;
    /**
     * Triggers when the Calendar is navigated to another view or within the same level of view.
     * @event
     * @blazorProperty 'Navigated'
     */
    navigated: base.EmitType<NavigatedEventArgs>;
    /**
     * Triggers when each day cell of the Calendar is rendered.
     * @event
     * @blazorProperty 'OnRenderDayCell'
     */
    renderDayCell: base.EmitType<RenderDayCellEventArgs>;
    /**
     * Gets or sets the start date of the date range selection.
     * @default null
     * @isBlazorNullableType true
     */
    startDate: Date;
    /**
     * Gets or sets the end date of the date range selection.
     * @default null
     * @isBlazorNullableType true
     */
    endDate: Date;
    /**
     * Set the$ predefined ranges which let the user pick required range easily in a component.
     * > For more details refer to
     * [`Preset Ranges`](../../daterangepicker/customization#preset-ranges) documentation.
     * @default null
     */
    presets: PresetsModel[];
    /**
     * Specifies the width of the DateRangePicker component.
     * @default ''
     */
    width: number | string;
    /**
     * specifies the z-index value of the dateRangePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex: number;
    /**
     * Specifies whether to show or hide the clear icon
     * @default true
     */
    showClearButton: boolean;
    /**
     * Specifies whether the today button is to be displayed or not.
     * @default true
     * @hidden
     */
    showTodayButton: boolean;
    /**
     * Specifies the initial view of the Calendar when it is opened.
     * With the help of this property, initial view can be changed to year or decade view.
     * @default Month
     */
    start: CalendarView;
    /**
     * Sets the maximum level of view (month, year, decade) in the Calendar.
     * Depth view should be smaller than the start view to restrict its view navigation.
     * @default Month
     */
    depth: CalendarView;
    /**
     *  Sets the root CSS class to the DateRangePicker which allows you to customize the appearance.
     * @default ''
     */
    cssClass: string;
    /**
     * Sets or gets the string that used between the start and end date string.
     * @default '-'
     */
    separator: string;
    /**
     *  Specifies the minimum span of days that can be allowed in date range selection.
     * > For more details refer to
     * [`Range Span`](../../daterangepicker/range-restriction/#range-span) documentation.
     * @default null
     * @aspType int
     * @blazorType int
     */
    minDays: number;
    /**
     *  Specifies the maximum span of days that can be allowed in a date range selection.
     * > For more details refer to
     * [`Range Span`](../../daterangepicker/range-restriction/#range-span) documentation.
     * @default null
     * @aspType int
     * @blazorType int
     * @isBlazorNullableType true
     */
    maxDays: number;
    /**
     * Specifies the component to act as strict which allows entering only a valid date range in a DateRangePicker.
     * > For more details refer to
     * [`Strict Mode`](../../daterangepicker/range-restriction#strict-mode)documentation.
     * @default false
     */
    strictMode: boolean;
    /**
     * Customizes the key actions in DateRangePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     *
     *
     * Input Navigation
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * escape<br/></td><td colSpan=1 rowSpan=1>
     * escape<br/></td></tr>
     * </table>
     *
     * Calendar Navigation (Use the following list of keys to navigate the currently focused Calendar after the popup has opened).
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlUp<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+38<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlDown<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+40<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveDown<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <td colSpan=1 rowSpan=1>
     * pageUp<br/></td><td colSpan=1 rowSpan=1>
     * pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageDown<br/></td><td colSpan=1 rowSpan=1>
     * pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1>
     * shift+pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1>
     * shift+pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveUp<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveLeft<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveRight<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * select<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * home<br/></td><td colSpan=1 rowSpan=1>
     * home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * end<br/></td><td colSpan=1 rowSpan=1>
     * end<br/></td></tr>
     * <tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlHome<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlEnd<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * spacebar<br/></td><td colSpan=1 rowSpan=1>
     * space<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * enter<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+leftarrow<br/></td></tr>
     * </table>
     *
     * @default null
     * @blazorType object
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * Sets or gets the required date format to the start and end date string.
     * > For more details refer to
     * [`Format`](https://ej2.syncfusion.com/demos/#/material/daterangepicker/format.html)sample.
     * @aspType string
     * @default null
     * @blazorType string
     */
    format: string | RangeFormatObject;
    /**
     * Specifies the component to be disabled which prevents the DateRangePicker from user interactions.
     * @default true
     */
    enabled: boolean;
    /**
     * Denies the editing the ranges in the DateRangePicker component.
     * @default false
     */
    readonly: boolean;
    /**
     * > Support for `allowEdit` has been provided from
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#daterangepicker).
     *
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit: boolean;
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType: inputs.FloatLabelType | string;
    /**
     * Specifies the placeholder text that need to be displayed in the DateRangePicker component.
     *
     * @default null
     */
    placeholder: string;
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes: {
        [key: string]: string;
    };
    /**
     * Triggers when the DateRangePicker is opened.
     * @event
     * @blazorProperty 'OnOpen'
     * @blazorType RangePopupEventArgs
     */
    open: base.EmitType<Object>;
    /**
     * Triggers when the DateRangePicker is closed.
     * @event
     * @blazorProperty 'OnClose'
     * @blazorType RangePopupEventArgs
     */
    close: base.EmitType<Object>;
    /**
     * Triggers on selecting the start and end date.
     * @event
     * @blazorProperty 'RangeSelected'
     * @blazorType RangeEventArgs
     */
    select: base.EmitType<Object>;
    /**
     *  Triggers when the control gets focus.
     * @event
     */
    focus: base.EmitType<FocusEventArgs>;
    /**
     * Triggers when the control loses the focus.
     * @event
     */
    blur: base.EmitType<BlurEventArgs>;
    /**
     * Constructor for creating the widget
     */
    constructor(options?: DateRangePickerModel, element?: string | HTMLInputElement);
    /**
     * To Initialize the control rendering.
     * @return void
     * @private
     */
    protected render(): void;
    /**
     * Initialize the event handler
     * @returns void
     * @private
     */
    protected preRender(): void;
    private updateValue;
    private initProperty;
    protected checkFormat(): void;
    private initialize;
    private setRangeAllowEdit;
    private updateClearIconState;
    protected validationAttribute(element: HTMLElement, input: Element): void;
    private updateHtmlAttributeToWrapper;
    private updateHtmlAttributeToElement;
    private processPresets;
    protected bindEvents(): void;
    private updateHiddenInput;
    private inputChangeHandler;
    private bindClearEvent;
    protected resetHandler(e: MouseEvent): void;
    private restoreValue;
    protected formResetHandler(e: MouseEvent): void;
    private clear;
    private rangeIconHandler;
    private checkHtmlAttributes;
    private createPopup;
    private renderControl;
    private clearCalendarEvents;
    private updateNavIcons;
    private calendarIconEvent;
    private bindCalendarEvents;
    private calendarIconRipple;
    private deviceCalendarEvent;
    private deviceNavNext;
    private deviceNavPrevious;
    private updateDeviceCalendar;
    private deviceHeaderClick;
    private inputFocusHandler;
    private inputBlurHandler;
    private clearRange;
    private errorClass;
    private keyCalendarUpdate;
    private navInCalendar;
    private keyInputHandler;
    private keyNavigation;
    private inputHandler;
    private bindCalendarCellEvents;
    private removeFocusedDate;
    private hoverSelection;
    private isSameStartEnd;
    private updateRange;
    private checkMinMaxDays;
    private rangeArgs;
    private otherMonthSelect;
    private selectRange;
    private selectableDates;
    private updateMinMaxDays;
    private removeClassDisabled;
    private updateHeader;
    private removeSelection;
    private addSelectedAttributes;
    private removeSelectedAttributes;
    private updateCalendarElement;
    private navPrevMonth;
    private deviceNavigation;
    private updateControl;
    private navNextMonth;
    private compareMonths;
    private compareYears;
    private compareDecades;
    private isPopupOpen;
    protected createRangeHeader(): HTMLElement;
    private disableInput;
    private validateMinMax;
    private validateRangeStrict;
    private validateRange;
    private validateMinMaxDays;
    private renderCalendar;
    private isSameMonth;
    private isSameYear;
    private isSameDecade;
    private startMonthCurrentDate;
    private selectNextMonth;
    private selectNextYear;
    private selectNextDecade;
    private selectStartMonth;
    private createCalendar;
    private leftNavTitle;
    private calendarNavigation;
    private rightNavTitle;
    protected clickEventEmitter(e: MouseEvent): void;
    /**
     * Gets the current view of the Calendar.
     * @returns string
     * @private
     * @hidden
     */
    currentView(): string;
    protected getCalendarView(view: string): CalendarView;
    protected navigatedEvent(e: MouseEvent): void;
    private createControl;
    private cancelFunction;
    private deviceHeaderUpdate;
    private applyFunction;
    private onMouseClick;
    private onMouseOver;
    private onMouseLeave;
    private setListSelection;
    private removeListSelection;
    private setValue;
    private applyPresetRange;
    private showPopup;
    private renderCustomPopup;
    private listRippleEffect;
    private createPresets;
    private wireListEvents;
    private unWireListEvents;
    private renderPopup;
    protected popupCloseHandler(e: base.KeyboardEventArgs): void;
    private calendarFocus;
    private presetHeight;
    private presetKeyActionHandler;
    private listMoveDown;
    private listMoveUp;
    private getHoverLI;
    private getActiveLI;
    private popupKeyBoardHandler;
    private setScrollPosition;
    private popupKeyActionHandle;
    private documentHandler;
    private createInput;
    private setEleWidth;
    private adjustLongHeaderWidth;
    private refreshControl;
    private updateInput;
    protected checkInvalidRange(value: String | DateRange | Date[]): void;
    private getstringvalue;
    private checkInvalidValue;
    private isDateDisabled;
    private disabledDateRender;
    private virtualRenderCellEvent;
    private disabledDates;
    private setModelValue;
    /**
     * To dispatch the event manually
     */
    protected dispatchEvent(element: HTMLElement, type: string): void;
    private changeTrigger;
    /**
     * This method is used to navigate to the month/year/decade view of the Calendar.
     * @param  {string} view - Specifies the view of the Calendar.
     * @param  {Date} date - Specifies the focused date in a view.
     * @returns void
     * @hidden
     */
    navigateTo(view: CalendarView, date: Date): void;
    private navigate;
    /**
     * Sets the focus to widget for interaction.
     * @returns void
     */
    focusIn(): void;
    /**
     * Remove the focus from widget, if the widget is in focus state.
     * @returns void
     */
    focusOut(): void;
    /**
     * To destroy the widget.
     * @returns void
     */
    destroy(): void;
    protected ensureInputAttribute(): void;
    /**
     * To get component name
     * @returns string
     * @private
     */
    protected getModuleName(): string;
    /**
     * Return the properties that are maintained upon browser refresh.
     * @returns string
     */
    getPersistData(): string;
    /**
     * Return the selected range and day span in the DateRangePicker.
     * @returns Object
     */
    getSelectedRange(): Object;
    /**
     * To open the popups.Popup container in the DateRangePicker component.
     * @returns void
     */
    show(element?: HTMLElement, event?: MouseEvent | base.KeyboardEventArgs | Event): void;
    /**
     * To close the popups.Popup container in the DateRangePicker component.
     * @returns void
     */
    hide(event?: base.KeyboardEventArgs | MouseEvent | Event): void;
    private setLocale;
    private refreshChange;
    private setDate;
    private enableInput;
    private clearModelvalue;
    private createHiddenInput;
    /**
     * Called internally if any of the property value changed.
     * returns void
     * @private
     */
    onPropertyChanged(newProp: DateRangePickerModel, oldProp: DateRangePickerModel): void;
}
//node_modules/@syncfusion/ej2-calendars/src/daterangepicker/index.d.ts
/**
 * DateRangePicker modules
 */
//node_modules/@syncfusion/ej2-calendars/src/datetimepicker/datetimepicker-model.d.ts
/**
 * Interface for a class DateTimePicker
 */
export interface DateTimePickerModel extends DatePickerModel{
    /**
     * Specifies the format of the time value that to be displayed in time popup list.
     * @default null
     */
    timeFormat?: string;
    /**
     * Specifies the time interval between the two adjacent time values in the time popup list . 
     * @default 30
     * @blazorType int
     */
    step?: number;
    /**
     * Specifies the scroll bar position if there is no value is selected in the timepicker popup list or
     * the given value is not present in the timepicker popup list.
     * @default null
     * @isBlazorNullableType true
     */
    scrollTo?: Date;
    /**
     * specifies the z-index value of the popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex?: number;
    /**
     * Customizes the key actions in DateTimePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     * 
     * 
     * inputs.Input Navigation
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * escape<br/></td><td colSpan=1 rowSpan=1> 
     * escape<br/></td></tr> 
     * </table> 
     * 
     * Calendar Navigation (Use the following list of keys to navigate the currently focused Calendar after the popup has opened). 
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlUp<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+38<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlDown<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+40<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveDown<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveUp<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveLeft<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * moveRight<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * select<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * home<br/></td><td colSpan=1 rowSpan=1> 
     * home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * end<br/></td><td colSpan=1 rowSpan=1> 
     * end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageUp<br/></td><td colSpan=1 rowSpan=1> 
     * pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * pageDown<br/></td><td colSpan=1 rowSpan=1> 
     * pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pageup<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1> 
     * shift+pagedown<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlHome<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * controlEnd<br/></td><td colSpan=1 rowSpan=1> 
     * ctrl+end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * spacebar<br/></td><td colSpan=1 rowSpan=1> 
     * space<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+rightarrow<br/></td></tr>  
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1> 
     * alt+leftarrow<br/></td></tr> 
     * </table> 
     * 
     * TimePicker Navigation (Use the below list of shortcut keys to interact with the TimePicker after the TimePicker popups.Popup has opened).
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * down<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * up<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * left<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * right<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * </table>
     * 
     * @default null
     * @blazorType object 
     */
    keyConfigs?: { [key: string]: string };
    /**
     * You can add the additional html base.attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes?: { [key: string]: string;
 };
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * > Support for `allowEdit` has been provided from 
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#datetimepicker).
     * 
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the 
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit?: boolean;
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     * @private
     */
    isMultiSelection?: boolean;
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     * @private
     */
    values?: Date[];
    /**
     * Specifies whether to show or hide the clear icon in textbox.
     * @default true
     */
    showClearButton?: boolean;
    /**
     * Specifies the placeholder text that to be is displayed in textbox.
     * @default null
     */
    placeholder?: string;
    /**
     * Specifies the component to act as strict. So that, it allows to enter only a valid
     * date and time value within a specified range or else it 
     * will resets to previous value. By default, strictMode is in false.
     * it allows invalid or out-of-range value with highlighted error class.
     * @default false
     * > For more details refer to 
     * [`Strict Mode`](../../datetimepicker/strict-mode/) documentation.
     */
    strictMode?: boolean;
    /**
     * Triggers when popup is opened.
     * @event 
     * @blazorProperty 'OnOpen'
     * @blazorType PopupObjectArgs
     */
    open?: base.EmitType<Object>;
    /**
     * Triggers when popup is closed.
     * @event 
     * @blazorProperty 'OnClose'
     * @blazorType PopupObjectArgs
     */
    close?: base.EmitType<Object>;
    /**
     * Triggers when input loses the focus.
     * @event
     */
    blur?: base.EmitType<Object>;
    /**
     * Triggers when input gets focus.
     * @event
     */
    focus?: base.EmitType<Object>;
    /**
     * Triggers when DateTimePicker is created.
     * @event 
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Object>;
    /**
     * Triggers when DateTimePicker is destroyed.
     * @event 
     * @blazorProperty 'Destroyed'
     */
    destroyed?: base.EmitType<Object>;
}
//node_modules/@syncfusion/ej2-calendars/src/datetimepicker/datetimepicker.d.ts

/**
 * Represents the DateTimePicker component that allows user to select
 * or enter a date time value.
 * ```html
 * <input id="dateTimePicker"/>
 * ```
 * ```typescript
 * <script>
 *   let dateTimePickerObject:DateTimePicker = new DateTimePicker({ value: new Date() });
 *   dateTimePickerObject.appendTo("#dateTimePicker");
 * </script>
 * ```
 */
export  class DateTimePicker extends DatePicker {
    private timeIcon;
    private cloneElement;
    private dateTimeWrapper;
    private rippleFn;
    private listWrapper;
    private liCollections;
    private timeCollections;
    private listTag;
    private selectedElement;
    private containerStyle;
    private popupObject;
    protected timeModal: HTMLElement;
    private isNavigate;
    protected isPreventBlur: Boolean;
    private timeValue;
    protected l10n: base.L10n;
    private keyboardHandler;
    protected inputEvent: base.KeyboardEvents;
    private activeIndex;
    private valueWithMinutes;
    private previousDateTime;
    private initValue;
    protected tabIndex: string;
    private isValidState;
    protected timekeyConfigure: {
        [key: string]: string;
    };
    protected preventArgs: PopupObjectArgs;
    private dateTimeOptions;
    /**
     * Specifies the format of the time value that to be displayed in time popup list.
     * @default null
     */
    timeFormat: string;
    /**
     * Specifies the time interval between the two adjacent time values in the time popup list .
     * @default 30
     * @blazorType int
     */
    step: number;
    /**
     * Specifies the scroll bar position if there is no value is selected in the timepicker popup list or
     * the given value is not present in the timepicker popup list.
     * @default null
     * @isBlazorNullableType true
     */
    scrollTo: Date;
    /**
     * specifies the z-index value of the popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex: number;
    /**
     * Customizes the key actions in DateTimePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     *
     *
     * Input Navigation
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altDownArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * escape<br/></td><td colSpan=1 rowSpan=1>
     * escape<br/></td></tr>
     * </table>
     *
     * Calendar Navigation (Use the following list of keys to navigate the currently focused Calendar after the popup has opened).
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlUp<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+38<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlDown<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+40<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveDown<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveUp<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveLeft<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * moveRight<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * select<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * home<br/></td><td colSpan=1 rowSpan=1>
     * home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * end<br/></td><td colSpan=1 rowSpan=1>
     * end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageUp<br/></td><td colSpan=1 rowSpan=1>
     * pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * pageDown<br/></td><td colSpan=1 rowSpan=1>
     * pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageUp<br/></td><td colSpan=1 rowSpan=1>
     * shift+pageup<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * shiftPageDown<br/></td><td colSpan=1 rowSpan=1>
     * shift+pagedown<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlHome<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * controlEnd<br/></td><td colSpan=1 rowSpan=1>
     * ctrl+end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altUpArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * spacebar<br/></td><td colSpan=1 rowSpan=1>
     * space<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altRightArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * altLeftArrow<br/></td><td colSpan=1 rowSpan=1>
     * alt+leftarrow<br/></td></tr>
     * </table>
     *
     * TimePicker Navigation (Use the below list of shortcut keys to interact with the TimePicker after the TimePicker Popup has opened).
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * down<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * up<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * left<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * right<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * </table>
     *
     * @default null
     * @blazorType object
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes: {
        [key: string]: string;
    };
    /**
     * Enable or disable persisting component's state between page reloads. If enabled, following list of states will be persisted.
     * 1. value
     * @default false
     */
    enablePersistence: boolean;
    /**
     * > Support for `allowEdit` has been provided from
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#datetimepicker).
     *
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit: boolean;
    /**
     * Specifies the option to enable the multiple dates selection of the calendar.
     * @default false
     * @private
     */
    isMultiSelection: boolean;
    /**
     * Gets or sets multiple selected dates of the calendar.
     * @default null
     * @private
     */
    values: Date[];
    /**
     * Specifies whether to show or hide the clear icon in textbox.
     * @default true
     */
    showClearButton: boolean;
    /**
     * Specifies the placeholder text that to be is displayed in textbox.
     * @default null
     */
    placeholder: string;
    /**
     * Specifies the component to act as strict. So that, it allows to enter only a valid
     * date and time value within a specified range or else it
     * will resets to previous value. By default, strictMode is in false.
     * it allows invalid or out-of-range value with highlighted error class.
     * @default false
     * > For more details refer to
     * [`Strict Mode`](../../datetimepicker/strict-mode/) documentation.
     */
    strictMode: boolean;
    /**
     * Triggers when popup is opened.
     * @event
     * @blazorProperty 'OnOpen'
     * @blazorType PopupObjectArgs
     */
    open: base.EmitType<Object>;
    /**
     * Triggers when popup is closed.
     * @event
     * @blazorProperty 'OnClose'
     * @blazorType PopupObjectArgs
     */
    close: base.EmitType<Object>;
    /**
     * Triggers when input loses the focus.
     * @event
     */
    blur: base.EmitType<Object>;
    /**
     * Triggers when input gets focus.
     * @event
     */
    focus: base.EmitType<Object>;
    /**
     * Triggers when DateTimePicker is created.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Object>;
    /**
     * Triggers when DateTimePicker is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed: base.EmitType<Object>;
    /**
     * Constructor for creating the widget
     */
    constructor(options?: DateTimePickerModel, element?: string | HTMLInputElement);
    private focusHandler;
    /**
     * Sets the focus to widget for interaction.
     * @returns void
     */
    focusIn(): void;
    /**
     * Remove the focus from widget, if the widget is in focus state.
     * @returns void
     */
    focusOut(): void;
    protected blurHandler(e: MouseEvent): void;
    /**
     * To destroy the widget.
     * @returns void
     */
    destroy(): void;
    /**
     * To Initialize the control rendering.
     * @return void
     * @private
     */
    render(): void;
    private setValue;
    private validateMinMaxRange;
    private checkValidState;
    private checkErrorState;
    private validateValue;
    private disablePopupButton;
    private getFormattedValue;
    private isDateObject;
    private createInputElement;
    private renderTimeIcon;
    private bindInputEvents;
    private unBindInputEvents;
    private cldrTimeFormat;
    private cldrDateTimeFormat;
    private getCldrFormat;
    private isNullOrEmpty;
    protected getCultureTimeObject(ld: Object, c: string): Object;
    private timeHandler;
    private dateHandler;
    show(type?: string, e?: MouseEvent | KeyboardEvent | base.KeyboardEventArgs): void;
    toggle(e?: base.KeyboardEventArgs): void;
    private listCreation;
    private popupCreation;
    private openPopup;
    private documentClickHandler;
    private isTimePopupOpen;
    private isDatePopupOpen;
    private renderPopup;
    private setDimension;
    private setPopupWidth;
    protected wireTimeListEvents(): void;
    protected unWireTimeListEvents(): void;
    private onMouseOver;
    private onMouseLeave;
    private setTimeHover;
    protected getPopupHeight(): number;
    protected changeEvent(e: Event): void;
    private updateValue;
    private setTimeScrollPosition;
    private findScrollTop;
    private setScrollTo;
    private setInputValue;
    private getFullDateTime;
    private combineDateTime;
    private onMouseClick;
    private setSelection;
    private setTimeActiveClass;
    private setTimeActiveDescendant;
    protected addTimeSelection(): void;
    protected removeTimeSelection(): void;
    protected removeTimeHover(className: string): void;
    protected getTimeHoverItem(className: string): Element[];
    protected isValidLI(li: Element | HTMLElement): boolean;
    private calculateStartEnd;
    private startTime;
    private endTime;
    hide(e?: KeyboardEvent | MouseEvent | Event): void;
    private dateTimeCloseEventCallback;
    private closePopup;
    protected preRender(): void;
    protected getProperty(date: DateTimePickerModel, val: string): void;
    protected checkAttributes(isDynamic: boolean): void;
    requiredModules(): base.ModuleDeclaration[];
    private getTimeActiveElement;
    protected createDateObj(val: Date | string): Date;
    private getDateObject;
    protected findNextTimeElement(event: base.KeyboardEventArgs): void;
    protected setTimeValue(date: Date, value: Date): Date;
    protected timeElementValue(value: Date): Date;
    protected timeKeyHandler(event: base.KeyboardEventArgs): void;
    protected TimeKeyActionHandle(event: base.KeyboardEventArgs): void;
    protected inputKeyAction(event: base.KeyboardEventArgs): void;
    onPropertyChanged(newProp: DateTimePickerModel, oldProp: DateTimePickerModel): void;
    /**
     * To get component name.
     * @private
     */
    protected getModuleName(): string;
    protected restoreValue(): void;
}
//node_modules/@syncfusion/ej2-calendars/src/datetimepicker/index.d.ts
/**
 * DateTimePicker modules
 */
//node_modules/@syncfusion/ej2-calendars/src/index.d.ts
/**
 * Calendar all modules
 */
//node_modules/@syncfusion/ej2-calendars/src/timepicker/index.d.ts
/**
 * TimePicker modules
 */
//node_modules/@syncfusion/ej2-calendars/src/timepicker/timepicker-model.d.ts
/**
 * Interface for a class TimePicker
 */
export interface TimePickerModel extends base.ComponentModel{
    /**
     * Gets or sets the width of the TimePicker component. The width of the popup is based on the width of the component.
     * @default null
     */
    width?: string | number;
    /**
     * Specifies the root CSS class of the TimePicker that allows to
     * customize the appearance by overriding the styles.
     * @default null
     */
    cssClass?: string;
    /**
     * Specifies the component to act as strict so that, it allows to enter only a valid time value within a specified range or else 
     * resets to previous value. By default, strictMode is in false.
     * > For more details refer to 
     * [`Strict Mode`](../../timepicker/strict-mode/) documentation.
     * @default false
     */
    strictMode?: boolean;
    /**
     * Customizes the key actions in TimePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     * 
     * <table> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * Key action<br/></td><td colSpan=1 rowSpan=1> 
     * Key<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * enter<br/></td><td colSpan=1 rowSpan=1> 
     * enter<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * escape<br/></td><td colSpan=1 rowSpan=1> 
     * escape<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * end<br/></td><td colSpan=1 rowSpan=1> 
     * end<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * tab<br/></td><td colSpan=1 rowSpan=1> 
     * tab<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * home<br/></td><td colSpan=1 rowSpan=1> 
     * home<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * down<br/></td><td colSpan=1 rowSpan=1> 
     * downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * up<br/></td><td colSpan=1 rowSpan=1> 
     * uparrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * left<br/></td><td colSpan=1 rowSpan=1> 
     * leftarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * right<br/></td><td colSpan=1 rowSpan=1> 
     * rightarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * open<br/></td><td colSpan=1 rowSpan=1> 
     * alt+downarrow<br/></td></tr> 
     * <tr> 
     * <td colSpan=1 rowSpan=1> 
     * close<br/></td><td colSpan=1 rowSpan=1> 
     * alt+uparrow<br/></td></tr> 
     * </table>
     * 
     * @default null
     * @blazorType object 
     */
    keyConfigs?: { [key: string]: string };
    /**
     * Specifies the format of value that is to be displayed in component. By default, the format is
     * based on the culture. 
     * > For more details refer to 
     * [`Format`](../../timepicker/getting-started#setting-the-time-format) documentation.
     * @default null
     * @aspType string
     * @blazorType string
     */
    format?: string | TimeFormatObject;
    /**
     * Specifies whether the component to be disabled or not.
     * @default true
     */
    enabled?: boolean;
    /**
     * Specifies the component in readonly state. 
     * @default false
     */
    readonly?: boolean;
    /**
     * You can add the additional html base.attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes?: { [key: string]: string;
 };
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType?: inputs.FloatLabelType | string;
    /**
     * Specifies the placeholder text that is displayed in textbox.
     * @default null
     */
    placeholder?: string;
    /**
     * specifies the z-index value of the timePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex?: number;
    /**
     * Enable or disable the persisting component's state between the page reloads. If enabled, following list of states will be persisted.
     * 1. Value
     * @default false
     */
    enablePersistence?: boolean;
    /**
     * Specifies whether to show or hide the clear icon.
     * @default true
     */
    showClearButton?: boolean;
    /**
     * Specifies the time interval between the two adjacent time values in the popup list. 
     * > For more details refer to 
     * [`Format`](../../timepicker/getting-started#setting-the-time-format)documentation.
     * @default 30
     * @blazorType int
     * 
     */
    step?: number;
    /**
     * Specifies the scroll bar position if there is no value is selected in the popup list or
     *  the given value is not present in the popup list.
     * > For more details refer to 
     * [`Time Duration`](https://ej2.syncfusion.com/demos/#/material/timepicker/list-formatting.html) sample. 
     * @default null
     * @isBlazorNullableType true
     */
    scrollTo?: Date;
    /**
     * Gets or sets the value of the component. The value is parsed based on the culture specific time format.
     * @default null
     * @isBlazorNullableType true
     */
    value?: Date;
    /**
     * Gets or sets the minimum time value that can be allowed to select in TimePicker.
     * > For more details refer to 
     * [`Time Range`](../../timepicker/time-range/) documentation.
     * @default 00:00
     * @blazorDefaultValue new DateTime(1900, 01, 01, 00, 00, 00)
     */
    min?: Date;
    /**
     * Gets or sets the maximum time value that can be allowed to select in TimePicker.
     * > For more details refer to 
     * [`Time Range`](../../timepicker/time-range/) documentation.
     * @default 00:00
     * @blazorDefaultValue new DateTime(2099, 12, 31, 23, 59, 59)
     */
    max?: Date;
    /**
     * > Support for `allowEdit` has been provided from 
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#timepicker).
     * 
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the 
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit?: boolean;
    /**
     * Triggers when the value is changed.
     * @event  
     * @blazorProperty 'ValueChange'
     */
    change?: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers when the component is created.
     * @event
     * @blazorProperty 'Created'
     */
    created?: base.EmitType<Object>;
    /**
     * Triggers when the component is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed?: base.EmitType<Object>;
    /**
     * Triggers when the popup is opened.
     * @event
     * @blazorProperty 'OnOpen'
     */
    open?: base.EmitType<PopupEventArgs>;
    /**
     * Triggers while rendering the each popup list item.
     * @event
     * @blazorProperty 'OnItemRender'
     */
    itemRender?: base.EmitType<ItemEventArgs>;
    /**
     * Triggers when the popup is closed.
     * @event
     * @blazorProperty 'OnClose'
     */
    close?: base.EmitType<PopupEventArgs>;
    /**
     * Triggers when the control loses the focus.
     * @event
     */
    blur?: base.EmitType<BlurEventArgs>;
    /**
     * Triggers when the control gets focused.
     * @event
     */
    focus?: base.EmitType<FocusEventArgs>;
}
//node_modules/@syncfusion/ej2-calendars/src/timepicker/timepicker.d.ts
export interface ChangeEventArgs {
    /** Defines the boolean that returns true when the value is changed by user interaction, otherwise returns false. */
    isInteracted?: boolean;
    /** Defines the selected time value of the TimePicker. */
    value?: Date;
    /** Defines the selected time value as string. */
    text?: string;
    /** Defines the original event arguments. */
    event?: base.KeyboardEventArgs | FocusEvent | MouseEvent | Event;
    /** Defines the element */
    element: HTMLInputElement | HTMLElement;
}
/**
 * Interface for before list item render .
 */
export interface ItemEventArgs extends base.BaseEventArgs {
    /** Defines the created LI element. */
    element: HTMLElement;
    /** Defines the displayed text value in a popup list. */
    text: string;
    /** Defines the Date object of displayed text in a popup list. */
    value: Date;
    /** Specifies whether to disable the current time value or not. */
    isDisabled: Boolean;
}
export interface CursorPositionDetails {
    /** Defines the text selection starting position. */
    start: number;
    /** Defines the text selection end position. */
    end: number;
}
export interface MeridianText {
    /** Defines the culture specific meridian text for AM. */
    am: string;
    /** Defines the culture specific meridian text for PM. */
    pm: string;
}
export interface TimeFormatObject {
    /**
     * Specifies the format in which the date format will process
     */
    skeleton?: string;
}
export interface PopupEventArgs {
    /** Specifies the name of the event  */
    name?: string;
    /**
     * Illustrates whether the current action needs to be prevented or not.
     */
    cancel?: boolean;
    /**
     * Defines the TimePicker popup object.
     * @deprecated
     */
    popup?: popups.Popup;
    /**
     * Specifies the original event arguments.
     */
    event?: MouseEvent | KeyboardEvent | FocusEvent | Event;
    /**
     * Specifies the node to which the popup element to be appended.
     */
    appendTo?: HTMLElement;
}
export  namespace TimePickerBase {
    function createListItems(createdEl: lists.createElementParams, min: Date, max: Date, globalize: base.Internationalization, timeFormat: string, step: number): {
        collection: number[];
        list: HTMLElement;
    };
}
/**
 * TimePicker is an intuitive interface component which provides an options to select a time value
 * from popup list or to set a desired time value.
 * ```
 * <input id='timepicker' type='text'/>
 * <script>
 *   var timePickerObj = new TimePicker({ value: new Date() });
 *   timePickerObj.appendTo('#timepicker');
 * </script>
 * ```
 */
export  class TimePicker extends base.Component<HTMLElement> implements inputs.IInput {
    private inputWrapper;
    private popupWrapper;
    private cloneElement;
    private listWrapper;
    private listTag;
    private anchor;
    private selectedElement;
    private liCollections;
    protected inputElement: HTMLInputElement;
    private popupObj;
    protected inputEvent: base.KeyboardEvents;
    protected globalize: base.Internationalization;
    private defaultCulture;
    private containerStyle;
    private rippleFn;
    private l10n;
    private cursorDetails;
    private activeIndex;
    private timeCollections;
    private isNavigate;
    private disableItemCollection;
    protected isPreventBlur: boolean;
    private isTextSelected;
    private prevValue;
    private inputStyle;
    private angularTag;
    private valueWithMinutes;
    private prevDate;
    private initValue;
    private initMin;
    private initMax;
    private inputEleValue;
    private openPopupEventArgs;
    private formatString;
    protected tabIndex: string;
    private formElement;
    private modal;
    private invalidValueString;
    protected keyConfigure: {
        [key: string]: string;
    };
    private timeOptions;
    /**
     * Gets or sets the width of the TimePicker component. The width of the popup is based on the width of the component.
     * @default null
     */
    width: string | number;
    /**
     * Specifies the root CSS class of the TimePicker that allows to
     * customize the appearance by overriding the styles.
     * @default null
     */
    cssClass: string;
    /**
     * Specifies the component to act as strict so that, it allows to enter only a valid time value within a specified range or else
     * resets to previous value. By default, strictMode is in false.
     * > For more details refer to
     * [`Strict Mode`](../../timepicker/strict-mode/) documentation.
     * @default false
     */
    strictMode: boolean;
    /**
     * Customizes the key actions in TimePicker.
     * For example, when using German keyboard, the key actions can be customized using these shortcuts.
     *
     * <table>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * Key action<br/></td><td colSpan=1 rowSpan=1>
     * Key<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * enter<br/></td><td colSpan=1 rowSpan=1>
     * enter<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * escape<br/></td><td colSpan=1 rowSpan=1>
     * escape<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * end<br/></td><td colSpan=1 rowSpan=1>
     * end<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * tab<br/></td><td colSpan=1 rowSpan=1>
     * tab<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * home<br/></td><td colSpan=1 rowSpan=1>
     * home<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * down<br/></td><td colSpan=1 rowSpan=1>
     * downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * up<br/></td><td colSpan=1 rowSpan=1>
     * uparrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * left<br/></td><td colSpan=1 rowSpan=1>
     * leftarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * right<br/></td><td colSpan=1 rowSpan=1>
     * rightarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * open<br/></td><td colSpan=1 rowSpan=1>
     * alt+downarrow<br/></td></tr>
     * <tr>
     * <td colSpan=1 rowSpan=1>
     * close<br/></td><td colSpan=1 rowSpan=1>
     * alt+uparrow<br/></td></tr>
     * </table>
     *
     * @default null
     * @blazorType object
     */
    keyConfigs: {
        [key: string]: string;
    };
    /**
     * Specifies the format of value that is to be displayed in component. By default, the format is
     * based on the culture.
     * > For more details refer to
     * [`Format`](../../timepicker/getting-started#setting-the-time-format) documentation.
     * @default null
     * @aspType string
     * @blazorType string
     */
    format: string | TimeFormatObject;
    /**
     * Specifies whether the component to be disabled or not.
     * @default true
     */
    enabled: boolean;
    /**
     * Specifies the component in readonly state.
     * @default false
     */
    readonly: boolean;
    /**
     * You can add the additional html attributes such as disabled, value etc., to the element.
     * If you configured both property and equivalent html attribute then the component considers the property value.
     * @default {}
     */
    htmlAttributes: {
        [key: string]: string;
    };
    /**
     * Specifies the placeholder text to be floated.
     * Possible values are:
     * Never: The label will never float in the input when the placeholder is available.
     * Always: The floating label will always float above the input.
     * Auto: The floating label will float above the input after focusing or entering a value in the input.
     * @default Syncfusion.EJ2.Inputs.inputs.FloatLabelType.Never
     * @aspType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @blazorType Syncfusion.EJ2.Inputs.inputs.FloatLabelType
     * @isEnumeration true
     */
    floatLabelType: inputs.FloatLabelType | string;
    /**
     * Specifies the placeholder text that is displayed in textbox.
     * @default null
     */
    placeholder: string;
    /**
     * specifies the z-index value of the timePicker popup element.
     * @default 1000
     * @aspType int
     * @blazorType int
     */
    zIndex: number;
    /**
     * Enable or disable the persisting component's state between the page reloads. If enabled, following list of states will be persisted.
     * 1. Value
     * @default false
     */
    enablePersistence: boolean;
    /**
     * Specifies whether to show or hide the clear icon.
     * @default true
     */
    showClearButton: boolean;
    /**
     * Specifies the time interval between the two adjacent time values in the popup list.
     * > For more details refer to
     * [`Format`](../../timepicker/getting-started#setting-the-time-format)documentation.
     * @default 30
     * @blazorType int
     *
     */
    step: number;
    /**
     * Specifies the scroll bar position if there is no value is selected in the popup list or
     *  the given value is not present in the popup list.
     * > For more details refer to
     * [`Time Duration`](https://ej2.syncfusion.com/demos/#/material/timepicker/list-formatting.html) sample.
     * @default null
     * @isBlazorNullableType true
     */
    scrollTo: Date;
    /**
     * Gets or sets the value of the component. The value is parsed based on the culture specific time format.
     * @default null
     * @isBlazorNullableType true
     */
    value: Date;
    /**
     * Gets or sets the minimum time value that can be allowed to select in TimePicker.
     * > For more details refer to
     * [`Time Range`](../../timepicker/time-range/) documentation.
     * @default 00:00
     * @blazorDefaultValue new DateTime(1900, 01, 01, 00, 00, 00)
     */
    min: Date;
    /**
     * Gets or sets the maximum time value that can be allowed to select in TimePicker.
     * > For more details refer to
     * [`Time Range`](../../timepicker/time-range/) documentation.
     * @default 00:00
     * @blazorDefaultValue new DateTime(2099, 12, 31, 23, 59, 59)
     */
    max: Date;
    /**
     * > Support for `allowEdit` has been provided from
     * [`v16.2.46`](https://ej2.syncfusion.com/angular/documentation/release-notes/16.2.46/#timepicker).
     *
     * Specifies whether the input textbox is editable or not. Here the user can select the value from the
     * popup and cannot edit in the input textbox.
     * @default true
     */
    allowEdit: boolean;
    /**
     * Triggers when the value is changed.
     * @event
     * @blazorProperty 'ValueChange'
     */
    change: base.EmitType<ChangeEventArgs>;
    /**
     * Triggers when the component is created.
     * @event
     * @blazorProperty 'Created'
     */
    created: base.EmitType<Object>;
    /**
     * Triggers when the component is destroyed.
     * @event
     * @blazorProperty 'Destroyed'
     */
    destroyed: base.EmitType<Object>;
    /**
     * Triggers when the popup is opened.
     * @event
     * @blazorProperty 'OnOpen'
     */
    open: base.EmitType<PopupEventArgs>;
    /**
     * Triggers while rendering the each popup list item.
     * @event
     * @blazorProperty 'OnItemRender'
     */
    itemRender: base.EmitType<ItemEventArgs>;
    /**
     * Triggers when the popup is closed.
     * @event
     * @blazorProperty 'OnClose'
     */
    close: base.EmitType<PopupEventArgs>;
    /**
     * Triggers when the control loses the focus.
     * @event
     */
    blur: base.EmitType<BlurEventArgs>;
    /**
     * Triggers when the control gets focused.
     * @event
     */
    focus: base.EmitType<FocusEventArgs>;
    /**
     * Constructor for creating the widget
     */
    constructor(options?: TimePickerModel, element?: string | HTMLInputElement);
    /**
     * Initialize the event handler
     * @private
     */
    protected preRender(): void;
    protected render(): void;
    private setTimeAllowEdit;
    private clearIconState;
    private validateDisable;
    protected validationAttribute(target: HTMLElement, input: Element): void;
    private initialize;
    protected checkTimeFormat(): void;
    private checkDateValue;
    private createInputElement;
    private getCldrDateTimeFormat;
    private checkInvalidValue;
    private CldrFormat;
    destroy(): void;
    protected ensureInputAttribute(): void;
    private popupCreation;
    protected getPopupHeight(): number;
    private generateList;
    private renderPopup;
    private getFormattedValue;
    private getDateObject;
    private updateHtmlAttributeToWrapper;
    private updateHtmlAttributeToElement;
    private removeErrorClass;
    private checkErrorState;
    private validateInterval;
    private disableTimeIcon;
    private disableElement;
    private enableElement;
    private selectInputText;
    private getMeridianText;
    private getCursorSelection;
    private getActiveElement;
    private isNullOrEmpty;
    private setWidth;
    private setPopupWidth;
    private setScrollPosition;
    private findScrollTop;
    private setScrollTo;
    private getText;
    private getValue;
    private cldrDateFormat;
    private cldrTimeFormat;
    private dateToNumeric;
    private getExactDateTime;
    private setValue;
    private compareFormatChange;
    private updatePlaceHolder;
    private popupHandler;
    private mouseDownHandler;
    private mouseUpHandler;
    private focusSelection;
    private inputHandler;
    private onMouseClick;
    private closePopup;
    private checkValueChange;
    private onMouseOver;
    private setHover;
    private setSelection;
    private onMouseLeave;
    private scrollHandler;
    private setMinMax;
    protected validateMinMax(dateVal: Date | string, minVal: Date, maxVal: Date): Date | string;
    private valueIsDisable;
    protected validateState(val: string | Date): boolean;
    protected strictOperation(minimum: Date, maximum: Date, dateVal: Date | string, val: Date): Date | string;
    protected bindEvents(): void;
    protected formResetHandler(): void;
    private inputChangeHandler;
    protected unBindEvents(): void;
    private bindClearEvent;
    protected clearHandler(e: MouseEvent): void;
    private clear;
    protected setZIndex(): void;
    protected checkAttributes(isDynamic: boolean): void;
    protected setCurrentDate(value: Date): Date;
    protected getTextFormat(): number;
    protected updateValue(value: string | Date, event: base.KeyboardEventArgs | FocusEvent | MouseEvent): void;
    protected previousState(date: Date): string;
    protected resetState(): void;
    protected objToString(val: Date): string;
    protected checkValue(value: string | Date): string;
    protected validateValue(date: Date, value: string | Date): string;
    protected findNextElement(event: base.KeyboardEventArgs): void;
    protected elementValue(value: Date): void;
    private validLiElement;
    protected keyHandler(event: base.KeyboardEventArgs): void;
    protected getCultureTimeObject(ld: Object, c: string): Object;
    protected getCultureDateObject(ld: Object, c: string): Object;
    protected wireListEvents(): void;
    protected unWireListEvents(): void;
    protected valueProcess(event: base.KeyboardEventArgs | FocusEvent | MouseEvent, value: Date): void;
    protected changeEvent(e: base.KeyboardEventArgs | FocusEvent | MouseEvent): void;
    protected updateInput(isUpdate: boolean, date: Date): void;
    protected setActiveDescendant(): void;
    protected removeSelection(): void;
    protected removeHover(className: string): void;
    protected getHoverItem(className: string): Element[];
    private setActiveClass;
    protected addSelection(): void;
    protected isValidLI(li: Element | HTMLElement): boolean;
    protected createDateObj(val: Date | string): Date;
    protected TimeParse(today: string, val: Date | string): Date;
    protected createListItems(): void;
    private documentClickHandler;
    protected setEnableRtl(): void;
    protected setEnable(): void;
    protected getProperty(date: TimePickerModel, val: string): void;
    protected inputBlurHandler(e: MouseEvent): void;
    /**
     * Focuses out the TimePicker textbox element.
     * @returns void
     */
    focusOut(): void;
    private isPopupOpen;
    private inputFocusHandler;
    /**
     * Focused the TimePicker textbox element.
     * @returns void
     */
    focusIn(): void;
    /**
     * Hides the TimePicker popup.
     * @returns void
     */
    hide(): void;
    /**
     * Opens the popup to show the list items.
     * @returns void
     */
    show(event?: KeyboardEvent | MouseEvent | Event): void;
    private formatValues;
    private popupAlignment;
    /**
     * Gets the properties to be maintained upon browser refresh.
     * @returns string
     */
    getPersistData(): string;
    /**
     * To get component name
     * @private
     */
    protected getModuleName(): string;
    /**
     * Called internally if any of the property value changed.
     * returns void
     * @private
     */
    onPropertyChanged(newProp: TimePickerModel, oldProp: TimePickerModel): void;
    protected checkInValue(inValue: string | Date | number): string;
}
 }
export namespace charts { 

//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/accumulation-model.d.ts
/**
 * Interface for a class AccumulationChart
 */
export interface AccumulationChartModel extends base.ComponentModel{
    /**
     * The width of the chart as a string in order to provide input as both like '100px' or '100%'.
     * If specified as '100%, chart will render to the full width of its parent element.
     * @default null
     */
    width?: string;
    /**
     * The height of the chart as a string in order to provide input as both like '100px' or '100%'.
     * If specified as '100%, chart will render to the full height of its parent element.
     * @default null
     */
    height?: string;
    /**
     * Title for accumulation chart
     * @default null
     */
    title?: string;
    /**
     * Center of pie
     */
    center?: PieCenterModel;
    /**
    * Specifies the dataSource for the AccumulationChart. It can be an array of JSON objects or an instance of data.DataManager.
    * ```html
    * <div id='Pie'></div>
    * ```
    * ```typescript
    * let dataManager: data.DataManager = new data.DataManager({
    *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
    * });
    * let query: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
    * let pie: AccumulationChart = new AccumulationChart({
    * ...
    *     dataSource: dataManager,
    *     series: [{
    *        xName: 'Id',
    *        yName: 'Estimate',
    *        query: query
    *    }],
    * ...
    * });
    * pie.appendTo('#Pie');
    * ```
    * @default ''
    */
    dataSource?: Object | data.DataManager;
    /**
     * Options for customizing the `title` of accumulation chart.
     */
    titleStyle?: FontModel;
    /**
     * SubTitle for accumulation chart
     * @default null
     */
    subTitle?: string;
    /**
     * Options for customizing the `subtitle` of accumulation chart.
     */
    subTitleStyle?: FontModel;
    /**
     * Options for customizing the legend of accumulation chart.
     */
    legendSettings?: LegendSettingsModel;
    /**
     * Options for customizing the tooltip of accumulation chart.
     */
    tooltip?:  TooltipSettingsModel;
    /**
     * Specifies whether point has to get selected or not. Takes value either 'None 'or 'Point'
     * @default None
     */
    selectionMode?: AccumulationSelectionMode;
    /**
     * If set true, enables the multi selection in accumulation chart. It requires `selectionMode` to be `Point`.
     * @default false
     */
    isMultiSelect?: boolean;
    /**
     * If set true, enables the animation for both chart and accumulation.
     * @default true
     */
    enableAnimation?: boolean;
    /**
     * Specifies the point indexes to be selected while loading a accumulation chart.
     * It requires `selectionMode` to be `Point`.
     * ```html
     * <div id='Pie'></div>
     * ```
     * ```typescript
     * let pie: AccumulationChart = new AccumulationChart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * pie.appendTo('#Pie');
     * ```
     * @default []
     */
    selectedDataIndexes?: IndexesModel[];
    /**
     *  Options to customize the left, right, top and bottom margins of accumulation chart.
     */
    margin?: MarginModel;
    /**
     * If set true, labels for the point will be placed smartly without overlapping.
     * @default true
     */
    enableSmartLabels?: boolean;
    /**
     * Options for customizing the color and width of the chart border.
     */
    border?: BorderModel;
    /**
     * The background color of the chart, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    background?: string;
    /**
     * The configuration for series in accumulation chart.
     */
    series?: AccumulationSeriesModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations?: AccumulationAnnotationSettingsModel[];
    /**
     * Specifies the theme for accumulation chart.
     * @default 'Material'
     */
    theme?: AccumulationTheme;
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator?: boolean;
    /**
     * To enable export feature in chart.
     * @default true
     */
    enableExport?: boolean;
    /**
     * Triggers after accumulation chart loaded.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<IAccLoadedEventArgs>;
    /**
     * Triggers before accumulation chart load.
     * @event
     * @deprecated
     */
    load?: base.EmitType<IAccLoadedEventArgs>;
    /**
     * Triggers before the series gets rendered.
     * @event
     * @deprecated
     */
    seriesRender?: base.EmitType<IAccSeriesRenderEventArgs>;
    /**
     * Triggers before the legend gets rendered.
     * @event
     * @deprecated
     */
    legendRender?: base.EmitType<ILegendRenderEventArgs>;
    /**
     * Triggers before the data label for series gets rendered.
     * @event
     * @deprecated
     */
    textRender?: base.EmitType<IAccTextRenderEventArgs>;
    /**
     * Triggers before the tooltip for series gets rendered.
     * @event
     */
    tooltipRender?: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers before each points for series gets rendered.
     * @event
     * @deprecated
     */
    pointRender?: base.EmitType<IAccPointRenderEventArgs>;
    /**
     * Triggers before the annotation gets rendered.
     * @event
     * @deprecated
     */
    annotationRender?: base.EmitType<IAnnotationRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint?: base.EmitType<IPrintEventArgs>;
    /**
     * Triggers on hovering the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseMove'
     */
    chartMouseMove?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseClick'
     */
    chartMouseClick?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick?: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove?: base.EmitType<IPointEventArgs>;
    /**
     * Triggers after animation gets completed for series.
     * @event
     * @blazorProperty 'OnAnimationComplete'
     */
    animationComplete?: base.EmitType<IAccAnimationCompleteEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnChartMouseDown'
     */
    chartMouseDown?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers while cursor leaves the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseLeave'
     */
    chartMouseLeave?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnChartMouseUp'
     */
    chartMouseUp?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers after window resize.
     * @event
     * @blazorProperty 'Resized'
     */
    resized?: base.EmitType<IAccResizeEventArgs>;
    /**
     * Defines the currencyCode format of the accumulation chart
     * @private
     * @aspType string
     */
    currencyCode?: string;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/accumulation.d.ts
/**
 * AccumulationChart file
 */
/**
 * Represents the AccumulationChart control.
 * ```html
 * <div id="accumulation"/>
 * <script>
 *   var accObj = new AccumulationChart({ });
 *   accObj.appendTo("#accumulation");
 * </script>
 * ```
 * @public
 */
export  class AccumulationChart extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * `accBaseModue` is used to define the common functionalities of accumulation series
     * @private
     */
    accBaseModule: AccumulationBase;
    /**
     * `pieSeriesModule` is used to render pie series.
     * @private
     */
    pieSeriesModule: PieSeries;
    /**
     * `funnelSeriesModule` is used to render funnel series.
     * @private
     */
    funnelSeriesModule: FunnelSeries;
    /**
     * `pyramidSeriesModule` is used to render funnel series.
     * @private
     */
    pyramidSeriesModule: PyramidSeries;
    /**
     * `accumulationLegendModule` is used to manipulate and add legend in accumulation chart.
     */
    accumulationLegendModule: AccumulationLegend;
    /**
     * `accumulationDataLabelModule` is used to manipulate and add dataLabel in accumulation chart.
     */
    accumulationDataLabelModule: AccumulationDataLabel;
    /**
     * `accumulationTooltipModule` is used to manipulate and add tooltip in accumulation chart.
     */
    accumulationTooltipModule: AccumulationTooltip;
    /**
     * `accumulationSelectionModule` is used to manipulate and add selection in accumulation chart.
     */
    accumulationSelectionModule: AccumulationSelection;
    /**
     * `annotationModule` is used to manipulate and add annotation in chart.
     */
    annotationModule: AccumulationAnnotation;
    /**
     * Export Module is used to export Accumulation chart.
     */
    exportModule: Export;
    /**
     * The width of the chart as a string in order to provide input as both like '100px' or '100%'.
     * If specified as '100%, chart will render to the full width of its parent element.
     * @default null
     */
    width: string;
    /**
     * The height of the chart as a string in order to provide input as both like '100px' or '100%'.
     * If specified as '100%, chart will render to the full height of its parent element.
     * @default null
     */
    height: string;
    /**
     * Title for accumulation chart
     * @default null
     */
    title: string;
    /**
     * Center of pie
     */
    center: PieCenterModel;
    /**
     * Specifies the dataSource for the AccumulationChart. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Pie'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let pie$: AccumulationChart = new AccumulationChart({
     * ...
     *     dataSource: dataManager,
     *     series: [{
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * pie.appendTo('#Pie');
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     * Options for customizing the `title` of accumulation chart.
     */
    titleStyle: FontModel;
    /**
     * SubTitle for accumulation chart
     * @default null
     */
    subTitle: string;
    /**
     * Options for customizing the `subtitle` of accumulation chart.
     */
    subTitleStyle: FontModel;
    /**
     * Options for customizing the legend of accumulation chart.
     */
    legendSettings: LegendSettingsModel;
    /**
     * Options for customizing the tooltip of accumulation chart.
     */
    tooltip: TooltipSettingsModel;
    /**
     * Specifies whether point has to get selected or not. Takes value either 'None 'or 'Point'
     * @default None
     */
    selectionMode: AccumulationSelectionMode;
    /**
     * If set true, enables the multi selection in accumulation chart. It requires `selectionMode` to be `Point`.
     * @default false
     */
    isMultiSelect: boolean;
    /**
     * If set true, enables the animation for both chart and accumulation.
     * @default true
     */
    enableAnimation: boolean;
    /**
     * Specifies the point indexes to be selected while loading a accumulation chart.
     * It requires `selectionMode` to be `Point`.
     * ```html
     * <div id='Pie'></div>
     * ```
     * ```typescript
     * let pie$: AccumulationChart = new AccumulationChart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * pie.appendTo('#Pie');
     * ```
     * @default []
     */
    selectedDataIndexes: IndexesModel[];
    /**
     *  Options to customize the left, right, top and bottom margins of accumulation chart.
     */
    margin: MarginModel;
    /**
     * If set true, labels for the point will be placed smartly without overlapping.
     * @default true
     */
    enableSmartLabels: boolean;
    /**
     * Options for customizing the color and width of the chart border.
     */
    border: BorderModel;
    /**
     * The background color of the chart, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    background: string;
    /**
     * The configuration for series in accumulation chart.
     */
    series: AccumulationSeriesModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations: AccumulationAnnotationSettingsModel[];
    /**
     * Specifies the theme for accumulation chart.
     * @default 'Material'
     */
    theme: AccumulationTheme;
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator: boolean;
    /**
     * To enable1 export feature in chart.
     * @default true
     */
    enableExport: boolean;
    /**
     * Triggers after accumulation chart loaded.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<IAccLoadedEventArgs>;
    /**
     * Triggers before accumulation chart load.
     * @event
     * @deprecated
     */
    load: base.EmitType<IAccLoadedEventArgs>;
    /**
     * Triggers before the series gets rendered.
     * @event
     * @deprecated
     */
    seriesRender: base.EmitType<IAccSeriesRenderEventArgs>;
    /**
     * Triggers before the legend gets rendered.
     * @event
     * @deprecated
     */
    legendRender: base.EmitType<ILegendRenderEventArgs>;
    /**
     * Triggers before the data label for series gets rendered.
     * @event
     * @deprecated
     */
    textRender: base.EmitType<IAccTextRenderEventArgs>;
    /**
     * Triggers before the tooltip for series gets rendered.
     * @event
     */
    tooltipRender: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers before each points for series gets rendered.
     * @event
     * @deprecated
     */
    pointRender: base.EmitType<IAccPointRenderEventArgs>;
    /**
     * Triggers before the annotation gets rendered.
     * @event
     * @deprecated
     */
    annotationRender: base.EmitType<IAnnotationRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint: base.EmitType<IPrintEventArgs>;
    /**
     * Triggers on hovering the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseMove'
     */
    chartMouseMove: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseClick'
     */
    chartMouseClick: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove: base.EmitType<IPointEventArgs>;
    /**
     * Triggers after animation gets completed for series.
     * @event
     * @blazorProperty 'OnAnimationComplete'
     */
    animationComplete: base.EmitType<IAccAnimationCompleteEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnChartMouseDown'
     */
    chartMouseDown: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers while cursor leaves the accumulation chart.
     * @event
     * @blazorProperty 'OnChartMouseLeave'
     */
    chartMouseLeave: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnChartMouseUp'
     */
    chartMouseUp: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers after window resize.
     * @event
     * @blazorProperty 'Resized'
     */
    resized: base.EmitType<IAccResizeEventArgs>;
    /**
     * Defines the currencyCode format of the accumulation chart
     * @private
     * @aspType string
     */
    private currencyCode;
    /**
     * Animate the series bounds on data change.
     * @private
     */
    animate(duration?: number): void;
    /** @private */
    svgObject: Element;
    /** @private */
    private animateselected;
    /** @public */
    duration: number;
    /** @private */
    initialClipRect: svgBase.Rect;
    /** @private */
    availableSize: svgBase.Size;
    /** @private */
    renderer: svgBase.SvgRenderer | svgBase.CanvasRenderer;
    /** @private */
    intl: base.Internationalization;
    /** @private */
    visibleSeries: AccumulationSeries[];
    /** @private */
    seriesCounts: number;
    /** @private explode radius internal property */
    explodeDistance: number;
    /** @private Mouse position x */
    mouseX: number;
    /** @private Mouse position y */
    mouseY: number;
    private resizeTo;
    /** @private */
    origin: ChartLocation;
    /** @private */
    readonly type: AccumulationType;
    /** @private */
    isTouch: boolean;
    /** @private */
    redraw: boolean;
    /** @private */
    animateSeries: boolean;
    private titleCollection;
    private subTitleCollection;
    /** @private */
    themeStyle: IThemeStyle;
    private chartid;
    /** @private */
    isBlazor: boolean;
    /**
     * Constructor for creating the AccumulationChart widget
     * @private
     */
    constructor(options?: AccumulationChartModel, element?: string | HTMLElement);
    /**
     *  To create svg object, renderer and binding events for the container.
     */
    protected preRender(): void;
    /**
     * Themeing for chart goes here
     */
    private setTheme;
    /**
     * To render the accumulation chart elements
     */
    protected render(): void;
    /**
     * Method to unbind events for accumulation chart
     */
    private unWireEvents;
    /**
     * Method to bind events for the accumulation chart
     */
    private wireEvents;
    /**
     * Method to set mouse x, y from events
     */
    private setMouseXY;
    /**
     * Handles the mouse end.
     * @return {boolean}
     * @private
     */
    accumulationMouseEnd(e: PointerEvent): boolean;
    /**
     * Handles the mouse start.
     * @return {boolean}
     * @private
     */
    accumulationMouseStart(e: PointerEvent): boolean;
    /**
     * Handles the accumulation chart resize.
     * @return {boolean}
     * @private
     */
    accumulationResize(e: Event): boolean;
    /**
     * Handles the print method for accumulation chart control.
     */
    print(id?: string[] | string | Element): void;
    /**
     * Export method for the chart.
     */
    export(type: ExportType, fileName: string): void;
    /**
     * Applying styles for accumulation chart element
     */
    private setStyle;
    /**
     * Method to set the annotation content dynamically for accumulation.
     */
    setAnnotationValue(annotationIndex: number, content: string): void;
    /**
     * Handles the mouse move on accumulation chart.
     * @return {boolean}
     * @private
     */
    accumulationMouseMove(e: PointerEvent): boolean;
    titleTooltip(event: Event, x: number, y: number, isTouch?: boolean): void;
    /**
     * Handles the mouse click on accumulation chart.
     * @return {boolean}
     * @private
     */
    accumulationOnMouseClick(e: PointerEvent): boolean;
    private triggerPointEvent;
    /**
     * Handles the mouse right click on accumulation chart.
     * @return {boolean}
     * @private
     */
    accumulationRightClick(event: MouseEvent | PointerEvent): boolean;
    /**
     * Handles the mouse leave on accumulation chart.
     * @return {boolean}
     * @private
     */
    accumulationMouseLeave(e: PointerEvent): boolean;
    /**
     * Method to set culture for chart
     */
    private setCulture;
    /**
     * Method to create SVG element for accumulation chart.
     */
    private createPieSvg;
    /**
     * To Remove the SVG from accumulation chart.
     * @return {boolean}
     * @private
     */
    removeSvg(): void;
    /**
     * Method to create the secondary element for tooltip, datalabel and annotaitons.
     */
    private createSecondaryElement;
    /**
     * Method to find visible series based on series types
     */
    private calculateVisibleSeries;
    /**
     * To find points from dataSource
     */
    private processData;
    /**
     * To refresh the accumulation chart
     * @private
     */
    refreshChart(): void;
    /**
     * Method to find groupped points
     */
    private doGrouppingProcess;
    /**
     * Method to calculate bounds for accumulation chart
     */
    private calculateBounds;
    private calculateLegendBounds;
    /**
     * To render elements for accumulation chart
     * @private
     */
    renderElements(): void;
    /**
     * To set the left and top position for data label template for center aligned chart
     * @private
     */
    setSecondaryElementPosition(): void;
    /**
     * To render the annotaitions for accumulation series.
     * @private
     */
    renderAnnotation(): void;
    /**
     * Method to process the explode in accumulation chart
     * @private
     */
    processExplode(): void;
    /**
     * Method to render series for accumulation chart
     */
    private renderSeries;
    /**
     * Method to render border for accumulation chart
     */
    private renderBorder;
    /**
     * Method to render legend for accumulation chart
     */
    private renderLegend;
    /**
     * To process the selection in accumulation chart
     * @private
     */
    processSelection(): void;
    /**
     * To render title for accumulation chart
     */
    private renderTitle;
    private renderSubTitle;
    /**
     * To get the series parent element
     * @private
     */
    getSeriesElement(): Element;
    /**
     * To refresh the all visible series points
     * @private
     */
    refreshSeries(): void;
    /**
     * To refresh points label region and visible
     * @private
     */
    refreshPoints(points: AccPoints[]): void;
    /**
     * To get Module name
     *  @private
     */
    getModuleName(): string;
    /**
     * To destroy the accumulationcharts
     * @private
     */
    destroy(): void;
    /**
     * To provide the array of modules needed for control rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    /**
     * To find datalabel visibility in series
     */
    private findDatalabelVisibility;
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
    /**
     * Called internally if any of the property value changed.
     * @private
     */
    onPropertyChanged(newProp: AccumulationChartModel, oldProp: AccumulationChartModel): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/annotation/annotation.d.ts
/**
 * AccumulationChart annotation properties
 */
/**
 * `AccumulationAnnotation` module handles the annotation for accumulation chart.
 */
export  class AccumulationAnnotation extends AnnotationBase {
    private pie;
    private parentElement;
    private annotations;
    /**
     * Constructor for accumulation chart annotation.
     * @private.
     */
    constructor(control: AccumulationChart);
    /**
     * Method to render the annotation for accumulation chart
     * @param element
     */
    renderAnnotations(element: Element): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the annotation.
     * @return {void}
     * @private
     */
    destroy(control: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/index.d.ts
/**
 * Pie Component items exported
 */
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/model/acc-base-model.d.ts
/**
 * Interface for a class AccumulationAnnotationSettings
 */
export interface AccumulationAnnotationSettingsModel {
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content?: string;
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x?: string | Date | number;
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y?: string | number;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits?: Units;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region?: Regions;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment?: Position;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as top side.
     * * Far - Align the annotation element as bottom side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment?: Alignment;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description?: string;
}
/**
 * Interface for a class AccumulationDataLabelSettings
 */
export interface AccumulationDataLabelSettingsModel {
    /**
     * If set true, data label for series gets render.
     * @default false
     */
    visible?: boolean;
    /**
     * The DataSource field which contains the data label value.
     * @default null
     */
    name?: string;
    /**
     * The background color of the data label, which accepts value in hex, rgba as a valid CSS color string.
     * @default 'transparent'
     */
    fill?: string;
    /**
     * Specifies the position of data label. They are.
     * * Outside - Places label outside the point.
     * * Inside - Places label inside the point.
     * @default 'Inside'
     */
    position?: AccumulationLabelPosition;
    /**
     * The roundedCornerX for the data label. It requires `border` values not to be null.
     * @default 5
     */
    rx?: number;
    /**
     * The roundedCornerY for the data label. It requires `border` values not to be null.
     * @default 5
     */
    ry?: number;
    /**
     * Specifies angle for data label.
     * @default 0
     */
    angle?: number;
    /**
     * Enables rotation for data label.
     * @default false
     */
    enableRotation?: boolean;
    /**
     * Option for customizing the border lines.
     */
    border?: BorderModel;
    /**
     * Option for customizing the data label text.
     */
    font?: FontModel;
    /**
     * Options for customize the connector line in series.
     * This property is applicable for Pie, Funnel and Pyramid series.
     * The default connector length for Pie series is '4%'. For other series, it is null.
     */
    connectorStyle?: ConnectorModel;
    /**
     * Custom template to format the data label content. Use ${point.x} and ${point.y} as a placeholder
     * text to display the corresponding data point.
     * @default null
     */
    template?: string;
}
/**
 * Interface for a class PieCenter
 */
export interface PieCenterModel {
    /**
     * X value of the center.
     * @default '50%'
     */
    x?: string;
    /**
     * Y value of the center.
     * @default '50%'
     */
    y?: string;
}
/**
 * Interface for a class AccPoints
 */
export interface AccPointsModel {
}
/**
 * Interface for a class AccumulationSeries
 */
export interface AccumulationSeriesModel {
    /**
     * Specifies the dataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Pie'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: data.Query = new data.Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let pie$: AccumulationChart = new AccumulationChart({
     * ...
     *     series: [{
     *        dataSource: dataManager,
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * pie.appendTo('#Pie');
     * ```
     * @default ''
     */
    dataSource?: Object | data.DataManager;
    /**
     * Specifies data.Query to select data from dataSource. This property is applicable only when the dataSource is `ej.data.DataManager`.
     * @default null
     */
    query?: data.Query;
    /**
     * The DataSource field which contains the x value.
     * @default ''
     */
    xName?: string;
    /**
     * Specifies the series name
     * @default ''
     */
    name?: string;
    /**
     * The provided value will be considered as a Tooltip Mapping name
     * @default ''
     */
    tooltipMappingName?: string;
    /**
     * The DataSource field which contains the y value.
     * @default ''
     */
    yName?: string;
    /**
     * Specifies the series visibility.
     * @default true
     */
    visible?: boolean;
    /**
     * Options for customizing the border of the series.
     */
    border?: BorderModel;
    /**
     * Options for customizing the animation for series.
     */
    animation?: AnimationModel;
    /**
     * The shape of the legend. Each series has its own legend shape. They are
     * * Circle - Renders a circle.
     * * Rectangle - Renders a rectangle.
     * * Triangle - Renders a triangle.
     * * Diamond - Renders a diamond.
     * * Cross - Renders a cross.
     * * HorizontalLine - Renders a horizontalLine.
     * * VerticalLine - Renders a verticalLine.
     * * Pentagon - Renders a pentagon.
     * * InvertedTriangle - Renders a invertedTriangle.
     * * SeriesType -Render a legend shape based on series type.
     * @default 'SeriesType'
     */
    legendShape?: LegendShape;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping?: string;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle?: string;
    /**
     * AccumulationSeries y values less than groupTo are combined into single slice named others
     * @default null
     */
    groupTo?: string;
    /**
     * AccumulationSeries y values less than groupMode are combined into single slice named others
     * @default Value
     */
    groupMode?: GroupModes;
    /**
     * The data label for the series.
     */
    dataLabel?: AccumulationDataLabelSettingsModel;
    /**
     * Palette for series points.
     * @default []
     */
    palettes?: string[];
    /**
     * Start angle for a series.
     * @default 0
     */
    startAngle?: number;
    /**
     * End angle for a series.
     * @default null
     */
    endAngle?: number;
    /**
     * Radius of the pie series and its values in percentage.
     * @default '80%'
     */
    radius?: string;
    /**
     * When the innerRadius value is greater than 0 percentage, a donut will appear in pie series. It takes values only in percentage.
     * @default '0'
     */
    innerRadius?: string;
    /**
     * Specify the type of the series in accumulation chart.
     * @default 'Pie'
     */
    type?: AccumulationType;
    /**
     * To enable or disable tooltip for a series.
     * @default true
     */
    enableTooltip?: boolean;
    /**
     * If set true, series points will be exploded on mouse click or touch.
     * @default false
     */
    explode?: boolean;
    /**
     * Distance of the point from the center, which takes values in both pixels and percentage.
     * @default '30%'
     */
    explodeOffset?: string;
    /**
     * If set true, all the points in the series will get exploded on load.
     * @default false
     */
    explodeAll?: boolean;
    /**
     * Index of the point, to be exploded on load.
     * @default null
     * @aspDefaultValueIgnore
     */
    explodeIndex?: number;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings?: EmptyPointSettingsModel;
    /**
     * Defines the distance between the segments of a funnel/pyramid series. The range will be from 0 to 1
     * @default 0
     */
    gapRatio?: number;
    /**
     * Defines the width of the funnel/pyramid with respect to the chart area
     * @default '80%'
     */
    width?: string;
    /**
     * Defines the height of the funnel/pyramid with respect to the chart area
     * @default '80%'
     */
    height?: string;
    /**
     * Defines the width of the funnel neck with respect to the chart area
     * @default '20%'
     */
    neckWidth?: string;
    /**
     * Defines the height of the funnel neck with respect to the chart area
     * @default '20%'
     */
    neckHeight?: string;
    /**
     * Defines how the values have to be reflected, whether through height/surface of the segments
     * @default 'Linear'
     */
    pyramidMode?: PyramidModes;
    /**
     * The opacity of the series.
     * @default 1.
     */
    opacity?: number;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/model/acc-base.d.ts
/**
 * AccumulationChart base file
 */
/**
 * Annotation for accumulation series
 */
export  class AccumulationAnnotationSettings extends base.ChildProperty<AccumulationAnnotationSettings> {
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content: string;
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x: string | Date | number;
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y: string | number;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits: Units;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region: Regions;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment: Position;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as top side.
     * * Far - Align the annotation element as bottom side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment: Alignment;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description: string;
}
/**
 * Configures the dataLabel in accumulation chart.
 */
export  class AccumulationDataLabelSettings extends base.ChildProperty<AccumulationDataLabelSettings> {
    /**
     * If set true, data label for series gets render.
     * @default false
     */
    visible: boolean;
    /**
     * The DataSource field which contains the data label value.
     * @default null
     */
    name: string;
    /**
     * The background color of the data label, which accepts value in hex, rgba as a valid CSS color string.
     * @default 'transparent'
     */
    fill: string;
    /**
     * Specifies the position of data label. They are.
     * * Outside - Places label outside the point.
     * * Inside - Places label inside the point.
     * @default 'Inside'
     */
    position: AccumulationLabelPosition;
    /**
     * The roundedCornerX for the data label. It requires `border` values not to be null.
     * @default 5
     */
    rx: number;
    /**
     * The roundedCornerY for the data label. It requires `border` values not to be null.
     * @default 5
     */
    ry: number;
    /**
     * Specifies angle for data label.
     * @default 0
     */
    angle: number;
    /**
     * Enables rotation for data label.
     * @default false
     */
    enableRotation: boolean;
    /**
     * Option for customizing the border lines.
     */
    border: BorderModel;
    /**
     * Option for customizing the data label text.
     */
    font: FontModel;
    /**
     * Options for customize the connector line in series.
     * This property is applicable for Pie, Funnel and Pyramid series.
     * The default connector length for Pie series is '4%'. For other series, it is null.
     */
    connectorStyle: ConnectorModel;
    /**
     * Custom template to format the data label content. Use ${point.x} and ${point.y} as a placeholder
     * text to display the corresponding data point.
     * @default null
     */
    template: string;
}
/**
 * Center value of the Pie series.
 */
export  class PieCenter extends base.ChildProperty<PieCenter> {
    /**
     * X value of the center.
     * @default '50%'
     */
    x: string;
    /**
     * Y value of the center.
     * @default '50%'
     */
    y: string;
}
/**
 * Points model for the series.
 * @public
 */
export  class AccPoints {
    /** accumulation point x value */
    x: Object;
    /** accumulation point y value */
    y: number;
    /** accumulation point visibility */
    visible: boolean;
    /** accumulation point text */
    text: string;
    /** accumulation point tooltip */
    tooltip: string;
    /** accumulation point slice radius */
    sliceRadius: string;
    /** accumulation point original text */
    originalText: string;
    /** @private */
    label: string;
    /** accumulation point color */
    color: string;
    /** accumulation point percentage value */
    percentage: number;
    /** accumulation point symbol location */
    symbolLocation: ChartLocation;
    /** accumulation point index */
    index: number;
    /** @private */
    midAngle: number;
    /** @private */
    startAngle: number;
    /** @private */
    endAngle: number;
    /** @private */
    labelAngle: number;
    /** @private */
    region: svgBase.Rect;
    /** @private */
    labelRegion: svgBase.Rect;
    /** @private */
    labelVisible: boolean;
    /** @private */
    labelPosition: AccumulationLabelPosition;
    /** @private */
    yRatio: number;
    /** @private */
    heightRatio: number;
    /** @private */
    labelOffset: ChartLocation;
    regions: svgBase.Rect[];
    /** @private */
    isExplode: boolean;
    /** @private */
    isClubbed: boolean;
    /** @private */
    isSliced: boolean;
    /** @private */
    start: number;
    /** @private */
    degree: number;
    /** @private */
    transform: string;
}
/**
 *  Configures the series in accumulation chart.
 */
export  class AccumulationSeries extends base.ChildProperty<AccumulationSeries> {
    /**
     * Specifies the dataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Pie'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: data.Query = new data.Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let pie$: AccumulationChart = new AccumulationChart({
     * ...
     *     series: [{
     *        dataSource: dataManager,
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * pie.appendTo('#Pie');
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     * Specifies data.Query to select data from dataSource. This property is applicable only when the dataSource is `ej.data.DataManager`.
     * @default null
     */
    query: data.Query;
    /**
     * The DataSource field which contains the x value.
     * @default ''
     */
    xName: string;
    /**
     * Specifies the series name
     * @default ''
     */
    name: string;
    /**
     * The provided value will be considered as a Tooltip Mapping name
     * @default ''
     */
    tooltipMappingName: string;
    /**
     * The DataSource field which contains the y value.
     * @default ''
     */
    yName: string;
    /**
     * Specifies the series visibility.
     * @default true
     */
    visible: boolean;
    /**
     * Options for customizing the border of the series.
     */
    border: BorderModel;
    /**
     * Options for customizing the animation for series.
     */
    animation: AnimationModel;
    /**
     * The shape of the legend. Each series has its own legend shape. They are
     * * Circle - Renders a circle.
     * * Rectangle - Renders a rectangle.
     * * Triangle - Renders a triangle.
     * * Diamond - Renders a diamond.
     * * Cross - Renders a cross.
     * * HorizontalLine - Renders a horizontalLine.
     * * VerticalLine - Renders a verticalLine.
     * * Pentagon - Renders a pentagon.
     * * InvertedTriangle - Renders a invertedTriangle.
     * * SeriesType -Render a legend shape based on series type.
     * @default 'SeriesType'
     */
    legendShape: LegendShape;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping: string;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle: string;
    /**
     * AccumulationSeries y values less than groupTo are combined into single slice named others
     * @default null
     */
    groupTo: string;
    /**
     * AccumulationSeries y values less than groupMode are combined into single slice named others
     * @default Value
     */
    groupMode: GroupModes;
    /**
     * The data label for the series.
     */
    dataLabel: AccumulationDataLabelSettingsModel;
    /**
     * Palette for series points.
     * @default []
     */
    palettes: string[];
    /**
     * Start angle for a series.
     * @default 0
     */
    startAngle: number;
    /**
     * End angle for a series.
     * @default null
     */
    endAngle: number;
    /**
     * Radius of the pie series and its values in percentage.
     * @default '80%'
     */
    radius: string;
    /**
     * When the innerRadius value is greater than 0 percentage, a donut will appear in pie series. It takes values only in percentage.
     * @default '0'
     */
    innerRadius: string;
    /**
     * Specify the type of the series in accumulation chart.
     * @default 'Pie'
     */
    type: AccumulationType;
    /**
     * To enable or disable tooltip for a series.
     * @default true
     */
    enableTooltip: boolean;
    /**
     * If set true, series points will be exploded on mouse click or touch.
     * @default false
     */
    explode: boolean;
    /**
     * Distance of the point from the center, which takes values in both pixels and percentage.
     * @default '30%'
     */
    explodeOffset: string;
    /**
     * If set true, all the points in the series will get exploded on load.
     * @default false
     */
    explodeAll: boolean;
    /**
     * Index of the point, to be exploded on load.
     * @default null
     * @aspDefaultValueIgnore
     */
    explodeIndex: number;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings: EmptyPointSettingsModel;
    /**
     * Defines the distance between the segments of a funnel/pyramid series. The range will be from 0 to 1
     * @default 0
     */
    gapRatio: number;
    /**
     * Defines the width of the funnel/pyramid with respect to the chart area
     * @default '80%'
     */
    width: string;
    /**
     * Defines the height of the funnel/pyramid with respect to the chart area
     * @default '80%'
     */
    height: string;
    /**
     * Defines the width of the funnel neck with respect to the chart area
     * @default '20%'
     */
    neckWidth: string;
    /**
     * Defines the height of the funnel neck with respect to the chart area
     * @default '20%'
     */
    neckHeight: string;
    /**
     * Defines how the values have to be reflected, whether through height/surface of the segments
     * @default 'Linear'
     */
    pyramidMode: PyramidModes;
    /**
     * The opacity of the series.
     * @default 1.
     */
    opacity: number;
    /** @private */
    points: AccPoints[];
    /** @private */
    clubbedPoints: AccPoints[];
    /** @private */
    dataModule: Data;
    /** @private */
    sumOfPoints: number;
    /** @private */
    index: number;
    /** @private */
    sumOfClub: number;
    /** @private */
    resultData: Object;
    /** @private */
    lastGroupTo: string;
    /** @private */
    isRectSeries: boolean;
    /** @private */
    clipRect: svgBase.Rect;
    /** @private */
    category: SeriesCategories;
    /**
     * To find the max bounds of the data label to place smart legend
     *  @private
     */
    labelBound: svgBase.Rect;
    /**
     * To find the max bounds of the accumulation segment to place smart legend
     *  @private
     */
    accumulationBound: svgBase.Rect;
    /**
     * Defines the funnel size
     * @private
     */
    triangleSize: svgBase.Size;
    /**
     * Defines the size of the funnel neck
     * @private
     */
    neckSize: svgBase.Size;
    /** @private To refresh the Datamanager for series */
    refreshDataManager(accumulation: AccumulationChart, render: boolean): void;
    /**
     * To get points on dataManager is success
     * @private
     */
    dataManagerSuccess(e: {
        result: Object;
        count: number;
    }, accumulation: AccumulationChart, render: boolean): void;
    /** @private To find points from result data */
    getPoints(result: Object, accumulation: AccumulationChart): void;
    generateClubPoint(): AccPoints;
    /**
     * Method to set point index and color
     */
    private pushPoints;
    /**
     * Method to find club point
     */
    private isClub;
    /**
     * Method to find sum of points in the series
     */
    private findSumOfPoints;
    /**
     * Method to set points x, y and text from data source
     */
    private setPoints;
    /**
     * Method render the series elements for accumulation chart
     * @private
     */
    renderSeries(accumulation: AccumulationChart, redraw?: boolean): void;
    /**
     * Method render the points elements for accumulation chart series.
     */
    private renderPoints;
    /**
     * Method render the datalabel elements for accumulation chart.
     */
    private renderDataLabel;
    /**
     * To find maximum bounds for smart legend placing
     * @private
     */
    findMaxBounds(totalbound: svgBase.Rect, bound: svgBase.Rect): void;
    /**
     * To set empty point value for null points
     * @private
     */
    setAccEmptyPoint(point: AccPoints, i: number, data: Object, colors: string[]): void;
    /**
     * To find point is empty
     */
    private isEmpty;
}
/**
 * method to get series from index
 * @private
 */
export  function getSeriesFromIndex(index: number, visibleSeries: AccumulationSeries[]): AccumulationSeries;
/**
 * method to get point from index
 * @private
 */
export  function pointByIndex(index: number, points: AccPoints[]): AccPoints;
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/model/enum.d.ts
/**
 * Accumulation charts Enum file
 */
/**
 * Defines the Accumulation Chart series type.
 */
export  type AccumulationType = 
/** Accumulation chart Pie series type */
'Pie' | 
/** Accumulation chart Funnel series type */
'Funnel' | 
/** Accumulation chart Pyramid series type */
'Pyramid';
/**
 * Defines the AccumulationLabelPosition. They are
 * * Inside - Define the data label position for the accumulation series Inside.
 * * Outside - Define the data label position for the accumulation series Outside.
 * *
 */
export  type AccumulationLabelPosition = 
/** Define the data label position for the accumulation series Inside */
'Inside' | 
/** Define the data label position for the accumulation series Outside */
'Outside';
/**
 * Defines the ConnectorType. They are
 * * Line - Accumulation series Connector line type as Straight line.
 * * Curve - Accumulation series Connector line type as Curved line.
 * *
 */
export  type ConnectorType = 
/** Accumulation series Connector line type as Straight line */
'Line' | 
/** Accumulation series Connector line type as Curved line */
'Curve';
/**
 * Defines the SelectionMode, They are.
 * * none - Disable the selection.
 * * point - To select a point.
 */
export  type AccumulationSelectionMode = 
/** Disable the selection. */
'None' | 
/** To select a point. */
'Point';
/**
 * Defines Theme of the accumulation chart. They are
 * * Material - Render a accumulation chart with Material theme.
 * * Fabric - Render a accumulation chart with fabric theme.
 */
export  type AccumulationTheme = 
/**  Render a accumulation chart with Material theme. */
'Material' | 
/**  Render a accumulation chart with Fabric theme. */
'Fabric' | 
/**  Render a accumulation chart with Bootstrap theme. */
'Bootstrap' | 
/**  Render a accumulation chart with Highcontrast Light theme. */
'HighContrastLight' | 
/**  Render a accumulation chart with MaterialDark theme. */
'MaterialDark' | 
/**  Render a accumulation chart with FabricDark theme. */
'FabricDark' | 
/**  Render a accumulation chart with HighContrastDark theme. */
'HighContrast' | 
/**  Render a accumulation chart with BootstrapDark theme. */
'BootstrapDark' | 
/**  Render a accumulation chart with BootstrapDark theme. */
'Bootstrap4';
/**
 * Defines the empty point mode of the chart.
 * * Zero - Used to display empty points as zero.
 * * Drop - Used to ignore the empty point while rendering.
 * * Average - Used to display empty points as previous and next point average.
 */
export  type AccEmptyPointMode = 
/** Used to display empty points as zero  */
'Zero' | 
/** Used to ignore the empty point while rendering  */
'Drop' | 
/** Used to display empty points as previous and next point average  */
'Average' | 
/** Used to ignore the empty point while rendering   */
'Gap';
/**
 * Defines the mode of the pyramid
 * * Linear - Height of the pyramid segments reflects the values
 * * Surface - Surface/Area of the  pyramid segments reflects the values
 */
export  type PyramidModes = 
/** Height of the pyramid segments reflects the values */
'Linear' | 
/** Surface/Area of the  pyramid segments reflects the values */
'Surface';
/**
 * Defines the mode of the group mode
 * * Point - When choosing points, the selected points get grouped.
 * * Value - When choosing values, the points which less then values get grouped.
 */
export  type GroupModes = 
/** When choosing points, the selected points get grouped */
'Point' | 
/** When choosing values, the points which less then values get grouped. */
'Value';
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/model/pie-interface.d.ts
/**
 * Interface for Accumulation chart
 */
/**
 * Accumulation Chart SeriesRender event arguments.
 */
export interface IAccSeriesRenderEventArgs {
    /** Defines the current series */
    series: AccumulationSeries;
    /** Defines the current data object */
    data: Object;
    /** Defines the current series name */
    name: string;
}
/**
 * Accumulation Chart TextRender event arguments.
 */
export interface IAccTextRenderEventArgs extends IChartEventArgs {
    /** Defines the current series */
    series: AccumulationSeriesModel;
    /** Defines the current point */
    point: AccPoints;
    /** Defines the current text */
    text: string;
    /** Defines the current fill color */
    color: string;
    /** Defines the current label border */
    border: BorderModel;
    /** Defines the current text template */
    template: string;
    /** Defines the current font */
    font: FontModel;
}
/**
 * Accumulation Chart TooltipRender event arguments.
 */
export interface IAccTooltipRenderEventArgs extends IChartEventArgs {
    /** Defines the current tooltip content */
    content?: string | HTMLElement;
    /** Defines the current tooltip text style */
    textStyle?: FontModel;
    /** Defines the current tooltip series */
    series: AccumulationSeries;
    /** Defines the current tooltip point */
    point: AccPoints;
}
/**
 * Accumulation Chart AnimationComplete event arguments.
 */
export interface IAccAnimationCompleteEventArgs extends IChartEventArgs {
    /** Defines the current animation series */
    series: AccumulationSeries;
    /** Defines the accumulation chart instance */
    accumulation: AccumulationChart;
    /** Defines the accumulation chart instance */
    chart: AccumulationChart;
}
/**
 * Accumulation Chart Resize event arguments.
 */
export interface IAccResizeEventArgs {
    /** Defines the name of the Event */
    name: string;
    /** Defines the previous size of the accumulation chart */
    previousSize: svgBase.Size;
    /** Defines the current size of the accumulation chart */
    currentSize: svgBase.Size;
    /** Defines the accumulation chart instance */
    accumulation: AccumulationChart;
    /** Defines the accumulation chart instance */
    chart: AccumulationChart;
}
/**
 * Accumulation Chart PointRender event arguments.
 */
export interface IAccPointRenderEventArgs extends IChartEventArgs {
    /** Defines the current series of the point */
    series: AccumulationSeries;
    /** Defines the current point */
    point: AccPoints;
    /** Defines the current point fill color */
    fill: string;
    /** Defines the current point border color */
    border: BorderModel;
    /** Defines the current point height */
    height?: number;
    /** Defines the current point width */
    width?: number;
}
/**
 * Accumulation Chart Load or Loaded event arguments.
 */
export interface IAccLoadedEventArgs extends IChartEventArgs {
    /** Defines the accumulation chart instance */
    accumulation: AccumulationChart;
    /** Defines the accumulation chart instance */
    chart: AccumulationChart;
}
export interface IAccLegendRenderEventArgs extends IChartEventArgs {
    /** Defines the current legend shape */
    shape: LegendShape;
    /** Defines the current legend fill color */
    fill: string;
    /** Defines the current legend text */
    text: string;
}
export interface IAccChartTooltipTemplate {
    /** accumulation point x value */
    x?: Object;
    /** accumulation point y value */
    y?: number;
    /** accumulation point color */
    label?: string;
    /** accumulation point percentage value */
    percentage?: number;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/accumulation-base.d.ts
/**
 * Accumulation Base used to do some base calculation for accumulation chart.
 */
export  class AccumulationBase {
    /** @private */
    constructor(accumulation: AccumulationChart);
    private pieCenter;
    /**
     * Gets the center of the pie
     * @private
     */
    /**
    * Sets the center of the pie
    * @private
    */
    center: ChartLocation;
    private pieRadius;
    /**
     * Gets the radius of the pie
     * @private
     */
    /**
    * Sets the radius of the pie
    * @private
    */
    radius: number;
    private pieLabelRadius;
    /**
     * Gets the label radius of the pie
     * @private
     */
    /**
    * Sets the label radius of the pie
    * @private
    */
    labelRadius: number;
    /** @private */
    protected accumulation: AccumulationChart;
    /**
     * Checks whether the series is circular or not
     * @private
     */
    protected isCircular(): boolean;
    /**
     * To check various radius pie
     * @private
     */
    protected isVariousRadius(): boolean;
    /**
     * To process the explode on accumulation chart loading
     * @private
     */
    processExplode(event: Event): void;
    /**
     * To invoke the explode on accumulation chart loading
     * @private
     */
    invokeExplode(): void;
    /**
     * To deExplode all points in the series
     * @private
     */
    deExplodeAll(index: number, animationDuration: number): void;
    /**
     * To explode point by index
     * @private
     */
    explodePoints(index: number, chart: AccumulationChart, explode?: boolean): void;
    private getSum;
    private clubPointExplode;
    /**
     * To Explode points
     * @param index
     * @param point
     * @param explode
     */
    private pointExplode;
    /**
     * To check point is exploded by id
     */
    private isExplode;
    /**
     * To deExplode the point by index
     */
    private deExplodeSlice;
    /**
     * To translate the point elements by index and position
     */
    private setTranslate;
    /**
     * To translate the point element by id and position
     */
    private setElementTransform;
    /**
     * To translate the point elements by index position
     */
    private explodeSlice;
    /**
     * To Perform animation point explode
     * @param index
     * @param sliceId
     * @param start
     * @param endX
     * @param endY
     */
    private performAnimation;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/dataLabel.d.ts
/**
 * AccumulationDataLabel module used to render `dataLabel`.
 */
export  class AccumulationDataLabel extends AccumulationBase {
    /** @private */
    titleRect: svgBase.Rect;
    /** @private */
    areaRect: svgBase.Rect;
    /** @private */
    clearTooltip: number;
    private id;
    marginValue: number;
    constructor(accumulation: AccumulationChart);
    /**
     * Method to get datalabel text location.
     * @private
     */
    getDataLabelPosition(point: AccPoints, dataLabel: AccumulationDataLabelSettingsModel, textSize: svgBase.Size, points: AccPoints[], parent: Element, id: string): void;
    /**
     * Method to get datalabel bound.
     */
    private getLabelRegion;
    /**
     * Method to get datalabel smart position.
     */
    private getSmartLabel;
    /**
     * To find trimmed datalabel tooltip needed.
     * @return {void}
     * @private
     */
    move(e: Event, x: number, y: number, isTouch?: boolean): void;
    /**
     * To find previous valid label point
     */
    private findPreviousPoint;
    /**
     * To find current point datalabel is overlapping with other points
     */
    private isOverlapping;
    /**
     * To get text trimmed while exceeds the accumulation chart area.
     */
    private textTrimming;
    /**
     * To set point label visible and region to disable.
     */
    private setPointVisibileFalse;
    /**
     * To set datalabel angle position for outside labels
     */
    private setOuterSmartLabel;
    /**
     * Sets smart label positions for funnel and pyramid series
     */
    private setSmartLabelForSegments;
    /**
     * To find connector line overlapping.
     */
    private isConnectorLineOverlapping;
    /**
     * To find two rectangle intersect
     */
    private isLineRectangleIntersect;
    /**
     * To find two line intersect
     */
    private isLinesIntersect;
    /**
     * To get two rectangle overlapping angles.
     */
    private getOverlappedAngle;
    /**
     * To get connector line path
     */
    private getConnectorPath;
    /**
     * Finds the curved path for funnel/pyramid data label connectors
     */
    private getPolyLinePath;
    /**
     * Finds the bezier point for funnel/pyramid data label connectors
     */
    private getBezierPoint;
    /**
     * To get label edges based on the center and label rect position.
     */
    private getEdgeOfLabel;
    /**
     * Finds the distance between the label position and the edge/center of the funnel/pyramid
     */
    private getLabelDistance;
    /**
     * Finds the label position / beginning of the connector(ouside funnel labels)
     */
    private getLabelLocation;
    /**
     * Finds the beginning of connector line
     */
    private getConnectorStartPoint;
    /**
     * To find area rect based on margin, available size.
     * @private
     */
    findAreaRect(): void;
    /**
     * To render the data labels from series points.
     */
    renderDataLabel(point: AccPoints, dataLabel: AccumulationDataLabelSettingsModel, parent: Element, points: AccPoints[], series: number, templateElement?: HTMLElement, redraw?: boolean): void;
    /**
     * To find the template element size
     * @param element
     * @param point
     * @param argsData
     */
    private getTemplateSize;
    /**
     * To set the template element style
     * @param childElement
     * @param point
     * @param parent
     * @param labelColor
     * @param fill
     */
    private setTemplateStyle;
    /**
     * To find saturated color for datalabel
     */
    private getSaturatedColor;
    /**
     * Animates the data label template.
     * @return {void}.
     * @private
     */
    doTemplateAnimation(accumulation: AccumulationChart, element: Element): void;
    /**
     * To find background color for the datalabel
     */
    private getLabelBackground;
    /**
     * To correct the padding between datalabel regions.
     */
    private correctLabelRegion;
    /**
     * To get the dataLabel module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the data label.
     * @return {void}
     * @private
     */
    destroy(accumulation: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/funnel-series.d.ts
/**
 * Defines the behavior of a funnel series
 */
/**
 * FunnelSeries module used to render `Funnel` Series.
 */
export  class FunnelSeries extends TriangularBase {
    /**
     * Defines the path of a funnel segment
     */
    private getSegmentData;
    /**
     * Renders a funnel segment
     * @private
     */
    renderPoint(point: AccPoints, series: AccumulationSeries, chart: AccumulationChart, options: svgBase.PathOption, seriesGroup: Element, redraw: boolean): void;
    /**
     * To get the module name of the funnel series.
     */
    protected getModuleName(): string;
    /**
     * To destroy the funnel series.
     * @return {void}
     * @private
     */
    destroy(accumulation: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/legend.d.ts
/**
 * AccumulationLegend module used to render `Legend` for Accumulation chart.
 */
export  class AccumulationLegend extends BaseLegend {
    titleRect: svgBase.Rect;
    private totalRowCount;
    private maxColumnWidth;
    /**
     * Constructor for Accumulation Legend.
     * @param chart
     */
    constructor(chart: AccumulationChart);
    /**
     * Get the legend options.
     * @return {void}
     * @private
     */
    getLegendOptions(chart: AccumulationChart, series: AccumulationSeries[]): void;
    /**
     * To find legend bounds for accumulation chart.
     * @private
     */
    getLegendBounds(availableSize: svgBase.Size, legendBounds: svgBase.Rect, legend: LegendSettingsModel): void;
    /**
     * To find maximum column size for legend
     */
    private getMaxColumn;
    /**
     * To find available width from legend x position.
     */
    private getAvailWidth;
    /**
     * To find legend rendering locations from legend options.
     * @private
     */
    getRenderPoint(legendOption: LegendOptions, start: ChartLocation, textPadding: number, prevLegend: LegendOptions, rect: svgBase.Rect, count: number, firstLegend: number): void;
    /**
     * finding the smart legend place according to positions.
     * @return {void}
     * @private
     */
    getSmartLegendLocation(labelBound: svgBase.Rect, legendBound: svgBase.Rect, margin: MarginModel): void;
    /**
     * To get title rect.
     */
    private getTitleRect;
    /**
     * To get legend by index
     */
    private legendByIndex;
    /**
     * To show or hide the legend on clicking the legend.
     * @return {void}
     */
    click(event: Event): void;
    /**
     * To translate the point elements by index and position
     */
    private sliceVisibility;
    /**
     * Slice animation
     * @param element
     * @param name
     * @param isVisible
     */
    private sliceAnimate;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the Legend.
     * @return {void}
     * @private
     */
    destroy(chart: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/pie-base.d.ts
/**
 * PieBase class used to do pie base calculations.
 */
export  class PieBase extends AccumulationBase {
    protected startAngle: number;
    protected totalAngle: number;
    innerRadius: number;
    center: ChartLocation;
    radius: number;
    labelRadius: number;
    isRadiusMapped: boolean;
    seriesRadius: number;
    size: number;
    /**
     * To initialize the property values.
     * @private
     */
    initProperties(chart: AccumulationChart, series: AccumulationSeries): void;
    getLabelRadius(series: AccumulationSeriesModel, point: AccPoints): number;
    /**
     * To find the center of the accumulation.
     * @private
     */
    findCenter(accumulation: AccumulationChart, series: AccumulationSeries): void;
    /**
     * To find angles from series.
     */
    private initAngles;
    /**
     * To calculate data-label bound
     * @private
     */
    defaultLabelBound(series: AccumulationSeries, visible: boolean, position: AccumulationLabelPosition): void;
    /**
     * To calculate series bound
     * @private
     */
    getSeriesBound(series: AccumulationSeries): svgBase.Rect;
    /**
     * To get rect location size from angle
     */
    private getRectFromAngle;
    /**
     * To get path arc direction
     */
    protected getPathArc(center: ChartLocation, start: number, end: number, radius: number, innerRadius: number): string;
    /**
     * To get pie direction
     */
    protected getPiePath(center: ChartLocation, start: ChartLocation, end: ChartLocation, radius: number, clockWise: number): string;
    /**
     * To get doughnut direction
     */
    protected getDoughnutPath(center: ChartLocation, start: ChartLocation, end: ChartLocation, radius: number, innerStart: ChartLocation, innerEnd: ChartLocation, innerRadius: number, clockWise: number): string;
    /**
     * Method to start animation for pie series.
     */
    protected doAnimation(slice: Element, series: AccumulationSeries): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/pie-series.d.ts
/**
 * AccumulationChart series file
 */
/**
 * PieSeries module used to render `Pie` Series.
 */
export  class PieSeries extends PieBase {
    /**
     * To get path option, degree, symbolLocation from the point.
     * @private
     */
    renderPoint(point: AccPoints, series: AccumulationSeries, chart: AccumulationChart, option: svgBase.PathOption, seriesGroup: Element, redraw?: boolean): void;
    findSeries(e: PointerEvent | TouchEvent): void;
    toggleInnerPoint(event: PointerEvent | TouchEvent, radius: number, innerRadius: number): void;
    removeBorder(borderElement: Element, duration: number): void;
    private refresh;
    /**
     * To get path option from the point.
     */
    private getPathOption;
    /**
     * To animate the pie series.
     * @private
     */
    animateSeries(accumulation: AccumulationChart, option: AnimationModel, series: AccumulationSeries, slice: Element): void;
    /**
     * To get the module name of the Pie series.
     */
    protected getModuleName(): string;
    /**
     * To destroy the pie series.
     * @return {void}
     * @private
     */
    destroy(accumulation: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/pyramid-series.d.ts
/**
 * Defines the behavior of a pyramid series
 */
/**
 * PyramidSeries module used to render `Pyramid` Series.
 */
export  class PyramidSeries extends TriangularBase {
    /**
     * Defines the path of a pyramid segment
     */
    private getSegmentData;
    /**
     * Initializes the size of the pyramid segments
     * @private
     */
    protected initializeSizeRatio(points: AccPoints[], series: AccumulationSeries): void;
    /**
     * Defines the size of the pyramid segments, the surface of that will reflect the values
     */
    private calculateSurfaceSegments;
    /**
     * Finds the height of pyramid segment
     */
    private getSurfaceHeight;
    /**
     * Solves quadratic equation
     */
    private solveQuadraticEquation;
    /**
     * Renders a pyramid segment
     */
    private renderPoint;
    /**
     * To get the module name of the Pyramid series.
     */
    protected getModuleName(): string;
    /**
     * To destroy the pyramid series
     * @return {void}
     * @private
     */
    destroy(accumulation: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/renderer/triangular-base.d.ts
/**
 * Defines the common behavior of funnel and pyramid series
 */
/**
 * TriangularBase is used to calculate base functions for funnel/pyramid series.
 */
export  class TriangularBase extends AccumulationBase {
    /**
     * Initializes the properties of funnel/pyramid series
     * @private
     */
    initProperties(chart: AccumulationChart, series: AccumulationSeries): void;
    /**
     * Initializes the size of the pyramid/funnel segments
     * @private
     */
    protected initializeSizeRatio(points: AccPoints[], series: AccumulationSeries, reverse?: boolean): void;
    /**
     * Marks the label location from the set of points that forms a pyramid/funnel segment
     * @private
     */
    protected setLabelLocation(series: AccumulationSeries, point: AccPoints, points: ChartLocation[]): void;
    /**
     * Finds the path to connect the list of points
     * @private
     */
    protected findPath(locations: ChartLocation[]): string;
    /**
     * To calculate data-label bounds
     * @private
     */
    defaultLabelBound(series: AccumulationSeries, visible: boolean, position: AccumulationLabelPosition, chart: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/user-interaction/selection.d.ts
/**
 * `AccumulationSelection` module handles the selection for accumulation chart.
 */
export  class AccumulationSelection extends BaseSelection {
    private renderer;
    /** @private */
    rectPoints: svgBase.Rect;
    selectedDataIndexes: Indexes[];
    private series;
    constructor(accumulation: AccumulationChart);
    /**
     * To initialize the private variables
     */
    private initPrivateVariables;
    /**
     * Invoke selection for rendered chart.
     * @param  {AccumulationChart} chart - Define the chart to invoke the selection.
     * @return {void}
     */
    invokeSelection(accumulation: AccumulationChart): void;
    /**
     * To get series selection style by series.
     */
    private generateStyle;
    /**
     * To get elements by index, series
     */
    private findElements;
    /**
     * To get series point element by index
     */
    private getElementByIndex;
    /**
     * To calculate selected elements on mouse click or touch
     * @private
     */
    calculateSelectedElements(accumulation: AccumulationChart, event: Event): void;
    /**
     * To perform the selection process based on index and element.
     */
    private performSelection;
    /**
     * To select the element by index. Adding or removing selection style class name.
     */
    private selection;
    /**
     * To redraw the selection process on accumulation chart refresh.
     * @private
     */
    redrawSelection(accumulation: AccumulationChart, oldMode: AccumulationSelectionMode): void;
    /**
     * To remove the selected elements style classes by indexes.
     */
    private removeSelectedElements;
    /**
     * To perform the selection for legend elements.
     * @private
     */
    legendSelection(accumulation: AccumulationChart, series: number, pointIndex: number): void;
    /**
     * To select the element by selected data indexes.
     */
    private selectDataIndex;
    /**
     * To remove the selection styles for multi selection process.
     */
    private removeMultiSelectEelments;
    /**
     * To apply the opacity effect for accumulation chart series elements.
     */
    private blurEffect;
    /**
     * To check selection elements by style class name.
     */
    private checkSelectionElements;
    /**
     * To apply selection style for elements.
     */
    private applyStyles;
    /**
     * To get selection style class name by id
     */
    private getSelectionClass;
    /**
     * To remove selection style for elements.
     */
    private removeStyles;
    /**
     * To apply or remove selected elements index.
     */
    private addOrRemoveIndex;
    /**
     * To check two index, point and series are equal
     */
    private checkEquals;
    /**
     * To check selected points are visibility
     */
    private checkPointVisibility;
    /**
     * Get module name.
     */
    getModuleName(): string;
    /**
     * To destroy the selection.
     * @return {void}
     * @private
     */
    destroy(accumulation: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/accumulation-chart/user-interaction/tooltip.d.ts
/**
 * `AccumulationTooltip` module is used to render tooltip for accumulation chart.
 */
export  class AccumulationTooltip extends BaseTooltip {
    accumulation: AccumulationChart;
    constructor(accumulation: AccumulationChart);
    /**
     * @hidden
     */
    private addEventListener;
    private mouseLeaveHandler;
    private mouseUpHandler;
    private mouseMoveHandler;
    /**
     * Renders the tooltip.
     * @param  {PointerEvent} event - Mouse move event.
     * @return {void}
     */
    tooltip(event: PointerEvent | TouchEvent): void;
    private renderSeriesTooltip;
    private triggerTooltipRender;
    private getPieData;
    /**
     * To get series from index
     */
    private getSeriesFromIndex;
    private getTooltipText;
    private findHeader;
    private parseTemplate;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the Tooltip.
     * @return {void}
     * @private
     */
    destroy(chart: AccumulationChart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/annotation/annotation.d.ts
/**
 * `ChartAnnotation` module handles the annotation for chart.
 */
export  class ChartAnnotation extends AnnotationBase {
    private chart;
    private annotations;
    private parentElement;
    /**
     * Constructor for chart annotation.
     * @private.
     */
    constructor(control: Chart, annotations: ChartAnnotationSettings[]);
    /**
     * Method to render the annotation for chart
     * @param element
     * @private
     */
    renderAnnotations(element: Element): void;
    /**
     * To destroy the annotation.
     * @return {void}
     * @private
     */
    destroy(control: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/axis-helper.d.ts
/**
 * Common axis classes
 * @private
 */
export  class NiceInterval extends Double {
    /**
     * Method to calculate numeric datetime interval
     */
    calculateDateTimeNiceInterval(axis: Axis, size: svgBase.Size, start: number, end: number, isChart?: boolean): number;
    /**
     * To get the skeleton for the DateTime axis.
     * @return {string}
     * @private
     */
    getSkeleton(axis: Axis, currentValue: number, previousValue: number): string;
    /**
     * Get intervalType month format
     * @param currentValue
     * @param previousValue
     */
    private getMonthFormat;
    /**
     * Get intervalType day label format for the axis
     * @param axis
     * @param currentValue
     * @param previousValue
     */
    private getDayFormat;
    /**
     * Find label format for axis
     * @param axis
     * @param currentValue
     * @param previousValue
     * @private
     */
    findCustomFormats(axis: Axis, currentValue: number, previousValue: number): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/axis-model.d.ts
/**
 * Interface for a class Row
 */
export interface RowModel {
    /**
     * The height of the row as a string accept input both as '100px' and '100%'.
     * If specified as '100%, row renders to the full height of its chart.
     * @default '100%'
     */
    height?: string;
    /**
     * Options to customize the border of the rows.
     */
    border?: BorderModel;
}
/**
 * Interface for a class Column
 */
export interface ColumnModel {
    /**
     * The width of the column as a string accepts input both as like '100px' or '100%'.
     * If specified as '100%, column renders to the full width of its chart.
     * @default '100%'
     */
    width?: string;
    /**
     * Options to customize the border of the columns.
     */
    border?: BorderModel;
}
/**
 * Interface for a class MajorGridLines
 */
export interface MajorGridLinesModel {
    /**
     * The width of the line in pixels.
     * @default 1
     */
    width?: number;
    /**
     * The dash array of the grid lines.
     * @default ''
     */
    dashArray?: string;
    /**
     * The color of the major grid line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
}
/**
 * Interface for a class MinorGridLines
 */
export interface MinorGridLinesModel {
    /**
     * The width of the line in pixels.
     * @default 0.7
     */
    width?: number;
    /**
     * The dash array of grid lines.
     * @default ''
     */
    dashArray?: string;
    /**
     * The color of the minor grid line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
}
/**
 * Interface for a class AxisLine
 */
export interface AxisLineModel {
    /**
     * The width of the line in pixels.
     * @default 1
     */
    width?: number;
    /**
     * The dash array of the axis line.
     * @default ''
     */
    dashArray?: string;
    /**
     * The color of the axis line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
}
/**
 * Interface for a class MajorTickLines
 */
export interface MajorTickLinesModel {
    /**
     * The width of the tick lines in pixels.
     * @default 1
     */
    width?: number;
    /**
     * The height of the ticks in pixels.
     * @default 5
     */
    height?: number;
    /**
     * The color of the major tick line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
}
/**
 * Interface for a class MinorTickLines
 */
export interface MinorTickLinesModel {
    /**
     * The width of the tick line in pixels.
     * @default 0.7
     */
    width?: number;
    /**
     * The height of the ticks in pixels.
     * @default 5
     */
    height?: number;
    /**
     * The color of the minor tick line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
}
/**
 * Interface for a class CrosshairTooltip
 */
export interface CrosshairTooltipModel {
    /**
     * If set to true, crosshair ToolTip will be visible.
     *  @default false
     */
    enable?: Boolean;
    /**
     * The fill color of the ToolTip accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    fill?: string;
    /**
     * Options to customize the crosshair ToolTip text.
     */
    textStyle?: FontModel;
}
/**
 * Interface for a class Axis
 */
export interface AxisModel {
    /**
     * Options to customize the axis label.
     */
    labelStyle?: FontModel;
    /**
     * Options to customize the crosshair ToolTip.
     */
    crosshairTooltip?: CrosshairTooltipModel;
    /**
     * Specifies the title of an axis.
     * @default ''
     */
    title?: string;
    /**
     * Options for customizing the axis title.
     */
    titleStyle?: FontModel;
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat?: string;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton?: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType?: SkeletonType;
    /**
     * Left and right padding for the plot area in pixels.
     * @default 0
     */
    plotOffset?: number;
    /**
     * Specifies indexed category  axis.
     * @default false
     */
    isIndexed?: boolean;
    /**
     * The base value for logarithmic axis. It requires `valueType` to be `Logarithmic`.
     * @default 10
     */
    logBase?: number;
    /**
     * Specifies the index of the column where the axis is associated,
     * when the chart area is divided into multiple plot areas by using `columns`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *     }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    columnIndex?: number;
    /**
     * Specifies the index of the row where the axis is associated, when the chart area is divided into multiple plot areas by using `rows`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *      }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    rowIndex?: number;
    /**
     * Specifies the number of `columns` or `rows` an axis has to span horizontally or vertically.
     * @default 1
     */
    span?: number;
    /**
     * With this property, you can request axis to calculate intervals approximately equal to your specified interval.
     * @default null
     * @aspDefaultValueIgnore
     */
    desiredIntervals?: number;
    /**
     * The maximum number of label count per 100 pixels with respect to the axis length.
     * @default 3
     */
    maximumLabels?: number;
    /**
     * The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
     * @default 1
     */
    zoomFactor?: number;
    /**
     * Position of the zoomed axis. Value ranges from 0 to 1.
     * @default 0
     */
    zoomPosition?: number;
    /**
     * If set to true, the axis will render at the opposite side of its default position.
     * @default false
     */
    opposedPosition?: boolean;
    /**
     * If set to true, axis interval will be calculated automatically with respect to the zoomed range.
     * @default true
     */
    enableAutoIntervalOnZooming?: boolean;
    /**
     * Specifies the padding for the axis range in terms of interval.They are,
     * * none: Padding cannot be applied to the axis.
     * * normal: Padding is applied to the axis based on the range calculation.
     * * additional: Interval of the axis is added as padding to the minimum and maximum values of the range.
     * * round: Axis range is rounded to the nearest possible value divided by the interval.
     * @default 'Auto'
     */
    rangePadding?: ChartRangePadding;
    /**
     * Specifies the type of data the axis is handling.
     * * Double:  Renders a numeric axis.
     * * DateTime: Renders a dateTime axis.
     * * Category: Renders a category axis.
     * * Logarithmic: Renders a log axis.
     * @default 'Double'
     * @blazorType Syncfusion.EJ2.Blazor.Charts.ValueType
     * @isEnumeration true
     */
    valueType?: ValueType;
    /**
     * Specifies the position of labels at the edge of the axis.They are,
     * * None: No action will be performed.
     * * Hide: Edge label will be hidden.
     * * Shift: Shifts the edge labels.
     * @default 'None'
     */
    edgeLabelPlacement?: EdgeLabelPlacement;
    /**
     * Specifies the types like `Years`, `Months`, `Days`, `Hours`, `Minutes`, `Seconds` in date time axis.They are,
     * * Auto: Defines the interval of the axis based on data.
     * * Years: Defines the interval of the axis in years.
     * * Months: Defines the interval of the axis in months.
     * * Days: Defines the interval of the axis in days.
     * * Hours: Defines the interval of the axis in hours.
     * * Minutes: Defines the interval of the axis in minutes.
     * @default 'Auto'
     */
    intervalType?: IntervalType;
    /**
     * Specifies the placement of a label for category axis. They are,
     * * betweenTicks: Renders the label between the ticks.
     * * onTicks: Renders the label on the ticks.
     * @default 'BetweenTicks'
     */
    labelPlacement?: LabelPlacement;
    /**
     * Specifies the placement of a ticks to the axis line. They are,
     * * inside: Renders the ticks inside to the axis line.
     * * outside: Renders the ticks outside to the axis line.
     * @default 'Outside'
     */
    tickPosition?: AxisPosition;
    /**
     * Specifies the placement of a labels to the axis line. They are,
     * * inside: Renders the labels inside to the axis line.
     * * outside: Renders the labels outside to the axis line.
     * @default 'Outside'
     */
    labelPosition?: AxisPosition;
    /**
     * Unique identifier of an axis.
     * To associate an axis with the series, set this name to the xAxisName/yAxisName properties of the series.
     * @default ''
     */
    name?: string;
    /**
     * If set to true, axis label will be visible.
     * @default true
     */
    visible?: boolean;
    /**
     * Specifies the number of minor ticks per interval.
     * @default 0
     */
    minorTicksPerInterval?: number;
    /**
     * The angle to which the axis label gets rotated.
     * @default 0
     */
    labelRotation?: number;
    /**
     * Specifies the value at which the axis line has to be intersect with the vertical axis or vice versa.
     * @default null
     */
    crossesAt?: Object;
    /**
     * Specifies whether axis elements like axis labels, axis title, etc has to be crossed with axis line
     * @default true
     */
    placeNextToAxisLine?: boolean;
    /**
     * Specifies axis name with which the axis line has to be crossed
     * @default null
     */
    crossesInAxis?: string;
    /**
     * Specifies the minimum range of an axis.
     * @default null
     */
    minimum?: Object;
    /**
     * Specifies the maximum range of an axis.
     * @default null
     */
    maximum?: Object;
    /**
     * Specifies the interval for an axis.
     * @default null
     * @aspDefaultValueIgnore
     */
    interval?: number;
    /**
     * Specifies the maximum width of an axis label.
     * @default 34.
     */
    maximumLabelWidth?: number;
    /**
     * Specifies the Trim property for an axis.
     * @default false
     */
    enableTrim?: boolean;
    /**
     * Options for customizing major tick lines.
     */
    majorTickLines?: MajorTickLinesModel;
    /**
     * Options for customizing minor tick lines.
     */
    minorTickLines?: MinorTickLinesModel;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines?: MajorGridLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines?: MinorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    lineStyle?: AxisLineModel;
    /**
     * Specifies the actions like `None`, `Hide`, `Trim`, `Wrap`, `MultipleRows`, `Rotate45`, and `Rotate90`
     * when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * * Trim: Trim the label when it intersects.
     * * Wrap: Wrap the label when it intersects.
     * * MultipleRows: Shows the label in MultipleRows when it intersects.
     * * Rotate45: Rotates the label to 45 degree when it intersects.
     * * Rotate90: Rotates the label to 90 degree when it intersects.
     * @default Trim
     */
    labelIntersectAction?: LabelIntersectAction;
    /**
     * It specifies whether the axis to be rendered in inversed manner or not.
     * @default false
     */
    isInversed?: boolean;
    /**
     * The polar radar radius position.
     * @default 100
     */
    coefficient?: number;
    /**
     * The start angle for the series.
     * @default 0
     */
    startAngle?: number;
    /**
     * Description for axis and its element.
     * @default null
     */
    description?: string;
    /**
     * TabIndex value for the axis.
     * @default 2
     */
    tabIndex?: number;
    /**
     * Specifies the stripLine collection for the axis
     */
    stripLines?: StripLineSettingsModel[];
    /**
     * Specifies the multi level labels collection for the axis
     */
    multiLevelLabels?: MultiLevelLabelsModel[];
    /**
     * Border of the multi level labels.
     */
    border?: LabelBorderModel;
    /**
     * Option to customize scrollbar with lazy loading
     */
    scrollbarSettings?: ScrollbarSettingsModel;
}
/**
 * Interface for a class VisibleLabels
 * @private
 */
export interface VisibleLabelsModel {
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/axis.d.ts
/**
 * Configures the `rows` of the chart.
 */
export  class Row extends base.ChildProperty<Row> {
    /**
     * The height of the row as a string accept input both as '100px' and '100%'.
     * If specified as '100%, row renders to the full height of its chart.
     * @default '100%'
     */
    height: string;
    /**
     * Options to customize the border of the rows.
     */
    border: BorderModel;
    /** @private */
    axes: Axis[];
    /** @private */
    computedHeight: number;
    /** @private */
    computedTop: number;
    /** @private */
    nearSizes: number[];
    /** @private */
    farSizes: number[];
    /**
     * Measure the row size
     * @return {void}
     * @private
     */
    computeSize(axis: Axis, clipRect: svgBase.Rect, scrollBarHeight: number): void;
}
/**
 * Configures the `columns` of the chart.
 */
export  class Column extends base.ChildProperty<Column> {
    /**
     * The width of the column as a string accepts input both as like '100px' or '100%'.
     * If specified as '100%, column renders to the full width of its chart.
     * @default '100%'
     */
    width: string;
    /**
     * Options to customize the border of the columns.
     */
    border: BorderModel;
    /** @private */
    axes: Axis[];
    /** @private */
    computedWidth: number;
    /** @private */
    computedLeft: number;
    /** @private */
    nearSizes: number[];
    /** @private */
    farSizes: number[];
    /** @private */
    private padding;
    /**
     * Measure the column size
     * @return {void}
     * @private
     */
    computeSize(axis: Axis, clipRect: svgBase.Rect, scrollBarHeight: number): void;
}
/**
 * Configures the major grid lines in the `axis`.
 */
export  class MajorGridLines extends base.ChildProperty<MajorGridLines> {
    /**
     * The width of the line in pixels.
     * @default 1
     */
    width: number;
    /**
     * The dash array of the grid lines.
     * @default ''
     */
    dashArray: string;
    /**
     * The color of the major grid line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color: string;
}
/**
 * Configures the minor grid lines in the `axis`.
 */
export  class MinorGridLines extends base.ChildProperty<MinorGridLines> {
    /**
     * The width of the line in pixels.
     * @default 0.7
     */
    width: number;
    /**
     * The dash array of grid lines.
     * @default ''
     */
    dashArray: string;
    /**
     * The color of the minor grid line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color: string;
}
/**
 * Configures the axis line of a chart.
 */
export  class AxisLine extends base.ChildProperty<AxisLine> {
    /**
     * The width of the line in pixels.
     * @default 1
     */
    width: number;
    /**
     * The dash array of the axis line.
     * @default ''
     */
    dashArray: string;
    /**
     * The color of the axis line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color: string;
}
/**
 * Configures the major tick lines.
 */
export  class MajorTickLines extends base.ChildProperty<MajorTickLines> {
    /**
     * The width of the tick lines in pixels.
     * @default 1
     */
    width: number;
    /**
     * The height of the ticks in pixels.
     * @default 5
     */
    height: number;
    /**
     * The color of the major tick line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color: string;
}
/**
 * Configures the minor tick lines.
 */
export  class MinorTickLines extends base.ChildProperty<MinorTickLines> {
    /**
     * The width of the tick line in pixels.
     * @default 0.7
     */
    width: number;
    /**
     * The height of the ticks in pixels.
     * @default 5
     */
    height: number;
    /**
     * The color of the minor tick line that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    color: string;
}
/**
 * Configures the crosshair ToolTip.
 */
export  class CrosshairTooltip extends base.ChildProperty<CrosshairTooltip> {
    /**
     * If set to true, crosshair ToolTip will be visible.
     *  @default false
     */
    enable: Boolean;
    /**
     * The fill color of the ToolTip accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    fill: string;
    /**
     * Options to customize the crosshair ToolTip text.
     */
    textStyle: FontModel;
}
/**
 * Configures the axes in the chart.
 * @public
 */
export  class Axis extends base.ChildProperty<Axis> {
    /**
     * Options to customize the axis label.
     */
    labelStyle: FontModel;
    /**
     * Options to customize the crosshair ToolTip.
     */
    crosshairTooltip: CrosshairTooltipModel;
    /**
     * Specifies the title of an axis.
     * @default ''
     */
    title: string;
    /**
     * Options for customizing the axis title.
     */
    titleStyle: FontModel;
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat: string;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType: SkeletonType;
    /**
     * Left and right padding for the plot area in pixels.
     * @default 0
     */
    plotOffset: number;
    /**
     * Specifies indexed category  axis.
     * @default false
     */
    isIndexed: boolean;
    /**
     * The base value for logarithmic axis. It requires `valueType` to be `Logarithmic`.
     * @default 10
     */
    logBase: number;
    /**
     * Specifies the index of the column where the axis is associated,
     * when the chart area is divided into multiple plot areas by using `columns`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *     }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    columnIndex: number;
    /**
     * Specifies the index of the row where the axis is associated, when the chart area is divided into multiple plot areas by using `rows`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *      }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    rowIndex: number;
    /**
     * Specifies the number of `columns` or `rows` an axis has to span horizontally or vertically.
     * @default 1
     */
    span: number;
    /**
     * With this property, you can request axis to calculate intervals approximately equal to your specified interval.
     * @default null
     * @aspDefaultValueIgnore
     */
    desiredIntervals: number;
    /**
     * The maximum number of label count per 100 pixels with respect to the axis length.
     * @default 3
     */
    maximumLabels: number;
    /**
     * The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
     * @default 1
     */
    zoomFactor: number;
    /**
     * Position of the zoomed axis. Value ranges from 0 to 1.
     * @default 0
     */
    zoomPosition: number;
    /**
     * If set to true, the axis will render at the opposite side of its default position.
     * @default false
     */
    opposedPosition: boolean;
    /**
     * If set to true, axis interval will be calculated automatically with respect to the zoomed range.
     * @default true
     */
    enableAutoIntervalOnZooming: boolean;
    /**
     * Specifies the padding for the axis range in terms of interval.They are,
     * * none: Padding cannot be applied to the axis.
     * * normal: Padding is applied to the axis based on the range calculation.
     * * additional: Interval of the axis is added as padding to the minimum and maximum values of the range.
     * * round: Axis range is rounded to the nearest possible value divided by the interval.
     * @default 'Auto'
     */
    rangePadding: ChartRangePadding;
    /**
     * Specifies the type of data the axis is handling.
     * * Double:  Renders a numeric axis.
     * * DateTime: Renders a dateTime axis.
     * * Category: Renders a category axis.
     * * Logarithmic: Renders a log axis.
     * @default 'Double'
     * @blazorType Syncfusion.EJ2.Blazor.Charts.ValueType
     * @isEnumeration true
     */
    valueType: ValueType;
    /**
     * Specifies the position of labels at the edge of the axis.They are,
     * * None: No action will be performed.
     * * Hide: Edge label will be hidden.
     * * Shift: Shifts the edge labels.
     * @default 'None'
     */
    edgeLabelPlacement: EdgeLabelPlacement;
    /**
     * Specifies the types like `Years`, `Months`, `Days`, `Hours`, `Minutes`, `Seconds` in date time axis.They are,
     * * Auto: Defines the interval of the axis based on data.
     * * Years: Defines the interval of the axis in years.
     * * Months: Defines the interval of the axis in months.
     * * Days: Defines the interval of the axis in days.
     * * Hours: Defines the interval of the axis in hours.
     * * Minutes: Defines the interval of the axis in minutes.
     * @default 'Auto'
     */
    intervalType: IntervalType;
    /**
     * Specifies the placement of a label for category axis. They are,
     * * betweenTicks: Renders the label between the ticks.
     * * onTicks: Renders the label on the ticks.
     * @default 'BetweenTicks'
     */
    labelPlacement: LabelPlacement;
    /**
     * Specifies the placement of a ticks to the axis line. They are,
     * * inside: Renders the ticks inside to the axis line.
     * * outside: Renders the ticks outside to the axis line.
     * @default 'Outside'
     */
    tickPosition: AxisPosition;
    /**
     * Specifies the placement of a labels to the axis line. They are,
     * * inside: Renders the labels inside to the axis line.
     * * outside: Renders the labels outside to the axis line.
     * @default 'Outside'
     */
    labelPosition: AxisPosition;
    /**
     * Unique identifier of an axis.
     * To associate an axis with the series, set this name to the xAxisName/yAxisName properties of the series.
     * @default ''
     */
    name: string;
    /**
     * If set to true, axis label will be visible.
     * @default true
     */
    visible: boolean;
    /**
     * Specifies the number of minor ticks per interval.
     * @default 0
     */
    minorTicksPerInterval: number;
    /**
     * The angle to which the axis label gets rotated.
     * @default 0
     */
    labelRotation: number;
    /**
     * Specifies the value at which the axis line has to be intersect with the vertical axis or vice versa.
     * @default null
     */
    crossesAt: Object;
    /**
     * Specifies whether axis elements like axis labels, axis title, etc has to be crossed with axis line
     * @default true
     */
    placeNextToAxisLine: boolean;
    /**
     * Specifies axis name with which the axis line has to be crossed
     * @default null
     */
    crossesInAxis: string;
    /**
     * Specifies the minimum range of an axis.
     * @default null
     */
    minimum: Object;
    /**
     * Specifies the maximum range of an axis.
     * @default null
     */
    maximum: Object;
    /**
     * Specifies the interval for an axis.
     * @default null
     * @aspDefaultValueIgnore
     */
    interval: number;
    /**
     * Specifies the maximum width of an axis label.
     * @default 34.
     */
    maximumLabelWidth: number;
    /**
     * Specifies the Trim property for an axis.
     * @default false
     */
    enableTrim: boolean;
    /**
     * Options for customizing major tick lines.
     */
    majorTickLines: MajorTickLinesModel;
    /**
     * Options for customizing minor tick lines.
     */
    minorTickLines: MinorTickLinesModel;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines: MajorGridLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines: MinorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    lineStyle: AxisLineModel;
    /**
     * Specifies the actions like `None`, `Hide`, `Trim`, `Wrap`, `MultipleRows`, `Rotate45`, and `Rotate90`
     * when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * * Trim: Trim the label when it intersects.
     * * Wrap: Wrap the label when it intersects.
     * * MultipleRows: Shows the label in MultipleRows when it intersects.
     * * Rotate45: Rotates the label to 45 degree when it intersects.
     * * Rotate90: Rotates the label to 90 degree when it intersects.
     * @default Trim
     */
    labelIntersectAction: LabelIntersectAction;
    /**
     * It specifies whether the axis to be rendered in inversed manner or not.
     * @default false
     */
    isInversed: boolean;
    /**
     * The polar radar radius position.
     * @default 100
     */
    coefficient: number;
    /**
     * The start angle for the series.
     * @default 0
     */
    startAngle: number;
    /**
     * Description for axis and its element.
     * @default null
     */
    description: string;
    /**
     * TabIndex value for the axis.
     * @default 2
     */
    tabIndex: number;
    /**
     * Specifies the stripLine collection for the axis
     */
    stripLines: StripLineSettingsModel[];
    /**
     * Specifies the multi level labels collection for the axis
     */
    multiLevelLabels: MultiLevelLabelsModel[];
    /**
     * Border of the multi level labels.
     */
    border: LabelBorderModel;
    /**
     * Option to customize scrollbar with lazy loading
     */
    scrollbarSettings: ScrollbarSettingsModel;
    /** @private */
    visibleRange: VisibleRangeModel;
    /** @private */
    visibleLabels: VisibleLabels[];
    /** @private */
    actualRange: VisibleRangeModel;
    /** @private */
    series: Series[];
    /** @private */
    doubleRange: DoubleRange;
    /** @private */
    maxLabelSize: svgBase.Size;
    /** @private */
    rotatedLabel: string;
    /** @private */
    rect: svgBase.Rect;
    /** @private */
    axisBottomLine: BorderModel;
    /** @private */
    orientation: Orientation;
    /** @private */
    intervalDivs: number[];
    /** @private */
    actualIntervalType: IntervalType;
    /** @private */
    labels: string[];
    /** @private */
    format: Function;
    /** @private */
    baseModule: Double | DateTime | Category | DateTimeCategory;
    /** @private */
    startLabel: string;
    /** @private */
    endLabel: string;
    /** @private */
    angle: number;
    /** @private */
    dateTimeInterval: number;
    /** @private */
    isStack100: boolean;
    /** @private */
    crossInAxis: this;
    /** @private */
    crossAt: number;
    /** @private */
    updatedRect: svgBase.Rect;
    /** @private */
    multiLevelLabelHeight: number;
    zoomingScrollBar: ScrollBar;
    /** @private */
    scrollBarHeight: number;
    /** @private */
    isChart: boolean;
    /** @private */
    maxPointLength: number;
    constructor(parent: any, propName: string, defaultValue: Object, isArray?: boolean);
    /**
     * The function used to find tick size.
     * @return {number}
     * @private
     */
    findTickSize(crossAxis: Axis): number;
    /**
     * The function used to find axis position.
     * @return {number}
     * @private
     */
    isInside(range: VisibleRangeModel): boolean;
    /**
     * The function used to find label svgBase.Size.
     * @return {number}
     * @private
     */
    findLabelSize(crossAxis: Axis, innerPadding: number): number;
    /**
     * The function used to find axis position.
     * @return {number}
     * @private
     */
    updateCrossValue(chart: Chart): void;
    private findDifference;
    /**
     * Calculate visible range for axis.
     * @return {void}
     * @private
     */
    calculateVisibleRange(size: svgBase.Size): void;
    /**
     * Triggers the event.
     * @return {void}
     * @private
     */
    triggerRangeRender(chart: Chart, minimum: number, maximum: number, interval: number): void;
    /**
     * Calculate padding for the axis.
     * @return {string}
     * @private
     */
    getRangePadding(chart: Chart): string;
    /**
     * Calculate maximum label width for the axis.
     * @return {void}
     * @private
     */
    getMaxLabelWidth(chart: Chart): void;
    /**
     * Finds the multiple rows for axis.
     * @return {void}
     */
    private findMultiRows;
    /**
     * Finds the default module for axis.
     * @return {void}
     * @private
     */
    getModule(chart: Chart): void;
}
/**
 * Axis visible range
 * @public
 */
export interface VisibleRangeModel {
    /** axis minimum value */
    min?: number;
    /** axis maximum value */
    max?: number;
    /** axis interval value */
    interval?: number;
    /** axis delta value */
    delta?: number;
}
/** @private */
export  class VisibleLabels {
    text: string | string[];
    value: number;
    labelStyle: FontModel;
    size: svgBase.Size;
    breakLabelSize: svgBase.Size;
    index: number;
    originalText: string;
    constructor(text: string | string[], value: number, labelStyle: FontModel, originalText: string | string[], size?: svgBase.Size, breakLabelSize?: svgBase.Size, index?: number);
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/cartesian-panel.d.ts
export  class CartesianAxisLayoutPanel {
    private chart;
    private initialClipRect;
    private htmlObject;
    private element;
    private padding;
    /** @private */
    leftSize: number;
    /** @private */
    rightSize: number;
    /** @private */
    topSize: number;
    /** @private */
    bottomSize: number;
    /** @private */
    seriesClipRect: svgBase.Rect;
    /** @private */
    constructor(chartModule?: Chart);
    /**
     * Measure the axis size.
     * @return {void}
     * @private
     */
    measureAxis(rect: svgBase.Rect): void;
    private measureRowAxis;
    private measureColumnAxis;
    /**
     * Measure the column and row in chart.
     * @return {void}
     * @private
     */
    measureDefinition(definition: Row | Column, chart: Chart, size: svgBase.Size, clipRect: svgBase.Rect): void;
    /**
     * Measure the axis.
     * @return {void}
     * @private
     */
    private calculateAxisSize;
    /**
     * Measure the axis.
     * @return {void}
     * @private
     */
    measure(): void;
    private crossAt;
    private updateCrossAt;
    private pushAxis;
    private arrangeAxis;
    private getActualColumn;
    private getActualRow;
    /**
     * Measure the row size.
     * @return {void}
     */
    private calculateRowSize;
    /**
     * Measure the row size.
     * @param rect
     */
    private calculateColumnSize;
    /**
     * To render the axis element.
     * @return {void}
     * @private
     */
    renderAxes(): Element;
    /**
     * To render the axis scrollbar
     * @param chart
     * @param axis
     */
    private renderScrollbar;
    /**
     * To find the axis position
     * @param axis
     */
    private findAxisPosition;
    /**
     * To render the bootom line of the columns and rows
     * @param definition
     * @param index
     * @param isRow
     */
    private drawBottomLine;
    /**
     * To render the axis line
     * @param axis
     * @param index
     * @param plotX
     * @param plotY
     * @param parent
     * @param rect
     */
    private drawAxisLine;
    /**
     * To render the yAxis grid line
     * @param axis
     * @param index
     * @param parent
     * @param rect
     */
    private drawYAxisGridLine;
    /**
     * To check the border of the axis
     * @param axis
     * @param index
     * @param value
     */
    private isBorder;
    /**
     * To render the yAxis label
     * @param axis
     * @param index
     * @param parent
     * @param rect
     * @private
     */
    drawYAxisLabels(axis: Axis, index: number, parent: Element, rect: svgBase.Rect): void;
    /**
     * To render the yAxis label border.
     * @param axis
     * @param index
     * @param parent
     * @param rect
     */
    private drawYAxisBorder;
    /**
     * To render the yAxis title
     * @param axis
     * @param index
     * @param parent
     * @param rect
     */
    private drawYAxisTitle;
    /**
     * xAxis grid line calculation performed here
     * @param axis
     * @param index
     * @param parent
     * @param rect
     */
    private drawXAxisGridLine;
    /**
     * To calcualte the axis minor line
     * @param axis
     * @param tempInterval
     * @param rect
     * @param labelIndex
     */
    private drawAxisMinorLine;
    /**
     * To find the numeric value of the log
     * @param axis
     * @param logPosition
     * @param logInterval
     * @param value
     * @param labelIndex
     */
    private findLogNumeric;
    /**
     * To render the xAxis Labels
     * @param axis
     * @param index
     * @param parent
     * @param rect
     * @private
     */
    drawXAxisLabels(axis: Axis, index: number, parent: Element, rect: svgBase.Rect): void;
    /**
     * To get axis label text
     * @param breakLabels
     * @param label
     * @param axis
     * @param intervalLength
     */
    private getLabelText;
    /**
     * To render the x-axis label border.
     * @param axis
     * @param index
     * @param parent
     * @param axisRect
     */
    private drawXAxisBorder;
    /**
     * To create border element of the axis
     * @param axis
     * @param index
     * @param labelBorder
     * @param parent
     */
    private createAxisBorderElement;
    /**
     * To find the axis label of the intersect action
     * @param axis
     * @param label
     * @param width
     */
    private findAxisLabel;
    /**
     * X-Axis Title function performed
     * @param axis
     * @param index
     * @param parent
     * @param rect
     */
    private drawXAxisTitle;
    /**
     * To render the axis grid and tick lines(Both Major and Minor)
     * @param axis
     * @param index
     * @param gridDirection
     * @param gridModel
     * @param gridId
     * @param gridIndex
     * @param parent
     * @param themeColor
     * @param dashArray
     */
    private renderGridLine;
    /**
     * To Find the parent node of the axis
     * @param chart
     * @param label
     * @param axis
     * @param index
     */
    private findParentNode;
    /**
     * Create Zooming Labels Function Called here
     * @param chart
     * @param labelElement
     * @param axis
     * @param index
     * @param rect
     */
    private createZoomingLabel;
    /**
     * To get Rotate text size
     * @param isBreakLabel
     * @param axis
     * @param label
     * @param angle
     * @param chart
     */
    private getRotateText;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/category-axis.d.ts
/**
 * `Category` module is used to render category axis.
 */
export  class Category extends NiceInterval {
    /**
     * Constructor for the category module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * The function to calculate the range and labels for the axis.
     * @return {void}
     */
    calculateRangeAndInterval(size: svgBase.Size, axis: Axis): void;
    /**
     * Actual Range for the axis.
     * @private
     */
    getActualRange(axis: Axis, size: svgBase.Size): void;
    /**
     * Padding for the axis.
     * @private
     */
    applyRangePadding(axis: Axis, size: svgBase.Size): void;
    /**
     * Calculate label for the axis.
     * @private
     */
    calculateVisibleLabels(axis: Axis): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the category axis.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/date-time-axis.d.ts
/**
 * `DateTime` module is used to render datetime axis.
 */
export  class DateTime extends NiceInterval {
    min: number;
    max: number;
    /**
     * Constructor for the dateTime module.
     * @private
     */
    constructor(chart?: Chart);
    /**
     * The function to calculate the range and labels for the axis.
     * @return {void}
     */
    calculateRangeAndInterval(size: svgBase.Size, axis: Axis): void;
    /**
     * Actual Range for the axis.
     * @private
     */
    getActualRange(axis: Axis, size: svgBase.Size): void;
    /**
     * Apply padding for the range.
     * @private
     */
    applyRangePadding(axis: Axis, size: svgBase.Size): void;
    private getYear;
    private getMonth;
    private getDay;
    private getHour;
    /**
     * Calculate visible range for axis.
     * @private
     */
    protected calculateVisibleRange(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculate visible labels for the axis.
     * @param axis
     * @param chart
     * @private
     */
    calculateVisibleLabels(axis: Axis, chart: Chart | RangeNavigator): void;
    /** @private */
    increaseDateTimeInterval(axis: Axis, value: number, interval: number): Date;
    private alignRangeStart;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the category axis.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/date-time-category-axis.d.ts
/**
 * Category module is used to render category axis.
 */
export  class DateTimeCategory extends Category {
    private axisSize;
    /**
     * Constructor for the category module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * The function to calculate the range and labels for the axis.
     * @return {void}
     * @private
     */
    calculateRangeAndInterval(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculate label for the axis.
     * @private
     */
    calculateVisibleLabels(axis: Axis): void;
    /**
     * To get the Indexed axis label text with axis format for DateTimeCategory axis
     * @param value
     * @param format
     */
    getIndexedAxisLabel(value: string, format: Function): string;
    /**
     * get same interval
     */
    private sameInterval;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the category axis.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/double-axis.d.ts
/**
 * Numeric module is used to render numeric axis.
 */
export  class Double {
    /** @private */
    chart: Chart;
    /** @private */
    min: Object;
    /** @private */
    max: Object;
    private isDrag;
    private interval;
    private paddingInterval;
    /**
     * Constructor for the dateTime module.
     * @private
     */
    constructor(chart?: Chart);
    /**
     * Numeric Nice Interval for the axis.
     * @private
     */
    protected calculateNumericNiceInterval(axis: Axis, delta: number, size: svgBase.Size): number;
    /**
     * Actual Range for the axis.
     * @private
     */
    getActualRange(axis: Axis, size: svgBase.Size): void;
    /**
     * Range for the axis.
     * @private
     */
    initializeDoubleRange(axis: Axis): void;
    /**
     * The function to calculate the range and labels for the axis.
     * @return {void}
     * @private
     */
    calculateRangeAndInterval(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculate Range for the axis.
     * @private
     */
    protected calculateRange(axis: Axis, size: svgBase.Size): void;
    private yAxisRange;
    private findMinMax;
    /**
     * Apply padding for the range.
     * @private
     */
    applyRangePadding(axis: Axis, size: svgBase.Size): void;
    updateActualRange(axis: Axis, minimum: number, maximum: number, interval: number): void;
    private findAdditional;
    private findNormal;
    /**
     * Calculate visible range for axis.
     * @private
     */
    protected calculateVisibleRange(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculate label for the axis.
     * @private
     */
    calculateVisibleLabels(axis: Axis, chart: Chart | RangeNavigator): void;
    /**
     * Format of the axis label.
     * @private
     */
    protected getFormat(axis: Axis): string;
    /**
     * Formatted the axis label.
     * @private
     */
    formatValue(axis: Axis, isCustom: boolean, format: string, tempInterval: number): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/logarithmic-axis.d.ts
/**
 * `Logarithmic` module is used to render log axis.
 */
export  class Logarithmic extends Double {
    /**
     * Constructor for the logerithmic module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * The method to calculate the range and labels for the axis.
     * @return {void}
     */
    calculateRangeAndInterval(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculates actual range for the axis.
     * @private
     */
    getActualRange(axis: Axis, size: svgBase.Size): void;
    /**
     * Calculates visible range for the axis.
     * @private
     */
    protected calculateVisibleRange(size: svgBase.Size, axis: Axis): void;
    /**
     * Calculates log iInteval for the axis.
     * @private
     */
    protected calculateLogNiceInterval(delta: number, size: svgBase.Size, axis: Axis): number;
    /**
     * Calculates labels for the axis.
     * @private
     */
    calculateVisibleLabels(axis: Axis, chart: Chart | RangeNavigator): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the category axis.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/multi-level-labels.d.ts
/**
 * MultiLevel Labels src
 */
/**
 * `MultiLevelLabel` module is used to render the multi level label in chart.
 */
export  class MultiLevelLabel {
    /** @private */
    chart: Chart;
    /** @private */
    xAxisPrevHeight: number[];
    /** @private */
    xAxisMultiLabelHeight: number[];
    /** @private */
    yAxisPrevHeight: number[];
    /** @private */
    yAxisMultiLabelHeight: number[];
    /** @private */
    multiElements: Element;
    /** @private */
    labelElement: Element;
    /**
     * Constructor for the logerithmic module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * Binding events for multi level module.
     */
    private addEventListener;
    /**
     * Finds multilevel label height
     * @return {void}
     */
    getMultilevelLabelsHeight(axis: Axis): void;
    /**
     * render x axis multi level labels
     * @private
     * @return {void}
     */
    renderXAxisMultiLevelLabels(axis: Axis, index: number, parent: Element, axisRect: svgBase.Rect): void;
    /**
     * render x axis multi level labels border
     * @private
     * @return {void}
     */
    private renderXAxisLabelBorder;
    /**
     * render y axis multi level labels
     * @private
     * @return {void}
     */
    renderYAxisMultiLevelLabels(axis: Axis, index: number, parent: Element, rect: svgBase.Rect): void;
    /**
     * render y axis multi level labels border
     * @private
     * @return {void}
     */
    private renderYAxisLabelBorder;
    /**
     * create cliprect
     * @return {void}
     * @private
     */
    createClipRect(x: number, y: number, height: number, width: number, clipId: string, axisId: string): void;
    /**
     * create borer element
     * @return {void}
     * @private
     */
    createBorderElement(borderIndex: number, axisIndex: number, axis: Axis, path: string, pointIndex?: number): void;
    /**
     * Triggers the event.
     * @return {void}
     * @private
     */
    triggerMultiLabelRender(axis: Axis, text: string, textStyle: FontModel, textAlignment: Alignment, customAttributes: object): IAxisMultiLabelRenderEventArgs;
    /**
     * Triggers the event.
     * @return {void}
     * @private
     */
    MultiLevelLabelClick(labelIndex: string, axisIndex: number): IMultiLevelLabelClickEventArgs;
    /**
     * To click the multi level label
     * @return {void}
     * @private
     */
    click(event: Event): void;
    /**
     * To get the module name for `MultiLevelLabel`.
     * @private
     */
    getModuleName(): string;
    /**
     * To destroy the `MultiLevelLabel` module.
     * @private
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/polar-radar-panel.d.ts
export  class PolarRadarPanel extends LineBase {
    private initialClipRect;
    private htmlObject;
    private element;
    private centerX;
    private centerY;
    private startAngle;
    /** @private */
    seriesClipRect: svgBase.Rect;
    /**
     * Measure the polar radar axis size.
     * @return {void}
     * @private
     */
    measureAxis(rect: svgBase.Rect): void;
    private measureRowAxis;
    private measureColumnAxis;
    /**
     * Measure the column and row in chart.
     * @return {void}
     * @private
     */
    measureDefinition(definition: Row | Column, chart: Chart, size: svgBase.Size, clipRect: svgBase.Rect): void;
    /**
     * Measure the axis.
     * @return {void}
     * @private
     */
    private calculateAxisSize;
    /**
     * Measure the axis.
     * @return {void}
     * @private
     */
    measure(): void;
    /**
     * Measure the row size.
     * @return {void}
     */
    private calculateRowSize;
    /**
     * Measure the row size.
     * @return {void}
     */
    private calculateColumnSize;
    /**
     * To render the axis element.
     * @return {void}
     * @private
     */
    renderAxes(): Element;
    private drawYAxisLine;
    drawYAxisLabels(axis: Axis, index: number): void;
    private drawYAxisGridLine;
    private drawXAxisGridLine;
    private drawAxisMinorLine;
    /**
     * To render the axis label.
     * @return {void}
     * @private
     */
    drawXAxisLabels(axis: Axis, index: number): void;
    private renderTickLine;
    private renderGridLine;
}
//node_modules/@syncfusion/ej2-charts/src/chart/axis/strip-line.d.ts
/**
 * `StripLine` module is used to render the stripLine in chart.
 */
export  class StripLine {
    /**
     * Finding x, y, width and height of the strip line
     * @param axis
     * @param strip line
     * @param seriesClipRect
     * @param startValue
     * @param segmentAxis
     */
    private measureStripLine;
    /**
     * To get from to value from start, end, size, start from axis
     * @param start
     * @param end
     * @param size
     * @param startFromAxis
     * @param axis
     * @param strip line
     */
    private getFromTovalue;
    /**
     * Finding end value of the strip line
     * @param to
     * @param from
     * @param size
     * @param axis
     * @param end
     * @param strip line
     */
    private getToValue;
    /**
     * To check the strip line values within range
     * @param value
     * @param axis
     */
    private findValue;
    /**
     * To render strip lines based start and end.
     * @private
     * @param chart
     * @param position
     * @param axes
     */
    renderStripLine(chart: Chart, position: ZIndex, axes: Axis[]): void;
    /**
     * To draw the single line strip line
     * @param strip line
     * @param rect
     * @param id
     * @param parent
     * @param chart
     * @param axis
     */
    private renderPath;
    /**
     * To draw the rectangle
     * @param strip line
     * @param rect
     * @param id
     * @param parent
     * @param chart
     */
    private renderRectangle;
    /**
     * To create the text on strip line
     * @param strip line
     * @param rect
     * @param id
     * @param parent
     * @param chart
     * @param axis
     */
    private renderText;
    private invertAlignment;
    /**
     * To find the next value of the recurrence strip line
     * @param axis
     * @param stripline
     * @param startValue
     */
    private getStartValue;
    /**
     * Finding segment axis for segmented strip line
     * @param axes
     * @param axis
     * @param strip line
     */
    private getSegmentAxis;
    /**
     * To render strip line on chart
     * @param axis
     * @param stripline
     * @param seriesClipRect
     * @param id
     * @param striplineGroup
     * @param chart
     * @param startValue
     * @param segmentAxis
     * @param count
     */
    private renderStripLineElement;
    /**
     * To find the factor of the text
     * @param anchor
     */
    private factor;
    /**
     * To find the start value of the text
     * @param xy
     * @param size
     * @param textAlignment
     */
    private getTextStart;
    /**
     * To get the module name for `StripLine`.
     * @private
     */
    getModuleName(): string;
    /**
     * To destroy the `StripLine` module.
     * @private
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/chart-model.d.ts
/**
 * Interface for a class CrosshairSettings
 */
export interface CrosshairSettingsModel {
    /**
     * If set to true, crosshair line becomes visible.
     * @default false
     */
    enable?: boolean;
    /**
     * DashArray for crosshair.
     * @default ''
     */
    dashArray?: string;
    /**
     * Options to customize the crosshair line.
     */
    line?: BorderModel;
    /**
     * Specifies the line type. Horizontal mode enables the horizontal line and Vertical mode enables the vertical line. They are,
     * * None: Hides both vertical and horizontal crosshair lines.
     * * Both: Shows both vertical and horizontal crosshair lines.
     * * Vertical: Shows the vertical line.
     * * Horizontal: Shows the horizontal line.
     * @default Both
     */
    lineType?: LineType;
}
/**
 * Interface for a class ZoomSettings
 */
export interface ZoomSettingsModel {
    /**
     * If set to true, chart can be zoomed by a rectangular selecting region on the plot area.
     * @default false
     */
    enableSelectionZooming?: boolean;
    /**
     * If to true, chart can be pinched to zoom in / zoom out.
     * @default false
     */
    enablePinchZooming?: boolean;
    /**
     * If set to true, chart can be zoomed by using mouse wheel.
     * @default false
     */
    enableMouseWheelZooming?: boolean;
    /**
     * If set to true, zooming will be performed on mouse up. It requires `enableSelectionZooming` to be true.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *    zoomSettings: {
     *      enableSelectionZooming: true,
     *      enableDeferredZooming: false
     *    }
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default true
     */
    enableDeferredZooming?: boolean;
    /**
     * Specifies whether to allow zooming vertically or horizontally or in both ways. They are,
     * * x,y: Chart can be zoomed both vertically and horizontally.
     * * x: Chart can be zoomed horizontally.
     * * y: Chart can be zoomed  vertically.
     *  It requires `enableSelectionZooming` to be true.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *    zoomSettings: {
     *      enableSelectionZooming: true,
     *      mode: 'XY'
     *    }
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 'XY'
     */
    mode?: ZoomMode;
    /**
     * Specifies the toolkit options for the zooming as follows:
     * * Zoom
     * * ZoomIn
     * * ZoomOut
     * * Pan
     * * Reset
     * @default '["Zoom", "ZoomIn", "ZoomOut", "Pan", "Reset"]'
     */
    toolbarItems?: ToolbarItems[];
    /**
     * Specifies whether chart needs to be panned by default.
     * @default false.
     */
    enablePan?: boolean;
    /**
     * Specifies whether axis needs to have scrollbar.
     * @default false.
     */
    enableScrollbar?: boolean;
}
/**
 * Interface for a class Chart
 */
export interface ChartModel extends base.ComponentModel{
    /**
     * The width of the chart as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, chart renders to the full width of its parent element.
     * @default null
     */
    width?: string;
    /**
     * The height of the chart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, chart renders to the full height of its parent element.
     * @default null
     */
    height?: string;
    /**
     * Title of the chart
     * @default ''
     */
    title?: string;
    /**
     * Specifies the DataSource for the chart. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let chart$: Chart = new Chart({
     * ...
     *  dataSource:dataManager,
     *   series: [{
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default ''
     */
    dataSource?: Object | data.DataManager;
    /**
     * Options for customizing the title of the Chart.
     */
    titleStyle?: FontModel;
    /**
     * SubTitle of the chart
     * @default ''
     */
    subTitle?: string;
    /**
     * Options for customizing the Subtitle of the Chart.
     */
    subTitleStyle?: FontModel;
    /**
     *  Options to customize left, right, top and bottom margins of the chart.
     */
    margin?: MarginModel;
    /**
     * Options for customizing the color and width of the chart border.
     */
    border?: BorderModel;
    /**
     * The background color of the chart that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    background?: string;
    /**
     * Options for configuring the border and background of the chart area.
     */
    chartArea?: ChartAreaModel;
    /**
     * Options to configure the horizontal axis.
     */
    primaryXAxis?: AxisModel;
    /**
     * Options to configure the vertical axis.
     */
    primaryYAxis?: AxisModel;
    /**
     * Options to split Chart into multiple plotting areas horizontally.
     * Each object in the collection represents a plotting area in the Chart.
     */
    rows?: RowModel[];
    /**
     * Options to split chart into multiple plotting areas vertically.
     * Each object in the collection represents a plotting area in the chart.
     */
    columns?: ColumnModel[];
    /**
     * Secondary axis collection for the chart.
     */
    axes?: AxisModel[];
    /**
     * The configuration for series in the chart.
     */
    series?: SeriesModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations?: ChartAnnotationSettingsModel[];
    /**
     * Palette for the chart series.
     * @default []
     */
    palettes?: string[];
    /**
     * Specifies the theme for the chart.
     * @default 'Material'
     */
    theme?: ChartTheme;
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip?: TooltipSettingsModel;
    /**
     * Options for customizing the crosshair of the chart.
     */
    crosshair?: CrosshairSettingsModel;
    /**
     * Options for customizing the legend of the chart.
     */
    legendSettings?: LegendSettingsModel;
    /**
     * Options to enable the zooming feature in the chart.
     */
    zoomSettings?: ZoomSettingsModel;
    /**
     * Specifies whether series or data point has to be selected. They are,
     * * none: Disables the selection.
     * * series: selects a series.
     * * point: selects a point.
     * * cluster: selects a cluster of point
     * * dragXY: selects points by dragging with respect to both horizontal and vertical axes
     * * dragX: selects points by dragging with respect to horizontal axis.
     * * dragY: selects points by dragging with respect to vertical axis.
     * * lasso: selects points by dragging with respect to free form.
     * @default None
     */
    selectionMode?: SelectionMode;
    /**
     * If set true, enables the multi selection in chart. It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * @default false
     */
    isMultiSelect?: boolean;
    /**
     * If set true, enables the multi drag selection in chart. It requires `selectionMode` to be `Dragx` | `DragY` | or `DragXY`.
     * @default false
     */
    allowMultiSelection?: boolean;
    /**
     * To enable11 export feature in chart.
     * @default true
     */
    enableExport?: boolean;
    /**
     * Specifies the point indexes to be selected while loading a chart.
     * It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default []
     */
    selectedDataIndexes?: IndexesModel[];
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator?: boolean;
    /**
     * It specifies whether the chart should be render in transposed manner or not.
     * @default false
     */
    isTransposed?: boolean;
    /**
      * It specifies whether the chart should be rendered in canvas mode
      * @default false
      */
    enableCanvas?: boolean;
    /**
     * Defines the collection of technical indicators, that are used in financial markets
     */
    indicators?: TechnicalIndicatorModel[];
    /**
     * If set true, Animation process will be executed.
     * @default true
     */
    enableAnimation?: boolean;
    /**
     * Description for chart.
     * @default null
     */
    description?: string;
    /**
     * TabIndex value for the chart.
     * @default 1
     */
    tabIndex?: number;
    /**
     * To enable the side by side placing the points for column type series.
     * @default true
     */
    enableSideBySidePlacement?: boolean;
    /**
     * Triggers after resizing of chart
     * @event
     * @blazorProperty 'Resized'
     */
    resized?: base.EmitType<IResizeEventArgs>;
    /**
     * Triggers before the annotation gets rendered.
     * @event
     * @deprecated
     */
    annotationRender?: base.EmitType<IAnnotationRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint?: base.EmitType<IPrintEventArgs>;
    /**
     * Triggers after chart load.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<ILoadedEventArgs>;
    /**
     * Triggers before chart load.
     * @event
     * @deprecated
     */
    load?: base.EmitType<ILoadedEventArgs>;
    /**
     * Triggers after animation is completed for the series.
     * @event
     * @blazorProperty 'OnAnimationComplete'
     */
    animationComplete?: base.EmitType<IAnimationCompleteEventArgs>;
    /**
     * Triggers before the legend is rendered.
     * @event
     * @deprecated
     */
    legendRender?: base.EmitType<ILegendRenderEventArgs>;
    /**
     * Triggers before the data label for series is rendered.
     * @event
     * @deprecated
     */
    textRender?: base.EmitType<ITextRenderEventArgs>;
    /**
     * Triggers before each points for the series is rendered.
     * @event
     * @deprecated
     */
    pointRender?: base.EmitType<IPointRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    seriesRender?: base.EmitType<ISeriesRenderEventArgs>;
    /**
     * Triggers before each axis label is rendered.
     * @event
     * @deprecated
     */
    axisLabelRender?: base.EmitType<IAxisLabelRenderEventArgs>;
    /**
     * Triggers before each axis range is rendered.
     * @event
     * @deprecated
     */
    axisRangeCalculated?: base.EmitType<IAxisRangeCalculatedEventArgs>;
    /**
     * Triggers before each axis multi label is rendered.
     * @event
     * @deprecated
     */
    axisMultiLabelRender?: base.EmitType<IAxisMultiLabelRenderEventArgs>;
    /**
     * Triggers after click on legend
     * @event
     */
    legendClick?: base.EmitType<ILegendClickEventArgs>;
    /**
     * Triggers after click on multiLevelLabelClick
     * @event
     */
    multiLevelLabelClick?: base.EmitType<IMultiLevelLabelClickEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     */
    tooltipRender?: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers on hovering the chart.
     * @event
     * @blazorProperty 'OnChartMouseMove'
     */
    chartMouseMove?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the chart.
     * @event
     * @blazorProperty 'OnChartMouseClick'
     */
    chartMouseClick?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick?: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove?: base.EmitType<IPointEventArgs>;
    /**
     * Triggers when cursor leaves the chart.
     * @event
     * @blazorProperty 'OnChartMouseLeave'
     */
    chartMouseLeave?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnChartMouseDown'
     */
    chartMouseDown?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnChartMouseUp'
     */
    chartMouseUp?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers after the drag selection is completed.
     * @event
     * @blazorProperty 'OnDragComplete'
     */
    dragComplete?: base.EmitType<IDragCompleteEventArgs>;
    /**
     * Triggers after the selection is completed.
     * @event
     * @blazorProperty 'OnSelectionComplete'
     */
    selectionComplete?: base.EmitType<ISelectionCompleteEventArgs>;
    /**
     * Triggers after the zoom selection is completed.
     * @event
     * @deprecated
     */
    zoomComplete?: base.EmitType<IZoomCompleteEventArgs>;
    /**
     * Triggers when start the scroll.
     * @event
     * @blazorProperty 'OnScrollStart'
     */
    scrollStart?: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers after the scroll end.
     * @event
     * @blazorProperty 'OnScrollEnd'
     */
    scrollEnd?: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers when change the scroll.
     * @event
     * @blazorProperty 'ScrollChanged'
     */
    scrollChanged?: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers when the point drag start.
     * @event
     */
    dragStart?: base.EmitType<IDataEditingEventArgs>;
    /**
     * Triggers when the point is dragging.
     * @event
     */
    drag?: base.EmitType<IDataEditingEventArgs>;
    /**
     * Triggers when the point drag end.
     * @event
     */
    dragEnd?: base.EmitType<IDataEditingEventArgs>;
    /**
     * Defines the currencyCode format of the chart
     * @private
     * @aspType string
     */
    currencyCode?: string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/chart.d.ts
/**
 * Configures the crosshair in the chart.
 */
export  class CrosshairSettings extends base.ChildProperty<CrosshairSettings> {
    /**
     * If set to true, crosshair line becomes visible.
     * @default false
     */
    enable: boolean;
    /**
     * DashArray for crosshair.
     * @default ''
     */
    dashArray: string;
    /**
     * Options to customize the crosshair line.
     */
    line: BorderModel;
    /**
     * Specifies the line type. Horizontal mode enables the horizontal line and Vertical mode enables the vertical line. They are,
     * * None: Hides both vertical and horizontal crosshair lines.
     * * Both: Shows both vertical and horizontal crosshair lines.
     * * Vertical: Shows the vertical line.
     * * Horizontal: Shows the horizontal line.
     * @default Both
     */
    lineType: LineType;
}
/**
 * Configures the zooming behavior for the chart.
 */
export  class ZoomSettings extends base.ChildProperty<ZoomSettings> {
    /**
     * If set to true, chart can be zoomed by a rectangular selecting region on the plot area.
     * @default false
     */
    enableSelectionZooming: boolean;
    /**
     * If to true, chart can be pinched to zoom in / zoom out.
     * @default false
     */
    enablePinchZooming: boolean;
    /**
     * If set to true, chart can be zoomed by using mouse wheel.
     * @default false
     */
    enableMouseWheelZooming: boolean;
    /**
     * If set to true, zooming will be performed on mouse up. It requires `enableSelectionZooming` to be true.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *    zoomSettings: {
     *      enableSelectionZooming: true,
     *      enableDeferredZooming: false
     *    }
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default true
     */
    enableDeferredZooming: boolean;
    /**
     * Specifies whether to allow zooming vertically or horizontally or in both ways. They are,
     * * x,y: Chart can be zoomed both vertically and horizontally.
     * * x: Chart can be zoomed horizontally.
     * * y: Chart can be zoomed  vertically.
     *  It requires `enableSelectionZooming` to be true.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *    zoomSettings: {
     *      enableSelectionZooming: true,
     *      mode: 'XY'
     *    }
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 'XY'
     */
    mode: ZoomMode;
    /**
     * Specifies the toolkit options for the zooming as follows:
     * * Zoom
     * * ZoomIn
     * * ZoomOut
     * * Pan
     * * Reset
     * @default '["Zoom", "ZoomIn", "ZoomOut", "Pan", "Reset"]'
     */
    toolbarItems: ToolbarItems[];
    /**
     * Specifies whether chart needs to be panned by default.
     * @default false.
     */
    enablePan: boolean;
    /**
     * Specifies whether axis needs to have scrollbar.
     * @default false.
     */
    enableScrollbar: boolean;
}
/**
 * Represents the Chart control.
 * ```html
 * <div id="chart"/>
 * <script>
 *   var chartObj = new Chart({ isResponsive : true });
 *   chartObj.appendTo("#chart");
 * </script>
 * ```
 * @public
 */
export  class Chart extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * `lineSeriesModule` is used to add line series to the chart.
     */
    lineSeriesModule: LineSeries;
    /**
     * `multiColoredLineSeriesModule` is used to add multi colored line series to the chart.
     */
    multiColoredLineSeriesModule: MultiColoredLineSeries;
    /**
     * `multiColoredAreaSeriesModule` is used to add multi colored area series to the chart.
     */
    multiColoredAreaSeriesModule: MultiColoredAreaSeries;
    /**
     * `columnSeriesModule` is used to add column series to the chart.
     */
    columnSeriesModule: ColumnSeries;
    /**
     * `ParetoSeriesModule` is used to add pareto series in the chart.
     */
    paretoSeriesModule: ParetoSeries;
    /**
     * `areaSeriesModule` is used to add area series in the chart.
     */
    areaSeriesModule: AreaSeries;
    /**
     * `barSeriesModule` is used to add bar series to the chart.
     */
    barSeriesModule: BarSeries;
    /**
     * `stackingColumnSeriesModule` is used to add stacking column series in the chart.
     */
    stackingColumnSeriesModule: StackingColumnSeries;
    /**
     * `stackingAreaSeriesModule` is used to add stacking area series to the chart.
     */
    stackingAreaSeriesModule: StackingAreaSeries;
    /**
     * `stackingLineSeriesModule` is used to add stacking line series to the chart.
     */
    stackingLineSeriesModule: StackingLineSeries;
    /**
     * 'CandleSeriesModule' is used to add candle series in the chart.
     */
    candleSeriesModule: CandleSeries;
    /**
     * `stackingBarSeriesModule` is used to add stacking bar series to the chart.
     */
    stackingBarSeriesModule: StackingBarSeries;
    /**
     * `stepLineSeriesModule` is used to add step line series to the chart.
     */
    stepLineSeriesModule: StepLineSeries;
    /**
     * `stepAreaSeriesModule` is used to add step area series to the chart.
     */
    stepAreaSeriesModule: StepAreaSeries;
    /**
     * `polarSeriesModule` is used to add polar series in the chart.
     */
    polarSeriesModule: PolarSeries;
    /**
     *  `radarSeriesModule` is used to add radar series in the chart.
     */
    radarSeriesModule: RadarSeries;
    /**
     * `splineSeriesModule` is used to add spline series to the chart.
     */
    splineSeriesModule: SplineSeries;
    /**
     * `splineAreaSeriesModule` is used to add spline area series to the chart.
     */
    splineAreaSeriesModule: SplineAreaSeries;
    /**
     * `scatterSeriesModule` is used to add scatter series to the chart.
     */
    scatterSeriesModule: ScatterSeries;
    /**
     * `boxAndWhiskerSeriesModule` is used to add line series to the chart.
     */
    boxAndWhiskerSeriesModule: BoxAndWhiskerSeries;
    /**
     * `rangeColumnSeriesModule` is used to add rangeColumn series to the chart.
     */
    rangeColumnSeriesModule: RangeColumnSeries;
    /**
     * histogramSeriesModule is used to add histogram series in chart
     */
    histogramSeriesModule: HistogramSeries;
    /**
     * hiloSeriesModule is used to add hilo series in chart
     */
    hiloSeriesModule: HiloSeries;
    /**
     * hiloOpenCloseSeriesModule is used to add hilo series in chart
     */
    hiloOpenCloseSeriesModule: HiloOpenCloseSeries;
    /**
     * `waterfallSeries` is used to add waterfall series in chart.
     */
    waterfallSeriesModule: WaterfallSeries;
    /**
     * `bubbleSeries` is used to add bubble series in chart.
     */
    bubbleSeriesModule: BubbleSeries;
    /**
     * `rangeAreaSeriesModule` is used to add rangeArea series in chart.
     */
    rangeAreaSeriesModule: RangeAreaSeries;
    /**
     * `tooltipModule` is used to manipulate and add tooltip to the series.
     */
    tooltipModule: Tooltip;
    /**
     * `crosshairModule` is used to manipulate and add crosshair to the chart.
     */
    crosshairModule: Crosshair;
    /**
     * `errorBarModule` is used to manipulate and add errorBar for series.
     */
    errorBarModule: ErrorBar;
    /**
     * `dataLabelModule` is used to manipulate and add data label to the series.
     */
    dataLabelModule: DataLabel;
    /**
     * `datetimeModule` is used to manipulate and add dateTime axis to the chart.
     */
    dateTimeModule: DateTime;
    /**
     * `categoryModule` is used to manipulate and add category axis to the chart.
     */
    categoryModule: Category;
    /**
     * `dateTimeCategoryModule` is used to manipulate date time and category axis
     */
    dateTimeCategoryModule: DateTimeCategory;
    /**
     * `logarithmicModule` is used to manipulate and add log axis to the chart.
     */
    logarithmicModule: Logarithmic;
    /**
     * `legendModule` is used to manipulate and add legend to the chart.
     */
    legendModule: Legend;
    /**
     * `zoomModule` is used to manipulate and add zooming to the chart.
     */
    zoomModule: Zoom;
    /**
     * `dataEditingModule` is used to drag and drop of the point.
     */
    dataEditingModule: DataEditing;
    /**
     * `selectionModule` is used to manipulate and add selection to the chart.
     */
    selectionModule: Selection;
    /**
     * `annotationModule` is used to manipulate and add annotation in chart.
     */
    annotationModule: ChartAnnotation;
    /**
     * `stripLineModule` is used to manipulate and add stripLine in chart.
     */
    stripLineModule: StripLine;
    /**
     * `multiLevelLabelModule` is used to manipulate and add multiLevelLabel in chart.
     */
    multiLevelLabelModule: MultiLevelLabel;
    /**
     * 'TrendlineModule' is used to predict the market trend using trendlines
     */
    trendLineModule: Trendlines;
    /**
     * `sMAIndicatorModule` is used to predict the market trend using SMA approach
     */
    sMAIndicatorModule: SmaIndicator;
    /**
     * `eMAIndicatorModule` is used to predict the market trend using EMA approach
     */
    eMAIndicatorModule: EmaIndicator;
    /**
     * `tMAIndicatorModule` is used to predict the market trend using TMA approach
     */
    tMAIndicatorModule: TmaIndicator;
    /**
     * `accumulationDistributionIndicatorModule` is used to predict the market trend using Accumulation Distribution approach
     */
    accumulationDistributionIndicatorModule: AccumulationDistributionIndicator;
    /**
     * `atrIndicatorModule` is used to predict the market trend using ATR approach
     */
    atrIndicatorModule: AtrIndicator;
    /**
     * `rSIIndicatorModule` is used to predict the market trend using RSI approach
     */
    rsiIndicatorModule: RsiIndicator;
    /**
     * `macdIndicatorModule` is used to predict the market trend using Macd approach
     */
    macdIndicatorModule: MacdIndicator;
    /**
     * `stochasticIndicatorModule` is used to predict the market trend using Stochastic approach
     */
    stochasticIndicatorModule: StochasticIndicator;
    /**
     * `momentumIndicatorModule` is used to predict the market trend using Momentum approach
     */
    momentumIndicatorModule: MomentumIndicator;
    /**
     * `bollingerBandsModule` is used to predict the market trend using Bollinger approach
     */
    bollingerBandsModule: BollingerBands;
    /**
     * ScrollBar Module is used to render scrollbar in chart while zooming.
     */
    scrollBarModule: ScrollBar;
    /**
     * Export Module1 is used to export chart.
     */
    exportModule: Export;
    /**
     * The width of the chart as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, chart renders to the full width of its parent element.
     * @default null
     */
    width: string;
    /**
     * The height of the chart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, chart renders to the full height of its parent element.
     * @default null
     */
    height: string;
    /**
     * Title of the chart
     * @default ''
     */
    title: string;
    /**
     * Specifies the DataSource for the chart. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let chart$: Chart = new Chart({
     * ...
     *  dataSource:dataManager,
     *   series: [{
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     * Options for customizing the title of the Chart.
     */
    titleStyle: FontModel;
    /**
     * SubTitle of the chart
     * @default ''
     */
    subTitle: string;
    /**
     * Options for customizing the Subtitle of the Chart.
     */
    subTitleStyle: FontModel;
    /**
     *  Options to customize left, right, top and bottom margins of the chart.
     */
    margin: MarginModel;
    /**
     * Options for customizing the color and width of the chart border.
     */
    border: BorderModel;
    /**
     * The background color of the chart that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    background: string;
    /**
     * Options for configuring the border and background of the chart area.
     */
    chartArea: ChartAreaModel;
    /**
     * Options to configure the horizontal axis.
     */
    primaryXAxis: AxisModel;
    /**
     * Options to configure the vertical axis.
     */
    primaryYAxis: AxisModel;
    /**
     * Options to split Chart into multiple plotting areas horizontally.
     * Each object in the collection represents a plotting area in the Chart.
     */
    rows: RowModel[];
    /**
     * Options to split chart into multiple plotting areas vertically.
     * Each object in the collection represents a plotting area in the chart.
     */
    columns: ColumnModel[];
    /**
     * Secondary axis collection for the chart.
     */
    axes: AxisModel[];
    /**
     * The configuration for series in the chart.
     */
    series: SeriesModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations: ChartAnnotationSettingsModel[];
    /**
     * Palette for the chart series.
     * @default []
     */
    palettes: string[];
    /**
     * Specifies the theme for the chart.
     * @default 'Material'
     */
    theme: ChartTheme;
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip: TooltipSettingsModel;
    /**
     * Options for customizing the crosshair of the chart.
     */
    crosshair: CrosshairSettingsModel;
    /**
     * Options for customizing the legend of the chart.
     */
    legendSettings: LegendSettingsModel;
    /**
     * Options to enable the zooming feature in the chart.
     */
    zoomSettings: ZoomSettingsModel;
    /**
     * Specifies whether series or data point has to be selected. They are,
     * * none: Disables the selection.
     * * series: selects a series.
     * * point: selects a point.
     * * cluster: selects a cluster of point
     * * dragXY: selects points by dragging with respect to both horizontal and vertical axes
     * * dragX: selects points by dragging with respect to horizontal axis.
     * * dragY: selects points by dragging with respect to vertical axis.
     * * lasso: selects points by dragging with respect to free form.
     * @default None
     */
    selectionMode: SelectionMode;
    /**
     * If set true, enables the multi selection in chart. It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * @default false
     */
    isMultiSelect: boolean;
    /**
     * If set true, enables the multi drag selection in chart. It requires `selectionMode` to be `Dragx` | `DragY` | or `DragXY`.
     * @default false
     */
    allowMultiSelection: boolean;
    /**
     * To enable111 export feature in chart.
     * @default true
     */
    enableExport: boolean;
    /**
     * Specifies the point indexes to be selected while loading a chart.
     * It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default []
     */
    selectedDataIndexes: IndexesModel[];
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator: boolean;
    /**
     * It specifies whether the chart should be render in transposed manner or not.
     * @default false
     */
    isTransposed: boolean;
    /**
     * It specifies whether the chart should be rendered in canvas mode
     * @default false
     */
    enableCanvas: boolean;
    /**
     * Defines the collection of technical indicators, that are used in financial markets
     */
    indicators: TechnicalIndicatorModel[];
    /**
     * If set true, Animation process will be executed.
     * @default true
     */
    enableAnimation: boolean;
    /**
     * Description for chart.
     * @default null
     */
    description: string;
    /**
     * TabIndex value for the chart.
     * @default 1
     */
    tabIndex: number;
    /**
     * To enable the side by side placing the points for column type series.
     * @default true
     */
    enableSideBySidePlacement: boolean;
    /**
     * Triggers after resizing of chart
     * @event
     * @blazorProperty 'Resized'
     */
    resized: base.EmitType<IResizeEventArgs>;
    /**
     * Triggers before the annotation gets rendered.
     * @event
     * @deprecated
     */
    annotationRender: base.EmitType<IAnnotationRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint: base.EmitType<IPrintEventArgs>;
    /**
     * Triggers after chart load.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<ILoadedEventArgs>;
    /**
     * Triggers before chart load.
     * @event
     * @deprecated
     */
    load: base.EmitType<ILoadedEventArgs>;
    /**
     * Triggers after animation is completed for the series.
     * @event
     * @blazorProperty 'OnAnimationComplete'
     */
    animationComplete: base.EmitType<IAnimationCompleteEventArgs>;
    /**
     * Triggers before the legend is rendered.
     * @event
     * @deprecated
     */
    legendRender: base.EmitType<ILegendRenderEventArgs>;
    /**
     * Triggers before the data label for series is rendered.
     * @event
     * @deprecated
     */
    textRender: base.EmitType<ITextRenderEventArgs>;
    /**
     * Triggers before each points for the series is rendered.
     * @event
     * @deprecated
     */
    pointRender: base.EmitType<IPointRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    seriesRender: base.EmitType<ISeriesRenderEventArgs>;
    /**
     * Triggers before each axis label is rendered.
     * @event
     * @deprecated
     */
    axisLabelRender: base.EmitType<IAxisLabelRenderEventArgs>;
    /**
     * Triggers before each axis range is rendered.
     * @event
     * @deprecated
     */
    axisRangeCalculated: base.EmitType<IAxisRangeCalculatedEventArgs>;
    /**
     * Triggers before each axis multi label is rendered.
     * @event
     * @deprecated
     */
    axisMultiLabelRender: base.EmitType<IAxisMultiLabelRenderEventArgs>;
    /**
     * Triggers after click on legend
     * @event
     */
    legendClick: base.EmitType<ILegendClickEventArgs>;
    /**
     * Triggers after click on multiLevelLabelClick
     * @event
     */
    multiLevelLabelClick: base.EmitType<IMultiLevelLabelClickEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     */
    tooltipRender: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers on hovering the chart.
     * @event
     * @blazorProperty 'OnChartMouseMove'
     */
    chartMouseMove: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the chart.
     * @event
     * @blazorProperty 'OnChartMouseClick'
     */
    chartMouseClick: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove: base.EmitType<IPointEventArgs>;
    /**
     * Triggers when cursor leaves the chart.
     * @event
     * @blazorProperty 'OnChartMouseLeave'
     */
    chartMouseLeave: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnChartMouseDown'
     */
    chartMouseDown: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnChartMouseUp'
     */
    chartMouseUp: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers after the drag selection is completed.
     * @event
     * @blazorProperty 'OnDragComplete'
     */
    dragComplete: base.EmitType<IDragCompleteEventArgs>;
    /**
     * Triggers after the selection is completed.
     * @event
     * @blazorProperty 'OnSelectionComplete'
     */
    selectionComplete: base.EmitType<ISelectionCompleteEventArgs>;
    /**
     * Triggers after the zoom selection is completed.
     * @event
     * @deprecated
     */
    zoomComplete: base.EmitType<IZoomCompleteEventArgs>;
    /**
     * Triggers when start the scroll.
     * @event
     * @blazorProperty 'OnScrollStart'
     */
    scrollStart: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers after the scroll end.
     * @event
     * @blazorProperty 'OnScrollEnd'
     */
    scrollEnd: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers when change the scroll.
     * @event
     * @blazorProperty 'ScrollChanged'
     */
    scrollChanged: base.EmitType<IScrollEventArgs>;
    /**
     * Triggers when the point drag start.
     * @event
     */
    dragStart: base.EmitType<IDataEditingEventArgs>;
    /**
     * Triggers when the point is dragging.
     * @event
     */
    drag: base.EmitType<IDataEditingEventArgs>;
    /**
     * Triggers when the point drag end.
     * @event
     */
    dragEnd: base.EmitType<IDataEditingEventArgs>;
    /**
     * Defines the currencyCode format of the chart
     * @private
     * @aspType string
     */
    private currencyCode;
    private htmlObject;
    private isLegend;
    /** @private */
    stockChart: StockChart;
    /**
     * localization object
     * @private
     */
    localeObject: base.L10n;
    /**
     * It contains default values of localization values
     */
    private defaultLocalConstants;
    /**
     * Gets the current visible axis of the Chart.
     * @hidden
     */
    axisCollections: Axis[];
    /**
     * Gets the current visible series of the Chart.
     * @hidden
     */
    visibleSeries: Series[];
    /**
     * Render panel for chart.
     * @hidden
     */
    chartAxisLayoutPanel: CartesianAxisLayoutPanel | PolarRadarPanel;
    /**
     * Gets all the horizontal axis of the Chart.
     * @hidden
     */
    horizontalAxes: Axis[];
    /**
     * Gets all the vertical axis of the Chart.
     * @hidden
     */
    verticalAxes: Axis[];
    /**
     * Gets the inverted chart.
     * @hidden
     */
    requireInvertedAxis: boolean;
    /** @private */
    svgObject: Element;
    /** @private */
    isTouch: boolean;
    /** @private */
    renderer: svgBase.SvgRenderer | svgBase.CanvasRenderer;
    /** @private */
    svgRenderer: svgBase.SvgRenderer;
    /** @private */
    canvasRender: svgBase.CanvasRenderer;
    /** @private */
    initialClipRect: svgBase.Rect;
    /** @private */
    seriesElements: Element;
    /** @private */
    indicatorElements: Element;
    /** @private */
    trendLineElements: Element;
    /** @private */
    visibleSeriesCount: number;
    /** @private */
    intl: base.Internationalization;
    /** @private */
    dataLabelCollections: svgBase.Rect[];
    /** @private */
    dataLabelElements: Element;
    /** @private */
    mouseX: number;
    /** @private */
    mouseY: number;
    /** @private */
    animateSeries: boolean;
    /** @private */
    redraw: boolean;
    /** @public */
    animated: boolean;
    /** @public */
    duration: number;
    /** @private */
    availableSize: svgBase.Size;
    /** @private */
    delayRedraw: boolean;
    /** @private */
    isDoubleTap: boolean;
    /** @private */
    mouseDownX: number;
    /** @private */
    mouseDownY: number;
    /** @private */
    previousMouseMoveX: number;
    /** @private */
    previousMouseMoveY: number;
    /** @private */
    private threshold;
    /** @private */
    isChartDrag: boolean;
    /** @private */
    isPointMouseDown: boolean;
    /** @private */
    isScrolling: boolean;
    /** @private */
    dragY: number;
    private resizeTo;
    /** @private */
    disableTrackTooltip: boolean;
    /** @private */
    startMove: boolean;
    /** @private */
    yAxisElements: Element;
    /** @private */
    radius: number;
    /** @private */
    chartAreaType: string;
    /**
     * `markerModule` is used to manipulate and add marker to the series.
     * @private
     */
    markerRender: Marker;
    private titleCollection;
    private subTitleCollection;
    /** @private */
    themeStyle: IThemeStyle;
    /** @private */
    scrollElement: Element;
    /** @private */
    scrollSettingEnabled: boolean;
    private chartid;
    /** @private */
    svgId: string;
    /** @private */
    isBlazor: boolean;
    /**
     * Touch object to unwire the touch event from element
     */
    private touchObject;
    /** @private */
    resizeBound: any;
    /** @private */
    longPressBound: any;
    /**
     * Constructor for creating the widget
     * @hidden
     */
    constructor(options?: ChartModel, element?: string | HTMLElement);
    /**
     * To manage persist chart data
     */
    private mergePersistChartData;
    /**
     * Initialize the event handler.
     */
    protected preRender(): void;
    private initPrivateVariable;
    /**
     * To Initialize the control rendering.
     */
    protected render(): void;
    /**
     * Gets the localized label by locale keyword.
     * @param  {string} key
     * @return {string}
     */
    getLocalizedLabel(key: string): string;
    /**
     * Animate the series bounds.
     * @private
     */
    animate(duration?: number): void;
    /**
     * Refresh the chart bounds.
     * @private
     */
    refreshBound(): void;
    /**
     * To calcualte the stack values
     */
    private calculateStackValues;
    private removeSelection;
    private renderElements;
    /**
     * To render the legend
     * @private
     */
    renderAxes(): Element;
    /**
     * To render the legend
     */
    private renderLegend;
    /**
     * To set the left and top position for data label template for center aligned chart
     */
    private setSecondaryElementPosition;
    private initializeModuleElements;
    private hasTrendlines;
    private renderSeriesElements;
    /**
     * @private
     */
    renderSeries(): void;
    protected renderCanvasSeries(item: Series): void;
    private initializeIndicator;
    private initializeTrendLine;
    private appendElementsAfterSeries;
    private applyZoomkit;
    /**
     * Render annotation perform here
     * @param redraw
     * @private
     */
    private renderAnnotation;
    private performSelection;
    private processData;
    private initializeDataModule;
    private calculateBounds;
    /**
     * Handles the print method for chart control.
     */
    print(id?: string[] | string | Element): void;
    /**
     * Defines the trendline initialization
     */
    private initTrendLines;
    private calculateAreaType;
    /**
     * Calculate the visible axis
     * @private
     */
    private calculateVisibleAxis;
    private initAxis;
    private initTechnicalIndicators;
    /** @private */
    refreshTechnicalIndicator(series: SeriesBase): void;
    private calculateVisibleSeries;
    private renderTitle;
    private renderSubTitle;
    private renderBorder;
    /**
     * @private
     */
    renderAreaBorder(): void;
    /**
     * To add series for the chart
     * @param {SeriesModel[]} seriesCollection - Defines the series collection to be added in chart.
     * @return {void}.
     */
    addSeries(seriesCollection: SeriesModel[]): void;
    /**
     * To Remove series for the chart
     * @param index - Defines the series index to be remove in chart series
     * @return {void}
     */
    removeSeries(index: number): void;
    /**
     * To destroy the widget
     * @method destroy
     * @return {void}.
     * @member of Chart
     */
    destroy(): void;
    /**
     * Get component name
     */
    getModuleName(): string;
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
    /**
     * Method to create SVG element.
     */
    createChartSvg(): void;
    /**
     * Method to bind events for chart
     */
    private unWireEvents;
    private wireEvents;
    private chartRightClick;
    private setStyle;
    /**
     * Finds the orientation.
     * @return {boolean}
     * @private
     */
    isOrientation(): boolean;
    /**
     * Handles the long press on chart.
     * @return {boolean}
     * @private
     */
    longPress(e?: base.TapEventArgs): boolean;
    /**
     * To find mouse x, y for aligned chart element svg position
     */
    private setMouseXY;
    /**
     * Export method for the chart.
     */
    export(type: ExportType, fileName: string): void;
    /**
     * Handles the chart resize.
     * @return {boolean}
     * @private
     */
    chartResize(e: Event): boolean;
    /**
     * Handles the mouse move.
     * @return {boolean}
     * @private
     */
    mouseMove(e: PointerEvent): boolean;
    /**
     * Handles the mouse leave.
     * @return {boolean}
     * @private
     */
    mouseLeave(e: PointerEvent): boolean;
    /**
     * Handles the mouse leave on chart.
     * @return {boolean}
     * @private
     */
    chartOnMouseLeave(e: PointerEvent | TouchEvent): boolean;
    /**
     * Handles the mouse click on chart.
     * @return {boolean}
     * @private
     */
    chartOnMouseClick(e: PointerEvent | TouchEvent): boolean;
    private triggerPointEvent;
    /**
     * Handles the mouse move on chart.
     * @return {boolean}
     * @private
     */
    chartOnMouseMove(e: PointerEvent | TouchEvent): boolean;
    private titleTooltip;
    private axisTooltip;
    private findAxisLabel;
    /**
     * Handles the mouse down on chart.
     * @return {boolean}
     * @private
     */
    chartOnMouseDown(e: PointerEvent): boolean;
    /**
     * Handles the mouse up.
     * @return {boolean}
     * @private
     */
    mouseEnd(e: PointerEvent): boolean;
    /**
     * Handles the mouse up.
     * @return {boolean}
     * @private
     */
    chartOnMouseUp(e: PointerEvent | TouchEvent): boolean;
    /**
     * Method to set culture for chart
     */
    private setCulture;
    /**
     * Method to set the annotation content dynamically for chart.
     */
    setAnnotationValue(annotationIndex: number, content: string): void;
    /**
     * Method to set locale constants
     */
    private setLocaleConstants;
    /**
     * Theming for chart
     */
    private setTheme;
    /**
     * To provide the array of modules needed for control rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    private findAxisModule;
    private findIndicatorModules;
    private findTrendLineModules;
    private findStriplineVisibility;
    /**
     * To Remove the SVG.
     * @return {boolean}
     * @private
     */
    removeSvg(): void;
    private refreshDefinition;
    /**
     * Refresh the axis default value.
     * @return {boolean}
     * @private
     */
    refreshAxis(): void;
    private axisChange;
    /**
     * Get visible series by index
     */
    private getVisibleSeries;
    /**
     * Clear visible Axis labels
     */
    private clearVisibleAxisLabels;
    /**
     * Called internally if any of the property value changed.
     * @private
     */
    onPropertyChanged(newProp: ChartModel, oldProp: ChartModel): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/index.d.ts
/**
 * Chart component exported items
 */
//node_modules/@syncfusion/ej2-charts/src/chart/legend/legend.d.ts
/**
 * `Legend` module is used to render legend for the chart.
 */
export  class Legend extends BaseLegend {
    constructor(chart: Chart);
    /**
     * Binding events for legend module.
     */
    private addEventListener;
    /**
     * UnBinding events for legend module.
     */
    private removeEventListener;
    /**
     * To handle mosue move for legend module
     */
    private mouseMove;
    /**
     * To handle mosue end for legend module
     */
    private mouseEnd;
    /**
     * Get the legend options.
     * @return {void}
     * @private
     */
    getLegendOptions(visibleSeriesCollection: Series[], chart: Chart): void;
    /** @private */
    getLegendBounds(availableSize: svgBase.Size, legendBounds: svgBase.Rect, legend: LegendSettingsModel): void;
    /** @private */
    getRenderPoint(legendOption: LegendOptions, start: ChartLocation, textPadding: number, prevLegend: LegendOptions, rect: svgBase.Rect, count: number, firstLegend: number): void;
    /** @private */
    LegendClick(seriesIndex: number): void;
    private redrawSeriesElements;
    private refreshSeries;
    /**
     * To show the tooltip for the trimmed text in legend.
     * @return {void}
     */
    click(event: Event | PointerEvent): void;
    /**
     * To check click position is within legend bounds
     */
    protected checkWithinBounds(pageX: number, pageY: number): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the Legend.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/model/chart-base-model.d.ts
/**
 * Interface for a class ChartAnnotationSettings
 */
export interface ChartAnnotationSettingsModel {
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x?: string | Date | number;
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y?: string | number;
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content?: string;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as left side.
     * * Far - Align the annotation element as right side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment?: Alignment;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits?: Units;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region?: Regions;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment?: Position;
    /**
     * The name of horizontal axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    xAxisName?: string;
    /**
     * The name of vertical axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    yAxisName?: string;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description?: string;
}
/**
 * Interface for a class LabelBorder
 */
export interface LabelBorderModel {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color?: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width?: number;
    /**
     * Border type for labels
     * * Rectangle
     * * Without Top Border
     * * Without Top and BottomBorder
     * * Without Border
     * * Brace
     * * CurlyBrace
     * @default 'Rectangle'
     */
    type?: BorderType;
}
/**
 * Interface for a class MultiLevelCategories
 */
export interface MultiLevelCategoriesModel {
    /**
     * Start value of the multi level labels
     * @default null
     * @aspDefaultValueIgnore
     */
    start?: number | Date | string;
    /**
     * End value of the multi level labels
     * @default null
     * @aspDefaultValueIgnore
     */
    end?: number | Date | string;
    /**
     * multi level labels text.
     * @default ''
     */
    text?: string;
    /**
     * Maximum width of the text for multi level labels.
     * @default null
     * @aspDefaultValueIgnore
     */
    maximumTextWidth?: number;
    /**
     * multi level labels custom data.
     * @default null
     */
    customAttributes?: object;
    /**
     * Border type for labels
     * * Rectangle
     * * Without Top Border
     * * Without Top and BottomBorder
     * * Without Border
     * * Brace
     * * CurlyBrace
     * @default 'Rectangle'
     * @aspDefaultValueIgnore
     * @blazorDefaultValueIgnore
     */
    type?: BorderType;
}
/**
 * Interface for a class StripLineSettings
 */
export interface StripLineSettingsModel {
    /**
     * If set true, strip line for axis renders.
     * @default true
     */
    visible?: boolean;
    /**
     *  If set true, strip line get render from axis origin.
     *  @default false
     */
    startFromAxis?: boolean;
    /**
     * Start value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    start?: number | Date;
    /**
     * End value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    end?: number | Date;
    /**
     * Size of the strip line, when it starts from the origin.
     * @default null
     * @aspDefaultValueIgnore
     */
    size?: number;
    /**
     * Color of the strip line.
     * @default '#808080'
     */
    color?: string;
    /**
     * Dash Array of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    dashArray?: string;
    /**
     * Size type of the strip line
     * @default Auto
     */
    sizeType?: SizeType;
    /**
     * isRepeat value of the strip line.
     * @default false
     * @aspDefaultValueIgnore
     */
    isRepeat?: boolean;
    /**
     * repeatEvery value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatEvery?: number | Date;
    /**
     * repeatUntil value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatUntil?: number | Date;
    /**
     * isSegmented value of the strip line
     * @default false
     * @aspDefaultValueIgnore
     */
    isSegmented?: boolean;
    /**
     * segmentStart value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentStart?: number | Date;
    /**
     * segmentEnd value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentEnd?: number | Date;
    /**
     * segmentAxisName of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentAxisName?: string;
    /**
     * Border of the strip line.
     */
    border?: BorderModel;
    /**
     * Strip line text.
     * @default ''
     */
    text?: string;
    /**
     * The angle to which the strip line text gets rotated.
     * @default null
     * @aspDefaultValueIgnore
     */
    rotation?: number;
    /**
     * Defines the position of the strip line text horizontally. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    horizontalAlignment?: Anchor;
    /**
     * Defines the position of the strip line text vertically. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    verticalAlignment?: Anchor;
    /**
     * Options to customize the strip line text.
     */
    textStyle?: FontModel;
    /**
     * Specifies the order of the strip line. They are,
     * * Behind: Places the strip line behind the series elements.
     * * Over: Places the strip line over the series elements.
     * @default 'Behind'
     */
    zIndex?: ZIndex;
    /**
     * Strip line Opacity
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class MultiLevelLabels
 */
export interface MultiLevelLabelsModel {
    /**
     * Defines the position of the multi level labels. They are,
     * * Near: Places the multi level labels at Near.
     * * Center: Places the multi level labels at Center.
     * * Far: Places the multi level labels at Far.
     * @default 'Center'
     */
    alignment?: Alignment;
    /**
     * Defines the textOverFlow for multi level labels. They are,
     * * Trim: Trim textOverflow for multi level labels.
     * * Wrap: Wrap textOverflow for multi level labels.
     * * none: None textOverflow for multi level labels.
     * @default 'Wrap'
     */
    overflow?: TextOverflow;
    /**
     * Options to customize the multi level labels.
     */
    textStyle?: FontModel;
    /**
     * Border of the multi level labels.
     */
    border?: LabelBorderModel;
    /**
     * multi level categories for multi level labels.
     */
    categories?: MultiLevelCategoriesModel[];
}
/**
 * Interface for a class ScrollbarSettingsRange
 */
export interface ScrollbarSettingsRangeModel {
    /**
     * Specifies the minimum range of an scrollbar.
     * @default null
     */
    minimum?: Date | string | number;
    /**
      * Specifies the maximum range of an scrollbar.
      * @default null
      */
    maximum?: Date | string | number;
}
/**
 * Interface for a class ScrollbarSettings
 */
export interface ScrollbarSettingsModel {
    /**
       * Enables the scrollbar for lazy loading.
       * @default false
       */
    enable?: boolean;
    /**
       * Defines the length of the points for numeric and logarithmic values.
       * @default null
       */
    pointsLength?: number;
    /**
      * Specifies the range for date time values alone.
      */
    range?: ScrollbarSettingsRangeModel;
}
//node_modules/@syncfusion/ej2-charts/src/chart/model/chart-base.d.ts
/**
 * Configures the Annotation for chart.
 */
export  class ChartAnnotationSettings extends base.ChildProperty<ChartAnnotationSettings> {
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x: string | Date | number;
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y: string | number;
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content: string;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as left side.
     * * Far - Align the annotation element as right side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment: Alignment;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits: Units;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region: Regions;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment: Position;
    /**
     * The name of horizontal axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    xAxisName: string;
    /**
     * The name of vertical axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    yAxisName: string;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description: string;
}
/**
 * label border properties.
 */
export  class LabelBorder extends base.ChildProperty<LabelBorder> {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width: number;
    /**
     * Border type for labels
     * * Rectangle
     * * Without Top Border
     * * Without Top and BottomBorder
     * * Without Border
     * * Brace
     * * CurlyBrace
     * @default 'Rectangle'
     */
    type: BorderType;
}
/**
 * categories for multi level labels
 */
export  class MultiLevelCategories extends base.ChildProperty<MultiLevelCategories> {
    /**
     * Start value of the multi level labels
     * @default null
     * @aspDefaultValueIgnore
     */
    start: number | Date | string;
    /**
     * End value of the multi level labels
     * @default null
     * @aspDefaultValueIgnore
     */
    end: number | Date | string;
    /**
     * multi level labels text.
     * @default ''
     */
    text: string;
    /**
     * Maximum width of the text for multi level labels.
     * @default null
     * @aspDefaultValueIgnore
     */
    maximumTextWidth: number;
    /**
     * multi level labels custom data.
     * @default null
     */
    customAttributes: object;
    /**
     * Border type for labels
     * * Rectangle
     * * Without Top Border
     * * Without Top and BottomBorder
     * * Without Border
     * * Brace
     * * CurlyBrace
     * @default 'Rectangle'
     * @aspDefaultValueIgnore
     * @blazorDefaultValueIgnore
     */
    type: BorderType;
}
/**
 * Strip line properties
 */
export  class StripLineSettings extends base.ChildProperty<StripLineSettings> {
    /**
     * If set true, strip line for axis renders.
     * @default true
     */
    visible: boolean;
    /**
     *  If set true, strip line get render from axis origin.
     *  @default false
     */
    startFromAxis: boolean;
    /**
     * Start value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    start: number | Date;
    /**
     * End value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    end: number | Date;
    /**
     * Size of the strip line, when it starts from the origin.
     * @default null
     * @aspDefaultValueIgnore
     */
    size: number;
    /**
     * Color of the strip line.
     * @default '#808080'
     */
    color: string;
    /**
     * Dash Array of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    dashArray: string;
    /**
     * Size type of the strip line
     * @default Auto
     */
    sizeType: SizeType;
    /**
     * isRepeat value of the strip line.
     * @default false
     * @aspDefaultValueIgnore
     */
    isRepeat: boolean;
    /**
     * repeatEvery value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatEvery: number | Date;
    /**
     * repeatUntil value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatUntil: number | Date;
    /**
     * isSegmented value of the strip line
     * @default false
     * @aspDefaultValueIgnore
     */
    isSegmented: boolean;
    /**
     * segmentStart value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentStart: number | Date;
    /**
     * segmentEnd value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentEnd: number | Date;
    /**
     * segmentAxisName of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentAxisName: string;
    /**
     * Border of the strip line.
     */
    border: BorderModel;
    /**
     * Strip line text.
     * @default ''
     */
    text: string;
    /**
     * The angle to which the strip line text gets rotated.
     * @default null
     * @aspDefaultValueIgnore
     */
    rotation: number;
    /**
     * Defines the position of the strip line text horizontally. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    horizontalAlignment: Anchor;
    /**
     * Defines the position of the strip line text vertically. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    verticalAlignment: Anchor;
    /**
     * Options to customize the strip line text.
     */
    textStyle: FontModel;
    /**
     * Specifies the order of the strip line. They are,
     * * Behind: Places the strip line behind the series elements.
     * * Over: Places the strip line over the series elements.
     * @default 'Behind'
     */
    zIndex: ZIndex;
    /**
     * Strip line Opacity
     * @default 1
     */
    opacity: number;
}
/**
 * MultiLevelLabels properties
 */
export  class MultiLevelLabels extends base.ChildProperty<MultiLevelLabels[]> {
    /**
     * Defines the position of the multi level labels. They are,
     * * Near: Places the multi level labels at Near.
     * * Center: Places the multi level labels at Center.
     * * Far: Places the multi level labels at Far.
     * @default 'Center'
     */
    alignment: Alignment;
    /**
     * Defines the textOverFlow for multi level labels. They are,
     * * Trim: Trim textOverflow for multi level labels.
     * * Wrap: Wrap textOverflow for multi level labels.
     * * none: None textOverflow for multi level labels.
     * @default 'Wrap'
     */
    overflow: TextOverflow;
    /**
     * Options to customize the multi level labels.
     */
    textStyle: FontModel;
    /**
     * Border of the multi level labels.
     */
    border: LabelBorderModel;
    /**
     * multi level categories for multi level labels.
     */
    categories: MultiLevelCategoriesModel[];
}
/**
 * Specifies range for scrollbarSettings property
 * @public
 */
export  class ScrollbarSettingsRange extends base.ChildProperty<ScrollbarSettingsRange> {
    /**
     * Specifies the minimum range of an scrollbar.
     * @default null
     */
    minimum: Date | string | number;
    /**
     * Specifies the maximum range of an scrollbar.
     * @default null
     */
    maximum: Date | string | number;
}
/**
 * Scrollbar Settings Properties for Lazy Loading
 */
export  class ScrollbarSettings extends base.ChildProperty<ScrollbarSettings> {
    /**
     * Enables the scrollbar for lazy loading.
     * @default false
     */
    enable: boolean;
    /**
     * Defines the length of the points for numeric and logarithmic values.
     * @default null
     */
    pointsLength: number;
    /**
     * Specifies the range for date time values alone.
     */
    range: ScrollbarSettingsRangeModel;
}
//node_modules/@syncfusion/ej2-charts/src/chart/model/chart-interface.d.ts
export interface IChartEventArgs {
    /** Defines the name of the event */
    name: string;
    /** Defines the event cancel status */
    cancel: boolean;
}
export interface IAnimationCompleteEventArgs extends IChartEventArgs {
    /** Defines the current animation series */
    series: Series;
}
export interface IAxisMultiLabelRenderEventArgs extends IChartEventArgs {
    /** Defines the current axis */
    axis: Axis;
    /** Defines axis current label text */
    text: string;
    /** Defines font style for multi labels */
    textStyle: FontModel;
    /** Defines text alignment for multi labels */
    alignment: Alignment;
    /** Defines custom objects for multi labels */
    customAttributes: object;
}
export interface IMultiLevelLabelClickEventArgs extends IChartEventArgs {
    /** Defines the current axis */
    axis: Axis;
    /** Defines label current label text */
    text: string;
    level: number;
    start: number | Date | string;
    end: number | Date | string;
    /** Defines custom objects for multi labels */
    customAttributes: object;
}
export interface IPointEventArgs extends IChartEventArgs {
    /** Defines the current series */
    series: SeriesModel;
    /** Defines the current point */
    point: Points;
    /** Defines the point index */
    pointIndex: number;
    /** Defines the series index */
    seriesIndex: number;
    /** Defines the current chart instance */
    chart: Chart;
    /** Defines current mouse x location */
    x: number;
    /** Defines current mouse y location */
    y: number;
}
/**
 * Defines the scroll events
 */
export interface IScrollEventArgs {
    /** Defines the name of the event */
    name?: string;
    /** Defines the current Zoom Position */
    zoomPosition?: number;
    /** Defines the current Zoom Factor */
    zoomFactor?: number;
    /** Defines the current range */
    range?: VisibleRangeModel;
    /** Defines the previous Zoom Position */
    previousZoomPosition?: number;
    /** Defines the previous Zoom Factor */
    previousZoomFactor?: number;
    /** Defines the previous range */
    previousRange?: VisibleRangeModel;
    /** Defines the current scroll axis */
    axis?: Axis;
    /** Defines axis previous range */
    previousAxisRange?: ScrollbarSettingsRangeModel;
    /** Defines axis current range */
    currentRange?: ScrollbarSettingsRangeModel;
}
export interface IZoomCompleteEventArgs extends IChartEventArgs {
    /** Defines the zoomed axis */
    axis: AxisModel;
    /** Defines the previous zoom factor */
    previousZoomFactor: number;
    /** Defines the previous zoom position */
    previousZoomPosition: number;
    /** Defines the current zoom factor */
    currentZoomFactor: number;
    /** Defines the current zoom position */
    currentZoomPosition: number;
}
export interface ITooltipRenderEventArgs extends IChartEventArgs {
    /** Defines tooltip text collections */
    text?: string;
    /** Defines tooltip text style */
    textStyle?: FontModel;
    /** Defines current tooltip series */
    series: Series | AccumulationSeries;
    /** Defines current tooltip point */
    point: Points | AccPoints;
    /** Defines the header text for the tooltip */
    headerText?: string;
    /** point informations */
    data?: IPointInformation;
}
export interface IPointInformation {
    /** point xValue */
    pointX: object;
    /** point yValue */
    pointY: object;
    /** point index */
    pointIndex: number;
    /** series index */
    seriesIndex: number;
    /** series name */
    seriesName: string;
    /** point text */
    pointText: string;
}
export interface IAxisLabelRenderEventArgs extends IChartEventArgs {
    /** Defines the current axis */
    axis: Axis;
    /** Defines axis current label text */
    text: string;
    /** Defines axis current label value */
    value: number;
    /** Defines axis current label font style */
    labelStyle: FontModel;
}
export interface ILegendRenderEventArgs extends IChartEventArgs {
    /** Defines the current legend text */
    text: string;
    /** Defines the current legend fill color */
    fill: string;
    /** Defines the current legend shape */
    shape: LegendShape;
    /** Defines the current legend marker shape */
    markerShape?: ChartShape;
}
export interface ILegendClickEventArgs extends IChartEventArgs {
    /** Defines the chart when legendClick */
    chart: Chart;
    /** Defines the current legend shape */
    legendShape: LegendShape;
    /** Defines the current series */
    series: Series;
    /** Defines the current legend text */
    legendText: string;
}
export interface ITextRenderEventArgs extends IChartEventArgs {
    /** Defines the current series of the label */
    series: SeriesModel;
    /** Defines the current point of the label */
    point: Points;
    /** Defines the current text */
    text: string;
    /** Defines the current label fill color */
    color: string;
    /** Defines the current label border */
    border: BorderModel;
    /** Defines the current label template */
    template: string;
    /** Defines the current font */
    font: FontModel;
}
export interface IAnnotationRenderEventArgs extends IChartEventArgs {
    /** Defines the current annotation content */
    content: HTMLElement;
    /** Defines the current annotation location */
    location: ChartLocation;
}
export interface IPointRenderEventArgs extends IChartEventArgs {
    /** Defines the current series of the point */
    series: Series;
    /** Defines the current point */
    point: Points;
    /** Defines the current point fill color */
    fill: string;
    /** Defines the current point border */
    border: BorderModel;
    /** Defines the current point height */
    height?: number;
    /** Defines the current point width */
    width?: number;
    /** Defines the current point marker shape */
    shape?: ChartShape;
}
export interface ISeriesRenderEventArgs {
    /** Defines the current series */
    series: Series;
    /** Defines the current series data object */
    data: Object;
    /** Defines name of the event */
    name: string;
    /** Defines the current series fill */
    fill: string;
}
export interface IAxisRangeCalculatedEventArgs extends IChartEventArgs {
    /** Defines the current axis */
    axis: Axis;
    /** Defines axis current range */
    minimum: number;
    /** Defines axis current range */
    maximum: number;
    /** Defines axis current interval */
    interval: number;
}
export interface IMouseEventArgs extends IChartEventArgs {
    /** Defines current mouse event target id */
    target: string;
    /** Defines current mouse x location */
    x: number;
    /** Defines current mouse y location */
    y: number;
}
export interface IDragCompleteEventArgs extends IChartEventArgs {
    /** Defines current selected Data X, Y values */
    selectedDataValues: {
        x: string | number | Date;
        y: number;
    }[][];
}
export interface ISelectionCompleteEventArgs extends IChartEventArgs {
    /** Defines current selected Data X, Y values */
    selectedDataValues: {
        x?: string | number | Date;
        y?: number;
        seriesIndex?: number;
        pointIndex?: number;
    }[];
}
export interface ILoadedEventArgs extends IChartEventArgs {
    /** Defines the current chart instance */
    chart: Chart;
}
export interface IPrintEventArgs extends IChartEventArgs {
    htmlContent: Element;
}
/** @private */
export interface IBoxPlotQuartile {
    minimum: number;
    maximum: number;
    outliers: number[];
    upperQuartile: number;
    lowerQuartile: number;
    average: number;
    median: number;
}
/** @private */
/**
 * Specifies the Theme style for chart and accumulation.
 */
export interface IThemeStyle {
    axisLabel: string;
    axisTitle: string;
    axisLine: string;
    majorGridLine: string;
    minorGridLine: string;
    majorTickLine: string;
    minorTickLine: string;
    chartTitle: string;
    legendLabel: string;
    background: string;
    areaBorder: string;
    errorBar: string;
    crosshairLine: string;
    crosshairFill: string;
    crosshairLabel: string;
    tooltipFill: string;
    tooltipBoldLabel: string;
    tooltipLightLabel: string;
    tooltipHeaderLine: string;
    markerShadow: string;
    selectionRectFill: string;
    selectionRectStroke: string;
    selectionCircleStroke: string;
}
export interface IRangeSelectorRenderEventArgs extends IChartEventArgs {
    /** Defines selector collections */
    selector: navigations.ItemModel[];
    /** enable custom format for calendar */
    enableCustomFormat: boolean;
    /** content fro calendar format */
    content: string;
}
/** @private */
export interface ITouches {
    pageX?: number;
    pageY?: number;
    pointerId?: number;
}
/** @private */
export interface IZoomAxisRange {
    actualMin?: number;
    actualDelta?: number;
    min?: number;
    delta?: number;
}
export interface IResizeEventArgs {
    /** Defines the name of the Event */
    name: string;
    /** Defines the previous size of the accumulation chart */
    previousSize: svgBase.Size;
    /** Defines the current size of the accumulation chart */
    currentSize: svgBase.Size;
    /** Defines the accumulation chart instance */
    chart: Chart | AccumulationChart | StockChart;
}
/**
 * Interface for point drag and drop
 */
export interface IDataEditingEventArgs {
    /**
     * current series index
     */
    seriesIndex: number;
    /**
     * Current point index
     */
    pointIndex: number;
    /**
     * current point old value
     */
    oldValue: number;
    /**
     * current point new value
     */
    newValue: number;
    /**
     * current series
     */
    series: Series;
    /**
     * current point
     */
    point: Points;
}
export interface IChartTooltipTemplate {
    /** point x */
    x?: object;
    /** point y */
    y?: number;
    /** point text */
    text?: string;
    /** point open value */
    open?: number;
    /** point close value */
    close?: number;
    /** point high value */
    high?: number;
    /** point low value */
    low?: number;
    /** point volume value */
    volume?: number;
}
//node_modules/@syncfusion/ej2-charts/src/chart/print-export/export.d.ts
/**
 * `ExportModule` module is used to print and export the rendered chart.
 */
export  class Export {
    private chart;
    /**
     * Constructor for export module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * Handles the export method for chart control.
     * @param type
     * @param fileName
     */
    export(type: ExportType, fileName: string, orientation?: pdfExport.PdfPageOrientation, controls?: (Chart | AccumulationChart | RangeNavigator | StockChart)[], width?: number, height?: number, isVertical?: boolean): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the chart.
     * @return {void}
     * @private
     */
    destroy(chart: Chart | AccumulationChart | RangeNavigator): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/area-series.d.ts
/**
 * `AreaSeries` module is used to render the area series.
 */
export  class AreaSeries extends MultiColoredSeries {
    /**
     * Render Area series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * To destroy the area series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/bar-series.d.ts
/**
 * `BarSeries` module is used to render the bar series.
 */
export  class BarSeries extends ColumnBase {
    /**
     * Render Bar series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the bar series.
     * @return {void}
     * @private
     */
    protected destroy(chart: Chart): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/box-and-whisker-series.d.ts
/**
 * `BoxAndWhiskerSeries` module is used to render the box and whisker series.
 */
export  class BoxAndWhiskerSeries extends ColumnBase {
    /**
     * Render BoxAndWhisker series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * update the tip region fo box plot
     * @param series
     * @param point
     * @param sideBySideInfo
     */
    private updateTipRegion;
    /**
     * Update tip size to tip regions
     * @param series
     * @param point
     * @param region
     * @param isInverted
     */
    private updateTipSize;
    /**
     * Calculation for path direction performed here
     * @param point
     * @param series
     * @param median
     * @param average
     */
    getPathString(point: Points, series: Series, median: ChartLocation, average: ChartLocation): string;
    /**
     * Rendering for box and whisker append here.
     * @param series
     * @param point
     * @param rect
     * @param argsData
     * @param direction
     */
    renderBoxAndWhisker(series: Series, point: Points, rect: svgBase.Rect, argsData: IPointRenderEventArgs, direction: string, median: number): void;
    /**
     * To find the box plot values
     * @param yValues
     * @param point
     * @param mode
     */
    findBoxPlotValues(yValues: number[], point: Points, mode: BoxPlotMode): void;
    /**
     * to find the exclusive quartile values
     * @param yValues
     * @param count
     * @param percentile
     */
    private getExclusiveQuartileValue;
    /**
     * to find the inclusive quartile values
     * @param yValues
     * @param count
     * @param percentile
     */
    private getInclusiveQuartileValue;
    /**
     * To find the quartile values
     * @param yValues
     * @param count
     * @param lowerQuartile
     * @param upperQuartile
     */
    private getQuartileValues;
    /**
     * To find the min, max and outlier values
     * @param yValues
     * @param lowerQuartile
     * @param upperQuartile
     * @param minimum
     * @param maximum
     * @param outliers
     */
    private getMinMaxOutlier;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the candle series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/bubble-series.d.ts
/**
 * `BubbleSeries` module is used to render the bubble series.
 */
export  class BubbleSeries {
    /**
     * Render the Bubble series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * To destroy the Bubble.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/candle-series.d.ts
/**
 * `CandleSeries` module is used to render the candle series.
 */
export  class CandleSeries extends ColumnBase {
    /**
     * Render Candle series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Trigger point rendering event
     */
    protected triggerPointRenderEvent(series: Series, point: Points): IPointRenderEventArgs;
    /**
     * Find the color of the candle
     * @param series
     * @private
     */
    private getCandleColor;
    /**
     * Finds the path of the candle shape
     * @param Series
     * @private
     */
    getPathString(topRect: svgBase.Rect, midRect: svgBase.Rect, series: Series): string;
    /**
     * Draws the candle shape
     * @param series
     * @private
     */
    drawCandle(series: Series, point: Points, rect: svgBase.Rect, argsData: IPointRenderEventArgs, direction: string): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the candle series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/chart-series-model.d.ts
/**
 * Interface for a class DataLabelSettings
 */
export interface DataLabelSettingsModel {
    /**
     * If set true, data label for series renders.
     * @default false
     */
    visible?: boolean;
    /**
     * The DataSource field that contains the data label value.
     * @default null
     */
    name?: string;
    /**
     * The background color of the data label accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    fill?: string;
    /**
     * The opacity for the background.
     * @default 1
     */
    opacity?: number;
    /**
     * Specifies angle for data label.
     * @default 0
     */
    angle?: number;
    /**
     * Enables rotation for data label.
     * @default false
     */
    enableRotation?: boolean;
    /**
     * Specifies the position of the data label. They are,
     * * Outer: Positions the label outside the point.
     * * top: Positions the label on top of the point.
     * * Bottom: Positions the label at the bottom of the point.
     * * Middle: Positions the label to the middle of the point.
     * * Auto: Positions the label based on series.
     * @default 'Auto'
     */
    position?: LabelPosition;
    /**
     * The roundedCornerX for the data label. It requires `border` values not to be null.
     * @default 5
     */
    rx?: number;
    /**
     * The roundedCornerY for the data label. It requires `border` values not to be null.
     * @default 5
     */
    ry?: number;
    /**
     * Specifies the alignment for data Label. They are,
     * * Near: Aligns the label to the left of the point.
     * * Center: Aligns the label to the center of the point.
     * * Far: Aligns the label to the right of the point.
     * @default 'Center'
     */
    alignment?: Alignment;
    /**
     * Option for customizing the border lines.
     */
    border?: BorderModel;
    /**
     * Margin configuration for the data label.
     */
    margin?: MarginModel;
    /**
     * Option for customizing the data label text.
     */
    font?: FontModel;
    /**
     * Custom template to show the data label. Use ${point.x} and ${point.y} as a placeholder
     * text to display the corresponding data point.
     * @default null
     */
    template?: string;
}
/**
 * Interface for a class MarkerSettings
 */
export interface MarkerSettingsModel {
    /**
     * If set to true the marker for series is rendered. This is applicable only for line and area type series.
     * @default false
     */
    visible?: boolean;
    /**
     * The different shape of a marker:
     * * Circle
     * * Rectangle
     * * Triangle
     * * Diamond
     * * HorizontalLine
     * * VerticalLine
     * * Pentagon
     * * InvertedTriangle
     * * Image
     * @default 'Circle'
     */
    shape?: ChartShape;
    /**
     * The URL for the Image that is to be displayed as a marker.  It requires marker `shape` value to be an `Image`.
     * @default ''
     */
    imageUrl?: string;
    /**
     * The height of the marker in pixels.
     * @default 5
     */
    height?: number;
    /**
     * The width of the marker in pixels.
     * @default 5
     */
    width?: number;
    /**
     * Options for customizing the border of a marker.
     */
    border?: BorderModel;
    /**
     * Options for customizing the marker position.
     */
    offset?: OffsetModel;
    /**
     *  The fill color of the marker that accepts value in hex and rgba as a valid CSS color string. By default, it will take series' color.
     * @default null
     */
    fill?: string;
    /**
     * The opacity of the marker.
     * @default 1
     */
    opacity?: number;
    /**
     * The data label for the series.
     */
    dataLabel?: DataLabelSettingsModel;
}
/**
 * Interface for a class Points
 */
export interface PointsModel {
}
/**
 * Interface for a class Trendline
 */
export interface TrendlineModel {
    /**
     * Defines the name of trendline
     * @default ''
     */
    name?: string;
    /**
     * Defines the type of the trendline
     * @default 'Linear'
     */
    type?: TrendlineTypes;
    /**
     * Defines the period, the price changes over which will be considered to predict moving average trend line
     * @default 2
     */
    period?: number;
    /**
     * Defines the polynomial order of the polynomial trendline
     * @default 2
     */
    polynomialOrder?: number;
    /**
     * Defines the period, by which the trend has to backward forecast
     * @default 0
     */
    backwardForecast?: number;
    /**
     * Defines the period, by which the trend has to forward forecast
     * @default 0
     */
    forwardForecast?: number;
    /**
     * Options to customize the animation for trendlines
     */
    animation?: AnimationModel;
    /**
     * Options to customize the marker for trendlines
     */
    marker?: MarkerSettingsModel;
    /**
     * Enables/disables tooltip for trendlines
     * @default true
     */
    enableTooltip?: boolean;
    /**
     * Defines the intercept of the trendline
     * @default null
     * @aspDefaultValueIgnore
     */
    intercept?: number;
    /**
     * Defines the fill color of trendline
     * @default ''
     */
    fill?: string;
    /**
     * Defines the width of the trendline
     * @default 1
     */
    width?: number;
    /**
     * Sets the legend shape of the trendline
     * @default 'SeriesType'
     */
    legendShape?: LegendShape;
}
/**
 * Interface for a class ErrorBarCapSettings
 */
export interface ErrorBarCapSettingsModel {
    /**
     * The width of the error bar in pixels.
     * @default 1
     */
    width?: number;
    /**
     * The length of the error bar in pixels.
     * @default 10
     */
    length?: number;
    /**
     *  The stroke color of the cap, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
    /**
     * The opacity of the cap.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class ChartSegment
 */
export interface ChartSegmentModel {
    /**
     * Defines the starting point of region.
     * @default null
     */
    value?: Object;
    /**
     * Defines the color of a region.
     * @default null
     */
    color?: string;
    /**
     * Defines the pattern of dashes and gaps to stroke.
     * @default '0'
     */
    dashArray?: string;
}
/**
 * Interface for a class ErrorBarSettings
 */
export interface ErrorBarSettingsModel {
    /**
     * If set true, error bar for data gets rendered.
     * @default false
     */
    visible?: boolean;
    /**
     * The type of the error bar . They are
     * * Fixed -  Renders a fixed type error bar.
     * * Percentage - Renders a percentage type error bar.
     * * StandardDeviation - Renders a standard deviation type error bar.
     * * StandardError -Renders a standard error type error bar.
     * * Custom -Renders a custom type error bar.
     * @default 'Fixed'
     */
    type?: ErrorBarType;
    /**
     * The direction of the error bar . They are
     * * both -  Renders both direction of error bar.
     * * minus - Renders minus direction of error bar.
     * * plus - Renders plus direction error bar.
     * @default 'Both'
     */
    direction?: ErrorBarDirection;
    /**
     * The mode of the error bar . They are
     * * Vertical -  Renders a vertical error bar.
     * * Horizontal - Renders a horizontal error bar.
     * * Both - Renders both side error bar.
     * @default 'Vertical'
     */
    mode?: ErrorBarMode;
    /**
     *  The color for stroke of the error bar, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    color?: string;
    /**
     * The vertical error of the error bar.
     * @default 1
     */
    verticalError?: number;
    /**
     * The stroke width of the error bar..
     * @default 1
     */
    width?: number;
    /**
     * The horizontal error of the error bar.
     * @default 1
     */
    horizontalError?: number;
    /**
     * The vertical positive error of the error bar.
     * @default 3
     */
    verticalPositiveError?: number;
    /**
     * The vertical negative error of the error bar.
     * @default 3
     */
    verticalNegativeError?: number;
    /**
     * The horizontal positive error of the error bar.
     * @default 1
     */
    horizontalPositiveError?: number;
    /**
     * The horizontal negative error of the error bar.
     * @default 1
     */
    horizontalNegativeError?: number;
    /**
     * Options for customizing the cap of the error bar.
     */
    errorBarCap?: ErrorBarCapSettingsModel;
}
/**
 * Interface for a class SeriesBase
 */
export interface SeriesBaseModel {
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName?: string;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high?: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low?: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open?: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close?: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume?: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping?: string;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                xAxisName: 'xAxis 1',
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    xAxisName?: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                yAxisName: 'yAxis 1'
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    yAxisName?: string;
    /**
     * Options to customizing animation for the series.
     */
    animation?: AnimationModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill?: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width?: number;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray?: string;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: data.Query = new data.Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let chart$: Chart = new Chart({
     * ...
     *     series: [{
     *        dataSource: dataManager,
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default ''
     */
    dataSource?: Object | data.DataManager;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default ''
     */
    query?: data.Query;
    /**
     * Defines the collection of regions that helps to differentiate a line series.
     */
    segments?: ChartSegmentModel[];
    /**
     * Defines the axis, based on which the line series will be split.
     */
    segmentAxis?: Segment;
    /**
     * This property used to improve chart performance via data mapping for series dataSource.
     * @default false
     */
    enableComplexProperty?: boolean;
}
/**
 * Interface for a class Series
 */
export interface SeriesModel extends SeriesBaseModel{
    /**
     * The name of the series visible in legend.
     * @default ''
     */
    name?: string;
    /**
     * The DataSource field that contains the y value.
     * @default ''
     */
    yName?: string;
    /**
     * Type of series to be drawn in radar or polar series. They are
     *  'Line'
     *  'Column'
     *  'Area'
     *  'Scatter'
     *  'Spline'
     *  'StackingColumn'
     *  'StackingArea'
     *  'RangeColumn'
     *  'SplineArea'
     * @default 'Line'
     */
    drawType?: ChartDrawType;
    /**
     * Specifies whether to join start and end point of a line/area series used in polar/radar chart to form a closed path.
     * @default true
     */
    isClosed?: boolean;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is less than the closing price.
     * @default '#2ecd71'
     */
    bearFillColor?: string;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is higher than the closing price.
     * @default '#e74c3d'
     */
    bullFillColor?: string;
    /**
     * This property is applicable for candle series.
     * It enables/disables to visually compare the current values with the previous values in stock.
     * @default false
     */
    enableSolidCandles?: boolean;
    /**
     * The DataSource field that contains the size value of y
     * @default ''
     */
    size?: string;
    /**
     * The bin interval of each histogram points.
     * @default null
     * @aspDefaultValueIgnore
     */
    binInterval?: number;
    /**
     * The normal distribution of histogram series.
     * @default false
     */
    showNormalDistribution?: boolean;
    /**
     * This property allows grouping series in `stacked column / bar` charts.
     * Any string value can be provided to the stackingGroup property.
     * If any two or above series have the same value, those series will be grouped together.
     * @default ''
     */
    stackingGroup?: string;
    /**
     * Specifies the visibility of series.
     * @default true
     */
    visible?: boolean;
    /**
     * Options to customizing the border of the series. This is applicable only for `Column` and `Bar` type series.
     */
    border?: BorderModel;
    /**
     * The opacity of the series.
     * @default 1
     */
    opacity?: number;
    /**
     * The z order of the series.
     * @default 0
     */
    zOrder?: number;
    /**
     * The type of the series are
     * * Line
     * * Column
     * * Area
     * * Bar
     * * Histogram
     * * StackingColumn
     * * StackingArea
     * * StackingBar
     * * StepLine
     * * StepArea
     * * Scatter
     * * Spline
     * * StackingColumn100
     * * StackingBar100
     * * StackingArea100
     * * RangeColumn
     * * Hilo
     * * HiloOpenClose
     * * Waterfall
     * * RangeArea
     * * Bubble
     * * Candle
     * * Polar
     * * Radar
     * * BoxAndWhisker
     * * Pareto
     * @default 'Line'
     */
    type?: ChartSeriesType;
    /**
     * Options for displaying and customizing error bar for individual point in a series.
     */
    errorBar?: ErrorBarSettingsModel;
    /**
     * Options for displaying and customizing markers for individual points in a series.
     */
    marker?: MarkerSettingsModel;
    /**
     * Options to customize the drag settings for series
     */
    dragSettings?: DragSettingsModel;
    /**
     * Defines the collection of trendlines that are used to predict the trend
     */
    trendlines?: TrendlineModel[];
    /**
     * If set true, the Tooltip for series will be visible.
     * @default true
     */
    enableTooltip?: boolean;
    /**
     * user can format now each series tooltip format separately.
     * @default ''
     */
    tooltipFormat?: string;
    /**
     * The provided value will be considered as a Tooltip name 
     * @default ''
     */
    tooltipMappingName?: string;
    /**
     * The shape of the legend. Each series has its own legend shape. They are,
     * * Circle
     * * Rectangle
     * * Triangle
     * * Diamond
     * * Cross
     * * HorizontalLine
     * * VerticalLine
     * * Pentagon
     * * InvertedTriangle
     * * SeriesType
     * @default 'SeriesType'
     */
    legendShape?: LegendShape;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle?: string;
    /**
     * Minimum radius
     * @default 1
     */
    minRadius?: number;
    /**
     * Maximum radius
     * @default 3
     */
    maxRadius?: number;
    /**
     * Defines type of spline to be rendered.
     * @default 'Natural'
     */
    splineType?: SplineType;
    /**
     * It defines tension of cardinal spline types
     * @default 0.5
     */
    cardinalSplineTension?: number;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings?: EmptyPointSettingsModel;
    /**
     * If set true, the mean value for box and whisker will be visible.
     * @default true
     */
    showMean?: boolean;
    /**
     * The mode of the box and whisker char series. They are,
     * Exclusive
     * Inclusive
     * Normal
     * @default 'Normal'
     */
    boxPlotMode?: BoxPlotMode;
    /**
     * To render the column series points with particular column width. If the series type is histogram the
     * default value is 1 otherwise 0.7.
     * @default null
     * @aspDefaultValueIgnore
     */
    columnWidth?: number;
    /**
     * To render the column series points with particular column spacing. It takes value from 0 - 1.
     * @default 0
     */
    columnSpacing?: number;
    /**
     * Defines the visual representation of the negative changes in waterfall charts.
     * @default '#C64E4A'
     */
    negativeFillColor?: string;
    /**
     * Defines the visual representation of the summaries in waterfall charts.
     * @default '#4E81BC'
     */
    summaryFillColor?: string;
    /**
     * Defines the collection of indexes of the intermediate summary columns in waterfall charts.
     * @default []
     * @aspType int[]
     */
    intermediateSumIndexes?: number[];
    /**
     * Defines the collection of indexes of the overall summary columns in waterfall charts.
     * @default []
     * @aspType int[]
     */
    sumIndexes?: number[];
    /**
     * Defines the appearance of line connecting adjacent points in waterfall charts.
     */
    connector?: ConnectorModel;
    /**
     * To render the column series points with particular rounded corner.
     */
    cornerRadius?: CornerRadiusModel;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/chart-series.d.ts
/**
 * Configures the data label in the series.
 */
export  class DataLabelSettings extends base.ChildProperty<DataLabelSettings> {
    /**
     * If set true, data label for series renders.
     * @default false
     */
    visible: boolean;
    /**
     * The DataSource field that contains the data label value.
     * @default null
     */
    name: string;
    /**
     * The background color of the data label accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    fill: string;
    /**
     * The opacity for the background.
     * @default 1
     */
    opacity: number;
    /**
     * Specifies angle for data label.
     * @default 0
     */
    angle: number;
    /**
     * Enables rotation for data label.
     * @default false
     */
    enableRotation: boolean;
    /**
     * Specifies the position of the data label. They are,
     * * Outer: Positions the label outside the point.
     * * top: Positions the label on top of the point.
     * * Bottom: Positions the label at the bottom of the point.
     * * Middle: Positions the label to the middle of the point.
     * * Auto: Positions the label based on series.
     * @default 'Auto'
     */
    position: LabelPosition;
    /**
     * The roundedCornerX for the data label. It requires `border` values not to be null.
     * @default 5
     */
    rx: number;
    /**
     * The roundedCornerY for the data label. It requires `border` values not to be null.
     * @default 5
     */
    ry: number;
    /**
     * Specifies the alignment for data Label. They are,
     * * Near: Aligns the label to the left of the point.
     * * Center: Aligns the label to the center of the point.
     * * Far: Aligns the label to the right of the point.
     * @default 'Center'
     */
    alignment: Alignment;
    /**
     * Option for customizing the border lines.
     */
    border: BorderModel;
    /**
     * Margin configuration for the data label.
     */
    margin: MarginModel;
    /**
     * Option for customizing the data label text.
     */
    font: FontModel;
    /**
     * Custom template to show the data label. Use ${point.x} and ${point.y} as a placeholder
     * text to display the corresponding data point.
     * @default null
     */
    template: string;
}
/**
 *  Configures the marker in the series.
 */
export  class MarkerSettings extends base.ChildProperty<MarkerSettings> {
    /**
     * If set to true the marker for series is rendered. This is applicable only for line and area type series.
     * @default false
     */
    visible: boolean;
    /**
     * The different shape of a marker:
     * * Circle
     * * Rectangle
     * * Triangle
     * * Diamond
     * * HorizontalLine
     * * VerticalLine
     * * Pentagon
     * * InvertedTriangle
     * * Image
     * @default 'Circle'
     */
    shape: ChartShape;
    /**
     * The URL for the Image that is to be displayed as a marker.  It requires marker `shape` value to be an `Image`.
     * @default ''
     */
    imageUrl: string;
    /**
     * The height of the marker in pixels.
     * @default 5
     */
    height: number;
    /**
     * The width of the marker in pixels.
     * @default 5
     */
    width: number;
    /**
     * Options for customizing the border of a marker.
     */
    border: BorderModel;
    /**
     * Options for customizing the marker position.
     */
    offset: OffsetModel;
    /**
     *  The fill color of the marker that accepts value in hex and rgba as a valid CSS color string. By default, it will take series' color.
     * @default null
     */
    fill: string;
    /**
     * The opacity of the marker.
     * @default 1
     */
    opacity: number;
    /**
     * The data label for the series.
     */
    dataLabel: DataLabelSettingsModel;
}
/**
 * Points model for the series.
 * @public
 */
export  class Points {
    /** point x */
    x: Object;
    /** point y */
    y: Object;
    /** point visibility */
    visible: boolean;
    /** point text */
    text: string;
    /** point tooltip */
    tooltip: string;
    /** point color */
    color: string;
    /** point open value */
    open: Object;
    /** point close value */
    close: Object;
    /** point symbol location */
    symbolLocations: ChartLocation[];
    /** point x value */
    xValue: number;
    /** point y value */
    yValue: number;
    /** point index value */
    index: number;
    /** point region */
    regions: svgBase.Rect[];
    /** point percentage value */
    percentage: number;
    /** point high value */
    high: Object;
    /** point low value */
    low: Object;
    /** point volume value */
    volume: Object;
    /** point size value */
    size: Object;
    /** point empty checking */
    isEmpty: boolean;
    /** point region data */
    regionData: PolarArc;
    /** point minimum value */
    minimum: number;
    /** point maximum value */
    maximum: number;
    /** point upper quartile value */
    upperQuartile: number;
    /** point lower quartile value */
    lowerQuartile: number;
    /** point median value */
    median: number;
    /** point outliers value */
    outliers: number[];
    /** point average value */
    average: number;
    /** point error value */
    error: number;
    /** point interior value */
    interior: string;
    /** To know the point is selected */
    isSelect: boolean;
    /** point marker */
    marker: MarkerSettingsModel;
}
/**
 * Defines the behavior of the Trendlines
 */
export  class Trendline extends base.ChildProperty<Trendline> {
    /**
     * Defines the name of trendline
     * @default ''
     */
    name: string;
    /**
     * Defines the type of the trendline
     * @default 'Linear'
     */
    type: TrendlineTypes;
    /**
     * Defines the period, the price changes over which will be considered to predict moving average trend line
     * @default 2
     */
    period: number;
    /**
     * Defines the polynomial order of the polynomial trendline
     * @default 2
     */
    polynomialOrder: number;
    /**
     * Defines the period, by which the trend has to backward forecast
     * @default 0
     */
    backwardForecast: number;
    /**
     * Defines the period, by which the trend has to forward forecast
     * @default 0
     */
    forwardForecast: number;
    /**
     * Options to customize the animation for trendlines
     */
    animation: AnimationModel;
    /**
     * Options to customize the marker for trendlines
     */
    marker: MarkerSettingsModel;
    /**
     * Enables/disables tooltip for trendlines
     * @default true
     */
    enableTooltip: boolean;
    /**
     * Defines the intercept of the trendline
     * @default null
     * @aspDefaultValueIgnore
     */
    intercept: number;
    /**
     * Defines the fill color of trendline
     * @default ''
     */
    fill: string;
    /**
     * Defines the width of the trendline
     * @default 1
     */
    width: number;
    /**
     * Sets the legend shape of the trendline
     * @default 'SeriesType'
     */
    legendShape: LegendShape;
    /** @private */
    targetSeries: Series;
    /** @private */
    trendLineElement: Element;
    /** @private */
    points: Points[];
    /** @private */
    clipRectElement: Element;
    /** @private */
    clipRect: svgBase.Rect;
    /** @private */
    polynomialSlopes: number[];
    /** @private */
    sourceIndex: number;
    /** @private */
    index: number;
    /** @private */
    setDataSource(series: Series, chart: Chart): void;
}
/**
 * Configures Error bar in series.
 */
export  class ErrorBarCapSettings extends base.ChildProperty<ErrorBarCapSettings> {
    /**
     * The width of the error bar in pixels.
     * @default 1
     */
    width: number;
    /**
     * The length of the error bar in pixels.
     * @default 10
     */
    length: number;
    /**
     *  The stroke color of the cap, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    color: string;
    /**
     * The opacity of the cap.
     * @default 1
     */
    opacity: number;
}
export  class ChartSegment extends base.ChildProperty<ChartSegment> {
    /**
     * Defines the starting point of region.
     * @default null
     */
    value: Object;
    /**
     * Defines the color of a region.
     * @default null
     */
    color: string;
    /**
     * Defines the pattern of dashes and gaps to stroke.
     * @default '0'
     */
    dashArray: string;
    /** @private */
    startValue: number;
    /** @private */
    endValue: number;
}
/**
 * Error bar settings
 * @public
 */
export  class ErrorBarSettings extends base.ChildProperty<ErrorBarSettings> {
    /**
     * If set true, error bar for data gets rendered.
     * @default false
     */
    visible: boolean;
    /**
     * The type of the error bar . They are
     * * Fixed -  Renders a fixed type error bar.
     * * Percentage - Renders a percentage type error bar.
     * * StandardDeviation - Renders a standard deviation type error bar.
     * * StandardError -Renders a standard error type error bar.
     * * Custom -Renders a custom type error bar.
     * @default 'Fixed'
     */
    type: ErrorBarType;
    /**
     * The direction of the error bar . They are
     * * both -  Renders both direction of error bar.
     * * minus - Renders minus direction of error bar.
     * * plus - Renders plus direction error bar.
     * @default 'Both'
     */
    direction: ErrorBarDirection;
    /**
     * The mode of the error bar . They are
     * * Vertical -  Renders a vertical error bar.
     * * Horizontal - Renders a horizontal error bar.
     * * Both - Renders both side error bar.
     * @default 'Vertical'
     */
    mode: ErrorBarMode;
    /**
     *  The color for stroke of the error bar, which accepts value in hex, rgba as a valid CSS color string.
     * @default null
     */
    color: string;
    /**
     * The vertical error of the error bar.
     * @default 1
     */
    verticalError: number;
    /**
     * The stroke width of the error bar..
     * @default 1
     */
    width: number;
    /**
     * The horizontal error of the error bar.
     * @default 1
     */
    horizontalError: number;
    /**
     * The vertical positive error of the error bar.
     * @default 3
     */
    verticalPositiveError: number;
    /**
     * The vertical negative error of the error bar.
     * @default 3
     */
    verticalNegativeError: number;
    /**
     * The horizontal positive error of the error bar.
     * @default 1
     */
    horizontalPositiveError: number;
    /**
     * The horizontal negative error of the error bar.
     * @default 1
     */
    horizontalNegativeError: number;
    /**
     * Options for customizing the cap of the error bar.
     */
    errorBarCap: ErrorBarCapSettingsModel;
}
/**
 * Defines the common behavior of Series and Technical Indicators
 */
export  class SeriesBase extends base.ChildProperty<SeriesBase> {
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName: string;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping: string;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                xAxisName: 'xAxis 1',
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    xAxisName: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                yAxisName: 'yAxis 1'
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    yAxisName: string;
    /**
     * Options to customizing animation for the series.
     */
    animation: AnimationModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width: number;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray: string;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: data.Query = new data.Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let chart$: Chart = new Chart({
     * ...
     *     series: [{
     *        dataSource: dataManager,
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default ''
     */
    query: data.Query;
    /**
     * Defines the collection of regions that helps to differentiate a line series.
     */
    segments: ChartSegmentModel[];
    /**
     * Defines the axis, based on which the line series will be split.
     */
    segmentAxis: Segment;
    /**
     * This property used to improve chart performance via data mapping for series dataSource.
     * @default false
     */
    enableComplexProperty: boolean;
    /**
     * Process data for the series.
     * @hidden
     */
    processJsonData(): void;
    private pushData;
    /** @private */
    protected dataPoint(i: number, textMappingName: string, xName: string): Points;
    private getObjectValue;
    /**
     * To set empty point value based on empty point mode
     * @private
     */
    setEmptyPoint(point: Points, i: number): void;
    private findVisibility;
    /**
     * To get Y min max for the provided point seriesType XY
     */
    private setXYMinMax;
    /**
     * To get Y min max for the provided point seriesType XY
     */
    private setHiloMinMax;
    /**
     * Finds the type of the series
     * @private
     */
    private getSeriesType;
    /** @private */
    protected pushCategoryData(point: Points, index: number, pointX: string): void;
    /**
     * To find average of given property
     */
    private getAverage;
    /**
     * To find the control points for spline.
     * @return {void}
     * @private
     */
    refreshDataManager(chart: Chart): void;
    private dataManagerSuccess;
    private refreshChart;
    /** @private */
    xMin: number;
    /** @private */
    xMax: number;
    /** @private */
    yMin: number;
    /** @private */
    yMax: number;
    /** @private */
    xAxis: Axis;
    /** @private */
    yAxis: Axis;
    /** @private */
    chart: Chart;
    /** @private */
    currentViewData: Object;
    /** @private */
    clipRect: svgBase.Rect;
    /** @private */
    xData: number[];
    /** @private */
    yData: number[];
    /** @private */
    index: number;
    /** @private */
    dataModule: Data;
    /** @private */
    points: Points[];
    /** @private */
    seriesType: SeriesValueType;
    /** @private */
    sizeMax: number;
    /** @private */
    private recordsCount;
}
/**
 * Configures the series in charts.
 * @public
 */
export  class Series extends SeriesBase {
    /**
     * The name of the series visible in legend.
     * @default ''
     */
    name: string;
    /**
     * The DataSource field that contains the y value.
     * @default ''
     */
    yName: string;
    /**
     * Type of series to be drawn in radar or polar series. They are
     *  'Line'
     *  'Column'
     *  'Area'
     *  'Scatter'
     *  'Spline'
     *  'StackingColumn'
     *  'StackingArea'
     *  'RangeColumn'
     *  'SplineArea'
     * @default 'Line'
     */
    drawType: ChartDrawType;
    /**
     * Specifies whether to join start and end point of a line/area series used in polar/radar chart to form a closed path.
     * @default true
     */
    isClosed: boolean;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is less than the closing price.
     * @default '#2ecd71'
     */
    bearFillColor: string;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is higher than the closing price.
     * @default '#e74c3d'
     */
    bullFillColor: string;
    /**
     * This property is applicable for candle series.
     * It enables/disables to visually compare the current values with the previous values in stock.
     * @default false
     */
    enableSolidCandles: boolean;
    /**
     * The DataSource field that contains the size value of y
     * @default ''
     */
    size: string;
    /**
     * The bin interval of each histogram points.
     * @default null
     * @aspDefaultValueIgnore
     */
    binInterval: number;
    /**
     * The normal distribution of histogram series.
     * @default false
     */
    showNormalDistribution: boolean;
    /**
     * This property allows grouping series in `stacked column / bar` charts.
     * Any string value can be provided to the stackingGroup property.
     * If any two or above series have the same value, those series will be grouped together.
     * @default ''
     */
    stackingGroup: string;
    /**
     * Specifies the visibility of series.
     * @default true
     */
    visible: boolean;
    /**
     * Options to customizing the border of the series. This is applicable only for `Column` and `Bar` type series.
     */
    border: BorderModel;
    /**
     * The opacity of the series.
     * @default 1
     */
    opacity: number;
    /**
     * The z order of the series.
     * @default 0
     */
    zOrder: number;
    /**
     * The type of the series are
     * * Line
     * * Column
     * * Area
     * * Bar
     * * Histogram
     * * StackingColumn
     * * StackingArea
     * * StackingBar
     * * StepLine
     * * StepArea
     * * Scatter
     * * Spline
     * * StackingColumn100
     * * StackingBar100
     * * StackingArea100
     * * RangeColumn
     * * Hilo
     * * HiloOpenClose
     * * Waterfall
     * * RangeArea
     * * Bubble
     * * Candle
     * * Polar
     * * Radar
     * * BoxAndWhisker
     * * Pareto
     * @default 'Line'
     */
    type: ChartSeriesType;
    /**
     * Options for displaying and customizing error bar for individual point in a series.
     */
    errorBar: ErrorBarSettingsModel;
    /**
     * Options for displaying and customizing markers for individual points in a series.
     */
    marker: MarkerSettingsModel;
    /**
     * Options to customize the drag settings for series
     */
    dragSettings: DragSettingsModel;
    /**
     * Defines the collection of trendlines that are used to predict the trend
     */
    trendlines: TrendlineModel[];
    /**
     * If set true, the Tooltip for series will be visible.
     * @default true
     */
    enableTooltip: boolean;
    /**
     * user can format now each series tooltip format separately.
     * @default ''
     */
    tooltipFormat: string;
    /**
     * The provided value will be considered as a Tooltip name
     * @default ''
     */
    tooltipMappingName: string;
    /**
     * The shape of the legend. Each series has its own legend shape. They are,
     * * Circle
     * * Rectangle
     * * Triangle
     * * Diamond
     * * Cross
     * * HorizontalLine
     * * VerticalLine
     * * Pentagon
     * * InvertedTriangle
     * * SeriesType
     * @default 'SeriesType'
     */
    legendShape: LegendShape;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle: string;
    /**
     * Minimum radius
     * @default 1
     */
    minRadius: number;
    /**
     * Maximum radius
     * @default 3
     */
    maxRadius: number;
    /**
     * Defines type of spline to be rendered.
     * @default 'Natural'
     */
    splineType: SplineType;
    /**
     * It defines tension of cardinal spline types
     * @default 0.5
     */
    cardinalSplineTension: number;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings: EmptyPointSettingsModel;
    /**
     * If set true, the mean value for box and whisker will be visible.
     * @default true
     */
    showMean: boolean;
    /**
     * The mode of the box and whisker char series. They are,
     * Exclusive
     * Inclusive
     * Normal
     * @default 'Normal'
     */
    boxPlotMode: BoxPlotMode;
    /**
     * To render the column series points with particular column width. If the series type is histogram the
     * default value is 1 otherwise 0.7.
     * @default null
     * @aspDefaultValueIgnore
     */
    columnWidth: number;
    /**
     * To render the column series points with particular column spacing. It takes value from 0 - 1.
     * @default 0
     */
    columnSpacing: number;
    /**
     * Defines the visual representation of the negative changes in waterfall charts.
     * @default '#C64E4A'
     */
    negativeFillColor: string;
    /**
     * Defines the visual representation of the summaries in waterfall charts.
     * @default '#4E81BC'
     */
    summaryFillColor: string;
    /**
     * Defines the collection of indexes of the intermediate summary columns in waterfall charts.
     * @default []
     * @aspType int[]
     */
    intermediateSumIndexes: number[];
    /**
     * Defines the collection of indexes of the overall summary columns in waterfall charts.
     * @default []
     * @aspType int[]
     */
    sumIndexes: number[];
    /**
     * Defines the appearance of line connecting adjacent points in waterfall charts.
     */
    connector: ConnectorModel;
    /**
     * To render the column series points with particular rounded corner.
     */
    cornerRadius: CornerRadiusModel;
    visibleSeriesCount: number;
    /** @private */
    position: number;
    /** @private */
    rectCount: number;
    /** @private */
    seriesElement: Element;
    /** @private */
    errorBarElement: Element;
    /** @private */
    symbolElement: Element;
    /** @private */
    shapeElement: Element;
    /** @private */
    textElement: Element;
    /** @private */
    pathElement: Element;
    /** @private */
    sourceIndex: number;
    /** @private */
    category: SeriesCategories;
    /** @private */
    isRectSeries: boolean;
    /** @private */
    clipRectElement: Element;
    /** @private */
    stackedValues: StackValues;
    /** @private */
    interior: string;
    /** @private */
    histogramValues: IHistogramValues;
    /** @private */
    drawPoints: ControlPoints[];
    /** @private */
    delayedAnimation: boolean;
    constructor(parent: any, propName: string, defaultValue: Object, isArray?: boolean);
    /**
     * Refresh the axis label.
     * @return {boolean}
     * @private
     */
    refreshAxisLabel(): void;
    /**
     * To get the series collection.
     * @return {void}
     * @private
     */
    findSeriesCollection(column: Column, row: Row, isStack: boolean): Series[];
    /**
     * To get the column type series.
     * @return {void}
     * @private
     */
    private rectSeriesInChart;
    /**
     * To calculate the stacked values.
     * @return {void}
     * @private
     */
    calculateStackedValue(isStacking100: boolean, chart: Chart): void;
    private calculateStackingValues;
    private findPercentageOfStacking;
    private findFrequencies;
    /** @private */
    renderSeries(chart: Chart): void;
    /**
     * To create seris element.
     * @return {void}
     * @private
     */
    createSeriesElements(chart: Chart): void;
    /**
     * To append the series.
     * @return {void}
     * @private
     */
    appendSeriesElement(element: Element, chart: Chart): void;
    /**
     * To perform animation for chart series.
     * @return {void}
     * @private
     */
    performAnimation(chart: Chart, type: string, errorBar: ErrorBarSettingsModel, marker: MarkerSettingsModel, dataLabel: DataLabelSettingsModel): void;
    /**
     * To set border color for empty point
     * @private
     */
    setPointColor(point: Points, color: string): string;
    /**
     * To set border color for empty point
     * @private
     */
    setBorderColor(point: Points, border: BorderModel): BorderModel;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/column-base.d.ts
/**
 * Column Series Base
 */
export  class ColumnBase {
    /**
     * To get the position of the column series.
     * @return {DoubleRange}
     * @private
     */
    protected getSideBySideInfo(series: Series): DoubleRange;
    /**
     * To get the rect values.
     * @return {svgBase.Rect}
     * @private
     */
    protected getRectangle(x1: number, y1: number, x2: number, y2: number, series: Series): svgBase.Rect;
    /**
     * To get the position of each series.
     * @return {void}
     * @private
     */
    private getSideBySidePositions;
    private findRectPosition;
    /**
     * Updates the symbollocation for points
     * @return void
     * @private
     */
    protected updateSymbolLocation(point: Points, rect: svgBase.Rect, series: Series): void;
    /**
     * Update the region for the point.
     * @return {void}
     * @private
     */
    protected updateXRegion(point: Points, rect: svgBase.Rect, series: Series): void;
    /**
     * Update the region for the point in bar series.
     * @return {void}
     * @private
     */
    protected updateYRegion(point: Points, rect: svgBase.Rect, series: Series): void;
    /**
     * To render the marker for the series.
     * @return {void}
     * @private
     */
    renderMarker(series: Series): void;
    /**
     * To trigger the point rendering event.
     * @return {void}
     * @private
     */
    protected triggerEvent(series: Series, point: Points, fill: string, border: BorderModel): IPointRenderEventArgs;
    /**
     * To draw the rectangle for points.
     * @return {void}
     * @private
     */
    protected drawRectangle(series: Series, point: Points, rect: svgBase.Rect, argsData: IPointRenderEventArgs): void;
    /**
     * To animate the series.
     * @return {void}
     * @private
     */
    animate(series: Series): void;
    /**
     * To animate the series.
     * @return {void}
     * @private
     */
    private animateRect;
    /**
     * To get rounded rect path direction
     */
    private calculateRoundedRectPath;
}
export interface RectPosition {
    position: number;
    rectCount: number;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/column-series.d.ts
/**
 * `ColumnSeries` Module used to render the column series.
 */
export  class ColumnSeries extends ColumnBase {
    /**
     * Render Column series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the column series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/data-label.d.ts
/**
 * `DataLabel` module is used to render data label for the data point.
 */
export  class DataLabel {
    private chart;
    private margin;
    private isShape;
    private locationX;
    private locationY;
    private fontBackground;
    private borderWidth;
    private markerHeight;
    private commonId;
    private yAxisInversed;
    private inverted;
    private errorHeight;
    private chartBackground;
    /**
     * Constructor for the data label module.
     * @private
     */
    constructor(chart: Chart);
    private initPrivateVariables;
    private calculateErrorHeight;
    private isRectSeries;
    /**
     * Render the data label for series.
     * @return {void}
     */
    render(series: Series, chart: Chart, dataLabel: DataLabelSettingsModel): void;
    /**
     * Render the data label template.
     * @return {void}
     * @private
     */
    private createDataLabelTemplate;
    private calculateTextPosition;
    private calculatePolarRectPosition;
    /**
     * Get the label location
     */
    private getLabelLocation;
    private calculateRectPosition;
    private calculatePathPosition;
    private isDataLabelShape;
    private calculateRectActualPosition;
    private calculateAlignment;
    private calculateTopAndOuterPosition;
    /**
     * Updates the label location
     */
    private updateLabelLocation;
    private calculatePathActualPosition;
    /**
     * Animates the data label.
     * @param  {Series} series - Data label of the series gets animated.
     * @return {void}
     */
    doDataLabelAnimation(series: Series, element?: Element): void;
    private getPosition;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the dataLabel for series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/error-bar.d.ts
/**
 * `ErrorBar` module is used to render the error bar for series.
 */
export  class ErrorBar {
    private chart;
    errorHeight: number;
    error: number;
    positiveHeight: number;
    negativeHeight: number;
    /**
     * Constructor for the error bar module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * Render the error bar for series.
     * @return {void}
     */
    render(series: Series): void;
    private renderErrorBar;
    private findLocation;
    private calculateFixedValue;
    private calculatePercentageValue;
    private calculateStandardDeviationValue;
    private calculateStandardErrorValue;
    private calculateCustomValue;
    private getHorizontalDirection;
    private getVerticalDirection;
    private getBothDirection;
    private getErrorDirection;
    meanCalculation(series: Series, mode: ErrorBarMode): Mean;
    private createElement;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doErrorBarAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the errorBar for series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/hilo-open-close-series.d.ts
/**
 * `HiloOpenCloseSeries` module is used to render the hiloOpenClose series.
 */
export  class HiloOpenCloseSeries extends ColumnBase {
    /**
     * Render HiloOpenCloseSeries series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Updates the tick region
     */
    private updateTickRegion;
    /**
     * Trigger point rendering event
     */
    private triggerPointRenderEvent;
    /**
     * To draw the rectangle for points.
     * @return {void}
     * @private
     */
    protected drawHiloOpenClosePath(series: Series, point: Points, open: ChartLocation, close: ChartLocation, rect: svgBase.Rect, argsData: IPointRenderEventArgs): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the column series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/hilo-series.d.ts
/**
 * `HiloSeries` module is used to render the hilo series.
 */
export  class HiloSeries extends ColumnBase {
    /**
     * Render Hiloseries.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * To trigger the point rendering event.
     * @return {void}
     * @private
     */
    private triggerPointRenderEvent;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the Hilo series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/histogram-series.d.ts
/**
 * `HistogramSeries` Module used to render the histogram series.
 */
export  class HistogramSeries extends ColumnSeries {
    /**
     * Render Histogram series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * To calculate bin interval for Histogram series.
     * @return number
     * @private
     */
    private calculateBinInterval;
    /**
     * Add data points for Histogram series.
     * @return {object[]}
     * @private
     */
    processInternalData(data: Object[], series: Series): Object[];
    /**
     * Render Normal Distribution for Histogram series.
     * @return {void}
     * @private
     */
    private renderNormalDistribution;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the histogram series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/line-base.d.ts
/**
 * Base for line type series.
 */
export  class LineBase {
    chart: Chart;
    /** @private */
    constructor(chartModule?: Chart);
    /**
     * To improve the chart performance.
     * @return {void}
     * @private
     */
    enableComplexProperty(series: Series): Points[];
    /**
     * To generate the line path direction
     * @param firstPoint
     * @param secondPoint
     * @param series
     * @param isInverted
     * @param getPointLocation
     * @param startPoint
     */
    getLineDirection(firstPoint: Points, secondPoint: Points, series: Series, isInverted: Boolean, getPointLocation: Function, startPoint: string): string;
    /**
     * To append the line path.
     * @return {void}
     * @private
     */
    appendLinePath(options: svgBase.PathOption, series: Series, clipRect: string): void;
    /**
     * To render the marker for the series.
     * @return {void}
     * @private
     */
    renderMarker(series: Series): void;
    /**
     * To do the progressive animation.
     * @return {void}
     * @private
     */
    doProgressiveAnimation(series: Series, option: AnimationModel): void;
    /**
     * To store the symbol location and region
     * @param point
     * @param series
     * @param isInverted
     * @param getLocation
     */
    storePointLocation(point: Points, series: Series, isInverted: boolean, getLocation: Function): void;
    /**
     * To do the linear animation.
     * @return {void}
     * @private
     */
    doLinearAnimation(series: Series, animation: AnimationModel): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/line-series.d.ts
/**
 * `LineSeries` module used to render the line series.
 */
export  class LineSeries extends LineBase {
    /**
     * Render Line Series.
     * @return {void}.
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the line series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/marker-explode.d.ts
/**
 * Marker Module used to render the marker for line type series.
 */
export  class MarkerExplode extends ChartData {
    private markerExplode;
    private isRemove;
    /** @private */
    elementId: string;
    /**
     * Constructor for the marker module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * @hidden
     */
    addEventListener(): void;
    /**
     * @hidden
     */
    removeEventListener(): void;
    /**
     * @hidden
     */
    private mouseUpHandler;
    /**
     * @hidden
     */
    private mouseMoveHandler;
    private markerMove;
    private drawTrackBall;
    /**
     * @hidden
     */
    removeHighlightedMarker(): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/marker.d.ts
/**
 * Marker module used to render the marker for line type series.
 */
export  class Marker extends MarkerExplode {
    /**
     * Constructor for the marker module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * Render the marker for series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    private renderMarker;
    createElement(series: Series, redraw: boolean): void;
    private getRangeLowPoint;
    /**
     * Animates the marker.
     * @return {void}.
     * @private
     */
    doMarkerAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/multi-colored-area-series.d.ts
/**
 * `MultiColoredAreaSeries` module used to render the area series with multi color.
 */
export  class MultiColoredAreaSeries extends MultiColoredSeries {
    /**
     * Render Area series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * To Store the path directions of the area
     */
    private generatePathOption;
    /**
     * To destroy the area series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/multi-colored-base.d.ts
/**
 * Base class for multi colored series
 */
export  class MultiColoredSeries extends LineBase {
    /**
     * To Generate the area path direction
     * @param xValue
     * @param yValue
     * @param series
     * @param isInverted
     * @param getPointLocation
     * @param startPoint
     * @param startPath
     */
    getAreaPathDirection(xValue: number, yValue: number, series: Series, isInverted: boolean, getPointLocation: Function, startPoint: ChartLocation, startPath: string): string;
    /**
     * To Generate the empty point direction
     * @param firstPoint
     * @param secondPoint
     * @param series
     * @param isInverted
     * @param getPointLocation
     */
    getAreaEmptyDirection(firstPoint: ChartLocation, secondPoint: ChartLocation, series: Series, isInverted: boolean, getPointLocation: Function): string;
    /**
     * To set point color
     * @param points
     */
    setPointColor(currentPoint: Points, previous: Points, series: Series, isXSegment: boolean, segments: ChartSegmentModel[]): boolean;
    sortSegments(series: Series, chartSegments: ChartSegmentModel[]): ChartSegmentModel[];
    /**
     * Segment calculation performed here
     * @param series
     * @param options
     * @param chartSegments
     */
    applySegmentAxis(series: Series, options: svgBase.PathOption[], segments: ChartSegmentModel[]): void;
    private includeSegment;
    /**
     * To create clip rect for segment axis
     * @param startValue
     * @param endValue
     * @param series
     * @param index
     * @param isX
     * @param chart
     */
    createClipRect(startValue: number, endValue: number, series: Series, index: number, isX: boolean): string;
    /**
     * To get exact value from segment value
     * @param segmentValue
     * @param axis
     * @param chart
     */
    getAxisValue(segmentValue: Object, axis: Axis, chart: Chart): number;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/multi-colored-line-series.d.ts
/**
 * `MultiColoredLineSeries` used to render the line series with multi color.
 */
export  class MultiColoredLineSeries extends MultiColoredSeries {
    /**
     * Render Line Series.
     * @return {void}.
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the line series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/pareto-series.d.ts
/**
 * `Pareto series` module used to render the Pareto series.
 */
export  class ParetoSeries extends ColumnBase {
    paretoAxes: Axis[];
    /**
     * Defines the Line initialization
     */
    initSeries(targetSeries: Series, chart: Chart): void;
    /**
     * Defines the Axis initialization for Line
     */
    initAxis(paretoSeries: Series, targetSeries: Series, chart: Chart): void;
    /**
     * Render Pareto series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * To perform the cumulative calculation for pareto series.
     */
    performCumulativeCalculation(json: Object, series: Series): Object[];
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the pareto series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/polar-series.d.ts
/**
 * `PolarSeries` module is used to render the polar series.
 */
export  class PolarSeries extends PolarRadarPanel {
    /**
     * Render Polar Series.
     * @return {void}.
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, inverted: boolean): void;
    /**
     * Render Column DrawType.
     * @return {void}.
     * @private
     */
    columnDrawTypeRender(series: Series, xAxis: Axis, yAxis: Axis): void;
    /**
     * To trigger the point rendering event.
     * @return {void}
     * @private
     */
    triggerEvent(chart: Chart, series: Series, point: Points): IPointRenderEventArgs;
    /** get position for column drawtypes
     * @return {void}.
     * @private
     */
    getSeriesPosition(series: Series): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To do the Polar Radar draw type column animation.
     * @return {void}
     * @private
     */
    doPolarRadarAnimation(animateElement: Element, delay: number, duration: number, series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the polar series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/radar-series.d.ts
/**
 * `RadarSeries` module is used to render the radar series.
 */
export  class RadarSeries extends PolarSeries {
    /**
     * Render radar Series.
     * @return {void}.
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, inverted: boolean): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the radar series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/range-area-series.d.ts
/**
 * `RangeAreaSeries` module is used to render the range area series.
 */
export  class RangeAreaSeries extends LineBase {
    /**
     * Render RangeArea Series.
     * @return {void}.
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, inverted: boolean): void;
    /**
     * path for rendering the low points
     * @return {void}.
     * @private
     */
    protected closeRangeAreaPath(visiblePoints: Points[], point: Points, series: Series, direction: string, i: number): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the line series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/range-column-series.d.ts
/**
 * `RangeColumnSeries` module is used to render the range column series.
 */
export  class RangeColumnSeries extends ColumnBase {
    /**
     * Render Range Column series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the range column series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/scatter-series.d.ts
/**
 * `ScatterSeries` module is used to render the scatter series.
 */
export  class ScatterSeries {
    /**
     * Render the scatter series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * To append scatter element
     * @param series
     * @param point
     * @param argsData
     * @param startLocation
     */
    private refresh;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the scatter.
     * @return {void}
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/spline-area-series.d.ts
/**
 * `SplineAreaSeries` module used to render the spline area series.
 */
export  class SplineAreaSeries extends SplineBase {
    /**
     * Render the splineArea series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the spline.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/spline-base.d.ts
/**
 * render Line series
 */
export  class SplineBase extends LineBase {
    private splinePoints;
    /** @private */
    constructor(chartModule?: Chart);
    /**
     * To find the control points for spline.
     * @return {void}
     * @private
     */
    findSplinePoint(series: Series): void;
    protected getPreviousIndex(points: Points[], i: number, series: Series): number;
    getNextIndex(points: Points[], i: number, series: Series): number;
    filterEmptyPoints(series: Series): Points[];
    /**
     * To find the natural spline.
     * @return {void}
     * @private
     */
    findSplineCoefficients(points: Points[], series: Series): number[];
    /**
     * To find the control points for spline.
     * @return {void}
     * @private
     */
    getControlPoints(point1: Points, point2: Points, ySpline1: number, ySpline2: number, series: Series): ControlPoints;
    /**
     * calculate datetime interval in hours
     *
     */
    protected dateTimeInterval(series: Series): number;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/spline-series.d.ts
/**
 * `SplineSeries` module is used to render the spline series.
 */
export  class SplineSeries extends SplineBase {
    /**
     * Render the spline series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the spline.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/stacking-area-series.d.ts
/**
 * `StackingAreaSeries` module used to render the Stacking Area series.
 */
export  class StackingAreaSeries extends LineBase {
    /**
     * Render the Stacking area series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the stacking area.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To find previous visible series
     */
    private getPreviousSeries;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/stacking-bar-series.d.ts
/**
 * `StackingBarSeries` module is used to render the stacking bar series.
 */
export  class StackingBarSeries extends ColumnBase {
    /**
     * Render the Stacking bar series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * To destroy the stacking bar.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/stacking-column-series.d.ts
/**
 * `StackingColumnSeries` module used to render the stacking column series.
 */
export  class StackingColumnSeries extends ColumnBase {
    /**
     * Render the Stacking column series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the stacking column.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/stacking-line-series.d.ts
/**
 * `StackingLineSeries` module used to render the Stacking Line series.
 */
export  class StackingLineSeries extends LineBase {
    /**
     * Render the Stacking line series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the stacking line.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/step-area-series.d.ts
/**
 * `StepAreaSeries` Module used to render the step area series.
 */
export  class StepAreaSeries extends LineBase {
    /**
     * Render StepArea series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the step Area series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/step-line-series.d.ts
/**
 * `StepLineSeries` module is used to render the step line series.
 */
export  class StepLineSeries extends LineBase {
    /**
     * Render the Step line series.
     * @return {void}
     * @private
     */
    render(series: Series, xAxis: Axis, yAxis: Axis, isInverted: boolean): void;
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * To destroy the step line series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/series/waterfall-series.d.ts
/**
 * `WaterfallSeries` module is used to render the waterfall series.
 */
export  class WaterfallSeries extends ColumnBase {
    /**
     * Render waterfall series.
     * @return {void}
     * @private
     */
    render(series: Series): void;
    /**
     * To check intermediateSumIndex in waterfall series.
     * @return boolean
     * @private
     */
    private isIntermediateSum;
    /**
     * To check sumIndex in waterfall series.
     * @return boolean
     * @private
     */
    private isSumIndex;
    /**
     * To trigger the point rendering event for waterfall series.
     * @return IPointRenderEventArgs
     * @private
     */
    private triggerPointRenderEvent;
    /**
     * Add sumIndex and intermediateSumIndex data.
     * @return {object[]}
     * @private
     */
    processInternalData(json: Object[], series: Series): Object[];
    /**
     * Animates the series.
     * @param  {Series} series - Defines the series to animate.
     * @return {void}
     */
    doAnimation(series: Series): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the waterfall series.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/ad-indicator.d.ts
/**
 * `AccumulationDistributionIndicator` module is used to render accumulation distribution indicator.
 */
export  class AccumulationDistributionIndicator extends TechnicalAnalysis {
    /**
     * Defines the predictions using accumulation distribution approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     *  Calculates the Accumulation Distribution values
     * @private
     */
    private calculateADPoints;
    /**
     * To destroy the Accumulation Distribution Technical Indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/atr-indicator.d.ts
/**
 * `AtrIndicator` module is used to render ATR indicator.
 */
export  class AtrIndicator extends TechnicalAnalysis {
    /**
     * Defines the predictions using Average True Range approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     *  To calculate Average True Range indicator points
     * @private
     */
    private calculateATRPoints;
    /**
     * To destroy the Average true range indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/bollinger-bands.d.ts
/**
 * `BollingerBands` module is used to render bollinger band indicator.
 */
export  class BollingerBands extends TechnicalAnalysis {
    /**
     * Initializes the series collection to represent bollinger band
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Defines the predictions using Bollinger Band Approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the Bollinger Band.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/ema-indicator.d.ts
/**
 * `EmaIndicator` module is used to render EMA indicator.
 */
export  class EmaIndicator extends TechnicalAnalysis {
    /**
     * Defines the predictions based on EMA approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the EMA Indicator
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/indicator-base.d.ts
/**
 * Technical Analysis module helps to predict the market trend
 */
export  class TechnicalAnalysis extends LineBase {
    /**
     * Defines the collection of series, that are used to represent the given technical indicator
     * @private
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Initializes the properties of the given series
     * @private
     */
    protected setSeriesProperties(series: Series, indicator: TechnicalIndicator, name: string, fill: string, width: number, chart: Chart): void;
    /**
     * Creates the elements of a technical indicator
     * @private
     */
    createIndicatorElements(chart: Chart, indicator: TechnicalIndicator, index: number): void;
    protected getDataPoint(x: Object, y: Object, sourcePoint: Points, series: Series, index: number, indicator?: TechnicalIndicator): Points;
    protected getRangePoint(x: Object, high: Object, low: Object, sourcePoint: Points, series: Series, index: number, indicator?: TechnicalIndicator): Points;
    protected setSeriesRange(points: Points[], indicator: TechnicalIndicator, series?: Series): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/macd-indicator.d.ts
/**
 * `MacdIndicator` module is used to render MACD indicator.
 */
export  class MacdIndicator extends TechnicalAnalysis {
    /**
     * Defines the collection of series to represent the MACD indicator
     * @private
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Defines the predictions using MACD approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Calculates the EMA values for the given period
     */
    private calculateEMAValues;
    /**
     * Defines the MACD Points
     */
    private getMACDPoints;
    /**
     * Calculates the signal points
     */
    private getSignalPoints;
    /**
     * Calculates the MACD values
     */
    private getMACDVales;
    /**
     * Calculates the Histogram Points
     */
    private getHistogramPoints;
    /**
     * To destroy the MACD Indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/momentum-indicator.d.ts
/**
 * `MomentumIndicator` module is used to render Momentum indicator.
 */
export  class MomentumIndicator extends TechnicalAnalysis {
    /**
     * Defines the collection of series to represent a momentum indicator
     * @private
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Defines the predictions using momentum approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the momentum indicator
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/rsi-indicator.d.ts
/**
 * `RsiIndicator` module is used to render RSI indicator.
 */
export  class RsiIndicator extends TechnicalAnalysis {
    /**
     * Initializes the series collection to represent the RSI Indicator
     * @private
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Defines the predictions using RSI approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the RSI Indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/sma-indicator.d.ts
/**
 * `SmaIndicator` module is used to render SMA indicator.
 */
export  class SmaIndicator extends TechnicalAnalysis {
    /**
     * Defines the predictions based on SMA approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the SMA indicator
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/stochastic-indicator.d.ts
/**
 * `StochasticIndicator` module is used to render stochastic indicator.
 */
export  class StochasticIndicator extends TechnicalAnalysis {
    /**
     * Defines the collection of series that represents the stochastic indicator
     * @private
     */
    initSeriesCollection(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Defines the predictions based on stochastic approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * Calculates the SMA Values
     * @private
     */
    private smaCalculation;
    /**
     * Calculates the period line values.
     * @private
     */
    private calculatePeriod;
    /**
     * To destroy the Stocastic Indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/technical-indicator-model.d.ts
/**
 * Interface for a class TechnicalIndicator
 */
export interface TechnicalIndicatorModel extends SeriesBaseModel{
    /**
     * Defines the type of the technical indicator
     * @default 'Sma'
     */
    type?: TechnicalIndicators;
    /**
     * Defines the period, the price changes over which will be considered to predict the trend
     * @default 14
     */
    period?: number;
    /**
     * Defines the look back period, the price changes over which will define the %K value in stochastic indicators
     * @default 14
     */
    kPeriod?: number;
    /**
     * Defines the period, the price changes over which will define the %D value in stochastic indicators
     * @default 3
     */
    dPeriod?: number;
    /**
     * Defines the over-bought(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 80
     */
    overBought?: number;
    /**
     * Defines the over-sold(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 20
     */
    overSold?: number;
    /**
     * Sets the standard deviation values that helps to define the upper and lower bollinger bands
     * @default 2
     */
    standardDeviation?: number;
    /**
     * Defines the field to compare the current value with previous values
     * @default 'Close'
     */
    field?: FinancialDataFields;
    /**
     * Sets the slow period to define the Macd line
     * @default 12
     */
    slowPeriod?: number;
    /**
     * Sets the fast period to define the Macd line
     * @default 26
     */
    fastPeriod?: number;
    /**
     * Enables/Disables the over-bought and over-sold regions
     * @default true
     */
    showZones?: boolean;
    /**
     * Defines the appearance of the the MacdLine of Macd indicator
     * @default { color: '#ff9933', width: 2 }
     */
    macdLine?: ConnectorModel;
    /**
     * Defines the type of the Macd indicator.
     * @default 'Both'
     */
    macdType?: MacdType;
    /**
     * Defines the color of the positive bars in Macd indicators
     * @default '#2ecd71'
     */
    macdPositiveColor?: string;
    /**
     * Defines the color of the negative bars in Macd indicators
     * @default '#e74c3d'
     */
    macdNegativeColor?: string;
    /**
     * Options for customizing the BollingerBand in the indicator.
     * @default 'rgba(211,211,211,0.25)'
     */
    bandColor?: string;
    /**
     * Defines the appearance of the upper line in technical indicators
     */
    upperLine?: ConnectorModel;
    /**
     * Defines the appearance of lower line in technical indicators
     */
    lowerLine?: ConnectorModel;
    /**
     * Defines the appearance of period line in technical indicators
     */
    periodLine?: ConnectorModel;
    /**
     * Defines the name of the series, the data of which has to be depicted as indicator
     * @default ''
     */
    seriesName?: string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/technical-indicator.d.ts

/**
 * Defines how to represent the market trend using technical indicators
 */
export  class TechnicalIndicator extends SeriesBase {
    /**
     * Defines the type of the technical indicator
     * @default 'Sma'
     */
    type: TechnicalIndicators;
    /**
     * Defines the period, the price changes over which will be considered to predict the trend
     * @default 14
     */
    period: number;
    /**
     * Defines the look back period, the price changes over which will define the %K value in stochastic indicators
     * @default 14
     */
    kPeriod: number;
    /**
     * Defines the period, the price changes over which will define the %D value in stochastic indicators
     * @default 3
     */
    dPeriod: number;
    /**
     * Defines the over-bought(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 80
     */
    overBought: number;
    /**
     * Defines the over-sold(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 20
     */
    overSold: number;
    /**
     * Sets the standard deviation values that helps to define the upper and lower bollinger bands
     * @default 2
     */
    standardDeviation: number;
    /**
     * Defines the field to compare the current value with previous values
     * @default 'Close'
     */
    field: FinancialDataFields;
    /**
     * Sets the slow period to define the Macd line
     * @default 12
     */
    slowPeriod: number;
    /**
     * Sets the fast period to define the Macd line
     * @default 26
     */
    fastPeriod: number;
    /**
     * Enables/Disables the over-bought and over-sold regions
     * @default true
     */
    showZones: boolean;
    /**
     * Defines the appearance of the the MacdLine of Macd indicator
     * @default { color: '#ff9933', width: 2 }
     */
    macdLine: ConnectorModel;
    /**
     * Defines the type of the Macd indicator.
     * @default 'Both'
     */
    macdType: MacdType;
    /**
     * Defines the color of the positive bars in Macd indicators
     * @default '#2ecd71'
     */
    macdPositiveColor: string;
    /**
     * Defines the color of the negative bars in Macd indicators
     * @default '#e74c3d'
     */
    macdNegativeColor: string;
    /**
     * Options for customizing the BollingerBand in the indicator.
     * @default 'rgba(211,211,211,0.25)'
     */
    bandColor: string;
    /**
     * Defines the appearance of the upper line in technical indicators
     */
    upperLine: ConnectorModel;
    /**
     * Defines the appearance of lower line in technical indicators
     */
    lowerLine: ConnectorModel;
    /**
     * Defines the appearance of period line in technical indicators
     */
    periodLine: ConnectorModel;
    /**
     * Defines the name of the series, the data of which has to be depicted as indicator
     * @default ''
     */
    seriesName: string;
    /** @private */
    targetSeries: Series[];
    /** @private */
    sourceSeries: Series;
    /** @private */
    indicatorElement: Element;
    /** @private */
    clipRectElement: Element;
    /** @private */
    clipRect: svgBase.Rect;
    /** @private */
    setDataSource(series: Series, chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/technical-indicators/tma-indicator.d.ts
/**
 * `TmaIndicator` module is used to render TMA indicator.
 */
export  class TmaIndicator extends TechnicalAnalysis {
    /**
     * Defines the predictions based on TMA approach
     * @private
     */
    initDataSource(indicator: TechnicalIndicator, chart: Chart): void;
    /**
     * To destroy the TMA indicator.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
}
//node_modules/@syncfusion/ej2-charts/src/chart/trend-lines/trend-line.d.ts
/**
 * `Trendline` module is used to render 6 types of trendlines in chart.
 */
export  class Trendlines {
    /**
     * Defines the collection of series, that are used to represent a trendline
     * @private
     */
    initSeriesCollection(trendline: Trendline, chart: Chart): void;
    /**
     * Initializes the properties of the trendline series
     */
    private setSeriesProperties;
    /**
     * Creates the elements of a trendline
     */
    private createTrendLineElements;
    /**
     * Defines the data point of trendline
     */
    private getDataPoint;
    /**
     * Finds the slope and intercept of trendline
     */
    private findSlopeIntercept;
    /**
     * Defines the points to draw the trendlines
     */
    initDataSource(trendline: Trendline, chart: Chart): void;
    /**
     * Calculation of exponential points
     */
    private setExponentialRange;
    /**
     * Calculation of logarithmic points
     */
    private setLogarithmicRange;
    /**
     * Calculation of polynomial points
     */
    private setPolynomialRange;
    /**
     * Calculation of power points
     */
    private setPowerRange;
    /**
     * Calculation of linear points
     */
    private setLinearRange;
    /**
     * Calculation of moving average points
     */
    private setMovingAverageRange;
    /**
     * Calculation of logarithmic points
     */
    private getLogarithmicPoints;
    /**
     * Defines the points based on data point
     */
    private getPowerPoints;
    /**
     * Get the polynomial points based on polynomial slopes
     */
    private getPolynomialPoints;
    /**
     * Defines the moving average points
     */
    private getMovingAveragePoints;
    /**
     * Defines the linear points
     */
    private getLinearPoints;
    /**
     * Defines the exponential points
     */
    private getExponentialPoints;
    /**
     * Defines the points based on data point
     */
    private getPoints;
    /**
     * Defines the polynomial value of y
     */
    private getPolynomialYValue;
    /**
     * Defines the gauss jordan elimination
     */
    private gaussJordanElimination;
    /**
     * Defines the trendline elements
     */
    getTrendLineElements(series: Series, chart: Chart): void;
    /**
     * To destroy the trendline
     */
    destroy(chart: Chart): void;
    /**
     * Get module name
     */
    protected getModuleName(): string;
}
/** @private */
export interface SlopeIntercept {
    slope?: number;
    intercept?: number;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/crosshair.d.ts
/**
 * `Crosshair` module is used to render the crosshair for chart.
 */
export  class Crosshair {
    private elementID;
    private elementSize;
    private svgRenderer;
    private crosshairInterval;
    private arrowLocation;
    private isTop;
    private isBottom;
    private isLeft;
    private isRight;
    private valueX;
    private valueY;
    private rx;
    private ry;
    private chart;
    /**
     * Constructor for crosshair module.
     * @private
     */
    constructor(chart: Chart);
    /**
     * @hidden
     */
    private addEventListener;
    private mouseUpHandler;
    private mouseLeaveHandler;
    private mouseMoveHandler;
    /**
     * Handles the long press on chart.
     * @return {boolean}
     * @private
     */
    private longPress;
    /**
     * Renders the crosshair.
     * @return {void}
     */
    crosshair(): void;
    private renderCrosshairLine;
    private drawCrosshairLine;
    private renderAxisTooltip;
    private getAxisText;
    private tooltipLocation;
    private stopAnimation;
    private progressAnimation;
    /**
     * Removes the crosshair on mouse leave.
     * @return {void}
     * @private
     */
    removeCrosshair(duration: number): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the crosshair.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/data-editing.d.ts
/**
 * `DataEditing` module handles data editing
 */
export  class DataEditing {
    private chart;
    private seriesIndex;
    private pointIndex;
    /**
     * Constructor for DataEditing module.
     * @private.
     */
    constructor(chart: Chart);
    /**
     * Point drag start here
     */
    pointMouseDown(): void;
    /**
     * Point dragging
     */
    pointMouseMove(event: PointerEvent | TouchEvent): void;
    /**
     * Get cursor style
     */
    private getCursorStyle;
    /**
     * Dragging calculation
     */
    private pointDragging;
    /**
     * Point drag ends here
     */
    pointMouseUp(): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the DataEditing.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/selection.d.ts
/**
 * `Selection` module handles the selection for chart.
 * @private
 */
export  class Selection extends BaseSelection {
    private renderer;
    private isSeriesMode;
    private isdrawRect;
    private resizing;
    /** @private */
    rectPoints: svgBase.Rect;
    private closeIconId;
    private closeIcon;
    private draggedRectGroup;
    private multiRectGroup;
    private draggedRect;
    private lassoPath;
    /** @private */
    selectedDataIndexes: Indexes[];
    multiDataIndexes: Points[][];
    pathIndex: number;
    seriesIndex: number;
    private series;
    private dragging;
    private count;
    private isMultiDrag;
    private targetIndex;
    private dragRect;
    private dragRectArray;
    filterArray: svgBase.Rect[];
    private totalSelectedPoints;
    private rectGrabbing;
    private path;
    private resizeMode;
    private chart;
    /**
     * Constructor for selection module.
     * @private.
     */
    constructor(chart: Chart);
    /**
     * Binding events for selection module.
     */
    private addEventListener;
    /**
     * Chart mouse down
     */
    private mousedown;
    /**
     * UnBinding events for selection module.
     */
    private removeEventListener;
    /**
     * To find private variable values
     */
    private initPrivateVariables;
    /**
     * Method to select the point and series.
     * @return {void}
     */
    invokeSelection(chart: Chart): void;
    private generateStyle;
    private selectDataIndex;
    private getElementByIndex;
    private getClusterElements;
    private findElements;
    /**
     * To find the selected element.
     * @return {void}
     * @private
     */
    calculateSelectedElements(event: Event): void;
    private performSelection;
    private selectionComplete;
    private selection;
    private clusterSelection;
    private removeMultiSelectEelments;
    private blurEffect;
    private checkSelectionElements;
    private applyStyles;
    private getSelectionClass;
    private removeStyles;
    private addOrRemoveIndex;
    private toEquals;
    /**
     * To redraw the selected points.
     * @return {void}
     * @private
     */
    redrawSelection(chart: Chart, oldMode: SelectionMode): void;
    /** @private */
    legendSelection(chart: Chart, series: number): void;
    private getSeriesElements;
    private indexFinder;
    /**
     * Drag selection that returns the selected data.
     * @return {void}
     * @private
     */
    calculateDragSelectedElements(chart: Chart, dragRect: svgBase.Rect, isClose?: boolean): void;
    private removeOffset;
    private isPointSelect;
    /**
     * Method to draw dragging rect.
     * @return {void}
     * @private
     */
    drawDraggingRect(chart: Chart, dragRect: svgBase.Rect, target?: Element): void;
    /**
     * To get drag selected group element index from its id
     * @param id
     */
    private getIndex;
    private createCloseButton;
    /**
     * Method to remove dragged element.
     * @return {void}
     * @private
     */
    removeDraggedElements(chart: Chart, event: Event): void;
    /**
     * Method to resize the drag rect.
     * @return {void}
     * @private
     */
    resizingSelectionRect(chart: Chart, location: ChartLocation, tapped?: boolean, target?: Element): void;
    private findResizeMode;
    private changeCursorStyle;
    private removeSelectedElements;
    private setAttributes;
    /**
     * Method to move the dragged rect.
     * @return {void}
     * @private
     */
    draggedRectMoved(chart: Chart, grabbedPoint: svgBase.Rect, doDrawing?: boolean, target?: Element): void;
    /**
     * To complete the selection.
     * @return {void}
     * @private
     */
    completeSelection(e: Event): void;
    private getDragRect;
    /** @private */
    dragStart(chart: Chart, seriesClipRect: svgBase.Rect, mouseDownX: number, mouseDownY: number, event: Event): void;
    private isDragRect;
    /** @private */
    mouseMove(event: PointerEvent | TouchEvent): void;
    private getPath;
    private pointChecking;
    /**
     * Get module name.
     * @private
     */
    getModuleName(): string;
    /**
     * To destroy the selection.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/tooltip.d.ts
/**
 * `Tooltip` module is used to render the tooltip for chart series.
 */
export  class Tooltip extends BaseTooltip {
    /**
     * Constructor for tooltip module.
     * @private.
     */
    constructor(chart: Chart);
    /**
     * @hidden
     */
    private addEventListener;
    private mouseUpHandler;
    private mouseLeaveHandler;
    private mouseMoveHandler;
    /**
     * Handles the long press on chart.
     * @return {boolean}
     * @private
     */
    private longPress;
    /**
     * Renders the tooltip.
     * @return {void}
     */
    tooltip(): void;
    private findHeader;
    private findShapes;
    private renderSeriesTooltip;
    private triggerTooltipRender;
    private findMarkerHeight;
    private findData;
    private getSymbolLocation;
    private getRangeArea;
    private getWaterfallRegion;
    private getTooltipText;
    private getTemplateText;
    private findMouseValue;
    private renderGroupedTooltip;
    private triggerSharedTooltip;
    private findSharedLocation;
    private getBoxLocation;
    private parseTemplate;
    private formatPointValue;
    private getFormat;
    private getIndicatorTooltipFormat;
    removeHighlightedMarker(data: PointData[]): void;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the tooltip.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/zooming-toolkit.d.ts
/**
 * Zooming Toolkit created here
 * @private
 */
export  class Toolkit {
    private chart;
    private selectionColor;
    private fillColor;
    private elementOpacity;
    private elementId;
    private zoomInElements;
    private zoomOutElements;
    private zoomElements;
    private panElements;
    private iconRect;
    private hoveredID;
    private selectedID;
    private iconRectOverFill;
    private iconRectSelectionFill;
    /** @private */
    constructor(chart: Chart);
    /**
     * To create the pan button.
     * @return {void}
     * @private
     */
    createPanButton(childElement: Element, parentElement: Element, chart: Chart): void;
    /**
     * To create the zoom button.
     * @return {void}
     * @private
     */
    createZoomButton(childElement: Element, parentElement: Element, chart: Chart): void;
    /**
     * To create the ZoomIn button.
     * @return {void}
     * @private
     */
    createZoomInButton(childElement: Element, parentElement: Element, chart: Chart): void;
    /**
     * To create the ZoomOut button.
     * @return {void}
     * @private
     */
    createZoomOutButton(childElement: Element, parentElement: Element, chart: Chart): void;
    /**
     * To create the Reset button.
     * @return {void}
     * @private
     */
    createResetButton(childElement: Element, parentElement: Element, chart: Chart, isDevice: Boolean): void;
    /**
     * To bind events.
     * @return {void}
     * @private
     */
    wireEvents(element: Element, process: Function): void;
    /**
     * To show tooltip.
     * @return {void}
     * @private
     */
    private showTooltip;
    /** @private */
    removeTooltip(): void;
    /** @private */
    reset(): boolean;
    private zoomIn;
    private zoomOut;
    private zoom;
    /** @private */
    pan(): boolean;
    private zoomInOutCalculation;
    private applySelection;
}
//node_modules/@syncfusion/ej2-charts/src/chart/user-interaction/zooming.d.ts
/**
 * `Zooming` module handles the zooming for chart.
 */
export  class Zoom {
    private chart;
    private zooming;
    private elementId;
    /** @private */
    zoomingRect: svgBase.Rect;
    /** @private */
    toolkit: Toolkit;
    /** @private */
    toolkitElements: Element;
    /** @private */
    isPanning: boolean;
    /** @private */
    isZoomed: boolean;
    /** @private */
    isPointer: Boolean;
    /** @private */
    pinchTarget: Element;
    /** @private */
    isDevice: Boolean;
    /** @private */
    browserName: string;
    /** @private */
    touchStartList: ITouches[] | TouchList;
    /** @private */
    touchMoveList: ITouches[] | TouchList;
    /** @private */
    offset: svgBase.Rect;
    /** @private */
    zoomAxes: IZoomAxisRange[];
    /** @private */
    isIOS: Boolean;
    /** @private */
    performedUI: boolean;
    private zoomkitOpacity;
    private wheelEvent;
    private cancelEvent;
    /**
     * Constructor for Zooming module.
     * @private.
     */
    constructor(chart: Chart);
    /**
     * Function that handles the Rectangular zooming.
     * @return {void}
     */
    renderZooming(e: PointerEvent | TouchEvent, chart: Chart, isTouch: boolean): void;
    private drawZoomingRectangle;
    private doPan;
    /**
     * Redraw the chart on zooming.
     * @return {void}
     * @private
     */
    performZoomRedraw(chart: Chart): void;
    private refreshAxis;
    private doZoom;
    /**
     * Function that handles the Mouse wheel zooming.
     * @return {void}
     * @private
     */
    performMouseWheelZooming(e: WheelEvent, mouseX: number, mouseY: number, chart: Chart, axes: AxisModel[]): void;
    /**
     * Function that handles the Pinch zooming.
     * @return {void}
     * @private
     */
    performPinchZooming(e: TouchEvent, chart: Chart): boolean;
    private calculatePinchZoomFactor;
    private setTransform;
    private calculateZoomAxesRange;
    private showZoomingToolkit;
    /**
     * To the show the zooming toolkit.
     * @return {void}
     * @private
     */
    applyZoomToolkit(chart: Chart, axes: AxisModel[]): void;
    /**
     * Return boolean property to show zooming toolkit.
     * @return {void}
     * @private
     */
    isAxisZoomed(axes: AxisModel[]): boolean;
    private zoomToolkitMove;
    private zoomToolkitLeave;
    /**
     * @hidden
     */
    addEventListener(): void;
    /**
     * @hidden
     */
    removeEventListener(): void;
    /**
     * Handles the mouse wheel on chart.
     * @return {boolean}
     * @private
     */
    chartMouseWheel(e: WheelEvent): boolean;
    /**
     * @hidden
     */
    private mouseMoveHandler;
    /**
     * @hidden
     */
    private mouseDownHandler;
    /**
     * @hidden
     */
    private mouseUpHandler;
    /**
     * @hidden
     */
    private mouseCancelHandler;
    /**
     * Handles the touch pointer.
     * @return {boolean}
     * @private
     */
    addTouchPointer(touchList: ITouches[], e: PointerEvent, touches: TouchList): ITouches[];
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the zooming.
     * @return {void}
     * @private
     */
    destroy(chart: Chart): void;
}
//node_modules/@syncfusion/ej2-charts/src/chart/utils/double-range.d.ts
/**
 * Numeric Range.
 * @private
 */
export  class DoubleRange {
    private mStart;
    private mEnd;
    /** @private */
    readonly start: number;
    /** @private */
    readonly end: number;
    /** @private */
    readonly delta: number;
    /** @private */
    readonly median: number;
    constructor(start: number, end: number);
}
//node_modules/@syncfusion/ej2-charts/src/chart/utils/enum.d.ts
/**
 * Defines Orientation of axis. They are
 * * horizontal
 * * vertical
 * @private
 */
export  type Orientation = 
/**  Horizontal Axis. */
'Horizontal' | 
/**  Vertical Axis. */
'Vertical';
/**
 * Defines area type of chart. They are
 * * none
 * * cartesianAxes
 * * polarAxes
 * @private
 */
export  type ChartAreaType = 
/**  Cartesian panel. */
'CartesianAxes' | 
/**  Polar panel. */
'PolarAxes';
/**
 * Defines series type of chart. They are
 * * xy
 * * highLow
 * @private
 */
export  type SeriesValueType = 
/**  XY value. */
'XY' | 
/**  HighLow value. */
'HighLow' | 
/**  HighLowOpenClose value. */
'HighLowOpenClose' | 
/** BoxPlot */
'BoxPlot';
/**
 * Defines the range padding of axis. They are
 * * none - Padding cannot be applied to the axis.
 * * normal - Padding is applied to the axis based on the range calculation.
 * * additional - Interval of the axis is added as padding to the minimum and maximum values of the range.
 * * round - Axis range is rounded to the nearest possible value divided by the interval.
 */
export  type ChartRangePadding = 
/**  Padding Normal is applied for orientation vertical axis and None is applied for orientation horizontal axis */
'Auto' | 
/**  Padding wiil not be applied to the axis. */
'None' | 
/**  Padding is applied to the axis based on the range calculation. */
'Normal' | 
/**  Interval of the axis is added as padding to the minimum and maximum values of the range. */
'Additional' | 
/**  Axis range is rounded to the nearest possible value divided by the interval. */
'Round';
/**
 * Defines the segment axis. They are,
 * * X - Segment calculation rendered based on horizontal axis
 * * Y - Segment calculation rendered based on vertical axis
 */
export  type Segment = 
/** Segment calculation rendered based on horizontal axis */
'X' | 
/** Segment calculation rendered based on verticalal axis */
'Y';
/**
 * Defines the unit of Strip line Size. They are
 * * auto
 * * pixel
 * * year
 * * month
 * * day
 * * hour
 * * minutes
 * * seconds
 */
export  type SizeType = 
/**  Auto - In numeric axis, it will consider a number and DateTime axis, it will consider as milliseconds. */
'Auto' | 
/**  Pixel - The stripline gets their size in pixel */
'Pixel' | 
/**  Years - The stipline size is based on year in the DateTime axis. */
'Years' | 
/**  Months - The stipline size is based on month in the DateTime axis. */
'Months' | 
/**  Days - The stipline size is based on day in the DateTime axis. */
'Days' | 
/**  Hours - The stipline size is based on hour in the DateTime axis. */
'Hours' | 
/**  Minutes - The stipline size is based on minutes in the DateTime axis. */
'Minutes' | 
/**  Seconds - The stipline size is based on seconds in the DateTime axis. */
'Seconds';
/**
 * Defines the type series in chart. They are
 * * line - Renders the line series.
 * * column - Renders the column series.
 * * area - Renders the area series.
 * * pie - Renders the pie series.
 * * polar - Renders the polar series.
 * * radar - Renders the radar series.
 * * bar - Renders the stacking column series
 * * histogram - Renders the histogram series
 * * stackingColumn - Renders the stacking column series.
 * * stackingArea - Renders the stacking area series.
 * * stackingLine - Renders the stacking line series.
 * * stackingBar - Renders the stacking bar series.
 * * StackingColumn100 - Renders the stacking column series.
 * * StackingArea100 - Renders the stacking area 100 percent series
 * * stackingLine100 - Renders the stacking line 100 percent series.
 * * StackingBar100 - Renders the stacking bar 100 percent series.
 * * stepLine -  Renders the step line series.
 * * stepArea -  Renders the step area series.
 * * scatter - Renders the scatter series.
 * * spline - Renders the spline series
 * * rangeColumn - Renders the rangeColumn series.
 * * hilo - Renders the hilo series
 * * hiloOpenClose - Renders the HiloOpenClose Series
 * * Waterfall - Renders the Waterfall Series
 * * rangeArea - Renders the rangeArea series.
 * * Pareto-Render the Pareto series
 */
export  type ChartSeriesType = 
/**  Define the line series. */
'Line' | 
/**  Define the Column series. */
'Column' | 
/**  Define the Area series. */
'Area' | 
/**  Define the Bar series. */
'Bar' | 
/**  Define the Histogram series. */
'Histogram' | 
/**  Define the StackingColumn series. */
'StackingColumn' | 
/**  Define the StackingArea series. */
'StackingArea' | 
/**  Define the StackingLine series. */
'StackingLine' | 
/**  Define the StackingBar series. */
'StackingBar' | 
/**  Define the Stepline series. */
'StepLine' | 
/**  Define the Steparea series. */
'StepArea' | 
/**  Define the Steparea series. */
'SplineArea' | 
/**  Define the Scatter series. */
'Scatter' | 
/**  Define the Spline series. */
'Spline' | 
/** Define the StackingColumn100 series */
'StackingColumn100' | 
/** Define the StackingBar100 series */
'StackingBar100' | 
/** Define the StackingLine100 series */
'StackingLine100' | 
/** Define the StackingArea100 series */
'StackingArea100' | 
/** Define the RangeColumn Series */
'RangeColumn' | 
/** Define the Hilo Series */
'Hilo' | 
/** Define the HiloOpenClose Series */
'HiloOpenClose' | 
/** Define the Waterfall Series */
'Waterfall' | 
/** Define the RangeArea Series */
'RangeArea' | 
/** Define the Bubble Series */
'Bubble' | 
/** Define the Candle Series */
'Candle' | 
/** Define the polar series */
'Polar' | 
/** Define the radar series */
'Radar' | 
/** Define the Box and whisker Series */
'BoxAndWhisker' | 
/** Define the multi color line series */
'MultiColoredLine' | 
/** Define the multi color area series */
'MultiColoredArea' | 
/** Define the Pareto series */
'Pareto';
/**
 * * Type of series to be drawn in radar or polar series. They are
 * * line - Renders the line series.
 * * column - Renders the column series.
 * * area - Renders the area series.
 * * scatter - Renders the scatter series.
 * * spline - Renders the spline series.
 * * stackingColumn - Renders the stacking column series.
 * * stackingArea - Renders the stacking area series.
 * * rangeColumn - Renders the range column series.
 * * splineArea - Renders the spline area series.
 */
export  type ChartDrawType = 
/**  Define the line series. */
'Line' | 
/**  Define the Column series. */
'Column' | 
/**  Define the stacking Column series. */
'StackingColumn' | 
/**  Define the Area series. */
'Area' | 
/**  Define the Scatter series. */
'Scatter' | 
/** Define the Range column series */
'RangeColumn' | 
/** Define the Spline series */
'Spline' | 
/** Define the Spline Area series */
'SplineArea' | 
/** Define the spline series */
'StackingArea' | 
/** Define the Stacking line series */
'StackingLine';
/**
 * Defines the Edge Label Placement for an axis. They are
 * * none - No action will be perform.
 * * hide - Edge label will be hidden.
 * * shift - Shift the edge labels.
 */
export  type EdgeLabelPlacement = 
/**  Render the edge label in axis. */
'None' | 
/**  Hides the edge label in axis. */
'Hide' | 
/**  Shift the edge series in axis. */
'Shift';
/**
 * Defines the Label Placement for category axis. They are
 * * betweenTicks - Render the label between the ticks.
 * * onTicks - Render the label on the ticks.
 */
export  type LabelPlacement = 
/**  Render the label between the ticks. */
'BetweenTicks' | 
/**  Render the label on the ticks. */
'OnTicks';
/**
 * Defines the shape of marker. They are
 * * circle - Renders a circle.
 * * rectangle - Renders a rectangle.
 * * triangle - Renders a triangle.
 * * diamond - Renders a diamond.
 * * cross - Renders a cross.
 * * horizontalLine - Renders a horizontalLine.
 * * verticalLine - Renders a verticalLine.
 * * pentagon- Renders a pentagon.
 * * invertedTriangle - Renders a invertedTriangle.
 * * image - Renders a image.
 */
export  type ChartShape = 
/** Render a circle. */
'Circle' | 
/** Render a Rectangle. */
'Rectangle' | 
/** Render a Triangle. */
'Triangle' | 
/** Render a Diamond. */
'Diamond' | 
/** Render a Cross. */
'Cross' | 
/** Render a HorizontalLine. */
'HorizontalLine' | 
/** Render a VerticalLine. */
'VerticalLine' | 
/** Render a Pentagon. */
'Pentagon' | 
/** Render a InvertedTriangle. */
'InvertedTriangle' | 
/** Render a Image. */
'Image';
/**
 * Defines the type of axis. They are
 * * double -  Renders a numeric axis.
 * * dateTime - Renders a dateTime axis.
 * * category - Renders a category axis.
 * * logarithmic - Renders a log axis.
 * * DateTimeCategory - Renders a datetime DateTimeCategory axis
 */
export  type ValueType = 
/** Define the numeric axis. */
'Double' | 
/** Define the DateTime axis. */
'DateTime' | 
/** Define the Category axis . */
'Category' | 
/** Define the Logarithmic axis . */
'Logarithmic' | 
/** Define the datetime category axis */
'DateTimeCategory';
/**
 * Defines the type of error bar. They are
 * * fixed -  Renders a fixed type error bar.
 * * percentage - Renders a percentage type error bar.
 * * standardDeviation - Renders a standard deviation type error bar.
 * * standardError -Renders a standard error type error bar.
 * * custom -Renders a custom type error bar.
 */
export  type ErrorBarType = 
/** Define the Fixed type. */
'Fixed' | 
/** Define the Percentage type. */
'Percentage' | 
/** Define the StandardDeviation type . */
'StandardDeviation' | 
/** Define the StandardError type . */
'StandardError' | 
/** Define the Custom type . */
'Custom';
/**
 * Defines the direction of error bar. They are
 * * both -  Renders both direction of error bar.
 * * minus - Renders minus direction of error bar.
 * * plus - Renders plus direction error bar.
 */
export  type ErrorBarDirection = 
/** Define the Both direction. */
'Both' | 
/** Define the Minus direction. */
'Minus' | 
/** Define the Plus direction . */
'Plus';
/**
 * Defines the modes of error bar. They are
 * * vertical -  Renders a vertical error bar.
 * * horizontal - Renders a horizontal error bar.
 * * both - Renders both side error bar.
 */
export  type ErrorBarMode = 
/** Define the Vertical mode. */
'Vertical' | 
/** Define the Horizontal mode. */
'Horizontal' | 
/** Define the Both mode . */
'Both';
/**
 * Defines the interval type of datetime axis. They are
 * * auto - Define the interval of the axis based on data.
 * * years - Define the interval of the axis in years.
 * * months - Define the interval of the axis in months.
 * * days - Define the interval of the axis in days.
 * * hours - Define the interval of the axis in hours.
 * * minutes - Define the interval of the axis in minutes.
 */
export  type IntervalType = 
/** Define the interval of the axis based on data. */
'Auto' | 
/** Define the interval of the axis in years. */
'Years' | 
/** Define the interval of the axis in months. */
'Months' | 
/** Define the interval of the axis in days. */
'Days' | 
/** Define the interval of the axis in hours. */
'Hours' | 
/** Define the interval of the axis in minutes. */
'Minutes' | 
/** Define the interval of the axis in seconds. */
'Seconds';
/**
 * Defines the mode of line in crosshair. They are
 * * none - Hides both vertical and horizontal crosshair line.
 * * both - Shows both vertical and horizontal crosshair line.
 * * vertical - Shows the vertical line.
 * * horizontal - Shows the horizontal line.
 */
export  type LineType = 
/** Hides both vertical and horizontal crosshair line. */
'None' | 
/** Shows both vertical and horizontal crosshair line. */
'Both' | 
/** Shows the vertical line. */
'Vertical' | 
/** Shows the horizontal line. */
'Horizontal';
export  type MacdType = 'Line' | 'Histogram' | 'Both';
/**
 * Defines the position of the legend. They are
 * * auto - Places the legend based on area type.
 * * top - Displays the legend on the top of chart.
 * * left - Displays the legend on the left of chart.
 * * bottom - Displays the legend on the bottom of chart.
 * * right - Displays the legend on the right of chart.
 * * custom - Displays the legend  based on given x and y value.
 */
export  type LegendPosition = 
/** Places the legend based on area type. */
'Auto' | 
/** Places the legend on the top of chart. */
'Top' | 
/** Places the legend on the left of chart. */
'Left' | 
/** Places the legend on the bottom of chart. */
'Bottom' | 
/** Places the legend on the right of chart. */
'Right' | 
/** Places the legend based on given x and y. */
'Custom';
/**
 * Defines the shape of legend. They are
 * * circle - Renders a circle.
 * * rectangle - Renders a rectangle.
 * * triangle - Renders a triangle.
 * * diamond - Renders a diamond.
 * * cross - Renders a cross.
 * * horizontalLine - Renders a horizontalLine.
 * * verticalLine - Renders a verticalLine.
 * * pentagon - Renders a pentagon.
 * * invertedTriangle - Renders a invertedTriangle.
 * * SeriesType -Render a legend shape based on series type.
 */
export  type LegendShape = 
/** Render a circle. */
'Circle' | 
/** Render a Rectangle. */
'Rectangle' | 
/** Render a Triangle. */
'Triangle' | 
/** Render a Diamond. */
'Diamond' | 
/** Render a Cross. */
'Cross' | 
/** Render a HorizontalLine. */
'HorizontalLine' | 
/** Render a VerticalLine. */
'VerticalLine' | 
/** Render a Pentagon. */
'Pentagon' | 
/** Render a InvertedTriangle. */
'InvertedTriangle' | 
/** Render a legend shape based on series type. */
'SeriesType';
/**
 * Defines the zooming mode, They are.
 * * x,y - Chart will be zoomed with respect to both vertical and horizontal axis.
 * * x - Chart will be zoomed with respect to horizontal axis.
 * * y - Chart will be zoomed with respect to vertical axis.
 */
export  type ZoomMode = 
/** Chart will be zoomed with respect to both vertical and horizontal axis. */
'XY' | 
/** Chart will be zoomed with respect to horizontal axis. */
'X' | 
/** Chart will be zoomed with respect to vertical axis. */
'Y';
/**
 * Defines the ZoomingToolkit, They are.
 * * zoom - Renders the zoom button.
 * * zoomIn - Renders the zoomIn button.
 * * zoomOut - Renders the zoomOut button.
 * * pan - Renders the pan button.
 * * reset - Renders the reset button.
 */
export  type ToolbarItems = 
/** Renders the zoom button. */
'Zoom' | 
/** Renders the zoomIn button. */
'ZoomIn' | 
/** Renders the zoomOut button. */
'ZoomOut' | 
/** Renders the pan button. */
'Pan' | 
/** Renders the reset button. */
'Reset';
/**
 * Defines the SelectionMode, They are.
 * * none - Disable the selection.
 * * series - To select a series.
 * * point - To select a point.
 * * cluster - To select a cluster of point
 * * dragXY - To select points, by dragging with respect to both horizontal and vertical axis
 * * dragX - To select points, by dragging with respect to horizontal axis.
 * * dragY - To select points, by dragging with respect to vertical axis.
 * * lasso - To select points, by dragging with respect to free form.
 */
export  type SelectionMode = 
/** Disable the selection. */
'None' | 
/** To select a series. */
'Series' | 
/** To select a point. */
'Point' | 
/** To select a cluster of point. */
'Cluster' | 
/** To select points, by dragging with respect to both horizontal and vertical axis. */
'DragXY' | 
/** To select points, by dragging with respect to vertical axis. */
'DragY' | 
/** To select points, by dragging with respect to horizontal axis. */
'DragX' | 
/** To select points, by dragging with respect to free form. */
'Lasso';
/**
 * Defines the LabelPosition, They are.
 * * outer - Position the label outside the point.
 * * top - Position the label on top of the point.
 * * bottom - Position the label on bottom of the point.
 * * middle - Position the label to middle of the point.
 * * auto - Position the label based on series.
 */
export  type LabelPosition = 
/** Position the label outside the point. */
'Outer' | 
/** Position the label on top of the point. */
'Top' | 
/** Position the label on bottom of the point. */
'Bottom' | 
/** Position the label to middle of the point. */
'Middle' | 
/** Position the label based on series. */
'Auto';
/**
 * Defines the Alignment. They are
 * * none - Shows all the labels.
 * * hide - Hide the label when it intersect.
 * * rotate45 - Rotate the label to 45 degree when it intersect.
 * * rotate90 - Rotate the label to 90 degree when it intersect.
 * *
 */
export  type LabelIntersectAction = 
/** Shows all the labels. */
'None' | 
/** Hide the label when it intersect. */
'Hide' | 
/** Trim the label when it intersect. */
'Trim' | 
/** Wrap the label when it intersect. */
'Wrap' | 
/** Arrange the label in multiple row when it intersect. */
'MultipleRows' | 
/** Rotate the label to 45 degree when it intersect. */
'Rotate45' | 
/** Rotate the label to 90 degree when it intersect. */
'Rotate90';
/**
 * Defines the Position. They are
 * * inside - Place the ticks or labels inside to the axis line.
 * * outside - Place the ticks or labels outside to the axis line.
 * *
 */
export  type AxisPosition = 
/** Place the ticks or labels inside to the axis line. */
'Inside' | 
/** Place the ticks or labels outside to the axis line. */
'Outside';
/**
 * Defines Theme of the chart. They are
 * * Material - Render a chart with Material theme.
 * * Fabric - Render a chart with Fabric theme
 */
export  type ChartTheme = 
/**  Render a chart with Material theme. */
'Material' | 
/**  Render a chart with Fabric theme. */
'Fabric' | 
/**  Render a chart with Bootstrap theme. */
'Bootstrap' | 
/**  Render a chart with HighcontrastLight theme. */
'HighContrastLight' | 
/**  Render a chart with MaterialDark theme. */
'MaterialDark' | 
/**  Render a chart with FabricDark theme. */
'FabricDark' | 
/**  Render a chart with HighContrast theme. */
'HighContrast' | 
/**  Render a chart with BootstrapDark theme. */
'BootstrapDark' | 
/**  Render a chart with Bootstrap4 theme. */
'Bootstrap4';
/**
 *  Specifies the order of the strip line. `Over` | `Behind`.
 * * Over - Places the strip line over the series elements.
 * * Behind - laces the strip line behind the series elements.
 */
export  type ZIndex = 
/** Places the strip line over the series elements. */
'Over' | 
/** Places the strip line behind the series elements. */
'Behind';
/**
 * Defines the strip line text position.
 * * Start - Places the strip line text at the start.
 * * Middle - Places the strip line text in the middle.
 * * End - Places the strip line text at the end.
 */
export  type Anchor = 
/** Places the strip line text at the start. */
'Start' | 
/** Places the strip line text in the middle. */
'Middle' | 
/** Places the strip line text at the end. */
'End';
/**
 * Defines the empty point mode of the chart.
 * * Gap - Used to display empty points as space.
 * * Zero - Used to display empty points as zero.
 * * Drop - Used to ignore the empty point while rendering.
 * * Average - Used to display empty points as previous and next point average.
 */
export  type EmptyPointMode = 
/** Used to display empty points as space  */
'Gap' | 
/** Used to display empty points as zero  */
'Zero' | 
/** Used to ignore the empty point while rendering  */
'Drop' | 
/** Used to display empty points as previous and next point average  */
'Average';
/**
 * Defines the type of technical indicators. They are
 * * Sma - Predicts the trend using Simple Moving Average approach
 * * Ema - Predicts the trend using Exponential Moving Average approach
 * * Tma - Predicts the trend using Triangle Moving Average approach
 * * Atr - Predicts the trend using Average True Range approach
 * * AccumulationDistribution - Predicts the trend using Accumulation Distribution approach
 * * Momentum - Predicts the trend using Momentum approach
 * * Rsi - Predicts the trend using RSI approach
 * * Macd - Predicts the trend using Moving Average Convergence Divergence approach
 * * Stochastic - Predicts the trend using Stochastic approach
 * * BollingerBands - Predicts the trend using Bollinger approach
 */
export  type TechnicalIndicators = 
/** Predicts the trend using Simple Moving Average approach */
'Sma' | 
/** Predicts the trend using Exponential Moving Average approach */
'Ema' | 
/** Predicts the trend using Triangle Moving Average approach */
'Tma' | 
/** Predicts the trend using Momentum approach */
'Momentum' | 
/** Predicts the trend using Average True Range approach */
'Atr' | 
/** Predicts the trend using Accumulation Distribution approach */
'AccumulationDistribution' | 
/** Predicts the trend using Bollinger approach */
'BollingerBands' | 
/** Predicts the trend using Moving Average Convergence Divergence approach */
'Macd' | 
/** Predicts the trend using Stochastic approach */
'Stochastic' | 
/** Predicts the trend using RSI approach */
'Rsi';
/**
 * Defines the type of trendlines. They are
 * * Linear - Defines the linear trendline
 * * Exponential - Defines the exponential trendline
 * * Polynomial - Defines the polynomial trendline
 * * Power - Defines the power trendline
 * * Logarithmic - Defines the logarithmic trendline
 * * MovingAverage - Defines the moving average trendline
 */
export  type TrendlineTypes = 
/** Defines the linear trendline */
'Linear' | 
/** Defines the exponential trendline */
'Exponential' | 
/** Defines the polynomial trendline */
'Polynomial' | 
/** Defines the power trendline */
'Power' | 
/** Defines the logarithmic trendline */
'Logarithmic' | 
/** Defines the moving average trendline */
'MovingAverage';
/**
 * Defines the financial data fields
 * * High - Represents the highest price in the stocks over time
 * * Low - Represents the lowest price in the stocks over time
 * * Open - Represents the opening price in the stocks over time
 * * Close - Represents the closing price in the stocks over time
 */
export  type FinancialDataFields = 
/** Represents the highest price in the stocks over time */
'High' | 
/** Represents the lowest price in the stocks over time */
'Low' | 
/** Represents the opening price in the stocks over time */
'Open' | 
/** Represents the closing price in the stocks over time */
'Close';
/**
 * It defines type of spline.
 * Natural - Used to render Natural spline.
 * Cardinal - Used to render cardinal spline.
 * Clamped - Used to render Clamped spline
 * Monotonic - Used to render monotonic spline
 */
export  type SplineType = 
/** Used to render natural spline type */
'Natural' | 
/** Used to render Monotonicspline  */
'Monotonic' | 
/** Used to render Cardinal */
'Cardinal' | 
/** Used to render Clamped */
'Clamped';
/**
 * Defines the BoxPlotMode for box and whisker chart series, They are.
 * * exclusive - Series render based on exclusive mode.
 * * inclusive - Series render based on inclusive mode.
 * * normal - Series render based on normal mode.
 */
export  type BoxPlotMode = 
/** Defines the Exclusive mode. */
'Exclusive' | 
/** Defines the InClusive mode. */
'Inclusive' | 
/** Defines the Normal mode. */
'Normal';
/**
 * Defines the skeleton type for the axis.
 * * Date - it formats date only.
 * * DateTime - it formats date and time.
 * * Time - it formats time only.
 */
export  type SkeletonType = 
/** Used to format date */
'Date' | 
/** Used to format date and time */
'DateTime' | 
/** Used to format time */
'Time';
/**
 * Defines border type for multi level labels.
 *  * Rectangle
 *  * Brace
 *  * WithoutBorder
 *  * Without top Border
 *  * Without top and bottom border
 *  * Curly brace
 */
export  type BorderType = 
/** Rectangle */
'Rectangle' | 
/** Brace */
'Brace' | 
/** WithoutBorder */
'WithoutBorder' | 
/** WithoutTopBorder */
'WithoutTopBorder' | 
/** WithoutTopandBottomBorder */
'WithoutTopandBottomBorder' | 
/** CurlyBrace */
'CurlyBrace';
//node_modules/@syncfusion/ej2-charts/src/chart/utils/get-data.d.ts
/**
 * To get the data on mouse move.
 * @private
 */
export  class ChartData {
    /** @private */
    chart: Chart;
    lierIndex: number;
    /** @private */
    currentPoints: PointData[] | AccPointData[];
    /** @private */
    previousPoints: PointData[] | AccPointData[];
    insideRegion: boolean;
    /**
     * Constructor for the data.
     * @private
     */
    constructor(chart: Chart);
    /**
     * Method to get the Data.
     * @private
     */
    getData(): PointData;
    isSelected(chart: Chart): boolean;
    private getRectPoint;
    /**
     * Checks whether the region contains a point
     */
    private checkRegionContainsPoint;
    /**
     * To find drag region for column and bar series
     * @param x
     * @param y
     * @param point
     * @param rect
     * @param series
     */
    private rectRegion;
    /**
     * @private
     */
    getClosest(series: Series, value: number): number;
    getClosestX(chart: Chart, series: Series): PointData;
}
//node_modules/@syncfusion/ej2-charts/src/common/annotation/annotation.d.ts
/**
 * Annotation Module handles the Annotation for chart and accumulation series.
 */
export  class AnnotationBase {
    private control;
    private annotation;
    private isChart;
    /**
     * Constructor for chart and accumulation annotation
     * @param control
     */
    constructor(control: Chart | AccumulationChart);
    /**
     * Method to render the annotation for chart and accumulation series.
     * @private
     * @param annotation
     * @param index
     */
    render(annotation: AccumulationAnnotationSettings | ChartAnnotationSettings, index: number): HTMLElement;
    /**
     * Method to calculate the location for annotation - coordinate unit as pixel.
     * @private
     * @param location
     */
    setAnnotationPixelValue(location: ChartLocation): boolean;
    /**
     * Method to calculate the location for annotation - coordinate unit as point.
     * @private
     * @param location
     */
    setAnnotationPointValue(location: ChartLocation): boolean;
    /**
     * To process the annotation for accumulation chart
     * @param annotation
     * @param index
     * @param parentElement
     */
    processAnnotation(annotation: ChartAnnotationSettings | AccumulationAnnotationSettings, index: number, parentElement: HTMLElement): void;
    /**
     * Method to calculate the location for annotation - coordinate unit as point in accumulation chart.
     * @private
     * @param location
     */
    setAccumulationPointValue(location: ChartLocation): boolean;
    /**
     * Method to set the element style for accumulation / chart annotation.
     * @private
     * @param location
     * @param element
     * @param parentElement
     */
    setElementStyle(location: ChartLocation, element: HTMLElement, parentElement: HTMLElement): void;
    /**
     * Method to calculate the alignment value for annotation.
     * @private
     * @param alignment
     * @param size
     * @param value
     */
    setAlignmentValue(alignment: Alignment | Position, size: number, value: number): number;
}
//node_modules/@syncfusion/ej2-charts/src/common/common.d.ts
/**
 * Common directory file
 */ 
//node_modules/@syncfusion/ej2-charts/src/common/index.d.ts
/**
 * Chart and accumulation common files
 */
//node_modules/@syncfusion/ej2-charts/src/common/legend/legend-model.d.ts
/**
 * Interface for a class Location
 */
export interface LocationModel {
    /**
     * X coordinate of the legend in pixels.
     * @default 0
     */
    x?: number;
    /**
     * Y coordinate of the legend in pixels.
     * @default 0
     */
    y?: number;
}
/**
 * Interface for a class LegendSettings
 */
export interface LegendSettingsModel {
    /**
     * If set to true, legend will be visible.
     * @default true
     */
    visible?: boolean;
    /**
     * The height of the legend in pixels.
     * @default null
     */
    height?: string;
    /**
     * The width of the legend in pixels.
     * @default null
     */
    width?: string;
    /**
     * Specifies the location of the legend, relative to the chart.
     * If x is 20, legend moves by 20 pixels to the right of the chart. It requires the `position` to be `Custom`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   legendSettings: {
     *     visible: true,
     *     position: 'Custom',
     *     location: { x: 100, y: 150 },
     *   },
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     */
    location?: LocationModel;
    /**
     * Position of the legend in the chart are,
     * * Auto: Places the legend based on area type.
     * * Top: Displays the legend at the top of the chart.
     * * Left: Displays the legend at the left of the chart.
     * * Bottom: Displays the legend at the bottom of the chart.
     * * Right: Displays the legend at the right of the chart.
     * * Custom: Displays the legend  based on the given x and y values.
     * @default 'Auto'
     */
    position?: LegendPosition;
    /**
     * Option to customize the padding between legend items.
     * @default 8
     */
    padding?: number;
    /**
     * Legend in chart can be aligned as follows:
     * * Near: Aligns the legend to the left of the chart.
     * * Center: Aligns the legend to the center of the chart.
     * * Far: Aligns the legend to the right of the chart.
     * @default 'Center'
     */
    alignment?: Alignment;
    /**
     * Options to customize the legend text.
     */
    textStyle?: FontModel;
    /**
     * Shape height of the legend in pixels.
     * @default 10
     */
    shapeHeight?: number;
    /**
     * Shape width of the legend in pixels.
     * @default 10
     */
    shapeWidth?: number;
    /**
     * Options to customize the border of the legend.
     */
    border?: BorderModel;
    /**
     *  Options to customize left, right, top and bottom margins of the chart.
     */
    margin?: MarginModel;
    /**
     * Padding between the legend shape and text.
     * @default 5
     */
    shapePadding?: number;
    /**
     * The background color of the legend that accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    background?: string;
    /**
     * Opacity of the legend.
     * @default 1
     */
    opacity?: number;
    /**
     * If set to true, series' visibility collapses based on the legend visibility.
     * @default true
     */
    toggleVisibility?: boolean;
    /**
     * Description for legends.
     * @default null
     */
    description?: string;
    /**
     * TabIndex value for the legend.
     * @default 3
     */
    tabIndex?: number;
}
/**
 * Interface for a class BaseLegend
 * @private
 */
export interface BaseLegendModel {
}
/**
 * Interface for a class LegendOptions
 * @private
 */
export interface LegendOptionsModel {
}
//node_modules/@syncfusion/ej2-charts/src/common/legend/legend.d.ts
/**
 * Configures the location for the legend.
 */
export  class Location extends base.ChildProperty<Location> {
    /**
     * X coordinate of the legend in pixels.
     * @default 0
     */
    x: number;
    /**
     * Y coordinate of the legend in pixels.
     * @default 0
     */
    y: number;
}
/**
 * Configures the legends in charts.
 */
export  class LegendSettings extends base.ChildProperty<LegendSettings> {
    /**
     * If set to true, legend will be visible.
     * @default true
     */
    visible: boolean;
    /**
     * The height of the legend in pixels.
     * @default null
     */
    height: string;
    /**
     * The width of the legend in pixels.
     * @default null
     */
    width: string;
    /**
     * Specifies the location of the legend, relative to the chart.
     * If x is 20, legend moves by 20 pixels to the right of the chart. It requires the `position` to be `Custom`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   legendSettings: {
     *     visible: true,
     *     position: 'Custom',
     *     location: { x: 100, y: 150 },
     *   },
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     */
    location: LocationModel;
    /**
     * Position of the legend in the chart are,
     * * Auto: Places the legend based on area type.
     * * Top: Displays the legend at the top of the chart.
     * * Left: Displays the legend at the left of the chart.
     * * Bottom: Displays the legend at the bottom of the chart.
     * * Right: Displays the legend at the right of the chart.
     * * Custom: Displays the legend  based on the given x and y values.
     * @default 'Auto'
     */
    position: LegendPosition;
    /**
     * Option to customize the padding between legend items.
     * @default 8
     */
    padding: number;
    /**
     * Legend in chart can be aligned as follows:
     * * Near: Aligns the legend to the left of the chart.
     * * Center: Aligns the legend to the center of the chart.
     * * Far: Aligns the legend to the right of the chart.
     * @default 'Center'
     */
    alignment: Alignment;
    /**
     * Options to customize the legend text.
     */
    textStyle: FontModel;
    /**
     * Shape height of the legend in pixels.
     * @default 10
     */
    shapeHeight: number;
    /**
     * Shape width of the legend in pixels.
     * @default 10
     */
    shapeWidth: number;
    /**
     * Options to customize the border of the legend.
     */
    border: BorderModel;
    /**
     *  Options to customize left, right, top and bottom margins of the chart.
     */
    margin: MarginModel;
    /**
     * Padding between the legend shape and text.
     * @default 5
     */
    shapePadding: number;
    /**
     * The background color of the legend that accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    background: string;
    /**
     * Opacity of the legend.
     * @default 1
     */
    opacity: number;
    /**
     * If set to true, series' visibility collapses based on the legend visibility.
     * @default true
     */
    toggleVisibility: boolean;
    /**
     * Description for legends.
     * @default null
     */
    description: string;
    /**
     * TabIndex value for the legend.
     * @default 3
     */
    tabIndex: number;
}
/**
 * Legend base class for Chart and Accumulation chart.
 * @private
 */
export  class BaseLegend {
    protected chart: Chart | AccumulationChart;
    protected legend: LegendSettingsModel;
    protected maxItemHeight: number;
    protected isPaging: boolean;
    private clipPathHeight;
    totalPages: number;
    protected isVertical: boolean;
    private rowCount;
    private columnCount;
    private pageButtonSize;
    protected pageXCollections: number[];
    protected maxColumns: number;
    private isTrimmed;
    maxWidth: number;
    protected legendID: string;
    private clipRect;
    private legendTranslateGroup;
    protected currentPage: number;
    private isChartControl;
    protected library: Legend | AccumulationLegend;
    /**  @private */
    position: LegendPosition;
    /**
     * Gets the legend bounds in chart.
     * @private
     */
    legendBounds: svgBase.Rect;
    /** @private */
    legendCollections: LegendOptions[];
    /** @private */
    clearTooltip: number;
    protected pagingClipRect: RectOption;
    protected currentPageNumber: number;
    protected legendRegions: ILegendRegions[];
    protected pagingRegions: svgBase.Rect[];
    protected totalNoOfPages: number;
    /** @private */
    calTotalPage: boolean;
    /**
     * Constructor for the dateTime module.
     * @private
     */
    constructor(chart?: Chart | AccumulationChart);
    /**
     * Calculate the bounds for the legends.
     * @return {void}
     * @private
     */
    calculateLegendBounds(rect: svgBase.Rect, availableSize: svgBase.Size): void;
    /**
     * To find legend position based on available size for chart and accumulation chart
     */
    private getPosition;
    /**
     * To set bounds for chart and accumulation chart
     */
    protected setBounds(computedWidth: number, computedHeight: number, legend: LegendSettingsModel, legendBounds: svgBase.Rect): void;
    /**
     * To find legend location based on position, alignment for chart and accumulation chart
     */
    private getLocation;
    /**
     * To find legend alignment for chart and accumulation chart
     */
    private alignLegend;
    /**
     * Renders the legend.
     * @return {void}
     * @private
     */
    renderLegend(chart: Chart | AccumulationChart, legend: LegendSettingsModel, legendBounds: svgBase.Rect, redraw?: boolean): void;
    /**
     * To find first valid legend text index for chart and accumulation chart
     */
    private findFirstLegendPosition;
    /**
     * To create legend rendering elements for chart and accumulation chart
     */
    private createLegendElements;
    /**
     * To render legend symbols for chart and accumulation chart
     */
    protected renderSymbol(legendOption: LegendOptions, group: Element, i: number): void;
    /**
     * To render legend text for chart and accumulation chart
     */
    protected renderText(chart: Chart | AccumulationChart, legendOption: LegendOptions, group: Element, textOptions: svgBase.TextOption, i: number): void;
    /**
     * To render legend paging elements for chart and accumulation chart
     */
    private renderPagingElements;
    /**
     * To translate legend pages for chart and accumulation chart
     */
    protected translatePage(pagingText: Element, page: number, pageNumber: number): number;
    /**
     * To change legend pages for chart and accumulation chart
     */
    protected changePage(event: Event, pageUp: boolean): void;
    /**
     * To find legend elements id based on chart or accumulation chart
     * @private
     */
    generateId(option: LegendOptions, prefix: string, count: number): string;
    /**
     * To show or hide trimmed text tooltip for legend.
     * @return {void}
     * @private
     */
    move(event: Event): void;
}
/**
 * Class for legend options
 * @private
 */
export  class LegendOptions {
    render: boolean;
    text: string;
    fill: string;
    shape: LegendShape;
    visible: boolean;
    type: ChartSeriesType | AccumulationType;
    textSize: svgBase.Size;
    location: ChartLocation;
    pointIndex?: number;
    seriesIndex?: number;
    markerShape?: ChartShape;
    markerVisibility?: boolean;
    constructor(text: string, fill: string, shape: LegendShape, visible: boolean, type: ChartSeriesType | AccumulationType, markerShape?: ChartShape, markerVisibility?: boolean, pointIndex?: number, seriesIndex?: number);
}
//node_modules/@syncfusion/ej2-charts/src/common/model/base-model.d.ts
/**
 * Interface for a class Connector
 */
export interface ConnectorModel {
    /**
     * specifies the type of the connector line. They are
     * * Smooth
     * * Line
     * @default 'Line'
     */
    type?: ConnectorType;
    /**
     * Color of the connector line.
     * @default null
     */
    color?: string;
    /**
     * Width of the connector line in pixels.
     * @default 1
     */
    width?: number;
    /**
     * Length of the connector line in pixels.
     * @default null
     */
    length?: string;
    /**
     * dashArray of the connector line.
     * @default ''
     */
    dashArray?: string;
}
/**
 * Interface for a class Font
 */
export interface FontModel {
    /**
     * FontStyle for the text.
     * @default 'Normal'
     */
    fontStyle?: string;
    /**
     * Font size for the text.
     * @default '16px'
     */
    size?: string;
    /**
     * FontWeight for the text.
     * @default 'Normal'
     */
    fontWeight?: string;
    /**
     * Color for the text.
     * @default ''
     */
    color?: string;
    /**
     * text alignment
     * @default 'Center'
     */
    textAlignment?: Alignment;
    /**
     * FontFamily for the text.
     */
    fontFamily?: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity?: number;
    /**
     * Specifies the chart title text overflow
     * @default 'Trim'
     */
    textOverflow?: TextOverflow;
}
/**
 * Interface for a class Border
 */
export interface BorderModel {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color?: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width?: number;
}
/**
 * Interface for a class Offset
 */
export interface OffsetModel {
    /**
     * x value of the marker position
     * @default 0
     */
    x?: number;
    /**
     * y value of the marker position
     * @default 0
     */
    y?: number;
}
/**
 * Interface for a class ChartArea
 */
export interface ChartAreaModel {
    /**
     * Options to customize the border of the chart area.
     */
    border?: BorderModel;
    /**
     * The background of the chart area that accepts value in hex and rgba as a valid CSS color string..
     * @default 'transparent'
     */
    background?: string;
    /**
     * The opacity for background.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class Margin
 */
export interface MarginModel {
    /**
     * Left margin in pixels.
     * @default 10
     */
    left?: number;
    /**
     * Right margin in pixels.
     * @default 10
     */
    right?: number;
    /**
     * Top margin in pixels.
     * @default 10
     */
    top?: number;
    /**
     * Bottom margin in pixels.
     * @default 10
     */
    bottom?: number;
}
/**
 * Interface for a class Animation
 */
export interface AnimationModel {
    /**
     * If set to true, series gets animated on initial loading.
     * @default true
     */
    enable?: boolean;
    /**
     * The duration of animation in milliseconds.
     * @default 1000
     */
    duration?: number;
    /**
     * The option to delay animation of the series.
     * @default 0
     */
    delay?: number;
}
/**
 * Interface for a class Indexes
 */
export interface IndexesModel {
    /**
     * Specifies the series index
     * @default 0
     * @aspType int
     */
    series?: number;
    /**
     * Specifies the point index
     * @default 0
     * @aspType int
     */
    point?: number;
}
/**
 * Interface for a class CornerRadius
 */
export interface CornerRadiusModel {
    /**
     * Specifies the top left corner radius value
     * @default 0
     */
    topLeft?: number;
    /**
     * Specifies the top right corner radius value
     * @default 0
     */
    topRight?: number;
    /**
     * Specifies the bottom left corner radius value
     * @default 0
     */
    bottomLeft?: number;
    /**
     * Specifies the bottom right corner radius value
     * @default 0
     */
    bottomRight?: number;
}
/**
 * Interface for a class Index
 * @private
 */
export interface IndexModel {
}
/**
 * Interface for a class EmptyPointSettings
 */
export interface EmptyPointSettingsModel {
    /**
     * To customize the fill color of empty points.
     * @default null
     */
    fill?: string;
    /**
     * Options to customize the border of empty points.
     * @default "{color: 'transparent', width: 0}"
     */
    border?: BorderModel;
    /**
     * To customize the mode of empty points.
     * @default Gap
     */
    mode?: EmptyPointMode | AccEmptyPointMode;
}
/**
 * Interface for a class DragSettings
 */
export interface DragSettingsModel {
    /**
     * To enable the drag the points
     * @default false
     */
    enable?: boolean;
    /**
     * To set the minimum y of the point
     * @default null
     */
    minY?: number;
    /**
     * To set the maximum y of the point
     * @default null
     */
    maxY?: number;
    /**
     * To set the color of the edited point
     * @default null
     */
    fill?: string;
}
/**
 * Interface for a class TooltipSettings
 */
export interface TooltipSettingsModel {
    /**
     * Enables / Disables the visibility of the tooltip.
     * @default false.
     */
    enable?: boolean;
    /**
     * Enables / Disables the visibility of the marker.
     * @default true.
     */
    enableMarker?: boolean;
    /**
     * If set to true, a single ToolTip will be displayed for every index.
     * @default false.
     */
    shared?: boolean;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string.
     * @default null 
     */
    fill?: string;
    /**
     * Header for tooltip. 
     * @default null
     */
    header?: string;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string. 
     * @default 0.75
     */
    opacity?: number;
    /**
     * Options to customize the ToolTip text.
     */
    textStyle?: FontModel;
    /**
     * Format the ToolTip content.
     * @default null.
     */
    format?: string;
    /**
     * Custom template to format the ToolTip content. Use ${x} and ${y} as the placeholder text to display the corresponding data point.
     * @default null.
     */
    template?: string;
    /**
     * If set to true, ToolTip will animate while moving from one point to another.
     * @default true.
     */
    enableAnimation?: boolean;
    /**
     * Options to customize tooltip borders.
     */
    border?: BorderModel;
}
/**
 * Interface for a class Periods
 */
export interface PeriodsModel {
    /**
     * IntervalType of button
     * @default 'Years'
     */
    intervalType?: RangeIntervalType;
    /**
     * Count value for the button
     * @default 1
     */
    interval?: number;
    /**
     * Text to be displayed on the button
     * @default null
     */
    text?: string;
    /**
     * To select the default period
     * @default false
     */
    selected?: boolean;
}
/**
 * Interface for a class PeriodSelectorSettings
 */
export interface PeriodSelectorSettingsModel {
    /**
     * Height for the period selector
     * @default 43
     */
    height?: number;
    /**
     * vertical position of the period selector
     * @default 'Bottom'
     */
    position?: PeriodSelectorPosition;
    /**
     * Buttons
     */
    periods?: PeriodsModel[];
}
//node_modules/@syncfusion/ej2-charts/src/common/model/base.d.ts
/**
 * Defines the appearance of the connectors
 */
export  class Connector extends base.ChildProperty<Connector> {
    /**
     * specifies the type of the connector line. They are
     * * Smooth
     * * Line
     * @default 'Line'
     */
    type: ConnectorType;
    /**
     * Color of the connector line.
     * @default null
     */
    color: string;
    /**
     * Width of the connector line in pixels.
     * @default 1
     */
    width: number;
    /**
     * Length of the connector line in pixels.
     * @default null
     */
    length: string;
    /**
     * dashArray of the connector line.
     * @default ''
     */
    dashArray: string;
}
/**
 * Configures the fonts in charts.
 */
export  class Font extends base.ChildProperty<Font> {
    /**
     * FontStyle for the text.
     * @default 'Normal'
     */
    fontStyle: string;
    /**
     * Font size for the text.
     * @default '16px'
     */
    size: string;
    /**
     * FontWeight for the text.
     * @default 'Normal'
     */
    fontWeight: string;
    /**
     * Color for the text.
     * @default ''
     */
    color: string;
    /**
     * text alignment
     * @default 'Center'
     */
    textAlignment: Alignment;
    /**
     * FontFamily for the text.
     */
    fontFamily: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity: number;
    /**
     * Specifies the chart title text overflow
     * @default 'Trim'
     */
    textOverflow: TextOverflow;
}
/**
 * Configures the borders in the chart.
 */
export  class Border extends base.ChildProperty<Border> {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width: number;
}
/**
 * Configures the marker position in the chart.
 */
export  class Offset extends base.ChildProperty<Offset> {
    /**
     * x value of the marker position
     * @default 0
     */
    x: number;
    /**
     * y value of the marker position
     * @default 0
     */
    y: number;
}
/**
 * Configures the chart area.
 */
export  class ChartArea extends base.ChildProperty<ChartArea> {
    /**
     * Options to customize the border of the chart area.
     */
    border: BorderModel;
    /**
     * The background of the chart area that accepts value in hex and rgba as a valid CSS color string..
     * @default 'transparent'
     */
    background: string;
    /**
     * The opacity for background.
     * @default 1
     */
    opacity: number;
}
/**
 * Configures the chart margins.
 */
export  class Margin extends base.ChildProperty<Margin> {
    /**
     * Left margin in pixels.
     * @default 10
     */
    left: number;
    /**
     * Right margin in pixels.
     * @default 10
     */
    right: number;
    /**
     * Top margin in pixels.
     * @default 10
     */
    top: number;
    /**
     * Bottom margin in pixels.
     * @default 10
     */
    bottom: number;
}
/**
 * Configures the animation behavior for chart series.
 */
export  class Animation extends base.ChildProperty<Animation> {
    /**
     * If set to true, series gets animated on initial loading.
     * @default true
     */
    enable: boolean;
    /**
     * The duration of animation in milliseconds.
     * @default 1000
     */
    duration: number;
    /**
     * The option to delay animation of the series.
     * @default 0
     */
    delay: number;
}
/**
 * Series and point index
 * @public
 */
export  class Indexes extends base.ChildProperty<Indexes> {
    /**
     * Specifies the series index
     * @default 0
     * @aspType int
     */
    series: number;
    /**
     * Specifies the point index
     * @default 0
     * @aspType int
     */
    point: number;
}
/**
 * Column series rounded corner options
 */
export  class CornerRadius extends base.ChildProperty<CornerRadius> {
    /**
     * Specifies the top left corner radius value
     * @default 0
     */
    topLeft: number;
    /**
     * Specifies the top right corner radius value
     * @default 0
     */
    topRight: number;
    /**
     * Specifies the bottom left corner radius value
     * @default 0
     */
    bottomLeft: number;
    /**
     * Specifies the bottom right corner radius value
     * @default 0
     */
    bottomRight: number;
}
/**
 * @private
 */
export  class Index {
    series: number;
    point: number;
    constructor(seriesIndex: number, pointIndex?: number);
}
/**
 * Configures the Empty Points of series
 */
export  class EmptyPointSettings extends base.ChildProperty<EmptyPointSettings> {
    /**
     * To customize the fill color of empty points.
     * @default null
     */
    fill: string;
    /**
     * Options to customize the border of empty points.
     * @default "{color: 'transparent', width: 0}"
     */
    border: BorderModel;
    /**
     * To customize the mode of empty points.
     * @default Gap
     */
    mode: EmptyPointMode | AccEmptyPointMode;
}
/**
 * Configures the drag settings of series
 */
export  class DragSettings extends base.ChildProperty<DragSettings> {
    /**
     * To enable the drag the points
     * @default false
     */
    enable: boolean;
    /**
     * To set the minimum y of the point
     * @default null
     */
    minY: number;
    /**
     * To set the maximum y of the point
     * @default null
     */
    maxY: number;
    /**
     * To set the color of the edited point
     * @default null
     */
    fill: string;
}
/**
 * Configures the ToolTips in the chart.
 * @public
 */
export  class TooltipSettings extends base.ChildProperty<TooltipSettings> {
    /**
     * Enables / Disables the visibility of the tooltip.
     * @default false.
     */
    enable: boolean;
    /**
     * Enables / Disables the visibility of the marker.
     * @default true.
     */
    enableMarker: boolean;
    /**
     * If set to true, a single ToolTip will be displayed for every index.
     * @default false.
     */
    shared: boolean;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    fill: string;
    /**
     * Header for tooltip.
     * @default null
     */
    header: string;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string.
     * @default 0.75
     */
    opacity: number;
    /**
     * Options to customize the ToolTip text.
     */
    textStyle: FontModel;
    /**
     * Format the ToolTip content.
     * @default null.
     */
    format: string;
    /**
     * Custom template to format the ToolTip content. Use ${x} and ${y} as the placeholder text to display the corresponding data point.
     * @default null.
     */
    template: string;
    /**
     * If set to true, ToolTip will animate while moving from one point to another.
     * @default true.
     */
    enableAnimation: boolean;
    /**
     * Options to customize tooltip borders.
     */
    border: BorderModel;
}
/**
 * button settings in period selector
 */
export  class Periods extends base.ChildProperty<Periods> {
    /**
     * IntervalType of button
     * @default 'Years'
     */
    intervalType: RangeIntervalType;
    /**
     * Count value for the button
     * @default 1
     */
    interval: number;
    /**
     * Text to be displayed on the button
     * @default null
     */
    text: string;
    /**
     * To select the default period
     * @default false
     */
    selected: boolean;
}
/**
 * Period Selector Settings
 */
export  class PeriodSelectorSettings extends base.ChildProperty<PeriodSelectorSettings> {
    /**
     * Height for the period selector
     * @default 43
     */
    height: number;
    /**
     * vertical position of the period selector
     * @default 'Bottom'
     */
    position: PeriodSelectorPosition;
    /**
     * Buttons
     */
    periods: PeriodsModel[];
}
//node_modules/@syncfusion/ej2-charts/src/common/model/constants.d.ts
/**
 * Specifies the chart constant value
 */
/** @private */
export  const loaded: string;
/** @private */
export  const legendClick: string;
/** @private */
export  const load: string;
/** @private */
export  const animationComplete: string;
/** @private */
export  const legendRender: string;
/** @private */
export  const textRender: string;
/** @private */
export  const pointRender: string;
/** @private */
export  const seriesRender: string;
/** @private */
export  const axisLabelRender: string;
/** @private */
export  const axisRangeCalculated: string;
/** @private */
export  const axisMultiLabelRender: string;
/** @private */
export  const tooltipRender: string;
/** @private */
export  const chartMouseMove: string;
/** @private */
export  const chartMouseClick: string;
/** @private */
export  const pointClick: string;
/** @private */
export  const pointMove: string;
/** @private */
export  const chartMouseLeave: string;
/** @private */
export  const chartMouseDown: string;
/** @private */
export  const chartMouseUp: string;
/** @private */
export  const zoomComplete: string;
/** @private */
export  const dragComplete: string;
/** @private */
export  const selectionComplete: string;
/** @private */
export  const resized: string;
/** @private */
export  const beforePrint: string;
/** @private */
export  const annotationRender: string;
/** @private */
export  const scrollStart: string;
/** @private */
export  const scrollEnd: string;
/** @private */
export  const scrollChanged: string;
/** @private */
export  const stockEventRender: string;
/** @private */
export  const multiLevelLabelClick: string;
/** @private */
export  const dragStart: string;
/** @private */
export  const drag: string;
/** @private */
export  const dragEnd: string;
//node_modules/@syncfusion/ej2-charts/src/common/model/data.d.ts
/**
 * data module is used to generate query and dataSource
 */
export  class Data {
    private dataManager;
    private query;
    /**
     * Constructor for data module
     * @private
     */
    constructor(dataSource?: Object | data.DataManager, query?: data.Query);
    /**
     * The function used to initialize dataManager and query
     * @return {void}
     * @private
     */
    initDataManager(dataSource: Object | data.DataManager, query: data.Query): void;
    /**
     * The function used to generate updated data.Query from chart model
     * @return {void}
     * @private
     */
    generateQuery(): data.Query;
    /**
     * The function used to get dataSource by executing given data.Query
     * @param  {data.Query} query - A data.Query that specifies to generate dataSource
     * @return {void}
     * @private
     */
    getData(query: data.Query): Promise<Object>;
}
//node_modules/@syncfusion/ej2-charts/src/common/model/interface.d.ts
export interface ISelectorRenderArgs {
    /** Defines the thumb size of the slider */
    thumbSize: number;
    /** Defines the selector appending element */
    element: HTMLElement;
    /** Defines the selector width */
    width: number;
    /** Defines the selector height */
    height: number;
}
/** @private */
export interface IFontMapping {
    size?: string;
    color?: string;
    fontWeight?: string;
    fontStyle?: string;
    fontFamily?: string;
    opacity?: number;
}
/** @private */
export interface IShapes {
    renderOption?: Object;
    functionName?: string;
}
/** @private */
/**
 * Specifies the Theme style for scrollbar.
 */
export interface IScrollbarThemeStyle {
    backRect: string;
    thumb: string;
    circle: string;
    circleHover: string;
    arrow: string;
    grip: string;
    arrowHover?: string;
    backRectBorder?: string;
}
export interface ILegendRegions {
    rect: svgBase.Rect;
    index: number;
}
/**
 * Period selector component interface
 * @private
 */
export interface IPeriodSelectorControl {
    /**
     * Element for the control
     */
    element: HTMLElement;
    /**
     * Series min value.
     */
    seriesXMin: number;
    /**
     * Series max value.
     */
    seriesXMax: number;
    /**
     * Start value for the axis.
     */
    startValue: number;
    /**
     * End value for the axis.
     */
    endValue: number;
    /**
     * Range slider instance.
     */
    rangeSlider: RangeSlider;
    /**
     * To disable the range selector.
     */
    disableRangeSelector: boolean;
    /**
     * To config period selector settings.
     */
    periods: PeriodsModel[];
    /**
     * Range navigator
     */
    rangeNavigatorControl: RangeNavigator;
}
//node_modules/@syncfusion/ej2-charts/src/common/model/theme.d.ts
/**
 * Specifies Chart Themes
 */
export  namespace Theme {
    /** @private */
    let axisLabelFont: IFontMapping;
    /** @private */
    let axisTitleFont: IFontMapping;
    /** @private */
    let chartTitleFont: IFontMapping;
    /** @private */
    let chartSubTitleFont: IFontMapping;
    /** @private */
    let crosshairLabelFont: IFontMapping;
    /** @private */
    let tooltipLabelFont: IFontMapping;
    /** @private */
    let legendLabelFont: IFontMapping;
    /** @private */
    let stripLineLabelFont: IFontMapping;
    /** @private */
    let stockEventFont: IFontMapping;
}
/** @private */
export  function getSeriesColor(theme: ChartTheme | AccumulationTheme): string[];
/** @private */
export  function getThemeColor(theme: ChartTheme | AccumulationTheme): IThemeStyle;
/** @private */
export  function getScrollbarThemeColor(theme: ChartTheme): IScrollbarThemeStyle;
//node_modules/@syncfusion/ej2-charts/src/common/period-selector/period-selector.d.ts
/**
 * Period selector class
 */
export  class PeriodSelector {
    periodSelectorSize: svgBase.Rect;
    periodSelectorDiv: Element;
    control: IPeriodSelectorControl;
    toolbar: navigations.Toolbar;
    datePicker: calendars.DateRangePicker;
    triggerChange: boolean;
    private nodes;
    calendarId: string;
    selectedIndex: number;
    datePickerTriggered: boolean;
    rootControl: StockChart | RangeNavigator;
    constructor(control: RangeNavigator | StockChart);
    /**
     * To set the control values
     * @param control
     */
    setControlValues(control: RangeNavigator | StockChart): void;
    /**
     *  To initialize the period selector properties
     */
    appendSelector(options: ISelectorRenderArgs, x?: number): void;
    /**
     * renderSelector div
     * @param control
     */
    renderSelectorElement(control?: RangeNavigator, options?: ISelectorRenderArgs, x?: number): void;
    /**
     * renderSelector elements
     */
    renderSelector(): void;
    private updateCustomElement;
    /**
     * To set and deselect the acrive style
     * @param buttons
     */
    private setSelectedStyle;
    /**
     * Button click handling
     */
    private buttonClick;
    /**
     *
     * @param type updatedRange for selector
     * @param end
     * @param interval
     */
    changedRange(type: RangeIntervalType, end: number, interval: number): Date;
    /**
     * Get module name
     */
    protected getModuleName(): string;
    /**
     * To destroy the period selector.
     * @return {void}
     * @private
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-charts/src/common/scrollbar/scrollbar-elements.d.ts
/**
 * Create scrollbar svg.
 * @return {void}
 */
export  function createScrollSvg(scrollbar: ScrollBar, renderer: svgBase.SvgRenderer): void;
/**
 * Scrollbar elements renderer
 */
export  class ScrollElements {
    /** @private */
    thumbRectX: number;
    /** @private */
    thumbRectWidth: number;
    /** @private */
    leftCircleEle: Element;
    /** @private */
    rightCircleEle: Element;
    /** @private */
    leftArrowEle: Element;
    /** @private */
    rightArrowEle: Element;
    /** @private */
    gripCircle: Element;
    /** @private */
    slider: Element;
    /** @private */
    chartId: string;
    /**
     * Constructor for scroll elements
     * @param scrollObj
     */
    constructor(chart: Chart);
    /**
     * Render scrollbar elements.
     * @return {void}
     * @private
     */
    renderElements(scroll: ScrollBar, renderer: svgBase.SvgRenderer): Element;
    /**
     * Method to render back rectangle of scrollbar
     * @param scroll
     */
    private backRect;
    /**
     * Method to render arrows
     * @param scroll
     */
    private arrows;
    /**
     * Methods to set the arrow width
     * @param thumbRectX
     * @param thumbRectWidth
     * @param height
     */
    setArrowDirection(thumbRectX: number, thumbRectWidth: number, height: number): void;
    /**
     * Method to render thumb
     * @param scroll
     * @param renderer
     * @param parent
     */
    thumb(scroll: ScrollBar, renderer: svgBase.SvgRenderer, parent: Element): void;
    /**
     *  Method to render circles
     * @param scroll
     * @param renderer
     * @param parent
     */
    private renderCircle;
    /**
     * Method to render grip elements
     * @param scroll
     * @param renderer
     * @param parent
     */
    private thumbGrip;
}
//node_modules/@syncfusion/ej2-charts/src/common/scrollbar/scrollbar.d.ts
/**
 * Scrollbar Base
 */
export  class ScrollBar {
    axis: Axis;
    component: Chart;
    zoomFactor: number;
    zoomPosition: number;
    svgObject: Element;
    width: number;
    height: number;
    /** @private */
    elements: Element[];
    /** @private */
    isVertical: boolean;
    /** @private */
    isThumbDrag: boolean;
    /** @private */
    mouseX: number;
    /** @private */
    mouseY: number;
    /** @private */
    startX: number;
    /** @private */
    scrollX: number;
    /** @private */
    scrollY: number;
    /** @private */
    animateDuration: number;
    /** @private */
    browserName: string;
    /** @private */
    isPointer: Boolean;
    /** @private */
    isScrollUI: boolean;
    /** @private */
    scrollbarThemeStyle: IScrollbarThemeStyle;
    /** @private */
    actualRange: number;
    /** @private */
    scrollRange: VisibleRangeModel;
    /** @private */
    isLazyLoad: boolean;
    /** @private */
    previousStart: number;
    /** @private */
    previousEnd: number;
    private scrollElements;
    private isResizeLeft;
    private isResizeRight;
    private previousXY;
    private previousWidth;
    private previousRectX;
    private mouseMoveListener;
    private mouseUpListener;
    private valueType;
    axes: Axis[];
    private startZoomPosition;
    private startZoomFactor;
    private startRange;
    private scrollStarted;
    private isScrollEnd;
    private isCustomHeight;
    /**
     * Constructor for creating scrollbar
     * @param component
     * @param axis
     */
    constructor(component: Chart, axis?: Axis);
    /**
     * To Mouse x and y position
     * @param e
     */
    private getMouseXY;
    /**
     * Method to bind events for scrollbar svg object
     * @param element
     */
    private wireEvents;
    /**
     * Method to remove events for srcollbar svg object
     * @param element
     */
    private unWireEvents;
    /**
     * Handles the mouse down on scrollbar
     * @param e
     */
    scrollMouseDown(e: PointerEvent): void;
    /**
     * To check the matched string
     * @param id
     * @param match
     */
    private isExist;
    /**
     * To check current poisition is within scrollbar region
     * @param currentX
     */
    private isWithIn;
    /**
     * Method to find move length of thumb
     * @param mouseXY
     * @param thumbX
     * @param circleRadius
     */
    private moveLength;
    /**
     * Method to calculate zoom factor and position
     * @param currentX
     * @param currentWidth
     */
    private setZoomFactorPosition;
    /**
     * Handles the mouse move on scrollbar
     * @param e
     */
    scrollMouseMove(e: PointerEvent): void;
    /**
     * Handles the mouse wheel on scrollbar
     * @param e
     */
    scrollMouseWheel(e: WheelEvent): void;
    /**
     * Handles the mouse up on scrollbar
     * @param e
     */
    scrollMouseUp(e: PointerEvent): void;
    calculateMouseWheelRange(scrollThumbX: number, scrollThumbWidth: number): IScrollEventArgs;
    /**
     * Range calculation for lazy loading
     */
    calculateLazyRange(scrollThumbX: number, scrollThumbWidth: number, thumbMove?: string): IScrollEventArgs;
    /**
     * Get start and end values
     */
    private getStartEnd;
    /**
     * To render scroll bar
     * @private
     */
    render(isScrollExist: boolean): Element;
    /**
     * Theming for scrollabr
     */
    private getTheme;
    /**
     * Method to remove existing scrollbar
     */
    removeScrollSvg(): void;
    /**
     * Method to set cursor fpr scrollbar
     * @param target
     */
    private setCursor;
    /**
     * Method to set theme for sollbar
     * @param target
     */
    private setTheme;
    /**
     * To check current axis
     * @param target
     * @param ele
     */
    private isCurrentAxis;
    /**
     * Method to resize thumb
     * @param e
     */
    private resizeThumb;
    /**
     * Method to position the scrollbar thumb
     * @param currentX
     * @param currentWidth
     */
    private positionThumb;
    /**
     * Method to get default values
     */
    private getDefaults;
    /**
     * Lazy load default values
     */
    getLazyDefaults(axis: Axis): void;
    /**
     * Method to get log range
     */
    getLogRange(axis: Axis): ScrollbarSettingsRangeModel;
    /**
     * Method for injecting scrollbar module
     * @param axis
     * @param component
     */
    injectTo(axis: Axis, component: Chart): void;
    /**
     * Method to destroy scrollbar
     */
    destroy(): void;
    /**
     * Method to get scrollbar module name
     */
    getModuleName(): string;
    private getArgs;
}
//node_modules/@syncfusion/ej2-charts/src/common/user-interaction/selection.d.ts
/**
 * Selection Module handles the selection for chart.
 * @private
 */
export  class BaseSelection {
    protected styleId: string;
    protected unselected: string;
    protected control: Chart | AccumulationChart;
    constructor(control: Chart | AccumulationChart);
    /**
     * To create selection styles for series
     */
    protected seriesStyles(): void;
    /**
     * To concat indexes
     */
    protected concatIndexes(userIndexes: IndexesModel[], localIndexes: Indexes[]): Indexes[];
    /**
     * Selected points series visibility checking on legend click
     */
    protected checkVisibility(selectedIndexes: Indexes[]): boolean;
    /**
     * To add svg element style class
     * @private
     */
    addSvgClass(element: Element, className: string): void;
    /**
     * To remove svg element style class
     * @private
     */
    removeSvgClass(element: Element, className: string): void;
    /**
     * To get children from parent element
     */
    protected getChildren(parent: Element): Element[];
}
//node_modules/@syncfusion/ej2-charts/src/common/user-interaction/tooltip.d.ts
/**
 * Tooltip Module used to render the tooltip for series.
 */
export  class BaseTooltip extends ChartData {
    element: HTMLElement;
    elementSize: svgBase.Size;
    textStyle: FontModel;
    isRemove: boolean;
    toolTipInterval: number;
    textElements: Element[];
    inverted: boolean;
    formattedText: string[];
    header: string;
    /** @private */
    valueX: number;
    /** @private */
    valueY: number;
    control: AccumulationChart | Chart;
    text: string[];
    svgTooltip: svgBase.Tooltip;
    headerText: string;
    /**
     * Constructor for tooltip module.
     * @private.
     */
    constructor(chart: Chart | AccumulationChart);
    getElement(id: string): HTMLElement;
    /**
     * Renders the tooltip.
     * @return {void}
     * @private
     */
    getTooltipElement(isTooltip: boolean): HTMLDivElement;
    createElement(): HTMLDivElement;
    pushData(data: PointData | AccPointData, isFirst: boolean, tooltipDiv: HTMLDivElement, isChart: boolean): boolean;
    removeHighlight(chart: Chart | AccumulationChart): void;
    highlightPoint(series: Series | AccumulationSeries, pointIndex: number, highlight: boolean): void;
    highlightPoints(): void;
    createTooltip(chart: Chart | AccumulationChart, isFirst: boolean, location: ChartLocation, clipLocation: ChartLocation, point: Points | AccPoints, shapes: ChartShape[], offset: number, bounds: svgBase.Rect, extraPoints?: PointData[], templatePoint?: Points | AccPoints): void;
    private findPalette;
    private findColor;
    updatePreviousPoint(extraPoints: PointData[]): void;
    fadeOut(data: PointData[], chart: Chart | AccumulationChart): void;
    removeHighlightedMarker(data: PointData[]): void;
    removeText(): void;
    stopAnimation(): void;
    /**
     * Removes the tooltip on mouse leave.
     * @return {void}
     * @private
     */
    removeTooltip(duration: number): void;
}
//node_modules/@syncfusion/ej2-charts/src/common/utils/enum.d.ts
/**
 * Defines Coordinate units of an annotation. They are
 * * Pixel
 * * Point
 */
export  type Units = 
/**  Specifies the pixel value */
'Pixel' | 
/**  Specifies the axis value. */
'Point';
/**
 * Defines the Alignment. They are
 * * near - Align the element to the left.
 * * center - Align the element to the center.
 * * far - Align the element to the right.
 * *
 */
export  type Alignment = 
/** Define the left alignment. */
'Near' | 
/** Define the center alignment. */
'Center' | 
/** Define the right alignment. */
'Far';
/** @private */
export  type SeriesCategories = 
/** Defines the trenline */
'TrendLine' | 
/** Defines the indicator */
'Indicator' | 
/** Defines the normal series */
'Series' | 
/** Defines the Pareto series */
'Pareto';
/**
 * Defines regions of an annotation. They are
 * * Chart
 * * Series
 */
export  type Regions = 
/**  Specifies the chart coordinates */
'Chart' | 
/**  Specifies the series coordinates */
'Series';
/**
 * Defines the Position. They are
 * * top - Align the element to the top.
 * * middle - Align the element to the center.
 * * bottom - Align the element to the bottom.
 * *
 */
export  type Position = 
/** Define the top position. */
'Top' | 
/** Define the middle position. */
'Middle' | 
/** Define the bottom position. */
'Bottom';
/**
 * Defines the export file format.
 * * PNG - export the image file format as png.
 * * JPEG - export the image file format as jpeg.
 */
export  type ExportType = 
/** Used to export a image as png format */
'PNG' | 
/** Used to export a image as jpeg format */
'JPEG' | 
/** Used to export a file as svg format */
'SVG' | 
/** Used to export a file as pdf format */
'PDF' | 
/** Used to print the chart */
'Print';
/**
 * Defines the Text overflow.
 * * None - Shown the chart title with overlap if exceed.
 * * Wrap - Shown the chart title with wrap if exceed.
 * * Trim - Shown the chart title with trim if exceed.
 */
export  type TextOverflow = 
/** Used to show the chart title with overlap to other element */
'None' | 
/** Used to show the chart title with Wrap support */
'Wrap' | 
/** Used to show the chart title with Trim */
'Trim';
/**
 * Defines the interval type of datetime axis. They are
 * * auto - Define the interval of the axis based on data.
 * * quarter - Define the interval of the axis based on data.
 * * years - Define the interval of the axis in years.
 * * months - Define the interval of the axis in months.
 * * weeks - Define the interval of the axis in weeks
 * * days - Define the interval of the axis in days.
 * * hours - Define the interval of the axis in hours.
 * * minutes - Define the interval of the axis in minutes.
 */
export  type RangeIntervalType = 
/** Define the interval of the axis based on data. */
'Auto' | 
/** Define the interval of the axis in years. */
'Years' | 
/** Define the interval of the axis based on quarter */
'Quarter' | 
/** Define the interval of the axis in months. */
'Months' | 
/** Define the intervl of the axis in weeks */
'Weeks' | 
/** Define the interval of the axis in days. */
'Days' | 
/** Define the interval of the axis in hours. */
'Hours' | 
/** Define the interval of the axis in minutes. */
'Minutes' | 
/** Define the interval of the axis in seconds. */
'Seconds';
/**
 * Period selector position
 * *Top
 * *Bottom
 */
export  type PeriodSelectorPosition = 
/** Top position */
'Top' | 
/** Bottom position */
'Bottom';
/**
 * Flag type for stock events
 */
export  type FlagType = 
/** Circle  */
'Circle' | 
/** Square */
'Square' | 
/** Flag */
'Flag' | 
/** Pin type flags */
'Pin' | 
/** Triangle Up */
'Triangle' | 
/** Triangle Down */
'InvertedTriangle' | 
/** Triangle Right */
'TriangleRight' | 
/** Triangle Left */
'TriangleLeft' | 
/** Arrow Up */
'ArrowUp' | 
/** Arrow down */
'ArrowDown' | 
/** Arrow Left */
'ArrowLeft' | 
/** Arrow right */
'ArrowRight' | 
/** Text type */
'Text';
//node_modules/@syncfusion/ej2-charts/src/common/utils/export.d.ts
export  class ExportUtils {
    private control;
    private printWindow;
    /**
     * Constructor for chart and accumulation annotation
     * @param control
     */
    constructor(control: Chart | AccumulationChart | RangeNavigator | StockChart);
    /**
     * To print the accumulation and chart elements
     * @param elements
     */
    print(elements?: string[] | string | Element): void;
    /**
     * To get the html string of the chart and accumulation
     * @param elements
     * @private
     */
    getHTMLContent(elements?: string[] | string | Element): Element;
    /**
     * To export the file as image/svg format
     * @param type
     * @param fileName
     */
    export(type: ExportType, fileName: string, orientation?: pdfExport.PdfPageOrientation, controls?: (Chart | AccumulationChart | RangeNavigator | StockChart)[], width?: number, height?: number, isVertical?: boolean): void;
    /**
     * To trigger the download element
     * @param fileName
     * @param type
     * @param url
     */
    triggerDownload(fileName: string, type: ExportType, url: string, isDownload: boolean): void;
    /**
     * To get the maximum size value
     * @param controls
     * @param name
     */
    private getControlsValue;
    private createCanvas;
    /**
     * To convert svg chart into canvas chart to fix export issue in IE
     * We cant export svg to other formats in IE
     */
    private canvasRender;
    private exportPdf;
    private doexport;
    private exportImage;
}
//node_modules/@syncfusion/ej2-charts/src/common/utils/helper.d.ts
/**
 * Function to sort the dataSource, by default it sort the data in ascending order.
 * @param  {Object} data
 * @param  {string} fields
 * @param  {boolean} isDescending
 * @returns Object
 */
export  function sort(data: Object[], fields: string[], isDescending?: boolean): Object[];
/** @private */
export  function isBreakLabel(label: string): boolean;
/** @private */
export  function rotateTextSize(font: FontModel, text: string, angle: number, chart: Chart): svgBase.Size;
/** @private */
export  function removeElement(id: string | Element): void;
/** @private */
export  function logBase(value: number, base: number): number;
/** @private */
export  function showTooltip(text: string, x: number, y: number, areaWidth: number, id: string, element: Element, isTouch?: boolean): void;
/** @private */
export  function inside(value: number, range: VisibleRangeModel): boolean;
/** @private */
export  function withIn(value: number, range: VisibleRangeModel): boolean;
/** @private */
export  function logWithIn(value: number, axis: Axis): number;
/** @private */
export  function withInRange(previousPoint: Points, currentPoint: Points, nextPoint: Points, series: Series): boolean;
/** @private */
export  function sum(values: number[]): number;
/** @private */
export  function subArraySum(values: Object[], first: number, last: number, index: number[], series: Series): number;
/** @private */
export  function subtractThickness(rect: svgBase.Rect, thickness: Thickness): svgBase.Rect;
/** @private */
export  function subtractRect(rect: svgBase.Rect, thickness: svgBase.Rect): svgBase.Rect;
/** @private */
export  function degreeToLocation(degree: number, radius: number, center: ChartLocation): ChartLocation;
/** @private */
export  function getAngle(center: ChartLocation, point: ChartLocation): number;
/** @private */
export  function subArray(values: number[], index: number): number[];
/** @private */
export  function valueToCoefficient(value: number, axis: Axis): number;
/** @private */
export  function TransformToVisible(x: number, y: number, xAxis: Axis, yAxis: Axis, isInverted?: boolean, series?: Series): ChartLocation;
/**
 * method to find series, point index by element id
 * @private
 */
export  function indexFinder(id: string, isPoint?: boolean): Index;
/** @private */
export  function CoefficientToVector(coefficient: number, startAngle: number): ChartLocation;
/** @private */
export  function valueToPolarCoefficient(value: number, axis: Axis): number;
/** @private */
export  class Mean {
    verticalStandardMean: number;
    horizontalStandardMean: number;
    verticalSquareRoot: number;
    horizontalSquareRoot: number;
    verticalMean: number;
    horizontalMean: number;
    constructor(verticalStandardMean: number, verticalSquareRoot: number, horizontalStandardMean: number, horizontalSquareRoot: number, verticalMean: number, horizontalMean: number);
}
/** @private */
export  class PolarArc {
    startAngle: number;
    endAngle: number;
    innerRadius: number;
    radius: number;
    currentXPosition: number;
    constructor(startAngle?: number, endAngle?: number, innerRadius?: number, radius?: number, currentXPosition?: number);
}
/** @private */
export  function createTooltip(id: string, text: string, top: number, left: number, fontSize: string): void;
/** @private */
export  function createZoomingLabels(chart: Chart, axis: Axis, parent: Element, index: number, isVertical: boolean, rect: svgBase.Rect): Element;
/** @private */
export  function withInBounds(x: number, y: number, bounds: svgBase.Rect, width?: number, height?: number): boolean;
/** @private */
export  function getValueXByPoint(value: number, size: number, axis: Axis): number;
/** @private */
export  function getValueYByPoint(value: number, size: number, axis: Axis): number;
/** @private */
export  function findClipRect(series: Series): void;
/** @private */
export  function firstToLowerCase(str: string): string;
/** @private */
export  function getTransform(xAxis: Axis, yAxis: Axis, invertedAxis: boolean): svgBase.Rect;
/** @private */
export  function getMinPointsDelta(axis: Axis, seriesCollection: Series[]): number;
/** @private */
export  function getAnimationFunction(effect: string): Function;
/**
 * Animation base.Effect Calculation Started Here
 * @param currentTime
 * @param startValue
 * @param endValue
 * @param duration
 * @private
 */
export  function linear(currentTime: number, startValue: number, endValue: number, duration: number): number;
/**
 * Animation base.Effect Calculation End
 * @private
 */
export  function markerAnimate(element: Element, delay: number, duration: number, series: Series | AccumulationSeries, pointIndex: number, point: ChartLocation, isLabel: boolean): void;
/**
 * Animate the rect element
 */
export  function animateRectElement(element: Element, delay: number, duration: number, currentRect: svgBase.Rect, previousRect: svgBase.Rect): void;
/**
 * Animation after legend click a path
 * @param element element to be animated
 * @param direction current direction of the path
 * @param previousDirection previous direction of the path
 */
export  function pathAnimation(element: Element, direction: string, redraw: boolean, previousDirection?: string, animateDuration?: number): void;
/**
 * To append the clip rect element
 * @param redraw
 * @param options
 * @param renderer
 * @param clipPath
 */
export  function appendClipElement(redraw: boolean, options: svgBase.BaseAttibutes, renderer: svgBase.SvgRenderer, clipPath?: string): Element;
/**
 * Triggers the event.
 * @return {void}
 * @private
 */
export  function triggerLabelRender(chart: Chart | RangeNavigator, tempInterval: number, text: string, labelStyle: FontModel, axis: Axis): void;
/**
 * The function used to find whether the range is set.
 * @return {boolean}
 * @private
 */
export  function setRange(axis: Axis): boolean;
/**
 * Calculate desired interval for the axis.
 * @return {void}
 * @private
 */
export  function getActualDesiredIntervalsCount(availableSize: svgBase.Size, axis: Axis): number;
/**
 * Animation for template
 * @private
 */
export  function templateAnimate(element: Element, delay: number, duration: number, name: base.Effect, isRemove?: boolean): void;
/** @private */
export  function drawSymbol(location: ChartLocation, shape: string, size: svgBase.Size, url: string, options: svgBase.PathOption, label: string, renderer?: svgBase.SvgRenderer | svgBase.CanvasRenderer, clipRect?: svgBase.Rect): Element;
/** @private */
export  function calculateShapes(location: ChartLocation, size: svgBase.Size, shape: string, options: svgBase.PathOption, url: string): IShapes;
/** @private */
export  function getRectLocation(startLocation: ChartLocation, endLocation: ChartLocation, outerRect: svgBase.Rect): svgBase.Rect;
/** @private */
export  function minMax(value: number, min: number, max: number): number;
/** @private */
export  function getElement(id: string): Element;
/** @private */
export  function getTemplateFunction(template: string): Function;
/** @private */
export  function createTemplate(childElement: HTMLElement, pointIndex: number, content: string, chart: Chart | AccumulationChart | RangeNavigator, point?: Points | AccPoints, series?: Series | AccumulationSeries): HTMLElement;
/** @private */
export  function getFontStyle(font: FontModel): string;
/** @private */
export  function measureElementRect(element: HTMLElement, redraw?: boolean): ClientRect;
/** @private */
export  function findlElement(elements: NodeList, id: string): Element;
/** @private */
export  function getPoint(x: number, y: number, xAxis: Axis, yAxis: Axis, isInverted?: boolean, series?: Series): ChartLocation;
/** @private */
export  function appendElement(child: Element, parent: Element, redraw?: boolean, animate?: boolean, x?: string, y?: string): void;
/**
 * Method to append child element
 * @param parent
 * @param childElement
 * @param isReplace
 */
export  function appendChildElement(isCanvas: boolean, parent: Element | HTMLElement, childElement: Element | HTMLElement, redraw?: boolean, isAnimate?: boolean, x?: string, y?: string, start?: ChartLocation, direction?: string, forceAnimate?: boolean, isRect?: boolean, previousRect?: svgBase.Rect, animateDuration?: number): void;
/** @private */
export  function getDraggedRectLocation(x1: number, y1: number, x2: number, y2: number, outerRect: svgBase.Rect): svgBase.Rect;
/** @private */
export  function checkBounds(start: number, size: number, min: number, max: number): number;
/** @private */
export  function getLabelText(currentPoint: Points, series: Series, chart: Chart): string[];
/** @private */
export  function stopTimer(timer: number): void;
/** @private */
export  function isCollide(rect: svgBase.Rect, collections: svgBase.Rect[], clipRect: svgBase.Rect): boolean;
/** @private */
export  function isOverlap(currentRect: svgBase.Rect, rect: svgBase.Rect): boolean;
/** @private */
export  function containsRect(currentRect: svgBase.Rect, rect: svgBase.Rect): boolean;
/** @private */
export  function calculateRect(location: ChartLocation, textSize: svgBase.Size, margin: MarginModel): svgBase.Rect;
/** @private */
export  function convertToHexCode(value: ColorValue): string;
/** @private */
export  function componentToHex(value: number): string;
/** @private */
export  function convertHexToColor(hex: string): ColorValue;
/** @private */
export  function colorNameToHex(color: string): string;
/** @private */
export  function getSaturationColor(color: string, factor: number): string;
/** @private */
export  function getMedian(values: number[]): number;
/** @private */
export  function calculateLegendShapes(location: ChartLocation, size: svgBase.Size, shape: string, options: svgBase.PathOption): IShapes;
/** @private */
export  function textTrim(maxWidth: number, text: string, font: FontModel): string;
/**
 * To trim the line break label
 * @param maxWidth
 * @param text
 * @param font
 */
export  function lineBreakLabelTrim(maxWidth: number, text: string, font: FontModel): string[];
/** @private */
export  function stringToNumber(value: string, containerSize: number): number;
/** @private */
export  function redrawElement(redraw: boolean, id: string, options?: svgBase.PathAttributes | svgBase.RectAttributes | svgBase.CircleAttributes, renderer?: svgBase.SvgRenderer | svgBase.CanvasRenderer): Element;
/** @private */
export  function animateRedrawElement(element: Element | HTMLElement, duration: number, start: ChartLocation, end: ChartLocation, x?: string, y?: string): void;
/** @private */
export  function textElement(renderer: svgBase.SvgRenderer | svgBase.CanvasRenderer, option: svgBase.TextOption, font: FontModel, color: string, parent: HTMLElement | Element, isMinus?: boolean, redraw?: boolean, isAnimate?: boolean, forceAnimate?: boolean, animateDuration?: number, seriesClipRect?: svgBase.Rect): Element;
/**
 * Method to calculate the width and height of the chart
 */
export  function calculateSize(chart: Chart | AccumulationChart | RangeNavigator | StockChart): void;
export  function createSvg(chart: Chart | AccumulationChart | RangeNavigator): void;
/**
 * To calculate chart title and height
 * @param title
 * @param style
 * @param width
 */
export  function getTitle(title: string, style: FontModel, width: number): string[];
/**
 * Method to calculate x position of title
 */
export  function titlePositionX(rect: svgBase.Rect, titleStyle: FontModel): number;
/**
 * Method to find new text and element size based on textOverflow
 */
export  function textWrap(currentLabel: string, maximumWidth: number, font: FontModel): string[];
/**
 * Method to reset the blazor templates
 */
export  function blazorTemplatesReset(control: Chart | AccumulationChart): void;
/** @private */
export  class CustomizeOption {
    id: string;
    constructor(id?: string);
}
/** @private */
export  class StackValues {
    startValues?: number[];
    endValues?: number[];
    constructor(startValue?: number[], endValue?: number[]);
}
/** @private */
export  class RectOption extends svgBase.PathOption {
    x: number;
    y: number;
    height: number;
    width: number;
    rx: number;
    ry: number;
    transform: string;
    constructor(id: string, fill: string, border: BorderModel, opacity: number, rect: svgBase.Rect, rx?: number, ry?: number, transform?: string, dashArray?: string);
}
/** @private */
export  class CircleOption extends svgBase.PathOption {
    cy: number;
    cx: number;
    r: number;
    constructor(id: string, fill: string, border: BorderModel, opacity: number, cx: number, cy: number, r: number);
}
/** @private */
export  class PolygonOption {
    id: string;
    points: string;
    fill: string;
    constructor(id: string, points: string, fill: string);
}
/** @private */
export  class ChartLocation {
    x: number;
    y: number;
    constructor(x: number, y: number);
}
/** @private */
export  class Thickness {
    left: number;
    right: number;
    top: number;
    bottom: number;
    constructor(left: number, right: number, top: number, bottom: number);
}
/** @private */
export  class ColorValue {
    r: number;
    g: number;
    b: number;
    constructor(r?: number, g?: number, b?: number);
}
/** @private */
export  class PointData {
    point: Points;
    series: Series;
    lierIndex: number;
    constructor(point: Points, series: Series, index?: number);
}
/** @private */
export  class AccPointData {
    point: AccPoints;
    series: AccumulationSeries;
    constructor(point: AccPoints, series: AccumulationSeries, index?: number);
}
/** @private */
export  class ControlPoints {
    controlPoint1: ChartLocation;
    controlPoint2: ChartLocation;
    constructor(controlPoint1: ChartLocation, controlPoint2: ChartLocation);
}
/** @private */
export interface IHistogramValues {
    sDValue?: number;
    mean?: number;
    binWidth?: number;
    yValues?: number[];
}
//node_modules/@syncfusion/ej2-charts/src/components.d.ts
/**
 * Export Chart, Accumulation, Smithchart, Sparkline and Range Navigator
 */
//node_modules/@syncfusion/ej2-charts/src/index.d.ts
/**
 * Chart components exported.
 */
//node_modules/@syncfusion/ej2-charts/src/range-navigator/index.d.ts
/**
 * Range Navigator component export methods
 */
//node_modules/@syncfusion/ej2-charts/src/range-navigator/model/range-base-model.d.ts
/**
 * Interface for a class RangeNavigatorSeries
 */
export interface RangeNavigatorSeriesModel {
    /**
     * It defines the data source for a series.
     * @default null
     */
    dataSource?: Object | data.DataManager;
    /**
     * It defines the xName for the series
     * @default null
     */
    xName?: string;
    /**
     * It defines the yName for the series
     * @default  null
     */
    yName?: string;
    /**
     * It defines the query for the data source
     * @default null
     */
    query?: data.Query;
    /**
     * It defines the series type of the range navigator
     * @default 'Line'
     */
    type?: RangeNavigatorType;
    /**
     * Options to customizing animation for the series.
     */
    animation?: AnimationModel;
    /**
     * Options for customizing the color and width of the series border.
     */
    border?: BorderModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill?: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width?: number;
    /**
     * The opacity for the background.
     * @default 1
     */
    opacity?: number;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray?: string;
}
/**
 * Interface for a class ThumbSettings
 */
export interface ThumbSettingsModel {
    /**
     * width of thumb
     * @default null
     * @aspDefaultValueIgnore
     */
    width?: number;
    /**
     * height of thumb
     * @default null
     * @aspDefaultValueIgnore
     */
    height?: number;
    /**
     * border for the thumb
     */
    border?: BorderModel;
    /**
     * fill color for the thumb
     * @default null
     */
    fill?: string;
    /**
     * type of thumb
     * @default `Circle`
     */
    type?: ThumbType;
}
/**
 * Interface for a class StyleSettings
 */
export interface StyleSettingsModel {
    /**
     * thumb settings
     */
    thumb?: ThumbSettingsModel;
    /**
     * Selected region color
     * @default null
     */
    selectedRegionColor?: string;
    /**
     * Un Selected region color
     * @default null
     */
    unselectedRegionColor?: string;
}
/**
 * Interface for a class RangeTooltipSettings
 */
export interface RangeTooltipSettingsModel {
    /**
     * Enables / Disables the visibility of the tooltip.
     * @default false.
     */
    enable?: boolean;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string. 
     * @default 0.85
     */
    opacity?: number;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string. 
     * @default null
     */
    fill?: string;
    /**
     * Format the ToolTip content.
     * @default null.
     */
    format?: string;
    /**
     * Options to customize the ToolTip text.
     */
    textStyle?: FontModel;
    /**
     * Custom template to format the ToolTip content. Use ${value} as the placeholder text to display the corresponding data point.
     * @default null.
     */
    template?: string;
    /**
     * Options to customize tooltip borders.
     */
    border?: BorderModel;
    /**
     * It defines display mode for tooltip
     * @default 'OnDemand'
     */
    displayMode?: TooltipDisplayMode;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/model/range-base.d.ts
/**
 * Series class for the range navigator
 */
export  class RangeNavigatorSeries extends base.ChildProperty<RangeNavigatorSeries> {
    /**
     * It defines the data source for a series.
     * @default null
     */
    dataSource: Object | data.DataManager;
    /**
     * It defines the xName for the series
     * @default null
     */
    xName: string;
    /**
     * It defines the yName for the series
     * @default  null
     */
    yName: string;
    /**
     * It defines the query for the data source
     * @default null
     */
    query: data.Query;
    /**
     * It defines the series type of the range navigator
     * @default 'Line'
     */
    type: RangeNavigatorType;
    /**
     * Options to customizing animation for the series.
     */
    animation: AnimationModel;
    /**
     * Options for customizing the color and width of the series border.
     */
    border: BorderModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width: number;
    /**
     * The opacity for the background.
     * @default 1
     */
    opacity: number;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray: string;
    /** @private */
    seriesElement: Element;
    /** @private */
    clipRectElement: Element;
    /** @private */
    clipRect: svgBase.Rect;
    /** @private */
    xAxis: Axis;
    /** @private */
    yAxis: Axis;
    /** @private */
    points: DataPoint[];
    /** @private */
    interior: string;
    /** @private */
    index: number;
    /** @private */
    chart: RangeNavigator;
}
/**
 * Thumb settings
 */
export  class ThumbSettings extends base.ChildProperty<ThumbSettings> {
    /**
     * width of thumb
     * @default null
     * @aspDefaultValueIgnore
     */
    width: number;
    /**
     * height of thumb
     * @default null
     * @aspDefaultValueIgnore
     */
    height: number;
    /**
     * border for the thumb
     */
    border: BorderModel;
    /**
     * fill color for the thumb
     * @default null
     */
    fill: string;
    /**
     * type of thumb
     * @default `Circle`
     */
    type: ThumbType;
}
/**
 * Style settings
 */
export  class StyleSettings extends base.ChildProperty<StyleSettings> {
    /**
     * thumb settings
     */
    thumb: ThumbSettingsModel;
    /**
     * Selected region color
     * @default null
     */
    selectedRegionColor: string;
    /**
     * Un Selected region color
     * @default null
     */
    unselectedRegionColor: string;
}
export  class RangeTooltipSettings extends base.ChildProperty<RangeTooltipSettings> {
    /**
     * Enables / Disables the visibility of the tooltip.
     * @default false.
     */
    enable: boolean;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string.
     * @default 0.85
     */
    opacity: number;
    /**
     * The fill color of the tooltip that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    fill: string;
    /**
     * Format the ToolTip content.
     * @default null.
     */
    format: string;
    /**
     * Options to customize the ToolTip text.
     */
    textStyle: FontModel;
    /**
     * Custom template to format the ToolTip content. Use ${value} as the placeholder text to display the corresponding data point.
     * @default null.
     */
    template: string;
    /**
     * Options to customize tooltip borders.
     */
    border: BorderModel;
    /**
     * It defines display mode for tooltip
     * @default 'OnDemand'
     */
    displayMode: TooltipDisplayMode;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/model/range-navigator-interface.d.ts
/**
 * Interface for range navigator
 */
/**
 * interface for load event
 */
export interface ILoadEventArgs {
    /** name of the event */
    name: string;
    /** rangeNavigator */
    rangeNavigator: RangeNavigator;
}
/**
 * interface for loaded event
 */
export interface IRangeLoadedEventArgs {
    /** name of the event */
    name: string;
    /** rangeNavigator */
    rangeNavigator: RangeNavigator;
}
export interface IRangeTooltipRenderEventArgs extends IRangeEventArgs {
    /** Defines tooltip text collections */
    text?: string[];
    /** Defines tooltip text style */
    textStyle?: FontModel;
}
/**
 * Interface for label render event
 */
export interface ILabelRenderEventsArgs {
    /** name of the event */
    name: string;
    /** labelStyle */
    labelStyle: FontModel;
    /** region */
    region: svgBase.Rect;
    /** text  */
    text: string;
    /** cancel for the event */
    cancel: boolean;
    /** value */
    value: number;
}
/**
 * Interface for Theme Style
 */
export interface IRangeStyle {
    gridLineColor: string;
    axisLineColor: string;
    labelFontColor: string;
    unselectedRectColor: string;
    thumpLineColor: string;
    thumbBackground: string;
    thumbHoverColor: string;
    gripColor: string;
    selectedRegionColor: string;
    background: string;
    tooltipBackground: string;
    tooltipFontColor: string;
    thumbWidth: number;
    thumbHeight: number;
}
/**
 * Interface for range events
 */
export interface IRangeEventArgs {
    /** Defines the name of the event */
    name: string;
    /** Defined the whether event has to trigger */
    cancel: boolean;
}
/**
 * Interface for changed events
 */
export interface IChangedEventArgs extends IRangeEventArgs {
    /** Defines the start value */
    start: number | Date;
    /** Defines the end value */
    end: number | Date;
    /** Defines the selected data */
    selectedData: DataPoint[];
    /** Defined the zoomPosition of the range navigator */
    zoomPosition: number;
    /** Defined the zoomFactor of the range navigator */
    zoomFactor: number;
}
export interface IResizeRangeNavigatorEventArgs {
    /** Defines the name of the Event */
    name: string;
    /** Defines the previous size of the accumulation chart */
    previousSize: svgBase.Size;
    /** Defines the current size of the accumulation chart */
    currentSize: svgBase.Size;
    /** Defines the range navigator instance */
    rangeNavigator: RangeNavigator;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/range-navigator-model.d.ts
/**
 * Interface for a class RangeNavigator
 */
export interface RangeNavigatorModel extends base.ComponentModel{
    /**
     * The width of the range navigator as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, range navigator renders to the full width of its parent element.
     * @default null
     * @aspDefaultValueIgnore
     */
    width?: string;
    /**
     * The height of the chart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, range navigator renders to the full height of its parent element.
     * @default null
     * @aspDefaultValueIgnore
     */
    height?: string;
    /**
     * It defines the data source for a range navigator.
     * @default null
     */
    dataSource?: Object | data.DataManager;
    /**
     * It defines the xName for the range navigator.
     * @default null
     */
    xName?: string;
    /**
     * It defines the yName for the range navigator.
     * @default null
     */
    yName?: string;
    /**
     * It defines the query for the data source.
     * @default null
     */
    query?: data.Query;
    /**
     * It defines the configuration of series in the range navigator
     */
    series?: RangeNavigatorSeriesModel[];
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip?: RangeTooltipSettingsModel;
    /**
     * Minimum value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    minimum?: number | Date;
    /**
     * Maximum value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    maximum?: number | Date;
    /**
     * interval value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    interval?: number;
    /**
     * IntervalType for the dateTime axis
     * @default 'Auto'
     */
    intervalType?: RangeIntervalType;
    /**
     * Specifies, when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * @default Hide
     */
    labelIntersectAction?: RangeLabelIntersectAction;
    /**
     * base value for log axis
     * @default 10
     */
    logBase?: number;
    /**
     * ValueType for the axis
     * @default 'Double'
     */
    valueType?: RangeValueType;
    /**
     * Label positions for the axis
     * @default 'Outside'
     */
    labelPosition?: AxisPosition;
    /**
     * Duration of the animation
     * @default 500
     */
    animationDuration?: number;
    /**
     * Enable grouping for the labels
     * @default false
     */
    enableGrouping?: boolean;
    /**
     * Enable deferred update for the range navigator
     * @default false
     */
    enableDeferredUpdate?: boolean;
    /**
     * To render the period selector with out range navigator.
     * @default false
     */
    disableRangeSelector?: boolean;
    /**
     * Enable snapping for range navigator sliders
     * @default false
     */
    allowSnapping?: boolean;
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator?: boolean;
    /**
     * GroupBy property for the axis
     * @default `Auto`
     */
    groupBy?: RangeIntervalType;
    /**
     * Tick Position for the axis
     * @default 'Outside'
     */
    tickPosition?: AxisPosition;
    /**
     * Label style for the labels
     */
    labelStyle?: FontModel;
    /**
     * MajorGridLines
     */
    majorGridLines?: MajorGridLinesModel;
    /**
     * MajorTickLines
     */
    majorTickLines?: MajorTickLinesModel;
    /**
     * Navigator style settings
     */
    navigatorStyleSettings?: StyleSettingsModel;
    /**
     * Period selector settings
     */
    periodSelectorSettings?: PeriodSelectorSettingsModel;
    /**
     * Options for customizing the color and width of the chart border.
     */
    navigatorBorder?: BorderModel;
    /**
     * Specifies the theme for the range navigator.
     * @default 'Material'
     */
    theme?: ChartTheme;
    /**
     * Selected range for range navigator.
     * @default []
     */
    value?: number[] | Date[];
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat?: string;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton?: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType?: SkeletonType;
    /**
     * It specifies the label alignment for secondary axis labels
     * @default 'Middle'
     */
    secondaryLabelAlignment?: LabelAlignment;
    /**
     * Margin for the range navigator
     * @default
     */
    margin?: MarginModel;
    /**
     * Triggers before the range navigator rendering
     * @event
     * @deprecated
     */
    load?: base.EmitType<IRangeLoadedEventArgs>;
    /**
     * Triggers after the range navigator rendering
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<IRangeLoadedEventArgs>;
    /**
     * Triggers after the range navigator resized
     * @event
     * @blazorProperty 'Resized'
     */
    resized?: base.EmitType<IResizeRangeNavigatorEventArgs>;
    /**
     * Triggers before the label rendering
     * @event
     * @deprecated
     */
    labelRender?: base.EmitType<ILabelRenderEventsArgs>;
    /**
     * Triggers after change the slider.
     * @event
     * @blazorProperty 'Changed'
     */
    changed?: base.EmitType<IChangedEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     * @deprecated
     */
    tooltipRender?: base.EmitType<IRangeTooltipRenderEventArgs>;
    /**
     * Triggers before the range navigator selector rendering
     * @event
     * @deprecated
     */
    selectorRender?: base.EmitType<IRangeSelectorRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint?: base.EmitType<IPrintEventArgs>;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/range-navigator.d.ts
/**
 * Range Navigator
 */
export  class RangeNavigator extends base.Component<HTMLElement> {
    /**
     * `lineSeriesModule` is used to add line series to the chart.
     */
    lineSeriesModule: LineSeries;
    /**
     * `areaSeriesModule` is used to add area series in the chart.
     */
    areaSeriesModule: AreaSeries;
    /**
     * `stepLineSeriesModule` is used to add stepLine series in the chart.
     */
    stepLineSeriesModule: StepLineSeries;
    /**
     * `datetimeModule` is used to manipulate and add dateTime axis to the chart.
     */
    dateTimeModule: DateTime;
    /**
     * `doubleModule` is used to manipulate and add double axis to the chart.
     */
    doubleModule: Double;
    /**
     * `logarithmicModule` is used to manipulate and add log axis to the chart.
     */
    logarithmicModule: Logarithmic;
    /**
     * `tooltipModule` is used to manipulate and add tooltip to the series.
     */
    rangeTooltipModule: RangeTooltip;
    /**
     * `periodSelectorModule` is used to add period selector un range navigator
     */
    periodSelectorModule: PeriodSelector;
    /**
     * The width of the range navigator as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, range navigator renders to the full width of its parent element.
     * @default null
     * @aspDefaultValueIgnore
     */
    width: string;
    /**
     * The height of the chart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, range navigator renders to the full height of its parent element.
     * @default null
     * @aspDefaultValueIgnore
     */
    height: string;
    /**
     * It defines the data source for a range navigator.
     * @default null
     */
    dataSource: Object | data.DataManager;
    /**
     * It defines the xName for the range navigator.
     * @default null
     */
    xName: string;
    /**
     * It defines the yName for the range navigator.
     * @default null
     */
    yName: string;
    /**
     * It defines the query for the data source.
     * @default null
     */
    query: data.Query;
    /**
     * It defines the configuration of series in the range navigator
     */
    series: RangeNavigatorSeriesModel[];
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip: RangeTooltipSettingsModel;
    /**
     * Minimum value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    minimum: number | Date;
    /**
     * Maximum value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    maximum: number | Date;
    /**
     * interval value for the axis
     * @default null
     * @aspDefaultValueIgnore
     */
    interval: number;
    /**
     * IntervalType for the dateTime axis
     * @default 'Auto'
     */
    intervalType: RangeIntervalType;
    /**
     * Specifies, when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * @default Hide
     */
    labelIntersectAction: RangeLabelIntersectAction;
    /**
     * base value for log axis
     * @default 10
     */
    logBase: number;
    /**
     * ValueType for the axis
     * @default 'Double'
     */
    valueType: RangeValueType;
    /**
     * Label positions for the axis
     * @default 'Outside'
     */
    labelPosition: AxisPosition;
    /**
     * Duration of the animation
     * @default 500
     */
    animationDuration: number;
    /**
     * Enable grouping for the labels
     * @default false
     */
    enableGrouping: boolean;
    /**
     * Enable deferred update for the range navigator
     * @default false
     */
    enableDeferredUpdate: boolean;
    /**
     * To render the period selector with out range navigator.
     * @default false
     */
    disableRangeSelector: boolean;
    /**
     * Enable snapping for range navigator sliders
     * @default false
     */
    allowSnapping: boolean;
    /**
     * Specifies whether a grouping separator should be used for a number.
     * @default false
     */
    useGroupingSeparator: boolean;
    /**
     * GroupBy property for the axis
     * @default `Auto`
     */
    groupBy: RangeIntervalType;
    /**
     * Tick Position for the axis
     * @default 'Outside'
     */
    tickPosition: AxisPosition;
    /**
     * Label style for the labels
     */
    labelStyle: FontModel;
    /**
     * MajorGridLines
     */
    majorGridLines: MajorGridLinesModel;
    /**
     * MajorTickLines
     */
    majorTickLines: MajorTickLinesModel;
    /**
     * Navigator style settings
     */
    navigatorStyleSettings: StyleSettingsModel;
    /**
     * Period selector settings
     */
    periodSelectorSettings: PeriodSelectorSettingsModel;
    /**
     * Options for customizing the color and width of the chart border.
     */
    navigatorBorder: BorderModel;
    /**
     * Specifies the theme for the range navigator.
     * @default 'Material'
     */
    theme: ChartTheme;
    /**
     * Selected range for range navigator.
     * @default []
     */
    value: number[] | Date[];
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat: string;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType: SkeletonType;
    /**
     * It specifies the label alignment for secondary axis labels
     * @default 'Middle'
     */
    secondaryLabelAlignment: LabelAlignment;
    /**
     * Margin for the range navigator
     * @default
     */
    margin: MarginModel;
    /** @private */
    themeStyle: IRangeStyle;
    /**
     * Triggers before the range navigator rendering
     * @event
     * @deprecated
     */
    load: base.EmitType<IRangeLoadedEventArgs>;
    /**
     * Triggers after the range navigator rendering
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<IRangeLoadedEventArgs>;
    /**
     * Triggers after the range navigator resized
     * @event
     * @blazorProperty 'Resized'
     */
    resized: base.EmitType<IResizeRangeNavigatorEventArgs>;
    /**
     * Triggers before the label rendering
     * @event
     * @deprecated
     */
    labelRender: base.EmitType<ILabelRenderEventsArgs>;
    /**
     * Triggers after change the slider.
     * @event
     * @blazorProperty 'Changed'
     */
    changed: base.EmitType<IChangedEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     * @deprecated
     */
    tooltipRender: base.EmitType<IRangeTooltipRenderEventArgs>;
    /**
     * Triggers before the range navigator selector rendering
     * @event
     * @deprecated
     */
    selectorRender: base.EmitType<IRangeSelectorRenderEventArgs>;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint: base.EmitType<IPrintEventArgs>;
    /** @private */
    renderer: svgBase.SvgRenderer;
    /** @private */
    svgObject: HTMLElement;
    /** @private */
    intl: base.Internationalization;
    /** @private */
    bounds: svgBase.Rect;
    /** @private */
    availableSize: svgBase.Size;
    /** @private */
    startValue: number;
    /** @private */
    endValue: number;
    /** @private */
    mouseX: number;
    /** @private */
    mouseDownX: number;
    /** @private */
    rangeSlider: RangeSlider;
    /** @private */
    chartSeries: RangeSeries;
    /** @private */
    rangeAxis: RangeNavigatorAxis;
    /** @private */
    private resizeTo;
    /** @private */
    dataModule: Data;
    /** @private */
    labels: ILabelRenderEventsArgs[];
    /** @private */
    animateSeries: boolean;
    /** @private */
    format: Function;
    private chartid;
    /** @private */
    stockChart: StockChart;
    /**
     * Constructor for creating the widget
     * @hidden
     */
    constructor(options?: RangeNavigatorModel, element?: string | HTMLElement);
    /**
     * Starting point of the control initialization
     */
    preRender(): void;
    /**
     * To initialize the private variables
     */
    private initPrivateVariables;
    /**
     * Method to set culture for chart
     */
    private setCulture;
    /**
     * to initialize the slider
     */
    private setSliderValue;
    /**
     * To render the range navigator
     */
    render(): void;
    /**
     * Theming for rangeNavigator
     */
    private setTheme;
    /**
     * Method to create SVG for Range Navigator
     */
    private createRangeSvg;
    /**
     * Bounds calculation for widget performed.
     */
    private calculateBounds;
    /**
     * Creating Chart for range navigator
     */
    renderChart(): void;
    /**
     * To render period selector value
     */
    private renderPeriodSelector;
    /**
     * Creating secondary range navigator
     */
    createSecondaryElement(): void;
    /**
     * Slider Calculation ane rendering performed here
     */
    private renderSlider;
    /**
     * To Remove the SVG.
     * @return {boolean}
     * @private
     */
    removeSvg(): void;
    /** Wire, UnWire and Event releated calculation Started here */
    /**
     * Method to un-bind events for range navigator
     */
    private unWireEvents;
    /**
     * Method to bind events for range navigator
     */
    private wireEvents;
    /**
     * Handles the widget resize.
     * @return {boolean}
     * @private
     */
    rangeResize(e: Event): boolean;
    /**
     * Handles the mouse move.
     * @return {boolean}
     * @private
     */
    mouseMove(e: PointerEvent): boolean;
    /**
     * Handles the mouse leave.
     * @return {boolean}
     * @private
     */
    mouseLeave(e: PointerEvent): boolean;
    /**
     * Handles the mouse click on range navigator.
     * @return {boolean}
     * @private
     */
    rangeOnMouseClick(e: PointerEvent | TouchEvent): boolean;
    /**
     * Handles the print method for range navigator control.
     */
    print(id?: string[] | string | Element): void;
    /**
     * Handles the export method for range navigator control.
     * @param type
     * @param fileName
     */
    export(type: ExportType, fileName: string, orientation?: pdfExport.PdfPageOrientation, controls?: (Chart | AccumulationChart | RangeNavigator)[], width?: number, height?: number, isVertical?: boolean): void;
    /**
     * Creating a background element to the svg object
     */
    private renderChartBackground;
    /**
     * Handles the mouse down on range navigator.
     * @return {boolean}
     * @private
     */
    rangeOnMouseDown(e: PointerEvent): boolean;
    /**
     * Handles the mouse up.
     * @return {boolean}
     * @private
     */
    mouseEnd(e: PointerEvent): boolean;
    /**
     * To find mouse x, y for aligned range navigator element svg position
     */
    private setMouseX;
    /** Wire, UnWire and Event releated calculation End here */
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
    /**
     * OnProperty change method calling here
     * @param newProp
     * @param oldProp
     */
    onPropertyChanged(newProp: RangeNavigatorModel, oldProp: RangeNavigatorModel): void;
    /**
     * To provide the array of modules needed for control rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    /**
     * To get the module name of the widget
     */
    getModuleName(): string;
    /**
     * To destroy the widget
     * @method destroy
     * @return {void}.
     * @member of rangeNavigator
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/renderer/chart-render.d.ts
/**
 * To render Chart series
 */
export  class RangeSeries extends NiceInterval {
    private dataSource;
    private xName;
    private yName;
    private query;
    xMin: number;
    xMax: number;
    private yMin;
    private yMax;
    private yAxis;
    xAxis: Axis;
    private seriesLength;
    private chartGroup;
    constructor(range: RangeNavigator);
    /**
     * To render light weight and data manager process
     * @param control
     */
    renderChart(control: RangeNavigator): void;
    private processDataSource;
    /**
     * data manager process calculated here
     * @param e
     */
    private dataManagerSuccess;
    /**
     * Process JSON data from data source
     * @param control
     * @param len
     */
    private processJsonData;
    private processXAxis;
    /**
     * Process yAxis for range navigator
     * @param control
     */
    private processYAxis;
    /**
     * Process Light weight control
     * @param control
     * @private
     */
    renderSeries(control: RangeNavigator): void;
    /**
     * Append series elements in element
     */
    appendSeriesElements(control: RangeNavigator): void;
    private createSeriesElement;
    private calculateGroupingBounds;
    private drawSeriesBorder;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/renderer/range-axis.d.ts
/**
 * class for axis
 */
export  class RangeNavigatorAxis extends DateTime {
    constructor(range: RangeNavigator);
    actualIntervalType: RangeIntervalType;
    rangeNavigator: RangeNavigator;
    firstLevelLabels: VisibleLabels[];
    secondLevelLabels: VisibleLabels[];
    lowerValues: number[];
    gridLines: Element;
    /**
     * To render grid lines of axis
     */
    renderGridLines(): void;
    /**
     * To render of axis labels
     */
    renderAxisLabels(): void;
    /**
     * To find secondary level label type
     * @param type
     */
    private getSecondaryLabelType;
    /**
     * To find labels for date time axis
     * @param axis
     */
    private findAxisLabels;
    /**
     * To find date time formats for Quarter and week interval type
     * @param text
     * @param axis
     * @param index
     */
    private dateFormats;
    /**
     * To find the y co-ordinate for axis labels
     * @param control - rangeNavigator
     * @param isSecondary sets true if the axis is secondary axis
     */
    private findLabelY;
    /**
     * It places the axis labels and returns border for secondary axis labels
     * @param axis axis for the lables placed
     * @param pointY y co-ordinate for axis labels
     * @param id id for the axis elements
     * @param control range navigator
     * @param labelElement parent element in which axis labels appended
     */
    private placeAxisLabels;
    /**
     * To check label is intersected with successive label or not
     */
    private isIntersect;
    /**
     * To find suitable label format for Quarter and week Interval types
     * @param axis
     * @param control
     */
    private findSuitableFormat;
    /**
     * Alignment position for secondary level labels in date time axis
     * @param axis
     * @param index
     */
    private findAlignment;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/renderer/slider.d.ts
/**
 * Class for slider
 */
export  class RangeSlider {
    private leftUnSelectedElement;
    private rightUnSelectedElement;
    private selectedElement;
    private leftSlider;
    private rightSlider;
    private control;
    /** @private */
    isDrag: boolean;
    private elementId;
    currentSlider: string;
    startX: number;
    endX: number;
    private sliderWidth;
    currentStart: number;
    currentEnd: number;
    private previousMoveX;
    private thumpPadding;
    private thumbColor;
    points: DataPoint[];
    leftRect: svgBase.Rect;
    rightRect: svgBase.Rect;
    midRect: svgBase.Rect;
    private labelIndex;
    private thumbVisible;
    private thumpY;
    sliderY: number;
    /** @private */
    isIOS: Boolean;
    constructor(range: RangeNavigator);
    /**
     * Render Slider elements for range navigator
     * @param range
     */
    render(range: RangeNavigator): void;
    /**
     * Thumb creation performed
     * @param render
     * @param bounds
     * @param parent
     * @param id
     */
    createThump(render: svgBase.SvgRenderer, bounds: svgBase.Rect, parent: Element, id: string, sliderGroup?: Element): void;
    /**
     * Set slider value for range navigator
     * @param start
     * @param end
     */
    setSlider(start: number, end: number, trigger: boolean, showTooltip: boolean): void;
    /**
     * Trigger changed event
     * @param range
     */
    private triggerEvent;
    /**
     * @hidden
     */
    private addEventListener;
    /**
     * @hidden
     */
    private removeEventListener;
    /**
     * Move move handler perfomed here
     * @hidden
     * @param e
     */
    private mouseMoveHandler;
    /**
     * To get the range value
     * @param x
     */
    private getRangeValue;
    /**
     * Moused down handler for slider perform here
     * @param e
     */
    private mouseDownHandler;
    /**
     * To get the current slider element
     * @param id
     */
    private getCurrentSlider;
    /**
     * Mouse up handler performed here
     * @param e
     */
    private mouseUpHandler;
    /**
     * Allow Snapping perfomed here
     * @param control
     * @param start
     * @param end
     */
    private setAllowSnapping;
    /**
     * Animation Calculation for slider navigation
     * @param start
     * @param end
     */
    performAnimation(start: number, end: number, control: RangeNavigator, animationDuration?: number): void;
    /**
     * Mouse Cancel Handler
     */
    private mouseCancelHandler;
    /**
     * Destroy Method Calling here
     */
    destroy(): void;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/user-interaction/tooltip.d.ts
/**
 * `Tooltip` module is used to render the tooltip for chart series.
 */
export  class RangeTooltip {
    leftTooltip: svgBase.Tooltip;
    rightTooltip: svgBase.Tooltip;
    private elementId;
    toolTipInterval: number;
    private control;
    /**
     * Constructor for tooltip module.
     * @private.
     */
    constructor(range: RangeNavigator);
    /**
     * Left tooltip method called here
     * @param rangeSlider
     */
    renderLeftTooltip(rangeSlider: RangeSlider): void;
    /**
     * get the content size
     * @param value
     */
    private getContentSize;
    /**
     * Right tooltip method called here
     * @param rangeSlider
     */
    renderRightTooltip(rangeSlider: RangeSlider): void;
    /**
     * Tooltip element creation
     * @param id
     */
    private createElement;
    /**
     * Tooltip render called here
     * @param bounds
     * @param parent
     * @param pointX
     * @param value
     */
    private renderTooltip;
    /**
     * Tooltip content processed here
     * @param value
     */
    private getTooltipContent;
    /**
     * Fadeout animation performed here
     */
    private fadeOutTooltip;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the tooltip.
     * @return {void}
     * @private
     */
    destroy(chart: RangeNavigator): void;
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/utils/enum.d.ts
/**
 * It defines type of series in the range navigator.
 * * line
 * * column
 * * area
 * @private
 */
export  type RangeNavigatorType = 
/** Line type */
'Line' | 
/** Area type */
'Area' | 
/** StepLine type */
'StepLine';
/**
 * It defines type of thump in the range navigator.
 * * circle
 * * rectangle
 * @private
 */
export  type ThumbType = 
/** Circle type */
'Circle' | 
/** Rectangle type */
'Rectangle';
/**
 * It defines display mode for the range navigator tooltip.
 * * always
 * * OnDemand
 * @private
 */
export  type TooltipDisplayMode = 
/** Tooltip will be shown always */
'Always' | 
/** Tooltip will be shown only in mouse move */
'OnDemand';
/**
 * It defines the value Type for the axis used
 * * double
 * * category
 * * dateTime
 * * logarithmic
 * @private
 */
export  type RangeValueType = 
/** Double axis */
'Double' | 
/** Datetime axis */
'DateTime' | 
/** Logarithmic axis */
'Logarithmic';
/**
 * Label alignment of the axis
 * *Near
 * *Middle
 * *Far
 * @private
 */
export  type LabelAlignment = 
/** Near alignment */
'Near' | 
/** Middle alignment */
'Middle' | 
/** Far Alignment */
'Far';
/**
 * Defines the intersect action. They are
 * * none - Shows all the labels.
 * * hide - Hide the label when it intersect.
 * *
 */
export  type RangeLabelIntersectAction = 
/** Shows all the labels. */
'None' | 
/** Hide the label when it intersect. */
'Hide';
//node_modules/@syncfusion/ej2-charts/src/range-navigator/utils/helper.d.ts
/**
 * Methods for calculating coefficient.
 */
/** @private */
export  function rangeValueToCoefficient(value: number, range: VisibleRangeModel, inversed: boolean): number;
/** @private */
export  function getXLocation(x: number, range: VisibleRangeModel, size: number, inversed: boolean): number;
/** @private */
export  function getRangeValueXByPoint(value: number, size: number, range: VisibleRangeModel, inversed: boolean): number;
/** @private */
export  function getExactData(points: DataPoint[], start: number, end: number): DataPoint[];
/** @private */
export  function getNearestValue(values: number[], point: number): number;
/**
 * Data point
 * @public
 */
export  class DataPoint {
    /** point x */
    x: Object;
    /** point y */
    y: Object;
    /** point x value */
    xValue?: number;
    /** point y value */
    yValue?: number;
    /** point visibility */
    visible?: boolean;
    constructor(x: Object, y: Object, xValue?: number, yValue?: number, visible?: boolean);
}
//node_modules/@syncfusion/ej2-charts/src/range-navigator/utils/theme.d.ts
/**
 *
 */
export  namespace RangeNavigatorTheme {
    /** @private */
    let axisLabelFont$: IFontMapping;
    /** @private */
    let tooltipLabelFont$: IFontMapping;
}
/** @private */
export  function getRangeThemeColor(theme: ChartTheme, range: RangeNavigator): IRangeStyle;
//node_modules/@syncfusion/ej2-charts/src/smithchart/axis/axis-model.d.ts
/**
 * Interface for a class SmithchartMajorGridLines
 */
export interface SmithchartMajorGridLinesModel {
    /**
    * width of the major grid lines
    * @default 1
    */
    width?: number;
    /**
     * The dash array of the major grid lines.
     * @default ''
     */
    dashArray?: string;
    /**
     * visibility of  major grid lines.
     * @default true
     */
    visible?: boolean;
    /**
     * option for customizing the majorGridLine color
     * @default null
     */
    color?: string;
    /**
     * opacity of  major grid lines.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class SmithchartMinorGridLines
 */
export interface SmithchartMinorGridLinesModel {
    /**
     * width of the minor grid lines
     * @default 1
     */
    width?: number;
    /**
     * The dash array of the minor grid lines.
     * @default ''
     */
    dashArray?: string;
    /**
     * visibility of  minor grid lines.
     * @default false
     */
    visible?: boolean;
    /**
     * option for customizing the minorGridLine color
     * @default null
     */
    color?: string;
    /**
     * count of  minor grid lines.
     * @default 8
     */
    count?: number;
}
/**
 * Interface for a class SmithchartAxisLine
 */
export interface SmithchartAxisLineModel {
    /**
     * visibility of  axis line.
     * @default true
     */
    visible?: boolean;
    /**
    * width of the axis lines
    * @default 1
    */
    width?: number;
    /**
     * option for customizing the axisLine color
     * @default null
     */
    color?: string;
    /**
     * The dash array of the axis line.
     * @default ''
     */
    dashArray?: string;
}
/**
 * Interface for a class SmithchartAxis
 */
export interface SmithchartAxisModel {
    /**
     * visibility of  axis.
     * @default true
     */
    visible?: boolean;
    /**
     * position of  axis line.
     * @default Outside
     */
    labelPosition?: AxisLabelPosition;
    /**
     * axis labels will be hide when overlap with each other.
     * @default Hide
     */
    labelIntersectAction?: SmithchartLabelIntersectAction;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines?: SmithchartMajorGridLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines?: SmithchartMinorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    axisLine?: SmithchartAxisLineModel;
    /**
     * Options for customizing font.
     */
    labelStyle?: SmithchartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/axis/axis.d.ts
/**
 * Configures the major Grid lines in the `axis`.
 */
export  class SmithchartMajorGridLines extends base.ChildProperty<SmithchartMajorGridLines> {
    /**
     * width of the major grid lines
     * @default 1
     */
    width: number;
    /**
     * The dash array of the major grid lines.
     * @default ''
     */
    dashArray: string;
    /**
     * visibility of  major grid lines.
     * @default true
     */
    visible: boolean;
    /**
     * option for customizing the majorGridLine color
     * @default null
     */
    color: string;
    /**
     * opacity of  major grid lines.
     * @default 1
     */
    opacity: number;
}
/**
 * Configures the major grid lines in the `axis`.
 */
export  class SmithchartMinorGridLines extends base.ChildProperty<SmithchartMinorGridLines> {
    /**
     * width of the minor grid lines
     * @default 1
     */
    width: number;
    /**
     * The dash array of the minor grid lines.
     * @default ''
     */
    dashArray: string;
    /**
     * visibility of  minor grid lines.
     * @default false
     */
    visible: boolean;
    /**
     * option for customizing the minorGridLine color
     * @default null
     */
    color: string;
    /**
     * count of  minor grid lines.
     * @default 8
     */
    count: number;
}
/**
 * Configures the axis lines in the `axis`.
 */
export  class SmithchartAxisLine extends base.ChildProperty<SmithchartAxisLine> {
    /**
     * visibility of  axis line.
     * @default true
     */
    visible: boolean;
    /**
     * width of the axis lines
     * @default 1
     */
    width: number;
    /**
     * option for customizing the axisLine color
     * @default null
     */
    color: string;
    /**
     * The dash array of the axis line.
     * @default ''
     */
    dashArray: string;
}
export  class SmithchartAxis extends base.ChildProperty<SmithchartAxis> {
    /**
     * visibility of  axis.
     * @default true
     */
    visible: boolean;
    /**
     * position of  axis line.
     * @default Outside
     */
    labelPosition: AxisLabelPosition;
    /**
     * axis labels will be hide when overlap with each other.
     * @default Hide
     */
    labelIntersectAction: SmithchartLabelIntersectAction;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines: SmithchartMajorGridLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines: SmithchartMinorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    axisLine: SmithchartAxisLineModel;
    /**
     * Options for customizing font.
     */
    labelStyle: SmithchartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/axis/axisrender.d.ts
/**
 *
 */
export  class AxisRender {
    areaRadius: number;
    circleLeftX: number;
    circleTopY: number;
    circleCenterX: number;
    circleCenterY: number;
    radialLabels: number[];
    radialLabelCollections: LabelCollection[];
    horizontalLabelCollections: HorizontalLabelCollection[];
    majorHGridArcPoints: GridArcPoints[];
    minorHGridArcPoints: GridArcPoints[];
    majorRGridArcPoints: GridArcPoints[];
    minorGridArcPoints: GridArcPoints[];
    labelCollections: RadialLabelCollections[];
    direction: Direction;
    renderArea(smithchart: Smithchart, bounds: SmithchartRect): void;
    private updateHAxis;
    private updateRAxis;
    private measureHorizontalAxis;
    private measureRadialAxis;
    private calculateChartArea;
    private calculateCircleMargin;
    private maximumLabelLength;
    private calculateAxisLabels;
    private isOverlap;
    private calculateXAxisRange;
    private calculateRAxisRange;
    private measureHMajorGridLines;
    private measureRMajorGridLines;
    private circleXYRadianValue;
    private calculateMajorArcStartEndPoints;
    private calculateHMajorArcStartEndPoints;
    private calculateMinorArcStartEndPoints;
    intersectingCirclePoints(x1: number, y1: number, r1: number, x2: number, y2: number, r2: number, renderType: RenderType): Point;
    private updateHMajorGridLines;
    private updateRMajorGridLines;
    private updateHAxisLine;
    private updateRAxisLine;
    private drawHAxisLabels;
    private drawRAxisLabels;
    private calculateRegion;
    private updateHMinorGridLines;
    private updateRMinorGridLines;
    private calculateGridLinesPath;
    private measureHMinorGridLines;
    private measureRMinorGridLines;
    private minorGridLineArcIntersectCircle;
    private circlePointPosition;
    private setLabelsInsidePosition;
    private setLabelsOutsidePosition;
    private arcRadius;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/index.d.ts
/**
 *
 */
//node_modules/@syncfusion/ej2-charts/src/smithchart/legend/legend-model.d.ts
/**
 * Interface for a class LegendTitle
 */
export interface LegendTitleModel {
    /**
 * visibility for legend title.
 * @default true
 */
    visible?: boolean;
    /**
 * text for legend title.
 * @default ''
 */
    text?: string;
    /**
 * description for legend title.
 * @default ''
 */
    description?: string;
    /**
 * alignment for legend title.
 * @default Center
 */
    textAlignment?: SmithchartAlignment;
    /**
 *  options for customizing font
 */
    textStyle?: SmithchartFont;
}
/**
 * Interface for a class LegendLocation
 */
export interface LegendLocationModel {
    /**
 * x location for legend.
 * @default 0
 */
    x?: number;
    /**
 * y location for legend.
 * @default 0
 */
    y?: number;
}
/**
 * Interface for a class LegendItemStyleBorder
 */
export interface LegendItemStyleBorderModel {
    /**
 * border width for legend item.
 * @default 1
 */
    width?: number;
    /**
 * border color for legend item.
 * @default null
 */
    color?: string;
}
/**
 * Interface for a class LegendItemStyle
 */
export interface LegendItemStyleModel {
    /**
 * specify the width for legend item.
 * @default 10
 */
    width?: number;
    /**
 * specify the height for legend item.
 * @default 10
 */
    height?: number;
    /**
 *  options for customizing legend item style border
 */
    border?: LegendItemStyleBorderModel;
}
/**
 * Interface for a class LegendBorder
 */
export interface LegendBorderModel {
    /**
     * border width for legend.
     * @default 1
     */
    width?: number;
    /**
 * border color for legend.
 * @default null
 */
    color?: string;
}
/**
 * Interface for a class SmithchartLegendSettings
 */
export interface SmithchartLegendSettingsModel {
    /**
 * visibility for legend.
 * @default false
 */
    visible?: boolean;
    /**
   * position for legend.
   * @default 'bottom'
   */
    position?: string;
    /**
   * alignment for legend.
   * @default Center
   */
    alignment?: SmithchartAlignment;
    /**
   * width for legend.
   * @default null
   */
    width?: number;
    /**
 * height for legend.
 * @default null
 */
    height?: number;
    /**
   * shape for legend.
   * @default 'circle'
   */
    shape?: string;
    /**
   * rowCount for legend.
   * @default null
   */
    rowCount?: number;
    /**
   * columnCount for legend.
   * @default null
   */
    columnCount?: number;
    /**
 * spacing between legend item.
 * @default 8
 */
    itemPadding?: number;
    /**
 * Padding between the legend shape and text.
 * @default 5
 */
    shapePadding?: number;
    /**
 * description for legend
 * @default ''
 */
    description?: string;
    /**
 * If set to true, series' visibility collapses based on the legend visibility.
 * @default true
 */
    toggleVisibility?: boolean;
    /**
    *  options for customizing legend title
    */
    title?: LegendTitleModel;
    /**
      *  options for customizing legend location
      */
    location?: LegendLocationModel;
    /**
      *  options for customizing legend item style
      */
    itemStyle?: LegendItemStyleModel;
    /**
      *  options for customizing legend border
      */
    border?: LegendBorderModel;
    /**
    *  options for customizing font
    */
    textStyle?: SmithchartFont;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/legend/legend.d.ts
export  class LegendTitle extends base.ChildProperty<LegendTitle> {
    /**
     * visibility for legend title.
     * @default true
     */
    visible: boolean;
    /**
     * text for legend title.
     * @default ''
     */
    text: string;
    /**
     * description for legend title.
     * @default ''
     */
    description: string;
    /**
     * alignment for legend title.
     * @default Center
     */
    textAlignment: SmithchartAlignment;
    /**
     *  options for customizing font
     */
    textStyle: SmithchartFont;
}
export  class LegendLocation extends base.ChildProperty<LegendLocation> {
    /**
     * x location for legend.
     * @default 0
     */
    x: number;
    /**
     * y location for legend.
     * @default 0
     */
    y: number;
}
export  class LegendItemStyleBorder extends base.ChildProperty<LegendItemStyleBorder> {
    /**
     * border width for legend item.
     * @default 1
     */
    width: number;
    /**
     * border color for legend item.
     * @default null
     */
    color: string;
}
export  class LegendItemStyle extends base.ChildProperty<LegendItemStyle> {
    /**
     * specify the width for legend item.
     * @default 10
     */
    width: number;
    /**
     * specify the height for legend item.
     * @default 10
     */
    height: number;
    /**
     *  options for customizing legend item style border
     */
    border: LegendItemStyleBorderModel;
}
export  class LegendBorder extends base.ChildProperty<LegendBorder> {
    /**
     * border width for legend.
     * @default 1
     */
    width: number;
    /**
     * border color for legend.
     * @default null
     */
    color: string;
}
export  class SmithchartLegendSettings extends base.ChildProperty<SmithchartLegendSettings> {
    /**
     * visibility for legend.
     * @default false
     */
    visible: boolean;
    /**
     * position for legend.
     * @default 'bottom'
     */
    position: string;
    /**
     * alignment for legend.
     * @default Center
     */
    alignment: SmithchartAlignment;
    /**
     * width for legend.
     * @default null
     */
    width: number;
    /**
     * height for legend.
     * @default null
     */
    height: number;
    /**
     * shape for legend.
     * @default 'circle'
     */
    shape: string;
    /**
     * rowCount for legend.
     * @default null
     */
    rowCount: number;
    /**
     * columnCount for legend.
     * @default null
     */
    columnCount: number;
    /**
     * spacing between legend item.
     * @default 8
     */
    itemPadding: number;
    /**
     * Padding between the legend shape and text.
     * @default 5
     */
    shapePadding: number;
    /**
     * description for legend
     * @default ''
     */
    description: string;
    /**
     * If set to true, series' visibility collapses based on the legend visibility.
     * @default true
     */
    toggleVisibility: boolean;
    /**
     *  options for customizing legend title
     */
    title: LegendTitleModel;
    /**
     *  options for customizing legend location
     */
    location: LegendLocationModel;
    /**
     *  options for customizing legend item style
     */
    itemStyle: LegendItemStyleModel;
    /**
     *  options for customizing legend border
     */
    border: LegendBorderModel;
    /**
     *  options for customizing font
     */
    textStyle: SmithchartFont;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/legend/legendrender.d.ts
/**
 *
 */
export  class SmithchartLegend {
    legendActualBounds: SmithchartRect;
    legendSeries: LegendSeries[];
    legendGroup: Element;
    /**
     * legend rendering
     */
    legendItemGroup: Element;
    renderLegend(smithchart: Smithchart): SmithchartRect;
    private calculateLegendBounds;
    private _getLegendSize;
    private _drawLegend;
    private drawLegendBorder;
    private drawLegendTitle;
    private drawLegendItem;
    private drawLegendShape;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the legend.
     * @return {void}
     * @private
     */
    destroy(smithchart: Smithchart): void;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/model/constant.d.ts
/**
 * Specifies smithchart animationComplete event name.
 * @private
 */
export  const animationComplete$: string;
/**
 * Specifies smithchart legendRender event name.
 * @private
 */
export  const legendRender$: string;
/**
 * Specifies smithchart titleRender event name.
 * @private
 */
export  const titleRender: string;
/**
 * Specifies smithchart subtitleRender event name.
 * @private
 */
export  const subtitleRender: string;
/**
 * Specifies smithchart textRender event name.
 * @private
 */
export  const textRender$: string;
/**
 * Specifies smithchart seriesRender event name.
 * @private
 */
export  const seriesRender$: string;
/**
 * Specifies smithchart load event name.
 * @private
 */
export  const load$: string;
/**
 * Specifies smithchart loaded event name.
 * @private
 */
export  const loaded$: string;
/**
 * Specifies smithchart axisLabelRender event name.
 * @private
 */
export  const axisLabelRender$: string;
//node_modules/@syncfusion/ej2-charts/src/smithchart/model/interface.d.ts
/**
 * Specifies Smithchart Events
 * @private
 */
export interface ISmithchartEventArgs {
    /** Defines the name of the event */
    name: string;
    /** Defines the event cancel status */
    cancel: boolean;
}
export interface ISmithchartPrintEventArgs extends ISmithchartEventArgs {
    htmlContent: Element;
}
/**
 * Specifies the Load Event arguments.
 */
export interface ISmithchartLoadEventArgs extends ISmithchartEventArgs {
    /** Defines the current Smithchart instance */
    smithchart: Smithchart;
}
/**
 * Specifies the Loaded Event arguments.
 */
export interface ISmithchartLoadedEventArgs extends ISmithchartEventArgs {
    /** Defines the current Smithchart instance */
    smithchart: Smithchart;
}
export interface ISmithchartAnimationCompleteEventArgs extends ISmithchartEventArgs {
    /**
     * smithchart instance event argument
     */
    smithchart?: Smithchart;
}
export interface ISmithchartLegendRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current legend text */
    text: string;
    /** Defines the current legend fill color */
    fill: string;
    /** Defines the current legend shape */
    shape: string;
}
/**
 * Specifies the Title Render Event arguments.
 */
export interface ITitleRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current title text */
    text: string;
    /** Defines the current title text x location */
    x: number;
    /** Defines the current title text y location */
    y: number;
}
/**
 * Specifies the SubTitle Render Event arguments.
 */
export interface ISubTitleRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current subtitle text */
    text: string;
    /** Defines the current subtitle text x location */
    x: number;
    /** Defines the current subtitle text y location */
    y: number;
}
/**
 * Specifies the Text Render Event arguments.
 */
export interface ISmithchartTextRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current datalabel text */
    text: string;
    /** Defines the current datalabel text x location */
    x: number;
    /** Defines the current datalabel text y location */
    y: number;
    /** Defines the current datalabel seriesIndex */
    seriesIndex: number;
    /** Defines the current datalabel pointIndex */
    pointIndex: number;
}
/**
 * Specifies the Axis Label Render Event arguments.
 */
export interface ISmithchartAxisLabelRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current axis label text */
    text: string;
    /** Defines the current axis label x location */
    x: number;
    /** Defines the current axis label y location */
    y: number;
}
/**
 * Specifies the Series Render Event arguments.
 */
export interface ISmithchartSeriesRenderEventArgs extends ISmithchartEventArgs {
    /** Defines name of the event */
    text: string;
    /** Defines the current series fill */
    fill: string;
}
/**
 * Specifies the Legend Render Event arguments.
 */
export interface ISmithchartLegendRenderEventArgs extends ISmithchartEventArgs {
    /** Defines the current legend text */
    text: string;
    /** Defines the current legend fill color */
    fill: string;
    /** Defines the current legend shape */
    shape: string;
}
/** @private */
export interface ISmithchartFontMapping {
    size?: string;
    color?: string;
    fontWeight?: string;
    fontStyle?: string;
    fontFamily?: string;
}
export interface ISmithchartThemeStyle {
    axisLabel: string;
    axisLine: string;
    majorGridLine: string;
    minorGridLine: string;
    chartTitle: string;
    legendLabel: string;
    background: string;
    areaBorder: string;
    tooltipFill: string;
    dataLabel: string;
    tooltipBoldLabel: string;
    tooltipLightLabel: string;
    tooltipHeaderLine: string;
    fontFamily?: string;
    fontSize?: string;
    labelFontFamily?: string;
    tooltipFillOpacity?: number;
    tooltipTextOpacity?: number;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/model/theme.d.ts
/**
 *
 */
export  namespace Theme {
    /** @private */
    let axisLabelFont$: ISmithchartFontMapping;
    /** @private */
    let smithchartTitleFont: ISmithchartFontMapping;
    /** @private */
    let smithchartSubtitleFont: ISmithchartFontMapping;
    /** @private */
    let dataLabelFont: ISmithchartFontMapping;
    /** @private */
    let legendLabelFont$: ISmithchartFontMapping;
}
/** @private */
export  function getSeriesColor(theme: SmithchartTheme): string[];
/** @private */
export  function getThemeColor(theme: SmithchartTheme): ISmithchartThemeStyle;
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/datalabel.d.ts
export  class DataLabel1 {
    textOptions: DataLabelTextOptions[];
    labelOptions: LabelOption[];
    private margin;
    private connectorFlag;
    private prevLabel;
    private allPoints;
    drawDataLabel(smithchart: Smithchart, seriesindex: number, groupElement: Element, pointsRegion: PointRegion[], bounds: SmithchartRect): void;
    calculateSmartLabels(points: object, seriesIndex: number): void;
    private compareDataLabels;
    private isCollide;
    private resetValues;
    drawConnectorLines(smithchart: Smithchart, seriesIndex: number, index: number, currentPoint: DataLabelTextOptions, groupElement: Element): void;
    private drawDatalabelSymbol;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/marker.d.ts
/**
 *
 */
export  class Marker1 {
    drawMarker(smithchart: Smithchart, seriesindex: number, groupElement: Element, pointsRegion: PointRegion[]): void;
    private drawSymbol;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/series-model.d.ts
/**
 * Interface for a class SeriesTooltipBorder
 */
export interface SeriesTooltipBorderModel {
    /**
 * border width  for tooltip.
 * @default 1
 */
    width?: number;
    /**
 * border color for tooltip
 * @default null
 */
    color?: string;
}
/**
 * Interface for a class SeriesTooltip
 */
export interface SeriesTooltipModel {
    /**
 * visibility of tooltip.
 * @default false
 */
    visible?: boolean;
    /**
 * color for tooltip .
 * @default null
 */
    fill?: string;
    /**
 * opacity for tooltip.
 * @default 0.95
 */
    opacity?: number;
    /**
  * template for tooltip
  * @default ''
  */
    template?: string;
    /**
     *  options for customizing tooltip border
     */
    border?: SeriesTooltipBorderModel;
}
/**
 * Interface for a class SeriesMarkerBorder
 */
export interface SeriesMarkerBorderModel {
    /**
 * border width for marker border.
 * @default 3
 */
    width?: number;
    /**
 * border color for marker border.
 * @default 'white'
 */
    color?: string;
}
/**
 * Interface for a class SeriesMarkerDataLabelBorder
 */
export interface SeriesMarkerDataLabelBorderModel {
    /**
 * border width for data label border.
 * @default 0.1
 */
    width?: number;
    /**
 * border color for data label color.
 * @default 'white'
 */
    color?: string;
}
/**
 * Interface for a class SeriesMarkerDataLabelConnectorLine
 */
export interface SeriesMarkerDataLabelConnectorLineModel {
    /**
 * border width for data label connector line.
 * @default 1
 */
    width?: number;
    /**
 * border color for data label connector line.
 * @default null
 */
    color?: string;
}
/**
 * Interface for a class SeriesMarkerDataLabel
 */
export interface SeriesMarkerDataLabelModel {
    /**
 * visibility for data label.
 * @default false
 */
    visible?: boolean;
    /**
 * showing template for data label template
 * @default ''
 */
    template?: string;
    /**
 * color for data label.
 * @default null
 */
    fill?: string;
    /**
 * opacity for data label.
 * @default 1
 */
    opacity?: number;
    /**
 *  options for customizing data label border
 */
    border?: SeriesMarkerDataLabelBorderModel;
    /**
 *  options for customizing data label connector line
 */
    connectorLine?: SeriesMarkerDataLabelConnectorLineModel;
    /**
 *  options for customizing font
 */
    textStyle?: SmithchartFontModel;
}
/**
 * Interface for a class SeriesMarker
 */
export interface SeriesMarkerModel {
    /**
 * visibility for marker.
 * @default false
 */
    visible?: boolean;
    /**
 * shape for marker.
 * @default 'circle'
 */
    shape?: string;
    /**
 * width for marker.
 * @default 6
 */
    width?: number;
    /**
 * height for marker.
 * @default 6
 */
    height?: number;
    /**
 * Url for the image that is to be displayed as marker
 * @default ''
 */
    imageUrl?: string;
    /**
 * color for marker.
 * @default ''
 */
    fill?: string;
    /**
 * opacity for marker.
 * @default 1
 */
    opacity?: number;
    /**
     *  options for customizing marker border
     */
    border?: SeriesMarkerBorderModel;
    /**
 *  options for customizing marker data label 
 */
    dataLabel?: SeriesMarkerDataLabelModel;
}
/**
 * Interface for a class SmithchartSeries
 */
export interface SmithchartSeriesModel {
    /**
 * visibility for series.
 * @default 'visible'
 */
    visibility?: string;
    /**
 * points for series.
 * @default []
 */
    points?: { resistance: number,  reactance: number}[];
    /**
 * resistance name for dataSource
 * @default ''
 */
    resistance?: string;
    /**
 * reactance name for dataSource
 * @default ''
 */
    reactance?: string;
    /**
 *  Specifies the dataSource
 * @default null
 * @isdatamanager false
 */
    dataSource?: Object;
    /**
 * The name of the series visible in legend.
 * @default ''
 */
    name?: string;
    /**
 * color for series.
 * @default null
 */
    fill?: string;
    /**
 * enable or disable the animation of series.
 * @default false
 */
    enableAnimation?: boolean;
    /**
 * perform animation of series based on animation duration.
 * @default '2000ms'
 */
    animationDuration?: string;
    /**
 * avoid the overlap of dataLabels.
 * @default false
 */
    enableSmartLabels?: boolean;
    /**
 * width for series.
 * @default 1
 */
    width?: number;
    /**
 * opacity for series.
 * @default 1
 */
    opacity?: number;
    /**
 *  options for customizing marker
 */
    marker?: SeriesMarkerModel;
    /**
 *  options for customizing tooltip
 */
    tooltip?: SeriesTooltipModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/series.d.ts
export  class SeriesTooltipBorder extends base.ChildProperty<SeriesTooltipBorder> {
    /**
     * border width  for tooltip.
     * @default 1
     */
    width: number;
    /**
     * border color for tooltip
     * @default null
     */
    color: string;
}
export  class SeriesTooltip extends base.ChildProperty<SeriesTooltip> {
    /**
     * visibility of tooltip.
     * @default false
     */
    visible: boolean;
    /**
     * color for tooltip .
     * @default null
     */
    fill: string;
    /**
     * opacity for tooltip.
     * @default 0.95
     */
    opacity: number;
    /**
     * template for tooltip
     * @default ''
     */
    template: string;
    /**
     *  options for customizing tooltip border
     */
    border: SeriesTooltipBorderModel;
}
export  class SeriesMarkerBorder extends base.ChildProperty<SeriesMarkerBorder> {
    /**
     * border width for marker border.
     * @default 3
     */
    width: number;
    /**
     * border color for marker border.
     * @default 'white'
     */
    color: string;
}
export  class SeriesMarkerDataLabelBorder extends base.ChildProperty<SeriesMarkerDataLabelBorder> {
    /**
     * border width for data label border.
     * @default 0.1
     */
    width: number;
    /**
     * border color for data label color.
     * @default 'white'
     */
    color: string;
}
export  class SeriesMarkerDataLabelConnectorLine extends base.ChildProperty<SeriesMarkerDataLabelConnectorLine> {
    /**
     * border width for data label connector line.
     * @default 1
     */
    width: number;
    /**
     * border color for data label connector line.
     * @default null
     */
    color: string;
}
export  class SeriesMarkerDataLabel extends base.ChildProperty<SeriesMarkerDataLabel> {
    /**
     * visibility for data label.
     * @default false
     */
    visible: boolean;
    /**
     * showing template for data label template
     * @default ''
     */
    template: string;
    /**
     * color for data label.
     * @default null
     */
    fill: string;
    /**
     * opacity for data label.
     * @default 1
     */
    opacity: number;
    /**
     *  options for customizing data label border
     */
    border: SeriesMarkerDataLabelBorderModel;
    /**
     *  options for customizing data label connector line
     */
    connectorLine: SeriesMarkerDataLabelConnectorLineModel;
    /**
     *  options for customizing font
     */
    textStyle: SmithchartFontModel;
}
export  class SeriesMarker extends base.ChildProperty<SeriesMarker> {
    /**
     * visibility for marker.
     * @default false
     */
    visible: boolean;
    /**
     * shape for marker.
     * @default 'circle'
     */
    shape: string;
    /**
     * width for marker.
     * @default 6
     */
    width: number;
    /**
     * height for marker.
     * @default 6
     */
    height: number;
    /**
     * Url for the image that is to be displayed as marker
     * @default ''
     */
    imageUrl: string;
    /**
     * color for marker.
     * @default ''
     */
    fill: string;
    /**
     * opacity for marker.
     * @default 1
     */
    opacity: number;
    /**
     *  options for customizing marker border
     */
    border: SeriesMarkerBorderModel;
    /**
     *  options for customizing marker data label
     */
    dataLabel: SeriesMarkerDataLabelModel;
}
export  class SmithchartSeries extends base.ChildProperty<SmithchartSeries> {
    /**
     * visibility for series.
     * @default 'visible'
     */
    visibility: string;
    /**
     * points for series.
     * @default []
     */
    points: {
        resistance: number;
        reactance: number;
    }[];
    /**
     * resistance name for dataSource
     * @default ''
     */
    resistance: string;
    /**
     * reactance name for dataSource
     * @default ''
     */
    reactance: string;
    /**
     *  Specifies the dataSource
     * @default null
     * @isdatamanager false
     */
    dataSource: Object;
    /**
     * The name of the series visible in legend.
     * @default ''
     */
    name: string;
    /**
     * color for series.
     * @default null
     */
    fill: string;
    /**
     * enable or disable the animation of series.
     * @default false
     */
    enableAnimation: boolean;
    /**
     * perform animation of series based on animation duration.
     * @default '2000ms'
     */
    animationDuration: string;
    /**
     * avoid the overlap of dataLabels.
     * @default false
     */
    enableSmartLabels: boolean;
    /**
     * width for series.
     * @default 1
     */
    width: number;
    /**
     * opacity for series.
     * @default 1
     */
    opacity: number;
    /**
     *  options for customizing marker
     */
    marker: SeriesMarkerModel;
    /**
     *  options for customizing tooltip
     */
    tooltip: SeriesTooltipModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/seriesrender.d.ts
/**
 *
 */
export  class SeriesRender {
    xValues: number[];
    yValues: number[];
    pointsRegion: PointRegion[][];
    lineSegments: LineSegment[];
    location: Point[][];
    clipRectElement: Element;
    private dataLabel;
    private processData;
    draw(smithchart: Smithchart, axisRender: AxisRender, bounds: SmithchartRect): void;
    private drawSeries;
    private animateDataLabelTemplate;
    private performAnimation;
    getLocation(seriesindex: number, pointIndex: number): Point;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/series/tooltip.d.ts
/**
 *
 */
/**
 * To render tooltip
 */
export  class TooltipRender {
    private mouseX;
    private mouseY;
    private locationX;
    private locationY;
    /** To define the tooltip element */
    tooltipElement: svgBase.Tooltip;
    smithchartMouseMove(smithchart: Smithchart, e: PointerEvent): svgBase.Tooltip;
    private setMouseXY;
    private createTooltip;
    private closestPointXY;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the legend.
     * @return {void}
     * @private
     */
    destroy(smithchart: Smithchart): void;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/smithchart-model.d.ts
/**
 * Interface for a class Smithchart
 */
export interface SmithchartModel extends base.ComponentModel{
    /**
     * render type of smithchart.
     * @default Impedance
     */
    renderType?: RenderType;
    /**
     * width for smithchart.
     * @default ''
     */
    width?: string;
    /**
     * height for smithchart.
     * @default ''
     */
    height?: string;
    /**
     * theme for smithchart.
     * @default Material
     */
    theme?: SmithchartTheme;
    /**
     *  options for customizing margin
     */
    margin?: SmithchartMarginModel;
    /**
     *  options for customizing margin
     */
    font?: SmithchartFontModel;
    /**
     *  options for customizing border
     */
    border?: SmithchartBorderModel;
    /**
     *  options for customizing title
     */
    title?: TitleModel;
    /**
     *  options for customizing series
     */
    series?: SmithchartSeriesModel[];
    /**
     *  options for customizing legend
     */
    legendSettings?: SmithchartLegendSettingsModel;
    /**
     * Options to configure the horizontal axis.
     */
    horizontalAxis?: SmithchartAxisModel;
    /**
     * Options to configure the vertical axis.
     */
    radialAxis?: SmithchartAxisModel;
    /**
     * The background color of the smithchart.
     */
    background?: string;
    /**
     *  Spacing between elements
     * @default 10
     */
    elementSpacing?: number;
    /**
     *  Spacing between elements
     * @default 1
     */
    radius?: number;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint?: base.EmitType<ISmithchartPrintEventArgs>;
    /**
     * Triggers after the animation completed.
     * @event
     * @blazorProperty 'AnimationCompleted'
     */
    animationComplete?: base.EmitType<ISmithchartAnimationCompleteEventArgs>;
    /**
     * Triggers before smithchart rendered.
     * @event
     * @blazorProperty 'OnLoad'
     */
    load?: base.EmitType<ISmithchartLoadEventArgs>;
    /**
     * Triggers after smithchart rendered.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<ISmithchartLoadedEventArgs>;
    /**
     * Triggers before the legend is rendered.
     * @event
     * @blazorProperty 'LegendRendering'
     */
    legendRender?: base.EmitType<ISmithchartLegendRenderEventArgs>;
    /**
     * Triggers before the title is rendered.
     * @event
     * @blazorProperty 'TitleRendering'
     */
    titleRender?: base.EmitType<ITitleRenderEventArgs>;
    /**
     * Triggers before the sub-title is rendered.
     * @event
     * @blazorProperty 'SubtitleRendering'
     */
    subtitleRender?: base.EmitType<ISubTitleRenderEventArgs>;
    /**
     * Triggers before the datalabel text is rendered.
     * @event
     * @blazorProperty 'TextRendering'
     */
    textRender?: base.EmitType<ISmithchartTextRenderEventArgs>;
    /**
     * Triggers before the axis label is rendered
     * @event
     * @blazorProperty 'AxisLabelRendering'
     */
    axisLabelRender?: base.EmitType<ISmithchartAxisLabelRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     */
    seriesRender?: base.EmitType<ISmithchartSeriesRenderEventArgs>;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/smithchart.d.ts
/**
 * Represents the Smithchart control.
 * ```html
 * <div id="smithchart"/>
 * <script>
 *   var chartObj = new Smithchart({ isResponsive : true });
 *   chartObj.appendTo("#smithchart");
 * </script>
 * ```
 */
export  class Smithchart extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * legend bounds
     */
    legendBounds: SmithchartRect;
    /**
     * area bounds
     */
    bounds: SmithchartRect;
    /**
     * `smithchartLegendModule` is used to add legend to the smithchart.
     */
    smithchartLegendModule: SmithchartLegend;
    /**
     * `tooltipRenderModule` is used to add tooltip to the smithchart.
     */
    tooltipRenderModule: TooltipRender;
    /**
     * render type of smithchart.
     * @default Impedance
     */
    renderType: RenderType;
    /**
     * width for smithchart.
     * @default ''
     */
    width: string;
    /**
     * height for smithchart.
     * @default ''
     */
    height: string;
    /**
     * theme for smithchart.
     * @default Material
     */
    theme: SmithchartTheme;
    /** @private */
    seriesrender: SeriesRender;
    /** @private */
    themeStyle: ISmithchartThemeStyle;
    /** @private */
    availableSize: SmithchartSize;
    /**
     *  options for customizing margin
     */
    margin: SmithchartMarginModel;
    /**
     *  options for customizing margin
     */
    font: SmithchartFontModel;
    /**
     *  options for customizing border
     */
    border: SmithchartBorderModel;
    /**
     *  options for customizing title
     */
    title: TitleModel;
    /**
     *  options for customizing series
     */
    series: SmithchartSeriesModel[];
    /**
     *  options for customizing legend
     */
    legendSettings: SmithchartLegendSettingsModel;
    /**
     * Options to configure the horizontal axis.
     */
    horizontalAxis: SmithchartAxisModel;
    /**
     * Options to configure the vertical axis.
     */
    radialAxis: SmithchartAxisModel;
    /**
     * svg renderer object.
     * @private
     */
    renderer: svgBase.SvgRenderer;
    /** @private */
    svgObject: Element;
    /** @private */
    animateSeries: boolean;
    /** @private */
    seriesColors: string[];
    chartArea: SmithchartRect;
    /**
     * Resize the smithchart
     */
    private resizeTo;
    private isTouch;
    private fadeoutTo;
    /**
     * The background color of the smithchart.
     */
    background: string;
    /**
     *  Spacing between elements
     * @default 10
     */
    elementSpacing: number;
    /**
     *  Spacing between elements
     * @default 1
     */
    radius: number;
    /**
     * Triggers before the prints gets started.
     * @event
     * @blazorProperty 'OnPrint'
     */
    beforePrint: base.EmitType<ISmithchartPrintEventArgs>;
    /**
     * Triggers after the animation completed.
     * @event
     * @blazorProperty 'AnimationCompleted'
     */
    animationComplete: base.EmitType<ISmithchartAnimationCompleteEventArgs>;
    /**
     * Triggers before smithchart rendered.
     * @event
     * @blazorProperty 'OnLoad'
     */
    load: base.EmitType<ISmithchartLoadEventArgs>;
    /**
     * Triggers after smithchart rendered.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<ISmithchartLoadedEventArgs>;
    /**
     * Triggers before the legend is rendered.
     * @event
     * @blazorProperty 'LegendRendering'
     */
    legendRender: base.EmitType<ISmithchartLegendRenderEventArgs>;
    /**
     * Triggers before the title is rendered.
     * @event
     * @blazorProperty 'TitleRendering'
     */
    titleRender: base.EmitType<ITitleRenderEventArgs>;
    /**
     * Triggers before the sub-title is rendered.
     * @event
     * @blazorProperty 'SubtitleRendering'
     */
    subtitleRender: base.EmitType<ISubTitleRenderEventArgs>;
    /**
     * Triggers before the datalabel text is rendered.
     * @event
     * @blazorProperty 'TextRendering'
     */
    textRender: base.EmitType<ISmithchartTextRenderEventArgs>;
    /**
     * Triggers before the axis label is rendered
     * @event
     * @blazorProperty 'AxisLabelRendering'
     */
    axisLabelRender: base.EmitType<ISmithchartAxisLabelRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     */
    seriesRender: base.EmitType<ISmithchartSeriesRenderEventArgs>;
    /** @private */
    isBlazor: boolean;
    /**
     * Get component name
     */
    getModuleName(): string;
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
    /**
     * Method to create SVG element.
     */
    private createChartSvg;
    private renderTitle;
    private renderSubtitle;
    /**
     * @private
     * Render the smithchart border
     */
    private renderBorder;
    /**
     * Called internally if any of the property value changed.
     * @private
     */
    onPropertyChanged(newProp: SmithchartModel, oldProp: SmithchartModel): void;
    /**
     * Constructor for creating the Smithchart widget
     */
    constructor(options?: SmithchartModel, element?: string | HTMLElement);
    /**
     * Initialize the event handler.
     */
    protected preRender(): void;
    private initPrivateVariable;
    /**
     * To Initialize the control rendering.
     */
    private setTheme;
    protected render(): void;
    private createSecondaryElement;
    /**
     * To destroy the widget
     * @method destroy
     * @return {void}.
     * @member of smithChart
     */
    destroy(): void;
    /**
     * To bind event handlers for smithchart.
     */
    private wireEVents;
    mouseMove(e: PointerEvent): void;
    mouseEnd(e: PointerEvent): void;
    /**
     * To handle the click event for the smithchart.
     */
    smithchartOnClick(e: PointerEvent): void;
    /**
     * To unbind event handlers from smithchart.
     */
    private unWireEVents;
    print(id?: string[] | string | Element): void;
    /**
     * Handles the export method for chart control.
     * @param type
     * @param fileName
     */
    export(type: SmithchartExportType, fileName: string, orientation?: pdfExport.PdfPageOrientation): void;
    /**
     * To handle the window resize event on smithchart.
     */
    smithchartOnResize(e: Event): boolean;
    /**
     * To provide the array of modules needed for smithchart rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    /**
     * To Remove the SVG.
     * @return {boolean}
     * @private
     */
    removeSvg(): void;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/title/title-model.d.ts
/**
 * Interface for a class Subtitle
 */
export interface SubtitleModel {
    /**
 * visibility for sub title.
 * @default true
 */
    visible?: boolean;
    /**
 * text for sub title.
 * @default ''
 */
    text?: string;
    /**
 * description for sub title.
 * @default ''
 */
    description?: string;
    /**
 * text alignment for sub title.
 * @default Far
 */
    textAlignment?: SmithchartAlignment;
    /**
  * trim the sub title.
  * @default true
  */
    enableTrim?: boolean;
    /**
 * maximum width of the sub title.
 * @aspDefaultValueIgnore
 * @default null
 */
    maximumWidth?: number;
    /**
 * options for customizing sub title font
 */
    textStyle?: SmithchartFontModel;
}
/**
 * Interface for a class Title
 */
export interface TitleModel {
    /**
 * visibility for title.
 * @default true
 */
    visible?: boolean;
    /**
 * text for title.
 * @default ''
 */
    text?: string;
    /**
 * description for title.
 * @default ''
 */
    description?: string;
    /**
 * text alignment for title.
 * @default Center
 */
    textAlignment?: SmithchartAlignment;
    /**
 * trim the title.
 * @default true
 */
    enableTrim?: boolean;
    /**
 * maximum width of the sub title
 * @aspDefaultValueIgnore
 * @default null
 */
    maximumWidth?: number;
    /**
 * options for customizing sub title
 */
    subtitle?: SubtitleModel;
    /**
 * options for customizing title font
 */
    font?: SmithchartFontModel;
    /**
 * options for customizing title text
 */
    textStyle?: SmithchartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/title/title.d.ts
export  class Subtitle extends base.ChildProperty<Subtitle> {
    /**
     * visibility for sub title.
     * @default true
     */
    visible: boolean;
    /**
     * text for sub title.
     * @default ''
     */
    text: string;
    /**
     * description for sub title.
     * @default ''
     */
    description: string;
    /**
     * text alignment for sub title.
     * @default Far
     */
    textAlignment: SmithchartAlignment;
    /**
     * trim the sub title.
     * @default true
     */
    enableTrim: boolean;
    /**
     * maximum width of the sub title.
     * @aspDefaultValueIgnore
     * @default null
     */
    maximumWidth: number;
    /**
     * options for customizing sub title font
     */
    textStyle: SmithchartFontModel;
}
export  class Title extends base.ChildProperty<Title> {
    /**
     * visibility for title.
     * @default true
     */
    visible: boolean;
    /**
     * text for title.
     * @default ''
     */
    text: string;
    /**
     * description for title.
     * @default ''
     */
    description: string;
    /**
     * text alignment for title.
     * @default Center
     */
    textAlignment: SmithchartAlignment;
    /**
     * trim the title.
     * @default true
     */
    enableTrim: boolean;
    /**
     * maximum width of the sub title
     * @aspDefaultValueIgnore
     * @default null
     */
    maximumWidth: number;
    /**
     * options for customizing sub title
     */
    subtitle: SubtitleModel;
    /**
     * options for customizing title font
     */
    font: SmithchartFontModel;
    /**
     * options for customizing title text
     */
    textStyle: SmithchartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/area.d.ts
/**
 *
 */
export  class AreaBounds {
    yOffset: number;
    calculateAreaBounds(smithchart: Smithchart, title: TitleModel, bounds: SmithchartRect): SmithchartRect;
    private getLegendSpace;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/enum.d.ts
/**
 * Defines Theme of the smithchart. They are
 * * Material - Render a smithchart with Material theme.
 * * Fabric - Render a smithchart with Fabric theme
 */
export  type SmithchartTheme = 
/**  Render a smithchart with Material theme. */
'Material' | 
/**  Render a smithchart with Fabric theme. */
'Fabric' | 
/**  Render a smithchart with Bootstrap theme. */
'Bootstrap' | 
/**  Render a smithchart with Highcontrast Light theme. */
'HighContrastLight' | 
/**  Render a smithchart with Material Dark theme. */
'MaterialDark' | 
/**  Render a smithchart with Fabric Dark theme. */
'FabricDark' | 
/**  Render a smithchart with Highcontrast Dark theme. */
'HighContrast' | 
/**  Render a smithchart with Bootstrap Dark theme. */
'BootstrapDark' | 
/** Render a smithchart with Bootstrap4 theme. */
'Bootstrap4';
/**
 * Defines render type of smithchart. They are
 * * Impedance - Render a smithchart with Impedance type.
 * * Admittance - Render a smithchart with Admittance type.
 */
export  type RenderType = 
/**  Render a smithchart with Impedance type. */
'Impedance' | 
/**  Render a smithchart with Admittance type. */
'Admittance';
export  type AxisLabelPosition = 
/**  Render a axis label with label position as outside. */
'Outside' | 
/**  Render a axis label with label position as outside. */
'Inside';
export  type SmithchartLabelIntersectAction = 
/**  Hide the overlapped axis label. */
'Hide' | 
/**  Render the overlapped axis label */
'None';
/**
 * Defines the Alignment. They are
 * * near - Align the element to the left.
 * * center - Align the element to the center.
 * * far - Align the element to the right.
 * *
 */
export  type SmithchartAlignment = 
/** Define the left alignment. */
'Near' | 
/** Define the center alignment. */
'Center' | 
/** Define the right alignment. */
'Far';
export  type SmithchartExportType = 
/** Used to export a image as png format */
'PNG' | 
/** Used to export a image as jpeg format */
'JPEG' | 
/** Used to export a file as svg format */
'SVG' | 
/** Used to export a file as pdf format */
'PDF';
/**
 * Specifies TreeMap beforePrint event name.
 * @private
 */
export  const smithchartBeforePrint: string;
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/export.d.ts
/**
 * Annotation Module handles the Annotation for Maps
 */
export  class ExportUtils1 {
    private control;
    private smithchartPrint;
    /**
     * Constructor for Maps
     * @param control
     */
    constructor(control: Smithchart);
    /**
     * To print the Maps
     * @param elements
     */
    print(elements?: string[] | string | Element): void;
    /**
     * To get the html string of the Maps
     * @param svgElements
     * @private
     */
    getHTMLContent(svgElements?: string[] | string | Element): Element;
    /**
     * To export the file as image/svg format
     * @param type
     * @param fileName
     */
    export(exportType: SmithchartExportType, fileName: string, orientation?: pdfExport.PdfPageOrientation): void;
    /**
     * To trigger the download element
     * @param fileName
     * @param type
     * @param url
     */
    triggerDownload(fileName: string, exportType: SmithchartExportType, url: string, isDownload: boolean): void;
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/helper.d.ts
export  function createSvg(smithchart: Smithchart): void;
export  function getElement(id: string): Element;
/**
 * @private
 * Trim the title text
 */
export  function textTrim(maxwidth: number, text: string, font: SmithchartFontModel): string;
/**
 * Function     to compile the template function for maps.
 * @returns Function
 * @private
 */
export  function getTemplateFunction(templateString: string): Function;
export  function convertElementFromLabel(element: Element, labelId: string, data: object, index: number, smithchart: Smithchart): HTMLElement;
export  function _getEpsilonValue(): number;
/**
 * Method to calculate the width and height of the smithchart
 */
export  function calculateSize(smithchart: Smithchart): void;
/**
 * Animation for template
 * @private
 */
export  function templateAnimate(smithchart: Smithchart, element: Element, delay: number, duration: number, name: base.Effect): void;
/** @private */
export  function stringToNumber(value: string, containerSize: number): number;
/**
 * Internal use of path options
 * @private
 */
export  class PathOption {
    id: string;
    opacity: number;
    fill: string;
    stroke: string;
    ['stroke-width']: number;
    ['stroke-dasharray']: string;
    d: string;
    constructor(id: string, fill: string, width: number, color: string, opacity?: number, dashArray?: string, d?: string);
}
/**
 * Internal use of rectangle options
 * @private
 */
export  class RectOption1 extends PathOption {
    x: number;
    y: number;
    height: number;
    width: number;
    transform: string;
    constructor(id: string, fill: string, border: SmithchartBorderModel, opacity: number, rect: SmithchartRect);
}
/**
 * Internal use of circle options
 * @private
 */
export  class CircleOption1 extends PathOption {
    cy: number;
    cx: number;
    r: number;
    ['stroke-dasharray']: string;
    constructor(id: string, fill: string, border: SmithchartBorderModel, opacity: number, cx: number, cy: number, r: number, dashArray: string);
}
export  function measureText(text: string, font: SmithchartFontModel): SmithchartSize;
/**
 * Internal use of text options
 * @private
 */
export  class TextOption {
    id: string;
    anchor: string;
    text: string;
    x: number;
    y: number;
    constructor(id?: string, x?: number, y?: number, anchor?: string, text?: string);
}
/**
 * To remove element by id
 */
export  function removeElement(id: string): void;
/**
 * Animation base.Effect Calculation Started Here
 * @param currentTime
 * @param startValue
 * @param endValue
 * @param duration
 * @private
 */
export  function linear(currentTime: number, startValue: number, endValue: number, duration: number): number;
export  function reverselinear(currentTime: number, startValue: number, endValue: number, duration: number): number;
/** @private */
export  function getAnimationFunction(effect: string): Function;
/**
 * Internal rendering of text
 * @private
 */
export  function renderTextElement(options: TextOption, font: SmithchartFontModel, color: string, parent: HTMLElement | Element): Element;
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/utils-model.d.ts
/**
 * Interface for a class SmithchartFont
 */
export interface SmithchartFontModel {
    /**
     * font family for text.
     */
    fontFamily?: string;
    /**
     * font style for text.
     * @default 'Normal'
     */
    fontStyle?: string;
    /**
     * font weight for text.
     * @default 'Regular'
     */
    fontWeight?: string;
    /**
     * Color for the text.
     * @default ''
     */
    color?: string;
    /**
     * font size for text.
     * @default '12px'
     */
    size?: string;
    /**
     * font opacity for text.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class SmithchartMargin
 */
export interface SmithchartMarginModel {
    /**
     * top margin of chartArea.
     * @default 10
     */
    top?: number;
    /**
     * bottom margin of chartArea.
     * @default 10
     */
    bottom?: number;
    /**
     * right margin of chartArea.
     * @default 10
     */
    right?: number;
    /**
     * left margin of chartArea.
     * @default 10
     */
    left?: number;
}
/**
 * Interface for a class SmithchartBorder
 */
export interface SmithchartBorderModel {
    /**
     * width for smithchart border.
     * @default 0
     */
    width?: number;
    /**
     * opacity for smithchart border.
     * @default 1
     */
    opacity?: number;
    /**
     * color for smithchart border .
     * @default 'transparent'
     */
    color?: string;
}
/**
 * Interface for a class SmithchartRect
 */
export interface SmithchartRectModel {
}
/**
 * Interface for a class LabelCollection
 */
export interface LabelCollectionModel {
}
/**
 * Interface for a class LegendSeries
 */
export interface LegendSeriesModel {
}
/**
 * Interface for a class LabelRegion
 */
export interface LabelRegionModel {
}
/**
 * Interface for a class HorizontalLabelCollection
 */
export interface HorizontalLabelCollectionModel extends LabelCollectionModel{
}
/**
 * Interface for a class RadialLabelCollections
 */
export interface RadialLabelCollectionsModel extends HorizontalLabelCollectionModel{
}
/**
 * Interface for a class LineSegment
 */
export interface LineSegmentModel {
}
/**
 * Interface for a class PointRegion
 */
export interface PointRegionModel {
}
/**
 * Interface for a class Point
 */
export interface PointModel {
}
/**
 * Interface for a class ClosestPoint
 */
export interface ClosestPointModel {
}
/**
 * Interface for a class MarkerOptions
 */
export interface MarkerOptionsModel {
}
/**
 * Interface for a class SmithchartLabelPosition
 */
export interface SmithchartLabelPositionModel {
}
/**
 * Interface for a class Direction
 */
export interface DirectionModel {
}
/**
 * Interface for a class DataLabelTextOptions
 */
export interface DataLabelTextOptionsModel {
}
/**
 * Interface for a class LabelOption
 */
export interface LabelOptionModel {
}
/**
 * Interface for a class SmithchartSize
 * @private
 */
export interface SmithchartSizeModel {
}
/**
 * Interface for a class GridArcPoints
 * @private
 */
export interface GridArcPointsModel {
}
//node_modules/@syncfusion/ej2-charts/src/smithchart/utils/utils.d.ts
export  class SmithchartFont extends base.ChildProperty<SmithchartFont> {
    /**
     * font family for text.
     */
    fontFamily: string;
    /**
     * font style for text.
     * @default 'Normal'
     */
    fontStyle: string;
    /**
     * font weight for text.
     * @default 'Regular'
     */
    fontWeight: string;
    /**
     * Color for the text.
     * @default ''
     */
    color: string;
    /**
     * font size for text.
     * @default '12px'
     */
    size: string;
    /**
     * font opacity for text.
     * @default 1
     */
    opacity: number;
}
export  class SmithchartMargin extends base.ChildProperty<SmithchartMargin> {
    /**
     * top margin of chartArea.
     * @default 10
     */
    top: number;
    /**
     * bottom margin of chartArea.
     * @default 10
     */
    bottom: number;
    /**
     * right margin of chartArea.
     * @default 10
     */
    right: number;
    /**
     * left margin of chartArea.
     * @default 10
     */
    left: number;
}
export  class SmithchartBorder extends base.ChildProperty<SmithchartBorder> {
    /**
     * width for smithchart border.
     * @default 0
     */
    width: number;
    /**
     * opacity for smithchart border.
     * @default 1
     */
    opacity: number;
    /**
     * color for smithchart border .
     * @default 'transparent'
     */
    color: string;
}
/**
 * Internal use of type rect
 */
export  class SmithchartRect {
    /** x value for rect */
    x: number;
    y: number;
    width: number;
    height: number;
    constructor(x: number, y: number, width: number, height: number);
}
export  class LabelCollection {
    centerX: number;
    centerY: number;
    radius: number;
    value: number;
}
export  class LegendSeries {
    text: string;
    seriesIndex: number;
    shape: string;
    fill: string;
    bounds: SmithchartSize;
}
export  class LabelRegion {
    bounds: SmithchartRect;
    labelText: string;
}
export  class HorizontalLabelCollection extends LabelCollection {
    region: LabelRegion;
}
export  class RadialLabelCollections extends HorizontalLabelCollection {
    angle: number;
}
export  class LineSegment {
    x1: number;
    x2: number;
    y1: number;
    y2: number;
}
export  class PointRegion {
    point: Point;
    x: number;
    y: number;
}
/**
 * Smithchart internal class for point
 */
export  class Point {
    x: number;
    y: number;
}
export  class ClosestPoint {
    location: Point;
    index: number;
}
export  class MarkerOptions {
    id: string;
    fill: string;
    opacity: number;
    borderColor: string;
    borderWidth: number;
    constructor(id?: string, fill?: string, borderColor?: string, borderWidth?: number, opacity?: number);
}
export  class SmithchartLabelPosition {
    textX: number;
    textY: number;
    x: number;
    y: number;
}
export  class Direction {
    counterclockwise: number;
    clockwise: number;
}
export  class DataLabelTextOptions {
    id: string;
    x: number;
    y: number;
    text: string;
    fill: string;
    font: SmithchartFontModel;
    xPosition: number;
    yPosition: number;
    width: number;
    height: number;
    location: Point;
    labelOptions: SmithchartLabelPosition;
    visible: boolean;
    connectorFlag: boolean;
}
export  class LabelOption {
    textOptions: DataLabelTextOptions[];
}
/** @private */
export  class SmithchartSize {
    height: number;
    width: number;
    constructor(width: number, height: number);
}
export  class GridArcPoints {
    startPoint: Point;
    endPoint: Point;
    rotationAngle: number;
    sweepDirection: number;
    isLargeArc: boolean;
    size: SmithchartSize;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/index.d.ts
/**
 * Exporting all modules from Sparkline Component
 */
//node_modules/@syncfusion/ej2-charts/src/sparkline/model/base-model.d.ts
/**
 * Interface for a class SparklineBorder
 */
export interface SparklineBorderModel {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     */
    color?: string;
    /**
     * The width of the border in pixels.
     */
    width?: number;
}
/**
 * Interface for a class SparklineFont
 */
export interface SparklineFontModel {
    /**
     * Font size for the text.
     */
    size?: string;
    /**
     * Color for the text.
     */
    color?: string;
    /**
     * FontFamily for the text.
     */
    fontFamily?: string;
    /**
     * FontWeight for the text.
     */
    fontWeight?: string;
    /**
     * FontStyle for the text.
     */
    fontStyle?: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class TrackLineSettings
 */
export interface TrackLineSettingsModel {
    /**
     * Toggle the tracker line visibility.
     * @default false
     */
    visible?: boolean;
    /**
     * To config the tracker line color.
     */
    color?: string;
    /**
     * To config the tracker line width.
     * @default 1
     */
    width?: number;
}
/**
 * Interface for a class SparklineTooltipSettings
 */
export interface SparklineTooltipSettingsModel {
    /**
     * Toggle the tooltip visibility.
     * @default false
     */
    visible?: boolean;
    /**
     * To customize the tooltip fill color.
     */
    fill?: string;
    /**
     * To customize the tooltip template.
     */
    template?: string;
    /**
     * To customize the tooltip format.
     */
    format?: string;
    /**
     * To configure tooltip border color and width.
     */
    border?: SparklineBorderModel;
    /**
     * To configure tooltip text styles.
     */
    // tslint:disable-next-line
    textStyle?: SparklineFontModel;
    /**
     * To configure the tracker line options.
     */
    trackLineSettings?: TrackLineSettingsModel;
}
/**
 * Interface for a class ContainerArea
 */
export interface ContainerAreaModel {
    /**
     * To configure Sparkline background color.
     * @default 'transparent'
     */
    background?: string;
    /**
     * To configure Sparkline border color and width.
     */
    border?: SparklineBorderModel;
}
/**
 * Interface for a class LineSettings
 */
export interface LineSettingsModel {
    /**
     * To toggle the axis line visibility.
     * @default `false`
     */
    visible?: boolean;
    /**
     * To configure the sparkline axis line color.
     */
    color?: string;
    /**
     * To configure the sparkline axis line dashArray.
     * @default ''
     */
    dashArray?: string;
    /**
     * To configure the sparkline axis line width.
     * @default 1.
     */
    width?: number;
    /**
     * To configure the sparkline axis line opacity.
     * @default 1.
     */
    opacity?: number;
}
/**
 * Interface for a class RangeBandSettings
 */
export interface RangeBandSettingsModel {
    /**
     * To configure sparkline start range
     * @aspDefaultValueIgnore 
     */
    startRange?: number;
    /**
     * To configure sparkline end range
     * @aspDefaultValueIgnore 
     */
    endRange?: number;
    /**
     * To configure sparkline rangeband color
     */
    color?: string;
    /**
     * To configure sparkline rangeband opacity
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class AxisSettings
 */
export interface AxisSettingsModel {
    /**
     * To configure Sparkline x axis min value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    minX?: number;
    /**
     * To configure Sparkline x axis max value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    maxX?: number;
    /**
     * To configure Sparkline y axis min value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    minY?: number;
    /**
     * To configure Sparkline y axis max value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    maxY?: number;
    /**
     * To configure Sparkline horizontal axis line position.
     * @default 0
     * @blazorDefaultValue 0
     */
    value?: number;
    /**
     * To configure Sparkline axis line settings.
     */
    lineSettings?: LineSettingsModel;
}
/**
 * Interface for a class Padding
 */
export interface PaddingModel {
    /**
     * To configure Sparkline left padding.
     * @default 5
     */
    left?: number;
    /**
     * To configure Sparkline right padding.
     * @default 5
     */
    right?: number;
    /**
     * To configure Sparkline bottom padding.
     * @default 5
     */
    bottom?: number;
    /**
     * To configure Sparkline top padding.
     * @default 5
     */
    top?: number;
}
/**
 * Interface for a class SparklineMarkerSettings
 */
export interface SparklineMarkerSettingsModel {
    /**
     * To toggle the marker visibility.
     * @default `[]`.
     */
    visible?: VisibleType[];
    /**
     * To configure the marker opacity.
     * @default 1
     */
    opacity?: number;
    /**
     * To configure the marker size.
     * @default 5
     */
    size?: number;
    /**
     * To configure the marker fill color.
     * @default '#00bdae'
     */
    fill?: string;
    /**
     * To configure Sparkline marker border color and width.
     */
    border?: SparklineBorderModel;
}
/**
 * Interface for a class LabelOffset
 */
export interface LabelOffsetModel {
    /**
     * To move the datalabel horizontally.
     */
    x?: number;
    /**
     * To move the datalabel vertically.
     */
    y?: number;
}
/**
 * Interface for a class SparklineDataLabelSettings
 */
export interface SparklineDataLabelSettingsModel {
    /**
     * To toggle the dataLabel visibility.
     * @default `[]`.
     */
    visible?: VisibleType[];
    /**
     * To configure the dataLabel opacity.
     * @default 1
     */
    opacity?: number;
    /**
     * To configure the dataLabel fill color.
     * @default 'transparent'
     */
    fill?: string;
    /**
     * To configure the dataLabel format the value.
     * @default ''
     */
    format?: string;
    /**
     * To configure Sparkline dataLabel border color and width.
     */
    border?: SparklineBorderModel;
    /**
     * To configure Sparkline dataLabel text styles.
     */
    // tslint:disable-next-line
    textStyle?: SparklineFontModel;
    /**
     * To configure Sparkline dataLabel offset.
     */
    offset?: LabelOffsetModel;
    /**
     * To change the edge dataLabel placement.
     * @default 'None'.
     */
    edgeLabelMode?: EdgeLabelMode;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/model/base.d.ts
/**
 * Sparkline base API Class declarations.
 */
/**
 * Configures the borders in the Sparkline.
 */
export  class SparklineBorder extends base.ChildProperty<SparklineBorder> {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     */
    color: string;
    /**
     * The width of the border in pixels.
     */
    width: number;
}
/**
 * Configures the fonts in sparklines.
 */
export  class SparklineFont extends base.ChildProperty<SparklineFont> {
    /**
     * Font size for the text.
     */
    size: string;
    /**
     * Color for the text.
     */
    color: string;
    /**
     * FontFamily for the text.
     */
    fontFamily: string;
    /**
     * FontWeight for the text.
     */
    fontWeight: string;
    /**
     * FontStyle for the text.
     */
    fontStyle: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity: number;
}
/**
 * To configure the tracker line settings.
 */
export  class TrackLineSettings extends base.ChildProperty<TrackLineSettings> {
    /**
     * Toggle the tracker line visibility.
     * @default false
     */
    visible: boolean;
    /**
     * To config the tracker line color.
     */
    color: string;
    /**
     * To config the tracker line width.
     * @default 1
     */
    width: number;
}
/**
 * To configure the tooltip settings for sparkline.
 */
export  class SparklineTooltipSettings extends base.ChildProperty<SparklineTooltipSettings> {
    /**
     * Toggle the tooltip visibility.
     * @default false
     */
    visible: boolean;
    /**
     * To customize the tooltip fill color.
     */
    fill: string;
    /**
     * To customize the tooltip template.
     */
    template: string;
    /**
     * To customize the tooltip format.
     */
    format: string;
    /**
     * To configure tooltip border color and width.
     */
    border: SparklineBorderModel;
    /**
     * To configure tooltip text styles.
     */
    textStyle: SparklineFontModel;
    /**
     * To configure the tracker line options.
     */
    trackLineSettings: TrackLineSettingsModel;
}
/**
 * To configure the sparkline container area customization
 */
export  class ContainerArea extends base.ChildProperty<ContainerArea> {
    /**
     * To configure Sparkline background color.
     * @default 'transparent'
     */
    background: string;
    /**
     * To configure Sparkline border color and width.
     */
    border: SparklineBorderModel;
}
/**
 * To configure axis line settings
 */
export  class LineSettings extends base.ChildProperty<LineSettings> {
    /**
     * To toggle the axis line visibility.
     * @default `false`
     */
    visible: boolean;
    /**
     * To configure the sparkline axis line color.
     */
    color: string;
    /**
     * To configure the sparkline axis line dashArray.
     * @default ''
     */
    dashArray: string;
    /**
     * To configure the sparkline axis line width.
     * @default 1.
     */
    width: number;
    /**
     * To configure the sparkline axis line opacity.
     * @default 1.
     */
    opacity: number;
}
/**
 * To configure the sparkline rangeband
 */
export  class RangeBandSettings extends base.ChildProperty<RangeBandSettings> {
    /**
     * To configure sparkline start range
     * @aspDefaultValueIgnore
     */
    startRange: number;
    /**
     * To configure sparkline end range
     * @aspDefaultValueIgnore
     */
    endRange: number;
    /**
     * To configure sparkline rangeband color
     */
    color: string;
    /**
     * To configure sparkline rangeband opacity
     * @default 1
     */
    opacity: number;
}
/**
 * To configure the sparkline axis
 */
export  class AxisSettings extends base.ChildProperty<AxisSettings> {
    /**
     * To configure Sparkline x axis min value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    minX: number;
    /**
     * To configure Sparkline x axis max value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    maxX: number;
    /**
     * To configure Sparkline y axis min value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    minY: number;
    /**
     * To configure Sparkline y axis max value.
     * @aspDefaultValueIgnore
     * @blazorDefaultValue null
     */
    maxY: number;
    /**
     * To configure Sparkline horizontal axis line position.
     * @default 0
     * @blazorDefaultValue 0
     */
    value: number;
    /**
     * To configure Sparkline axis line settings.
     */
    lineSettings: LineSettingsModel;
}
/**
 * To configure the sparkline padding.
 */
export  class Padding extends base.ChildProperty<Padding> {
    /**
     * To configure Sparkline left padding.
     * @default 5
     */
    left: number;
    /**
     * To configure Sparkline right padding.
     * @default 5
     */
    right: number;
    /**
     * To configure Sparkline bottom padding.
     * @default 5
     */
    bottom: number;
    /**
     * To configure Sparkline top padding.
     * @default 5
     */
    top: number;
}
/**
 * To configure the sparkline marker options.
 */
export  class SparklineMarkerSettings extends base.ChildProperty<SparklineMarkerSettings> {
    /**
     * To toggle the marker visibility.
     * @default `[]`.
     */
    visible: VisibleType[];
    /**
     * To configure the marker opacity.
     * @default 1
     */
    opacity: number;
    /**
     * To configure the marker size.
     * @default 5
     */
    size: number;
    /**
     * To configure the marker fill color.
     * @default '#00bdae'
     */
    fill: string;
    /**
     * To configure Sparkline marker border color and width.
     */
    border: SparklineBorderModel;
}
/**
 * To configure the datalabel offset
 */
export  class LabelOffset extends base.ChildProperty<LabelOffset> {
    /**
     * To move the datalabel horizontally.
     */
    x: number;
    /**
     * To move the datalabel vertically.
     */
    y: number;
}
/**
 * To configure the sparkline dataLabel options.
 */
export  class SparklineDataLabelSettings extends base.ChildProperty<SparklineDataLabelSettings> {
    /**
     * To toggle the dataLabel visibility.
     * @default `[]`.
     */
    visible: VisibleType[];
    /**
     * To configure the dataLabel opacity.
     * @default 1
     */
    opacity: number;
    /**
     * To configure the dataLabel fill color.
     * @default 'transparent'
     */
    fill: string;
    /**
     * To configure the dataLabel format the value.
     * @default ''
     */
    format: string;
    /**
     * To configure Sparkline dataLabel border color and width.
     */
    border: SparklineBorderModel;
    /**
     * To configure Sparkline dataLabel text styles.
     */
    textStyle: SparklineFontModel;
    /**
     * To configure Sparkline dataLabel offset.
     */
    offset: LabelOffsetModel;
    /**
     * To change the edge dataLabel placement.
     * @default 'None'.
     */
    edgeLabelMode: EdgeLabelMode;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/model/enum.d.ts
/**
 * Sparkline Enum
 */
/**
 * Specifies the sparkline types.
 * `Line`, `Column`, `WinLoss`, `Pie` and `Area`.
 */
export  type SparklineType = 
/** Define the Sparkline Line type series. */
'Line' | 
/** Define the Sparkline Column type series. */
'Column' | 
/** Define the Sparkline WinLoss type series. */
'WinLoss' | 
/** Define the Sparkline Pie type series. */
'Pie' | 
/** Define the Sparkline Area type series. */
'Area';
/**
 * Specifies the sparkline data value types.
 * `Numeric`, `Category` and `DateTime`.
 */
export  type SparklineValueType = 
/** Define the Sparkline Numeric value type series. */
'Numeric' | 
/** Define the Sparkline Category value type series. */
'Category' | 
/** Define the Sparkline DateTime value type series. */
'DateTime';
/**
 * Specifies the sparkline marker | datalabel visible types.
 * `All`,  `High`,  `Low`,  `Start`,  `End`,  `Negative` and `None`.
 */
export  type VisibleType = 
/** Define the Sparkline marker | datalabel  Visbile All type */
'All' | 
/** Define the Sparkline marker | datalabel Visbile High type */
'High' | 
/** Define the Sparkline marker | datalabel Visbile Low type */
'Low' | 
/** Define the Sparkline marker | datalabel Visbile Start type */
'Start' | 
/** Define the Sparkline marker | datalabel Visbile End type */
'End' | 
/** Define the Sparkline marker | datalabel Visbile Negative type */
'Negative';
/**
 * Defines Theme of the sparkline. They are
 * * Material - Render a sparkline with Material theme.
 * * Fabric - Render a sparkline with Fabric theme
 * * Bootstrap - Render a sparkline with Bootstrap theme
 * * HighContrast - Render a sparkline with HighContrast theme
 * * Dark - Render a sparkline with Dark theme
 */
export  type SparklineTheme = 
/**  Render a sparkline with Material theme. */
'Material' | 
/**  Render a sparkline with Fabric theme. */
'Fabric' | 
/**  Render a sparkline with Bootstrap theme. */
'Bootstrap' | 
/**  Render a sparkline with HighContrast Light theme. */
'HighContrastLight' | 
/**  Render a sparkline with Material Dark theme. */
'MaterialDark' | 
/**  Render a sparkline with Fabric Dark theme. */
'FabricDark' | 
/**  Render a sparkline with Highcontrast Dark theme. */
'HighContrast' | 
/**  Render a sparkline with Bootstrap Dark theme. */
'BootstrapDark' | 
/** Render a sparkline with Bootstrap4 theme. */
'Bootstrap4';
/**
 * Defines edge data label placement for datalabel, if exceeds the sparkline area horizontally.
 * * None - Edge data label shown as clipped text.
 * * Shift - Edge data label moved inside the sparkline area.
 * * Hide - Edge data label will hide, if exceeds the sparkline area.
 */
export  type EdgeLabelMode = 
/** Edge data label shown as clipped text */
'None' | 
/** Edge data label moved inside the sparkline area */
'Shift' | 
/** Edge data label will hide, if exceeds the sparkline area */
'Hide';
//node_modules/@syncfusion/ej2-charts/src/sparkline/model/interface.d.ts
/**
 * Sparkline interface file.
 */
/**
 * Specifies sparkline Events
 * @private
 */
export interface ISparklineEventArgs {
    /** Defines the name of the event */
    name: string;
    /** Defines the event cancel status */
    cancel: boolean;
}
/**
 * Specifies the interface for themes.
 */
export interface IThemes {
    /** Defines the color of the axis line */
    axisLineColor: string;
    /** Defines the color of the range band */
    rangeBandColor: string;
    /** Defines the font color of the data labels */
    dataLabelColor: string;
    /** Defines the background color of the tooltip */
    tooltipFill: string;
    /** Defines the font color of the tooltip */
    tooltipFontColor: string;
    /** Defines the background color of the sparkline */
    background: string;
    /** Defines the color of the tracker line */
    trackerLineColor: string;
    /** Defines the font style of the text */
    fontFamily?: string;
    /** Defines the tooltip fill color opacity */
    tooltipFillOpacity?: number;
    /** Defines the tooltip text opacity */
    tooltipTextOpacity?: number;
    /** Defines the label font style */
    labelFontFamily?: string;
}
/**
 * Specifies the Loaded Event arguments.
 */
export interface ISparklineLoadedEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
}
/**
 * Specifies the Load Event arguments.
 * @deprecated
 */
export interface ISparklineLoadEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
}
/**
 * Specifies the axis rendering Event arguments.
 * @deprecated
 */
export interface IAxisRenderingEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
    /** Defines the sparkline axis min x */
    minX: number;
    /** Defines the sparkline axis max x */
    maxX: number;
    /** Defines the sparkline axis min y */
    minY: number;
    /** Defines the sparkline axis max y */
    maxY: number;
    /** Defines the sparkline axis value */
    value: number;
    /** Defines the sparkline axis line color */
    lineColor: string;
    /** Defines the sparkline axis line width */
    lineWidth: number;
}
/**
 * Specifies the sparkline series rendering Event arguments.
 */
export interface ISeriesRenderingEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
    /** Defines the sparkline series fill color */
    fill: string;
    /** Defines the sparkline series line width for applicable line and area. */
    lineWidth: number;
    /** Defines the current sparkline series border */
    border: SparklineBorderModel;
}
/**
 * Specifies the sparkline point related Event arguments.
 */
export interface ISparklinePointEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline?: Sparkline;
    /** Defines the current sparkline point index */
    pointIndex: number;
    /** Defines the current sparkline point fill color */
    fill: string;
    /** Defines the current sparkline point border */
    border: SparklineBorderModel;
}
/**
 * Specifies the sparkline mouse related Event arguments.
 */
export interface ISparklineMouseEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline?: Sparkline;
    /** Defines the current sparkline mouse event */
    event: PointerEvent | MouseEvent;
}
/**
 * Specifies the sparkline mouse point region Event arguments.
 */
export interface IPointRegionEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline?: Sparkline;
    /** Defines the sparkline point index region event  */
    pointIndex: number;
    /** Defines the current sparkline mouse event */
    event: PointerEvent | MouseEvent;
}
/**
 * Specifies the sparkline datalabel rendering Event arguments.
 * @deprecated
 */
export interface IDataLabelRenderingEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
    /** Defines the current sparkline label text */
    text: string;
    /** Defines the current sparkline label text location x */
    x: number;
    /** Defines the current sparkline label text location y */
    y: number;
    /** Defines the current sparkline label text color */
    color: string;
    /** Defines the current sparkline label rect fill color */
    fill: string;
    /** Defines the current sparkline label rect border */
    border: SparklineBorderModel;
    /** Defines the current sparkline label point index */
    pointIndex: number;
}
/**
 * Specifies the sparkline marker rendering Event arguments.
 * @deprecated
 */
export interface IMarkerRenderingEventArgs extends ISparklineEventArgs {
    /** Defines the current sparkline instance */
    sparkline: Sparkline;
    /** Defines the current sparkline marker location x */
    x: number;
    /** Defines the current sparkline marker location y */
    y: number;
    /** Defines the sparkline marker radius */
    size: number;
    /** Defines the current sparkline marker fill color */
    fill: string;
    /** Defines the current sparkline marker border */
    border: SparklineBorderModel;
    /** Defines the current sparkline label point index */
    pointIndex: number;
}
/**
 * Sparkline Resize event arguments.
 */
export interface ISparklineResizeEventArgs {
    /** Defines the name of the Event */
    name: string;
    /** Defines the previous size of the sparkline */
    previousSize: Size;
    /** Defines the current size of the sparkline */
    currentSize: Size;
    /** Defines the sparkline instance */
    sparkline: Sparkline;
}
/**
 * Sparkline tooltip event args.
 * @deprecated
 */
export interface ITooltipRenderingEventArgs extends ISparklineEventArgs {
    /** Defines tooltip text */
    text?: string[];
    /** Defines tooltip text style */
    textStyle?: SparklineFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/rendering/sparkline-renderer.d.ts
/**
 * Sparkline rendering calculation file
 */
export  class SparklineRenderer {
    /**
     * To process sparkline instance internally.
     */
    private sparkline;
    private min;
    private maxLength;
    private unitX;
    private unitY;
    private axisColor;
    private axisWidth;
    private axisValue;
    private pointRegions;
    private clipId;
    /**
     * To get visible points options internally.
     * @private
     */
    visiblePoints: SparkValues[];
    private axisHeight;
    /**
     * To process highpoint index color for tooltip customization
     * @private
     */
    highPointIndex: number;
    /**
     * To process low point index color for tooltip customization
     * @private
     */
    lowPointIndex: number;
    /**
     * To process start point index color for tooltip customization
     * @private
     */
    startPointIndex: number;
    /**
     * To process end point index color for tooltip customization
     * @private
     */
    endPointIndex: number;
    /**
     * To process negative point index color for tooltip customization
     * @private
     */
    negativePointIndexes: number[];
    /**
     * Sparkline data calculations
     * @param sparkline
     */
    constructor(sparkline: Sparkline);
    /**
     * To process the sparkline data
     */
    processData(): void;
    processDataManager(): void;
    /**
     * To process sparkline category data.
     */
    private processCategory;
    /**
     * To process sparkline DateTime data.
     */
    private processDateTime;
    /**
     * To render sparkline series.
     * @private
     */
    renderSeries(): void;
    /**
     * To render a range band
     */
    private rangeBand;
    /**
     * To render line series
     */
    private renderLine;
    /**
     * To render pie series
     */
    private renderPie;
    /**
     * To get special point color and option for Pie series.
     */
    private getPieSpecialPoint;
    /**
     * To render area series
     */
    private renderArea;
    /**
     * To render column series
     */
    private renderColumn;
    /**
     * To render WinLoss series
     */
    private renderWinLoss;
    private renderMarker;
    /**
     * To get special point color and option.
     */
    private getSpecialPoint;
    /**
     * To render data label for sparkline.
     */
    private renderLabel;
    private arrangeLabelPosition;
    /**
     * To get special point color and option.
     */
    private getLabelVisible;
    /**
     * To format text
     */
    private formatter;
    /**
     * To calculate min max for x and y axis
     */
    private axisCalculation;
    /**
     * To find x axis interval.
     */
    private getInterval;
    /**
     * To calculate axis ranges internally.
     */
    private findRanges;
    /**
     * To render the sparkline axis
     */
    private drawAxis;
    /**
     * To trigger point render event
     */
    private triggerPointRender;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/rendering/sparkline-tooltip.d.ts
/**
 * Sparkline Tooltip Module
 */
export  class SparklineTooltip {
    /**
     * Sparkline instance in tooltip.
     */
    private sparkline;
    /**
     * Sparkline current point index.
     */
    private pointIndex;
    /**
     * Sparkline tooltip timer.
     */
    private clearTooltip;
    constructor(sparkline: Sparkline);
    /**
     * @hidden
     */
    private addEventListener;
    private mouseLeaveHandler;
    private mouseUpHandler;
    private fadeOut;
    /**
     * To remove tooltip and tracker elements.
     * @private
     */
    removeTooltipElements(): void;
    private mouseMoveHandler;
    private processTooltip;
    /**
     * To render tracker line
     */
    private renderTrackerLine;
    /**
     * To render line series
     */
    private renderTooltip;
    /**
     * To get tooltip format.
     */
    private getFormat;
    private formatValue;
    /**
     * To remove tracker line.
     */
    private removeTracker;
    /**
     * To remove tooltip element.
     */
    private removeTooltip;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the tooltip.
     */
    destroy(sparkline: Sparkline): void;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/sparkline-model.d.ts
/**
 * Interface for a class Sparkline
 */
export interface SparklineModel extends base.ComponentModel{
    /**
     * To configure Sparkline width.
     */
    width?: string;
    /**
     * To configure Sparkline height.
     */
    height?: string;
    /**
     * To configure Sparkline points border color and width.
     */
    border?: SparklineBorderModel;
    /**
     * To configure Sparkline series type.
     * @default 'Line'
     */
    type?: SparklineType;
    /**
     * To configure sparkline data source.
     * @isGenericType true
     * @default null
     */
    dataSource?: Object[] | data.DataManager;
    /**
     * Specifies the query for filter the data.
     * @default null
     */
    query?: data.Query;
    /**
     * To configure sparkline series value type.
     * @default 'Numeric'
     */
    valueType?: SparklineValueType;
    /**
     * To configure sparkline series xName.
     * @default null
     */
    xName?: string;
    /**
     * To configure sparkline series yName.
     * @default null
     */
    yName?: string;
    /**
     * To configure sparkline series fill.
     * @default '#00bdae'
     */
    fill?: string;
    /**
     * To configure sparkline series highest y value point color.
     * @default ''
     */
    highPointColor?: string;
    /**
     * To configure sparkline series lowest y value point color.
     * @default ''
     */
    lowPointColor?: string;
    /**
     * To configure sparkline series first x value point color.
     * @default ''
     */
    startPointColor?: string;
    /**
     * To configure sparkline series last x value point color.
     * @default ''
     */
    endPointColor?: string;
    /**
     * To configure sparkline series negative y value point color.
     * @default ''
     */
    negativePointColor?: string;
    /**
     * To configure sparkline winloss series tie y value point color.
     * @default ''
     */
    tiePointColor?: string;
    /**
     * To configure sparkline series color palette. It applicable to column and pie type series.
     * @default []
     */
    palette?: string[];
    /**
     * To configure sparkline line series width.
     * @default '1'
     */
    lineWidth?: number;
    /**
     * To configure sparkline line series opacity.
     * @default '1'
     */
    opacity?: number;
    /**
     * To apply internationalization for sparkline.
     * @default null
     */
    format?: string;
    /**
     * To enable the separator
     * @default false
     */
    useGroupingSeparator?: boolean;
    /**
     * To configure Sparkline tooltip settings.
     */
    tooltipSettings?: SparklineTooltipSettingsModel;
    /**
     * To configure Sparkline container area customization.
     */
    containerArea?: ContainerAreaModel;
    /**
     * To configure Sparkline axis line customization.
     */
    rangeBandSettings?: RangeBandSettingsModel[];
    /**
     * To configure Sparkline container area customization.
     */
    axisSettings?: AxisSettingsModel;
    /**
     * To configure Sparkline marker configuration.
     */
    markerSettings?: SparklineMarkerSettingsModel;
    /**
     * To configure Sparkline dataLabel configuration.
     */
    dataLabelSettings?: SparklineDataLabelSettingsModel;
    /**
     * To configure Sparkline container area customization.
     */
    padding?: PaddingModel;
    /**
     * To configure sparkline theme.
     * @default 'Material'
     */
    theme?: SparklineTheme;
    /**
     * Triggers after sparkline rendered.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<ISparklineLoadedEventArgs>;
    /**
     * Triggers before sparkline render.
     * @event
     * @blazorProperty 'OnLoad'
     */
    load?: base.EmitType<ISparklineLoadEventArgs>;
    /**
     * Triggers before sparkline tooltip render.
     * @event
     * @deprecated
     * @blazorProperty 'OnTooltipInitialize'
     */
    tooltipInitialize?: base.EmitType<ITooltipRenderingEventArgs>;
    /**
     * Triggers before sparkline series render.
     * @event
     * @blazorProperty 'SeriesRendering'
     */
    seriesRendering?: base.EmitType<ISeriesRenderingEventArgs>;
    /**
     * Triggers before sparkline axis render.
     * @event
     * @deprecated
     * @blazorProperty 'AxisRendering'
     */
    axisRendering?: base.EmitType<IAxisRenderingEventArgs>;
    /**
     * Triggers before sparkline points render.
     * @event
     * @deprecated
     * @blazorProperty 'PointRendering'
     */
    pointRendering?: base.EmitType<ISparklinePointEventArgs>;
    /**
     * Triggers while mouse move on the sparkline point region.
     * @event
     * @blazorProperty 'OnPointRegionMouseMove'
     */
    pointRegionMouseMove?: base.EmitType<IPointRegionEventArgs>;
    /**
     * Triggers while mouse click on the sparkline point region.
     * @event
     * @blazorProperty 'OnPointRegionMouseClick'
     */
    pointRegionMouseClick?: base.EmitType<IPointRegionEventArgs>;
    /**
     * Triggers while mouse move on the sparkline container.
     * @event
     * @blazorProperty 'OnSparklineMouseMove'
     */
    sparklineMouseMove?: base.EmitType<ISparklineMouseEventArgs>;
    /**
     * Triggers while mouse click on the sparkline container.
     * @event
     * @blazorProperty 'OnSparklineMouseClick'
     */
    sparklineMouseClick?: base.EmitType<ISparklineMouseEventArgs>;
    /**
     * Triggers before the sparkline datalabel render.
     * @event
     * @deprecated
     * @blazorProperty 'DataLabelRendering'
     */
    dataLabelRendering?: base.EmitType<IDataLabelRenderingEventArgs>;
    /**
     * Triggers before the sparkline marker render.
     * @event
     * @deprecated
     * @blazorProperty 'MarkerRendering'
     */
    markerRendering?: base.EmitType<IMarkerRenderingEventArgs>;
    /**
     * Triggers on resizing the sparkline.
     * @event
     * @blazorProperty 'Resizing'
     */
    resize?: base.EmitType<ISparklineResizeEventArgs>;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/sparkline.d.ts
/**
 * Represents the Sparkline control.
 * ```html
 * <div id="sparkline"/>
 * <script>
 *   var sparkline = new Sparkline();
 *   sparkline.appendTo("#sparkline");
 * </script>
 * ```
 */
export  class Sparkline extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    sparklineTooltipModule: SparklineTooltip;
    /**
     * To configure Sparkline width.
     */
    width: string;
    /**
     * To configure Sparkline height.
     */
    height: string;
    /**
     * To configure Sparkline points border color and width.
     */
    border: SparklineBorderModel;
    /**
     * To configure Sparkline series type.
     * @default 'Line'
     */
    type: SparklineType;
    /**
     * To configure sparkline data source.
     * @isGenericType true
     * @default null
     */
    dataSource: Object[] | data.DataManager;
    /**
     * Specifies the query for filter the data.
     * @default null
     */
    query: data.Query;
    /**
     * To configure sparkline series value type.
     * @default 'Numeric'
     */
    valueType: SparklineValueType;
    /**
     * To configure sparkline series xName.
     * @default null
     */
    xName: string;
    /**
     * To configure sparkline series yName.
     * @default null
     */
    yName: string;
    /**
     * To configure sparkline series fill.
     * @default '#00bdae'
     */
    fill: string;
    /**
     * To configure sparkline series highest y value point color.
     * @default ''
     */
    highPointColor: string;
    /**
     * To configure sparkline series lowest y value point color.
     * @default ''
     */
    lowPointColor: string;
    /**
     * To configure sparkline series first x value point color.
     * @default ''
     */
    startPointColor: string;
    /**
     * To configure sparkline series last x value point color.
     * @default ''
     */
    endPointColor: string;
    /**
     * To configure sparkline series negative y value point color.
     * @default ''
     */
    negativePointColor: string;
    /**
     * To configure sparkline winloss series tie y value point color.
     * @default ''
     */
    tiePointColor: string;
    /**
     * To configure sparkline series color palette. It applicable to column and pie type series.
     * @default []
     */
    palette: string[];
    /**
     * To configure sparkline line series width.
     * @default '1'
     */
    lineWidth: number;
    /**
     * To configure sparkline line series opacity.
     * @default '1'
     */
    opacity: number;
    /**
     * To apply internationalization for sparkline.
     * @default null
     */
    format: string;
    /**
     * To enable the separator
     * @default false
     */
    useGroupingSeparator: boolean;
    /**
     * To configure Sparkline tooltip settings.
     */
    tooltipSettings: SparklineTooltipSettingsModel;
    /**
     * To configure Sparkline container area customization.
     */
    containerArea: ContainerAreaModel;
    /**
     * To configure Sparkline axis line customization.
     */
    rangeBandSettings: RangeBandSettingsModel[];
    /**
     * To configure Sparkline container area customization.
     */
    axisSettings: AxisSettingsModel;
    /**
     * To configure Sparkline marker configuration.
     */
    markerSettings: SparklineMarkerSettingsModel;
    /**
     * To configure Sparkline dataLabel configuration.
     */
    dataLabelSettings: SparklineDataLabelSettingsModel;
    /**
     * To configure Sparkline container area customization.
     */
    padding: PaddingModel;
    /**
     * To configure sparkline theme.
     * @default 'Material'
     */
    theme: SparklineTheme;
    /**
     * Triggers after sparkline rendered.
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<ISparklineLoadedEventArgs>;
    /**
     * Triggers before sparkline render.
     * @event
     * @blazorProperty 'OnLoad'
     */
    load: base.EmitType<ISparklineLoadEventArgs>;
    /**
     * Triggers before sparkline tooltip render.
     * @event
     * @deprecated
     * @blazorProperty 'OnTooltipInitialize'
     */
    tooltipInitialize: base.EmitType<ITooltipRenderingEventArgs>;
    /**
     * Triggers before sparkline series render.
     * @event
     * @blazorProperty 'SeriesRendering'
     */
    seriesRendering: base.EmitType<ISeriesRenderingEventArgs>;
    /**
     * Triggers before sparkline axis render.
     * @event
     * @deprecated
     * @blazorProperty 'AxisRendering'
     */
    axisRendering: base.EmitType<IAxisRenderingEventArgs>;
    /**
     * Triggers before sparkline points render.
     * @event
     * @deprecated
     * @blazorProperty 'PointRendering'
     */
    pointRendering: base.EmitType<ISparklinePointEventArgs>;
    /**
     * Triggers while mouse move on the sparkline point region.
     * @event
     * @blazorProperty 'OnPointRegionMouseMove'
     */
    pointRegionMouseMove: base.EmitType<IPointRegionEventArgs>;
    /**
     * Triggers while mouse click on the sparkline point region.
     * @event
     * @blazorProperty 'OnPointRegionMouseClick'
     */
    pointRegionMouseClick: base.EmitType<IPointRegionEventArgs>;
    /**
     * Triggers while mouse move on the sparkline container.
     * @event
     * @blazorProperty 'OnSparklineMouseMove'
     */
    sparklineMouseMove: base.EmitType<ISparklineMouseEventArgs>;
    /**
     * Triggers while mouse click on the sparkline container.
     * @event
     * @blazorProperty 'OnSparklineMouseClick'
     */
    sparklineMouseClick: base.EmitType<ISparklineMouseEventArgs>;
    /**
     * Triggers before the sparkline datalabel render.
     * @event
     * @deprecated
     * @blazorProperty 'DataLabelRendering'
     */
    dataLabelRendering: base.EmitType<IDataLabelRenderingEventArgs>;
    /**
     * Triggers before the sparkline marker render.
     * @event
     * @deprecated
     * @blazorProperty 'MarkerRendering'
     */
    markerRendering: base.EmitType<IMarkerRenderingEventArgs>;
    /**
     * Triggers on resizing the sparkline.
     * @event
     * @blazorProperty 'Resizing'
     */
    resize: base.EmitType<ISparklineResizeEventArgs>;
    /**
     * svg renderer object.
     * @private
     */
    renderer: svgBase.SvgRenderer;
    /**
     * sparkline renderer object.
     * @private
     */
    sparklineRenderer: SparklineRenderer;
    /**
     * sparkline svg element's object
     * @private
     */
    svgObject: Element;
    /** @private */
    isDevice: Boolean;
    /** @private */
    isTouch: Boolean;
    /** @private */
    mouseX: number;
    /** @private */
    mouseY: number;
    /**
     * resize event timer
     * @private
     */
    resizeTo: number;
    /**
     * Sparkline available height, width
     * @private
     */
    availableSize: Size;
    /**
     * Sparkline theme support
     *  @private
     */
    sparkTheme: IThemes;
    /**
     * localization object
     * @private
     */
    localeObject: base.L10n;
    /**
     * To process sparkline data internally.
     * @private
     */
    sparklineData: Object[] | data.DataManager;
    /**
     * It contains default values of localization values
     */
    private defaultLocalConstants;
    /**
     * Internal use of internationalization instance.
     * @private
     */
    intl: base.Internationalization;
    /** @private */
    isBlazor: boolean;
    /**
     * Constructor for creating the Sparkline widget
     */
    constructor(options?: SparklineModel, element?: string | HTMLElement);
    /**
     * Initializing pre-required values for sparkline.
     */
    protected preRender(): void;
    /**
     * Sparkline Elements rendering starting.
     */
    protected render(): void;
    /**
     * @private
     */
    processSparklineData(): void;
    /**
     * To render sparkline elements
     */
    renderSparkline(): void;
    /**
     * Create secondary element for the tooltip
     */
    private createDiv;
    /**
     * To set the left and top position for data label template for sparkline
     */
    private setSecondaryElementPosition;
    /**
     * @private
     * Render the sparkline border
     */
    private renderBorder;
    /**
     * To create svg element for sparkline
     */
    private createSVG;
    /**
     * To Remove the Sparkline SVG object
     */
    private removeSvg;
    /**
     * Method to set culture for sparkline
     */
    private setCulture;
    /**
     * To provide the array of modules needed for sparkline rendering
     * @return {base.ModuleDeclaration[]}
     * @private
     */
    requiredModules(): base.ModuleDeclaration[];
    /**
     * Method to unbind events for sparkline chart
     */
    private unWireEvents;
    /**
     * Method to bind events for the sparkline
     */
    private wireEvents;
    /**
     * Sparkline resize event.
     * @private
     */
    sparklineResize(e: Event): boolean;
    /**
     * Handles the mouse move on sparkline.
     * @return {boolean}
     * @private
     */
    sparklineMove(e: PointerEvent): boolean;
    /**
     * Handles the mouse click on sparkline.
     * @return {boolean}
     * @private
     */
    sparklineClick(e: PointerEvent): boolean;
    /**
     * To check mouse event target is point region or not.
     */
    private isPointRegion;
    /**
     * Handles the mouse end.
     * @return {boolean}
     * @private
     */
    sparklineMouseEnd(e: PointerEvent): boolean;
    /**
     * Handles the mouse leave on sparkline.
     * @return {boolean}
     * @private
     */
    sparklineMouseLeave(e: PointerEvent): boolean;
    /**
     * Method to set mouse x, y from events
     */
    private setSparklineMouseXY;
    /**
     * To change rendering while property value modified.
     * @private
     */
    onPropertyChanged(newProp: SparklineModel, oldProp: SparklineModel): void;
    /**
     * To render sparkline series and appending.
     */
    private refreshSparkline;
    /**
     * Get component name
     */
    getModuleName(): string;
    /**
     * Destroy the component
     */
    destroy(): void;
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
}
//node_modules/@syncfusion/ej2-charts/src/sparkline/utils/helper.d.ts
/**
 * Sparkline control helper file
 */
/**
 * sparkline internal use of `Size` type
 */
export  class Size {
    /**
     * height of the size
     */
    height: number;
    width: number;
    constructor(width: number, height: number);
}
/**
 * To find the default colors based on theme.
 * @private
 */
export  function getThemeColor(theme: SparklineTheme): IThemes;
/**
 * To find number from string
 * @private
 */
export  function stringToNumber(value: string, containerSize: number): number;
/**
 * Method to calculate the width and height of the sparkline
 */
export  function calculateSize(sparkline: Sparkline): void;
/**
 * Method to create svg for sparkline.
 */
export  function createSvg(sparkline: Sparkline): void;
/**
 * Internal use of type rect
 * @private
 */
export  class Rect {
    x: number;
    y: number;
    height: number;
    width: number;
    constructor(x: number, y: number, width: number, height: number);
}
/**
 * Internal use of path options
 * @private
 */
export  class PathOption1 {
    opacity: number;
    id: string;
    stroke: string;
    fill: string;
    ['stroke-dasharray']: string;
    ['stroke-width']: number;
    d: string;
    constructor(id: string, fill: string, width: number, color: string, opacity?: number, dashArray?: string, d?: string);
}
/**
 * Sparkline internal rendering options
 * @private
 */
export interface SparkValues {
    x?: number;
    y?: number;
    height?: number;
    width?: number;
    percent?: number;
    degree?: number;
    location?: {
        x: number;
        y: number;
    };
    markerPosition?: number;
    xVal?: number;
    yVal?: number;
}
/**
 * Internal use of rectangle options
 * @private
 */
export  class RectOption11 extends PathOption {
    rect: Rect;
    topLeft: number;
    topRight: number;
    bottomLeft: number;
    bottomRight: number;
    constructor(id: string, fill: string, border: SparklineBorderModel, opacity: number, rect: Rect, tl?: number, tr?: number, bl?: number, br?: number);
}
/**
 * Internal use of circle options
 * @private
 */
export  class CircleOption11 extends PathOption {
    cy: number;
    cx: number;
    r: number;
    ['stroke-dasharray']: string;
    constructor(id: string, fill: string, border: SparklineBorderModel, opacity: number, cx: number, cy: number, r: number, dashArray: string);
}
/**
 * Internal use of append shape element
 * @private
 */
export  function appendShape(shape: Element, element: Element): Element;
/**
 * Internal rendering of Circle
 * @private
 */
export  function drawCircle(sparkline: Sparkline, options: CircleOption, element?: Element): Element;
/**
 * To get rounded rect path direction
 */
export  function calculateRoundedRectPath(r: Rect, topLeft: number, topRight: number, bottomLeft: number, bottomRight: number): string;
/**
 * Internal rendering of Rectangle
 * @private
 */
export  function drawRectangle(sparkline: Sparkline, options: RectOption, element?: Element): Element;
/**
 * Internal rendering of Path
 * @private
 */
export  function drawPath(sparkline: Sparkline, options: PathOption, element?: Element): Element;
/**
 * Function to measure the height and width of the text.
 * @param  {string} text
 * @param  {SparklineFontModel} font
 * @param  {string} id
 * @returns no
 * @private
 */
export  function measureText(text: string, font: SparklineFontModel): Size;
/**
 * Internal use of text options
 * @private
 */
export  class TextOption1 {
    id: string;
    anchor: string;
    text: string;
    transform: string;
    x: number;
    y: number;
    baseLine: string;
    constructor(id?: string, x?: number, y?: number, anchor?: string, text?: string, baseLine?: string, transform?: string);
}
/**
 * Internal rendering of text
 * @private
 */
export  function renderTextElement(options: TextOption, font: SparklineFontModel, color: string, parent: HTMLElement | Element): Element;
/**
 * To remove element by id
 */
export  function removeElement(id: string): void;
/**
 * To find the element by id
 */
export  function getIdElement(id: string): Element;
/**
 * To find point within the bounds.
 */
export  function withInBounds(x: number, y: number, bounds: Rect): boolean;
//node_modules/@syncfusion/ej2-charts/src/stock-chart/index.d.ts
/**
 * Financial chart exports
 */
//node_modules/@syncfusion/ej2-charts/src/stock-chart/model/base-model.d.ts
/**
 * Interface for a class StockChartFont
 */
export interface StockChartFontModel {
    /**
     * Color for the text.
     * @default ''
     */
    color?: string;
    /**
     * Font size for the text.
     * @default '16px'
     */
    size?: string;
    /**
     * FontFamily for the text.
     */
    fontFamily?: string;
    /**
     * FontStyle for the text.
     * @default 'Normal'
     */
    fontStyle?: string;
    /**
     * FontWeight for the text.
     * @default 'Normal'
     */
    fontWeight?: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity?: number;
    /**
     * Specifies the chart title text overflow
     * @default 'Trim'
     */
    textOverflow?: TextOverflow;
    /**
     * text alignment
     * @default 'Center'
     */
    textAlignment?: Alignment;
}
/**
 * Interface for a class StockChartBorder
 */
export interface StockChartBorderModel {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color?: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width?: number;
}
/**
 * Interface for a class StockChartArea
 */
export interface StockChartAreaModel {
    /**
     * Options to customize the border of the chart area.
     */
    border?: StockChartBorderModel;
    /**
     * The background of the chart area that accepts value in hex and rgba as a valid CSS color string..
     * @default 'transparent'
     */
    background?: string;
    /**
     * The opacity for background.
     * @default 1
     */
    opacity?: number;
}
/**
 * Interface for a class StockMargin
 */
export interface StockMarginModel {
    /**
     * Left margin in pixels.
     * @default 10
     */
    left?: number;
    /**
     * Right margin in pixels.
     * @default 10
     */
    right?: number;
    /**
     * Top margin in pixels.
     * @default 10
     */
    top?: number;
    /**
     * Bottom margin in pixels.
     * @default 10
     */
    bottom?: number;
}
/**
 * Interface for a class StockChartStripLineSettings
 */
export interface StockChartStripLineSettingsModel {
    /**
     *  If set true, strip line get render from axis origin.
     *  @default false
     */
    startFromAxis?: boolean;
    /**
     * If set true, strip line for axis renders.
     * @default true
     */
    visible?: boolean;
    /**
     * Start value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    start?: number | Date;
    /**
     * Color of the strip line.
     * @default '#808080'
     */
    color?: string;
    /**
     * End value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    end?: number | Date;
    /**
     * Size of the strip line, when it starts from the origin.
     * @default null
     * @aspDefaultValueIgnore
     */
    size?: number;
    /**
     * Size type of the strip line
     * @default Auto
     */
    sizeType?: SizeType;
    /**
     * Dash Array of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    dashArray?: string;
    /**
     * isRepeat value of the strip line.
     * @default false
     * @aspDefaultValueIgnore
     */
    isRepeat?: boolean;
    /**
     * repeatEvery value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatEvery?: number | Date;
    /**
     * isSegmented value of the strip line
     * @default false
     * @aspDefaultValueIgnore
     */
    isSegmented?: boolean;
    /**
     * repeatUntil value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatUntil?: number | Date;
    /**
     * segmentStart value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentStart?: number | Date;
    /**
     * segmentAxisName of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentAxisName?: string;
    /**
     * segmentEnd value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentEnd?: number | Date;
    /**
     * Strip line Opacity
     * @default 1
     */
    opacity?: number;
    /**
     * Strip line text.
     * @default ''
     */
    text?: string;
    /**
     * Border of the strip line.
     */
    border?: StockChartBorderModel;
    /**
     * The angle to which the strip line text gets rotated.
     * @default null
     * @aspDefaultValueIgnore
     */
    rotation?: number;
    /**
     * Specifies the order of the strip line. They are,
     * * Behind: Places the strip line behind the series elements.
     * * Over: Places the strip line over the series elements.
     * @default 'Behind'
     */
    zIndex?: ZIndex;
    /**
     * Defines the position of the strip line text horizontally. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    horizontalAlignment?: Anchor;
    /**
     * Defines the position of the strip line text vertically. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    verticalAlignment?: Anchor;
    /**
     * Options to customize the strip line text.
     */
    textStyle?: StockChartFontModel;
    /**
     * The option to delay animation of the series.
     * @default 0
     */
    delay?: number;
    /**
     * If set to true, series gets animated on initial loading.
     * @default false
     */
    enable?: boolean;
    /**
     * The duration of animation in milliseconds.
     * @default 1000
     */
    duration?: number;
}
/**
 * Interface for a class StockEmptyPointSettings
 */
export interface StockEmptyPointSettingsModel {
    /**
     * To customize the fill color of empty points.
     * @default null
     */
    fill?: string;
    /**
     * To customize the mode of empty points.
     * @default Gap
     */
    mode?: EmptyPointMode;
    /**
     * Options to customize the border of empty points.
     * @default "{color: 'transparent', width: 0}"
     */
    border?: StockChartBorderModel;
}
/**
 * Interface for a class StockChartConnector
 */
export interface StockChartConnectorModel {
    /**
     * specifies the type of the connector line. They are
     * * Smooth
     * * Line
     * @default 'Line'
     */
    type?: ConnectorType;
    /**
     * Length of the connector line in pixels.
     * @default null
     */
    length?: string;
    /**
     * Color of the connector line.
     * @default null
     */
    color?: string;
    /**
     * dashArray of the connector line.
     * @default ''
     */
    dashArray?: string;
    /**
     * Width of the connector line in pixels.
     * @default 1
     */
    width?: number;
}
/**
 * Interface for a class StockSeries
 */
export interface StockSeriesModel {
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName?: string;
    /**
     * The DataSource field that contains the y value.
     * @default ''
     */
    yName?: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open?: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close?: string;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high?: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low?: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume?: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping?: string;
    /**
     * Options to customizing animation for the series.
     */
    animation?: AnimationModel;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * @default null
     */
    xAxisName?: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * @default null
     */
    yAxisName?: string;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill?: string;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray?: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width?: number;
    /**
     * The name of the series visible in legend.
     * @default ''
     */
    name?: string;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * @default ''
     */
    dataSource?: Object | data.DataManager;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default null
     */
    query?: data.Query;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is higher than the closing price.
     * @default '#e74c3d'
     */
    bullFillColor?: string;
    /**
     * This property is used in stock charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is less than the closing price.
     * @default '#2ecd71'
     */
    bearFillColor?: string;
    /**
     * This property is applicable for candle series.
     * It enables/disables to visually compare the current values with the previous values in stock.
     * @default false
     */
    enableSolidCandles?: boolean;
    /**
     * Specifies the visibility of series.
     * @default true
     */
    visible?: boolean;
    /**
     * Options to customizing the border of the series. This is applicable only for `Column` and `Bar` type series.
     */
    border?: StockChartBorderModel;
    /**
     * The opacity of the series.
     * @default 1
     */
    opacity?: number;
    /**
     * The type of the series are
     * * Line
     * * Column
     * * Area
     * * Spline
     * * Hilo
     * * HiloOpenClose
     * * Candle
     * @default 'Candle'
     */
    type?: ChartSeriesType;
    /**
     * Options for displaying and customizing markers for individual points in a series.
     */
    marker?: MarkerSettingsModel;
    /**
     * Defines the collection of trendlines that are used to predict the trend
     */
    trendlines?: TrendlineModel[];
    /**
     * If set true, the Tooltip for series will be visible.
     * @default true
     */
    enableTooltip?: boolean;
    /**
     * The provided value will be considered as a Tooltip name 
     * @default ''
     */
    tooltipMappingName?: string;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle?: string;
    /**
     * It defines tension of cardinal spline types
     * @default 0.5
     */
    cardinalSplineTension?: number;
    /**
     * To render the column series points with particular rounded corner.
     */
    cornerRadius?: CornerRadiusModel;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings?: EmptyPointSettingsModel;
    /**
     * To render the column series points with particular column width. If the series type is histogram the
     * default value is 1 otherwise 0.7.
     * @default null
     * @aspDefaultValueIgnore
     */
    columnWidth?: number;
    /**
     * To render the column series points with particular column spacing. It takes value from 0 - 1.
     * @default 0
     */
    columnSpacing?: number;
}
/**
 * Interface for a class StockChartIndicator
 */
export interface StockChartIndicatorModel {
    /**
     * Defines the type of the technical indicator
     * @default 'Sma'
     */
    type?: TechnicalIndicators;
    /**
     * Defines the period, the price changes over which will be considered to predict the trend
     * @default 14
     */
    period?: number;
    /**
     * Defines the period, the price changes over which will define the %D value in stochastic indicators
     * @default 3
     */
    dPeriod?: number;
    /**
     * Defines the look back period, the price changes over which will define the %K value in stochastic indicators
     * @default 14
     */
    kPeriod?: number;
    /**
     * Defines the over-bought(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 80
     */
    overBought?: number;
    /**
     * Defines the over-sold(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 20
     */
    overSold?: number;
    /**
     * Defines the field to compare the current value with previous values
     * @default 'Close'
     */
    field?: FinancialDataFields;
    /**
     * Sets the standard deviation values that helps to define the upper and lower bollinger bands
     * @default 2
     */
    standardDeviation?: number;
    /**
     * Sets the slow period to define the Macd line
     * @default 12
     */
    slowPeriod?: number;
    /**
     * Enables/Disables the over-bought and over-sold regions
     * @default true
     */
    showZones?: boolean;
    /**
     * Sets the fast period to define the Macd line
     * @default 26
     */
    fastPeriod?: number;
    /**
     * Defines the appearance of the the MacdLine of Macd indicator
     * @default { color: '#ff9933', width: 2 }
     */
    macdLine?: StockChartConnectorModel;
    /**
     * Defines the type of the Macd indicator.
     * @default 'Both'
     */
    macdType?: MacdType;
    /**
     * Defines the color of the negative bars in Macd indicators
     * @default '#e74c3d'
     */
    macdNegativeColor?: string;
    /**
     * Defines the color of the positive bars in Macd indicators
     * @default '#2ecd71'
     */
    macdPositiveColor?: string;
    /**
     * Options for customizing the BollingerBand in the indicator.
     * @default 'rgba(211,211,211,0.25)'
     */
    bandColor?: string;
    /**
     * Defines the appearance of the upper line in technical indicators
     */
    upperLine?: StockChartConnectorModel;
    /**
     * Defines the name of the series, the data of which has to be depicted as indicator
     * @default ''
     */
    seriesName?: string;
    /**
     * Defines the appearance of period line in technical indicators
     */
    periodLine?: StockChartConnectorModel;
    /**
     * Defines the appearance of lower line in technical indicators
     */
    lowerLine?: ConnectorModel;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high?: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open?: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low?: string;
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName?: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close?: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping?: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume?: string;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                xAxisName: 'xAxis 1',
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    xAxisName?: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * @default null
     */
    yAxisName?: string;
    /**
     * Options to customizing animation for the series.
     */
    animation?: AnimationModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill?: string;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray?: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width?: number;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default null
     */
    query?: data.Query;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * @default ''
     */
    dataSource?: Object | data.DataManager;
}
/**
 * Interface for a class StockChartAxis
 */
export interface StockChartAxisModel {
    /**
     * Options to customize the crosshair ToolTip.
     */
    crosshairTooltip?: CrosshairTooltipModel;
    /**
     * Options to customize the axis label.
     */
    labelStyle?: StockChartFontModel;
    /**
     * Specifies the title of an axis.
     * @default ''
     */
    title?: string;
    /**
     * Options for customizing the axis title.
     */
    titleStyle?: StockChartFontModel;
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat?: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType?: SkeletonType;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton?: string;
    /**
     * Left and right padding for the plot area in pixels.
     * @default 0
     */
    plotOffset?: number;
    /**
     * The base value for logarithmic axis. It requires `valueType` to be `Logarithmic`.
     * @default 10
     */
    logBase?: number;
    /**
     * Specifies the index of the row where the axis is associated, when the chart area is divided into multiple plot areas by using `rows`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *      }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    rowIndex?: number;
    /**
     * Specifies the number of `columns` or `rows` an axis has to span horizontally or vertically.
     * @default 1
     */
    span?: number;
    /**
     * The maximum number of label count per 100 pixels with respect to the axis length.
     * @default 3
     */
    maximumLabels?: number;
    /**
     * With this property, you can request axis to calculate intervals approximately equal to your specified interval.
     * @default null
     * @aspDefaultValueIgnore
     */
    desiredIntervals?: number;
    /**
     * The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
     * @default 1
     */
    zoomFactor?: number;
    /**
     * Position of the zoomed axis. Value ranges from 0 to 1.
     * @default 0
     */
    zoomPosition?: number;
    /**
     * If set to true, the axis will render at the opposite side of its default position.
     * @default false
     */
    opposedPosition?: boolean;
    /**
     * If set to true, axis interval will be calculated automatically with respect to the zoomed range.
     * @default true
     */
    enableAutoIntervalOnZooming?: boolean;
    /**
     * Specifies the type of data the axis is handling.
     * * Double:  Renders a numeric axis.
     * * DateTime: Renders a dateTime axis.
     * * Category: Renders a category axis.
     * * Logarithmic: Renders a log axis.
     * @default 'Double'
     * @blazorType Syncfusion.EJ2.Blazor.Charts.ValueType
     * @isEnumeration true
     */
    valueType?: ValueType;
    /**
     * Specifies the padding for the axis range in terms of interval.They are,
     * * none: Padding cannot be applied to the axis.
     * * normal: Padding is applied to the axis based on the range calculation.
     * * additional: Interval of the axis is added as padding to the minimum and maximum values of the range.
     * * round: Axis range is rounded to the nearest possible value divided by the interval.
     * @default 'Auto'
     */
    rangePadding?: ChartRangePadding;
    /**
     * Specifies the position of labels at the edge of the axis.They are,
     * * None: No action will be performed.
     * * Hide: Edge label will be hidden.
     * * Shift: Shifts the edge labels.
     * @default 'None'
     */
    edgeLabelPlacement?: EdgeLabelPlacement;
    /**
     * Specifies the placement of a label for category axis. They are,
     * * betweenTicks: Renders the label between the ticks.
     * * onTicks: Renders the label on the ticks.
     * @default 'BetweenTicks'
     */
    labelPlacement?: LabelPlacement;
    /**
     * Specifies the types like `Years`, `Months`, `Days`, `Hours`, `Minutes`, `Seconds` in date time axis.They are,
     * * Auto: Defines the interval of the axis based on data.
     * * Years: Defines the interval of the axis in years.
     * * Months: Defines the interval of the axis in months.
     * * Days: Defines the interval of the axis in days.
     * * Hours: Defines the interval of the axis in hours.
     * * Minutes: Defines the interval of the axis in minutes.
     * @default 'Auto'
     */
    intervalType?: IntervalType;
    /**
     * Specifies the placement of a ticks to the axis line. They are,
     * * inside: Renders the ticks inside to the axis line.
     * * outside: Renders the ticks outside to the axis line.
     * @default 'Outside'
     */
    tickPosition?: AxisPosition;
    /**
     * Unique identifier of an axis.
     * To associate an axis with the series, set this name to the xAxisName/yAxisName properties of the series.
     * @default ''
     */
    name?: string;
    /**
     * Specifies the placement of a labels to the axis line. They are,
     * * inside: Renders the labels inside to the axis line.
     * * outside: Renders the labels outside to the axis line.
     * @default 'Outside'
     */
    labelPosition?: AxisPosition;
    /**
     * If set to true, axis label will be visible.
     * @default true
     */
    visible?: boolean;
    /**
     * The angle to which the axis label gets rotated.
     * @default 0
     */
    labelRotation?: number;
    /**
     * Specifies the number of minor ticks per interval.
     * @default 0
     */
    minorTicksPerInterval?: number;
    /**
     * Specifies the value at which the axis line has to be intersect with the vertical axis or vice versa.
     * @default null
     */
    crossesAt?: Object;
    /**
     * Specifies axis name with which the axis line has to be crossed
     * @default null
     */
    crossesInAxis?: string;
    /**
     * Specifies whether axis elements like axis labels, axis title, etc has to be crossed with axis line
     * @default true
     */
    placeNextToAxisLine?: boolean;
    /**
     * Specifies the minimum range of an axis.
     * @default null
     */
    minimum?: Object;
    /**
     * Specifies the interval for an axis.
     * @default null
     * @aspDefaultValueIgnore
     */
    interval?: number;
    /**
     * Specifies the maximum range of an axis.
     * @default null
     */
    maximum?: Object;
    /**
     * Specifies the maximum width of an axis label.
     * @default 34.
     */
    maximumLabelWidth?: number;
    /**
     * Options for customizing major tick lines.
     */
    majorTickLines?: MajorTickLinesModel;
    /**
     * Specifies the Trim property for an axis.
     * @default false
     */
    enableTrim?: boolean;
    /**
     * Options for customizing minor tick lines.
     */
    minorTickLines?: MinorTickLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines?: MinorGridLinesModel;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines?: MajorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    lineStyle?: AxisLineModel;
    /**
     * It specifies whether the axis to be rendered in inversed manner or not.
     * @default false
     */
    isInversed?: boolean;
    /**
     * Specifies the actions like `Hide`, `Rotate45`, and `Rotate90` when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * * Rotate45: Rotates the label to 45 degree when it intersects.
     * * Rotate90: Rotates the label to 90 degree when it intersects.
     * @default Hide
     */
    labelIntersectAction?: LabelIntersectAction;
    /**
     * The polar radar radius position.
     * @default 100
     */
    coefficient?: number;
    /**
     * The start angle for the series.
     * @default 0
     */
    startAngle?: number;
    /**
     * TabIndex value for the axis.
     * @default 2
     */
    tabIndex?: number;
    /**
     * Specifies the stripLine collection for the axis
     */
    stripLines?: StockChartStripLineSettingsModel[];
    /**
     * Description for axis and its element.
     * @default null
     */
    description?: string;
}
/**
 * Interface for a class StockChartRow
 */
export interface StockChartRowModel {
    /**
     * The height of the row as a string accept input both as '100px' and '100%'.
     * If specified as '100%, row renders to the full height of its chart.
     * @default '100%'
     */
    height?: string;
    /**
     * Options to customize the border of the rows.
     */
    border?: StockChartBorderModel;
}
/**
 * Interface for a class StockChartTrendline
 */
export interface StockChartTrendlineModel {
    /**
     * Defines the period, the price changes over which will be considered to predict moving average trend line
     * @default 2
     */
    period?: number;
    /**
     * Defines the name of trendline
     * @default ''
     */
    name?: string;
    /**
     * Defines the type of the trendline
     * @default 'Linear'
     */
    type?: TrendlineTypes;
    /**
     * Defines the polynomial order of the polynomial trendline
     * @default 2
     */
    polynomialOrder?: number;
    /**
     * Defines the period, by which the trend has to forward forecast
     * @default 0
     */
    forwardForecast?: number;
    /**
     * Defines the period, by which the trend has to backward forecast
     * @default 0
     */
    backwardForecast?: number;
    /**
     * Options to customize the animation for trendlines
     */
    animation?: AnimationModel;
    /**
     * Enables/disables tooltip for trendlines
     * @default true
     */
    enableTooltip?: boolean;
    /**
     * Options to customize the marker for trendlines
     */
    marker?: MarkerSettingsModel;
    /**
     * Defines the intercept of the trendline
     * @default null
     * @aspDefaultValueIgnore
     */
    intercept?: number;
    /**
     * Defines the fill color of trendline
     * @default ''
     */
    fill?: string;
    /**
     * Sets the legend shape of the trendline
     * @default 'SeriesType'
     */
    legendShape?: LegendShape;
    /**
     * Defines the width of the trendline
     * @default 1
     */
    width?: number;
}
/**
 * Interface for a class StockChartAnnotationSettings
 */
export interface StockChartAnnotationSettingsModel {
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y?: string | number;
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x?: string | Date | number;
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content?: string;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region?: Regions;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as left side.
     * * Far - Align the annotation element as right side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment?: Alignment;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits?: Units;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment?: Position;
    /**
     * The name of vertical axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    yAxisName?: string;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description?: string;
    /**
     * The name of horizontal axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    xAxisName?: string;
}
/**
 * Interface for a class StockChartIndexes
 */
export interface StockChartIndexesModel {
    /**
     * Specifies index of point
     * @default 0
     * @aspType int
     */
    point?: number;
    /**
     * Specifies index of series
     * @default 0
     * @aspType int
     */
    series?: number;
}
/**
 * Interface for a class StockEventsSettings
 */
export interface StockEventsSettingsModel {
    /**
     * Specifies type of stock events
     * * Circle 
     * * Square
     * * Flag
     * * Text
     * * Sign
     * * Triangle
     * * InvertedTriangle
     * * ArrowUp
     * * ArrowDown
     * * ArrowLeft
     * * ArrowRight
     * @default 'Circle'
     */
    type?: FlagType;
    /**
     * Specifies the text for the stock chart text.
     */
    text?: string;
    /**
     * Specifies the description for the chart which renders in tooltip for stock event.
     */
    description?: string;
    /**
     * Date value of stock event in which stock event shows.
     */
    date?: Date;
    /**
     * Options to customize the border of the stock events.
     */
    border?: StockChartBorderModel;
    /**
     * The background of the stock event that accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    background?: string;
    /**
     * Enables the stock events to be render on series. If it disabled, stock event rendered on primaryXAxis.
     * @default true
     */
    showOnSeries?: boolean;
    /**
     * Corresponding values in which stock event placed.
     * * Close
     * * Open
     * * High
     * * Close
     * @default 'close'
     */
    placeAt?: string;
    /**
     * Options to customize the styles for stock events text.
     */
    textStyle?: StockChartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/model/base.d.ts
export  class StockChartFont extends base.ChildProperty<StockChartFont> {
    /**
     * Color for the text.
     * @default ''
     */
    color: string;
    /**
     * Font size for the text.
     * @default '16px'
     */
    size: string;
    /**
     * FontFamily for the text.
     */
    fontFamily: string;
    /**
     * FontStyle for the text.
     * @default 'Normal'
     */
    fontStyle: string;
    /**
     * FontWeight for the text.
     * @default 'Normal'
     */
    fontWeight: string;
    /**
     * Opacity for the text.
     * @default 1
     */
    opacity: number;
    /**
     * Specifies the chart title text overflow
     * @default 'Trim'
     */
    textOverflow: TextOverflow;
    /**
     * text alignment
     * @default 'Center'
     */
    textAlignment: Alignment;
}
/**
 * Border
 */
export  class StockChartBorder extends base.ChildProperty<StockChartBorder> {
    /**
     * The color of the border that accepts value in hex and rgba as a valid CSS color string.
     * @default ''
     */
    color: string;
    /**
     * The width of the border in pixels.
     * @default 1
     */
    width: number;
}
/**
 * Configures the chart area.
 */
export  class StockChartArea extends base.ChildProperty<StockChartArea> {
    /**
     * Options to customize the border of the chart area.
     */
    border: StockChartBorderModel;
    /**
     * The background of the chart area that accepts value in hex and rgba as a valid CSS color string..
     * @default 'transparent'
     */
    background: string;
    /**
     * The opacity for background.
     * @default 1
     */
    opacity: number;
}
/**
 * Configures the chart margins.
 */
export  class StockMargin extends base.ChildProperty<StockMargin> {
    /**
     * Left margin in pixels.
     * @default 10
     */
    left: number;
    /**
     * Right margin in pixels.
     * @default 10
     */
    right: number;
    /**
     * Top margin in pixels.
     * @default 10
     */
    top: number;
    /**
     * Bottom margin in pixels.
     * @default 10
     */
    bottom: number;
}
/**
 * StockChart strip line settings
 */
export  class StockChartStripLineSettings extends base.ChildProperty<StockChartStripLineSettings> {
    /**
     *  If set true, strip line get render from axis origin.
     *  @default false
     */
    startFromAxis: boolean;
    /**
     * If set true, strip line for axis renders.
     * @default true
     */
    visible: boolean;
    /**
     * Start value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    start: number | Date;
    /**
     * Color of the strip line.
     * @default '#808080'
     */
    color: string;
    /**
     * End value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    end: number | Date;
    /**
     * Size of the strip line, when it starts from the origin.
     * @default null
     * @aspDefaultValueIgnore
     */
    size: number;
    /**
     * Size type of the strip line
     * @default Auto
     */
    sizeType: SizeType;
    /**
     * Dash Array of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    dashArray: string;
    /**
     * isRepeat value of the strip line.
     * @default false
     * @aspDefaultValueIgnore
     */
    isRepeat: boolean;
    /**
     * repeatEvery value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatEvery: number | Date;
    /**
     * isSegmented value of the strip line
     * @default false
     * @aspDefaultValueIgnore
     */
    isSegmented: boolean;
    /**
     * repeatUntil value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    repeatUntil: number | Date;
    /**
     * segmentStart value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentStart: number | Date;
    /**
     * segmentAxisName of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentAxisName: string;
    /**
     * segmentEnd value of the strip line.
     * @default null
     * @aspDefaultValueIgnore
     */
    segmentEnd: number | Date;
    /**
     * Strip line Opacity
     * @default 1
     */
    opacity: number;
    /**
     * Strip line text.
     * @default ''
     */
    text: string;
    /**
     * Border of the strip line.
     */
    border: StockChartBorderModel;
    /**
     * The angle to which the strip line text gets rotated.
     * @default null
     * @aspDefaultValueIgnore
     */
    rotation: number;
    /**
     * Specifies the order of the strip line. They are,
     * * Behind: Places the strip line behind the series elements.
     * * Over: Places the strip line over the series elements.
     * @default 'Behind'
     */
    zIndex: ZIndex;
    /**
     * Defines the position of the strip line text horizontally. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    horizontalAlignment: Anchor;
    /**
     * Defines the position of the strip line text vertically. They are,
     * * Start: Places the strip line text at the start.
     * * Middle: Places the strip line text in the middle.
     * * End: Places the strip line text at the end.
     * @default 'Middle'
     */
    verticalAlignment: Anchor;
    /**
     * Options to customize the strip line text.
     */
    textStyle: StockChartFontModel;
}
export  class StockEmptyPointSettings extends base.ChildProperty<StockEmptyPointSettings> {
    /**
     * To customize the fill color of empty points.
     * @default null
     */
    fill: string;
    /**
     * To customize the mode of empty points.
     * @default Gap
     */
    mode: EmptyPointMode;
    /**
     * Options to customize the border of empty points.
     * @default "{color: 'transparent', width: 0}"
     */
    border: StockChartBorderModel;
}
export  class StockChartConnector extends base.ChildProperty<StockChartConnector> {
    /**
     * specifies the type of the connector line. They are
     * * Smooth
     * * Line
     * @default 'Line'
     */
    type: ConnectorType;
    /**
     * Length of the connector line in pixels.
     * @default null
     */
    length: string;
    /**
     * Color of the connector line.
     * @default null
     */
    color: string;
    /**
     * dashArray of the connector line.
     * @default ''
     */
    dashArray: string;
    /**
     * Width of the connector line in pixels.
     * @default 1
     */
    width: number;
}
/**
 * Configures the Annotation for chart.
 */
export  class StockSeries extends base.ChildProperty<StockSeries> {
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName: string;
    /**
     * The DataSource field that contains the y value.
     * @default ''
     */
    yName: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close: string;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping: string;
    /**
     * Options to customizing animation for the series.
     */
    animation: AnimationModel;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * @default null
     */
    xAxisName: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * @default null
     */
    yAxisName: string;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill: string;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width: number;
    /**
     * The name of the series visible in legend.
     * @default ''
     */
    name: string;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default null
     */
    query: data.Query;
    /**
     * This property is used in financial charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is higher than the closing price.
     * @default '#e74c3d'
     */
    bullFillColor: string;
    /**
     * This property is used in stock charts to visualize the price movements in stock.
     * It defines the color of the candle/point, when the opening price is less than the closing price.
     * @default '#2ecd71'
     */
    bearFillColor: string;
    /**
     * This property is applicable for candle series.
     * It enables/disables to visually compare the current values with the previous values in stock.
     * @default false
     */
    enableSolidCandles: boolean;
    /**
     * Specifies the visibility of series.
     * @default true
     */
    visible: boolean;
    /**
     * Options to customizing the border of the series. This is applicable only for `Column` and `Bar` type series.
     */
    border: StockChartBorderModel;
    /**
     * The opacity of the series.
     * @default 1
     */
    opacity: number;
    /**
     * The type of the series are
     * * Line
     * * Column
     * * Area
     * * Spline
     * * Hilo
     * * HiloOpenClose
     * * Candle
     * @default 'Candle'
     */
    type: ChartSeriesType;
    /**
     * Options for displaying and customizing markers for individual points in a series.
     */
    marker: MarkerSettingsModel;
    /**
     * Defines the collection of trendlines that are used to predict the trend
     */
    trendlines: TrendlineModel[];
    /**
     * If set true, the Tooltip for series will be visible.
     * @default true
     */
    enableTooltip: boolean;
    /**
     * The provided value will be considered as a Tooltip name
     * @default ''
     */
    tooltipMappingName: string;
    /**
     * Custom style for the selected series or points.
     * @default null
     */
    selectionStyle: string;
    /**
     * It defines tension of cardinal spline types
     * @default 0.5
     */
    cardinalSplineTension: number;
    /**
     * To render the column series points with particular rounded corner.
     */
    cornerRadius: CornerRadiusModel;
    /**
     * options to customize the empty points in series
     */
    emptyPointSettings: EmptyPointSettingsModel;
    /**
     * To render the column series points with particular column width. If the series type is histogram the
     * default value is 1 otherwise 0.7.
     * @default null
     * @aspDefaultValueIgnore
     */
    columnWidth: number;
    /**
     * To render the column series points with particular column spacing. It takes value from 0 - 1.
     * @default 0
     */
    columnSpacing: number;
    /** @private */
    localData: Object;
}
export interface IStockChartEventArgs {
    /** name of the event */
    name: string;
    /** stock chart */
    stockChart: StockChart;
}
/**
 * Interface for changed events
 */
export interface IRangeChangeEventArgs {
    /** name of the event */
    name: string;
    /** Defines the start value */
    start: number | Date;
    /** Defines the end value */
    end: number | Date;
    /** Defines the data source */
    data: Object[];
    /** Defines the selected data */
    selectedData: Object[];
    /** Defined the zoomPosition of the Stock chart */
    zoomPosition: number;
    /** Defined the zoomFactor of the stock chart */
    zoomFactor: number;
}
/** Stock event render event */
export interface IStockEventRenderArgs {
    /** stockChart */
    stockChart: StockChart;
    /** Event text  */
    text: string;
    /** Event shape */
    type: FlagType;
    /** Defines the name of the event */
    name: string;
    /** Defines the event cancel status */
    cancel: boolean;
    /** Defines the stock series */
    series: StockSeriesModel;
}
export  class StockChartIndicator extends base.ChildProperty<StockChartIndicator> {
    /**
     * Defines the type of the technical indicator
     * @default 'Sma'
     */
    type: TechnicalIndicators;
    /**
     * Defines the period, the price changes over which will be considered to predict the trend
     * @default 14
     */
    period: number;
    /**
     * Defines the period, the price changes over which will define the %D value in stochastic indicators
     * @default 3
     */
    dPeriod: number;
    /**
     * Defines the look back period, the price changes over which will define the %K value in stochastic indicators
     * @default 14
     */
    kPeriod: number;
    /**
     * Defines the over-bought(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 80
     */
    overBought: number;
    /**
     * Defines the over-sold(threshold) values. It is applicable for RSI and stochastic indicators
     * @default 20
     */
    overSold: number;
    /**
     * Defines the field to compare the current value with previous values
     * @default 'Close'
     */
    field: FinancialDataFields;
    /**
     * Sets the standard deviation values that helps to define the upper and lower bollinger bands
     * @default 2
     */
    standardDeviation: number;
    /**
     * Sets the slow period to define the Macd line
     * @default 12
     */
    slowPeriod: number;
    /**
     * Enables/Disables the over-bought and over-sold regions
     * @default true
     */
    showZones: boolean;
    /**
     * Sets the fast period to define the Macd line
     * @default 26
     */
    fastPeriod: number;
    /**
     * Defines the appearance of the the MacdLine of Macd indicator
     * @default { color: '#ff9933', width: 2 }
     */
    macdLine: StockChartConnectorModel;
    /**
     * Defines the type of the Macd indicator.
     * @default 'Both'
     */
    macdType: MacdType;
    /**
     * Defines the color of the negative bars in Macd indicators
     * @default '#e74c3d'
     */
    macdNegativeColor: string;
    /**
     * Defines the color of the positive bars in Macd indicators
     * @default '#2ecd71'
     */
    macdPositiveColor: string;
    /**
     * Options for customizing the BollingerBand in the indicator.
     * @default 'rgba(211,211,211,0.25)'
     */
    bandColor: string;
    /**
     * Defines the appearance of the upper line in technical indicators
     */
    upperLine: StockChartConnectorModel;
    /**
     * Defines the name of the series, the data of which has to be depicted as indicator
     * @default ''
     */
    seriesName: string;
    /**
     * Defines the appearance of period line in technical indicators
     */
    periodLine: StockChartConnectorModel;
    /**
     * Defines the appearance of lower line in technical indicators
     */
    lowerLine: ConnectorModel;
    /**
     * The DataSource field that contains the high value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    high: string;
    /**
     * The DataSource field that contains the open value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    open: string;
    /**
     * The DataSource field that contains the low value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    low: string;
    /**
     * The DataSource field that contains the x value.
     * It is applicable for series and technical indicators
     * @default ''
     */
    xName: string;
    /**
     * The DataSource field that contains the close value of y
     * It is applicable for series and technical indicators
     * @default ''
     */
    close: string;
    /**
     * The DataSource field that contains the color value of point
     * It is applicable for series
     * @default ''
     */
    pointColorMapping: string;
    /**
     * Defines the data source field that contains the volume value in candle charts
     * It is applicable for financial series and technical indicators
     * @default ''
     */
    volume: string;
    /**
     * The name of the horizontal axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     columns: [{ width: '50%' },
     *               { width: '50%' }],
     *     axes: [{
     *                name: 'xAxis 1',
     *                columnIndex: 1,
     *            }],
     *     series: [{
     *                dataSource: data,
     *                xName: 'x', yName: 'y',
     *                xAxisName: 'xAxis 1',
     *     }],
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default null
     */
    xAxisName: string;
    /**
     * The name of the vertical axis associated with the series. It requires `axes` of the chart.
     * It is applicable for series and technical indicators
     * ```html
     * <div id='Chart'></div>
     * ```
     * @default null
     */
    yAxisName: string;
    /**
     * Options to customizing animation for the series.
     */
    animation: AnimationModel;
    /**
     * The fill color for the series that accepts value in hex and rgba as a valid CSS color string.
     * It also represents the color of the signal lines in technical indicators.
     * For technical indicators, the default value is 'blue' and for series, it has null.
     * @default null
     */
    fill: string;
    /**
     * Defines the pattern of dashes and gaps to stroke the lines in `Line` type series.
     * @default '0'
     */
    dashArray: string;
    /**
     * The stroke width for the series that is applicable only for `Line` type series.
     * It also represents the stroke width of the signal lines in technical indicators.
     * @default 1
     */
    width: number;
    /**
     * Specifies query to select data from DataSource. This property is applicable only when the DataSource is `ej.data.DataManager`.
     * @default null
     */
    query: data.Query;
    /**
     * Specifies the DataSource for the series. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='Chart'></div>
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
}
export  class StockChartAxis extends base.ChildProperty<StockChartAxis> {
    /**
     * Options to customize the crosshair ToolTip.
     */
    crosshairTooltip: CrosshairTooltipModel;
    /**
     * Options to customize the axis label.
     */
    labelStyle: StockChartFontModel;
    /**
     * Specifies the title of an axis.
     * @default ''
     */
    title: string;
    /**
     * Options for customizing the axis title.
     */
    titleStyle: StockChartFontModel;
    /**
     * Used to format the axis label that accepts any global string format like 'C', 'n1', 'P' etc.
     * It also accepts placeholder like '{value}°C' in which value represent the axis label, e.g, 20°C.
     * @default ''
     */
    labelFormat: string;
    /**
     * It specifies the type of format to be used in dateTime format process.
     * @default 'DateTime'
     */
    skeletonType: SkeletonType;
    /**
     * Specifies the skeleton format in which the dateTime format will process.
     * @default ''
     */
    skeleton: string;
    /**
     * Left and right padding for the plot area in pixels.
     * @default 0
     */
    plotOffset: number;
    /**
     * The base value for logarithmic axis. It requires `valueType` to be `Logarithmic`.
     * @default 10
     */
    logBase: number;
    /**
     * Specifies the index of the row where the axis is associated, when the chart area is divided into multiple plot areas by using `rows`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *     rows: [{ height: '50%' },
     *            { height: '50%' }],
     *     axes: [{
     *                name: 'yAxis 1',
     *                rowIndex: 1,
     *      }],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default 0
     */
    rowIndex: number;
    /**
     * Specifies the number of `columns` or `rows` an axis has to span horizontally or vertically.
     * @default 1
     */
    span: number;
    /**
     * The maximum number of label count per 100 pixels with respect to the axis length.
     * @default 3
     */
    maximumLabels: number;
    /**
     * With this property, you can request axis to calculate intervals approximately equal to your specified interval.
     * @default null
     * @aspDefaultValueIgnore
     */
    desiredIntervals: number;
    /**
     * The axis is scaled by this factor. When zoomFactor is 0.5, the chart is scaled by 200% along this axis. Value ranges from 0 to 1.
     * @default 1
     */
    zoomFactor: number;
    /**
     * Position of the zoomed axis. Value ranges from 0 to 1.
     * @default 0
     */
    zoomPosition: number;
    /**
     * If set to true, the axis will render at the opposite side of its default position.
     * @default false
     */
    opposedPosition: boolean;
    /**
     * If set to true, axis interval will be calculated automatically with respect to the zoomed range.
     * @default true
     */
    enableAutoIntervalOnZooming: boolean;
    /**
     * Specifies the type of data the axis is handling.
     * * Double:  Renders a numeric axis.
     * * DateTime: Renders a dateTime axis.
     * * Category: Renders a category axis.
     * * Logarithmic: Renders a log axis.
     * @default 'Double'
     * @blazorType Syncfusion.EJ2.Blazor.Charts.ValueType
     * @isEnumeration true
     */
    valueType: ValueType;
    /**
     * Specifies the padding for the axis range in terms of interval.They are,
     * * none: Padding cannot be applied to the axis.
     * * normal: Padding is applied to the axis based on the range calculation.
     * * additional: Interval of the axis is added as padding to the minimum and maximum values of the range.
     * * round: Axis range is rounded to the nearest possible value divided by the interval.
     * @default 'Auto'
     */
    rangePadding: ChartRangePadding;
    /**
     * Specifies the position of labels at the edge of the axis.They are,
     * * None: No action will be performed.
     * * Hide: Edge label will be hidden.
     * * Shift: Shifts the edge labels.
     * @default 'None'
     */
    edgeLabelPlacement: EdgeLabelPlacement;
    /**
     * Specifies the placement of a label for category axis. They are,
     * * betweenTicks: Renders the label between the ticks.
     * * onTicks: Renders the label on the ticks.
     * @default 'BetweenTicks'
     */
    labelPlacement: LabelPlacement;
    /**
     * Specifies the types like `Years`, `Months`, `Days`, `Hours`, `Minutes`, `Seconds` in date time axis.They are,
     * * Auto: Defines the interval of the axis based on data.
     * * Years: Defines the interval of the axis in years.
     * * Months: Defines the interval of the axis in months.
     * * Days: Defines the interval of the axis in days.
     * * Hours: Defines the interval of the axis in hours.
     * * Minutes: Defines the interval of the axis in minutes.
     * @default 'Auto'
     */
    intervalType: IntervalType;
    /**
     * Specifies the placement of a ticks to the axis line. They are,
     * * inside: Renders the ticks inside to the axis line.
     * * outside: Renders the ticks outside to the axis line.
     * @default 'Outside'
     */
    tickPosition: AxisPosition;
    /**
     * Unique identifier of an axis.
     * To associate an axis with the series, set this name to the xAxisName/yAxisName properties of the series.
     * @default ''
     */
    name: string;
    /**
     * Specifies the placement of a labels to the axis line. They are,
     * * inside: Renders the labels inside to the axis line.
     * * outside: Renders the labels outside to the axis line.
     * @default 'Outside'
     */
    labelPosition: AxisPosition;
    /**
     * If set to true, axis label will be visible.
     * @default true
     */
    visible: boolean;
    /**
     * The angle to which the axis label gets rotated.
     * @default 0
     */
    labelRotation: number;
    /**
     * Specifies the number of minor ticks per interval.
     * @default 0
     */
    minorTicksPerInterval: number;
    /**
     * Specifies the value at which the axis line has to be intersect with the vertical axis or vice versa.
     * @default null
     */
    crossesAt: Object;
    /**
     * Specifies axis name with which the axis line has to be crossed
     * @default null
     */
    crossesInAxis: string;
    /**
     * Specifies whether axis elements like axis labels, axis title, etc has to be crossed with axis line
     * @default true
     */
    placeNextToAxisLine: boolean;
    /**
     * Specifies the minimum range of an axis.
     * @default null
     */
    minimum: Object;
    /**
     * Specifies the interval for an axis.
     * @default null
     * @aspDefaultValueIgnore
     */
    interval: number;
    /**
     * Specifies the maximum range of an axis.
     * @default null
     */
    maximum: Object;
    /**
     * Specifies the maximum width of an axis label.
     * @default 34.
     */
    maximumLabelWidth: number;
    /**
     * Options for customizing major tick lines.
     */
    majorTickLines: MajorTickLinesModel;
    /**
     * Specifies the Trim property for an axis.
     * @default false
     */
    enableTrim: boolean;
    /**
     * Options for customizing minor tick lines.
     */
    minorTickLines: MinorTickLinesModel;
    /**
     * Options for customizing minor grid lines.
     */
    minorGridLines: MinorGridLinesModel;
    /**
     * Options for customizing major grid lines.
     */
    majorGridLines: MajorGridLinesModel;
    /**
     * Options for customizing axis lines.
     */
    lineStyle: AxisLineModel;
    /**
     * It specifies whether the axis to be rendered in inversed manner or not.
     * @default false
     */
    isInversed: boolean;
    /**
     * Specifies the actions like `Hide`, `Rotate45`, and `Rotate90` when the axis labels intersect with each other.They are,
     * * None: Shows all the labels.
     * * Hide: Hides the label when it intersects.
     * * Rotate45: Rotates the label to 45 degree when it intersects.
     * * Rotate90: Rotates the label to 90 degree when it intersects.
     * @default Hide
     */
    labelIntersectAction: LabelIntersectAction;
    /**
     * The polar radar radius position.
     * @default 100
     */
    coefficient: number;
    /**
     * The start angle for the series.
     * @default 0
     */
    startAngle: number;
    /**
     * TabIndex value for the axis.
     * @default 2
     */
    tabIndex: number;
    /**
     * Specifies the stripLine collection for the axis
     */
    stripLines: StockChartStripLineSettingsModel[];
    /**
     * Description for axis and its element.
     * @default null
     */
    description: string;
}
/**
 * StockChart row
 */
export  class StockChartRow extends base.ChildProperty<StockChartRow> {
    /**
     * The height of the row as a string accept input both as '100px' and '100%'.
     * If specified as '100%, row renders to the full height of its chart.
     * @default '100%'
     */
    height: string;
    /**
     * Options to customize the border of the rows.
     */
    border: StockChartBorderModel;
}
export  class StockChartTrendline extends base.ChildProperty<StockChartTrendline> {
    /**
     * Defines the period, the price changes over which will be considered to predict moving average trend line
     * @default 2
     */
    period: number;
    /**
     * Defines the name of trendline
     * @default ''
     */
    name: string;
    /**
     * Defines the type of the trendline
     * @default 'Linear'
     */
    type: TrendlineTypes;
    /**
     * Defines the polynomial order of the polynomial trendline
     * @default 2
     */
    polynomialOrder: number;
    /**
     * Defines the period, by which the trend has to forward forecast
     * @default 0
     */
    forwardForecast: number;
    /**
     * Defines the period, by which the trend has to backward forecast
     * @default 0
     */
    backwardForecast: number;
    /**
     * Options to customize the animation for trendlines
     */
    animation: AnimationModel;
    /**
     * Enables/disables tooltip for trendlines
     * @default true
     */
    enableTooltip: boolean;
    /**
     * Options to customize the marker for trendlines
     */
    marker: MarkerSettingsModel;
    /**
     * Defines the intercept of the trendline
     * @default null
     * @aspDefaultValueIgnore
     */
    intercept: number;
    /**
     * Defines the fill color of trendline
     * @default ''
     */
    fill: string;
    /**
     * Sets the legend shape of the trendline
     * @default 'SeriesType'
     */
    legendShape: LegendShape;
    /**
     * Defines the width of the trendline
     * @default 1
     */
    width: number;
}
export  class StockChartAnnotationSettings extends base.ChildProperty<StockChartAnnotationSettings> {
    /**
     * if set coordinateUnit as `Pixel` Y specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    y: string | number;
    /**
     * if set coordinateUnit as `Pixel` X specifies the axis value
     * else is specifies pixel or percentage of coordinate
     * @default '0'
     */
    x: string | Date | number;
    /**
     * Content of the annotation, which accepts the id of the custom element.
     * @default null
     */
    content: string;
    /**
     * Specifies the regions of the annotation. They are
     * * Chart - Annotation renders based on chart coordinates.
     * * Series - Annotation renders based on series coordinates.
     * @default 'Chart'
     */
    region: Regions;
    /**
     * Specifies the alignment of the annotation. They are
     * * Near - Align the annotation element as left side.
     * * Far - Align the annotation element as right side.
     * * Center - Align the annotation element as mid point.
     * @default 'Center'
     */
    horizontalAlignment: Alignment;
    /**
     * Specifies the coordinate units of the annotation. They are
     * * Pixel - Annotation renders based on x and y pixel value.
     * * Point - Annotation renders based on x and y axis value.
     * @default 'Pixel'
     */
    coordinateUnits: Units;
    /**
     * Specifies the position of the annotation. They are
     * * Top - Align the annotation element as top side.
     * * Bottom - Align the annotation element as bottom side.
     * * Middle - Align the annotation element as mid point.
     * @default 'Middle'
     */
    verticalAlignment: Position;
    /**
     * The name of vertical axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    yAxisName: string;
    /**
     * Information about annotation for assistive technology.
     * @default null
     */
    description: string;
    /**
     * The name of horizontal axis associated with the annotation.
     * It requires `axes` of chart.
     * @default null
     */
    xAxisName: string;
}
export  class StockChartIndexes extends base.ChildProperty<StockChartIndexes> {
    /**
     * Specifies index of point
     * @default 0
     * @aspType int
     */
    point: number;
    /**
     * Specifies index of series
     * @default 0
     * @aspType int
     */
    series: number;
}
/**
 * Configures the Stock events for stock chart.
 */
export  class StockEventsSettings extends base.ChildProperty<StockEventsSettings> {
    /**
     * Specifies type of stock events
     * * Circle
     * * Square
     * * Flag
     * * Text
     * * Sign
     * * Triangle
     * * InvertedTriangle
     * * ArrowUp
     * * ArrowDown
     * * ArrowLeft
     * * ArrowRight
     * @default 'Circle'
     */
    type: FlagType;
    /**
     * Specifies the text for the stock chart text.
     */
    text: string;
    /**
     * Specifies the description for the chart which renders in tooltip for stock event.
     */
    description: string;
    /**
     * Date value of stock event in which stock event shows.
     */
    date: Date;
    /**
     * Options to customize the border of the stock events.
     */
    border: StockChartBorderModel;
    /**
     * The background of the stock event that accepts value in hex and rgba as a valid CSS color string.
     * @default 'transparent'
     */
    background: string;
    /**
     * Enables the stock events to be render on series. If it disabled, stock event rendered on primaryXAxis.
     * @default true
     */
    showOnSeries: boolean;
    /**
     * Corresponding values in which stock event placed.
     * * Close
     * * Open
     * * High
     * * Close
     * @default 'close'
     */
    placeAt: string;
    /**
     * Options to customize the styles for stock events text.
     */
    textStyle: StockChartFontModel;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/renderer/cartesian-chart.d.ts
/** @private */
export  class CartesianChart {
    private stockChart;
    cartesianChartSize: svgBase.Size;
    constructor(chart: StockChart);
    initializeChart(chartArgsData?: object[]): void;
    private findMargin;
    private findSeriesCollection;
    calculateChartSize(): svgBase.Size;
    private calculateUpdatedRange;
    /**
     * Cartesian chart refreshes based on start and end value
     * @param stockChart
     * @param start
     * @param end
     */
    cartesianChartRefresh(stockChart: StockChart, start: number, end: number, data?: Object[]): void;
    private copyObject;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/renderer/range-selector.d.ts
/** @private */
export  class RangeSelector {
    private stockChart;
    constructor(stockChart: StockChart);
    initializeRangeNavigator(): void;
    private findMargin;
    private findSeriesCollection;
    private calculateChartSize;
    /**
     * Performs slider change
     * @param start
     * @param end
     */
    sliderChange(start: number, end: number): void;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/renderer/stock-events.d.ts
/**
 * Used for stock event calculations.
 */
/**
 * @private
 */
export  class StockEvents extends BaseTooltip {
    constructor(stockChart: StockChart);
    private stockChart;
    private chartId;
    /** @private */
    stockEventTooltip: svgBase.Tooltip;
    /** @private */
    symbolLocations: ChartLocation[][];
    private pointIndex;
    private seriesIndex;
    /**
     * @private
     * To render stock events in chart
     */
    renderStockEvents(): Element;
    private findClosePoint;
    private createStockElements;
    renderStockEventTooltip(targetId: string): void;
    /**
     * Remove the stock event tooltip
     * @param duration
     */
    removeStockEventTooltip(duration: number): void;
    private findArrowpaths;
    private applyHighLights;
    private removeHighLights;
    private setOpacity;
    /**
     * @param value
     * To convert the c# or javascript date formats into js format
     * refer chart control's dateTime processing.
     */
    private dateParse;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/renderer/toolbar-selector.d.ts
/**
 * Period selector for range navigator
 */
/** @private */
export  class ToolBarSelector {
    private stockChart;
    private indicatorDropDown;
    private trendlineDropDown;
    private selectedSeries;
    private selectedIndicator;
    private selectedTrendLine;
    constructor(chart: StockChart);
    initializePeriodSelector(): void;
    /**
     * This method returns itemModel for dropdown button
     * @param type
     */
    private getDropDownItems;
    /**
     * This method changes the type of series while selectind series in dropdown button
     */
    private addedSeries;
    initializeSeriesSelector(): void;
    private trendline;
    private indicators;
    private secondayIndicators;
    resetButton(): void;
    initializeTrendlineSelector(): void;
    initializeIndicatorSelector(): void;
    private getIndicator;
    createIndicatorAxes(type: TechnicalIndicators, args: splitbuttons.MenuEventArgs): void;
    tickMark(args: splitbuttons.MenuEventArgs): string;
    printButton(): void;
    exportButton(): void;
    calculateAutoPeriods(): PeriodsModel[];
    private findRange;
    /**
     * Text elements added to while export the chart
     * It details about the seriesTypes, indicatorTypes and Trendlines selected in chart.
     */
    private addExportSettings;
    /** @private */
    private textElementSpan;
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/stock-chart-model.d.ts
/**
 * Interface for a class StockChart
 */
export interface StockChartModel extends base.ComponentModel{
    /**
     * The width of the stockChart as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, stockChart renders to the full width of its parent element.
     * @default null
     */
    width?: string;
    /**
     * The height of the stockChart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, stockChart renders to the full height of its parent element.
     * @default null
     */
    height?: string;
    /**
     * Specifies the DataSource for the stockChart. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='financial'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let financial: stockChart = new stockChart({
     * ...
     *  dataSource:dataManager,
     *   series: [{
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * financial.appendTo('#financial');
     * ```
     * @default ''
     */
    dataSource?: Object | data.DataManager;
    /**
     *  Options to customize left, right, top and bottom margins of the stockChart.
     */
    margin?: StockMarginModel;
    /**
     * Options for customizing the color and width of the stockChart border.
     */
    border?: StockChartBorderModel;
    /**
     * The background color of the stockChart that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    background?: string;
    /**
     * Specifies the theme for the stockChart.
     * @default 'Material'
     */
    theme?: ChartTheme;
    /**
     * Options to configure the horizontal axis.
     */
    primaryXAxis?: StockChartAxisModel;
    /**
     * Options for configuring the border and background of the stockChart area.
     */
    chartArea?: StockChartAreaModel;
    /**
     * Options to configure the vertical axis.
     */
    primaryYAxis?: StockChartAxisModel;
    /**
     * Options to split stockChart into multiple plotting areas horizontally.
     * Each object in the collection represents a plotting area in the stockChart.
     */
    rows?: StockChartRowModel[];
    /**
     * Secondary axis collection for the stockChart.
     */
    axes?: StockChartAxisModel[];
    /**
     * The configuration for series in the stockChart.
     */
    series?: StockSeriesModel[];
    /**
     * The configuration for stock events in the stockChart.
     */
    stockEvents?: StockEventsSettingsModel[];
    /**
     * It specifies whether the stockChart should be render in transposed manner or not.
     * @default false
     */
    isTransposed?: boolean;
    /**
     * Title of the chart
     * @default ''
     */
    title?: string;
    /**
     * Options for customizing the title of the Chart.
     */
    // tslint:disable-next-line:max-line-length
    titleStyle?: StockChartFontModel;
    /**
     * Defines the collection of technical indicators, that are used in financial markets
     */
    indicators?: StockChartIndicatorModel[];
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip?: TooltipSettingsModel;
    /**
     * Options for customizing the crosshair of the chart.
     */
    crosshair?: CrosshairSettingsModel;
    /**
     * Options to enable the zooming feature in the chart.
     */
    zoomSettings?: ZoomSettingsModel;
    /**
     * It specifies whether the periodSelector to be rendered in financial chart
     * @default true
     */
    enablePeriodSelector?: boolean;
    /**
     * Custom Range
     * @default true
     */
    enableCustomRange?: boolean;
    /**
     * If set true, enables the animation in chart.
     * @default false
     */
    isSelect?: boolean;
    /**
     * It specifies whether the range navigator to be rendered in financial chart
     * @default true
     */
    enableSelector?: boolean;
    /**
     * To configure period selector options.
     */
    periods?: PeriodsModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations?: StockChartAnnotationSettingsModel[];
    /**
     * Triggers before render the selector
     * @event
     * @deprecated
     */
    selectorRender?: base.EmitType<IRangeSelectorRenderEventArgs>;
    /**
     * Triggers on hovering the stock chart.
     * @event
     * @blazorProperty 'OnStockChartMouseMove'
     */
    stockChartMouseMove?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers when cursor leaves the chart.
     * @event
     * @blazorProperty 'OnStockChartMouseLeave'
     */
    stockChartMouseLeave?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnStockChartMouseDown'
     */
    stockChartMouseDown?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnStockChartMouseUp'
     */
    stockChartMouseUp?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the stock chart.
     * @event
     * @blazorProperty 'OnStockChartMouseClick'
     */
    stockChartMouseClick?: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick?: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove?: base.EmitType<IPointEventArgs>;
    /**
     * Specifies whether series or data point has to be selected. They are,
     * * none: Disables the selection.
     * * series: selects a series.
     * * point: selects a point.
     * * cluster: selects a cluster of point
     * * dragXY: selects points by dragging with respect to both horizontal and vertical axes
     * * dragX: selects points by dragging with respect to horizontal axis.
     * * dragY: selects points by dragging with respect to vertical axis.
     * @default None
     */
    selectionMode?: SelectionMode;
    /**
     * If set true, enables the multi selection in chart. It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * @default false
     */
    isMultiSelect?: boolean;
    /**
     * Triggers before the range navigator rendering
     * @event
     * @deprecated
     */
    load?: base.EmitType<IStockChartEventArgs>;
    /**
     * Triggers after the range navigator rendering
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded?: base.EmitType<IStockChartEventArgs>;
    /**
     * Triggers if the range is changed
     * @event
     * @blazorProperty 'RangeChange'
     */
    rangeChange?: base.EmitType<IRangeChangeEventArgs>;
    /**
     * Triggers before each axis label is rendered.
     * @event
     * @deprecated
     */
    axisLabelRender?: base.EmitType<IAxisLabelRenderEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     * @deprecated
     */
    tooltipRender?: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    seriesRender?: base.EmitType<ISeriesRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    stockEventRender?: base.EmitType<IStockEventRenderArgs>;
    /**
     * Specifies the point indexes to be selected while loading a chart.
     * It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default []
     */
    selectedDataIndexes?: StockChartIndexesModel[];
    /**
     * It specifies the types of series in financial chart.
     */
    seriesType?: ChartSeriesType[];
    /**
     * It specifies the types of indicators in financial chart.
     */
    indicatorType?: TechnicalIndicators[];
    /**
     * It specifies the types of Export types in financial chart.
     */
    exportType?: ExportType[];
    /**
     * It specifies the types of trendline types in financial chart.
     */
    trendlineType?: TrendlineTypes[];
}
//node_modules/@syncfusion/ej2-charts/src/stock-chart/stock-chart.d.ts
/**
 * Stock Chart
 */
export  class StockChart extends base.Component<HTMLElement> implements base.INotifyPropertyChanged {
    /**
     * The width of the stockChart as a string accepts input as both like '100px' or '100%'.
     * If specified as '100%, stockChart renders to the full width of its parent element.
     * @default null
     */
    width: string;
    /**
     * The height of the stockChart as a string accepts input both as '100px' or '100%'.
     * If specified as '100%, stockChart renders to the full height of its parent element.
     * @default null
     */
    height: string;
    /**
     * Specifies the DataSource for the stockChart. It can be an array of JSON objects or an instance of data.DataManager.
     * ```html
     * <div id='financial'></div>
     * ```
     * ```typescript
     * let dataManager$: data.DataManager = new data.DataManager({
     *         url: 'http://mvc.syncfusion.com/Services/Northwnd.svc/Tasks/'
     * });
     * let query$: Query = new Query().take(50).where('Estimate', 'greaterThan', 0, false);
     * let financial$: stockChart = new stockChart({
     * ...
     *  dataSource:dataManager,
     *   series: [{
     *        xName: 'Id',
     *        yName: 'Estimate',
     *        query: query
     *    }],
     * ...
     * });
     * financial.appendTo('#financial');
     * ```
     * @default ''
     */
    dataSource: Object | data.DataManager;
    /**
     *  Options to customize left, right, top and bottom margins of the stockChart.
     */
    margin: StockMarginModel;
    /**
     * Options for customizing the color and width of the stockChart border.
     */
    border: StockChartBorderModel;
    /**
     * The background color of the stockChart that accepts value in hex and rgba as a valid CSS color string.
     * @default null
     */
    background: string;
    /**
     * Specifies the theme for the stockChart.
     * @default 'Material'
     */
    theme: ChartTheme;
    /**
     * Options to configure the horizontal axis.
     */
    primaryXAxis: StockChartAxisModel;
    /**
     * Options for configuring the border and background of the stockChart area.
     */
    chartArea: StockChartAreaModel;
    /**
     * Options to configure the vertical axis.
     */
    primaryYAxis: StockChartAxisModel;
    /**
     * Options to split stockChart into multiple plotting areas horizontally.
     * Each object in the collection represents a plotting area in the stockChart.
     */
    rows: StockChartRowModel[];
    /**
     * Secondary axis collection for the stockChart.
     */
    axes: StockChartAxisModel[];
    /**
     * The configuration for series in the stockChart.
     */
    series: StockSeriesModel[];
    /**
     * The configuration for stock events in the stockChart.
     */
    stockEvents: StockEventsSettingsModel[];
    /**
     * It specifies whether the stockChart should be render in transposed manner or not.
     * @default false
     */
    isTransposed: boolean;
    /**
     * Title of the chart
     * @default ''
     */
    title: string;
    /**
     * Options for customizing the title of the Chart.
     */
    titleStyle: StockChartFontModel;
    /**
     * Defines the collection of technical indicators, that are used in financial markets
     */
    indicators: StockChartIndicatorModel[];
    /**
     * Options for customizing the tooltip of the chart.
     */
    tooltip: TooltipSettingsModel;
    /**
     * Options for customizing the crosshair of the chart.
     */
    crosshair: CrosshairSettingsModel;
    /**
     * Options to enable the zooming feature in the chart.
     */
    zoomSettings: ZoomSettingsModel;
    /**
     * It specifies whether the periodSelector to be rendered in financial chart
     * @default true
     */
    enablePeriodSelector: boolean;
    /**
     * Custom Range
     * @default true
     */
    enableCustomRange: boolean;
    /**
     * If set true, enables the animation in chart.
     * @default false
     */
    isSelect: boolean;
    /**
     * It specifies whether the range navigator to be rendered in financial chart
     * @default true
     */
    enableSelector: boolean;
    /**
     * To configure period selector options.
     */
    periods: PeriodsModel[];
    /**
     * The configuration for annotation in chart.
     */
    annotations: StockChartAnnotationSettingsModel[];
    /**
     * Triggers before render the selector
     * @event
     * @deprecated
     */
    selectorRender: base.EmitType<IRangeSelectorRenderEventArgs>;
    /**
     * Triggers on hovering the stock chart.
     * @event
     * @blazorProperty 'OnStockChartMouseMove'
     */
    stockChartMouseMove: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers when cursor leaves the chart.
     * @event
     * @blazorProperty 'OnStockChartMouseLeave'
     */
    stockChartMouseLeave: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse down.
     * @event
     * @blazorProperty 'OnStockChartMouseDown'
     */
    stockChartMouseDown: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on mouse up.
     * @event
     * @blazorProperty 'OnStockChartMouseUp'
     */
    stockChartMouseUp: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on clicking the stock chart.
     * @event
     * @blazorProperty 'OnStockChartMouseClick'
     */
    stockChartMouseClick: base.EmitType<IMouseEventArgs>;
    /**
     * Triggers on point click.
     * @event
     * @blazorProperty 'OnPointClick'
     */
    pointClick: base.EmitType<IPointEventArgs>;
    /**
     * Triggers on point move.
     * @event
     * @blazorProperty 'PointMoved'
     */
    pointMove: base.EmitType<IPointEventArgs>;
    /**
     * Specifies whether series or data point has to be selected. They are,
     * * none: Disables the selection.
     * * series: selects a series.
     * * point: selects a point.
     * * cluster: selects a cluster of point
     * * dragXY: selects points by dragging with respect to both horizontal and vertical axes
     * * dragX: selects points by dragging with respect to horizontal axis.
     * * dragY: selects points by dragging with respect to vertical axis.
     * @default None
     */
    selectionMode: SelectionMode;
    /**
     * If set true, enables the multi selection in chart. It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * @default false
     */
    isMultiSelect: boolean;
    /**
     * Triggers before the range navigator rendering
     * @event
     * @deprecated
     */
    load: base.EmitType<IStockChartEventArgs>;
    /**
     * Triggers after the range navigator rendering
     * @event
     * @blazorProperty 'Loaded'
     */
    loaded: base.EmitType<IStockChartEventArgs>;
    /**
     * Triggers if the range is changed
     * @event
     * @blazorProperty 'RangeChange'
     */
    rangeChange: base.EmitType<IRangeChangeEventArgs>;
    /**
     * Triggers before each axis label is rendered.
     * @event
     * @deprecated
     */
    axisLabelRender: base.EmitType<IAxisLabelRenderEventArgs>;
    /**
     * Triggers before the tooltip for series is rendered.
     * @event
     * @deprecated
     */
    tooltipRender: base.EmitType<ITooltipRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    seriesRender: base.EmitType<ISeriesRenderEventArgs>;
    /**
     * Triggers before the series is rendered.
     * @event
     * @deprecated
     */
    stockEventRender: base.EmitType<IStockEventRenderArgs>;
    /**
     * Specifies the point indexes to be selected while loading a chart.
     * It requires `selectionMode` to be `Point` | `Series` | or `Cluster`.
     * ```html
     * <div id='Chart'></div>
     * ```
     * ```typescript
     * let chart$: Chart = new Chart({
     * ...
     *   selectionMode: 'Point',
     *   selectedDataIndexes: [ { series: 0, point: 1},
     *                          { series: 2, point: 3} ],
     * ...
     * });
     * chart.appendTo('#Chart');
     * ```
     * @default []
     */
    selectedDataIndexes: StockChartIndexesModel[];
    /**
     * It specifies the types of series in financial chart.
     */
    seriesType: ChartSeriesType[];
    /**
     * It specifies the types of indicators in financial chart.
     */
    indicatorType: TechnicalIndicators[];
    /**
     * It specifies the types of Export types in financial chart.
     */
    exportType: ExportType[];
    /**
     * It specifies the types of trendline types in financial chart.
     */
    trendlineType: TrendlineTypes[];
    /** @private */
    startValue: number;
    /** @private */
    isSingleAxis: boolean;
    /** @private */
    endValue: number;
    /** @private */
    seriesXMax: number;
    /** @private */
    seriesXMin: number;
    /** @private  */
    currentEnd: number;
    /** Overall SVG */
    mainObject: Element;
    /** @private */
    selectorObject: Element;
    /** @private */
    chartObject: Element;
    /** @private */
    svgObject: Element;
    /** @private */
    isTouch: boolean;
    /** @private */
    renderer: svgBase.SvgRenderer;
    /** @private */
    animateSeries: boolean;
    /** @private */
    availableSize: svgBase.Size;
    /** @private */
    titleSize: svgBase.Size;
    /** @private */
    chartSize: svgBase.Size;
    /** @private */
    intl: base.Internationalization;
    /** @private */
    isDoubleTap: boolean;
    /** @private */
    private threshold;
    /** @private */
    isChartDrag: boolean;
    resizeTo: number;
    /** @private */
    disableTrackTooltip: boolean;
    /** @private */
    startMove: boolean;
    /** @private */
    yAxisElements: Element;
    /** @private */
    themeStyle: IThemeStyle;
    /** @private */
    scrollElement: Element;
    private chartid;
    tempSeriesType: ChartSeriesType[];
    /** @private */
    chart: Chart;
    /** @private */
    rangeNavigator: RangeNavigator;
    /** @private */
    periodSelector: PeriodSelector;
    /** @private */
    cartesianChart: CartesianChart;
    /** @private */
    rangeSelector: RangeSelector;
    /** @private */
    toolbarSelector: ToolBarSelector;
    /** @private */
    stockEvent: StockEvents;
    /** private */
    zoomChange: boolean;
    /** @private */
    mouseDownX: number;
    /** @private */
    mouseDownY: number;
    /** @private */
    previousMouseMoveX: number;
    /** @private */
    previousMouseMoveY: number;
    /** @private */
    mouseDownXPoint: number;
    /** @private */
    mouseUpXPoint: number;
    /** @private */
    allowPan: boolean;
    /** @private  */
    onPanning: boolean;
    /** @private  */
    referenceXAxis: Axis;
    /** @private */
    mouseX: number;
    /** @private */
    mouseY: number;
    /** @private */
    indicatorElements: Element;
    /** @private */
    trendlinetriggered: boolean;
    /** @private */
    periodSelectorHeight: number;
    /** @private */
    toolbarHeight: number;
    /** @private */
    stockChartTheme: IThemeStyle;
    /** @private */
    initialRender: boolean;
    /** @private */
    rangeFound: boolean;
    /** @private */
    tempPeriods: PeriodsModel[];
    /**
     * Constructor for creating the widget
     * @hidden
     */
    constructor(options?: StockChartModel, element?: string | HTMLElement);
    /**
     * Called internally if any of the property value changed.
     * @private
     */
    onPropertyChanged(newProp: StockChartModel, oldProp: StockChartModel): void;
    /**
     * To change the range for chart
     */
    rangeChanged(updatedStart: number, updatedEnd: number): void;
    /**
     * Pre render for financial Chart
     */
    protected preRender(): void;
    /**
     * Method to bind events for chart
     */
    private unWireEvents;
    private wireEvents;
    private initPrivateVariable;
    /**
     * Method to set culture for chart
     */
    private setCulture;
    private storeDataSource;
    /**
     * To Initialize the control rendering.
     */
    protected render(): void;
    /**
     * data.DataManager Success
     */
    stockChartDataManagerSuccess(): void;
    /**
     * To set styles to resolve mvc width issue.
     * @param element
     */
    private setStyle;
    private drawSVG;
    private createSecondaryElements;
    findCurrentData(totalData: Object, xName: string): Object;
    /**
     * Render period selector
     */
    renderPeriodSelector(): void;
    private chartRender;
    /**
     * To render range Selector
     */
    private renderRangeSelector;
    /**
     * Get component name
     */
    getModuleName(): string;
    /**
     * Get the properties to be maintained in the persisted state.
     * @private
     */
    getPersistData(): string;
    /**
     * To Remove the SVG.
     * @return {boolean}
     * @private
     */
    removeSvg(): void;
    /**
     * Module Injection for components
     */
    chartModuleInjection(): void;
    /**
     * find range for financal chart
     */
    private findRange;
    /**
     * Handles the chart resize.
     * @return {boolean}
     * @private
     */
    stockChartResize(e: Event): boolean;
    /**
     * Handles the mouse down on chart.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseDown(e: PointerEvent): boolean;
    /**
     * Handles the mouse up.
     * @return {boolean}
     * @private
     */
    stockChartMouseEnd(e: PointerEvent): boolean;
    /**
     * Handles the mouse up.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseUp(e: PointerEvent | TouchEvent): boolean;
    /**
     * To find mouse x, y for aligned chart element svg position
     */
    private setMouseXY;
    /**
     * Handles the mouse move.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseMove(e: PointerEvent): boolean;
    /**
     * Handles the mouse move on chart.
     * @return {boolean}
     * @private
     */
    chartOnMouseMove(e: PointerEvent | TouchEvent): boolean;
    /**
     * Handles the mouse click on chart.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseClick(e: PointerEvent | TouchEvent): boolean;
    private stockChartRightClick;
    /**
     * Handles the mouse leave.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseLeave(e: PointerEvent): boolean;
    /**
     * Handles the mouse leave on chart.
     * @return {boolean}
     * @private
     */
    stockChartOnMouseLeaveEvent(e: PointerEvent | TouchEvent): boolean;
    /**
     * Destroy method
     */
    destroy(): void;
    private renderBorder;
    /**
     * Render title for chart
     */
    private renderTitle;
    private findTitleColor;
    /**
     * @private
     */
    calculateStockEvents(): void;
}
 }
export namespace circulargauge { 

//node_modules/@syncfusion/ej2-circulargauge/src/circular-gauge/annotations/annotations.d.ts
/**
 * Annotation Module handles the Annotation of the axis.
 */
export  class Annotations {
    private gauge;
    private elementId;
    /**
     * Constructor for Annotation module.
     * @private.
     */
    constructor(gauge: CircularGauge);
    /**
     * Method to render the annotation for circular gauge.
     */
    renderAnnotation(axis: Axis, index: number): void;
    /**
     * Method to create annotation template for circular gauge.
     */
    createTemplate(element: HTMLElement, annotationIndex: number, axisIndex: number): void;
    /**
     * Method to update the annotation location for circular gauge.
     */
    private updateLocation;
    /**
     * Get module name.
     */
    protected getModuleName(): string;
    /**
     * To destroy the annotation.
     * @return {void}
     * @private
     */
    destroy(gauge: CircularGauge): void;
}
//node_modules/@syncfusion/ej2-circulargauge/src/circular-gauge/axes/axis-model.d.ts
/**
 * Interface for a class Line
 */
export interface LineModel {
    /**
     * The width of the line in pixels.
     * @default 2
     */
    width?: number;
    /**
     * The dash array of the axis line.
     * @default ''
     */
    dashArray?: string;
    /**
     * The color of the axis line, which accepts value in hex, rgba as a valid CSS color string.
     */
    color?: string;
}
/**
 * Interface for a class Label
 */
export interface LabelModel {
    /**
     * The font of the axis labels
     */
    font?: FontModel;
    /**
     * To format the axis label, which accepts any global string format like 'C', 'n1', 'P' etc.
     * Also accepts placeholder like '{value}°C' in which value represent the axis label e.g. 20°C.
     * @default ''
     */
    format?: string;
    /**
     * Specifies the position of the labels. They are,
     * * inside -  Places the labels inside the axis.
     * * outside - Places the labels outside of the axis.
     * @default Inside
     */
    position?: Position;
    /**
     * Specifies the label of an axis, which must get hide when an axis makes a complete circle. They are
     * * first -  Hides the 1st label on intersect.
     * * last - Hides the last label on intersect.
     * * none - Places both the labels.
     * @default None
     */
    hiddenLabel?: HiddenLabel;
    /**
     * if set true, the labels will get rotated along the axis.
     * @default false
     */
    autoAngle?: boolean;
    /**
     * If set true, labels takes the range color.
     * @default false
     */
    useRangeColor?: boolean;
    /**
     * Distance of the labels from axis in pixel.
     * @default 0
     */
    offset?: number;
}
/**
 * Interface for a class Range
 */
export interface RangeModel {
    /**
     * Specifies the minimum value of the range.
     * @aspDefaultValueIgnore
     * @default 0
     */
    start?: number;
    /**
     * Specifies the maximum value of the range.
     * @aspDefaultValueIgnore
     * @default 0
     */
    end?: number;
    /**
     * The radius of the range in pixels or in percentage.
     * @default null
     */
    radius?: string;
    /**
     * Specifies the start width of the ranges
     * @default '10'
     */
    startWidth?: number | string;
    /**
     * Specifies the end wid