import { Component, ViewChild } from '@angular/core';
import { Query, DataManager, Predicate, WebApiAdaptor, JsonAdaptor, ODataV4Adaptor, ODataAdaptor } from '@syncfusion/ej2-data';
import { naics } from './naics';
import { FormGroup, FormBuilder } from '@angular/forms';
import { AutoCompleteComponent, FilteringEventArgs } from '@syncfusion/ej2-angular-dropdowns';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent {

  public data: DataManager = new DataManager({
    url: 'https://services.odata.org/V4/OData/OData.svc/Products',
    adaptor: new ODataV4Adaptor,
    crossDomain: true
  });

  // maps the appropriate column to fields property
  public fields: Object = { value: 'ID', text: 'Name' };
  public query: Query = new Query().select(['ID, Name']).take(10).requiresCount();

  public form: FormGroup;

  // Filtering search is case-sensitive
  onFiltering(e: FilteringEventArgs) {
    if (e.text && e.text.length >= 3) {
      const predicate = new Predicate('Name', 'contains', e.text, true);
      let query = new Query();
      query = (e.text != '') ? query.where(predicate) : query;
      e.updateData(this.data, query);
    } else {
      const query = new Query();
      e.updateData(this.data, query);
    }
  }

  ngOnInit() {
    // create a form with pre-populated productId
    const fb = new FormBuilder();
    this.form = fb.group({
      productId: 9  // Lemonade
    });
  }
}
