﻿using Syncfusion.DocIO.DLS;
using Syncfusion.DocToPDFConverter;
using Syncfusion.Pdf;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("TestPdfConvert-Ok.docx...");
            TestExport("TestPdfConvert-Ok.docx");

            Console.WriteLine("TestPdfConvert-Fail.docx...");
            TestExport("TestPdfConvert-Fail.docx");

            Console.WriteLine("Press any key to exit");
            Console.ReadKey();
        }


        public static void TestExport(string fileName)
        {
            try
            {
                using (WordDocument wordDocument = new WordDocument(fileName))
                using (DocToPDFConverter converter = new DocToPDFConverter())
                using (PdfDocument pdfDocument = converter.ConvertToPDF(wordDocument))
                {
                    pdfDocument.Save(Path.Combine(@"D:\Temp", fileName + ".pdf"));
                }
            }
            catch (Exception exception)
            {
                Console.WriteLine(exception.ToString());
            }
        }
    }
}
