﻿using Syncfusion.WinForms.DataGrid;
using Syncfusion.WinForms.DataGrid.Enums;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SyncfusionWinFormsApp1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

             grid.ShowRowHeader = true;
            grid.AutoGenerateColumns = false;        
            grid.AutoSizeColumnsMode = AutoSizeColumnsMode.ColumnHeader;
            grid.SelectionMode = GridSelectionMode.Single;
            grid.FilterRowPosition = RowPosition.FixedTop;

            grid.Columns.Clear();
           //grid.ShowToolTip = true;

            var colA1 = CreateTextCol("a1", "Column Label A1");            
            grid.Columns.Add(colA1);

            var colA2 = CreateTextCol("A2", "Column Label A2");
             grid.Columns.Add(colA2);

            var colA3 = CreateTextCol("A3", "Column Label A3");
             grid.Columns.Add(colA3);

            var colA4 = CreateTextCol("A4", "Column Label A4");
             grid.Columns.Add(colA4);

            var colA5 = CreateTextCol("A5", "Column Label A5");
             grid.Columns.Add(colA5);

            var colA6 = CreateTextCol("A6", "Column Label A6");
             grid.Columns.Add(colA6);

            var colA7 = CreateTextCol("A7", "Column Label A7");
             grid.Columns.Add(colA7);
            colA7.AllowEditing = false;
            var colA8 = CreateTextCol("A8", "Column Label A8");
             grid.Columns.Add(colA8);
            colA8.AllowEditing = false;
            colA8.ShowFilterRowOptions = false;


            grid.DataSource = getDS();
        }

        private List<model> getDS()
        {
            var ds = new List<model>();

            ds.Add(new model() );
            return ds;
        }

        public  GridTextColumn CreateTextCol(string MappingName, string HeaderText, AutoSizeColumnsMode autoSizeColumnsMode = AutoSizeColumnsMode.AllCells)
        {
            var col = new GridTextColumn();
            col.HeaderText = HeaderText;
            col.MappingName = MappingName;
             col.AllowEditing = true;
            col.AllowFiltering = true;
             col.ShowFilterRowOptions = true;
             col.FilterRowCondition = FilterRowCondition.Contains;
            col.AutoSizeColumnsMode = autoSizeColumnsMode;
            col.ImmediateUpdateColumnFilter = true;
            col.FilterPopupMode = Syncfusion.WinForms.GridCommon.FilterPopupMode.Both;
            return col;
        }
    }



}
