﻿using Newtonsoft.Json;
using Rostering.Abstractions.Interfaces;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace Rostering.Abstractions.Model
{
    public class RosterShiftTemplate : IDao<int>, IShiftTemplateRowPlaceable
    {
        private DateTime _date;

        [NotMapped]
        public string PlanningId => Id != 0 ? Id.ToString() : Guid.NewGuid().ToString();

        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public int Id { get; set; }

        [JsonProperty(ReferenceLoopHandling = ReferenceLoopHandling.Ignore)]
        public Roster Roster { get; set; }
        public int RosterId { get; set; }
        public DateTime Date { get => _date.ToUniversalTime(); set { _date = value.ToUniversalTime(); } }
        public int Row { get; set; }
        public ShiftTemplate ShiftTemplate { get; set; }
        public int ShiftTemplateId { get; set; }
        public DayOfWeek DayOfWeek { get; set; }
        public int WeekNumber { get; set; }
        public int? UserId { get; set; }
        public ApplicationUser User { get; set; }

        [JsonProperty(ReferenceLoopHandling = ReferenceLoopHandling.Ignore)]
        public virtual ICollection<BrokenConstraints> BrokenConstraints { get; set; } = new List<BrokenConstraints>();

        [NotMapped]
        public DateTime StartTime => _date.Add(ShiftTemplate.Start.GetValueOrDefault().TimeOfDay);

        [NotMapped]
        public DateTime EndTime => _date.Add(ShiftTemplate.End.GetValueOrDefault().TimeOfDay);

        [NotMapped]
        public string Subject => ShiftTemplate?.ShiftBoxText;

        [NotMapped]
        //[JsonIgnore]
        public string Location => ShiftTemplate?.Department?.Code;

        [NotMapped]
        //[JsonIgnore]
        public string Description => $"Roster: {Roster?.Name}";

        [NotMapped]
        public int? DepartmentId => User?.DepartmentId;
    }
}
