﻿using Syncfusion.DocIO.DLS;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("".PadRight(40, '-'));
            Console.WriteLine("Test Bookmark");
            Console.WriteLine("".PadRight(40, '-'));

            Console.WriteLine($"Before first load/save: {new FileInfo("TestBookmark_Source.docx").Length}");
            using (WordDocument doc = new WordDocument("TestBookmark_Source.docx"))
            {
                Console.WriteLine($"Bookmark existing before first save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
                doc.Save(@"TestBookmark_Destination.docx");
                Console.WriteLine($"Bookmark existing after first save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
            }
            Console.WriteLine($"After first load/save: {new FileInfo("TestBookmark_Destination.docx").Length}");

            using (WordDocument doc = new WordDocument("TestBookmark_Destination.docx"))
            {
                Console.WriteLine($"Bookmark existing before second save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
                doc.Save(@"TestBookmark_Destination.docx");
                Console.WriteLine($"Bookmark existing after second save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
            }
            Console.WriteLine($"After second load/save: {new FileInfo("TestBookmark_Destination.docx").Length}");

            using (WordDocument doc = new WordDocument("TestBookmark_Destination.docx"))
            {
                Console.WriteLine($"Bookmark existing before third save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
                doc.Save(@"TestBookmark_Destination.docx");
                Console.WriteLine($"Bookmark existing after third save: {(doc.Bookmarks.FindByName("MyBookmark") != null ? "yes" : "no")}");
            }
            Console.WriteLine($"After third load/save: {new FileInfo("TestBookmark_Destination.docx").Length}");


            Console.WriteLine("".PadRight(40, '-'));
            Console.WriteLine("Test TextBox");
            Console.WriteLine("".PadRight(40, '-'));

            using (WordDocument doc = new WordDocument("TestTextBox_Source.docx"))
            {
                IterateEntities(doc.Sections[0].Body.ChildEntities, (Entity entity) =>
                {
                    if (entity is WTextBox textBox)
                    {
                        Console.WriteLine($"TextBox is visible: {(textBox.Visible ? "yes" : "no")}");
                        textBox.Visible = false;
                        return true;
                    }

                    return false;
                });
                doc.Save("TestTextBox_Destination.docx");
            }

            using (WordDocument doc = new WordDocument("TestTextBox_Destination.docx"))
            {
                IterateEntities(doc.Sections[0].Body.ChildEntities, (Entity entity) =>
                {
                    if (entity is WTextBox textBox)
                    {
                        Console.WriteLine($"TextBox is visible: {(textBox.Visible ? "yes" : "no")}");
                        textBox.Visible = true;
                        return true;
                    }

                    return false;
                });
                doc.Save("TestTextBox_Destination.docx");
            }

            using (WordDocument doc = new WordDocument("TestTextBox_Destination.docx"))
            {
                IterateEntities(doc.Sections[0].Body.ChildEntities, (Entity entity) =>
                {
                    if (entity is WTextBox textBox)
                    {
                        Console.WriteLine($"TextBox is visible: {(textBox.Visible ? "yes" : "no")}");
                        return true;
                    }

                    return false;
                });
                doc.Save("TestTextBox_Destination.docx");
            }


            Console.ReadKey();
        }


        /// <summary>
        /// Iterates the entities.
        /// </summary>
        /// <param name="entities">The entities.</param>
        /// <param name="callback">The callback.</param>
        /// <returns><c>true</c> if callback returns true which results in aborting the iteration; otherwise <c>false</c>.</returns>
        protected static bool IterateEntities(EntityCollection entities, Func<Entity, bool> callback)
        {
            // Iterates through each given child item
            for (int i = 0; i < entities.Count; i++)
            {
                // IEntity is the basic unit in DocIO DOM
                IEntity entity = entities[i];
                switch (entity.EntityType)
                {
                    // Processes the paragraph content by iterating through the paragraphs DOM
                    case EntityType.Paragraph:
                        WParagraph paragraph = entity as WParagraph;
                        if (callback(paragraph))
                        {
                            return true;
                        }

                        for (int j = 0; j < paragraph.ChildEntities.Count; j++)
                        {
                            if (callback(paragraph.ChildEntities[j]))
                            {
                                return true;
                            }

                            // Special case: Text boxes
                            if (paragraph.ChildEntities[j] is WTextBox textBox)
                            {
                                if (IterateEntities(textBox.ChildEntities, callback))
                                {
                                    return true;
                                }
                            }
                        }
                        break;

                    // Table is a collection of rows and cells so iterate through tables DOM
                    case EntityType.Table:
                        WTable table = entity as WTable;
                        if (callback(table))
                        {
                            return true;
                        }

                        foreach (WTableRow row in table.Rows)
                        {
                            foreach (WTableCell cell in row.Cells)
                            {
                                // Table cell is derived from (also a) TextBody with entities 
                                // so reusing the code meant for iterating the entities
                                if (IterateEntities(cell.ChildEntities, callback))
                                {
                                    return true;
                                }
                            }
                        }
                        break;
                }
            }

            return false;
        }
    }
}
