import { render } from 'react-dom';
import './index.css';
import * as React from "react";
import { SampleBase } from './sample-base';
import { DashboardLayoutComponent, PanelsDirective, PanelDirective } from "@syncfusion/ej2-react-layouts";
import { ButtonComponent } from "@syncfusion/ej2-react-buttons";
import {
    ColumnDirective,
    ColumnsDirective,
    CommandColumn,
    CommandModel,
    GridComponent,
    Inject
} from '@syncfusion/ej2-react-grids';
import {Scrollbar} from 'react-scrollbars-custom';

export class DynamicWidget extends SampleBase {
    constructor(props) {
        super(props);
        this.state = {
            showPanel: true
        };
    }
    btnClick() {
       this.setState({ showPanel: false });
    }
    btnClickShow() {
       this.setState({ showPanel: true });
    }

    render() {
        return (<div>
                <div id='edit_target' className="control-section">
                <div>
                    <div style={{ "width": "100%", "height": "30px" }}>
                        <ButtonComponent cssClass='e-outline e-flat e-primary' ref={(scope) => { this.btnobj = scope; }} iconCss='edit' isToggle={true} onClick={this.btnClick.bind(this)} style={{ "float": "right", "width": "75px" }}>
                            Hide
                        </ButtonComponent>
                    </div>
                    <div style={{ "width": "100%", "height": "30px" }}>
                        <ButtonComponent cssClass='e-outline e-flat e-primary' ref={(scope) => { this.btnobj = scope; }} iconCss='edit' isToggle={true} onClick={this.btnClickShow.bind(this)} style={{ "float": "right", "width": "75px" }}>
                            Show
                        </ButtonComponent>
                    </div>
                </div>
                <Scrollbar style={{ maxHeight: 'calc(100vh - 110px)', minHeight: 'calc(100vh - 110px)'}} native={true}>
                <DashboardLayoutComponent id="edit_dashboard" columns={2} cellSpacing={this.cellSpacing} ref={(scope) => { this.dashboardObj = scope; }} allowResizing={true} allowDragging={true}>
                       <div id={"test2"} className="e-panel e-panel-transition e-lib e-draggable" data-row={0} data-col={0} data-sizex={1} data-sizey={1} data-minsizex="1" data-minsizey="1"> 
                        <div id="gridHost" className="grid-host">
                        <GridComponent key={'customerHistoryGrid'} enablePersistence={false}  clipMode="EllipsisWithTooltip" allowTextWrap={false} textWrapSettings={ {wrapMode: "Both"}} height={100} > 
                            <ColumnsDirective >
                                <ColumnDirective field="id" visible={false} isPrimaryKey={true}/>
                                <ColumnDirective field="name"  allowEditing={false} headerText={"header1"} width="30" textAlign="Left"   />
                            </ColumnsDirective>
                        </GridComponent>
                      </div>
                        </div>

                        {this.state.showPanel?
                        <div id={"test2"} className="e-panel e-panel-transition e-lib e-draggable" data-row={0} data-col={1} data-sizex={1} data-sizey={1} data-minsizex="1" data-minsizey="1"> 
                        <div id="gridHost" className="grid-host">
                         <GridComponent key={'customerHistoryGrid'} enablePersistence={false}  clipMode="EllipsisWithTooltip" allowTextWrap={false} textWrapSettings={ {wrapMode: "Both"}}  > 
                            <ColumnsDirective >
                                <ColumnDirective field="id" visible={false} isPrimaryKey={true}/>
                                <ColumnDirective field="name"  allowEditing={false} headerText={"header2"} width="30" textAlign="Left"   />
                            </ColumnsDirective>
                        </GridComponent>
                        </div>
                        </div> : null}
                        
                </DashboardLayoutComponent>
                 </Scrollbar>
                </div>
            </div>);
    }

}

render(<DynamicWidget />, document.getElementById('sample'));