define(['dart_sdk'], function(dart_sdk) {
  'use strict';
  const core = dart_sdk.core;
  const collection = dart_sdk.collection;
  const _interceptors = dart_sdk._interceptors;
  const async = dart_sdk.async;
  const dart = dart_sdk.dart;
  const dartx = dart_sdk.dartx;
  const list_range = Object.create(dart.library);
  const shared = Object.create(dart.library);
  const util = Object.create(dart.library);
  const utf_16_code_unit_decoder = Object.create(dart.library);
  const constants = Object.create(dart.library);
  const utf8 = Object.create(dart.library);
  const utf16 = Object.create(dart.library);
  const utf32 = Object.create(dart.library);
  const utf = Object.create(dart.library);
  const utf_stream = Object.create(dart.library);
  const $length = dartx.length;
  const $iterator = dartx.iterator;
  const $_get = dartx._get;
  const $codeUnits = dartx.codeUnits;
  const $_set = dartx._set;
  const $setRange = dartx.setRange;
  const $rightShift = dartx['>>'];
  const $truncate = dartx.truncate;
  const $addAll = dartx.addAll;
  const $sublist = dartx.sublist;
  const $add = dartx.add;
  let ListOfint = () => (ListOfint = dart.constFn(core.List$(core.int)))();
  let JSArrayOfint = () => (JSArrayOfint = dart.constFn(_interceptors.JSArray$(core.int)))();
  let VoidToUtf16BytesToCodeUnitsDecoder = () => (VoidToUtf16BytesToCodeUnitsDecoder = dart.constFn(dart.fnType(utf16.Utf16BytesToCodeUnitsDecoder, [])))();
  let VoidToUtf16beBytesToCodeUnitsDecoder = () => (VoidToUtf16beBytesToCodeUnitsDecoder = dart.constFn(dart.fnType(utf16.Utf16beBytesToCodeUnitsDecoder, [])))();
  let VoidToUtf16leBytesToCodeUnitsDecoder = () => (VoidToUtf16leBytesToCodeUnitsDecoder = dart.constFn(dart.fnType(utf16.Utf16leBytesToCodeUnitsDecoder, [])))();
  let VoidToUtf32BytesDecoder = () => (VoidToUtf32BytesDecoder = dart.constFn(dart.fnType(utf32.Utf32BytesDecoder, [])))();
  let VoidToUtf32beBytesDecoder = () => (VoidToUtf32beBytesDecoder = dart.constFn(dart.fnType(utf32.Utf32beBytesDecoder, [])))();
  let VoidToUtf32leBytesDecoder = () => (VoidToUtf32leBytesDecoder = dart.constFn(dart.fnType(utf32.Utf32leBytesDecoder, [])))();
  let StreamOfListOfint = () => (StreamOfListOfint = dart.constFn(async.Stream$(ListOfint())))();
  let StreamOfString = () => (StreamOfString = dart.constFn(async.Stream$(core.String)))();
  let EventSinkOfString = () => (EventSinkOfString = dart.constFn(async.EventSink$(core.String)))();
  let EventSinkOfStringTo_StringDecoder = () => (EventSinkOfStringTo_StringDecoder = dart.constFn(dart.fnType(utf_stream._StringDecoder, [EventSinkOfString()])))();
  let VoidToint = () => (VoidToint = dart.constFn(dart.fnType(core.int, [])))();
  let VoidTovoid = () => (VoidTovoid = dart.constFn(dart.fnType(dart.void, [])))();
  let EventSinkOfListOfint = () => (EventSinkOfListOfint = dart.constFn(async.EventSink$(ListOfint())))();
  let EventSinkOfListOfintTo_StringEncoder = () => (EventSinkOfListOfintTo_StringEncoder = dart.constFn(dart.fnType(utf_stream._StringEncoder, [EventSinkOfListOfint()])))();
  const CT = Object.create(null);
  const _source$ = dart.privateName(list_range, "_source");
  const _offset = dart.privateName(list_range, "_offset");
  const _length = dart.privateName(list_range, "_length");
  list_range.ListRange = class ListRange extends collection.IterableBase$(core.int) {
    get iterator() {
      return new list_range._ListRangeIteratorImpl.new(this[_source$], this[_offset], dart.notNull(this[_offset]) + dart.notNull(this[_length]));
    }
    get length() {
      return this[_length];
    }
  };
  (list_range.ListRange.new = function(source, offset = 0, length = null) {
    this[_source$] = source;
    this[_offset] = offset;
    this[_length] = length == null ? dart.notNull(source[$length]) - dart.notNull(offset) : length;
    list_range.ListRange.__proto__.new.call(this);
    if (dart.notNull(this[_offset]) < 0 || dart.notNull(this[_offset]) > dart.notNull(this[_source$][$length])) {
      dart.throw(new core.RangeError.value(this[_offset]));
    }
    if (this[_length] != null && dart.notNull(this[_length]) < 0) {
      dart.throw(new core.RangeError.value(this[_length]));
    }
    if (dart.notNull(this[_length]) + dart.notNull(this[_offset]) > dart.notNull(this[_source$][$length])) {
      dart.throw(new core.RangeError.value(dart.notNull(this[_length]) + dart.notNull(this[_offset])));
    }
  }).prototype = list_range.ListRange.prototype;
  dart.addTypeTests(list_range.ListRange);
  dart.setGetterSignature(list_range.ListRange, () => ({
    __proto__: dart.getGetters(list_range.ListRange.__proto__),
    iterator: list_range.ListRangeIterator,
    [$iterator]: list_range.ListRangeIterator
  }));
  dart.setLibraryUri(list_range.ListRange, "package:utf/src/list_range.dart");
  dart.setFieldSignature(list_range.ListRange, () => ({
    __proto__: dart.getFields(list_range.ListRange.__proto__),
    [_source$]: dart.finalFieldType(core.List$(core.int)),
    [_offset]: dart.finalFieldType(core.int),
    [_length]: dart.finalFieldType(core.int)
  }));
  dart.defineExtensionAccessors(list_range.ListRange, ['iterator', 'length']);
  list_range.ListRangeIterator = class ListRangeIterator extends core.Object {};
  (list_range.ListRangeIterator.new = function() {
    ;
  }).prototype = list_range.ListRangeIterator.prototype;
  dart.addTypeTests(list_range.ListRangeIterator);
  list_range.ListRangeIterator[dart.implements] = () => [core.Iterator$(core.int)];
  dart.setLibraryUri(list_range.ListRangeIterator, "package:utf/src/list_range.dart");
  const _end$ = dart.privateName(list_range, "_end");
  list_range._ListRangeIteratorImpl = class _ListRangeIteratorImpl extends core.Object {
    get current() {
      return this[_source$][$_get](this[_offset]);
    }
    moveNext() {
      return (this[_offset] = dart.notNull(this[_offset]) + 1) < dart.notNull(this[_end$]);
    }
    get position() {
      return this[_offset];
    }
    backup(by = 1) {
      this[_offset] = dart.notNull(this[_offset]) - dart.notNull(by);
    }
    get remaining() {
      return dart.notNull(this[_end$]) - dart.notNull(this[_offset]) - 1;
    }
    skip(count = 1) {
      this[_offset] = dart.notNull(this[_offset]) + dart.notNull(count);
    }
  };
  (list_range._ListRangeIteratorImpl.new = function(_source, offset, _end) {
    this[_source$] = _source;
    this[_end$] = _end;
    this[_offset] = dart.notNull(offset) - 1;
    ;
  }).prototype = list_range._ListRangeIteratorImpl.prototype;
  dart.addTypeTests(list_range._ListRangeIteratorImpl);
  list_range._ListRangeIteratorImpl[dart.implements] = () => [list_range.ListRangeIterator];
  dart.setMethodSignature(list_range._ListRangeIteratorImpl, () => ({
    __proto__: dart.getMethods(list_range._ListRangeIteratorImpl.__proto__),
    moveNext: dart.fnType(core.bool, []),
    backup: dart.fnType(dart.void, [], [core.int]),
    skip: dart.fnType(dart.void, [], [core.int])
  }));
  dart.setGetterSignature(list_range._ListRangeIteratorImpl, () => ({
    __proto__: dart.getGetters(list_range._ListRangeIteratorImpl.__proto__),
    current: core.int,
    position: core.int,
    remaining: core.int
  }));
  dart.setLibraryUri(list_range._ListRangeIteratorImpl, "package:utf/src/list_range.dart");
  dart.setFieldSignature(list_range._ListRangeIteratorImpl, () => ({
    __proto__: dart.getFields(list_range._ListRangeIteratorImpl.__proto__),
    [_source$]: dart.finalFieldType(core.List$(core.int)),
    [_offset]: dart.fieldType(core.int),
    [_end$]: dart.finalFieldType(core.int)
  }));
  shared.stringToCodepoints = function stringToCodepoints(str) {
    return util.utf16CodeUnitsToCodepoints(str[$codeUnits]);
  };
  util.utf16CodeUnitsToCodepoints = function utf16CodeUnitsToCodepoints(utf16CodeUnits, offset = 0, length = null, replacementCodepoint = 65533) {
    let t0;
    let source = new list_range.ListRange.new(utf16CodeUnits, offset, length).iterator;
    let decoder = new utf_16_code_unit_decoder.Utf16CodeUnitDecoder.fromListRangeIterator(source, replacementCodepoint);
    let codepoints = ListOfint().new(source.remaining);
    let i = 0;
    while (dart.test(decoder.moveNext())) {
      codepoints[$_set]((t0 = i, i = t0 + 1, t0), decoder.current);
    }
    if (i === codepoints[$length]) {
      return codepoints;
    } else {
      let codepointTrunc = ListOfint().new(i);
      codepointTrunc[$setRange](0, i, codepoints);
      return codepointTrunc;
    }
  };
  util.codepointsToUtf16CodeUnits = function codepointsToUtf16CodeUnits(codepoints, offset = 0, length = null, replacementCodepoint = 65533) {
    let t0, t0$, t0$0, t0$1;
    let listRange = new list_range.ListRange.new(codepoints, offset, length);
    let encodedLength = 0;
    for (let value of listRange) {
      if (dart.notNull(value) >= 0 && dart.notNull(value) < 55296 || dart.notNull(value) > 57343 && dart.notNull(value) <= 65535) {
        encodedLength = encodedLength + 1;
      } else if (dart.notNull(value) > 65535 && dart.notNull(value) <= 1114111) {
        encodedLength = encodedLength + 2;
      } else {
        encodedLength = encodedLength + 1;
      }
    }
    let codeUnitsBuffer = ListOfint().new(encodedLength);
    let j = 0;
    for (let value of listRange) {
      if (dart.notNull(value) >= 0 && dart.notNull(value) < 55296 || dart.notNull(value) > 57343 && dart.notNull(value) <= 65535) {
        codeUnitsBuffer[$_set]((t0 = j, j = t0 + 1, t0), value);
      } else if (dart.notNull(value) > 65535 && dart.notNull(value) <= 1114111) {
        let base = dart.notNull(value) - 65536;
        codeUnitsBuffer[$_set]((t0$ = j, j = t0$ + 1, t0$), 55296 + ((base & 1047552) >>> 10));
        codeUnitsBuffer[$_set]((t0$0 = j, j = t0$0 + 1, t0$0), 56320 + ((base & 1023) >>> 0));
      } else if (replacementCodepoint != null) {
        codeUnitsBuffer[$_set]((t0$1 = j, j = t0$1 + 1, t0$1), replacementCodepoint);
      } else {
        dart.throw(new core.ArgumentError.new("Invalid encoding"));
      }
    }
    return codeUnitsBuffer;
  };
  const _current = dart.privateName(utf_16_code_unit_decoder, "_current");
  const utf16CodeUnitIterator$ = dart.privateName(utf_16_code_unit_decoder, "Utf16CodeUnitDecoder.utf16CodeUnitIterator");
  const replacementCodepoint$ = dart.privateName(utf_16_code_unit_decoder, "Utf16CodeUnitDecoder.replacementCodepoint");
  utf_16_code_unit_decoder.Utf16CodeUnitDecoder = class Utf16CodeUnitDecoder extends core.Object {
    get utf16CodeUnitIterator() {
      return this[utf16CodeUnitIterator$];
    }
    set utf16CodeUnitIterator(value) {
      super.utf16CodeUnitIterator = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    get iterator() {
      return this;
    }
    get current() {
      return this[_current];
    }
    moveNext() {
      this[_current] = null;
      if (!dart.test(this.utf16CodeUnitIterator.moveNext())) return false;
      let value = this.utf16CodeUnitIterator.current;
      if (dart.notNull(value) < 0) {
        if (this.replacementCodepoint != null) {
          this[_current] = this.replacementCodepoint;
        } else {
          dart.throw(new core.ArgumentError.new("Invalid UTF16 at " + dart.str(this.utf16CodeUnitIterator.position)));
        }
      } else if (dart.notNull(value) < 55296 || dart.notNull(value) > 57343 && dart.notNull(value) <= 65535) {
        this[_current] = value;
      } else if (dart.notNull(value) < 56320 && dart.test(this.utf16CodeUnitIterator.moveNext())) {
        let nextValue = this.utf16CodeUnitIterator.current;
        if (dart.notNull(nextValue) >= 56320 && dart.notNull(nextValue) <= 57343) {
          value = dart.notNull(value) - 55296 << 10 >>> 0;
          value = dart.notNull(value) + (65536 + (dart.notNull(nextValue) - 56320));
          this[_current] = value;
        } else {
          if (dart.notNull(nextValue) >= 55296 && dart.notNull(nextValue) < 56320) {
            this.utf16CodeUnitIterator.backup();
          }
          if (this.replacementCodepoint != null) {
            this[_current] = this.replacementCodepoint;
          } else {
            dart.throw(new core.ArgumentError.new("Invalid UTF16 at " + dart.str(this.utf16CodeUnitIterator.position)));
          }
        }
      } else if (this.replacementCodepoint != null) {
        this[_current] = this.replacementCodepoint;
      } else {
        dart.throw(new core.ArgumentError.new("Invalid UTF16 at " + dart.str(this.utf16CodeUnitIterator.position)));
      }
      return true;
    }
  };
  (utf_16_code_unit_decoder.Utf16CodeUnitDecoder.new = function(utf16CodeUnits, offset = 0, length = null, replacementCodepoint = 65533) {
    this[_current] = null;
    this[replacementCodepoint$] = replacementCodepoint;
    this[utf16CodeUnitIterator$] = new list_range.ListRange.new(utf16CodeUnits, offset, length).iterator;
    ;
  }).prototype = utf_16_code_unit_decoder.Utf16CodeUnitDecoder.prototype;
  (utf_16_code_unit_decoder.Utf16CodeUnitDecoder.fromListRangeIterator = function(utf16CodeUnitIterator, replacementCodepoint) {
    this[_current] = null;
    this[utf16CodeUnitIterator$] = utf16CodeUnitIterator;
    this[replacementCodepoint$] = replacementCodepoint;
    ;
  }).prototype = utf_16_code_unit_decoder.Utf16CodeUnitDecoder.prototype;
  dart.addTypeTests(utf_16_code_unit_decoder.Utf16CodeUnitDecoder);
  utf_16_code_unit_decoder.Utf16CodeUnitDecoder[dart.implements] = () => [core.Iterator$(core.int)];
  dart.setMethodSignature(utf_16_code_unit_decoder.Utf16CodeUnitDecoder, () => ({
    __proto__: dart.getMethods(utf_16_code_unit_decoder.Utf16CodeUnitDecoder.__proto__),
    moveNext: dart.fnType(core.bool, [])
  }));
  dart.setGetterSignature(utf_16_code_unit_decoder.Utf16CodeUnitDecoder, () => ({
    __proto__: dart.getGetters(utf_16_code_unit_decoder.Utf16CodeUnitDecoder.__proto__),
    iterator: core.Iterator$(core.int),
    current: core.int
  }));
  dart.setLibraryUri(utf_16_code_unit_decoder.Utf16CodeUnitDecoder, "package:utf/src/utf_16_code_unit_decoder.dart");
  dart.setFieldSignature(utf_16_code_unit_decoder.Utf16CodeUnitDecoder, () => ({
    __proto__: dart.getFields(utf_16_code_unit_decoder.Utf16CodeUnitDecoder.__proto__),
    utf16CodeUnitIterator: dart.finalFieldType(list_range.ListRangeIterator),
    replacementCodepoint: dart.finalFieldType(core.int),
    [_current]: dart.fieldType(core.int)
  }));
  dart.defineLazy(constants, {
    /*constants.UNICODE_REPLACEMENT_CHARACTER_CODEPOINT*/get UNICODE_REPLACEMENT_CHARACTER_CODEPOINT() {
      return 65533;
    },
    /*constants.UNICODE_BOM*/get UNICODE_BOM() {
      return 65279;
    },
    /*constants.UNICODE_UTF_BOM_LO*/get UNICODE_UTF_BOM_LO() {
      return 255;
    },
    /*constants.UNICODE_UTF_BOM_HI*/get UNICODE_UTF_BOM_HI() {
      return 254;
    },
    /*constants.UNICODE_BYTE_ZERO_MASK*/get UNICODE_BYTE_ZERO_MASK() {
      return 255;
    },
    /*constants.UNICODE_BYTE_ONE_MASK*/get UNICODE_BYTE_ONE_MASK() {
      return 65280;
    },
    /*constants.UNICODE_VALID_RANGE_MAX*/get UNICODE_VALID_RANGE_MAX() {
      return 1114111;
    },
    /*constants.UNICODE_PLANE_ONE_MAX*/get UNICODE_PLANE_ONE_MAX() {
      return 65535;
    },
    /*constants.UNICODE_UTF16_RESERVED_LO*/get UNICODE_UTF16_RESERVED_LO() {
      return 55296;
    },
    /*constants.UNICODE_UTF16_RESERVED_HI*/get UNICODE_UTF16_RESERVED_HI() {
      return 57343;
    },
    /*constants.UNICODE_UTF16_OFFSET*/get UNICODE_UTF16_OFFSET() {
      return 65536;
    },
    /*constants.UNICODE_UTF16_SURROGATE_UNIT_0_BASE*/get UNICODE_UTF16_SURROGATE_UNIT_0_BASE() {
      return 55296;
    },
    /*constants.UNICODE_UTF16_SURROGATE_UNIT_1_BASE*/get UNICODE_UTF16_SURROGATE_UNIT_1_BASE() {
      return 56320;
    },
    /*constants.UNICODE_UTF16_HI_MASK*/get UNICODE_UTF16_HI_MASK() {
      return 1047552;
    },
    /*constants.UNICODE_UTF16_LO_MASK*/get UNICODE_UTF16_LO_MASK() {
      return 1023;
    }
  });
  const bytes$ = dart.privateName(utf8, "IterableUtf8Decoder.bytes");
  const offset$ = dart.privateName(utf8, "IterableUtf8Decoder.offset");
  const length$ = dart.privateName(utf8, "IterableUtf8Decoder.length");
  const replacementCodepoint$0 = dart.privateName(utf8, "IterableUtf8Decoder.replacementCodepoint");
  utf8.IterableUtf8Decoder = class IterableUtf8Decoder extends collection.IterableBase$(core.int) {
    get bytes() {
      return this[bytes$];
    }
    set bytes(value) {
      super.bytes = value;
    }
    get offset() {
      return this[offset$];
    }
    set offset(value) {
      super.offset = value;
    }
    get length() {
      return this[length$];
    }
    set length(value) {
      super.length = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$0];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    get iterator() {
      return new utf8.Utf8Decoder.new(this.bytes, this.offset, this.length, this.replacementCodepoint);
    }
  };
  (utf8.IterableUtf8Decoder.new = function(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    this[bytes$] = bytes;
    this[offset$] = offset;
    this[length$] = length;
    this[replacementCodepoint$0] = replacementCodepoint;
    utf8.IterableUtf8Decoder.__proto__.new.call(this);
    ;
  }).prototype = utf8.IterableUtf8Decoder.prototype;
  dart.addTypeTests(utf8.IterableUtf8Decoder);
  dart.setGetterSignature(utf8.IterableUtf8Decoder, () => ({
    __proto__: dart.getGetters(utf8.IterableUtf8Decoder.__proto__),
    iterator: utf8.Utf8Decoder,
    [$iterator]: utf8.Utf8Decoder
  }));
  dart.setLibraryUri(utf8.IterableUtf8Decoder, "package:utf/src/utf8.dart");
  dart.setFieldSignature(utf8.IterableUtf8Decoder, () => ({
    __proto__: dart.getFields(utf8.IterableUtf8Decoder.__proto__),
    bytes: dart.finalFieldType(core.List$(core.int)),
    offset: dart.finalFieldType(core.int),
    length: dart.finalFieldType(core.int),
    replacementCodepoint: dart.finalFieldType(core.int)
  }));
  dart.defineExtensionAccessors(utf8.IterableUtf8Decoder, ['length', 'iterator']);
  const _current$ = dart.privateName(utf8, "_current");
  const utf8EncodedBytesIterator = dart.privateName(utf8, "Utf8Decoder.utf8EncodedBytesIterator");
  const replacementCodepoint$1 = dart.privateName(utf8, "Utf8Decoder.replacementCodepoint");
  utf8.Utf8Decoder = class Utf8Decoder extends core.Object {
    get utf8EncodedBytesIterator() {
      return this[utf8EncodedBytesIterator];
    }
    set utf8EncodedBytesIterator(value) {
      super.utf8EncodedBytesIterator = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$1];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    decodeRest() {
      let t0;
      let codepoints = ListOfint().new(this.utf8EncodedBytesIterator.remaining);
      let i = 0;
      while (dart.test(this.moveNext())) {
        codepoints[$_set]((t0 = i, i = t0 + 1, t0), this.current);
      }
      if (i === codepoints[$length]) {
        return codepoints;
      } else {
        let truncCodepoints = ListOfint().new(i);
        truncCodepoints[$setRange](0, i, codepoints);
        return truncCodepoints;
      }
    }
    get current() {
      return this[_current$];
    }
    moveNext() {
      this[_current$] = null;
      if (!dart.test(this.utf8EncodedBytesIterator.moveNext())) return false;
      let value = this.utf8EncodedBytesIterator.current;
      let additionalBytes = 0;
      if (dart.notNull(value) < 0) {
        if (this.replacementCodepoint != null) {
          this[_current$] = this.replacementCodepoint;
          return true;
        } else {
          dart.throw(new core.ArgumentError.new("Invalid UTF8 at " + dart.str(this.utf8EncodedBytesIterator.position)));
        }
      } else if (dart.notNull(value) <= 127) {
        this[_current$] = value;
        return true;
      } else if (dart.notNull(value) < 192) {
        if (this.replacementCodepoint != null) {
          this[_current$] = this.replacementCodepoint;
          return true;
        } else {
          dart.throw(new core.ArgumentError.new("Invalid UTF8 at " + dart.str(this.utf8EncodedBytesIterator.position)));
        }
      } else if (dart.notNull(value) < 224) {
        value = dart.notNull(value) - 192;
        additionalBytes = 1;
      } else if (dart.notNull(value) < 240) {
        value = dart.notNull(value) - 224;
        additionalBytes = 2;
      } else if (dart.notNull(value) < 248) {
        value = dart.notNull(value) - 240;
        additionalBytes = 3;
      } else if (dart.notNull(value) < 252) {
        value = dart.notNull(value) - 248;
        additionalBytes = 4;
      } else if (dart.notNull(value) < 254) {
        value = dart.notNull(value) - 252;
        additionalBytes = 5;
      } else if (this.replacementCodepoint != null) {
        this[_current$] = this.replacementCodepoint;
        return true;
      } else {
        dart.throw(new core.ArgumentError.new("Invalid UTF8 at " + dart.str(this.utf8EncodedBytesIterator.position)));
      }
      let j = 0;
      while (j < additionalBytes && dart.test(this.utf8EncodedBytesIterator.moveNext())) {
        let nextValue = this.utf8EncodedBytesIterator.current;
        if (dart.notNull(nextValue) > 127 && dart.notNull(nextValue) < 192) {
          value = (dart.notNull(value) << 6 | (dart.notNull(nextValue) & 63) >>> 0) >>> 0;
        } else {
          if (dart.notNull(nextValue) >= 192) {
            this.utf8EncodedBytesIterator.backup();
          }
          break;
        }
        j = j + 1;
      }
      let validSequence = j === additionalBytes && (dart.notNull(value) < 55296 || dart.notNull(value) > 57343);
      let nonOverlong = additionalBytes === 1 && dart.notNull(value) > 127 || additionalBytes === 2 && dart.notNull(value) > 2047 || additionalBytes === 3 && dart.notNull(value) > 65535;
      let inRange = dart.notNull(value) <= 1114111;
      if (validSequence && nonOverlong && inRange) {
        this[_current$] = value;
        return true;
      } else if (this.replacementCodepoint != null) {
        this[_current$] = this.replacementCodepoint;
        return true;
      } else {
        dart.throw(new core.ArgumentError.new("Invalid UTF8 at " + dart.str(dart.notNull(this.utf8EncodedBytesIterator.position) - j)));
      }
    }
  };
  (utf8.Utf8Decoder.new = function(utf8EncodedBytes, offset = 0, length = null, replacementCodepoint = 65533) {
    this[_current$] = null;
    this[replacementCodepoint$1] = replacementCodepoint;
    this[utf8EncodedBytesIterator] = new list_range.ListRange.new(utf8EncodedBytes, offset, length).iterator;
    ;
  }).prototype = utf8.Utf8Decoder.prototype;
  (utf8.Utf8Decoder._fromListRangeIterator = function(source, replacementCodepoint = 65533) {
    this[_current$] = null;
    this[replacementCodepoint$1] = replacementCodepoint;
    this[utf8EncodedBytesIterator] = source.iterator;
    ;
  }).prototype = utf8.Utf8Decoder.prototype;
  dart.addTypeTests(utf8.Utf8Decoder);
  utf8.Utf8Decoder[dart.implements] = () => [core.Iterator$(core.int)];
  dart.setMethodSignature(utf8.Utf8Decoder, () => ({
    __proto__: dart.getMethods(utf8.Utf8Decoder.__proto__),
    decodeRest: dart.fnType(core.List$(core.int), []),
    moveNext: dart.fnType(core.bool, [])
  }));
  dart.setGetterSignature(utf8.Utf8Decoder, () => ({
    __proto__: dart.getGetters(utf8.Utf8Decoder.__proto__),
    current: core.int
  }));
  dart.setLibraryUri(utf8.Utf8Decoder, "package:utf/src/utf8.dart");
  dart.setFieldSignature(utf8.Utf8Decoder, () => ({
    __proto__: dart.getFields(utf8.Utf8Decoder.__proto__),
    utf8EncodedBytesIterator: dart.finalFieldType(list_range.ListRangeIterator),
    replacementCodepoint: dart.finalFieldType(core.int),
    [_current$]: dart.fieldType(core.int)
  }));
  utf8.decodeUtf8AsIterable = function decodeUtf8AsIterable(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return new utf8.IterableUtf8Decoder.new(bytes, offset, length, replacementCodepoint);
  };
  utf8.decodeUtf8 = function decodeUtf8(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return core.String.fromCharCodes(new utf8.Utf8Decoder.new(bytes, offset, length, replacementCodepoint).decodeRest());
  };
  utf8.encodeUtf8 = function encodeUtf8(str) {
    return utf8.codepointsToUtf8(shared.stringToCodepoints(str));
  };
  utf8._addToEncoding = function _addToEncoding(offset, bytes, value, buffer) {
    while (dart.notNull(bytes) > 0) {
      buffer[$_set](dart.notNull(offset) + dart.notNull(bytes), (128 | (dart.notNull(value) & 63) >>> 0) >>> 0);
      value = value[$rightShift](6);
      bytes = dart.notNull(bytes) - 1;
    }
    return value;
  };
  utf8.codepointsToUtf8 = function codepointsToUtf8(codepoints, offset = 0, length = null) {
    let source = new list_range.ListRange.new(codepoints, offset, length);
    let encodedLength = 0;
    for (let value of source) {
      if (dart.notNull(value) < 0 || dart.notNull(value) > 1114111) {
        encodedLength = encodedLength + 3;
      } else if (dart.notNull(value) <= 127) {
        encodedLength = encodedLength + 1;
      } else if (dart.notNull(value) <= 2047) {
        encodedLength = encodedLength + 2;
      } else if (dart.notNull(value) <= 65535) {
        encodedLength = encodedLength + 3;
      } else if (dart.notNull(value) <= 1114111) {
        encodedLength = encodedLength + 4;
      }
    }
    let encoded = ListOfint().new(encodedLength);
    let insertAt = 0;
    for (let value of source) {
      if (dart.notNull(value) < 0 || dart.notNull(value) > 1114111) {
        encoded[$setRange](insertAt, insertAt + 3, JSArrayOfint().of([239, 191, 189]));
        insertAt = insertAt + 3;
      } else if (dart.notNull(value) <= 127) {
        encoded[$_set](insertAt, value);
        insertAt = insertAt + 1;
      } else if (dart.notNull(value) <= 2047) {
        encoded[$_set](insertAt, (192 | (31 & dart.notNull(utf8._addToEncoding(insertAt, 1, value, encoded))) >>> 0) >>> 0);
        insertAt = insertAt + 2;
      } else if (dart.notNull(value) <= 65535) {
        encoded[$_set](insertAt, (224 | (15 & dart.notNull(utf8._addToEncoding(insertAt, 2, value, encoded))) >>> 0) >>> 0);
        insertAt = insertAt + 3;
      } else if (dart.notNull(value) <= 1114111) {
        encoded[$_set](insertAt, (240 | (7 & dart.notNull(utf8._addToEncoding(insertAt, 3, value, encoded))) >>> 0) >>> 0);
        insertAt = insertAt + 4;
      }
    }
    return encoded;
  };
  utf8.utf8ToCodepoints = function utf8ToCodepoints(utf8EncodedBytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return new utf8.Utf8Decoder.new(utf8EncodedBytes, offset, length, replacementCodepoint).decodeRest();
  };
  dart.defineLazy(utf8, {
    /*utf8._UTF8_ONE_BYTE_MAX*/get _UTF8_ONE_BYTE_MAX() {
      return 127;
    },
    /*utf8._UTF8_TWO_BYTE_MAX*/get _UTF8_TWO_BYTE_MAX() {
      return 2047;
    },
    /*utf8._UTF8_THREE_BYTE_MAX*/get _UTF8_THREE_BYTE_MAX() {
      return 65535;
    },
    /*utf8._UTF8_LO_SIX_BIT_MASK*/get _UTF8_LO_SIX_BIT_MASK() {
      return 63;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_TWO_BASE*/get _UTF8_FIRST_BYTE_OF_TWO_BASE() {
      return 192;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_THREE_BASE*/get _UTF8_FIRST_BYTE_OF_THREE_BASE() {
      return 224;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_FOUR_BASE*/get _UTF8_FIRST_BYTE_OF_FOUR_BASE() {
      return 240;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_FIVE_BASE*/get _UTF8_FIRST_BYTE_OF_FIVE_BASE() {
      return 248;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_SIX_BASE*/get _UTF8_FIRST_BYTE_OF_SIX_BASE() {
      return 252;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_TWO_MASK*/get _UTF8_FIRST_BYTE_OF_TWO_MASK() {
      return 31;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_THREE_MASK*/get _UTF8_FIRST_BYTE_OF_THREE_MASK() {
      return 15;
    },
    /*utf8._UTF8_FIRST_BYTE_OF_FOUR_MASK*/get _UTF8_FIRST_BYTE_OF_FOUR_MASK() {
      return 7;
    },
    /*utf8._UTF8_FIRST_BYTE_BOUND_EXCL*/get _UTF8_FIRST_BYTE_BOUND_EXCL() {
      return 254;
    },
    /*utf8._UTF8_SUBSEQUENT_BYTE_BASE*/get _UTF8_SUBSEQUENT_BYTE_BASE() {
      return 128;
    }
  });
  const codeunitsProvider$ = dart.privateName(utf16, "IterableUtf16Decoder.codeunitsProvider");
  const replacementCodepoint$2 = dart.privateName(utf16, "IterableUtf16Decoder.replacementCodepoint");
  utf16.IterableUtf16Decoder = class IterableUtf16Decoder extends collection.IterableBase$(core.int) {
    get codeunitsProvider() {
      return this[codeunitsProvider$];
    }
    set codeunitsProvider(value) {
      super.codeunitsProvider = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$2];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    get iterator() {
      return new utf_16_code_unit_decoder.Utf16CodeUnitDecoder.fromListRangeIterator(this.codeunitsProvider(), this.replacementCodepoint);
    }
  };
  (utf16.IterableUtf16Decoder.__ = function(codeunitsProvider, replacementCodepoint) {
    this[codeunitsProvider$] = codeunitsProvider;
    this[replacementCodepoint$2] = replacementCodepoint;
    utf16.IterableUtf16Decoder.__proto__.new.call(this);
    ;
  }).prototype = utf16.IterableUtf16Decoder.prototype;
  dart.addTypeTests(utf16.IterableUtf16Decoder);
  dart.setGetterSignature(utf16.IterableUtf16Decoder, () => ({
    __proto__: dart.getGetters(utf16.IterableUtf16Decoder.__proto__),
    iterator: utf_16_code_unit_decoder.Utf16CodeUnitDecoder,
    [$iterator]: utf_16_code_unit_decoder.Utf16CodeUnitDecoder
  }));
  dart.setLibraryUri(utf16.IterableUtf16Decoder, "package:utf/src/utf16.dart");
  dart.setFieldSignature(utf16.IterableUtf16Decoder, () => ({
    __proto__: dart.getFields(utf16.IterableUtf16Decoder.__proto__),
    codeunitsProvider: dart.finalFieldType(dart.fnType(list_range.ListRangeIterator, [])),
    replacementCodepoint: dart.finalFieldType(core.int)
  }));
  dart.defineExtensionAccessors(utf16.IterableUtf16Decoder, ['iterator']);
  const _current$0 = dart.privateName(utf16, "_current");
  const utf16EncodedBytesIterator$ = dart.privateName(utf16, "Utf16BytesToCodeUnitsDecoder.utf16EncodedBytesIterator");
  const replacementCodepoint$3 = dart.privateName(utf16, "Utf16BytesToCodeUnitsDecoder.replacementCodepoint");
  utf16.Utf16BytesToCodeUnitsDecoder = class Utf16BytesToCodeUnitsDecoder extends core.Object {
    get utf16EncodedBytesIterator() {
      return this[utf16EncodedBytesIterator$];
    }
    set utf16EncodedBytesIterator(value) {
      super.utf16EncodedBytesIterator = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$3];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    static new(utf16EncodedBytes, offset = 0, length = null, replacementCodepoint = 65533) {
      if (length == null) {
        length = dart.notNull(utf16EncodedBytes[$length]) - dart.notNull(offset);
      }
      if (dart.test(utf16.hasUtf16beBom(utf16EncodedBytes, offset, length))) {
        return new utf16.Utf16beBytesToCodeUnitsDecoder.new(utf16EncodedBytes, dart.notNull(offset) + 2, dart.notNull(length) - 2, false, replacementCodepoint);
      } else if (dart.test(utf16.hasUtf16leBom(utf16EncodedBytes, offset, length))) {
        return new utf16.Utf16leBytesToCodeUnitsDecoder.new(utf16EncodedBytes, dart.notNull(offset) + 2, dart.notNull(length) - 2, false, replacementCodepoint);
      } else {
        return new utf16.Utf16beBytesToCodeUnitsDecoder.new(utf16EncodedBytes, offset, length, false, replacementCodepoint);
      }
    }
    decodeRest() {
      let t0;
      let codeunits = ListOfint().new(this.remaining);
      let i = 0;
      while (dart.test(this.moveNext())) {
        codeunits[$_set]((t0 = i, i = t0 + 1, t0), this.current);
      }
      if (i === codeunits[$length]) {
        return codeunits;
      } else {
        let truncCodeunits = ListOfint().new(i);
        truncCodeunits[$setRange](0, i, codeunits);
        return truncCodeunits;
      }
    }
    get current() {
      return this[_current$0];
    }
    moveNext() {
      this[_current$0] = null;
      let remaining = this.utf16EncodedBytesIterator.remaining;
      if (remaining === 0) {
        this[_current$0] = null;
        return false;
      }
      if (remaining === 1) {
        this.utf16EncodedBytesIterator.moveNext();
        if (this.replacementCodepoint != null) {
          this[_current$0] = this.replacementCodepoint;
          return true;
        } else {
          dart.throw(new core.ArgumentError.new("Invalid UTF16 at " + dart.str(this.utf16EncodedBytesIterator.position)));
        }
      }
      this[_current$0] = this.decode();
      return true;
    }
    get position() {
      return (dart.notNull(this.utf16EncodedBytesIterator.position) / 2)[$truncate]();
    }
    backup(by = 1) {
      this.utf16EncodedBytesIterator.backup(2 * dart.notNull(by));
    }
    get remaining() {
      return ((dart.notNull(this.utf16EncodedBytesIterator.remaining) + 1) / 2)[$truncate]();
    }
    skip(count = 1) {
      this.utf16EncodedBytesIterator.skip(2 * dart.notNull(count));
    }
  };
  (utf16.Utf16BytesToCodeUnitsDecoder._fromListRangeIterator = function(utf16EncodedBytesIterator, replacementCodepoint) {
    this[_current$0] = null;
    this[utf16EncodedBytesIterator$] = utf16EncodedBytesIterator;
    this[replacementCodepoint$3] = replacementCodepoint;
    ;
  }).prototype = utf16.Utf16BytesToCodeUnitsDecoder.prototype;
  dart.addTypeTests(utf16.Utf16BytesToCodeUnitsDecoder);
  utf16.Utf16BytesToCodeUnitsDecoder[dart.implements] = () => [list_range.ListRangeIterator];
  dart.setMethodSignature(utf16.Utf16BytesToCodeUnitsDecoder, () => ({
    __proto__: dart.getMethods(utf16.Utf16BytesToCodeUnitsDecoder.__proto__),
    decodeRest: dart.fnType(core.List$(core.int), []),
    moveNext: dart.fnType(core.bool, []),
    backup: dart.fnType(dart.void, [], [core.int]),
    skip: dart.fnType(dart.void, [], [core.int])
  }));
  dart.setGetterSignature(utf16.Utf16BytesToCodeUnitsDecoder, () => ({
    __proto__: dart.getGetters(utf16.Utf16BytesToCodeUnitsDecoder.__proto__),
    current: core.int,
    position: core.int,
    remaining: core.int
  }));
  dart.setLibraryUri(utf16.Utf16BytesToCodeUnitsDecoder, "package:utf/src/utf16.dart");
  dart.setFieldSignature(utf16.Utf16BytesToCodeUnitsDecoder, () => ({
    __proto__: dart.getFields(utf16.Utf16BytesToCodeUnitsDecoder.__proto__),
    utf16EncodedBytesIterator: dart.finalFieldType(list_range.ListRangeIterator),
    replacementCodepoint: dart.finalFieldType(core.int),
    [_current$0]: dart.fieldType(core.int)
  }));
  utf16.Utf16beBytesToCodeUnitsDecoder = class Utf16beBytesToCodeUnitsDecoder extends utf16.Utf16BytesToCodeUnitsDecoder {
    decode() {
      this.utf16EncodedBytesIterator.moveNext();
      let hi = this.utf16EncodedBytesIterator.current;
      this.utf16EncodedBytesIterator.moveNext();
      let lo = this.utf16EncodedBytesIterator.current;
      return (dart.notNull(hi) << 8 >>> 0) + dart.notNull(lo);
    }
  };
  (utf16.Utf16beBytesToCodeUnitsDecoder.new = function(utf16EncodedBytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    utf16.Utf16beBytesToCodeUnitsDecoder.__proto__._fromListRangeIterator.call(this, new list_range.ListRange.new(utf16EncodedBytes, offset, length).iterator, replacementCodepoint);
    if (dart.test(stripBom) && dart.test(utf16.hasUtf16beBom(utf16EncodedBytes, offset, length))) {
      this.skip();
    }
  }).prototype = utf16.Utf16beBytesToCodeUnitsDecoder.prototype;
  dart.addTypeTests(utf16.Utf16beBytesToCodeUnitsDecoder);
  dart.setMethodSignature(utf16.Utf16beBytesToCodeUnitsDecoder, () => ({
    __proto__: dart.getMethods(utf16.Utf16beBytesToCodeUnitsDecoder.__proto__),
    decode: dart.fnType(core.int, [])
  }));
  dart.setLibraryUri(utf16.Utf16beBytesToCodeUnitsDecoder, "package:utf/src/utf16.dart");
  utf16.Utf16leBytesToCodeUnitsDecoder = class Utf16leBytesToCodeUnitsDecoder extends utf16.Utf16BytesToCodeUnitsDecoder {
    decode() {
      this.utf16EncodedBytesIterator.moveNext();
      let lo = this.utf16EncodedBytesIterator.current;
      this.utf16EncodedBytesIterator.moveNext();
      let hi = this.utf16EncodedBytesIterator.current;
      return (dart.notNull(hi) << 8 >>> 0) + dart.notNull(lo);
    }
  };
  (utf16.Utf16leBytesToCodeUnitsDecoder.new = function(utf16EncodedBytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    utf16.Utf16leBytesToCodeUnitsDecoder.__proto__._fromListRangeIterator.call(this, new list_range.ListRange.new(utf16EncodedBytes, offset, length).iterator, replacementCodepoint);
    if (dart.test(stripBom) && dart.test(utf16.hasUtf16leBom(utf16EncodedBytes, offset, length))) {
      this.skip();
    }
  }).prototype = utf16.Utf16leBytesToCodeUnitsDecoder.prototype;
  dart.addTypeTests(utf16.Utf16leBytesToCodeUnitsDecoder);
  dart.setMethodSignature(utf16.Utf16leBytesToCodeUnitsDecoder, () => ({
    __proto__: dart.getMethods(utf16.Utf16leBytesToCodeUnitsDecoder.__proto__),
    decode: dart.fnType(core.int, [])
  }));
  dart.setLibraryUri(utf16.Utf16leBytesToCodeUnitsDecoder, "package:utf/src/utf16.dart");
  utf16.codepointsToString = function codepointsToString(codepoints) {
    return core.String.fromCharCodes(codepoints);
  };
  utf16.decodeUtf16AsIterable = function decodeUtf16AsIterable(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return new utf16.IterableUtf16Decoder.__(dart.fn(() => utf16.Utf16BytesToCodeUnitsDecoder.new(bytes, offset, length, replacementCodepoint), VoidToUtf16BytesToCodeUnitsDecoder()), replacementCodepoint);
  };
  utf16.decodeUtf16beAsIterable = function decodeUtf16beAsIterable(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return new utf16.IterableUtf16Decoder.__(dart.fn(() => new utf16.Utf16beBytesToCodeUnitsDecoder.new(bytes, offset, length, stripBom, replacementCodepoint), VoidToUtf16beBytesToCodeUnitsDecoder()), replacementCodepoint);
  };
  utf16.decodeUtf16leAsIterable = function decodeUtf16leAsIterable(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return new utf16.IterableUtf16Decoder.__(dart.fn(() => new utf16.Utf16leBytesToCodeUnitsDecoder.new(bytes, offset, length, stripBom, replacementCodepoint), VoidToUtf16leBytesToCodeUnitsDecoder()), replacementCodepoint);
  };
  utf16.decodeUtf16 = function decodeUtf16(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    let decoder = utf16.Utf16BytesToCodeUnitsDecoder.new(bytes, offset, length, replacementCodepoint);
    let codeunits = decoder.decodeRest();
    return core.String.fromCharCodes(util.utf16CodeUnitsToCodepoints(codeunits, 0, null, replacementCodepoint));
  };
  utf16.decodeUtf16be = function decodeUtf16be(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    let codeunits = new utf16.Utf16beBytesToCodeUnitsDecoder.new(bytes, offset, length, stripBom, replacementCodepoint).decodeRest();
    return core.String.fromCharCodes(util.utf16CodeUnitsToCodepoints(codeunits, 0, null, replacementCodepoint));
  };
  utf16.decodeUtf16le = function decodeUtf16le(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    let codeunits = new utf16.Utf16leBytesToCodeUnitsDecoder.new(bytes, offset, length, stripBom, replacementCodepoint).decodeRest();
    return core.String.fromCharCodes(util.utf16CodeUnitsToCodepoints(codeunits, 0, null, replacementCodepoint));
  };
  utf16.encodeUtf16 = function encodeUtf16(str) {
    return utf16.encodeUtf16be(str, true);
  };
  utf16.encodeUtf16be = function encodeUtf16be(str, writeBOM = false) {
    let t0, t0$, t0$0, t0$1;
    let utf16CodeUnits = utf16._stringToUtf16CodeUnits(str);
    let encoding = ListOfint().new(2 * dart.notNull(utf16CodeUnits[$length]) + (dart.test(writeBOM) ? 2 : 0));
    let i = 0;
    if (dart.test(writeBOM)) {
      encoding[$_set]((t0 = i, i = t0 + 1, t0), 254);
      encoding[$_set]((t0$ = i, i = t0$ + 1, t0$), 255);
    }
    for (let unit of utf16CodeUnits) {
      encoding[$_set]((t0$0 = i, i = t0$0 + 1, t0$0), (dart.notNull(unit) & 65280) >>> 8);
      encoding[$_set]((t0$1 = i, i = t0$1 + 1, t0$1), (dart.notNull(unit) & 255) >>> 0);
    }
    return encoding;
  };
  utf16.encodeUtf16le = function encodeUtf16le(str, writeBOM = false) {
    let t0, t0$, t0$0, t0$1;
    let utf16CodeUnits = utf16._stringToUtf16CodeUnits(str);
    let encoding = ListOfint().new(2 * dart.notNull(utf16CodeUnits[$length]) + (dart.test(writeBOM) ? 2 : 0));
    let i = 0;
    if (dart.test(writeBOM)) {
      encoding[$_set]((t0 = i, i = t0 + 1, t0), 255);
      encoding[$_set]((t0$ = i, i = t0$ + 1, t0$), 254);
    }
    for (let unit of utf16CodeUnits) {
      encoding[$_set]((t0$0 = i, i = t0$0 + 1, t0$0), (dart.notNull(unit) & 255) >>> 0);
      encoding[$_set]((t0$1 = i, i = t0$1 + 1, t0$1), (dart.notNull(unit) & 65280) >>> 8);
    }
    return encoding;
  };
  utf16.hasUtf16Bom = function hasUtf16Bom(utf32EncodedBytes, offset = 0, length = null) {
    return dart.test(utf16.hasUtf16beBom(utf32EncodedBytes, offset, length)) || dart.test(utf16.hasUtf16leBom(utf32EncodedBytes, offset, length));
  };
  utf16.hasUtf16beBom = function hasUtf16beBom(utf16EncodedBytes, offset = 0, length = null) {
    let end = length != null ? dart.notNull(offset) + dart.notNull(length) : utf16EncodedBytes[$length];
    return dart.notNull(offset) + 2 <= dart.notNull(end) && utf16EncodedBytes[$_get](offset) === 254 && utf16EncodedBytes[$_get](dart.notNull(offset) + 1) === 255;
  };
  utf16.hasUtf16leBom = function hasUtf16leBom(utf16EncodedBytes, offset = 0, length = null) {
    let end = length != null ? dart.notNull(offset) + dart.notNull(length) : utf16EncodedBytes[$length];
    return dart.notNull(offset) + 2 <= dart.notNull(end) && utf16EncodedBytes[$_get](offset) === 255 && utf16EncodedBytes[$_get](dart.notNull(offset) + 1) === 254;
  };
  utf16._stringToUtf16CodeUnits = function _stringToUtf16CodeUnits(str) {
    return util.codepointsToUtf16CodeUnits(str[$codeUnits]);
  };
  const codeunitsProvider$0 = dart.privateName(utf32, "IterableUtf32Decoder.codeunitsProvider");
  utf32.IterableUtf32Decoder = class IterableUtf32Decoder extends collection.IterableBase$(core.int) {
    get codeunitsProvider() {
      return this[codeunitsProvider$0];
    }
    set codeunitsProvider(value) {
      super.codeunitsProvider = value;
    }
    get iterator() {
      return this.codeunitsProvider();
    }
  };
  (utf32.IterableUtf32Decoder.__ = function(codeunitsProvider) {
    this[codeunitsProvider$0] = codeunitsProvider;
    utf32.IterableUtf32Decoder.__proto__.new.call(this);
    ;
  }).prototype = utf32.IterableUtf32Decoder.prototype;
  dart.addTypeTests(utf32.IterableUtf32Decoder);
  dart.setGetterSignature(utf32.IterableUtf32Decoder, () => ({
    __proto__: dart.getGetters(utf32.IterableUtf32Decoder.__proto__),
    iterator: utf32.Utf32BytesDecoder,
    [$iterator]: utf32.Utf32BytesDecoder
  }));
  dart.setLibraryUri(utf32.IterableUtf32Decoder, "package:utf/src/utf32.dart");
  dart.setFieldSignature(utf32.IterableUtf32Decoder, () => ({
    __proto__: dart.getFields(utf32.IterableUtf32Decoder.__proto__),
    codeunitsProvider: dart.finalFieldType(dart.fnType(utf32.Utf32BytesDecoder, []))
  }));
  dart.defineExtensionAccessors(utf32.IterableUtf32Decoder, ['iterator']);
  const _current$1 = dart.privateName(utf32, "_current");
  const utf32EncodedBytesIterator$ = dart.privateName(utf32, "Utf32BytesDecoder.utf32EncodedBytesIterator");
  const replacementCodepoint$4 = dart.privateName(utf32, "Utf32BytesDecoder.replacementCodepoint");
  utf32.Utf32BytesDecoder = class Utf32BytesDecoder extends core.Object {
    get utf32EncodedBytesIterator() {
      return this[utf32EncodedBytesIterator$];
    }
    set utf32EncodedBytesIterator(value) {
      super.utf32EncodedBytesIterator = value;
    }
    get replacementCodepoint() {
      return this[replacementCodepoint$4];
    }
    set replacementCodepoint(value) {
      super.replacementCodepoint = value;
    }
    static new(utf32EncodedBytes, offset = 0, length = null, replacementCodepoint = 65533) {
      if (length == null) {
        length = dart.notNull(utf32EncodedBytes[$length]) - dart.notNull(offset);
      }
      if (dart.test(utf32.hasUtf32beBom(utf32EncodedBytes, offset, length))) {
        return new utf32.Utf32beBytesDecoder.new(utf32EncodedBytes, dart.notNull(offset) + 4, dart.notNull(length) - 4, false, replacementCodepoint);
      } else if (dart.test(utf32.hasUtf32leBom(utf32EncodedBytes, offset, length))) {
        return new utf32.Utf32leBytesDecoder.new(utf32EncodedBytes, dart.notNull(offset) + 4, dart.notNull(length) - 4, false, replacementCodepoint);
      } else {
        return new utf32.Utf32beBytesDecoder.new(utf32EncodedBytes, offset, length, false, replacementCodepoint);
      }
    }
    decodeRest() {
      let t0;
      let codeunits = ListOfint().new(this.remaining);
      let i = 0;
      while (dart.test(this.moveNext())) {
        codeunits[$_set]((t0 = i, i = t0 + 1, t0), this.current);
      }
      return codeunits;
    }
    get current() {
      return this[_current$1];
    }
    moveNext() {
      this[_current$1] = null;
      let remaining = this.utf32EncodedBytesIterator.remaining;
      if (remaining === 0) {
        this[_current$1] = null;
        return false;
      }
      if (dart.notNull(remaining) < 4) {
        this.utf32EncodedBytesIterator.skip(this.utf32EncodedBytesIterator.remaining);
        if (this.replacementCodepoint != null) {
          this[_current$1] = this.replacementCodepoint;
          return true;
        } else {
          dart.throw(new core.ArgumentError.new("Invalid UTF32 at " + dart.str(this.utf32EncodedBytesIterator.position)));
        }
      }
      let codepoint = this.decode();
      if (dart.test(utf32._validCodepoint(codepoint))) {
        this[_current$1] = codepoint;
        return true;
      } else if (this.replacementCodepoint != null) {
        this[_current$1] = this.replacementCodepoint;
        return true;
      } else {
        dart.throw(new core.ArgumentError.new("Invalid UTF32 at " + dart.str(this.utf32EncodedBytesIterator.position)));
      }
    }
    get position() {
      return (dart.notNull(this.utf32EncodedBytesIterator.position) / 4)[$truncate]();
    }
    backup(by = 1) {
      this.utf32EncodedBytesIterator.backup(4 * dart.notNull(by));
    }
    get remaining() {
      return ((dart.notNull(this.utf32EncodedBytesIterator.remaining) + 3) / 4)[$truncate]();
    }
    skip(count = 1) {
      this.utf32EncodedBytesIterator.skip(4 * dart.notNull(count));
    }
  };
  (utf32.Utf32BytesDecoder._fromListRangeIterator = function(utf32EncodedBytesIterator, replacementCodepoint) {
    this[_current$1] = null;
    this[utf32EncodedBytesIterator$] = utf32EncodedBytesIterator;
    this[replacementCodepoint$4] = replacementCodepoint;
    ;
  }).prototype = utf32.Utf32BytesDecoder.prototype;
  dart.addTypeTests(utf32.Utf32BytesDecoder);
  utf32.Utf32BytesDecoder[dart.implements] = () => [list_range.ListRangeIterator];
  dart.setMethodSignature(utf32.Utf32BytesDecoder, () => ({
    __proto__: dart.getMethods(utf32.Utf32BytesDecoder.__proto__),
    decodeRest: dart.fnType(core.List$(core.int), []),
    moveNext: dart.fnType(core.bool, []),
    backup: dart.fnType(dart.void, [], [core.int]),
    skip: dart.fnType(dart.void, [], [core.int])
  }));
  dart.setGetterSignature(utf32.Utf32BytesDecoder, () => ({
    __proto__: dart.getGetters(utf32.Utf32BytesDecoder.__proto__),
    current: core.int,
    position: core.int,
    remaining: core.int
  }));
  dart.setLibraryUri(utf32.Utf32BytesDecoder, "package:utf/src/utf32.dart");
  dart.setFieldSignature(utf32.Utf32BytesDecoder, () => ({
    __proto__: dart.getFields(utf32.Utf32BytesDecoder.__proto__),
    utf32EncodedBytesIterator: dart.finalFieldType(list_range.ListRangeIterator),
    replacementCodepoint: dart.finalFieldType(core.int),
    [_current$1]: dart.fieldType(core.int)
  }));
  utf32.Utf32beBytesDecoder = class Utf32beBytesDecoder extends utf32.Utf32BytesDecoder {
    decode() {
      this.utf32EncodedBytesIterator.moveNext();
      let value = this.utf32EncodedBytesIterator.current;
      this.utf32EncodedBytesIterator.moveNext();
      value = (dart.notNull(value) << 8 >>> 0) + dart.notNull(this.utf32EncodedBytesIterator.current);
      this.utf32EncodedBytesIterator.moveNext();
      value = (dart.notNull(value) << 8 >>> 0) + dart.notNull(this.utf32EncodedBytesIterator.current);
      this.utf32EncodedBytesIterator.moveNext();
      value = (dart.notNull(value) << 8 >>> 0) + dart.notNull(this.utf32EncodedBytesIterator.current);
      return value;
    }
  };
  (utf32.Utf32beBytesDecoder.new = function(utf32EncodedBytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    utf32.Utf32beBytesDecoder.__proto__._fromListRangeIterator.call(this, new list_range.ListRange.new(utf32EncodedBytes, offset, length).iterator, replacementCodepoint);
    if (dart.test(stripBom) && dart.test(utf32.hasUtf32beBom(utf32EncodedBytes, offset, length))) {
      this.skip();
    }
  }).prototype = utf32.Utf32beBytesDecoder.prototype;
  dart.addTypeTests(utf32.Utf32beBytesDecoder);
  dart.setMethodSignature(utf32.Utf32beBytesDecoder, () => ({
    __proto__: dart.getMethods(utf32.Utf32beBytesDecoder.__proto__),
    decode: dart.fnType(core.int, [])
  }));
  dart.setLibraryUri(utf32.Utf32beBytesDecoder, "package:utf/src/utf32.dart");
  utf32.Utf32leBytesDecoder = class Utf32leBytesDecoder extends utf32.Utf32BytesDecoder {
    decode() {
      this.utf32EncodedBytesIterator.moveNext();
      let value = this.utf32EncodedBytesIterator.current;
      this.utf32EncodedBytesIterator.moveNext();
      value = dart.notNull(value) + (dart.notNull(this.utf32EncodedBytesIterator.current) << 8 >>> 0);
      this.utf32EncodedBytesIterator.moveNext();
      value = dart.notNull(value) + (dart.notNull(this.utf32EncodedBytesIterator.current) << 16 >>> 0);
      this.utf32EncodedBytesIterator.moveNext();
      value = dart.notNull(value) + (dart.notNull(this.utf32EncodedBytesIterator.current) << 24 >>> 0);
      return value;
    }
  };
  (utf32.Utf32leBytesDecoder.new = function(utf32EncodedBytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    utf32.Utf32leBytesDecoder.__proto__._fromListRangeIterator.call(this, new list_range.ListRange.new(utf32EncodedBytes, offset, length).iterator, replacementCodepoint);
    if (dart.test(stripBom) && dart.test(utf32.hasUtf32leBom(utf32EncodedBytes, offset, length))) {
      this.skip();
    }
  }).prototype = utf32.Utf32leBytesDecoder.prototype;
  dart.addTypeTests(utf32.Utf32leBytesDecoder);
  dart.setMethodSignature(utf32.Utf32leBytesDecoder, () => ({
    __proto__: dart.getMethods(utf32.Utf32leBytesDecoder.__proto__),
    decode: dart.fnType(core.int, [])
  }));
  dart.setLibraryUri(utf32.Utf32leBytesDecoder, "package:utf/src/utf32.dart");
  utf32.decodeUtf32AsIterable = function decodeUtf32AsIterable(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return new utf32.IterableUtf32Decoder.__(dart.fn(() => utf32.Utf32BytesDecoder.new(bytes, offset, length, replacementCodepoint), VoidToUtf32BytesDecoder()));
  };
  utf32.decodeUtf32beAsIterable = function decodeUtf32beAsIterable(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return new utf32.IterableUtf32Decoder.__(dart.fn(() => new utf32.Utf32beBytesDecoder.new(bytes, offset, length, stripBom, replacementCodepoint), VoidToUtf32beBytesDecoder()));
  };
  utf32.decodeUtf32leAsIterable = function decodeUtf32leAsIterable(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return new utf32.IterableUtf32Decoder.__(dart.fn(() => new utf32.Utf32leBytesDecoder.new(bytes, offset, length, stripBom, replacementCodepoint), VoidToUtf32leBytesDecoder()));
  };
  utf32.decodeUtf32 = function decodeUtf32(bytes, offset = 0, length = null, replacementCodepoint = 65533) {
    return core.String.fromCharCodes(utf32.Utf32BytesDecoder.new(bytes, offset, length, replacementCodepoint).decodeRest());
  };
  utf32.decodeUtf32be = function decodeUtf32be(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return core.String.fromCharCodes(new utf32.Utf32beBytesDecoder.new(bytes, offset, length, stripBom, replacementCodepoint).decodeRest());
  };
  utf32.decodeUtf32le = function decodeUtf32le(bytes, offset = 0, length = null, stripBom = true, replacementCodepoint = 65533) {
    return core.String.fromCharCodes(new utf32.Utf32leBytesDecoder.new(bytes, offset, length, stripBom, replacementCodepoint).decodeRest());
  };
  utf32.encodeUtf32 = function encodeUtf32(str) {
    return utf32.encodeUtf32be(str, true);
  };
  utf32.encodeUtf32be = function encodeUtf32be(str, writeBOM = false) {
    let t0, t0$, t0$0, t0$1, t0$2, t0$3, t0$4, t0$5;
    let utf32CodeUnits = shared.stringToCodepoints(str);
    let encoding = ListOfint().new(4 * dart.notNull(utf32CodeUnits[$length]) + (dart.test(writeBOM) ? 4 : 0));
    let i = 0;
    if (dart.test(writeBOM)) {
      encoding[$_set]((t0 = i, i = t0 + 1, t0), 0);
      encoding[$_set]((t0$ = i, i = t0$ + 1, t0$), 0);
      encoding[$_set]((t0$0 = i, i = t0$0 + 1, t0$0), 254);
      encoding[$_set]((t0$1 = i, i = t0$1 + 1, t0$1), 255);
    }
    for (let unit of utf32CodeUnits) {
      encoding[$_set]((t0$2 = i, i = t0$2 + 1, t0$2), (unit[$rightShift](24) & 255) >>> 0);
      encoding[$_set]((t0$3 = i, i = t0$3 + 1, t0$3), (unit[$rightShift](16) & 255) >>> 0);
      encoding[$_set]((t0$4 = i, i = t0$4 + 1, t0$4), (unit[$rightShift](8) & 255) >>> 0);
      encoding[$_set]((t0$5 = i, i = t0$5 + 1, t0$5), (dart.notNull(unit) & 255) >>> 0);
    }
    return encoding;
  };
  utf32.encodeUtf32le = function encodeUtf32le(str, writeBOM = false) {
    let t0, t0$, t0$0, t0$1, t0$2, t0$3, t0$4, t0$5;
    let utf32CodeUnits = shared.stringToCodepoints(str);
    let encoding = ListOfint().new(4 * dart.notNull(utf32CodeUnits[$length]) + (dart.test(writeBOM) ? 4 : 0));
    let i = 0;
    if (dart.test(writeBOM)) {
      encoding[$_set]((t0 = i, i = t0 + 1, t0), 255);
      encoding[$_set]((t0$ = i, i = t0$ + 1, t0$), 254);
      encoding[$_set]((t0$0 = i, i = t0$0 + 1, t0$0), 0);
      encoding[$_set]((t0$1 = i, i = t0$1 + 1, t0$1), 0);
    }
    for (let unit of utf32CodeUnits) {
      encoding[$_set]((t0$2 = i, i = t0$2 + 1, t0$2), (dart.notNull(unit) & 255) >>> 0);
      encoding[$_set]((t0$3 = i, i = t0$3 + 1, t0$3), (unit[$rightShift](8) & 255) >>> 0);
      encoding[$_set]((t0$4 = i, i = t0$4 + 1, t0$4), (unit[$rightShift](16) & 255) >>> 0);
      encoding[$_set]((t0$5 = i, i = t0$5 + 1, t0$5), (unit[$rightShift](24) & 255) >>> 0);
    }
    return encoding;
  };
  utf32.hasUtf32Bom = function hasUtf32Bom(utf32EncodedBytes, offset = 0, length = null) {
    return dart.test(utf32.hasUtf32beBom(utf32EncodedBytes, offset, length)) || dart.test(utf32.hasUtf32leBom(utf32EncodedBytes, offset, length));
  };
  utf32.hasUtf32beBom = function hasUtf32beBom(utf32EncodedBytes, offset = 0, length = null) {
    let end = length != null ? dart.notNull(offset) + dart.notNull(length) : utf32EncodedBytes[$length];
    return dart.notNull(offset) + 4 <= dart.notNull(end) && utf32EncodedBytes[$_get](offset) === 0 && utf32EncodedBytes[$_get](dart.notNull(offset) + 1) === 0 && utf32EncodedBytes[$_get](dart.notNull(offset) + 2) === 254 && utf32EncodedBytes[$_get](dart.notNull(offset) + 3) === 255;
  };
  utf32.hasUtf32leBom = function hasUtf32leBom(utf32EncodedBytes, offset = 0, length = null) {
    let end = length != null ? dart.notNull(offset) + dart.notNull(length) : utf32EncodedBytes[$length];
    return dart.notNull(offset) + 4 <= dart.notNull(end) && utf32EncodedBytes[$_get](offset) === 255 && utf32EncodedBytes[$_get](dart.notNull(offset) + 1) === 254 && utf32EncodedBytes[$_get](dart.notNull(offset) + 2) === 0 && utf32EncodedBytes[$_get](dart.notNull(offset) + 3) === 0;
  };
  utf32._validCodepoint = function _validCodepoint(codepoint) {
    return dart.notNull(codepoint) >= 0 && dart.notNull(codepoint) < 55296 || dart.notNull(codepoint) > 57343 && dart.notNull(codepoint) < 1114111;
  };
  const _carry = dart.privateName(utf_stream, "_carry");
  const _buffer = dart.privateName(utf_stream, "_buffer");
  const _outSink = dart.privateName(utf_stream, "_outSink");
  const _replacementChar$ = dart.privateName(utf_stream, "_replacementChar");
  const _processBytes = dart.privateName(utf_stream, "_processBytes");
  const _addChar = dart.privateName(utf_stream, "_addChar");
  utf_stream._StringDecoder = class _StringDecoder extends async.StreamTransformerBase$(core.List$(core.int), core.String) {
    bind(stream) {
      StreamOfListOfint()._check(stream);
      return StreamOfString().eventTransformed(stream, dart.fn(sink => {
        if (this[_outSink] != null) {
          dart.throw(new core.StateError.new("String decoder already used"));
        }
        this[_outSink] = sink;
        return this;
      }, EventSinkOfStringTo_StringDecoder()));
    }
    add(bytes) {
      ListOfint()._check(bytes);
      try {
        this[_buffer] = JSArrayOfint().of([]);
        let carry = this[_carry];
        this[_carry] = null;
        let pos = 0;
        let available = bytes[$length];
        let goodChars = 0;
        if (carry != null) pos = -dart.notNull(carry[$length]);
        while (pos < dart.notNull(available)) {
          let currentPos = pos;
          function getNext() {
            let t0, t0$;
            if (pos < 0) {
              return carry[$_get]((t0 = pos, pos = t0 + 1, t0) + dart.notNull(carry[$length]));
            } else if (pos < dart.notNull(available)) {
              return bytes[$_get]((t0$ = pos, pos = t0$ + 1, t0$));
            }
            return null;
          }
          dart.fn(getNext, VoidToint());
          let consumed = this[_processBytes](getNext);
          if (dart.notNull(consumed) > 0) {
            goodChars = this[_buffer][$length];
          } else if (consumed === 0) {
            this[_buffer][$length] = goodChars;
            if (currentPos < 0) {
              this[_carry] = JSArrayOfint().of([]);
              this[_carry][$addAll](carry);
              this[_carry][$addAll](bytes);
            } else {
              this[_carry] = bytes[$sublist](currentPos);
            }
            break;
          } else {
            this[_buffer][$length] = goodChars;
            this[_addChar](-1);
            goodChars = this[_buffer][$length];
          }
        }
        if (dart.notNull(this[_buffer][$length]) > 0) {
          this[_outSink].add(core.String.fromCharCodes(this[_buffer]));
        }
        this[_buffer] = null;
      } catch (e$) {
        let e = dart.getThrown(e$);
        let stackTrace = dart.stackTrace(e$);
        this[_outSink].addError(e, stackTrace);
      }
    }
    addError(error, stackTrace = null) {
      this[_outSink].addError(error, stackTrace);
    }
    close() {
      if (this[_carry] != null) {
        if (this[_replacementChar$] != null) {
          this[_outSink].add(core.String.fromCharCodes(ListOfint().filled(this[_carry][$length], this[_replacementChar$])));
        } else {
          dart.throw(new core.ArgumentError.new("Invalid codepoint"));
        }
      }
      this[_outSink].close();
    }
    [_addChar](char) {
      const error = () => {
        if (this[_replacementChar$] != null) {
          char = this[_replacementChar$];
        } else {
          dart.throw(new core.ArgumentError.new("Invalid codepoint"));
        }
      };
      dart.fn(error, VoidTovoid());
      if (dart.notNull(char) < 0) error();
      if (dart.notNull(char) >= 55296 && dart.notNull(char) <= 57343) error();
      if (dart.notNull(char) > 1114111) error();
      this[_buffer][$add](char);
    }
  };
  (utf_stream._StringDecoder.new = function(_replacementChar) {
    this[_carry] = null;
    this[_buffer] = null;
    this[_outSink] = null;
    this[_replacementChar$] = _replacementChar;
    utf_stream._StringDecoder.__proto__.new.call(this);
    ;
  }).prototype = utf_stream._StringDecoder.prototype;
  dart.addTypeTests(utf_stream._StringDecoder);
  utf_stream._StringDecoder[dart.implements] = () => [async.EventSink$(core.List$(core.int))];
  dart.setMethodSignature(utf_stream._StringDecoder, () => ({
    __proto__: dart.getMethods(utf_stream._StringDecoder.__proto__),
    bind: dart.fnType(async.Stream$(core.String), [core.Object]),
    add: dart.fnType(dart.void, [core.Object]),
    addError: dart.fnType(dart.void, [core.Object], [core.StackTrace]),
    close: dart.fnType(dart.void, []),
    [_addChar]: dart.fnType(dart.void, [core.int])
  }));
  dart.setLibraryUri(utf_stream._StringDecoder, "package:utf/src/utf_stream.dart");
  dart.setFieldSignature(utf_stream._StringDecoder, () => ({
    __proto__: dart.getFields(utf_stream._StringDecoder.__proto__),
    [_carry]: dart.fieldType(core.List$(core.int)),
    [_buffer]: dart.fieldType(core.List$(core.int)),
    [_replacementChar$]: dart.fieldType(core.int),
    [_outSink]: dart.fieldType(async.EventSink$(core.String))
  }));
  utf_stream.Utf8DecoderTransformer = class Utf8DecoderTransformer extends utf_stream._StringDecoder {
    [_processBytes](getNext) {
      let value = getNext();
      if ((dart.notNull(value) & 255) !== value) return -1;
      if ((dart.notNull(value) & 128) === 128) {
        let additionalBytes = null;
        let min = null;
        if ((dart.notNull(value) & 224) === 192) {
          value = dart.notNull(value) & 31;
          additionalBytes = 1;
          min = 128;
        } else if ((dart.notNull(value) & 240) === 224) {
          value = dart.notNull(value) & 15;
          additionalBytes = 2;
          min = 2048;
        } else if ((dart.notNull(value) & 248) === 240) {
          value = dart.notNull(value) & 7;
          additionalBytes = 3;
          min = 65536;
        } else if ((dart.notNull(value) & 252) === 248) {
          value = dart.notNull(value) & 3;
          additionalBytes = 4;
          min = 2097152;
        } else if ((dart.notNull(value) & 254) === 252) {
          value = dart.notNull(value) & 1;
          additionalBytes = 5;
          min = 67108864;
        } else {
          return -1;
        }
        for (let i = 0; i < dart.notNull(additionalBytes); i = i + 1) {
          let next = getNext();
          if (next == null) return 0;
          if ((dart.notNull(next) & 192) !== 128 || (dart.notNull(next) & 255) !== next) return -1;
          value = (dart.notNull(value) << 6 | dart.notNull(next) & 63) >>> 0;
          if (dart.notNull(additionalBytes) >= 3 && i === 0 && dart.notNull(value) << 12 >>> 0 > 1114111) {
            this[_addChar](-1);
          }
        }
        if (dart.notNull(value) < dart.notNull(min)) value = -1;
        this[_addChar](value);
        return 1 + dart.notNull(additionalBytes);
      }
      this[_addChar](value);
      return 1;
    }
  };
  (utf_stream.Utf8DecoderTransformer.new = function(replacementChar = 65533) {
    utf_stream.Utf8DecoderTransformer.__proto__.new.call(this, replacementChar);
    ;
  }).prototype = utf_stream.Utf8DecoderTransformer.prototype;
  dart.addTypeTests(utf_stream.Utf8DecoderTransformer);
  dart.setMethodSignature(utf_stream.Utf8DecoderTransformer, () => ({
    __proto__: dart.getMethods(utf_stream.Utf8DecoderTransformer.__proto__),
    [_processBytes]: dart.fnType(core.int, [dart.fnType(core.int, [])])
  }));
  dart.setLibraryUri(utf_stream.Utf8DecoderTransformer, "package:utf/src/utf_stream.dart");
  const _processString = dart.privateName(utf_stream, "_processString");
  utf_stream._StringEncoder = class _StringEncoder extends async.StreamTransformerBase$(core.String, core.List$(core.int)) {
    bind(stream) {
      StreamOfString()._check(stream);
      return StreamOfListOfint().eventTransformed(stream, dart.fn(sink => {
        if (this[_outSink] != null) {
          dart.throw(new core.StateError.new("String encoder already used"));
        }
        this[_outSink] = sink;
        return this;
      }, EventSinkOfListOfintTo_StringEncoder()));
    }
    add(data) {
      core.String._check(data);
      this[_outSink].add(this[_processString](data));
    }
    addError(error, stackTrace = null) {
      this[_outSink].addError(error, stackTrace);
    }
    close() {
      this[_outSink].close();
    }
  };
  (utf_stream._StringEncoder.new = function() {
    this[_outSink] = null;
    utf_stream._StringEncoder.__proto__.new.call(this);
    ;
  }).prototype = utf_stream._StringEncoder.prototype;
  dart.addTypeTests(utf_stream._StringEncoder);
  utf_stream._StringEncoder[dart.implements] = () => [async.EventSink$(core.String)];
  dart.setMethodSignature(utf_stream._StringEncoder, () => ({
    __proto__: dart.getMethods(utf_stream._StringEncoder.__proto__),
    bind: dart.fnType(async.Stream$(core.List$(core.int)), [core.Object]),
    add: dart.fnType(dart.void, [core.Object]),
    addError: dart.fnType(dart.void, [core.Object], [core.StackTrace]),
    close: dart.fnType(dart.void, [])
  }));
  dart.setLibraryUri(utf_stream._StringEncoder, "package:utf/src/utf_stream.dart");
  dart.setFieldSignature(utf_stream._StringEncoder, () => ({
    __proto__: dart.getFields(utf_stream._StringEncoder.__proto__),
    [_outSink]: dart.fieldType(async.EventSink$(core.List$(core.int)))
  }));
  utf_stream.Utf8EncoderTransformer = class Utf8EncoderTransformer extends utf_stream._StringEncoder {
    [_processString](string) {
      let bytes = JSArrayOfint().of([]);
      let codepoints = util.utf16CodeUnitsToCodepoints(string[$codeUnits]);
      let length = codepoints[$length];
      for (let i = 0; i < dart.notNull(length); i = i + 1) {
        let additionalBytes = null;
        let charCode = codepoints[$_get](i);
        if (dart.notNull(charCode) <= 127) {
          additionalBytes = 0;
          bytes[$add](charCode);
        } else if (dart.notNull(charCode) <= 2047) {
          bytes[$add](dart.notNull(charCode) >> 6 & 31 | 192);
          additionalBytes = 1;
        } else if (dart.notNull(charCode) <= 65535) {
          bytes[$add](dart.notNull(charCode) >> 12 & 15 | 224);
          additionalBytes = 2;
        } else {
          bytes[$add](dart.notNull(charCode) >> 18 & 7 | 240);
          additionalBytes = 3;
        }
        for (let i = additionalBytes; dart.notNull(i) > 0; i = dart.notNull(i) - 1) {
          bytes[$add](charCode[$rightShift](6 * (dart.notNull(i) - 1)) & 63 | 128);
        }
      }
      return bytes;
    }
  };
  (utf_stream.Utf8EncoderTransformer.new = function() {
    utf_stream.Utf8EncoderTransformer.__proto__.new.call(this);
    ;
  }).prototype = utf_stream.Utf8EncoderTransformer.prototype;
  dart.addTypeTests(utf_stream.Utf8EncoderTransformer);
  dart.setMethodSignature(utf_stream.Utf8EncoderTransformer, () => ({
    __proto__: dart.getMethods(utf_stream.Utf8EncoderTransformer.__proto__),
    [_processString]: dart.fnType(core.List$(core.int), [core.String])
  }));
  dart.setLibraryUri(utf_stream.Utf8EncoderTransformer, "package:utf/src/utf_stream.dart");
  dart.trackLibraries("packages/utf/src/constants", {
    "package:utf/src/list_range.dart": list_range,
    "package:utf/src/shared.dart": shared,
    "package:utf/src/util.dart": util,
    "package:utf/src/utf_16_code_unit_decoder.dart": utf_16_code_unit_decoder,
    "package:utf/src/constants.dart": constants,
    "package:utf/src/utf8.dart": utf8,
    "package:utf/src/utf16.dart": utf16,
    "package:utf/src/utf32.dart": utf32,
    "package:utf/utf.dart": utf,
    "package:utf/src/utf_stream.dart": utf_stream
  }, {
  }, '{"version":3,"sourceRoot":"","sources":["list_range.dart","shared.dart","util.dart","utf_16_code_unit_decoder.dart","constants.dart","utf8.dart","utf16.dart","utf32.dart","utf_stream.dart"],"names":[],"mappings":";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;AAoCM,YAAI,2CAAuB,gBAAS,eAAiB,aAAR,8BAAU;IAAQ;;AAEjD;IAAO;;uCAlBL,QAAa,YAAgB;IAC9B,iBAAE,MAAM;IACR,gBAAE,MAAM;IACR,gBAAG,AAAO,MAAD,IAAI,OAAqB,aAAd,AAAO,MAAD,0BAAU,MAAM,IAAG,MAAM;AAHtE;AAIE,QAAY,aAAR,iBAAU,KAAa,aAAR,8BAAU,AAAQ;AACA,MAAnC,WAAU,0BAAiB;;AAE7B,QAAI,iBAAW,QAAiB,aAAR,iBAAU;AACG,MAAnC,WAAU,0BAAiB;;AAE7B,QAAY,AAAU,aAAlB,8BAAU,8BAAU,AAAQ;AACe,MAA7C,WAAU,0BAAyB,aAAR,8BAAU;;EAEzC;;;;;;;;;;;;;;;;;;EAoBF;;;;;;;AAUqB,YAAA,AAAO,uBAAC;IAAQ;;AAEhB,YAAU,EAAR,gBAAF,aAAE,iBAAF,kBAAY;IAAI;;AAEf;IAAO;WAEV;AACF,MAAb,gBAAQ,aAAR,8BAAW,EAAE;IACf;;AAEqB,YAAK,AAAU,cAAf,4BAAO,iBAAU;IAAC;SAExB;AACG,MAAhB,gBAAQ,aAAR,8BAAW,KAAK;IAClB;;oDAjB4B,SAAa,QAAa;IAA1B;IAA0B;IACxC,gBAAS,aAAP,MAAM,IAAG;;EAAC;;;;;;;;;;;;;;;;;;;;;;0DCnDQ;AAGlC,UAAO,iCAA2B,AAAI,GAAD;EACvC;wECD+C,gBACtC,YACD,eACA;;AACY,iBACT,AAA2C,6BAAjC,cAAc,EAAE,MAAM,EAAE,MAAM;AAC5B,kBAAc,wEAC/B,MAAM,EAAE,oBAAoB;AACtB,qBAAiB,gBAAU,AAAO,MAAD;AACvC,YAAI;AACR,qBAAO,AAAQ,OAAD;AACqB,MAAjC,AAAU,UAAA,SAAE,KAAD,CAAC,mBAAM,AAAQ,OAAD;;AAE3B,QAAI,AAAE,CAAD,KAAI,AAAW,UAAD;AACjB,YAAO,WAAU;;AAEP,2BAAqB,gBAAU,CAAC;AACD,MAAzC,AAAe,cAAD,YAAU,GAAG,CAAC,EAAE,UAAU;AACxC,YAAO,eAAc;;EAEzB;wEAK+C,YACtC,YACD,eACA;;AACI,oBAAgB,6BAAU,UAAU,EAAE,MAAM,EAAE,MAAM;AAC1D,wBAAgB;AACpB,aAAS,QAAS,UAAS;AACzB,UAAW,aAAN,KAAK,KAAI,KAAW,aAAN,KAAK,aACb,aAAN,KAAK,aAAsC,aAAN,KAAK;AAC9B,QAAf,gBAAA,AAAa,aAAA;YACR,KAAU,aAAN,KAAK,aACN,aAAN,KAAK;AACW,QAAlB,gBAAA,AAAc,aAAD,GAAI;;AAEF,QAAf,gBAAA,AAAa,aAAA;;;AAIP,0BAAsB,gBAAU,aAAa;AACnD,YAAI;AACR,aAAS,QAAS,UAAS;AACzB,UAAW,aAAN,KAAK,KAAI,KAAW,aAAN,KAAK,aACb,aAAN,KAAK,aAAsC,aAAN,KAAK;AACjB,QAA5B,AAAe,eAAA,SAAE,KAAD,CAAC,mBAAM,KAAK;YACvB,KAAU,aAAN,KAAK,aACN,aAAN,KAAK;AACH,mBAAa,aAAN,KAAK;AAE0B,QAD1C,AAAe,eAAA,SAAE,MAAD,CAAC,qBAA0C,SACvB,CAA9B,AAAK,IAAD,gBAA6B;AAEiC,QADxE,AAAe,eAAA,SAAE,OAAD,CAAC,uBACuB,SAAQ,CAAL,IAAI;YAC1C,KAAI,oBAAoB,IAAI;AACU,QAA3C,AAAe,eAAA,SAAE,OAAD,CAAC,uBAAM,oBAAoB;;AAEA,QAA3C,WAAU,2BAAc;;;AAG5B,UAAO,gBAAe;EACxB;;;;;IC3D0B;;;;;;IACd;;;;;;;AAaoB;IAAI;;AAEf;IAAQ;;AAGV,MAAf,iBAAW;AACX,qBAAK,AAAsB,wCAAY,MAAO;AAE1C,kBAAQ,AAAsB;AAClC,UAAU,aAAN,KAAK,IAAG;AACV,YAAI,6BAAwB;AACK,UAA/B,iBAAW;;AAG8C,UADzD,WAAU,2BACN,AAAoD,+BAAhC,AAAsB;;YAE3C,KAAU,aAAN,KAAK,aACL,aAAN,KAAK,aAAsC,aAAN,KAAK;AAE7B,QAAhB,iBAAW,KAAK;YACX,KAAU,aAAN,KAAK,uBACZ,AAAsB;AAEpB,wBAAY,AAAsB;AACtC,YAAc,aAAV,SAAS,cACC,aAAV,SAAS;AACgD,UAA3D,QAAe,AAAuC,aAA7C,KAAK,aAA2C;AAEJ,UADrD,QAAM,aAAN,KAAK,KAAyB,SACf,aAAV,SAAS;AACE,UAAhB,iBAAW,KAAK;;AAEhB,cAAc,aAAV,SAAS,cACC,aAAV,SAAS;AACmB,YAA9B,AAAsB;;AAExB,cAAI,6BAAwB;AACK,YAA/B,iBAAW;;AAG8C,YADzD,WAAU,2BACN,AAAoD,+BAAhC,AAAsB;;;YAG7C,KAAI,6BAAwB;AACF,QAA/B,iBAAW;;AAG8C,QADzD,WAAU,2BACN,AAAoD,+BAAhC,AAAsB;;AAEhD,YAAO;IACT;;gEA3D+B,gBACtB,YACD,eACC;IALL;IAKK;IACmB,+BACb,AAA2C,6BAAjC,cAAc,EAAE,MAAM,EAAE,MAAM;;EAAW;kFAGzD,uBAA4B;IAVjC;IAUK;IAA4B;;EAAqB;;;;;;;;;;;;;;;;;;;;MCpBlD,iDAAuC;;;MACvC,qBAAW;;;MACX,4BAAkB;;;MAClB,4BAAkB;;;MAElB,gCAAsB;;;MACtB,+BAAqB;;;MACrB,iCAAuB;;;MACvB,+BAAqB;;;MACrB,mCAAyB;;;MACzB,mCAAyB;;;MACzB,8BAAoB;;;MACpB,6CAAmC;;;MACnC,6CAAmC;;;MACnC,+BAAqB;;;MACrB,+BAAqB;;;;;;;;;ICsHb;;;;;;IACN;;;;;;IACA;;;;;;IACA;;;;;;;AAQN,YAAI,0BAAY,YAAO,aAAQ,aAAQ;IAAqB;;2CANvC,OACf,YACD,eACA;IAHgB;IACf;IACD;IACA;AAHT;;EAGyE;;;;;;;;;;;;;;;;;;;;IAgBjD;;;;;;IACd;;;;;;;;AAkBE,uBAAiB,gBAAU,AAAyB;AAC1D,cAAI;AACR,uBAAO;AACoB,QAAzB,AAAU,UAAA,SAAE,KAAD,CAAC,mBAAM;;AAEpB,UAAI,AAAE,CAAD,KAAI,AAAW,UAAD;AACjB,cAAO,WAAU;;AAEP,8BAAsB,gBAAU,CAAC;AACD,QAA1C,AAAgB,eAAD,YAAU,GAAG,CAAC,EAAE,UAAU;AACzC,cAAO,gBAAe;;IAE1B;;AAEmB;IAAQ;;AAGV,MAAf,kBAAW;AAEX,qBAAK,AAAyB,2CAAY,MAAO;AAE7C,kBAAQ,AAAyB;AACjC,4BAAkB;AAEtB,UAAU,aAAN,KAAK,IAAG;AACV,YAAI,6BAAwB;AACK,UAA/B,kBAAW;AACX,gBAAO;;AAGoD,UAD3D,WAAU,2BACN,AAAsD,8BAAnC,AAAyB;;YAE7C,KAAU,aAAN,KAAK;AACE,QAAhB,kBAAW,KAAK;AAChB,cAAO;YACF,KAAU,aAAN,KAAK;AACd,YAAI,6BAAwB;AACK,UAA/B,kBAAW;AACX,gBAAO;;AAGoD,UAD3D,WAAU,2BACN,AAAsD,8BAAnC,AAAyB;;YAE7C,KAAU,aAAN,KAAK;AACuB,QAArC,QAAM,aAAN,KAAK;AACc,QAAnB,kBAAkB;YACb,KAAU,aAAN,KAAK;AACyB,QAAvC,QAAM,aAAN,KAAK;AACc,QAAnB,kBAAkB;YACb,KAAU,aAAN,KAAK;AACwB,QAAtC,QAAM,aAAN,KAAK;AACc,QAAnB,kBAAkB;YACb,KAAU,aAAN,KAAK;AACwB,QAAtC,QAAM,aAAN,KAAK;AACc,QAAnB,kBAAkB;YACb,KAAU,aAAN,KAAK;AACuB,QAArC,QAAM,aAAN,KAAK;AACc,QAAnB,kBAAkB;YACb,KAAI,6BAAwB;AACF,QAA/B,kBAAW;AACX,cAAO;;AAGoD,QAD3D,WAAU,2BACN,AAAsD,8BAAnC,AAAyB;;AAE9C,cAAI;AACR,aAAO,AAAE,CAAD,GAAG,eAAe,cAAI,AAAyB;AACjD,wBAAY,AAAyB;AACzC,YAAc,aAAV,SAAS,WACC,aAAV,SAAS;AACiD,UAA5D,QAAsB,CAAN,aAAN,KAAK,KAAI,IAAgB,cAAV,SAAS;;AAGlC,cAAc,aAAV,SAAS;AACsB,YAAjC,AAAyB;;AAE3B;;AAEC,QAAH,IAAA,AAAC,CAAA;;AAEE,0BAAiB,AAAE,AAAmB,CAApB,KAAI,eAAe,KAC/B,aAAN,KAAK,aACI,aAAN,KAAK;AACR,wBAAe,AAAgB,AACqB,eADtB,KAAI,KAAW,aAAN,KAAK,WAC5C,AAAgB,eAAD,KAAI,KAAW,aAAN,KAAK,YAC7B,AAAgB,eAAD,KAAI,KAAW,aAAN,KAAK;AAC7B,oBAAgB,aAAN,KAAK;AACpB,UAAI,aAAa,IAAI,WAAW,IAAI,OAAO;AACzB,QAAhB,kBAAW,KAAK;AAChB,cAAO;YACF,KAAI,6BAAwB;AACF,QAA/B,kBAAW;AACX,cAAO;;AAGwD,QAD/D,WAAU,2BACN,AAA0D,8BAAL,aAAlC,AAAyB,0CAAW,CAAC;;IAEhE;;mCAhHsB,kBACb,YACD,eACC;IALL;IAKK;IACsB,iCAChB,AAA6C,6BAAnC,gBAAgB,EAAE,MAAM,EAAE,MAAM;;EAAW;sDAEvB,QACnC;IAVN;IAUM;IACqB,iCAAE,AAAO,MAAD;;EAAS;;;;;;;;;;;;;;;;;;;4DA/IC,OAC1C,YACD,eACA;AACN,UAAW,kCAAoB,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;EAC5E;wCAS4B,OACnB,YACD,eACA;AACN,UAAW,2BACF,AACA,yBADY,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;EAElE;wCAK4B;AAAQ,iCAAiB,0BAAmB,GAAG;EAAE;gDAEtD,QAAY,OAAW,OAAiB;AAC7D,WAAa,aAAN,KAAK,IAAG;AAEmD,MADhE,AAAM,MAAA,QAAQ,aAAP,MAAM,iBAAG,KAAK,GACU,OAAS,cAAN,KAAK;AACrB,MAAlB,QAAQ,AAAM,KAAD,cAAI;AACV,MAAP,QAAK,aAAL,KAAK;;AAEP,UAAO,MAAK;EACd;oDAKqC,YAAiB,YAAgB;AAC1D,iBAAa,6BAAU,UAAU,EAAE,MAAM,EAAE,MAAM;AAEvD,wBAAgB;AACpB,aAAS,QAAS,OAAM;AACtB,UAAU,aAAN,KAAK,IAAG,KAAW,aAAN,KAAK;AACF,QAAlB,gBAAA,AAAc,aAAD,GAAI;YACZ,KAAU,aAAN,KAAK;AACC,QAAf,gBAAA,AAAa,aAAA;YACR,KAAU,aAAN,KAAK;AACI,QAAlB,gBAAA,AAAc,aAAD,GAAI;YACZ,KAAU,aAAN,KAAK;AACI,QAAlB,gBAAA,AAAc,aAAD,GAAI;YACZ,KAAU,aAAN,KAAK;AACI,QAAlB,gBAAA,AAAc,aAAD,GAAI;;;AAIX,kBAAc,gBAAU,aAAa;AAC3C,mBAAW;AACf,aAAS,QAAS,OAAM;AACtB,UAAU,aAAN,KAAK,IAAG,KAAW,aAAN,KAAK;AACwC,QAA5D,AAAQ,OAAD,YAAU,QAAQ,EAAE,AAAS,QAAD,GAAG,GAAG,mBAAC,KAAM,KAAM;AACzC,QAAb,WAAA,AAAS,QAAD,GAAI;YACP,KAAU,aAAN,KAAK;AACW,QAAzB,AAAO,OAAA,QAAC,QAAQ,EAAI,KAAK;AACf,QAAV,WAAA,AAAQ,QAAA;YACH,KAAU,aAAN,KAAK;AAGsC,QAFpD,AAAO,OAAA,QAAC,QAAQ,EAAiC,OACf,mBAC1B,oBAAe,QAAQ,EAAE,GAAG,KAAK,EAAE,OAAO;AACrC,QAAb,WAAA,AAAS,QAAD,GAAI;YACP,KAAU,aAAN,KAAK;AAGsC,QAFpD,AAAO,OAAA,QAAC,QAAQ,EAAmC,OACf,mBAC5B,oBAAe,QAAQ,EAAE,GAAG,KAAK,EAAE,OAAO;AACrC,QAAb,WAAA,AAAS,QAAD,GAAI;YACP,KAAU,aAAN,KAAK;AAGsC,QAFpD,AAAO,OAAA,QAAC,QAAQ,EAAkC,OACf,kBAC3B,oBAAe,QAAQ,EAAE,GAAG,KAAK,EAAE,OAAO;AACrC,QAAb,WAAA,AAAS,QAAD,GAAI;;;AAGhB,UAAO,QAAO;EAChB;oDAIqC,kBAC5B,YACD,eACA;AACN,UAAW,AACN,0BADkB,gBAAgB,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;EAE/E;;MAxHU,uBAAkB;;;MAClB,uBAAkB;;;MAClB,yBAAoB;;;MAEpB,0BAAqB;;;MAErB,iCAA4B;;;MAC5B,mCAA8B;;;MAC9B,kCAA6B;;;MAC7B,kCAA6B;;;MAC7B,iCAA4B;;;MAE5B,iCAA4B;;;MAC5B,mCAA8B;;;MAC9B,kCAA6B;;;MAE7B,gCAA2B;;;MAC3B,+BAA0B;;;;;;;ICoMT;;;;;;IACf;;;;;;;AAKN,YAAI,yEACA,0BAAqB;IAAqB;;4CAJtB,mBAAwB;IAAxB;IAAwB;AAApD;;EAAyE;;;;;;;;;;;;;;;;;;IAcjD;;;;;;IACd;;;;;;eAMqC,mBACtC,YACD,eACA;AACN,UAAI,AAAO,MAAD,IAAI;AAC8B,QAA1C,SAAkC,aAAzB,AAAkB,iBAAD,0BAAU,MAAM;;AAE5C,oBAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACjD,cAAW,8CAA+B,iBAAiB,EAAS,aAAP,MAAM,IAAG,GAC3D,aAAP,MAAM,IAAG,GAAG,OAAO,oBAAoB;YACtC,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACxD,cAAW,8CAA+B,iBAAiB,EAAS,aAAP,MAAM,IAAG,GAC3D,aAAP,MAAM,IAAG,GAAG,OAAO,oBAAoB;;AAE3C,cAAW,8CACP,iBAAiB,EAAE,MAAM,EAAE,MAAM,EAAE,OAAO,oBAAoB;;IAEtE;;;AAQY,sBAAgB,gBAAU;AAChC,cAAI;AACR,uBAAO;AACmB,QAAxB,AAAS,SAAA,SAAE,KAAD,CAAC,mBAAM;;AAEnB,UAAI,AAAE,CAAD,KAAI,AAAU,SAAD;AAChB,cAAO,UAAS;;AAEN,6BAAqB,gBAAU,CAAC;AACF,QAAxC,AAAe,cAAD,YAAU,GAAG,CAAC,EAAE,SAAS;AACvC,cAAO,eAAc;;IAEzB;;AAEmB;IAAQ;;AAGV,MAAf,mBAAW;AACP,sBAAY,AAA0B;AAC1C,UAAI,AAAU,SAAD,KAAI;AACA,QAAf,mBAAW;AACX,cAAO;;AAET,UAAI,AAAU,SAAD,KAAI;AACqB,QAApC,AAA0B;AAC1B,YAAI,6BAAwB;AACK,UAA/B,mBAAW;AACX,gBAAO;;AAGsD,UAD7D,WAAU,2BACN,AAAwD,+BAApC,AAA0B;;;AAGnC,MAAnB,mBAAW;AACX,YAAO;IACT;;AAEoB,YAAmC,eAAnC,AAA0B,2CAAY;IAAC;WAE1C;AACyB,MAAxC,AAA0B,sCAAO,AAAE,iBAAE,EAAE;IACzC;;AAEqB,YAA0C,GAAL,aAApC,AAA0B,4CAAY,KAAM;IAAC;SAEpD;AAC4B,MAAzC,AAA0B,oCAAK,AAAE,iBAAE,KAAK;IAC1C;;wEA1ES,2BAAgC;IAHrC;IAGK;IAAgC;;EAAqB;;;;;;;;;;;;;;;;;;;;;;;;;AAkGxB,MAApC,AAA0B;AACtB,eAAK,AAA0B;AACC,MAApC,AAA0B;AACtB,eAAK,AAA0B;AACnC,YAAiB,EAAN,aAAH,EAAE,KAAI,wBAAK,EAAE;IACvB;;uDAnByC,mBAChC,YACD,eACC,iBACD;AACI,qFACG,AAA8C,6BAApC,iBAAiB,EAAE,MAAM,EAAE,MAAM,YAChD,oBAAoB;AAC5B,kBAAI,QAAQ,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACvD,MAAN;;EAEJ;;;;;;;;;AA8BsC,MAApC,AAA0B;AACtB,eAAK,AAA0B;AACC,MAApC,AAA0B;AACtB,eAAK,AAA0B;AACnC,YAAiB,EAAN,aAAH,EAAE,KAAI,wBAAK,EAAE;IACvB;;uDAnByC,mBAChC,YACD,eACC,iBACD;AACI,qFACG,AAA8C,6BAApC,iBAAiB,EAAE,MAAM,EAAE,MAAM,YAChD,oBAAoB;AAC5B,kBAAI,QAAQ,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACvD,MAAN;;EAEJ;;;;;;;yDA9VkC;AAClC,UAAW,2BAAqB,UAAU;EAC5C;+DAUqD,OAC5C,YACD,eACA;AACN,UAAW,mCACP,cAAU,uCACN,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB,0CAC/C,oBAAoB;EAC1B;mEAUuD,OAC9C,YACD,eACC,iBACD;AACN,UAAW,mCACP,cAAU,6CACN,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB,4CACzD,oBAAoB;EAC1B;mEAUuD,OAC9C,YACD,eACC,iBACD;AACN,UAAW,mCACP,cAAU,6CACN,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB,4CACzD,oBAAoB;EAC1B;2CAQ6B,OACpB,YACD,eACA;AACuB,kBAAc,uCACvC,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;AACrC,oBAAY,AAAQ,OAAD;AAC7B,UAAW,2BACP,gCAA2B,SAAS,EAAE,GAAG,MAAM,oBAAoB;EACzE;+CAS+B,OACtB,YACD,eACC,iBACD;AACI,oBAAiB,AAEtB,6CADG,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;AAE7D,UAAW,2BACP,gCAA2B,SAAS,EAAE,GAAG,MAAM,oBAAoB;EACzE;+CAS+B,OACtB,YACD,eACC,iBACD;AACI,oBAAiB,AAEtB,6CADG,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;AAE7D,UAAW,2BACP,gCAA2B,SAAS,EAAE,GAAG,MAAM,oBAAoB;EACzE;2CAM6B;AAAQ,+BAAc,GAAG,EAAE;EAAK;+CAM9B,KAAW;;AAC9B,yBAAiB,8BAAwB,GAAG;AAC5C,mBACF,gBAAU,AAAE,AAAwB,iBAAtB,AAAe,cAAD,wBAAW,QAAQ,IAAG,IAAI;AAC1D,YAAI;AACR,kBAAI,QAAQ;AACwB,MAAlC,AAAQ,QAAA,SAAE,KAAD,CAAC;AACwB,MAAlC,AAAQ,QAAA,SAAE,MAAD,CAAC;;AAEZ,aAAS,OAAQ,eAAc;AACsB,MAAnD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAqC,CAAzB,aAAL,IAAI,eAA6B;AACL,MAA7C,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAW,cAAL,IAAI;;AAEtB,UAAO,SAAQ;EACjB;+CAM+B,KAAW;;AAC9B,yBAAiB,8BAAwB,GAAG;AAC5C,mBACF,gBAAU,AAAE,AAAwB,iBAAtB,AAAe,cAAD,wBAAW,QAAQ,IAAG,IAAI;AAC1D,YAAI;AACR,kBAAI,QAAQ;AACwB,MAAlC,AAAQ,QAAA,SAAE,KAAD,CAAC;AACwB,MAAlC,AAAQ,QAAA,SAAE,MAAD,CAAC;;AAEZ,aAAS,OAAQ,eAAc;AACgB,MAA7C,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAW,cAAL,IAAI;AAC+B,MAAnD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAqC,CAAzB,aAAL,IAAI,eAA6B;;AAEpD,UAAO,SAAQ;EACjB;2CAM2B,mBAAwB,YAAgB;AACjE,UAAwD,WAAjD,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM,gBAClD,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;EACrD;+CAM6B,mBAAwB,YAAgB;AAC/D,cAAM,AAAO,MAAD,IAAI,OAAc,aAAP,MAAM,iBAAG,MAAM,IAAG,AAAkB,iBAAD;AAC9D,UAAe,AAAK,AACgC,cAD5C,MAAM,IAAG,kBAAM,GAAG,KACtB,AAAiB,AAAS,iBAAT,QAAC,MAAM,aACxB,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG;EACjC;+CAM6B,mBAAwB,YAAgB;AAC/D,cAAM,AAAO,MAAD,IAAI,OAAc,aAAP,MAAM,iBAAG,MAAM,IAAG,AAAkB,iBAAD;AAC9D,UAAe,AAAK,AACgC,cAD5C,MAAM,IAAG,kBAAM,GAAG,KACtB,AAAiB,AAAS,iBAAT,QAAC,MAAM,aACxB,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG;EACjC;mEAEyC;AACvC,UAAO,iCAA2B,AAAI,GAAD;EACvC;;;ICPkC;;;;;;;AAIE;IAAmB;;;IAFzB;AAA5B;;EAA8C;;;;;;;;;;;;;;;;;IAUtB;;;;;;IACd;;;;;;eAM0B,mBAC3B,YACD,eACA;AACN,UAAI,AAAO,MAAD,IAAI;AAC8B,QAA1C,SAAkC,aAAzB,AAAkB,iBAAD,0BAAU,MAAM;;AAE5C,oBAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACjD,cAAW,mCAAoB,iBAAiB,EAAS,aAAP,MAAM,IAAG,GAAU,aAAP,MAAM,IAAG,GACnE,OAAO,oBAAoB;YAC1B,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACxD,cAAW,mCAAoB,iBAAiB,EAAS,aAAP,MAAM,IAAG,GAAU,aAAP,MAAM,IAAG,GACnE,OAAO,oBAAoB;;AAE/B,cAAW,mCACP,iBAAiB,EAAE,MAAM,EAAE,MAAM,EAAE,OAAO,oBAAoB;;IAEtE;;;AAGY,sBAAgB,gBAAU;AAChC,cAAI;AACR,uBAAO;AACmB,QAAxB,AAAS,SAAA,SAAE,KAAD,CAAC,mBAAM;;AAEnB,YAAO,UAAS;IAClB;;AAEmB;IAAQ;;AAGV,MAAf,mBAAW;AACP,sBAAY,AAA0B;AAC1C,UAAI,AAAU,SAAD,KAAI;AACA,QAAf,mBAAW;AACX,cAAO;;AAET,UAAc,aAAV,SAAS,IAAG;AACqD,QAAnE,AAA0B,oCAAK,AAA0B;AACzD,YAAI,6BAAwB;AACK,UAA/B,mBAAW;AACX,gBAAO;;AAGsD,UAD7D,WAAU,2BACN,AAAwD,+BAApC,AAA0B;;;AAGlD,sBAAY;AAChB,oBAAI,sBAAgB,SAAS;AACP,QAApB,mBAAW,SAAS;AACpB,cAAO;YACF,KAAI,6BAAwB;AACF,QAA/B,mBAAW;AACX,cAAO;;AAGsD,QAD7D,WAAU,2BACN,AAAwD,+BAApC,AAA0B;;IAEtD;;AAEoB,YAAmC,eAAnC,AAA0B,2CAAY;IAAC;WAE1C;AACyB,MAAxC,AAA0B,sCAAO,AAAE,iBAAE,EAAE;IACzC;;AAEqB,YAA0C,GAAL,aAApC,AAA0B,4CAAY,KAAM;IAAC;SAEpD;AAC4B,MAAzC,AAA0B,oCAAK,AAAE,iBAAE,KAAK;IAC1C;;6DAxES,2BAAgC;IAHrC;IAGK;IAAgC;;EAAqB;;;;;;;;;;;;;;;;;;;;;;;;;AAgGxB,MAApC,AAA0B;AACtB,kBAAQ,AAA0B;AACF,MAApC,AAA0B;AAC8B,MAAxD,QAAqB,CAAN,aAAN,KAAK,KAAI,wBAAK,AAA0B;AACb,MAApC,AAA0B;AAC8B,MAAxD,QAAqB,CAAN,aAAN,KAAK,KAAI,wBAAK,AAA0B;AACb,MAApC,AAA0B;AAC8B,MAAxD,QAAqB,CAAN,aAAN,KAAK,KAAI,wBAAK,AAA0B;AACjD,YAAO,MAAK;IACd;;4CAvB8B,mBACrB,YACD,eACC,iBACD;AACI,0EACG,AAA8C,6BAApC,iBAAiB,EAAE,MAAM,EAAE,MAAM,YAChD,oBAAoB;AAC5B,kBAAI,QAAQ,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACvD,MAAN;;EAEJ;;;;;;;;;AAkCsC,MAApC,AAA0B;AACtB,kBAAQ,AAA0B;AACF,MAApC,AAA0B;AACuB,MAAjD,QAAM,aAAN,KAAK,KAAuC,aAAlC,AAA0B,2CAAW;AACX,MAApC,AAA0B;AACwB,MAAlD,QAAM,aAAN,KAAK,KAAuC,aAAlC,AAA0B,2CAAW;AACX,MAApC,AAA0B;AACwB,MAAlD,QAAM,aAAN,KAAK,KAAuC,aAAlC,AAA0B,2CAAW;AAC/C,YAAO,MAAK;IACd;;4CAvB8B,mBACrB,YACD,eACC,iBACD;AACI,0EACG,AAA8C,6BAApC,iBAAiB,EAAE,MAAM,EAAE,MAAM,YAChD,oBAAoB;AAC5B,kBAAI,QAAQ,eAAI,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;AACvD,MAAN;;EAEJ;;;;;;;+DAxUmD,OAC5C,YACD,eACA;AACN,UAAW,mCACP,cAAU,4BAAkB,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;EAC7E;mEASuD,OAC9C,YACD,eACC,iBACD;AACN,UAAW,mCAAuB,cAAU,kCACxC,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;EAC3D;mEASuD,OAC9C,YACD,eACC,iBACD;AACN,UAAW,mCAAuB,cAAU,kCACxC,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;EAC3D;2CAS6B,OACpB,YACD,eACA;AACN,UAAW,2BACF,AACA,4BADkB,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,oBAAoB;EAExE;+CAS+B,OAClB,YACD,eACC,iBACD;AACR,UAAI,2BAA0B,AAEzB,kCADG,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;EAC3C;+CASS,OAClB,YACD,eACC,iBACD;AACR,UAAI,2BAA0B,AAEzB,kCADG,KAAK,EAAE,MAAM,EAAE,MAAM,EAAE,QAAQ,EAAE,oBAAoB;EAC3C;2CAMO;AAAQ,+BAAc,GAAG,EAAE;EAAK;+CAM9B,KAAW;;AAC9B,yBAAiB,0BAAmB,GAAG;AACvC,mBACF,gBAAU,AAAE,AAAwB,iBAAtB,AAAe,cAAD,wBAAW,QAAQ,IAAG,IAAI;AAC1D,YAAI;AACR,kBAAI,QAAQ;AACO,MAAjB,AAAQ,QAAA,SAAE,KAAD,CAAC,mBAAM;AACC,MAAjB,AAAQ,QAAA,SAAE,MAAD,CAAC,qBAAM;AACkB,MAAlC,AAAQ,QAAA,SAAE,OAAD,CAAC;AACwB,MAAlC,AAAQ,QAAA,SAAE,OAAD,CAAC;;AAEZ,aAAS,OAAQ,eAAc;AACwB,MAArD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAmB,CAAZ,AAAK,IAAD,cAAI;AAC4B,MAArD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAmB,CAAZ,AAAK,IAAD,cAAI;AAC2B,MAApD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAkB,CAAX,AAAK,IAAD,cAAI;AACoB,MAA7C,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAW,cAAL,IAAI;;AAEtB,UAAO,SAAQ;EACjB;+CAM+B,KAAW;;AAC9B,yBAAiB,0BAAmB,GAAG;AACvC,mBACF,gBAAU,AAAE,AAAwB,iBAAtB,AAAe,cAAD,wBAAW,QAAQ,IAAG,IAAI;AAC1D,YAAI;AACR,kBAAI,QAAQ;AACwB,MAAlC,AAAQ,QAAA,SAAE,KAAD,CAAC;AACwB,MAAlC,AAAQ,QAAA,SAAE,MAAD,CAAC;AACO,MAAjB,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAM;AACC,MAAjB,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAM;;AAElB,aAAS,OAAQ,eAAc;AACgB,MAA7C,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAW,cAAL,IAAI;AACgC,MAApD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAkB,CAAX,AAAK,IAAD,cAAI;AAC4B,MAArD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAmB,CAAZ,AAAK,IAAD,cAAI;AAC4B,MAArD,AAAQ,QAAA,SAAE,OAAD,CAAC,uBAAmB,CAAZ,AAAK,IAAD,cAAI;;AAE3B,UAAO,SAAQ;EACjB;2CAM2B,mBAAwB,YAAgB;AACjE,UAAwD,WAAjD,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM,gBAClD,oBAAc,iBAAiB,EAAE,MAAM,EAAE,MAAM;EACrD;+CAM6B,mBAAwB,YAAgB;AAC/D,cAAM,AAAO,MAAD,IAAI,OAAc,aAAP,MAAM,iBAAG,MAAM,IAAG,AAAkB,iBAAD;AAC9D,UAAe,AAAK,AAGoC,cAHhD,MAAM,IAAG,kBAAM,GAAG,KACtB,AAAiB,AAAS,iBAAT,QAAC,MAAM,MAAK,KAC7B,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG,OAAM,KACjC,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG,cAC3B,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG;EACjC;+CAM6B,mBAAwB,YAAgB;AAC/D,cAAM,AAAO,MAAD,IAAI,OAAc,aAAP,MAAM,iBAAG,MAAM,IAAG,AAAkB,iBAAD;AAC9D,UAAe,AAAK,AAGmB,cAH/B,MAAM,IAAG,kBAAM,GAAG,KACtB,AAAiB,AAAS,iBAAT,QAAC,MAAM,aACxB,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG,cAC3B,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG,OAAM,KACjC,AAAiB,AAAa,iBAAb,QAAQ,aAAP,MAAM,IAAG,OAAM;EACvC;mDAwKyB;AACvB,UAAkB,AAA+C,cAAzD,SAAS,KAAI,KAAe,aAAV,SAAS,aACpB,aAAV,SAAS,aACI,aAAV,SAAS;EACnB;;;;;;;;;iCCxVwC;AACpC,YAAW,mCAAgC,MAAM,EAC7C,QAAmB;AACrB,YAAI,kBAAY;AACqC,UAAnD,WAAU,wBAAW;;AAER,QAAf,iBAAW,IAAI;AACf,cAAO;;IAEX;;yBAEmB;AACjB;AACmB,QAAjB,gBAAe;AACL,oBAAQ;AACL,QAAb,eAAS;AACL,kBAAM;AACN,wBAAY,AAAM,KAAD;AAGjB,wBAAY;AAChB,YAAI,KAAK,IAAI,MAAM,AAAmB,MAAb,cAAC,AAAM,KAAD;AAC/B,eAAO,AAAI,GAAD,gBAAG,SAAS;AAChB,2BAAa,GAAG;AACpB,mBAAI;;AACF,gBAAI,AAAI,GAAD,GAAG;AACR,oBAAO,AAAK,MAAA,QAAO,CAAH,KAAH,GAAG,mCAAK,AAAM,KAAD;kBACrB,KAAI,AAAI,GAAD,gBAAG,SAAS;AACxB,oBAAO,AAAK,MAAA,SAAI,MAAH,GAAG;;AAElB,kBAAO;;;AAGL,yBAAW,oBAAc,OAAO;AACpC,cAAa,aAAT,QAAQ,IAAG;AACa,YAA1B,YAAY,AAAQ;gBACf,KAAI,AAAS,QAAD,KAAI;AACK,YAA1B,AAAQ,yBAAS,SAAS;AAC1B,gBAAI,AAAW,UAAD,GAAG;AACJ,cAAX,eAAS;AACW,cAApB,AAAO,sBAAO,KAAK;AACC,cAApB,AAAO,sBAAO,KAAK;;AAEe,cAAlC,eAAS,AAAM,KAAD,WAAS,UAAU;;AAEnC;;AAG0B,YAA1B,AAAQ,yBAAS,SAAS;AACd,YAAZ,eAAS,CAAC;AACgB,YAA1B,YAAY,AAAQ;;;AAGxB,YAAmB,aAAf,AAAQ,0BAAS;AAE4B,UAA/C,AAAS,mBAAQ,0BAAqB;;AAE1B,QAAd,gBAAU;;YACH;YAAG;AACsB,QAAhC,AAAS,wBAAS,CAAC,EAAE,UAAU;;IAEnC;aAEc,OAAmB;AACK,MAApC,AAAS,wBAAS,KAAK,EAAE,UAAU;IACrC;;AAGE,UAAI,gBAAU;AACZ,YAAI,2BAAoB;AAEgC,UADtD,AAAS,mBAAQ,0BACT,mBAAY,AAAO,uBAAQ;;AAES,UAA5C,WAAU,2BAAc;;;AAGZ,MAAhB,AAAS;IACX;eAIkB;AAChB,YAAK;AACH,YAAI,2BAAoB;AACC,UAAvB,OAAO;;AAEqC,UAA5C,WAAU,2BAAc;;;;AAI5B,UAAS,aAAL,IAAI,IAAG,GAAG,AAAK,AAAE,KAAF;AACnB,UAAS,aAAL,IAAI,KAAI,SAAe,aAAL,IAAI,KAAI,OAAQ,AAAK,AAAE,KAAF;AAC3C,UAAS,aAAL,IAAI,IAAG,SAAU,AAAK,AAAE,KAAF;AACT,MAAjB,AAAQ,oBAAI,IAAI;IAClB;;4CAhGoB;IANV;IACA;IAGQ;IAEE;AAApB;;EAAqC;;;;;;;;;;;;;;;;;;;;oBA2Gf;AAChB,kBAAQ,AAAO,OAAA;AACnB,WAAW,aAAN,KAAK,IAAG,SAAS,KAAK,EAAE,MAAO,EAAC;AACrC,UAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAChB;AACA;AACJ,YAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAEA,UAApB,QAAc,aAAN,KAAK,IAAG;AACG,UAAnB,kBAAkB;AACR,UAAV,MAAM;cACD,KAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAEP,UAApB,QAAc,aAAN,KAAK,IAAG;AACG,UAAnB,kBAAkB;AACP,UAAX,MAAM;cACD,KAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAEP,UAApB,QAAc,aAAN,KAAK,IAAG;AACG,UAAnB,kBAAkB;AACL,UAAb,MAAM;cACD,KAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAEP,UAApB,QAAc,aAAN,KAAK,IAAG;AACG,UAAnB,kBAAkB;AACJ,UAAd,MAAM;cACD,KAAmB,CAAR,aAAN,KAAK,IAAG,SAAS;AAEP,UAApB,QAAc,aAAN,KAAK,IAAG;AACG,UAAnB,kBAAkB;AACH,UAAf,MAAM;;AAEN,gBAAO,EAAC;;AAEV,iBAAS,IAAI,GAAG,AAAE,CAAD,gBAAG,eAAe,GAAE,IAAA,AAAC,CAAA;AAChC,qBAAO,AAAO,OAAA;AAClB,cAAI,AAAK,IAAD,IAAI,MAAM,MAAO;AACzB,eAAU,aAAL,IAAI,IAAG,SAAS,QAAc,aAAL,IAAI,IAAG,SAAS,IAAI,EAAE,MAAO,EAAC;AAC1B,UAAlC,QAAmB,CAAL,aAAN,KAAK,KAAI,IAAU,aAAL,IAAI,IAAG;AAC7B,cAAoB,aAAhB,eAAe,KAAI,KAAK,AAAE,CAAD,KAAI,KAAW,AAAM,aAAZ,KAAK,KAAI,WAAK;AACtC,YAAZ,eAAS,CAAC;;;AAId,YAAU,aAAN,KAAK,iBAAG,GAAG,GAAE,AAAU,QAAF,CAAC;AACX,QAAf,eAAS,KAAK;AACd,cAAO,AAAE,kBAAE,eAAe;;AAEb,MAAf,eAAS,KAAK;AACd,YAAO;IACT;;oDArDS;AACH,+DAAM,eAAe;;EAAC;;;;;;;;;;8BA2DU;AACpC,YAAW,sCAAmC,MAAM,EAChD,QAAsB;AACxB,YAAI,kBAAY;AACqC,UAAnD,WAAU,wBAAW;;AAER,QAAf,iBAAW,IAAI;AACf,cAAO;;IAEX;;yBAEgB;AACoB,MAAlC,AAAS,mBAAI,qBAAe,IAAI;IAClC;aAEc,OAAmB;AACK,MAApC,AAAS,wBAAS,KAAK,EAAE,UAAU;IACrC;;AAGkB,MAAhB,AAAS;IACX;;;IAvBqB;;;EA0BvB;;;;;;;;;;;;;;;;qBAMkC;AAC1B,kBAAa;AACP,uBAAa,gCAA2B,AAAO,MAAD;AACpD,mBAAS,AAAW,UAAD;AACvB,eAAS,IAAI,GAAG,AAAE,CAAD,gBAAG,MAAM,GAAE,IAAA,AAAC,CAAA;AACvB;AACA,uBAAW,AAAU,UAAA,QAAC,CAAC;AAC3B,YAAa,aAAT,QAAQ,KAAI;AACK,UAAnB,kBAAkB;AACC,UAAnB,AAAM,KAAD,OAAK,QAAQ;cACb,KAAa,aAAT,QAAQ,KAAI;AAEqB,UAA1C,AAAM,KAAD,OAAgB,AAAM,AAAQ,aAAvB,QAAQ,KAAI,IAAK,KAAQ;AAClB,UAAnB,kBAAkB;cACb,KAAa,aAAT,QAAQ,KAAI;AAEsB,UAA3C,AAAM,KAAD,OAAgB,AAAO,AAAQ,aAAxB,QAAQ,KAAI,KAAM,KAAQ;AACnB,UAAnB,kBAAkB;;AAGyB,UAA3C,AAAM,KAAD,OAAgB,AAAO,AAAQ,aAAxB,QAAQ,KAAI,KAAM,IAAQ;AACnB,UAAnB,kBAAkB;;AAEpB,iBAAS,IAAI,eAAe,EAAI,aAAF,CAAC,IAAG,GAAG,IAAC,aAAD,CAAC;AAEkB,UAAtD,AAAM,KAAD,OAAO,AAAS,AAAkB,AAAQ,QAA3B,cAAK,AAAE,KAAK,aAAF,CAAC,IAAG,MAAO,KAAQ;;;AAGrD,YAAO,MAAK;IACd;;;;;EACF","file":"constants.ddc.js"}');
  // Exports:
  return {
    src__list_range: list_range,
    src__shared: shared,
    src__util: util,
    src__utf_16_code_unit_decoder: utf_16_code_unit_decoder,
    src__constants: constants,
    src__utf8: utf8,
    src__utf16: utf16,
    src__utf32: utf32,
    utf: utf,
    src__utf_stream: utf_stream
  };
});

//# sourceMappingURL=constants.ddc.js.map
