﻿using System;
using System.Collections.Generic;
using System.IO;
using Syncfusion.DocIO;
using Syncfusion.DocIO.DLS;
using Syncfusion.DocIORenderer;
using Syncfusion.Drawing;
using Syncfusion.OfficeChart;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;
using Syncfusion.Pdf.Interactive;
using Syncfusion.Pdf.Parsing;
using System.Linq;
using System.Collections;
using Syncfusion.Licensing;
using syncfusionEntityType = Syncfusion.DocIO.DLS.EntityType;

namespace SyncfusionTextTest
{
    class Program
    {
        static void Main(string[] args)
        {
            UseCustomFont();
        }

        private static void UseCustomFont()
        {
            
                FileStream docStream = new FileStream(@"Includes\teco.docx", FileMode.Open, FileAccess.Read);
                //Loads file stream into Word document
                WordDocument wordDocument = new WordDocument(docStream, Syncfusion.DocIO.FormatType.Docx);
                //Hooks the font substitution event
                wordDocument.FontSettings.SubstituteFont += FontSettings_SubstituteFont;
                //Instantiation of DocIORenderer for Word to PDF conversion
                DocIORenderer render = new DocIORenderer();
                //Converts Word document into PDF document
                //render.Settings.EmbedFonts = true;
                PdfDocument pdfDocument = render.ConvertToPDF(wordDocument);
                //Unhooks the font substitution event after converting to PDF
                wordDocument.FontSettings.SubstituteFont -= FontSettings_SubstituteFont;
                //Releases all resources used by the Word document and DocIO Renderer objects
                render.Dispose();
                wordDocument.Dispose();
                //Saves the PDF file
                FileStream dstStream = new FileStream("teco.pdf", FileMode.Create, FileAccess.ReadWrite);
                pdfDocument.Save(dstStream);
                //Closes the instance of PDF document object
                pdfDocument.Close();
            
           
        }

        private static void FontSettings_SubstituteFont(object sender, SubstituteFontEventArgs args)
        {
            //Sets the alternate font when a specified font is not installed in the production environment
            if (args.OriginalFontName == "Teko" && args.FontStyle == FontStyle.Regular)
            {
                args.AlternateFontStream = new FileStream(@"Includes\Teko-Regular.TTF", FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
            }
           
        }
    }
}
