﻿using Syncfusion.UI.Xaml.Charts;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows.Media;

namespace WpfCoreSfChartAnnotationIssue
{
    class ViewModel
    {
        public ViewModel()
        {
            Datasets = new ObservableCollection<Dataset>
            {
                new Dataset()
            };
        }
        public ObservableCollection<Dataset> Datasets { get; set; }

    }

    public class Dataset
    {
        public Dataset()
        {
            Data = new ObservableCollection<Price>()
            {
                new Price{ Date=new DateTime(2020,1,1), Value=100 },
                new Price{ Date=new DateTime(2020,1,2), Value=120 },
                new Price{ Date=new DateTime(2020,1,3), Value=90 },
            };

            Annotations = new AnnotationCollection
            {
                new LineAnnotation
                {
                    X1 = Data[0].Date.ToOADate(),
                    Y1 = Data[0].Value,
                    X2 = Data[2].Date.ToOADate(),
                    Y2 = Data[2].Value,
                    Stroke = new  SolidColorBrush(Colors.Red),
                    StrokeThickness = 4
                }
            };
        }
        public ObservableCollection<Price> Data { get; set; }
        public AnnotationCollection Annotations { get; set; }
    }

    public class Price
    {
        public double Value { get; set; }
        public DateTime Date { get; set; }
    }
}